// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_page_selector/cr_page_selector.js';
import '//resources/cr_elements/cr_tabs/cr_tabs.js';
import './trace_report_list.js';
import './tracing_scenarios_config.js';
import './trace_recorder.js';
import { CrRouter } from '//resources/js/cr_router.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { getCss } from './app.css.js';
import { getHtml } from './app.html.js';
export class TracesAppElement extends CrLitElement {
    static get is() {
        return 'traces-app';
    }
    render() {
        return getHtml.bind(this)();
    }
    static get styles() {
        return getCss();
    }
    static get properties() {
        return {
            // The index of the currently selected page.
            selected_: { type: Number },
            tabNames_: { type: Array },
        };
    }
    tabs = [
        {
            name: 'Reports',
            path: '',
        },
        {
            name: 'Scenarios',
            path: 'scenarios',
        },
        {
            name: 'Recorder',
            path: 'recorder',
        },
    ];
    #selected__accessor_storage = 0;
    get selected_() { return this.#selected__accessor_storage; }
    set selected_(value) { this.#selected__accessor_storage = value; }
    #tabNames__accessor_storage = this.tabs.map(tab => tab.name);
    get tabNames_() { return this.#tabNames__accessor_storage; }
    set tabNames_(value) { this.#tabNames__accessor_storage = value; }
    firstUpdated() {
        const router = CrRouter.getInstance();
        this.pathChanged_(router.getPath());
        router.addEventListener('cr-router-path-changed', (e) => this.pathChanged_(e.detail));
    }
    /** Updates the location hash on selection change. */
    onSelectedChanged_(e) {
        if (e === undefined || e.detail.value === this.selected_) {
            return;
        }
        this.selected_ = e.detail.value;
        const newTab = this.tabs[this.selected_];
        if (newTab === undefined) {
            return;
        }
        const tabPath = newTab.path;
        CrRouter.getInstance().setPath(`/${tabPath}`);
    }
    /**
     * Returns the index of the currently selected tab corresponding to the
     * path or zero if no match.
     */
    selectedFromPath_(path) {
        const index = this.tabs.findIndex(tab => path === tab.path);
        return Math.max(index, 0);
    }
    /** Updates the selection property on path change. */
    pathChanged_(newValue, _oldValue) {
        this.selected_ = this.selectedFromPath_(newValue.substr(1));
    }
}
customElements.define(TracesAppElement.is, TracesAppElement);
