// content/browser/xr/webxr_internals/mojom/webxr_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { XRDeviceIdSpec as device_mojom_XRDeviceIdSpec } from './xr_device.mojom-webui.js';
import { RequestSessionErrorSpec as device_mojom_RequestSessionErrorSpec, XRSessionFeatureSpec as device_mojom_XRSessionFeatureSpec, XRSessionOptionsSpec as device_mojom_XRSessionOptionsSpec, XrFrameStatisticsSpec as device_mojom_XrFrameStatisticsSpec, XrLogMessageSpec as device_mojom_XrLogMessageSpec } from './xr_session.mojom-webui.js';
import { TimeSpec as mojoBase_mojom_TimeSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
export class WebXrInternalsHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'webxr.mojom.WebXrInternalsHandler', scope);
    }
}
export class WebXrInternalsHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(WebXrInternalsHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getDeviceInfo() {
        return this.proxy.sendMessage(0, WebXrInternalsHandler_GetDeviceInfo_ParamsSpec.$, WebXrInternalsHandler_GetDeviceInfo_ResponseParamsSpec.$, [], false);
    }
    getActiveRuntimes() {
        return this.proxy.sendMessage(1, WebXrInternalsHandler_GetActiveRuntimes_ParamsSpec.$, WebXrInternalsHandler_GetActiveRuntimes_ResponseParamsSpec.$, [], false);
    }
    subscribeToEvents(listener) {
        this.proxy.sendMessage(2, WebXrInternalsHandler_SubscribeToEvents_ParamsSpec.$, null, [
            listener
        ], false);
    }
}
;
/**
 * An object which receives request messages for the WebXrInternalsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebXrInternalsHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WebXrInternalsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, WebXrInternalsHandler_GetDeviceInfo_ParamsSpec.$, WebXrInternalsHandler_GetDeviceInfo_ResponseParamsSpec.$, impl.getDeviceInfo.bind(impl), false);
        this.helper_internal_.registerHandler(1, WebXrInternalsHandler_GetActiveRuntimes_ParamsSpec.$, WebXrInternalsHandler_GetActiveRuntimes_ResponseParamsSpec.$, impl.getActiveRuntimes.bind(impl), false);
        this.helper_internal_.registerHandler(2, WebXrInternalsHandler_SubscribeToEvents_ParamsSpec.$, null, impl.subscribeToEvents.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class WebXrInternalsHandler {
    static get $interfaceName() {
        return "webxr.mojom.WebXrInternalsHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new WebXrInternalsHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the WebXrInternalsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebXrInternalsHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getDeviceInfo;
    getActiveRuntimes;
    subscribeToEvents;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WebXrInternalsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getDeviceInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, WebXrInternalsHandler_GetDeviceInfo_ParamsSpec.$, WebXrInternalsHandler_GetDeviceInfo_ResponseParamsSpec.$, this.getDeviceInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.getActiveRuntimes =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, WebXrInternalsHandler_GetActiveRuntimes_ParamsSpec.$, WebXrInternalsHandler_GetActiveRuntimes_ResponseParamsSpec.$, this.getActiveRuntimes.createReceiverHandler(true /* expectsResponse */), false);
        this.subscribeToEvents =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, WebXrInternalsHandler_SubscribeToEvents_ParamsSpec.$, null, this.subscribeToEvents.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class XRInternalsSessionListenerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'webxr.mojom.XRInternalsSessionListener', scope);
    }
}
export class XRInternalsSessionListenerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(XRInternalsSessionListenerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    logXrSessionRequested(sessionRequestedRecord) {
        this.proxy.sendMessage(0, XRInternalsSessionListener_LogXrSessionRequested_ParamsSpec.$, null, [
            sessionRequestedRecord
        ], false);
    }
    logXrSessionRejected(sessionRejectedRecord) {
        this.proxy.sendMessage(1, XRInternalsSessionListener_LogXrSessionRejected_ParamsSpec.$, null, [
            sessionRejectedRecord
        ], false);
    }
    logXrSessionStarted(sessionStartedRecord) {
        this.proxy.sendMessage(2, XRInternalsSessionListener_LogXrSessionStarted_ParamsSpec.$, null, [
            sessionStartedRecord
        ], false);
    }
    logXrSessionStopped(sessionStoppedRecord) {
        this.proxy.sendMessage(3, XRInternalsSessionListener_LogXrSessionStopped_ParamsSpec.$, null, [
            sessionStoppedRecord
        ], false);
    }
    logXrRuntimeAdded(runtimeAddedRecord) {
        this.proxy.sendMessage(4, XRInternalsSessionListener_LogXrRuntimeAdded_ParamsSpec.$, null, [
            runtimeAddedRecord
        ], false);
    }
    logXrRuntimeRemoved(deviceId) {
        this.proxy.sendMessage(5, XRInternalsSessionListener_LogXrRuntimeRemoved_ParamsSpec.$, null, [
            deviceId
        ], false);
    }
    logFrameData(xrframeStatistics) {
        this.proxy.sendMessage(6, XRInternalsSessionListener_LogFrameData_ParamsSpec.$, null, [
            xrframeStatistics
        ], false);
    }
    logConsoleMessages(xrloggingStatistics) {
        this.proxy.sendMessage(7, XRInternalsSessionListener_LogConsoleMessages_ParamsSpec.$, null, [
            xrloggingStatistics
        ], false);
    }
}
;
/**
 * An object which receives request messages for the XRInternalsSessionListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class XRInternalsSessionListenerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(XRInternalsSessionListenerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, XRInternalsSessionListener_LogXrSessionRequested_ParamsSpec.$, null, impl.logXrSessionRequested.bind(impl), false);
        this.helper_internal_.registerHandler(1, XRInternalsSessionListener_LogXrSessionRejected_ParamsSpec.$, null, impl.logXrSessionRejected.bind(impl), false);
        this.helper_internal_.registerHandler(2, XRInternalsSessionListener_LogXrSessionStarted_ParamsSpec.$, null, impl.logXrSessionStarted.bind(impl), false);
        this.helper_internal_.registerHandler(3, XRInternalsSessionListener_LogXrSessionStopped_ParamsSpec.$, null, impl.logXrSessionStopped.bind(impl), false);
        this.helper_internal_.registerHandler(4, XRInternalsSessionListener_LogXrRuntimeAdded_ParamsSpec.$, null, impl.logXrRuntimeAdded.bind(impl), false);
        this.helper_internal_.registerHandler(5, XRInternalsSessionListener_LogXrRuntimeRemoved_ParamsSpec.$, null, impl.logXrRuntimeRemoved.bind(impl), false);
        this.helper_internal_.registerHandler(6, XRInternalsSessionListener_LogFrameData_ParamsSpec.$, null, impl.logFrameData.bind(impl), false);
        this.helper_internal_.registerHandler(7, XRInternalsSessionListener_LogConsoleMessages_ParamsSpec.$, null, impl.logConsoleMessages.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class XRInternalsSessionListener {
    static get $interfaceName() {
        return "webxr.mojom.XRInternalsSessionListener";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new XRInternalsSessionListenerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the XRInternalsSessionListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class XRInternalsSessionListenerCallbackRouter {
    helper_internal_;
    $;
    router_;
    logXrSessionRequested;
    logXrSessionRejected;
    logXrSessionStarted;
    logXrSessionStopped;
    logXrRuntimeAdded;
    logXrRuntimeRemoved;
    logFrameData;
    logConsoleMessages;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(XRInternalsSessionListenerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.logXrSessionRequested =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, XRInternalsSessionListener_LogXrSessionRequested_ParamsSpec.$, null, this.logXrSessionRequested.createReceiverHandler(false /* expectsResponse */), false);
        this.logXrSessionRejected =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, XRInternalsSessionListener_LogXrSessionRejected_ParamsSpec.$, null, this.logXrSessionRejected.createReceiverHandler(false /* expectsResponse */), false);
        this.logXrSessionStarted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, XRInternalsSessionListener_LogXrSessionStarted_ParamsSpec.$, null, this.logXrSessionStarted.createReceiverHandler(false /* expectsResponse */), false);
        this.logXrSessionStopped =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, XRInternalsSessionListener_LogXrSessionStopped_ParamsSpec.$, null, this.logXrSessionStopped.createReceiverHandler(false /* expectsResponse */), false);
        this.logXrRuntimeAdded =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, XRInternalsSessionListener_LogXrRuntimeAdded_ParamsSpec.$, null, this.logXrRuntimeAdded.createReceiverHandler(false /* expectsResponse */), false);
        this.logXrRuntimeRemoved =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, XRInternalsSessionListener_LogXrRuntimeRemoved_ParamsSpec.$, null, this.logXrRuntimeRemoved.createReceiverHandler(false /* expectsResponse */), false);
        this.logFrameData =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, XRInternalsSessionListener_LogFrameData_ParamsSpec.$, null, this.logFrameData.createReceiverHandler(false /* expectsResponse */), false);
        this.logConsoleMessages =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, XRInternalsSessionListener_LogConsoleMessages_ParamsSpec.$, null, this.logConsoleMessages.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const DeviceInfoSpec = { $: {} };
export const SessionRequestedRecordSpec = { $: {} };
export const SessionRejectedRecordSpec = { $: {} };
export const SessionStartedRecordSpec = { $: {} };
export const SessionStoppedRecordSpec = { $: {} };
export const RuntimeInfoSpec = { $: {} };
export const WebXrInternalsHandler_GetDeviceInfo_ParamsSpec = { $: {} };
export const WebXrInternalsHandler_GetDeviceInfo_ResponseParamsSpec = { $: {} };
export const WebXrInternalsHandler_GetActiveRuntimes_ParamsSpec = { $: {} };
export const WebXrInternalsHandler_GetActiveRuntimes_ResponseParamsSpec = { $: {} };
export const WebXrInternalsHandler_SubscribeToEvents_ParamsSpec = { $: {} };
export const XRInternalsSessionListener_LogXrSessionRequested_ParamsSpec = { $: {} };
export const XRInternalsSessionListener_LogXrSessionRejected_ParamsSpec = { $: {} };
export const XRInternalsSessionListener_LogXrSessionStarted_ParamsSpec = { $: {} };
export const XRInternalsSessionListener_LogXrSessionStopped_ParamsSpec = { $: {} };
export const XRInternalsSessionListener_LogXrRuntimeAdded_ParamsSpec = { $: {} };
export const XRInternalsSessionListener_LogXrRuntimeRemoved_ParamsSpec = { $: {} };
export const XRInternalsSessionListener_LogFrameData_ParamsSpec = { $: {} };
export const XRInternalsSessionListener_LogConsoleMessages_ParamsSpec = { $: {} };
mojo.internal.Struct(DeviceInfoSpec.$, 'DeviceInfo', [
    mojo.internal.StructField('operatingSystemName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('operatingSystemVersion', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('gpuGlVendor', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('gpuGlRenderer', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(SessionRequestedRecordSpec.$, 'SessionRequestedRecord', [
    mojo.internal.StructField('options', 0, 0, device_mojom_XRSessionOptionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('requestedTime', 8, 0, mojoBase_mojom_TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(SessionRejectedRecordSpec.$, 'SessionRejectedRecord', [
    mojo.internal.StructField('traceId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('failureReason', 8, 0, device_mojom_RequestSessionErrorSpec.$, 1, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('rejectedTime', 16, 0, mojoBase_mojom_TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('failureReasonDescription', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('rejectedFeatures', 32, 0, mojo.internal.Array(device_mojom_XRSessionFeatureSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(SessionStartedRecordSpec.$, 'SessionStartedRecord', [
    mojo.internal.StructField('traceId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceId', 8, 0, device_mojom_XRDeviceIdSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('startedTime', 16, 0, mojoBase_mojom_TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(SessionStoppedRecordSpec.$, 'SessionStoppedRecord', [
    mojo.internal.StructField('traceId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('stoppedTime', 8, 0, mojoBase_mojom_TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(RuntimeInfoSpec.$, 'RuntimeInfo', [
    mojo.internal.StructField('deviceId', 0, 0, device_mojom_XRDeviceIdSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('supportedFeatures', 8, 0, mojo.internal.Array(device_mojom_XRSessionFeatureSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isArBlendModeSupported', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebXrInternalsHandler_GetDeviceInfo_ParamsSpec.$, 'WebXrInternalsHandler_GetDeviceInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(WebXrInternalsHandler_GetDeviceInfo_ResponseParamsSpec.$, 'WebXrInternalsHandler_GetDeviceInfo_ResponseParams', [
    mojo.internal.StructField('deviceInfo', 0, 0, DeviceInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebXrInternalsHandler_GetActiveRuntimes_ParamsSpec.$, 'WebXrInternalsHandler_GetActiveRuntimes_Params', [], [[0, 8],]);
mojo.internal.Struct(WebXrInternalsHandler_GetActiveRuntimes_ResponseParamsSpec.$, 'WebXrInternalsHandler_GetActiveRuntimes_ResponseParams', [
    mojo.internal.StructField('activeRuntimes', 0, 0, mojo.internal.Array(RuntimeInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebXrInternalsHandler_SubscribeToEvents_ParamsSpec.$, 'WebXrInternalsHandler_SubscribeToEvents_Params', [
    mojo.internal.StructField('listener', 0, 0, mojo.internal.InterfaceProxy(XRInternalsSessionListenerRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(XRInternalsSessionListener_LogXrSessionRequested_ParamsSpec.$, 'XRInternalsSessionListener_LogXrSessionRequested_Params', [
    mojo.internal.StructField('sessionRequestedRecord', 0, 0, SessionRequestedRecordSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(XRInternalsSessionListener_LogXrSessionRejected_ParamsSpec.$, 'XRInternalsSessionListener_LogXrSessionRejected_Params', [
    mojo.internal.StructField('sessionRejectedRecord', 0, 0, SessionRejectedRecordSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(XRInternalsSessionListener_LogXrSessionStarted_ParamsSpec.$, 'XRInternalsSessionListener_LogXrSessionStarted_Params', [
    mojo.internal.StructField('sessionStartedRecord', 0, 0, SessionStartedRecordSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(XRInternalsSessionListener_LogXrSessionStopped_ParamsSpec.$, 'XRInternalsSessionListener_LogXrSessionStopped_Params', [
    mojo.internal.StructField('sessionStoppedRecord', 0, 0, SessionStoppedRecordSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(XRInternalsSessionListener_LogXrRuntimeAdded_ParamsSpec.$, 'XRInternalsSessionListener_LogXrRuntimeAdded_Params', [
    mojo.internal.StructField('runtimeAddedRecord', 0, 0, RuntimeInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(XRInternalsSessionListener_LogXrRuntimeRemoved_ParamsSpec.$, 'XRInternalsSessionListener_LogXrRuntimeRemoved_Params', [
    mojo.internal.StructField('deviceId', 0, 0, device_mojom_XRDeviceIdSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(XRInternalsSessionListener_LogFrameData_ParamsSpec.$, 'XRInternalsSessionListener_LogFrameData_Params', [
    mojo.internal.StructField('xrframeStatistics', 0, 0, device_mojom_XrFrameStatisticsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(XRInternalsSessionListener_LogConsoleMessages_ParamsSpec.$, 'XRInternalsSessionListener_LogConsoleMessages_Params', [
    mojo.internal.StructField('xrloggingStatistics', 0, 0, device_mojom_XrLogMessageSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
