// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{$}from"chrome://resources/js/util.js";const USER_MEDIA_TAB_ID="user-media-tab-id";function appendChildWithText(parent,tag,text){const child=document.createElement(tag);child.textContent=text;parent.appendChild(child);return child}export class UserMediaTable{constructor(tabView){this.tabView=tabView}createTab(){const container=this.tabView.addTab(USER_MEDIA_TAB_ID,"getUserMedia/getDisplayMedia");appendChildWithText(container,"label","Filter by origin including ");const input=document.createElement("input");input.size=30;input.oninput=this.filterUserMedia.bind(this);container.appendChild(input)}filterUserMedia(event){const filter=event.target.value;const requests=$(USER_MEDIA_TAB_ID).childNodes;for(let i=0;i<requests.length;++i){if(!requests[i]["data-origin"]){continue}if(requests[i]["data-origin"].includes(filter)){requests[i].style.display="block"}else{requests[i].style.display="none"}}}addMedia(data){if(!$(USER_MEDIA_TAB_ID)){this.createTab()}const requestDiv=document.createElement("div");requestDiv.className="user-media-request-div-class";requestDiv.id=["gum",data.rid,data.pid,data.request_id].join("-");requestDiv["data-rid"]=data.rid;requestDiv["data-origin"]=data.origin;$(USER_MEDIA_TAB_ID).insertBefore(requestDiv,$(USER_MEDIA_TAB_ID).firstChild);appendChildWithText(requestDiv,"div","Caller origin: "+data.origin);appendChildWithText(requestDiv,"div","Caller process id: "+data.pid);const el=appendChildWithText(requestDiv,"span",data.request_type+" call");el.style.fontWeight="bold";appendChildWithText(el,"div","Time: "+new Date(data.timestamp).toTimeString()).style.fontWeight="normal";if(data.audio!==undefined){appendChildWithText(el,"div","Audio constraints: "+(data.audio||"true")).style.fontWeight="normal"}if(data.video!==undefined){appendChildWithText(el,"div","Video constraints: "+(data.video||"true")).style.fontWeight="normal"}}updateMedia(data){if(!$(USER_MEDIA_TAB_ID)){this.createTab()}const requestDiv=document.getElementById(["gum",data.rid,data.pid,data.request_id].join("-"));if(!requestDiv){console.error("Could not update "+data.request_type+" request",data);return}if(data.error){const el=appendChildWithText(requestDiv,"span","Error");el.style.fontWeight="bold";appendChildWithText(el,"div","Time: "+new Date(data.timestamp).toTimeString()).style.fontWeight="normal";appendChildWithText(el,"div","Error: "+data.error).style.fontWeight="normal";appendChildWithText(el,"div","Error message: "+data.error_message).style.fontWeight="normal";return}const el=appendChildWithText(requestDiv,"span",data.request_type+" result");el.style.fontWeight="bold";appendChildWithText(el,"div","Time: "+new Date(data.timestamp).toTimeString()).style.fontWeight="normal";appendChildWithText(el,"div","Stream id: "+data.stream_id).style.fontWeight="normal";const audio=JSON.parse(data.audio_track_info);if(audio){appendChildWithText(el,"div",["Audio track:","id="+audio.id,"label:"+audio.label].join(" ")).style.fontWeight="normal"}const video=JSON.parse(data.video_track_info);if(video){appendChildWithText(el,"div",["Video track:","id="+video.id,"label:"+video.label].join(" ")).style.fontWeight="normal"}}removeMediaForRenderer(data){const requests=$(USER_MEDIA_TAB_ID).childNodes;for(let i=0;i<requests.length;++i){if(!requests[i]["data-origin"]){continue}if(requests[i]["data-rid"]===data.rid){$(USER_MEDIA_TAB_ID).removeChild(requests[i])}}if($(USER_MEDIA_TAB_ID).childNodes.length===2){this.tabView.removeTab(USER_MEDIA_TAB_ID)}}}