// content/test/data/web_ui_ts_test_types.test-mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export class StringWrapperPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'content.mojom.StringWrapper', scope);
    }
}
export class StringWrapperRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(StringWrapperPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    putString(item) {
        this.proxy.sendMessage(0, StringWrapper_PutString_ParamsSpec.$, null, [
            item
        ], false);
    }
    getString() {
        return this.proxy.sendMessage(1, StringWrapper_GetString_ParamsSpec.$, StringWrapper_GetString_ResponseParamsSpec.$, [], false);
    }
    clone(stringWrapperClone) {
        this.proxy.sendMessage(2, StringWrapper_Clone_ParamsSpec.$, null, [
            stringWrapperClone
        ], false);
    }
}
;
/**
 * An object which receives request messages for the StringWrapper
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class StringWrapperReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(StringWrapperRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, StringWrapper_PutString_ParamsSpec.$, null, impl.putString.bind(impl), false);
        this.helper_internal_.registerHandler(1, StringWrapper_GetString_ParamsSpec.$, StringWrapper_GetString_ResponseParamsSpec.$, impl.getString.bind(impl), false);
        this.helper_internal_.registerHandler(2, StringWrapper_Clone_ParamsSpec.$, null, impl.clone.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class StringWrapper {
    static get $interfaceName() {
        return "content.mojom.StringWrapper";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new StringWrapperRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the StringWrapper
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class StringWrapperCallbackRouter {
    helper_internal_;
    $;
    router_;
    putString;
    getString;
    clone;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(StringWrapperRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.putString =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, StringWrapper_PutString_ParamsSpec.$, null, this.putString.createReceiverHandler(false /* expectsResponse */), false);
        this.getString =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, StringWrapper_GetString_ParamsSpec.$, StringWrapper_GetString_ResponseParamsSpec.$, this.getString.createReceiverHandler(true /* expectsResponse */), false);
        this.clone =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, StringWrapper_Clone_ParamsSpec.$, null, this.clone.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const TsCacheItemSpec = { $: {} };
export const StringWrapper_PutString_ParamsSpec = { $: {} };
export const StringWrapper_GetString_ParamsSpec = { $: {} };
export const StringWrapper_GetString_ResponseParamsSpec = { $: {} };
export const StringWrapper_Clone_ParamsSpec = { $: {} };
mojo.internal.Struct(TsCacheItemSpec.$, 'TsCacheItem', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('contents', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(StringWrapper_PutString_ParamsSpec.$, 'StringWrapper_PutString_Params', [
    mojo.internal.StructField('item', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(StringWrapper_GetString_ParamsSpec.$, 'StringWrapper_GetString_Params', [], [[0, 8],]);
mojo.internal.Struct(StringWrapper_GetString_ResponseParamsSpec.$, 'StringWrapper_GetString_ResponseParams', [
    mojo.internal.StructField('item', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(StringWrapper_Clone_ParamsSpec.$, 'StringWrapper_Clone_Params', [
    mojo.internal.StructField('stringWrapperClone', 0, 0, mojo.internal.InterfaceRequest(StringWrapperPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
