// content/web_test/common/fake_bluetooth_chooser.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'content/web_test/common/fake_bluetooth_chooser.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('content.mojom');
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../url/mojom/origin.mojom.js');
  }


  var ChooserEventType = {};
  ChooserEventType.CHOOSER_OPENED = 0;
  ChooserEventType.CHOOSER_CLOSED = 1;
  ChooserEventType.ADAPTER_REMOVED = 2;
  ChooserEventType.ADAPTER_DISABLED = 3;
  ChooserEventType.ADAPTER_ENABLED = 4;
  ChooserEventType.DISCOVERY_FAILED_TO_START = 5;
  ChooserEventType.DISCOVERING = 6;
  ChooserEventType.DISCOVERY_IDLE = 7;
  ChooserEventType.ADD_OR_UPDATE_DEVICE = 8;
  ChooserEventType.UNAUTHORIZED = 9;
  ChooserEventType.MIN_VALUE = 0;
  ChooserEventType.MAX_VALUE = 9;

  ChooserEventType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
      return true;
    }
    return false;
  };

  ChooserEventType.toKnownEnumValue = function(value) {
    return value;
  };

  ChooserEventType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function FakeBluetoothChooserEvent(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FakeBluetoothChooserEvent.prototype.initDefaults_ = function() {
    this.type = 0;
    this.origin = null;
    this.peripheralAddress = null;
  };
  FakeBluetoothChooserEvent.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FakeBluetoothChooserEvent.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FakeBluetoothChooserEvent.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ChooserEventType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FakeBluetoothChooserEvent.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FakeBluetoothChooserEvent.peripheralAddress
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FakeBluetoothChooserEvent.encodedSize = codec.kStructHeaderSize + 24;

  FakeBluetoothChooserEvent.decode = function(decoder) {
    var packed;
    var val = new FakeBluetoothChooserEvent();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(ChooserEventType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    val.peripheralAddress =
        decoder.decodeStruct(codec.String);
    return val;
  };

  FakeBluetoothChooserEvent.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FakeBluetoothChooserEvent.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    encoder.encodeStruct(codec.String, val.peripheralAddress);
  };
  function FakeBluetoothChooser_SelectPeripheral_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FakeBluetoothChooser_SelectPeripheral_Params.prototype.initDefaults_ = function() {
    this.peripheralAddress = null;
  };
  FakeBluetoothChooser_SelectPeripheral_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FakeBluetoothChooser_SelectPeripheral_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FakeBluetoothChooser_SelectPeripheral_Params.peripheralAddress
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FakeBluetoothChooser_SelectPeripheral_Params.encodedSize = codec.kStructHeaderSize + 8;

  FakeBluetoothChooser_SelectPeripheral_Params.decode = function(decoder) {
    var packed;
    var val = new FakeBluetoothChooser_SelectPeripheral_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.peripheralAddress =
        decoder.decodeStruct(codec.String);
    return val;
  };

  FakeBluetoothChooser_SelectPeripheral_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FakeBluetoothChooser_SelectPeripheral_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.peripheralAddress);
  };
  function FakeBluetoothChooser_Cancel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FakeBluetoothChooser_Cancel_Params.prototype.initDefaults_ = function() {
  };
  FakeBluetoothChooser_Cancel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FakeBluetoothChooser_Cancel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FakeBluetoothChooser_Cancel_Params.encodedSize = codec.kStructHeaderSize + 0;

  FakeBluetoothChooser_Cancel_Params.decode = function(decoder) {
    var packed;
    var val = new FakeBluetoothChooser_Cancel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FakeBluetoothChooser_Cancel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FakeBluetoothChooser_Cancel_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FakeBluetoothChooser_Rescan_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FakeBluetoothChooser_Rescan_Params.prototype.initDefaults_ = function() {
  };
  FakeBluetoothChooser_Rescan_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FakeBluetoothChooser_Rescan_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FakeBluetoothChooser_Rescan_Params.encodedSize = codec.kStructHeaderSize + 0;

  FakeBluetoothChooser_Rescan_Params.decode = function(decoder) {
    var packed;
    var val = new FakeBluetoothChooser_Rescan_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FakeBluetoothChooser_Rescan_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FakeBluetoothChooser_Rescan_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params.prototype.initDefaults_ = function() {
    this.fakeChooser = new bindings.InterfaceRequest();
    this.client = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params.fakeChooser
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params.client
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params.encodedSize = codec.kStructHeaderSize + 16;

  FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params.decode = function(decoder) {
    var packed;
    var val = new FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.fakeChooser =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.client =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.fakeChooser);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.client);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams.prototype.initDefaults_ = function() {
  };
  FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function FakeBluetoothChooserClient_OnEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FakeBluetoothChooserClient_OnEvent_Params.prototype.initDefaults_ = function() {
    this.event = null;
  };
  FakeBluetoothChooserClient_OnEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FakeBluetoothChooserClient_OnEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FakeBluetoothChooserClient_OnEvent_Params.event
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, FakeBluetoothChooserEvent, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FakeBluetoothChooserClient_OnEvent_Params.encodedSize = codec.kStructHeaderSize + 8;

  FakeBluetoothChooserClient_OnEvent_Params.decode = function(decoder) {
    var packed;
    var val = new FakeBluetoothChooserClient_OnEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.event =
        decoder.decodeStructPointer(FakeBluetoothChooserEvent);
    return val;
  };

  FakeBluetoothChooserClient_OnEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FakeBluetoothChooserClient_OnEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(FakeBluetoothChooserEvent, val.event);
  };
  var kFakeBluetoothChooser_SelectPeripheral_Name = 0;
  var kFakeBluetoothChooser_Cancel_Name = 1;
  var kFakeBluetoothChooser_Rescan_Name = 2;

  function FakeBluetoothChooserPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FakeBluetoothChooser,
                                                   handleOrPtrInfo);
  }

  function FakeBluetoothChooserAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FakeBluetoothChooser, associatedInterfacePtrInfo);
  }

  FakeBluetoothChooserAssociatedPtr.prototype =
      Object.create(FakeBluetoothChooserPtr.prototype);
  FakeBluetoothChooserAssociatedPtr.prototype.constructor =
      FakeBluetoothChooserAssociatedPtr;

  function FakeBluetoothChooserProxy(receiver) {
    this.receiver_ = receiver;
  }
  FakeBluetoothChooserPtr.prototype.selectPeripheral = function() {
    return FakeBluetoothChooserProxy.prototype.selectPeripheral
        .apply(this.ptr.getProxy(), arguments);
  };

  FakeBluetoothChooserProxy.prototype.selectPeripheral = function(peripheralAddress) {
    var params_ = new FakeBluetoothChooser_SelectPeripheral_Params();
    params_.peripheralAddress = peripheralAddress;
    var builder = new codec.MessageV0Builder(
        kFakeBluetoothChooser_SelectPeripheral_Name,
        codec.align(FakeBluetoothChooser_SelectPeripheral_Params.encodedSize));
    builder.encodeStruct(FakeBluetoothChooser_SelectPeripheral_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FakeBluetoothChooserPtr.prototype.cancel = function() {
    return FakeBluetoothChooserProxy.prototype.cancel
        .apply(this.ptr.getProxy(), arguments);
  };

  FakeBluetoothChooserProxy.prototype.cancel = function() {
    var params_ = new FakeBluetoothChooser_Cancel_Params();
    var builder = new codec.MessageV0Builder(
        kFakeBluetoothChooser_Cancel_Name,
        codec.align(FakeBluetoothChooser_Cancel_Params.encodedSize));
    builder.encodeStruct(FakeBluetoothChooser_Cancel_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FakeBluetoothChooserPtr.prototype.rescan = function() {
    return FakeBluetoothChooserProxy.prototype.rescan
        .apply(this.ptr.getProxy(), arguments);
  };

  FakeBluetoothChooserProxy.prototype.rescan = function() {
    var params_ = new FakeBluetoothChooser_Rescan_Params();
    var builder = new codec.MessageV0Builder(
        kFakeBluetoothChooser_Rescan_Name,
        codec.align(FakeBluetoothChooser_Rescan_Params.encodedSize));
    builder.encodeStruct(FakeBluetoothChooser_Rescan_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FakeBluetoothChooserStub(delegate) {
    this.delegate_ = delegate;
  }
  FakeBluetoothChooserStub.prototype.selectPeripheral = function(peripheralAddress) {
    return this.delegate_ && this.delegate_.selectPeripheral && this.delegate_.selectPeripheral(peripheralAddress);
  }
  FakeBluetoothChooserStub.prototype.cancel = function() {
    return this.delegate_ && this.delegate_.cancel && this.delegate_.cancel();
  }
  FakeBluetoothChooserStub.prototype.rescan = function() {
    return this.delegate_ && this.delegate_.rescan && this.delegate_.rescan();
  }

  FakeBluetoothChooserStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFakeBluetoothChooser_SelectPeripheral_Name:
      var params = reader.decodeStruct(FakeBluetoothChooser_SelectPeripheral_Params);
      this.selectPeripheral(params.peripheralAddress);
      return true;
    case kFakeBluetoothChooser_Cancel_Name:
      var params = reader.decodeStruct(FakeBluetoothChooser_Cancel_Params);
      this.cancel();
      return true;
    case kFakeBluetoothChooser_Rescan_Name:
      var params = reader.decodeStruct(FakeBluetoothChooser_Rescan_Params);
      this.rescan();
      return true;
    default:
      return false;
    }
  };

  FakeBluetoothChooserStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFakeBluetoothChooserRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFakeBluetoothChooser_SelectPeripheral_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FakeBluetoothChooser_SelectPeripheral_Params;
      break;
      case kFakeBluetoothChooser_Cancel_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FakeBluetoothChooser_Cancel_Params;
      break;
      case kFakeBluetoothChooser_Rescan_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FakeBluetoothChooser_Rescan_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFakeBluetoothChooserResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FakeBluetoothChooser = {
    name: 'content.mojom.FakeBluetoothChooser',
    kVersion: 0,
    ptrClass: FakeBluetoothChooserPtr,
    proxyClass: FakeBluetoothChooserProxy,
    stubClass: FakeBluetoothChooserStub,
    validateRequest: validateFakeBluetoothChooserRequest,
    validateResponse: null,
  };
  FakeBluetoothChooserStub.prototype.validator = validateFakeBluetoothChooserRequest;
  FakeBluetoothChooserProxy.prototype.validator = null;
  var kFakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Name = 0;

  function FakeBluetoothChooserFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FakeBluetoothChooserFactory,
                                                   handleOrPtrInfo);
  }

  function FakeBluetoothChooserFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FakeBluetoothChooserFactory, associatedInterfacePtrInfo);
  }

  FakeBluetoothChooserFactoryAssociatedPtr.prototype =
      Object.create(FakeBluetoothChooserFactoryPtr.prototype);
  FakeBluetoothChooserFactoryAssociatedPtr.prototype.constructor =
      FakeBluetoothChooserFactoryAssociatedPtr;

  function FakeBluetoothChooserFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  FakeBluetoothChooserFactoryPtr.prototype.createFakeBluetoothChooser = function() {
    return FakeBluetoothChooserFactoryProxy.prototype.createFakeBluetoothChooser
        .apply(this.ptr.getProxy(), arguments);
  };

  FakeBluetoothChooserFactoryProxy.prototype.createFakeBluetoothChooser = function(fakeChooser, client) {
    var params_ = new FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params();
    params_.fakeChooser = fakeChooser;
    params_.client = client;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kFakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Name,
          codec.align(FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function FakeBluetoothChooserFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  FakeBluetoothChooserFactoryStub.prototype.createFakeBluetoothChooser = function(fakeChooser, client) {
    return this.delegate_ && this.delegate_.createFakeBluetoothChooser && this.delegate_.createFakeBluetoothChooser(fakeChooser, client);
  }

  FakeBluetoothChooserFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  FakeBluetoothChooserFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Name:
      var params = reader.decodeStruct(FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params);
      this.createFakeBluetoothChooser(params.fakeChooser, params.client).then(function(response) {
        var responseParams =
            new FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams();
        var builder = new codec.MessageV2Builder(
            kFakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Name,
            codec.align(FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFakeBluetoothChooserFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Name:
        if (message.expectsResponse())
          paramsClass = FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFakeBluetoothChooserFactoryResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Name:
        if (message.isResponse())
          paramsClass = FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FakeBluetoothChooserFactory = {
    name: 'content.mojom.FakeBluetoothChooserFactory',
    kVersion: 0,
    ptrClass: FakeBluetoothChooserFactoryPtr,
    proxyClass: FakeBluetoothChooserFactoryProxy,
    stubClass: FakeBluetoothChooserFactoryStub,
    validateRequest: validateFakeBluetoothChooserFactoryRequest,
    validateResponse: validateFakeBluetoothChooserFactoryResponse,
  };
  FakeBluetoothChooserFactoryStub.prototype.validator = validateFakeBluetoothChooserFactoryRequest;
  FakeBluetoothChooserFactoryProxy.prototype.validator = validateFakeBluetoothChooserFactoryResponse;
  var kFakeBluetoothChooserClient_OnEvent_Name = 0;

  function FakeBluetoothChooserClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FakeBluetoothChooserClient,
                                                   handleOrPtrInfo);
  }

  function FakeBluetoothChooserClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FakeBluetoothChooserClient, associatedInterfacePtrInfo);
  }

  FakeBluetoothChooserClientAssociatedPtr.prototype =
      Object.create(FakeBluetoothChooserClientPtr.prototype);
  FakeBluetoothChooserClientAssociatedPtr.prototype.constructor =
      FakeBluetoothChooserClientAssociatedPtr;

  function FakeBluetoothChooserClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  FakeBluetoothChooserClientPtr.prototype.onEvent = function() {
    return FakeBluetoothChooserClientProxy.prototype.onEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  FakeBluetoothChooserClientProxy.prototype.onEvent = function(event) {
    var params_ = new FakeBluetoothChooserClient_OnEvent_Params();
    params_.event = event;
    var builder = new codec.MessageV0Builder(
        kFakeBluetoothChooserClient_OnEvent_Name,
        codec.align(FakeBluetoothChooserClient_OnEvent_Params.encodedSize));
    builder.encodeStruct(FakeBluetoothChooserClient_OnEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FakeBluetoothChooserClientStub(delegate) {
    this.delegate_ = delegate;
  }
  FakeBluetoothChooserClientStub.prototype.onEvent = function(event) {
    return this.delegate_ && this.delegate_.onEvent && this.delegate_.onEvent(event);
  }

  FakeBluetoothChooserClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFakeBluetoothChooserClient_OnEvent_Name:
      var params = reader.decodeStruct(FakeBluetoothChooserClient_OnEvent_Params);
      this.onEvent(params.event);
      return true;
    default:
      return false;
    }
  };

  FakeBluetoothChooserClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFakeBluetoothChooserClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFakeBluetoothChooserClient_OnEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FakeBluetoothChooserClient_OnEvent_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFakeBluetoothChooserClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FakeBluetoothChooserClient = {
    name: 'content.mojom.FakeBluetoothChooserClient',
    kVersion: 0,
    ptrClass: FakeBluetoothChooserClientPtr,
    proxyClass: FakeBluetoothChooserClientProxy,
    stubClass: FakeBluetoothChooserClientStub,
    validateRequest: validateFakeBluetoothChooserClientRequest,
    validateResponse: null,
  };
  FakeBluetoothChooserClientStub.prototype.validator = validateFakeBluetoothChooserClientRequest;
  FakeBluetoothChooserClientProxy.prototype.validator = null;
  exports.ChooserEventType = ChooserEventType;
  exports.FakeBluetoothChooserEvent = FakeBluetoothChooserEvent;
  exports.FakeBluetoothChooser = FakeBluetoothChooser;
  exports.FakeBluetoothChooserPtr = FakeBluetoothChooserPtr;
  exports.FakeBluetoothChooserAssociatedPtr = FakeBluetoothChooserAssociatedPtr;
  exports.FakeBluetoothChooserFactory = FakeBluetoothChooserFactory;
  exports.FakeBluetoothChooserFactoryPtr = FakeBluetoothChooserFactoryPtr;
  exports.FakeBluetoothChooserFactoryAssociatedPtr = FakeBluetoothChooserFactoryAssociatedPtr;
  exports.FakeBluetoothChooserClient = FakeBluetoothChooserClient;
  exports.FakeBluetoothChooserClientPtr = FakeBluetoothChooserClientPtr;
  exports.FakeBluetoothChooserClientAssociatedPtr = FakeBluetoothChooserClientAssociatedPtr;
})();