// content/web_test/common/mojo_echo.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MojoEchoPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'content.mojom.MojoEcho', scope);
  }
}

/** @interface */
export class MojoEchoInterface {
  
  /**
   * @param { !TestUnion } testUnion
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  echoBoolFromUnion(testUnion) {}
  
  /**
   * @param { !TestUnion } testUnion
   * @return {!Promise<{
        value: !number,
   *  }>}
   */

  echoInt32FromUnion(testUnion) {}
  
  /**
   * @param { !TestUnion } testUnion
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  echoStringFromUnion(testUnion) {}
  
  /**
   * @param { !boolean } value
   * @return {!Promise<{
        testUnion: !TestUnion,
   *  }>}
   */

  echoBoolAsUnion(value) {}
  
  /**
   * @param { !number } value
   * @return {!Promise<{
        testUnion: !TestUnion,
   *  }>}
   */

  echoInt32AsUnion(value) {}
  
  /**
   * @param { !string } value
   * @return {!Promise<{
        testUnion: !TestUnion,
   *  }>}
   */

  echoStringAsUnion(value) {}
  
  /**
   * @param { ?TestUnion } testUnion
   * @return {!Promise}
   */

  echoNullFromOptionalUnion(testUnion) {}
  
  /**
   * @param { ?TestUnion } testUnion
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  echoBoolFromOptionalUnion(testUnion) {}
  
  /**
   * @param { ?TestUnion } testUnion
   * @return {!Promise<{
        value: !number,
   *  }>}
   */

  echoInt32FromOptionalUnion(testUnion) {}
  
  /**
   * @param { ?TestUnion } testUnion
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  echoStringFromOptionalUnion(testUnion) {}
  
  /**
   * @return {!Promise<{
        testUnion: ?TestUnion,
   *  }>}
   */

  echoNullAsOptionalUnion() {}
  
  /**
   * @param { !boolean } value
   * @return {!Promise<{
        testUnion: ?TestUnion,
   *  }>}
   */

  echoBoolAsOptionalUnion(value) {}
  
  /**
   * @param { !number } value
   * @return {!Promise<{
        testUnion: ?TestUnion,
   *  }>}
   */

  echoInt32AsOptionalUnion(value) {}
  
  /**
   * @param { !string } value
   * @return {!Promise<{
        testUnion: ?TestUnion,
   *  }>}
   */

  echoStringAsOptionalUnion(value) {}
  
  /**
   * @param { !NestedUnion } testUnion
   * @return {!Promise<{
        value: !number,
   *  }>}
   */

  echoInt8FromNestedUnion(testUnion) {}
  
  /**
   * @param { !NestedUnion } testUnion
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  echoBoolFromNestedUnion(testUnion) {}
  
  /**
   * @param { !NestedUnion } testUnion
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  echoStringFromNestedUnion(testUnion) {}
  
  /**
   * @param { !number } value
   * @return {!Promise<{
        testUnion: !NestedUnion,
   *  }>}
   */

  echoInt8AsNestedUnion(value) {}
  
  /**
   * @param { !boolean } value
   * @return {!Promise<{
        testUnion: !NestedUnion,
   *  }>}
   */

  echoBoolAsNestedUnion(value) {}
  
  /**
   * @param { !string } value
   * @return {!Promise<{
        testUnion: !NestedUnion,
   *  }>}
   */

  echoStringAsNestedUnion(value) {}
  
  /**
   * @param { ?NestedUnion } testUnion
   * @return {!Promise}
   */

  echoNullFromOptionalNestedUnion(testUnion) {}
  
  /**
   * @param { ?NestedUnion } testUnion
   * @return {!Promise<{
        value: !number,
   *  }>}
   */

  echoInt8FromOptionalNestedUnion(testUnion) {}
  
  /**
   * @param { ?NestedUnion } testUnion
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  echoBoolFromOptionalNestedUnion(testUnion) {}
  
  /**
   * @param { ?NestedUnion } testUnion
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  echoStringFromOptionalNestedUnion(testUnion) {}
  
  /**
   * @return {!Promise<{
        testUnion: ?NestedUnion,
   *  }>}
   */

  echoNullAsOptionalNestedUnion() {}
  
  /**
   * @param { !number } value
   * @return {!Promise<{
        testUnion: ?NestedUnion,
   *  }>}
   */

  echoInt8AsOptionalNestedUnion(value) {}
  
  /**
   * @param { !boolean } value
   * @return {!Promise<{
        testUnion: ?NestedUnion,
   *  }>}
   */

  echoBoolAsOptionalNestedUnion(value) {}
  
  /**
   * @param { !string } value
   * @return {!Promise<{
        testUnion: ?NestedUnion,
   *  }>}
   */

  echoStringAsOptionalNestedUnion(value) {}
  
  /**
   * @param { !Array<!boolean> } values
   * @return {!Promise<{
        values: !Array<!boolean>,
   *  }>}
   */

  echoBoolArray(values) {}
}

/**
 * @implements { MojoEchoInterface }
 */
export class MojoEchoRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MojoEchoPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MojoEchoPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MojoEchoPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !TestUnion } testUnion
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  echoBoolFromUnion(
      testUnion) {
    return this.proxy.sendMessage(
        0,
        MojoEcho_EchoBoolFromUnion_ParamsSpec.$,
        MojoEcho_EchoBoolFromUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { !TestUnion } testUnion
   * @return {!Promise<{
        value: !number,
   *  }>}
   */

  echoInt32FromUnion(
      testUnion) {
    return this.proxy.sendMessage(
        1,
        MojoEcho_EchoInt32FromUnion_ParamsSpec.$,
        MojoEcho_EchoInt32FromUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { !TestUnion } testUnion
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  echoStringFromUnion(
      testUnion) {
    return this.proxy.sendMessage(
        2,
        MojoEcho_EchoStringFromUnion_ParamsSpec.$,
        MojoEcho_EchoStringFromUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   * @return {!Promise<{
        testUnion: !TestUnion,
   *  }>}
   */

  echoBoolAsUnion(
      value) {
    return this.proxy.sendMessage(
        3,
        MojoEcho_EchoBoolAsUnion_ParamsSpec.$,
        MojoEcho_EchoBoolAsUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !number } value
   * @return {!Promise<{
        testUnion: !TestUnion,
   *  }>}
   */

  echoInt32AsUnion(
      value) {
    return this.proxy.sendMessage(
        4,
        MojoEcho_EchoInt32AsUnion_ParamsSpec.$,
        MojoEcho_EchoInt32AsUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !string } value
   * @return {!Promise<{
        testUnion: !TestUnion,
   *  }>}
   */

  echoStringAsUnion(
      value) {
    return this.proxy.sendMessage(
        5,
        MojoEcho_EchoStringAsUnion_ParamsSpec.$,
        MojoEcho_EchoStringAsUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { ?TestUnion } testUnion
   * @return {!Promise}
   */

  echoNullFromOptionalUnion(
      testUnion) {
    return this.proxy.sendMessage(
        6,
        MojoEcho_EchoNullFromOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoNullFromOptionalUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { ?TestUnion } testUnion
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  echoBoolFromOptionalUnion(
      testUnion) {
    return this.proxy.sendMessage(
        7,
        MojoEcho_EchoBoolFromOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoBoolFromOptionalUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { ?TestUnion } testUnion
   * @return {!Promise<{
        value: !number,
   *  }>}
   */

  echoInt32FromOptionalUnion(
      testUnion) {
    return this.proxy.sendMessage(
        8,
        MojoEcho_EchoInt32FromOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoInt32FromOptionalUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { ?TestUnion } testUnion
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  echoStringFromOptionalUnion(
      testUnion) {
    return this.proxy.sendMessage(
        9,
        MojoEcho_EchoStringFromOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoStringFromOptionalUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        testUnion: ?TestUnion,
   *  }>}
   */

  echoNullAsOptionalUnion() {
    return this.proxy.sendMessage(
        10,
        MojoEcho_EchoNullAsOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoNullAsOptionalUnion_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   * @return {!Promise<{
        testUnion: ?TestUnion,
   *  }>}
   */

  echoBoolAsOptionalUnion(
      value) {
    return this.proxy.sendMessage(
        11,
        MojoEcho_EchoBoolAsOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoBoolAsOptionalUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !number } value
   * @return {!Promise<{
        testUnion: ?TestUnion,
   *  }>}
   */

  echoInt32AsOptionalUnion(
      value) {
    return this.proxy.sendMessage(
        12,
        MojoEcho_EchoInt32AsOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoInt32AsOptionalUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !string } value
   * @return {!Promise<{
        testUnion: ?TestUnion,
   *  }>}
   */

  echoStringAsOptionalUnion(
      value) {
    return this.proxy.sendMessage(
        13,
        MojoEcho_EchoStringAsOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoStringAsOptionalUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !NestedUnion } testUnion
   * @return {!Promise<{
        value: !number,
   *  }>}
   */

  echoInt8FromNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        14,
        MojoEcho_EchoInt8FromNestedUnion_ParamsSpec.$,
        MojoEcho_EchoInt8FromNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { !NestedUnion } testUnion
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  echoBoolFromNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        15,
        MojoEcho_EchoBoolFromNestedUnion_ParamsSpec.$,
        MojoEcho_EchoBoolFromNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { !NestedUnion } testUnion
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  echoStringFromNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        16,
        MojoEcho_EchoStringFromNestedUnion_ParamsSpec.$,
        MojoEcho_EchoStringFromNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { !number } value
   * @return {!Promise<{
        testUnion: !NestedUnion,
   *  }>}
   */

  echoInt8AsNestedUnion(
      value) {
    return this.proxy.sendMessage(
        17,
        MojoEcho_EchoInt8AsNestedUnion_ParamsSpec.$,
        MojoEcho_EchoInt8AsNestedUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   * @return {!Promise<{
        testUnion: !NestedUnion,
   *  }>}
   */

  echoBoolAsNestedUnion(
      value) {
    return this.proxy.sendMessage(
        18,
        MojoEcho_EchoBoolAsNestedUnion_ParamsSpec.$,
        MojoEcho_EchoBoolAsNestedUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !string } value
   * @return {!Promise<{
        testUnion: !NestedUnion,
   *  }>}
   */

  echoStringAsNestedUnion(
      value) {
    return this.proxy.sendMessage(
        19,
        MojoEcho_EchoStringAsNestedUnion_ParamsSpec.$,
        MojoEcho_EchoStringAsNestedUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { ?NestedUnion } testUnion
   * @return {!Promise}
   */

  echoNullFromOptionalNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        20,
        MojoEcho_EchoNullFromOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { ?NestedUnion } testUnion
   * @return {!Promise<{
        value: !number,
   *  }>}
   */

  echoInt8FromOptionalNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        21,
        MojoEcho_EchoInt8FromOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { ?NestedUnion } testUnion
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  echoBoolFromOptionalNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        22,
        MojoEcho_EchoBoolFromOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { ?NestedUnion } testUnion
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  echoStringFromOptionalNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        23,
        MojoEcho_EchoStringFromOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        testUnion: ?NestedUnion,
   *  }>}
   */

  echoNullAsOptionalNestedUnion() {
    return this.proxy.sendMessage(
        24,
        MojoEcho_EchoNullAsOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } value
   * @return {!Promise<{
        testUnion: ?NestedUnion,
   *  }>}
   */

  echoInt8AsOptionalNestedUnion(
      value) {
    return this.proxy.sendMessage(
        25,
        MojoEcho_EchoInt8AsOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   * @return {!Promise<{
        testUnion: ?NestedUnion,
   *  }>}
   */

  echoBoolAsOptionalNestedUnion(
      value) {
    return this.proxy.sendMessage(
        26,
        MojoEcho_EchoBoolAsOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !string } value
   * @return {!Promise<{
        testUnion: ?NestedUnion,
   *  }>}
   */

  echoStringAsOptionalNestedUnion(
      value) {
    return this.proxy.sendMessage(
        27,
        MojoEcho_EchoStringAsOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !Array<!boolean> } values
   * @return {!Promise<{
        values: !Array<!boolean>,
   *  }>}
   */

  echoBoolArray(
      values) {
    return this.proxy.sendMessage(
        28,
        MojoEcho_EchoBoolArray_ParamsSpec.$,
        MojoEcho_EchoBoolArray_ResponseParamsSpec.$,
        [
          values
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MojoEcho
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MojoEchoReceiver {
  /**
   * @param {!MojoEchoInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MojoEchoRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MojoEchoRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MojoEchoRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MojoEcho_EchoBoolFromUnion_ParamsSpec.$,
        MojoEcho_EchoBoolFromUnion_ResponseParamsSpec.$,
        impl.echoBoolFromUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MojoEcho_EchoInt32FromUnion_ParamsSpec.$,
        MojoEcho_EchoInt32FromUnion_ResponseParamsSpec.$,
        impl.echoInt32FromUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MojoEcho_EchoStringFromUnion_ParamsSpec.$,
        MojoEcho_EchoStringFromUnion_ResponseParamsSpec.$,
        impl.echoStringFromUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MojoEcho_EchoBoolAsUnion_ParamsSpec.$,
        MojoEcho_EchoBoolAsUnion_ResponseParamsSpec.$,
        impl.echoBoolAsUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MojoEcho_EchoInt32AsUnion_ParamsSpec.$,
        MojoEcho_EchoInt32AsUnion_ResponseParamsSpec.$,
        impl.echoInt32AsUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MojoEcho_EchoStringAsUnion_ParamsSpec.$,
        MojoEcho_EchoStringAsUnion_ResponseParamsSpec.$,
        impl.echoStringAsUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MojoEcho_EchoNullFromOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoNullFromOptionalUnion_ResponseParamsSpec.$,
        impl.echoNullFromOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MojoEcho_EchoBoolFromOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoBoolFromOptionalUnion_ResponseParamsSpec.$,
        impl.echoBoolFromOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        MojoEcho_EchoInt32FromOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoInt32FromOptionalUnion_ResponseParamsSpec.$,
        impl.echoInt32FromOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        MojoEcho_EchoStringFromOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoStringFromOptionalUnion_ResponseParamsSpec.$,
        impl.echoStringFromOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        MojoEcho_EchoNullAsOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoNullAsOptionalUnion_ResponseParamsSpec.$,
        impl.echoNullAsOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        MojoEcho_EchoBoolAsOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoBoolAsOptionalUnion_ResponseParamsSpec.$,
        impl.echoBoolAsOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        MojoEcho_EchoInt32AsOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoInt32AsOptionalUnion_ResponseParamsSpec.$,
        impl.echoInt32AsOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        MojoEcho_EchoStringAsOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoStringAsOptionalUnion_ResponseParamsSpec.$,
        impl.echoStringAsOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        MojoEcho_EchoInt8FromNestedUnion_ParamsSpec.$,
        MojoEcho_EchoInt8FromNestedUnion_ResponseParamsSpec.$,
        impl.echoInt8FromNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        MojoEcho_EchoBoolFromNestedUnion_ParamsSpec.$,
        MojoEcho_EchoBoolFromNestedUnion_ResponseParamsSpec.$,
        impl.echoBoolFromNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        MojoEcho_EchoStringFromNestedUnion_ParamsSpec.$,
        MojoEcho_EchoStringFromNestedUnion_ResponseParamsSpec.$,
        impl.echoStringFromNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        MojoEcho_EchoInt8AsNestedUnion_ParamsSpec.$,
        MojoEcho_EchoInt8AsNestedUnion_ResponseParamsSpec.$,
        impl.echoInt8AsNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        MojoEcho_EchoBoolAsNestedUnion_ParamsSpec.$,
        MojoEcho_EchoBoolAsNestedUnion_ResponseParamsSpec.$,
        impl.echoBoolAsNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        MojoEcho_EchoStringAsNestedUnion_ParamsSpec.$,
        MojoEcho_EchoStringAsNestedUnion_ResponseParamsSpec.$,
        impl.echoStringAsNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        MojoEcho_EchoNullFromOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoNullFromOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        MojoEcho_EchoInt8FromOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoInt8FromOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        MojoEcho_EchoBoolFromOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoBoolFromOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        MojoEcho_EchoStringFromOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoStringFromOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        MojoEcho_EchoNullAsOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoNullAsOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        MojoEcho_EchoInt8AsOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoInt8AsOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        MojoEcho_EchoBoolAsOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoBoolAsOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        MojoEcho_EchoStringAsOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoStringAsOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        MojoEcho_EchoBoolArray_ParamsSpec.$,
        MojoEcho_EchoBoolArray_ResponseParamsSpec.$,
        impl.echoBoolArray.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MojoEcho {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.MojoEcho";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MojoEchoRemote}
   */
  static getRemote() {
    let remote = new MojoEchoRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MojoEcho
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MojoEchoCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MojoEchoRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MojoEchoRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolFromUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MojoEcho_EchoBoolFromUnion_ParamsSpec.$,
        MojoEcho_EchoBoolFromUnion_ResponseParamsSpec.$,
        this.echoBoolFromUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt32FromUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MojoEcho_EchoInt32FromUnion_ParamsSpec.$,
        MojoEcho_EchoInt32FromUnion_ResponseParamsSpec.$,
        this.echoInt32FromUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringFromUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MojoEcho_EchoStringFromUnion_ParamsSpec.$,
        MojoEcho_EchoStringFromUnion_ResponseParamsSpec.$,
        this.echoStringFromUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolAsUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MojoEcho_EchoBoolAsUnion_ParamsSpec.$,
        MojoEcho_EchoBoolAsUnion_ResponseParamsSpec.$,
        this.echoBoolAsUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt32AsUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MojoEcho_EchoInt32AsUnion_ParamsSpec.$,
        MojoEcho_EchoInt32AsUnion_ResponseParamsSpec.$,
        this.echoInt32AsUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringAsUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MojoEcho_EchoStringAsUnion_ParamsSpec.$,
        MojoEcho_EchoStringAsUnion_ResponseParamsSpec.$,
        this.echoStringAsUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoNullFromOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MojoEcho_EchoNullFromOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoNullFromOptionalUnion_ResponseParamsSpec.$,
        this.echoNullFromOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolFromOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MojoEcho_EchoBoolFromOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoBoolFromOptionalUnion_ResponseParamsSpec.$,
        this.echoBoolFromOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt32FromOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        MojoEcho_EchoInt32FromOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoInt32FromOptionalUnion_ResponseParamsSpec.$,
        this.echoInt32FromOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringFromOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        MojoEcho_EchoStringFromOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoStringFromOptionalUnion_ResponseParamsSpec.$,
        this.echoStringFromOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoNullAsOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        MojoEcho_EchoNullAsOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoNullAsOptionalUnion_ResponseParamsSpec.$,
        this.echoNullAsOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolAsOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        MojoEcho_EchoBoolAsOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoBoolAsOptionalUnion_ResponseParamsSpec.$,
        this.echoBoolAsOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt32AsOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        MojoEcho_EchoInt32AsOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoInt32AsOptionalUnion_ResponseParamsSpec.$,
        this.echoInt32AsOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringAsOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        MojoEcho_EchoStringAsOptionalUnion_ParamsSpec.$,
        MojoEcho_EchoStringAsOptionalUnion_ResponseParamsSpec.$,
        this.echoStringAsOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt8FromNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        MojoEcho_EchoInt8FromNestedUnion_ParamsSpec.$,
        MojoEcho_EchoInt8FromNestedUnion_ResponseParamsSpec.$,
        this.echoInt8FromNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolFromNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        MojoEcho_EchoBoolFromNestedUnion_ParamsSpec.$,
        MojoEcho_EchoBoolFromNestedUnion_ResponseParamsSpec.$,
        this.echoBoolFromNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringFromNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        MojoEcho_EchoStringFromNestedUnion_ParamsSpec.$,
        MojoEcho_EchoStringFromNestedUnion_ResponseParamsSpec.$,
        this.echoStringFromNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt8AsNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        MojoEcho_EchoInt8AsNestedUnion_ParamsSpec.$,
        MojoEcho_EchoInt8AsNestedUnion_ResponseParamsSpec.$,
        this.echoInt8AsNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolAsNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        MojoEcho_EchoBoolAsNestedUnion_ParamsSpec.$,
        MojoEcho_EchoBoolAsNestedUnion_ResponseParamsSpec.$,
        this.echoBoolAsNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringAsNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        MojoEcho_EchoStringAsNestedUnion_ParamsSpec.$,
        MojoEcho_EchoStringAsNestedUnion_ResponseParamsSpec.$,
        this.echoStringAsNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoNullFromOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        MojoEcho_EchoNullFromOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoNullFromOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt8FromOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        MojoEcho_EchoInt8FromOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoInt8FromOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolFromOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        MojoEcho_EchoBoolFromOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoBoolFromOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringFromOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        MojoEcho_EchoStringFromOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoStringFromOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoNullAsOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        MojoEcho_EchoNullAsOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoNullAsOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt8AsOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        MojoEcho_EchoInt8AsOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoInt8AsOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolAsOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        MojoEcho_EchoBoolAsOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoBoolAsOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringAsOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        MojoEcho_EchoStringAsOptionalNestedUnion_ParamsSpec.$,
        MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoStringAsOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolArray =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        MojoEcho_EchoBoolArray_ParamsSpec.$,
        MojoEcho_EchoBoolArray_ResponseParamsSpec.$,
        this.echoBoolArray.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolFromUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolFromUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt32FromUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt32FromUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringFromUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringFromUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolAsUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolAsUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt32AsUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt32AsUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringAsUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringAsUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoNullFromOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoNullFromOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolFromOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolFromOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt32FromOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt32FromOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringFromOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringFromOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoNullAsOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoNullAsOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolAsOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolAsOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt32AsOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt32AsOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringAsOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringAsOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt8FromNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt8FromNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolFromNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolFromNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringFromNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringFromNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt8AsNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt8AsNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolAsNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolAsNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringAsNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringAsNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoNullFromOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt8FromOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolFromOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringFromOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoNullAsOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt8AsOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolAsOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringAsOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolArray_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MojoEcho_EchoBoolArray_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const TestUnionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const NestedUnionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MojoEcho_EchoBoolFromUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolFromUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolFromUnion_Params {
  constructor() {
    /** @type { !TestUnion } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolFromUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolFromUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolFromUnion_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt32FromUnion_ParamsSpec.$,
    'MojoEcho_EchoInt32FromUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoInt32FromUnion_Params {
  constructor() {
    /** @type { !TestUnion } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt32FromUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt32FromUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoInt32FromUnion_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringFromUnion_ParamsSpec.$,
    'MojoEcho_EchoStringFromUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoStringFromUnion_Params {
  constructor() {
    /** @type { !TestUnion } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringFromUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringFromUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoStringFromUnion_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolAsUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolAsUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolAsUnion_Params {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolAsUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolAsUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolAsUnion_ResponseParams {
  constructor() {
    /** @type { !TestUnion } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt32AsUnion_ParamsSpec.$,
    'MojoEcho_EchoInt32AsUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoInt32AsUnion_Params {
  constructor() {
    /** @type { !number } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt32AsUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt32AsUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoInt32AsUnion_ResponseParams {
  constructor() {
    /** @type { !TestUnion } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringAsUnion_ParamsSpec.$,
    'MojoEcho_EchoStringAsUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoStringAsUnion_Params {
  constructor() {
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringAsUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringAsUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoStringAsUnion_ResponseParams {
  constructor() {
    /** @type { !TestUnion } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoNullFromOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoNullFromOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoNullFromOptionalUnion_Params {
  constructor() {
    /** @type { (TestUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoNullFromOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoNullFromOptionalUnion_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MojoEcho_EchoNullFromOptionalUnion_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolFromOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolFromOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolFromOptionalUnion_Params {
  constructor() {
    /** @type { (TestUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolFromOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolFromOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolFromOptionalUnion_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt32FromOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoInt32FromOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoInt32FromOptionalUnion_Params {
  constructor() {
    /** @type { (TestUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt32FromOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt32FromOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoInt32FromOptionalUnion_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringFromOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoStringFromOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoStringFromOptionalUnion_Params {
  constructor() {
    /** @type { (TestUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringFromOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringFromOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoStringFromOptionalUnion_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoNullAsOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoNullAsOptionalUnion_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MojoEcho_EchoNullAsOptionalUnion_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MojoEcho_EchoNullAsOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoNullAsOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoNullAsOptionalUnion_ResponseParams {
  constructor() {
    /** @type { (TestUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolAsOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolAsOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolAsOptionalUnion_Params {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolAsOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolAsOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolAsOptionalUnion_ResponseParams {
  constructor() {
    /** @type { (TestUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt32AsOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoInt32AsOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoInt32AsOptionalUnion_Params {
  constructor() {
    /** @type { !number } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt32AsOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt32AsOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoInt32AsOptionalUnion_ResponseParams {
  constructor() {
    /** @type { (TestUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringAsOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoStringAsOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoStringAsOptionalUnion_Params {
  constructor() {
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringAsOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringAsOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        TestUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoStringAsOptionalUnion_ResponseParams {
  constructor() {
    /** @type { (TestUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt8FromNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoInt8FromNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoInt8FromNestedUnion_Params {
  constructor() {
    /** @type { !NestedUnion } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt8FromNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt8FromNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoInt8FromNestedUnion_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolFromNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolFromNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolFromNestedUnion_Params {
  constructor() {
    /** @type { !NestedUnion } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolFromNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolFromNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolFromNestedUnion_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringFromNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoStringFromNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoStringFromNestedUnion_Params {
  constructor() {
    /** @type { !NestedUnion } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringFromNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringFromNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoStringFromNestedUnion_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt8AsNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoInt8AsNestedUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoInt8AsNestedUnion_Params {
  constructor() {
    /** @type { !number } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt8AsNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt8AsNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoInt8AsNestedUnion_ResponseParams {
  constructor() {
    /** @type { !NestedUnion } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolAsNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolAsNestedUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolAsNestedUnion_Params {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolAsNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolAsNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolAsNestedUnion_ResponseParams {
  constructor() {
    /** @type { !NestedUnion } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringAsNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoStringAsNestedUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoStringAsNestedUnion_Params {
  constructor() {
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringAsNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringAsNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoStringAsNestedUnion_ResponseParams {
  constructor() {
    /** @type { !NestedUnion } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoNullFromOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoNullFromOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoNullFromOptionalNestedUnion_Params {
  constructor() {
    /** @type { (NestedUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt8FromOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoInt8FromOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoInt8FromOptionalNestedUnion_Params {
  constructor() {
    /** @type { (NestedUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolFromOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolFromOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolFromOptionalNestedUnion_Params {
  constructor() {
    /** @type { (NestedUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringFromOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoStringFromOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoStringFromOptionalNestedUnion_Params {
  constructor() {
    /** @type { (NestedUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoNullAsOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoNullAsOptionalNestedUnion_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MojoEcho_EchoNullAsOptionalNestedUnion_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParams {
  constructor() {
    /** @type { (NestedUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt8AsOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoInt8AsOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoInt8AsOptionalNestedUnion_Params {
  constructor() {
    /** @type { !number } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParams {
  constructor() {
    /** @type { (NestedUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolAsOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolAsOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolAsOptionalNestedUnion_Params {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParams {
  constructor() {
    /** @type { (NestedUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringAsOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoStringAsOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoStringAsOptionalNestedUnion_Params {
  constructor() {
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        NestedUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParams {
  constructor() {
    /** @type { (NestedUnion|undefined) } */
    this.testUnion;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolArray_ParamsSpec.$,
    'MojoEcho_EchoBoolArray_Params',
    [
      mojo.internal.StructField(
        'values', 0,
        0,
        mojo.internal.Array(mojo.internal.Bool, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolArray_Params {
  constructor() {
    /** @type { !Array<!boolean> } */
    this.values;
  }
}



mojo.internal.Struct(
    MojoEcho_EchoBoolArray_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolArray_ResponseParams',
    [
      mojo.internal.StructField(
        'values', 0,
        0,
        mojo.internal.Array(mojo.internal.Bool, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MojoEcho_EchoBoolArray_ResponseParams {
  constructor() {
    /** @type { !Array<!boolean> } */
    this.values;
  }
}

mojo.internal.Union(
    TestUnionSpec.$, 'TestUnion',
    {
      'boolValue': {
        'ordinal': 0,
        'type': mojo.internal.Bool,
      },
      'int32Value': {
        'ordinal': 1,
        'type': mojo.internal.Int32,
      },
      'stringValue': {
        'ordinal': 2,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   boolValue: (!boolean|undefined),
 *   int32Value: (!number|undefined),
 *   stringValue: (!string|undefined),
 * } }
 */
export const TestUnion = {};
mojo.internal.Union(
    NestedUnionSpec.$, 'NestedUnion',
    {
      'int8Value': {
        'ordinal': 0,
        'type': mojo.internal.Int8,
      },
      'unionValue': {
        'ordinal': 1,
        'type': TestUnionSpec.$,
      },
    });

/**
 * @typedef { {
 *   int8Value: (!number|undefined),
 *   unionValue: (!TestUnion|undefined),
 * } }
 */
export const NestedUnion = {};
