// content/web_test/common/web_test.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  ByteString as mojoBase_mojom_ByteString,
  ByteStringSpec as mojoBase_mojom_ByteStringSpec
} from '../../../mojo/public/mojom/base/byte_string.mojom.m.js';

import {
  File as mojoBase_mojom_File,
  FileSpec as mojoBase_mojom_FileSpec
} from '../../../mojo/public/mojom/base/file.mojom.m.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  DictionaryValue as mojoBase_mojom_DictionaryValue,
  DictionaryValueSpec as mojoBase_mojom_DictionaryValueSpec
} from '../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  BitmapN32 as skia_mojom_BitmapN32,
  BitmapN32Spec as skia_mojom_BitmapN32Spec
} from '../../../skia/public/mojom/bitmap.mojom.m.js';

import {
  LCPCriticalPathPredictorNavigationTimeHint as blink_mojom_LCPCriticalPathPredictorNavigationTimeHint,
  LCPCriticalPathPredictorNavigationTimeHintSpec as blink_mojom_LCPCriticalPathPredictorNavigationTimeHintSpec
} from '../../../third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom.m.js';

import {
  PermissionStatus as blink_mojom_PermissionStatus,
  PermissionStatusSpec as blink_mojom_PermissionStatusSpec
} from '../../../third_party/blink/public/mojom/permissions/permission_status.mojom.m.js';

import {
  LocalFrameToken as blink_mojom_LocalFrameToken,
  LocalFrameTokenSpec as blink_mojom_LocalFrameTokenSpec
} from '../../../third_party/blink/public/mojom/tokens/tokens.mojom.m.js';

import {
  WebPreferences as blink_mojom_WebPreferences,
  WebPreferencesSpec as blink_mojom_WebPreferencesSpec
} from '../../../third_party/blink/public/mojom/webpreferences/web_preferences.mojom.m.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec,
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebTestRenderFramePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'content.mojom.WebTestRenderFrame', scope);
  }
}

/** @interface */
export class WebTestRenderFrameInterface {
  
  /**
   * @return {!Promise}
   */

  synchronouslyCompositeAfterTest() {}
  
  /**
   * @return {!Promise<{
        frameLayoutDump: !string,
   *  }>}
   */

  dumpFrameLayout() {}
  
  /**
   * @param { !WebTestRunTestConfiguration } config
   * @param { !boolean } startingTest
   */

  setTestConfiguration(config, startingTest) {}
  
  /**
   */

  onDeactivated() {}
  
  /**
   */

  onReactivated() {}
  
  /**
   */

  blockTestUntilStart() {}
  
  /**
   */

  startTest() {}
  
  /**
   */

  setupRendererProcessForNonTestWindow() {}
  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } changedLayoutTestRuntimeFlags
   */

  replicateWebTestRuntimeFlagsChanges(changedLayoutTestRuntimeFlags) {}
  
  /**
   */

  testFinishedFromSecondaryRenderer() {}
  
  /**
   */

  resetRendererAfterWebTest() {}
  
  /**
   * @param { !WorkItem } workItem
   */

  processWorkItem(workItem) {}
  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } workQueueStates
   */

  replicateWorkQueueStates(workQueueStates) {}
}

/**
 * @implements { WebTestRenderFrameInterface }
 */
export class WebTestRenderFrameRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebTestRenderFramePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebTestRenderFramePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebTestRenderFramePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise}
   */

  synchronouslyCompositeAfterTest() {
    return this.proxy.sendMessage(
        0,
        WebTestRenderFrame_SynchronouslyCompositeAfterTest_ParamsSpec.$,
        WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        frameLayoutDump: !string,
   *  }>}
   */

  dumpFrameLayout() {
    return this.proxy.sendMessage(
        1,
        WebTestRenderFrame_DumpFrameLayout_ParamsSpec.$,
        WebTestRenderFrame_DumpFrameLayout_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !WebTestRunTestConfiguration } config
   * @param { !boolean } startingTest
   */

  setTestConfiguration(
      config,
      startingTest) {
    this.proxy.sendMessage(
        2,
        WebTestRenderFrame_SetTestConfiguration_ParamsSpec.$,
        null,
        [
          config,
          startingTest
        ],
        false);
  }

  
  /**
   */

  onDeactivated() {
    this.proxy.sendMessage(
        3,
        WebTestRenderFrame_OnDeactivated_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onReactivated() {
    this.proxy.sendMessage(
        4,
        WebTestRenderFrame_OnReactivated_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  blockTestUntilStart() {
    this.proxy.sendMessage(
        5,
        WebTestRenderFrame_BlockTestUntilStart_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  startTest() {
    this.proxy.sendMessage(
        6,
        WebTestRenderFrame_StartTest_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  setupRendererProcessForNonTestWindow() {
    this.proxy.sendMessage(
        7,
        WebTestRenderFrame_SetupRendererProcessForNonTestWindow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } changedLayoutTestRuntimeFlags
   */

  replicateWebTestRuntimeFlagsChanges(
      changedLayoutTestRuntimeFlags) {
    this.proxy.sendMessage(
        8,
        WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_ParamsSpec.$,
        null,
        [
          changedLayoutTestRuntimeFlags
        ],
        false);
  }

  
  /**
   */

  testFinishedFromSecondaryRenderer() {
    this.proxy.sendMessage(
        9,
        WebTestRenderFrame_TestFinishedFromSecondaryRenderer_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resetRendererAfterWebTest() {
    this.proxy.sendMessage(
        10,
        WebTestRenderFrame_ResetRendererAfterWebTest_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !WorkItem } workItem
   */

  processWorkItem(
      workItem) {
    this.proxy.sendMessage(
        11,
        WebTestRenderFrame_ProcessWorkItem_ParamsSpec.$,
        null,
        [
          workItem
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } workQueueStates
   */

  replicateWorkQueueStates(
      workQueueStates) {
    this.proxy.sendMessage(
        12,
        WebTestRenderFrame_ReplicateWorkQueueStates_ParamsSpec.$,
        null,
        [
          workQueueStates
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebTestRenderFrame
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebTestRenderFrameReceiver {
  /**
   * @param {!WebTestRenderFrameInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebTestRenderFrameRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebTestRenderFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebTestRenderFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebTestRenderFrame_SynchronouslyCompositeAfterTest_ParamsSpec.$,
        WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParamsSpec.$,
        impl.synchronouslyCompositeAfterTest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebTestRenderFrame_DumpFrameLayout_ParamsSpec.$,
        WebTestRenderFrame_DumpFrameLayout_ResponseParamsSpec.$,
        impl.dumpFrameLayout.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WebTestRenderFrame_SetTestConfiguration_ParamsSpec.$,
        null,
        impl.setTestConfiguration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WebTestRenderFrame_OnDeactivated_ParamsSpec.$,
        null,
        impl.onDeactivated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WebTestRenderFrame_OnReactivated_ParamsSpec.$,
        null,
        impl.onReactivated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        WebTestRenderFrame_BlockTestUntilStart_ParamsSpec.$,
        null,
        impl.blockTestUntilStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        WebTestRenderFrame_StartTest_ParamsSpec.$,
        null,
        impl.startTest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        WebTestRenderFrame_SetupRendererProcessForNonTestWindow_ParamsSpec.$,
        null,
        impl.setupRendererProcessForNonTestWindow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_ParamsSpec.$,
        null,
        impl.replicateWebTestRuntimeFlagsChanges.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        WebTestRenderFrame_TestFinishedFromSecondaryRenderer_ParamsSpec.$,
        null,
        impl.testFinishedFromSecondaryRenderer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        WebTestRenderFrame_ResetRendererAfterWebTest_ParamsSpec.$,
        null,
        impl.resetRendererAfterWebTest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        WebTestRenderFrame_ProcessWorkItem_ParamsSpec.$,
        null,
        impl.processWorkItem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        WebTestRenderFrame_ReplicateWorkQueueStates_ParamsSpec.$,
        null,
        impl.replicateWorkQueueStates.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebTestRenderFrame {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.WebTestRenderFrame";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebTestRenderFrameRemote}
   */
  static getRemote() {
    let remote = new WebTestRenderFrameRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebTestRenderFrame
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebTestRenderFrameCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebTestRenderFrameRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebTestRenderFrameRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.synchronouslyCompositeAfterTest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebTestRenderFrame_SynchronouslyCompositeAfterTest_ParamsSpec.$,
        WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParamsSpec.$,
        this.synchronouslyCompositeAfterTest.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dumpFrameLayout =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebTestRenderFrame_DumpFrameLayout_ParamsSpec.$,
        WebTestRenderFrame_DumpFrameLayout_ResponseParamsSpec.$,
        this.dumpFrameLayout.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTestConfiguration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WebTestRenderFrame_SetTestConfiguration_ParamsSpec.$,
        null,
        this.setTestConfiguration.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeactivated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WebTestRenderFrame_OnDeactivated_ParamsSpec.$,
        null,
        this.onDeactivated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReactivated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WebTestRenderFrame_OnReactivated_ParamsSpec.$,
        null,
        this.onReactivated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.blockTestUntilStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        WebTestRenderFrame_BlockTestUntilStart_ParamsSpec.$,
        null,
        this.blockTestUntilStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startTest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        WebTestRenderFrame_StartTest_ParamsSpec.$,
        null,
        this.startTest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setupRendererProcessForNonTestWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        WebTestRenderFrame_SetupRendererProcessForNonTestWindow_ParamsSpec.$,
        null,
        this.setupRendererProcessForNonTestWindow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replicateWebTestRuntimeFlagsChanges =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_ParamsSpec.$,
        null,
        this.replicateWebTestRuntimeFlagsChanges.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.testFinishedFromSecondaryRenderer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        WebTestRenderFrame_TestFinishedFromSecondaryRenderer_ParamsSpec.$,
        null,
        this.testFinishedFromSecondaryRenderer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resetRendererAfterWebTest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        WebTestRenderFrame_ResetRendererAfterWebTest_ParamsSpec.$,
        null,
        this.resetRendererAfterWebTest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.processWorkItem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        WebTestRenderFrame_ProcessWorkItem_ParamsSpec.$,
        null,
        this.processWorkItem.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replicateWorkQueueStates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        WebTestRenderFrame_ReplicateWorkQueueStates_ParamsSpec.$,
        null,
        this.replicateWorkQueueStates.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebTestControlHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'content.mojom.WebTestControlHost', scope);
  }
}

/** @interface */
export class WebTestControlHostInterface {
  
  /**
   * @param { !WebTestRendererDumpResult } result
   * @param { !boolean } captureNavigationHistory
   * @param { !boolean } capturePixels
   */

  initiateCaptureDump(result, captureNavigationHistory, capturePixels) {}
  
  /**
   */

  testFinishedInSecondaryRenderer() {}
  
  /**
   * @param { !string } message
   */

  printMessageToStderr(message) {}
  
  /**
   * @param { !string } message
   */

  printMessage(message) {}
  
  /**
   * @param { !blink_mojom_WebPreferences } webPreferences
   */

  overridePreferences(webPreferences) {}
  
  /**
   */

  reload() {}
  
  /**
   */

  checkForLeakedWindows() {}
  
  /**
   * @param { !boolean } hidden
   */

  setMainWindowHidden(hidden) {}
  
  /**
   * @param { !blink_mojom_LocalFrameToken } frameToken
   * @param { !boolean } hidden
   */

  setFrameWindowHidden(frameToken, hidden) {}
  
  /**
   * @param { !number } offset
   */

  goToOffset(offset) {}
  
  /**
   * @param { !string } event
   * @param { !string } argument
   */

  sendBluetoothManualChooserEvent(event, argument) {}
  
  /**
   * @param { !boolean } enable
   */

  setBluetoothManualChooser(enable) {}
  
  /**
   * @return {!Promise<{
        events: !Array<!string>,
   *  }>}
   */

  getBluetoothManualChooserEvents() {}
  
  /**
   * @param { !boolean } blockPopups
   */

  setPopupBlockingEnabled(blockPopups) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } frameName
   */

  loadURLForFrame(url, frameName) {}
  
  /**
   */

  simulateScreenOrientationChanged() {}
  
  /**
   * @param { !string } name
   * @param { !blink_mojom_PermissionStatus } status
   * @param { !url_mojom_Url } origin
   * @param { !url_mojom_Url } embeddingOrigin
   */

  setPermission(name, status, origin, embeddingOrigin) {}
  
  /**
   * @param { !boolean } block
   */

  blockThirdPartyCookies(block) {}
  
  /**
   * @return {!Promise<{
        path: !mojoBase_mojom_FilePath,
   *  }>}
   */

  getWritableDirectory() {}
  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   */

  setFilePathForMockFileDialog(path) {}
  
  /**
   * @param { !Array<!string> } disallowedSuffixes
   * @return {!Promise<{
        file: !mojoBase_mojom_File,
   *  }>}
   */

  createSubresourceFilterRulesetFile(disallowedSuffixes) {}
  
  /**
   */

  focusDevtoolsSecondaryWindow() {}
  
  /**
   * @param { !string } rawCommitments
   * @return {!Promise}
   */

  setTrustTokenKeyCommitments(rawCommitments) {}
  
  /**
   * @return {!Promise}
   */

  clearTrustTokenState() {}
  
  /**
   * @param { !string } title
   * @param { !number } actionIndex
   * @param { ?mojoBase_mojom_String16 } reply
   */

  simulateWebNotificationClick(title, actionIndex, reply) {}
  
  /**
   * @param { !string } title
   * @param { !boolean } byUser
   */

  simulateWebNotificationClose(title, byUser) {}
  
  /**
   * @param { !string } id
   */

  simulateWebContentIndexDelete(id) {}
  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } changedWebTestRuntimeFlags
   */

  webTestRuntimeFlagsChanged(changedWebTestRuntimeFlags) {}
  
  /**
   * @param { !Array<!mojoBase_mojom_FilePath> } filePaths
   * @return {!Promise<{
        filesystemId: !string,
   *  }>}
   */

  registerIsolatedFileSystem(filePaths) {}
  
  /**
   */

  dropPointerLock() {}
  
  /**
   */

  setPointerLockWillFail() {}
  
  /**
   */

  setPointerLockWillRespondAsynchronously() {}
  
  /**
   */

  allowPointerLock() {}
  
  /**
   * @param { !WorkItem } workItem
   */

  workItemAdded(workItem) {}
  
  /**
   */

  requestWorkItem() {}
  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } changedWorkQueueStates
   */

  workQueueStatesChanged(changedWorkQueueStates) {}
  
  /**
   * @param { !string } acceptLanguages
   */

  setAcceptLanguages(acceptLanguages) {}
  
  /**
   * @param { !WebTestControlHost_AutoResponseMode } mode
   */

  setRegisterProtocolHandlerMode(mode) {}
  
  /**
   * @param { !gfx_mojom_Size } minSize
   * @param { !gfx_mojom_Size } maxSize
   */

  enableAutoResize(minSize, maxSize) {}
  
  /**
   * @param { !gfx_mojom_Size } newSize
   */

  disableAutoResize(newSize) {}
}

/**
 * @implements { WebTestControlHostInterface }
 */
export class WebTestControlHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebTestControlHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebTestControlHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebTestControlHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !WebTestRendererDumpResult } result
   * @param { !boolean } captureNavigationHistory
   * @param { !boolean } capturePixels
   */

  initiateCaptureDump(
      result,
      captureNavigationHistory,
      capturePixels) {
    this.proxy.sendMessage(
        0,
        WebTestControlHost_InitiateCaptureDump_ParamsSpec.$,
        null,
        [
          result,
          captureNavigationHistory,
          capturePixels
        ],
        false);
  }

  
  /**
   */

  testFinishedInSecondaryRenderer() {
    this.proxy.sendMessage(
        1,
        WebTestControlHost_TestFinishedInSecondaryRenderer_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } message
   */

  printMessageToStderr(
      message) {
    this.proxy.sendMessage(
        2,
        WebTestControlHost_PrintMessageToStderr_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  
  /**
   * @param { !string } message
   */

  printMessage(
      message) {
    this.proxy.sendMessage(
        3,
        WebTestControlHost_PrintMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_WebPreferences } webPreferences
   */

  overridePreferences(
      webPreferences) {
    this.proxy.sendMessage(
        4,
        WebTestControlHost_OverridePreferences_ParamsSpec.$,
        null,
        [
          webPreferences
        ],
        false);
  }

  
  /**
   */

  reload() {
    this.proxy.sendMessage(
        5,
        WebTestControlHost_Reload_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  checkForLeakedWindows() {
    this.proxy.sendMessage(
        6,
        WebTestControlHost_CheckForLeakedWindows_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } hidden
   */

  setMainWindowHidden(
      hidden) {
    this.proxy.sendMessage(
        7,
        WebTestControlHost_SetMainWindowHidden_ParamsSpec.$,
        null,
        [
          hidden
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_LocalFrameToken } frameToken
   * @param { !boolean } hidden
   */

  setFrameWindowHidden(
      frameToken,
      hidden) {
    this.proxy.sendMessage(
        8,
        WebTestControlHost_SetFrameWindowHidden_ParamsSpec.$,
        null,
        [
          frameToken,
          hidden
        ],
        false);
  }

  
  /**
   * @param { !number } offset
   */

  goToOffset(
      offset) {
    this.proxy.sendMessage(
        9,
        WebTestControlHost_GoToOffset_ParamsSpec.$,
        null,
        [
          offset
        ],
        false);
  }

  
  /**
   * @param { !string } event
   * @param { !string } argument
   */

  sendBluetoothManualChooserEvent(
      event,
      argument) {
    this.proxy.sendMessage(
        10,
        WebTestControlHost_SendBluetoothManualChooserEvent_ParamsSpec.$,
        null,
        [
          event,
          argument
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   */

  setBluetoothManualChooser(
      enable) {
    this.proxy.sendMessage(
        11,
        WebTestControlHost_SetBluetoothManualChooser_ParamsSpec.$,
        null,
        [
          enable
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        events: !Array<!string>,
   *  }>}
   */

  getBluetoothManualChooserEvents() {
    return this.proxy.sendMessage(
        12,
        WebTestControlHost_GetBluetoothManualChooserEvents_ParamsSpec.$,
        WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } blockPopups
   */

  setPopupBlockingEnabled(
      blockPopups) {
    this.proxy.sendMessage(
        13,
        WebTestControlHost_SetPopupBlockingEnabled_ParamsSpec.$,
        null,
        [
          blockPopups
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !string } frameName
   */

  loadURLForFrame(
      url,
      frameName) {
    this.proxy.sendMessage(
        14,
        WebTestControlHost_LoadURLForFrame_ParamsSpec.$,
        null,
        [
          url,
          frameName
        ],
        false);
  }

  
  /**
   */

  simulateScreenOrientationChanged() {
    this.proxy.sendMessage(
        15,
        WebTestControlHost_SimulateScreenOrientationChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @param { !blink_mojom_PermissionStatus } status
   * @param { !url_mojom_Url } origin
   * @param { !url_mojom_Url } embeddingOrigin
   */

  setPermission(
      name,
      status,
      origin,
      embeddingOrigin) {
    this.proxy.sendMessage(
        16,
        WebTestControlHost_SetPermission_ParamsSpec.$,
        null,
        [
          name,
          status,
          origin,
          embeddingOrigin
        ],
        false);
  }

  
  /**
   * @param { !boolean } block
   */

  blockThirdPartyCookies(
      block) {
    this.proxy.sendMessage(
        17,
        WebTestControlHost_BlockThirdPartyCookies_ParamsSpec.$,
        null,
        [
          block
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        path: !mojoBase_mojom_FilePath,
   *  }>}
   */

  getWritableDirectory() {
    return this.proxy.sendMessage(
        18,
        WebTestControlHost_GetWritableDirectory_ParamsSpec.$,
        WebTestControlHost_GetWritableDirectory_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   */

  setFilePathForMockFileDialog(
      path) {
    this.proxy.sendMessage(
        19,
        WebTestControlHost_SetFilePathForMockFileDialog_ParamsSpec.$,
        null,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } disallowedSuffixes
   * @return {!Promise<{
        file: !mojoBase_mojom_File,
   *  }>}
   */

  createSubresourceFilterRulesetFile(
      disallowedSuffixes) {
    return this.proxy.sendMessage(
        20,
        WebTestControlHost_CreateSubresourceFilterRulesetFile_ParamsSpec.$,
        WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParamsSpec.$,
        [
          disallowedSuffixes
        ],
        false);
  }

  
  /**
   */

  focusDevtoolsSecondaryWindow() {
    this.proxy.sendMessage(
        21,
        WebTestControlHost_FocusDevtoolsSecondaryWindow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } rawCommitments
   * @return {!Promise}
   */

  setTrustTokenKeyCommitments(
      rawCommitments) {
    return this.proxy.sendMessage(
        22,
        WebTestControlHost_SetTrustTokenKeyCommitments_ParamsSpec.$,
        WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
        [
          rawCommitments
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  clearTrustTokenState() {
    return this.proxy.sendMessage(
        23,
        WebTestControlHost_ClearTrustTokenState_ParamsSpec.$,
        WebTestControlHost_ClearTrustTokenState_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } title
   * @param { !number } actionIndex
   * @param { ?mojoBase_mojom_String16 } reply
   */

  simulateWebNotificationClick(
      title,
      actionIndex,
      reply) {
    this.proxy.sendMessage(
        24,
        WebTestControlHost_SimulateWebNotificationClick_ParamsSpec.$,
        null,
        [
          title,
          actionIndex,
          reply
        ],
        false);
  }

  
  /**
   * @param { !string } title
   * @param { !boolean } byUser
   */

  simulateWebNotificationClose(
      title,
      byUser) {
    this.proxy.sendMessage(
        25,
        WebTestControlHost_SimulateWebNotificationClose_ParamsSpec.$,
        null,
        [
          title,
          byUser
        ],
        false);
  }

  
  /**
   * @param { !string } id
   */

  simulateWebContentIndexDelete(
      id) {
    this.proxy.sendMessage(
        26,
        WebTestControlHost_SimulateWebContentIndexDelete_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } changedWebTestRuntimeFlags
   */

  webTestRuntimeFlagsChanged(
      changedWebTestRuntimeFlags) {
    this.proxy.sendMessage(
        27,
        WebTestControlHost_WebTestRuntimeFlagsChanged_ParamsSpec.$,
        null,
        [
          changedWebTestRuntimeFlags
        ],
        false);
  }

  
  /**
   * @param { !Array<!mojoBase_mojom_FilePath> } filePaths
   * @return {!Promise<{
        filesystemId: !string,
   *  }>}
   */

  registerIsolatedFileSystem(
      filePaths) {
    return this.proxy.sendMessage(
        28,
        WebTestControlHost_RegisterIsolatedFileSystem_ParamsSpec.$,
        WebTestControlHost_RegisterIsolatedFileSystem_ResponseParamsSpec.$,
        [
          filePaths
        ],
        false);
  }

  
  /**
   */

  dropPointerLock() {
    this.proxy.sendMessage(
        29,
        WebTestControlHost_DropPointerLock_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  setPointerLockWillFail() {
    this.proxy.sendMessage(
        30,
        WebTestControlHost_SetPointerLockWillFail_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  setPointerLockWillRespondAsynchronously() {
    this.proxy.sendMessage(
        31,
        WebTestControlHost_SetPointerLockWillRespondAsynchronously_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  allowPointerLock() {
    this.proxy.sendMessage(
        32,
        WebTestControlHost_AllowPointerLock_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !WorkItem } workItem
   */

  workItemAdded(
      workItem) {
    this.proxy.sendMessage(
        33,
        WebTestControlHost_WorkItemAdded_ParamsSpec.$,
        null,
        [
          workItem
        ],
        false);
  }

  
  /**
   */

  requestWorkItem() {
    this.proxy.sendMessage(
        34,
        WebTestControlHost_RequestWorkItem_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } changedWorkQueueStates
   */

  workQueueStatesChanged(
      changedWorkQueueStates) {
    this.proxy.sendMessage(
        35,
        WebTestControlHost_WorkQueueStatesChanged_ParamsSpec.$,
        null,
        [
          changedWorkQueueStates
        ],
        false);
  }

  
  /**
   * @param { !string } acceptLanguages
   */

  setAcceptLanguages(
      acceptLanguages) {
    this.proxy.sendMessage(
        36,
        WebTestControlHost_SetAcceptLanguages_ParamsSpec.$,
        null,
        [
          acceptLanguages
        ],
        false);
  }

  
  /**
   * @param { !WebTestControlHost_AutoResponseMode } mode
   */

  setRegisterProtocolHandlerMode(
      mode) {
    this.proxy.sendMessage(
        37,
        WebTestControlHost_SetRegisterProtocolHandlerMode_ParamsSpec.$,
        null,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Size } minSize
   * @param { !gfx_mojom_Size } maxSize
   */

  enableAutoResize(
      minSize,
      maxSize) {
    this.proxy.sendMessage(
        38,
        WebTestControlHost_EnableAutoResize_ParamsSpec.$,
        null,
        [
          minSize,
          maxSize
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Size } newSize
   */

  disableAutoResize(
      newSize) {
    this.proxy.sendMessage(
        39,
        WebTestControlHost_DisableAutoResize_ParamsSpec.$,
        null,
        [
          newSize
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebTestControlHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebTestControlHostReceiver {
  /**
   * @param {!WebTestControlHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebTestControlHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebTestControlHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebTestControlHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebTestControlHost_InitiateCaptureDump_ParamsSpec.$,
        null,
        impl.initiateCaptureDump.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebTestControlHost_TestFinishedInSecondaryRenderer_ParamsSpec.$,
        null,
        impl.testFinishedInSecondaryRenderer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WebTestControlHost_PrintMessageToStderr_ParamsSpec.$,
        null,
        impl.printMessageToStderr.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WebTestControlHost_PrintMessage_ParamsSpec.$,
        null,
        impl.printMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WebTestControlHost_OverridePreferences_ParamsSpec.$,
        null,
        impl.overridePreferences.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        WebTestControlHost_Reload_ParamsSpec.$,
        null,
        impl.reload.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        WebTestControlHost_CheckForLeakedWindows_ParamsSpec.$,
        null,
        impl.checkForLeakedWindows.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        WebTestControlHost_SetMainWindowHidden_ParamsSpec.$,
        null,
        impl.setMainWindowHidden.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        WebTestControlHost_SetFrameWindowHidden_ParamsSpec.$,
        null,
        impl.setFrameWindowHidden.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        WebTestControlHost_GoToOffset_ParamsSpec.$,
        null,
        impl.goToOffset.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        WebTestControlHost_SendBluetoothManualChooserEvent_ParamsSpec.$,
        null,
        impl.sendBluetoothManualChooserEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        WebTestControlHost_SetBluetoothManualChooser_ParamsSpec.$,
        null,
        impl.setBluetoothManualChooser.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        WebTestControlHost_GetBluetoothManualChooserEvents_ParamsSpec.$,
        WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParamsSpec.$,
        impl.getBluetoothManualChooserEvents.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        WebTestControlHost_SetPopupBlockingEnabled_ParamsSpec.$,
        null,
        impl.setPopupBlockingEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        WebTestControlHost_LoadURLForFrame_ParamsSpec.$,
        null,
        impl.loadURLForFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        WebTestControlHost_SimulateScreenOrientationChanged_ParamsSpec.$,
        null,
        impl.simulateScreenOrientationChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        WebTestControlHost_SetPermission_ParamsSpec.$,
        null,
        impl.setPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        WebTestControlHost_BlockThirdPartyCookies_ParamsSpec.$,
        null,
        impl.blockThirdPartyCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        WebTestControlHost_GetWritableDirectory_ParamsSpec.$,
        WebTestControlHost_GetWritableDirectory_ResponseParamsSpec.$,
        impl.getWritableDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        WebTestControlHost_SetFilePathForMockFileDialog_ParamsSpec.$,
        null,
        impl.setFilePathForMockFileDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        WebTestControlHost_CreateSubresourceFilterRulesetFile_ParamsSpec.$,
        WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParamsSpec.$,
        impl.createSubresourceFilterRulesetFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        WebTestControlHost_FocusDevtoolsSecondaryWindow_ParamsSpec.$,
        null,
        impl.focusDevtoolsSecondaryWindow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        WebTestControlHost_SetTrustTokenKeyCommitments_ParamsSpec.$,
        WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
        impl.setTrustTokenKeyCommitments.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        WebTestControlHost_ClearTrustTokenState_ParamsSpec.$,
        WebTestControlHost_ClearTrustTokenState_ResponseParamsSpec.$,
        impl.clearTrustTokenState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        WebTestControlHost_SimulateWebNotificationClick_ParamsSpec.$,
        null,
        impl.simulateWebNotificationClick.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        WebTestControlHost_SimulateWebNotificationClose_ParamsSpec.$,
        null,
        impl.simulateWebNotificationClose.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        WebTestControlHost_SimulateWebContentIndexDelete_ParamsSpec.$,
        null,
        impl.simulateWebContentIndexDelete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        WebTestControlHost_WebTestRuntimeFlagsChanged_ParamsSpec.$,
        null,
        impl.webTestRuntimeFlagsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        WebTestControlHost_RegisterIsolatedFileSystem_ParamsSpec.$,
        WebTestControlHost_RegisterIsolatedFileSystem_ResponseParamsSpec.$,
        impl.registerIsolatedFileSystem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        WebTestControlHost_DropPointerLock_ParamsSpec.$,
        null,
        impl.dropPointerLock.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        30,
        WebTestControlHost_SetPointerLockWillFail_ParamsSpec.$,
        null,
        impl.setPointerLockWillFail.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        31,
        WebTestControlHost_SetPointerLockWillRespondAsynchronously_ParamsSpec.$,
        null,
        impl.setPointerLockWillRespondAsynchronously.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        32,
        WebTestControlHost_AllowPointerLock_ParamsSpec.$,
        null,
        impl.allowPointerLock.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        33,
        WebTestControlHost_WorkItemAdded_ParamsSpec.$,
        null,
        impl.workItemAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        34,
        WebTestControlHost_RequestWorkItem_ParamsSpec.$,
        null,
        impl.requestWorkItem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        35,
        WebTestControlHost_WorkQueueStatesChanged_ParamsSpec.$,
        null,
        impl.workQueueStatesChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        36,
        WebTestControlHost_SetAcceptLanguages_ParamsSpec.$,
        null,
        impl.setAcceptLanguages.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        37,
        WebTestControlHost_SetRegisterProtocolHandlerMode_ParamsSpec.$,
        null,
        impl.setRegisterProtocolHandlerMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        38,
        WebTestControlHost_EnableAutoResize_ParamsSpec.$,
        null,
        impl.enableAutoResize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        39,
        WebTestControlHost_DisableAutoResize_ParamsSpec.$,
        null,
        impl.disableAutoResize.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebTestControlHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.WebTestControlHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebTestControlHostRemote}
   */
  static getRemote() {
    let remote = new WebTestControlHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebTestControlHost_AutoResponseModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebTestControlHost_AutoResponseMode = {
  
  kNone: 0,
  kAutoAccept: 1,
  kAutoReject: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * An object which receives request messages for the WebTestControlHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebTestControlHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebTestControlHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebTestControlHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initiateCaptureDump =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebTestControlHost_InitiateCaptureDump_ParamsSpec.$,
        null,
        this.initiateCaptureDump.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.testFinishedInSecondaryRenderer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebTestControlHost_TestFinishedInSecondaryRenderer_ParamsSpec.$,
        null,
        this.testFinishedInSecondaryRenderer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.printMessageToStderr =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WebTestControlHost_PrintMessageToStderr_ParamsSpec.$,
        null,
        this.printMessageToStderr.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.printMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WebTestControlHost_PrintMessage_ParamsSpec.$,
        null,
        this.printMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.overridePreferences =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WebTestControlHost_OverridePreferences_ParamsSpec.$,
        null,
        this.overridePreferences.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reload =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        WebTestControlHost_Reload_ParamsSpec.$,
        null,
        this.reload.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.checkForLeakedWindows =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        WebTestControlHost_CheckForLeakedWindows_ParamsSpec.$,
        null,
        this.checkForLeakedWindows.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMainWindowHidden =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        WebTestControlHost_SetMainWindowHidden_ParamsSpec.$,
        null,
        this.setMainWindowHidden.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFrameWindowHidden =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        WebTestControlHost_SetFrameWindowHidden_ParamsSpec.$,
        null,
        this.setFrameWindowHidden.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.goToOffset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        WebTestControlHost_GoToOffset_ParamsSpec.$,
        null,
        this.goToOffset.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendBluetoothManualChooserEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        WebTestControlHost_SendBluetoothManualChooserEvent_ParamsSpec.$,
        null,
        this.sendBluetoothManualChooserEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setBluetoothManualChooser =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        WebTestControlHost_SetBluetoothManualChooser_ParamsSpec.$,
        null,
        this.setBluetoothManualChooser.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getBluetoothManualChooserEvents =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        WebTestControlHost_GetBluetoothManualChooserEvents_ParamsSpec.$,
        WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParamsSpec.$,
        this.getBluetoothManualChooserEvents.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPopupBlockingEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        WebTestControlHost_SetPopupBlockingEnabled_ParamsSpec.$,
        null,
        this.setPopupBlockingEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadURLForFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        WebTestControlHost_LoadURLForFrame_ParamsSpec.$,
        null,
        this.loadURLForFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateScreenOrientationChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        WebTestControlHost_SimulateScreenOrientationChanged_ParamsSpec.$,
        null,
        this.simulateScreenOrientationChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        WebTestControlHost_SetPermission_ParamsSpec.$,
        null,
        this.setPermission.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.blockThirdPartyCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        WebTestControlHost_BlockThirdPartyCookies_ParamsSpec.$,
        null,
        this.blockThirdPartyCookies.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getWritableDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        WebTestControlHost_GetWritableDirectory_ParamsSpec.$,
        WebTestControlHost_GetWritableDirectory_ResponseParamsSpec.$,
        this.getWritableDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFilePathForMockFileDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        WebTestControlHost_SetFilePathForMockFileDialog_ParamsSpec.$,
        null,
        this.setFilePathForMockFileDialog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSubresourceFilterRulesetFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        WebTestControlHost_CreateSubresourceFilterRulesetFile_ParamsSpec.$,
        WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParamsSpec.$,
        this.createSubresourceFilterRulesetFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.focusDevtoolsSecondaryWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        WebTestControlHost_FocusDevtoolsSecondaryWindow_ParamsSpec.$,
        null,
        this.focusDevtoolsSecondaryWindow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTrustTokenKeyCommitments =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        WebTestControlHost_SetTrustTokenKeyCommitments_ParamsSpec.$,
        WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
        this.setTrustTokenKeyCommitments.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearTrustTokenState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        WebTestControlHost_ClearTrustTokenState_ParamsSpec.$,
        WebTestControlHost_ClearTrustTokenState_ResponseParamsSpec.$,
        this.clearTrustTokenState.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateWebNotificationClick =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        WebTestControlHost_SimulateWebNotificationClick_ParamsSpec.$,
        null,
        this.simulateWebNotificationClick.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateWebNotificationClose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        WebTestControlHost_SimulateWebNotificationClose_ParamsSpec.$,
        null,
        this.simulateWebNotificationClose.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateWebContentIndexDelete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        WebTestControlHost_SimulateWebContentIndexDelete_ParamsSpec.$,
        null,
        this.simulateWebContentIndexDelete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.webTestRuntimeFlagsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        WebTestControlHost_WebTestRuntimeFlagsChanged_ParamsSpec.$,
        null,
        this.webTestRuntimeFlagsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerIsolatedFileSystem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        WebTestControlHost_RegisterIsolatedFileSystem_ParamsSpec.$,
        WebTestControlHost_RegisterIsolatedFileSystem_ResponseParamsSpec.$,
        this.registerIsolatedFileSystem.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dropPointerLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        WebTestControlHost_DropPointerLock_ParamsSpec.$,
        null,
        this.dropPointerLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPointerLockWillFail =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        30,
        WebTestControlHost_SetPointerLockWillFail_ParamsSpec.$,
        null,
        this.setPointerLockWillFail.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPointerLockWillRespondAsynchronously =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        31,
        WebTestControlHost_SetPointerLockWillRespondAsynchronously_ParamsSpec.$,
        null,
        this.setPointerLockWillRespondAsynchronously.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.allowPointerLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        32,
        WebTestControlHost_AllowPointerLock_ParamsSpec.$,
        null,
        this.allowPointerLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.workItemAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        33,
        WebTestControlHost_WorkItemAdded_ParamsSpec.$,
        null,
        this.workItemAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestWorkItem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        34,
        WebTestControlHost_RequestWorkItem_ParamsSpec.$,
        null,
        this.requestWorkItem.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.workQueueStatesChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        35,
        WebTestControlHost_WorkQueueStatesChanged_ParamsSpec.$,
        null,
        this.workQueueStatesChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAcceptLanguages =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        36,
        WebTestControlHost_SetAcceptLanguages_ParamsSpec.$,
        null,
        this.setAcceptLanguages.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setRegisterProtocolHandlerMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        37,
        WebTestControlHost_SetRegisterProtocolHandlerMode_ParamsSpec.$,
        null,
        this.setRegisterProtocolHandlerMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableAutoResize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        38,
        WebTestControlHost_EnableAutoResize_ParamsSpec.$,
        null,
        this.enableAutoResize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disableAutoResize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        39,
        WebTestControlHost_DisableAutoResize_ParamsSpec.$,
        null,
        this.disableAutoResize.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NonAssociatedWebTestControlHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'content.mojom.NonAssociatedWebTestControlHost', scope);
  }
}

/** @interface */
export class NonAssociatedWebTestControlHostInterface {
  
  /**
   * @param { !blink_mojom_LCPCriticalPathPredictorNavigationTimeHint } hint
   */

  setLCPPNavigationHint(hint) {}
}

/**
 * @implements { NonAssociatedWebTestControlHostInterface }
 */
export class NonAssociatedWebTestControlHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NonAssociatedWebTestControlHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NonAssociatedWebTestControlHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NonAssociatedWebTestControlHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_LCPCriticalPathPredictorNavigationTimeHint } hint
   */

  setLCPPNavigationHint(
      hint) {
    this.proxy.sendMessage(
        0,
        NonAssociatedWebTestControlHost_SetLCPPNavigationHint_ParamsSpec.$,
        null,
        [
          hint
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NonAssociatedWebTestControlHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NonAssociatedWebTestControlHostReceiver {
  /**
   * @param {!NonAssociatedWebTestControlHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NonAssociatedWebTestControlHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NonAssociatedWebTestControlHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NonAssociatedWebTestControlHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NonAssociatedWebTestControlHost_SetLCPPNavigationHint_ParamsSpec.$,
        null,
        impl.setLCPPNavigationHint.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NonAssociatedWebTestControlHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.NonAssociatedWebTestControlHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NonAssociatedWebTestControlHostRemote}
   */
  static getRemote() {
    let remote = new NonAssociatedWebTestControlHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NonAssociatedWebTestControlHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NonAssociatedWebTestControlHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NonAssociatedWebTestControlHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NonAssociatedWebTestControlHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setLCPPNavigationHint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NonAssociatedWebTestControlHost_SetLCPPNavigationHint_ParamsSpec.$,
        null,
        this.setLCPPNavigationHint.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRunTestConfigurationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRendererDumpResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WorkItemBackForwardSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WorkItemLoadSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WorkItemReloadSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WorkItemLoadingScriptSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WorkItemNonLoadingScriptSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_SynchronouslyCompositeAfterTest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_DumpFrameLayout_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_DumpFrameLayout_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_SetTestConfiguration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_OnDeactivated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_OnReactivated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_BlockTestUntilStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_StartTest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_SetupRendererProcessForNonTestWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_TestFinishedFromSecondaryRenderer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_ResetRendererAfterWebTest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_ProcessWorkItem_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestRenderFrame_ReplicateWorkQueueStates_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_InitiateCaptureDump_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_TestFinishedInSecondaryRenderer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_PrintMessageToStderr_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_PrintMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_OverridePreferences_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_Reload_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_CheckForLeakedWindows_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SetMainWindowHidden_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SetFrameWindowHidden_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_GoToOffset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SendBluetoothManualChooserEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SetBluetoothManualChooser_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_GetBluetoothManualChooserEvents_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SetPopupBlockingEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_LoadURLForFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SimulateScreenOrientationChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SetPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_BlockThirdPartyCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_GetWritableDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_GetWritableDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SetFilePathForMockFileDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_CreateSubresourceFilterRulesetFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_FocusDevtoolsSecondaryWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SetTrustTokenKeyCommitments_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_ClearTrustTokenState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_ClearTrustTokenState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SimulateWebNotificationClick_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SimulateWebNotificationClose_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SimulateWebContentIndexDelete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_WebTestRuntimeFlagsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_RegisterIsolatedFileSystem_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_RegisterIsolatedFileSystem_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_DropPointerLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SetPointerLockWillFail_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SetPointerLockWillRespondAsynchronously_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_AllowPointerLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_WorkItemAdded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_RequestWorkItem_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_WorkQueueStatesChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SetAcceptLanguages_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_SetRegisterProtocolHandlerMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_EnableAutoResize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTestControlHost_DisableAutoResize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NonAssociatedWebTestControlHost_SetLCPPNavigationHint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const WorkItemSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WebTestRunTestConfigurationSpec.$,
    'WebTestRunTestConfiguration',
    [
      mojo.internal.StructField(
        'currentWorkingDirectory', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tempPath', 8,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'testUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowExternalPages', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedPixelHash', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wptPrintMode', 24,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'protocolMode', 24,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class WebTestRunTestConfiguration {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.currentWorkingDirectory;
    /** @type { !mojoBase_mojom_FilePath } */
    this.tempPath;
    /** @type { !url_mojom_Url } */
    this.testUrl;
    /** @type { !boolean } */
    this.allowExternalPages;
    /** @type { !string } */
    this.expectedPixelHash;
    /** @type { !boolean } */
    this.wptPrintMode;
    /** @type { !boolean } */
    this.protocolMode;
  }
}



mojo.internal.Struct(
    WebTestRendererDumpResultSpec.$,
    'WebTestRendererDumpResult',
    [
      mojo.internal.StructField(
        'audio', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'layout', 8,
        0,
        mojoBase_mojom_ByteStringSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pixels', 16,
        0,
        skia_mojom_BitmapN32Spec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'actualPixelHash', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selectionRect', 32,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class WebTestRendererDumpResult {
  constructor() {
    /** @type { (Array<!number>|undefined) } */
    this.audio;
    /** @type { (mojoBase_mojom_ByteString|undefined) } */
    this.layout;
    /** @type { (skia_mojom_BitmapN32|undefined) } */
    this.pixels;
    /** @type { !string } */
    this.actualPixelHash;
    /** @type { !gfx_mojom_Rect } */
    this.selectionRect;
  }
}



mojo.internal.Struct(
    WorkItemBackForwardSpec.$,
    'WorkItemBackForward',
    [
      mojo.internal.StructField(
        'distance', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WorkItemBackForward {
  constructor() {
    /** @type { !number } */
    this.distance;
  }
}



mojo.internal.Struct(
    WorkItemLoadSpec.$,
    'WorkItemLoad',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'target', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WorkItemLoad {
  constructor() {
    /** @type { !string } */
    this.url;
    /** @type { !string } */
    this.target;
  }
}



mojo.internal.Struct(
    WorkItemReloadSpec.$,
    'WorkItemReload',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WorkItemReload {
  constructor() {
  }
}



mojo.internal.Struct(
    WorkItemLoadingScriptSpec.$,
    'WorkItemLoadingScript',
    [
      mojo.internal.StructField(
        'script', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WorkItemLoadingScript {
  constructor() {
    /** @type { !string } */
    this.script;
  }
}



mojo.internal.Struct(
    WorkItemNonLoadingScriptSpec.$,
    'WorkItemNonLoadingScript',
    [
      mojo.internal.StructField(
        'script', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WorkItemNonLoadingScript {
  constructor() {
    /** @type { !string } */
    this.script;
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_SynchronouslyCompositeAfterTest_ParamsSpec.$,
    'WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestRenderFrame_SynchronouslyCompositeAfterTest_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParamsSpec.$,
    'WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestRenderFrame_SynchronouslyCompositeAfterTest_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_DumpFrameLayout_ParamsSpec.$,
    'WebTestRenderFrame_DumpFrameLayout_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestRenderFrame_DumpFrameLayout_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_DumpFrameLayout_ResponseParamsSpec.$,
    'WebTestRenderFrame_DumpFrameLayout_ResponseParams',
    [
      mojo.internal.StructField(
        'frameLayoutDump', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestRenderFrame_DumpFrameLayout_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.frameLayoutDump;
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_SetTestConfiguration_ParamsSpec.$,
    'WebTestRenderFrame_SetTestConfiguration_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        WebTestRunTestConfigurationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'startingTest', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebTestRenderFrame_SetTestConfiguration_Params {
  constructor() {
    /** @type { !WebTestRunTestConfiguration } */
    this.config;
    /** @type { !boolean } */
    this.startingTest;
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_OnDeactivated_ParamsSpec.$,
    'WebTestRenderFrame_OnDeactivated_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestRenderFrame_OnDeactivated_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_OnReactivated_ParamsSpec.$,
    'WebTestRenderFrame_OnReactivated_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestRenderFrame_OnReactivated_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_BlockTestUntilStart_ParamsSpec.$,
    'WebTestRenderFrame_BlockTestUntilStart_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestRenderFrame_BlockTestUntilStart_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_StartTest_ParamsSpec.$,
    'WebTestRenderFrame_StartTest_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestRenderFrame_StartTest_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_SetupRendererProcessForNonTestWindow_ParamsSpec.$,
    'WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestRenderFrame_SetupRendererProcessForNonTestWindow_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_ParamsSpec.$,
    'WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params',
    [
      mojo.internal.StructField(
        'changedLayoutTestRuntimeFlags', 0,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestRenderFrame_ReplicateWebTestRuntimeFlagsChanges_Params {
  constructor() {
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.changedLayoutTestRuntimeFlags;
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_TestFinishedFromSecondaryRenderer_ParamsSpec.$,
    'WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestRenderFrame_TestFinishedFromSecondaryRenderer_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_ResetRendererAfterWebTest_ParamsSpec.$,
    'WebTestRenderFrame_ResetRendererAfterWebTest_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestRenderFrame_ResetRendererAfterWebTest_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_ProcessWorkItem_ParamsSpec.$,
    'WebTestRenderFrame_ProcessWorkItem_Params',
    [
      mojo.internal.StructField(
        'workItem', 0,
        0,
        WorkItemSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebTestRenderFrame_ProcessWorkItem_Params {
  constructor() {
    /** @type { !WorkItem } */
    this.workItem;
  }
}



mojo.internal.Struct(
    WebTestRenderFrame_ReplicateWorkQueueStates_ParamsSpec.$,
    'WebTestRenderFrame_ReplicateWorkQueueStates_Params',
    [
      mojo.internal.StructField(
        'workQueueStates', 0,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestRenderFrame_ReplicateWorkQueueStates_Params {
  constructor() {
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.workQueueStates;
  }
}



mojo.internal.Struct(
    WebTestControlHost_InitiateCaptureDump_ParamsSpec.$,
    'WebTestControlHost_InitiateCaptureDump_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        WebTestRendererDumpResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'captureNavigationHistory', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'capturePixels', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebTestControlHost_InitiateCaptureDump_Params {
  constructor() {
    /** @type { !WebTestRendererDumpResult } */
    this.result;
    /** @type { !boolean } */
    this.captureNavigationHistory;
    /** @type { !boolean } */
    this.capturePixels;
  }
}



mojo.internal.Struct(
    WebTestControlHost_TestFinishedInSecondaryRenderer_ParamsSpec.$,
    'WebTestControlHost_TestFinishedInSecondaryRenderer_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_TestFinishedInSecondaryRenderer_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_PrintMessageToStderr_ParamsSpec.$,
    'WebTestControlHost_PrintMessageToStderr_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_PrintMessageToStderr_Params {
  constructor() {
    /** @type { !string } */
    this.message;
  }
}



mojo.internal.Struct(
    WebTestControlHost_PrintMessage_ParamsSpec.$,
    'WebTestControlHost_PrintMessage_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_PrintMessage_Params {
  constructor() {
    /** @type { !string } */
    this.message;
  }
}



mojo.internal.Struct(
    WebTestControlHost_OverridePreferences_ParamsSpec.$,
    'WebTestControlHost_OverridePreferences_Params',
    [
      mojo.internal.StructField(
        'webPreferences', 0,
        0,
        blink_mojom_WebPreferencesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_OverridePreferences_Params {
  constructor() {
    /** @type { !blink_mojom_WebPreferences } */
    this.webPreferences;
  }
}



mojo.internal.Struct(
    WebTestControlHost_Reload_ParamsSpec.$,
    'WebTestControlHost_Reload_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_Reload_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_CheckForLeakedWindows_ParamsSpec.$,
    'WebTestControlHost_CheckForLeakedWindows_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_CheckForLeakedWindows_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_SetMainWindowHidden_ParamsSpec.$,
    'WebTestControlHost_SetMainWindowHidden_Params',
    [
      mojo.internal.StructField(
        'hidden', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_SetMainWindowHidden_Params {
  constructor() {
    /** @type { !boolean } */
    this.hidden;
  }
}



mojo.internal.Struct(
    WebTestControlHost_SetFrameWindowHidden_ParamsSpec.$,
    'WebTestControlHost_SetFrameWindowHidden_Params',
    [
      mojo.internal.StructField(
        'frameToken', 0,
        0,
        blink_mojom_LocalFrameTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hidden', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebTestControlHost_SetFrameWindowHidden_Params {
  constructor() {
    /** @type { !blink_mojom_LocalFrameToken } */
    this.frameToken;
    /** @type { !boolean } */
    this.hidden;
  }
}



mojo.internal.Struct(
    WebTestControlHost_GoToOffset_ParamsSpec.$,
    'WebTestControlHost_GoToOffset_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_GoToOffset_Params {
  constructor() {
    /** @type { !number } */
    this.offset;
  }
}



mojo.internal.Struct(
    WebTestControlHost_SendBluetoothManualChooserEvent_ParamsSpec.$,
    'WebTestControlHost_SendBluetoothManualChooserEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'argument', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebTestControlHost_SendBluetoothManualChooserEvent_Params {
  constructor() {
    /** @type { !string } */
    this.event;
    /** @type { !string } */
    this.argument;
  }
}



mojo.internal.Struct(
    WebTestControlHost_SetBluetoothManualChooser_ParamsSpec.$,
    'WebTestControlHost_SetBluetoothManualChooser_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_SetBluetoothManualChooser_Params {
  constructor() {
    /** @type { !boolean } */
    this.enable;
  }
}



mojo.internal.Struct(
    WebTestControlHost_GetBluetoothManualChooserEvents_ParamsSpec.$,
    'WebTestControlHost_GetBluetoothManualChooserEvents_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_GetBluetoothManualChooserEvents_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParamsSpec.$,
    'WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams',
    [
      mojo.internal.StructField(
        'events', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_GetBluetoothManualChooserEvents_ResponseParams {
  constructor() {
    /** @type { !Array<!string> } */
    this.events;
  }
}



mojo.internal.Struct(
    WebTestControlHost_SetPopupBlockingEnabled_ParamsSpec.$,
    'WebTestControlHost_SetPopupBlockingEnabled_Params',
    [
      mojo.internal.StructField(
        'blockPopups', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_SetPopupBlockingEnabled_Params {
  constructor() {
    /** @type { !boolean } */
    this.blockPopups;
  }
}



mojo.internal.Struct(
    WebTestControlHost_LoadURLForFrame_ParamsSpec.$,
    'WebTestControlHost_LoadURLForFrame_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebTestControlHost_LoadURLForFrame_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.frameName;
  }
}



mojo.internal.Struct(
    WebTestControlHost_SimulateScreenOrientationChanged_ParamsSpec.$,
    'WebTestControlHost_SimulateScreenOrientationChanged_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_SimulateScreenOrientationChanged_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_SetPermission_ParamsSpec.$,
    'WebTestControlHost_SetPermission_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        blink_mojom_PermissionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'origin', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'embeddingOrigin', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class WebTestControlHost_SetPermission_Params {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !blink_mojom_PermissionStatus } */
    this.status;
    /** @type { !url_mojom_Url } */
    this.origin;
    /** @type { !url_mojom_Url } */
    this.embeddingOrigin;
  }
}



mojo.internal.Struct(
    WebTestControlHost_BlockThirdPartyCookies_ParamsSpec.$,
    'WebTestControlHost_BlockThirdPartyCookies_Params',
    [
      mojo.internal.StructField(
        'block', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_BlockThirdPartyCookies_Params {
  constructor() {
    /** @type { !boolean } */
    this.block;
  }
}



mojo.internal.Struct(
    WebTestControlHost_GetWritableDirectory_ParamsSpec.$,
    'WebTestControlHost_GetWritableDirectory_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_GetWritableDirectory_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_GetWritableDirectory_ResponseParamsSpec.$,
    'WebTestControlHost_GetWritableDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_GetWritableDirectory_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
  }
}



mojo.internal.Struct(
    WebTestControlHost_SetFilePathForMockFileDialog_ParamsSpec.$,
    'WebTestControlHost_SetFilePathForMockFileDialog_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_SetFilePathForMockFileDialog_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
  }
}



mojo.internal.Struct(
    WebTestControlHost_CreateSubresourceFilterRulesetFile_ParamsSpec.$,
    'WebTestControlHost_CreateSubresourceFilterRulesetFile_Params',
    [
      mojo.internal.StructField(
        'disallowedSuffixes', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_CreateSubresourceFilterRulesetFile_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.disallowedSuffixes;
  }
}



mojo.internal.Struct(
    WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParamsSpec.$,
    'WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams',
    [
      mojo.internal.StructField(
        'file', 0,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_CreateSubresourceFilterRulesetFile_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_File } */
    this.file;
  }
}



mojo.internal.Struct(
    WebTestControlHost_FocusDevtoolsSecondaryWindow_ParamsSpec.$,
    'WebTestControlHost_FocusDevtoolsSecondaryWindow_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_FocusDevtoolsSecondaryWindow_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_SetTrustTokenKeyCommitments_ParamsSpec.$,
    'WebTestControlHost_SetTrustTokenKeyCommitments_Params',
    [
      mojo.internal.StructField(
        'rawCommitments', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_SetTrustTokenKeyCommitments_Params {
  constructor() {
    /** @type { !string } */
    this.rawCommitments;
  }
}



mojo.internal.Struct(
    WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
    'WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_SetTrustTokenKeyCommitments_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_ClearTrustTokenState_ParamsSpec.$,
    'WebTestControlHost_ClearTrustTokenState_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_ClearTrustTokenState_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_ClearTrustTokenState_ResponseParamsSpec.$,
    'WebTestControlHost_ClearTrustTokenState_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_ClearTrustTokenState_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_SimulateWebNotificationClick_ParamsSpec.$,
    'WebTestControlHost_SimulateWebNotificationClick_Params',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'actionIndex', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reply', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class WebTestControlHost_SimulateWebNotificationClick_Params {
  constructor() {
    /** @type { !string } */
    this.title;
    /** @type { !number } */
    this.actionIndex;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.reply;
  }
}



mojo.internal.Struct(
    WebTestControlHost_SimulateWebNotificationClose_ParamsSpec.$,
    'WebTestControlHost_SimulateWebNotificationClose_Params',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'byUser', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebTestControlHost_SimulateWebNotificationClose_Params {
  constructor() {
    /** @type { !string } */
    this.title;
    /** @type { !boolean } */
    this.byUser;
  }
}



mojo.internal.Struct(
    WebTestControlHost_SimulateWebContentIndexDelete_ParamsSpec.$,
    'WebTestControlHost_SimulateWebContentIndexDelete_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_SimulateWebContentIndexDelete_Params {
  constructor() {
    /** @type { !string } */
    this.id;
  }
}



mojo.internal.Struct(
    WebTestControlHost_WebTestRuntimeFlagsChanged_ParamsSpec.$,
    'WebTestControlHost_WebTestRuntimeFlagsChanged_Params',
    [
      mojo.internal.StructField(
        'changedWebTestRuntimeFlags', 0,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_WebTestRuntimeFlagsChanged_Params {
  constructor() {
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.changedWebTestRuntimeFlags;
  }
}



mojo.internal.Struct(
    WebTestControlHost_RegisterIsolatedFileSystem_ParamsSpec.$,
    'WebTestControlHost_RegisterIsolatedFileSystem_Params',
    [
      mojo.internal.StructField(
        'filePaths', 0,
        0,
        mojo.internal.Array(mojoBase_mojom_FilePathSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_RegisterIsolatedFileSystem_Params {
  constructor() {
    /** @type { !Array<!mojoBase_mojom_FilePath> } */
    this.filePaths;
  }
}



mojo.internal.Struct(
    WebTestControlHost_RegisterIsolatedFileSystem_ResponseParamsSpec.$,
    'WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams',
    [
      mojo.internal.StructField(
        'filesystemId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_RegisterIsolatedFileSystem_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.filesystemId;
  }
}



mojo.internal.Struct(
    WebTestControlHost_DropPointerLock_ParamsSpec.$,
    'WebTestControlHost_DropPointerLock_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_DropPointerLock_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_SetPointerLockWillFail_ParamsSpec.$,
    'WebTestControlHost_SetPointerLockWillFail_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_SetPointerLockWillFail_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_SetPointerLockWillRespondAsynchronously_ParamsSpec.$,
    'WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_SetPointerLockWillRespondAsynchronously_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_AllowPointerLock_ParamsSpec.$,
    'WebTestControlHost_AllowPointerLock_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_AllowPointerLock_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_WorkItemAdded_ParamsSpec.$,
    'WebTestControlHost_WorkItemAdded_Params',
    [
      mojo.internal.StructField(
        'workItem', 0,
        0,
        WorkItemSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebTestControlHost_WorkItemAdded_Params {
  constructor() {
    /** @type { !WorkItem } */
    this.workItem;
  }
}



mojo.internal.Struct(
    WebTestControlHost_RequestWorkItem_ParamsSpec.$,
    'WebTestControlHost_RequestWorkItem_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTestControlHost_RequestWorkItem_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTestControlHost_WorkQueueStatesChanged_ParamsSpec.$,
    'WebTestControlHost_WorkQueueStatesChanged_Params',
    [
      mojo.internal.StructField(
        'changedWorkQueueStates', 0,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_WorkQueueStatesChanged_Params {
  constructor() {
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.changedWorkQueueStates;
  }
}



mojo.internal.Struct(
    WebTestControlHost_SetAcceptLanguages_ParamsSpec.$,
    'WebTestControlHost_SetAcceptLanguages_Params',
    [
      mojo.internal.StructField(
        'acceptLanguages', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_SetAcceptLanguages_Params {
  constructor() {
    /** @type { !string } */
    this.acceptLanguages;
  }
}



mojo.internal.Struct(
    WebTestControlHost_SetRegisterProtocolHandlerMode_ParamsSpec.$,
    'WebTestControlHost_SetRegisterProtocolHandlerMode_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        WebTestControlHost_AutoResponseModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_SetRegisterProtocolHandlerMode_Params {
  constructor() {
    /** @type { !WebTestControlHost_AutoResponseMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    WebTestControlHost_EnableAutoResize_ParamsSpec.$,
    'WebTestControlHost_EnableAutoResize_Params',
    [
      mojo.internal.StructField(
        'minSize', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxSize', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebTestControlHost_EnableAutoResize_Params {
  constructor() {
    /** @type { !gfx_mojom_Size } */
    this.minSize;
    /** @type { !gfx_mojom_Size } */
    this.maxSize;
  }
}



mojo.internal.Struct(
    WebTestControlHost_DisableAutoResize_ParamsSpec.$,
    'WebTestControlHost_DisableAutoResize_Params',
    [
      mojo.internal.StructField(
        'newSize', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTestControlHost_DisableAutoResize_Params {
  constructor() {
    /** @type { !gfx_mojom_Size } */
    this.newSize;
  }
}



mojo.internal.Struct(
    NonAssociatedWebTestControlHost_SetLCPPNavigationHint_ParamsSpec.$,
    'NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params',
    [
      mojo.internal.StructField(
        'hint', 0,
        0,
        blink_mojom_LCPCriticalPathPredictorNavigationTimeHintSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NonAssociatedWebTestControlHost_SetLCPPNavigationHint_Params {
  constructor() {
    /** @type { !blink_mojom_LCPCriticalPathPredictorNavigationTimeHint } */
    this.hint;
  }
}

mojo.internal.Union(
    WorkItemSpec.$, 'WorkItem',
    {
      'backForward': {
        'ordinal': 0,
        'type': WorkItemBackForwardSpec.$,
      },
      'load': {
        'ordinal': 1,
        'type': WorkItemLoadSpec.$,
      },
      'reload': {
        'ordinal': 2,
        'type': WorkItemReloadSpec.$,
      },
      'loadingScript': {
        'ordinal': 3,
        'type': WorkItemLoadingScriptSpec.$,
      },
      'nonLoadingScript': {
        'ordinal': 4,
        'type': WorkItemNonLoadingScriptSpec.$,
      },
    });

/**
 * @typedef { {
 *   backForward: (!WorkItemBackForward|undefined),
 *   load: (!WorkItemLoad|undefined),
 *   reload: (!WorkItemReload|undefined),
 *   loadingScript: (!WorkItemLoadingScript|undefined),
 *   nonLoadingScript: (!WorkItemNonLoadingScript|undefined),
 * } }
 */
export const WorkItem = {};
