// extensions/common/mojom/event_router.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  DictionaryValue as mojoBase_mojom_DictionaryValue,
  DictionaryValueSpec as mojoBase_mojom_DictionaryValueSpec
} from '../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../url/mojom/url.mojom.m.js';

import {
  ExtensionId as extensions_mojom_ExtensionId,
  ExtensionIdSpec as extensions_mojom_ExtensionIdSpec
} from './extension_id.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class EventRouterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mojom.EventRouter', scope);
  }
}

/** @interface */
export class EventRouterInterface {
  
  /**
   * @param { !EventListener } eventListener
   */

  addListenerForMainThread(eventListener) {}
  
  /**
   * @param { !EventListener } eventListener
   */

  addListenerForServiceWorker(eventListener) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } eventName
   */

  addLazyListenerForMainThread(extensionId, eventName) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !url_mojom_Url } workerScopeUrl
   * @param { !string } eventName
   */

  addLazyListenerForServiceWorker(extensionId, workerScopeUrl, eventName) {}
  
  /**
   * @param { !EventListenerOwner } listenerOwner
   * @param { !string } eventName
   * @param { !mojoBase_mojom_DictionaryValue } filter
   * @param { !boolean } addLazyListener
   */

  addFilteredListenerForMainThread(listenerOwner, eventName, filter, addLazyListener) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } eventName
   * @param { !ServiceWorkerContext } serviceWorkerContext
   * @param { !mojoBase_mojom_DictionaryValue } filter
   * @param { !boolean } addLazyListener
   */

  addFilteredListenerForServiceWorker(extensionId, eventName, serviceWorkerContext, filter, addLazyListener) {}
  
  /**
   * @param { !EventListener } eventListener
   */

  removeListenerForMainThread(eventListener) {}
  
  /**
   * @param { !EventListener } eventListener
   */

  removeListenerForServiceWorker(eventListener) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } eventName
   */

  removeLazyListenerForMainThread(extensionId, eventName) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !url_mojom_Url } workerScopeUrl
   * @param { !string } eventName
   */

  removeLazyListenerForServiceWorker(extensionId, workerScopeUrl, eventName) {}
  
  /**
   * @param { !EventListenerOwner } listenerOwner
   * @param { !string } eventName
   * @param { !mojoBase_mojom_DictionaryValue } filter
   * @param { !boolean } removeLazyListener
   */

  removeFilteredListenerForMainThread(listenerOwner, eventName, filter, removeLazyListener) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } eventName
   * @param { !ServiceWorkerContext } serviceWorkerContext
   * @param { !mojoBase_mojom_DictionaryValue } filter
   * @param { !boolean } removeLazyListener
   */

  removeFilteredListenerForServiceWorker(extensionId, eventName, serviceWorkerContext, filter, removeLazyListener) {}
}

/**
 * @implements { EventRouterInterface }
 */
export class EventRouterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!EventRouterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          EventRouterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!EventRouterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !EventListener } eventListener
   */

  addListenerForMainThread(
      eventListener) {
    this.proxy.sendMessage(
        0,
        EventRouter_AddListenerForMainThread_ParamsSpec.$,
        null,
        [
          eventListener
        ],
        false);
  }

  
  /**
   * @param { !EventListener } eventListener
   */

  addListenerForServiceWorker(
      eventListener) {
    this.proxy.sendMessage(
        1,
        EventRouter_AddListenerForServiceWorker_ParamsSpec.$,
        null,
        [
          eventListener
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } eventName
   */

  addLazyListenerForMainThread(
      extensionId,
      eventName) {
    this.proxy.sendMessage(
        2,
        EventRouter_AddLazyListenerForMainThread_ParamsSpec.$,
        null,
        [
          extensionId,
          eventName
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !url_mojom_Url } workerScopeUrl
   * @param { !string } eventName
   */

  addLazyListenerForServiceWorker(
      extensionId,
      workerScopeUrl,
      eventName) {
    this.proxy.sendMessage(
        3,
        EventRouter_AddLazyListenerForServiceWorker_ParamsSpec.$,
        null,
        [
          extensionId,
          workerScopeUrl,
          eventName
        ],
        false);
  }

  
  /**
   * @param { !EventListenerOwner } listenerOwner
   * @param { !string } eventName
   * @param { !mojoBase_mojom_DictionaryValue } filter
   * @param { !boolean } addLazyListener
   */

  addFilteredListenerForMainThread(
      listenerOwner,
      eventName,
      filter,
      addLazyListener) {
    this.proxy.sendMessage(
        4,
        EventRouter_AddFilteredListenerForMainThread_ParamsSpec.$,
        null,
        [
          listenerOwner,
          eventName,
          filter,
          addLazyListener
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } eventName
   * @param { !ServiceWorkerContext } serviceWorkerContext
   * @param { !mojoBase_mojom_DictionaryValue } filter
   * @param { !boolean } addLazyListener
   */

  addFilteredListenerForServiceWorker(
      extensionId,
      eventName,
      serviceWorkerContext,
      filter,
      addLazyListener) {
    this.proxy.sendMessage(
        5,
        EventRouter_AddFilteredListenerForServiceWorker_ParamsSpec.$,
        null,
        [
          extensionId,
          eventName,
          serviceWorkerContext,
          filter,
          addLazyListener
        ],
        false);
  }

  
  /**
   * @param { !EventListener } eventListener
   */

  removeListenerForMainThread(
      eventListener) {
    this.proxy.sendMessage(
        6,
        EventRouter_RemoveListenerForMainThread_ParamsSpec.$,
        null,
        [
          eventListener
        ],
        false);
  }

  
  /**
   * @param { !EventListener } eventListener
   */

  removeListenerForServiceWorker(
      eventListener) {
    this.proxy.sendMessage(
        7,
        EventRouter_RemoveListenerForServiceWorker_ParamsSpec.$,
        null,
        [
          eventListener
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } eventName
   */

  removeLazyListenerForMainThread(
      extensionId,
      eventName) {
    this.proxy.sendMessage(
        8,
        EventRouter_RemoveLazyListenerForMainThread_ParamsSpec.$,
        null,
        [
          extensionId,
          eventName
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !url_mojom_Url } workerScopeUrl
   * @param { !string } eventName
   */

  removeLazyListenerForServiceWorker(
      extensionId,
      workerScopeUrl,
      eventName) {
    this.proxy.sendMessage(
        9,
        EventRouter_RemoveLazyListenerForServiceWorker_ParamsSpec.$,
        null,
        [
          extensionId,
          workerScopeUrl,
          eventName
        ],
        false);
  }

  
  /**
   * @param { !EventListenerOwner } listenerOwner
   * @param { !string } eventName
   * @param { !mojoBase_mojom_DictionaryValue } filter
   * @param { !boolean } removeLazyListener
   */

  removeFilteredListenerForMainThread(
      listenerOwner,
      eventName,
      filter,
      removeLazyListener) {
    this.proxy.sendMessage(
        10,
        EventRouter_RemoveFilteredListenerForMainThread_ParamsSpec.$,
        null,
        [
          listenerOwner,
          eventName,
          filter,
          removeLazyListener
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } eventName
   * @param { !ServiceWorkerContext } serviceWorkerContext
   * @param { !mojoBase_mojom_DictionaryValue } filter
   * @param { !boolean } removeLazyListener
   */

  removeFilteredListenerForServiceWorker(
      extensionId,
      eventName,
      serviceWorkerContext,
      filter,
      removeLazyListener) {
    this.proxy.sendMessage(
        11,
        EventRouter_RemoveFilteredListenerForServiceWorker_ParamsSpec.$,
        null,
        [
          extensionId,
          eventName,
          serviceWorkerContext,
          filter,
          removeLazyListener
        ],
        false);
  }
}

/**
 * An object which receives request messages for the EventRouter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class EventRouterReceiver {
  /**
   * @param {!EventRouterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!EventRouterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        EventRouterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EventRouterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        EventRouter_AddListenerForMainThread_ParamsSpec.$,
        null,
        impl.addListenerForMainThread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        EventRouter_AddListenerForServiceWorker_ParamsSpec.$,
        null,
        impl.addListenerForServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        EventRouter_AddLazyListenerForMainThread_ParamsSpec.$,
        null,
        impl.addLazyListenerForMainThread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        EventRouter_AddLazyListenerForServiceWorker_ParamsSpec.$,
        null,
        impl.addLazyListenerForServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        EventRouter_AddFilteredListenerForMainThread_ParamsSpec.$,
        null,
        impl.addFilteredListenerForMainThread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        EventRouter_AddFilteredListenerForServiceWorker_ParamsSpec.$,
        null,
        impl.addFilteredListenerForServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        EventRouter_RemoveListenerForMainThread_ParamsSpec.$,
        null,
        impl.removeListenerForMainThread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        EventRouter_RemoveListenerForServiceWorker_ParamsSpec.$,
        null,
        impl.removeListenerForServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        EventRouter_RemoveLazyListenerForMainThread_ParamsSpec.$,
        null,
        impl.removeLazyListenerForMainThread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        EventRouter_RemoveLazyListenerForServiceWorker_ParamsSpec.$,
        null,
        impl.removeLazyListenerForServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        EventRouter_RemoveFilteredListenerForMainThread_ParamsSpec.$,
        null,
        impl.removeFilteredListenerForMainThread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        EventRouter_RemoveFilteredListenerForServiceWorker_ParamsSpec.$,
        null,
        impl.removeFilteredListenerForServiceWorker.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class EventRouter {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.EventRouter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!EventRouterRemote}
   */
  static getRemote() {
    let remote = new EventRouterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the EventRouter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class EventRouterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      EventRouterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EventRouterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addListenerForMainThread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        EventRouter_AddListenerForMainThread_ParamsSpec.$,
        null,
        this.addListenerForMainThread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addListenerForServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        EventRouter_AddListenerForServiceWorker_ParamsSpec.$,
        null,
        this.addListenerForServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addLazyListenerForMainThread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        EventRouter_AddLazyListenerForMainThread_ParamsSpec.$,
        null,
        this.addLazyListenerForMainThread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addLazyListenerForServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        EventRouter_AddLazyListenerForServiceWorker_ParamsSpec.$,
        null,
        this.addLazyListenerForServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addFilteredListenerForMainThread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        EventRouter_AddFilteredListenerForMainThread_ParamsSpec.$,
        null,
        this.addFilteredListenerForMainThread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addFilteredListenerForServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        EventRouter_AddFilteredListenerForServiceWorker_ParamsSpec.$,
        null,
        this.addFilteredListenerForServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeListenerForMainThread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        EventRouter_RemoveListenerForMainThread_ParamsSpec.$,
        null,
        this.removeListenerForMainThread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeListenerForServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        EventRouter_RemoveListenerForServiceWorker_ParamsSpec.$,
        null,
        this.removeListenerForServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeLazyListenerForMainThread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        EventRouter_RemoveLazyListenerForMainThread_ParamsSpec.$,
        null,
        this.removeLazyListenerForMainThread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeLazyListenerForServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        EventRouter_RemoveLazyListenerForServiceWorker_ParamsSpec.$,
        null,
        this.removeLazyListenerForServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeFilteredListenerForMainThread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        EventRouter_RemoveFilteredListenerForMainThread_ParamsSpec.$,
        null,
        this.removeFilteredListenerForMainThread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeFilteredListenerForServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        EventRouter_RemoveFilteredListenerForServiceWorker_ParamsSpec.$,
        null,
        this.removeFilteredListenerForServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventListenerSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventRouter_AddListenerForMainThread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventRouter_AddListenerForServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventRouter_AddLazyListenerForMainThread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventRouter_AddLazyListenerForServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventRouter_AddFilteredListenerForMainThread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventRouter_AddFilteredListenerForServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventRouter_RemoveListenerForMainThread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventRouter_RemoveListenerForServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventRouter_RemoveLazyListenerForMainThread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventRouter_RemoveLazyListenerForServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventRouter_RemoveFilteredListenerForMainThread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventRouter_RemoveFilteredListenerForServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const EventListenerOwnerSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ServiceWorkerContextSpec.$,
    'ServiceWorkerContext',
    [
      mojo.internal.StructField(
        'scopeUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'versionId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'threadId', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServiceWorkerContext {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.scopeUrl;
    /** @type { !bigint } */
    this.versionId;
    /** @type { !number } */
    this.threadId;
  }
}



mojo.internal.Struct(
    EventListenerSpec.$,
    'EventListener',
    [
      mojo.internal.StructField(
        'listenerOwner', 0,
        0,
        EventListenerOwnerSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerContext', 24,
        0,
        ServiceWorkerContextSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filter', 32,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class EventListener {
  constructor() {
    /** @type { !EventListenerOwner } */
    this.listenerOwner;
    /** @type { !string } */
    this.eventName;
    /** @type { (ServiceWorkerContext|undefined) } */
    this.serviceWorkerContext;
    /** @type { (mojoBase_mojom_DictionaryValue|undefined) } */
    this.filter;
  }
}



mojo.internal.Struct(
    EventRouter_AddListenerForMainThread_ParamsSpec.$,
    'EventRouter_AddListenerForMainThread_Params',
    [
      mojo.internal.StructField(
        'eventListener', 0,
        0,
        EventListenerSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EventRouter_AddListenerForMainThread_Params {
  constructor() {
    /** @type { !EventListener } */
    this.eventListener;
  }
}



mojo.internal.Struct(
    EventRouter_AddListenerForServiceWorker_ParamsSpec.$,
    'EventRouter_AddListenerForServiceWorker_Params',
    [
      mojo.internal.StructField(
        'eventListener', 0,
        0,
        EventListenerSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EventRouter_AddListenerForServiceWorker_Params {
  constructor() {
    /** @type { !EventListener } */
    this.eventListener;
  }
}



mojo.internal.Struct(
    EventRouter_AddLazyListenerForMainThread_ParamsSpec.$,
    'EventRouter_AddLazyListenerForMainThread_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EventRouter_AddLazyListenerForMainThread_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !string } */
    this.eventName;
  }
}



mojo.internal.Struct(
    EventRouter_AddLazyListenerForServiceWorker_ParamsSpec.$,
    'EventRouter_AddLazyListenerForServiceWorker_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'workerScopeUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class EventRouter_AddLazyListenerForServiceWorker_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !url_mojom_Url } */
    this.workerScopeUrl;
    /** @type { !string } */
    this.eventName;
  }
}



mojo.internal.Struct(
    EventRouter_AddFilteredListenerForMainThread_ParamsSpec.$,
    'EventRouter_AddFilteredListenerForMainThread_Params',
    [
      mojo.internal.StructField(
        'listenerOwner', 0,
        0,
        EventListenerOwnerSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filter', 24,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'addLazyListener', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class EventRouter_AddFilteredListenerForMainThread_Params {
  constructor() {
    /** @type { !EventListenerOwner } */
    this.listenerOwner;
    /** @type { !string } */
    this.eventName;
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.filter;
    /** @type { !boolean } */
    this.addLazyListener;
  }
}



mojo.internal.Struct(
    EventRouter_AddFilteredListenerForServiceWorker_ParamsSpec.$,
    'EventRouter_AddFilteredListenerForServiceWorker_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerContext', 16,
        0,
        ServiceWorkerContextSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filter', 24,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'addLazyListener', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class EventRouter_AddFilteredListenerForServiceWorker_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !string } */
    this.eventName;
    /** @type { !ServiceWorkerContext } */
    this.serviceWorkerContext;
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.filter;
    /** @type { !boolean } */
    this.addLazyListener;
  }
}



mojo.internal.Struct(
    EventRouter_RemoveListenerForMainThread_ParamsSpec.$,
    'EventRouter_RemoveListenerForMainThread_Params',
    [
      mojo.internal.StructField(
        'eventListener', 0,
        0,
        EventListenerSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EventRouter_RemoveListenerForMainThread_Params {
  constructor() {
    /** @type { !EventListener } */
    this.eventListener;
  }
}



mojo.internal.Struct(
    EventRouter_RemoveListenerForServiceWorker_ParamsSpec.$,
    'EventRouter_RemoveListenerForServiceWorker_Params',
    [
      mojo.internal.StructField(
        'eventListener', 0,
        0,
        EventListenerSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EventRouter_RemoveListenerForServiceWorker_Params {
  constructor() {
    /** @type { !EventListener } */
    this.eventListener;
  }
}



mojo.internal.Struct(
    EventRouter_RemoveLazyListenerForMainThread_ParamsSpec.$,
    'EventRouter_RemoveLazyListenerForMainThread_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EventRouter_RemoveLazyListenerForMainThread_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !string } */
    this.eventName;
  }
}



mojo.internal.Struct(
    EventRouter_RemoveLazyListenerForServiceWorker_ParamsSpec.$,
    'EventRouter_RemoveLazyListenerForServiceWorker_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'workerScopeUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class EventRouter_RemoveLazyListenerForServiceWorker_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !url_mojom_Url } */
    this.workerScopeUrl;
    /** @type { !string } */
    this.eventName;
  }
}



mojo.internal.Struct(
    EventRouter_RemoveFilteredListenerForMainThread_ParamsSpec.$,
    'EventRouter_RemoveFilteredListenerForMainThread_Params',
    [
      mojo.internal.StructField(
        'listenerOwner', 0,
        0,
        EventListenerOwnerSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filter', 24,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'removeLazyListener', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class EventRouter_RemoveFilteredListenerForMainThread_Params {
  constructor() {
    /** @type { !EventListenerOwner } */
    this.listenerOwner;
    /** @type { !string } */
    this.eventName;
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.filter;
    /** @type { !boolean } */
    this.removeLazyListener;
  }
}



mojo.internal.Struct(
    EventRouter_RemoveFilteredListenerForServiceWorker_ParamsSpec.$,
    'EventRouter_RemoveFilteredListenerForServiceWorker_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerContext', 16,
        0,
        ServiceWorkerContextSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filter', 24,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'removeLazyListener', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class EventRouter_RemoveFilteredListenerForServiceWorker_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !string } */
    this.eventName;
    /** @type { !ServiceWorkerContext } */
    this.serviceWorkerContext;
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.filter;
    /** @type { !boolean } */
    this.removeLazyListener;
  }
}

mojo.internal.Union(
    EventListenerOwnerSpec.$, 'EventListenerOwner',
    {
      'extensionId': {
        'ordinal': 0,
        'type': extensions_mojom_ExtensionIdSpec.$,
      },
      'listenerUrl': {
        'ordinal': 1,
        'type': url_mojom_UrlSpec.$,
      },
    });

/**
 * @typedef { {
 *   extensionId: (!extensions_mojom_ExtensionId|undefined),
 *   listenerUrl: (!url_mojom_Url|undefined),
 * } }
 */
export const EventListenerOwner = {};
