// gpu/ipc/common/exported_shared_image.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'gpu/ipc/common/exported_shared_image.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gpu.mojom');
  var mailbox$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/mailbox.mojom', 'mailbox.mojom.js');
  }
  var shared_image_metadata$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/shared_image_metadata.mojom', 'shared_image_metadata.mojom.js');
  }
  var sync_token$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/sync_token.mojom', 'sync_token.mojom.js');
  }
  var buffer_types$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/buffer_types.mojom', '../../../ui/gfx/mojom/buffer_types.mojom.js');
  }



  function ExportedSharedImage(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ExportedSharedImage.prototype.initDefaults_ = function() {
    this.mailbox = null;
    this.metadata = null;
    this.creationSyncToken = null;
    this.debugLabel = null;
    this.bufferHandle = null;
    this.buffer_usage_$flag = false;
    this.buffer_usage_$value = 0;
    this.textureTarget = 0;
  };
  ExportedSharedImage.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ExportedSharedImage.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExportedSharedImage.mailbox
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, mailbox$.Mailbox, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExportedSharedImage.metadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, shared_image_metadata$.SharedImageMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExportedSharedImage.creationSyncToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, sync_token$.SyncToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExportedSharedImage.debugLabel
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExportedSharedImage.bufferHandle
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, buffer_types$.GpuMemoryBufferHandle, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ExportedSharedImage.buffer_usage_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 44, buffer_types$.BufferUsage);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ExportedSharedImage.encodedSize = codec.kStructHeaderSize + 56;

  ExportedSharedImage.decode = function(decoder) {
    var packed;
    var val = new ExportedSharedImage();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mailbox =
        decoder.decodeStructPointer(mailbox$.Mailbox);
    val.metadata =
        decoder.decodeStructPointer(shared_image_metadata$.SharedImageMetadata);
    val.creationSyncToken =
        decoder.decodeStructPointer(sync_token$.SyncToken);
    val.debugLabel =
        decoder.decodeStruct(codec.String);
    val.bufferHandle =
        decoder.decodeStructPointer(buffer_types$.GpuMemoryBufferHandle);
    packed = decoder.readUint8();
    val.buffer_usage_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.buffer_usage_$value =
        decoder.decodeStruct(new codec.Enum(buffer_types$.BufferUsage));
    val.textureTarget =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ExportedSharedImage.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ExportedSharedImage.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(mailbox$.Mailbox, val.mailbox);
    encoder.encodeStructPointer(shared_image_metadata$.SharedImageMetadata, val.metadata);
    encoder.encodeStructPointer(sync_token$.SyncToken, val.creationSyncToken);
    encoder.encodeStruct(codec.String, val.debugLabel);
    encoder.encodeStructPointer(buffer_types$.GpuMemoryBufferHandle, val.bufferHandle);
    packed = 0;
    packed |= (val.buffer_usage_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.buffer_usage_$value);
    encoder.encodeStruct(codec.Uint32, val.textureTarget);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.ExportedSharedImage = ExportedSharedImage;
})();