// gpu/ipc/common/gpu_info.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  GLImplementationParts as gl_mojom_GLImplementationParts,
  GLImplementationPartsSpec as gl_mojom_GLImplementationPartsSpec
} from '../../../ui/gl/mojom/gl_implementation.mojom.m.js';

import {
  GpuPreference as gl_mojom_GpuPreference,
  GpuPreferenceSpec as gl_mojom_GpuPreferenceSpec
} from '../../../ui/gl/mojom/gpu_preference.mojom.m.js';

import {
  VulkanInfo as gpu_mojom_VulkanInfo,
  VulkanInfoSpec as gpu_mojom_VulkanInfoSpec
} from './vulkan_info.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SkiaBackendTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SkiaBackendType = {
  
  kUnknown: 0,
  kNone: 1,
  kGaneshGL: 2,
  kGaneshVulkan: 3,
  kGraphiteDawnVulkan: 4,
  kGraphiteDawnMetal: 5,
  kGraphiteDawnD3D11: 6,
  kGraphiteDawnD3D12: 7,
  kGraphiteMetal: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoCodecProfileSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoCodecProfile = {
  
  VIDEO_CODEC_PROFILE_UNKNOWN: -1,
  H264PROFILE_BASELINE: 0,
  H264PROFILE_MAIN: 1,
  H264PROFILE_EXTENDED: 2,
  H264PROFILE_HIGH: 3,
  H264PROFILE_HIGH10PROFILE: 4,
  H264PROFILE_HIGH422PROFILE: 5,
  H264PROFILE_HIGH444PREDICTIVEPROFILE: 6,
  H264PROFILE_SCALABLEBASELINE: 7,
  H264PROFILE_SCALABLEHIGH: 8,
  H264PROFILE_STEREOHIGH: 9,
  H264PROFILE_MULTIVIEWHIGH: 10,
  VP8PROFILE_ANY: 11,
  VP9PROFILE_PROFILE0: 12,
  VP9PROFILE_PROFILE1: 13,
  VP9PROFILE_PROFILE2: 14,
  VP9PROFILE_PROFILE3: 15,
  HEVCPROFILE_MAIN: 16,
  HEVCPROFILE_MAIN10: 17,
  HEVCPROFILE_MAIN_STILL_PICTURE: 18,
  DOLBYVISION_PROFILE0: 19,
  DOLBYVISION_PROFILE5: 21,
  DOLBYVISION_PROFILE7: 22,
  THEORAPROFILE_ANY: 23,
  AV1PROFILE_PROFILE_MAIN: 24,
  AV1PROFILE_PROFILE_HIGH: 25,
  AV1PROFILE_PROFILE_PRO: 26,
  DOLBYVISION_PROFILE8: 27,
  DOLBYVISION_PROFILE9: 28,
  HEVCPROFILE_REXT: 29,
  HEVCPROFILE_HIGH_THROUGHPUT: 30,
  HEVCPROFILE_MULTIVIEW_MAIN: 31,
  HEVCPROFILE_SCALABLE_MAIN: 32,
  HEVCPROFILE_3D_MAIN: 33,
  HEVCPROFILE_SCREEN_EXTENDED: 34,
  HEVCPROFILE_SCALABLE_REXT: 35,
  HEVCPROFILE_HIGH_THROUGHPUT_SCREEN_EXTENDED: 36,
  VVCPROFILE_MAIN10: 37,
  VVCPROFILE_MAIN12: 38,
  VVCPROFILE_MAIN12_INTRA: 39,
  VVCPROIFLE_MULTILAYER_MAIN10: 40,
  VVCPROFILE_MAIN10_444: 41,
  VVCPROFILE_MAIN12_444: 42,
  VVCPROFILE_MAIN16_444: 43,
  VVCPROFILE_MAIN12_444_INTRA: 44,
  VVCPROFILE_MAIN16_444_INTRA: 45,
  VVCPROFILE_MULTILAYER_MAIN10_444: 46,
  VVCPROFILE_MAIN10_STILL_PICTURE: 47,
  VVCPROFILE_MAIN12_STILL_PICTURE: 48,
  VVCPROFILE_MAIN10_444_STILL_PICTURE: 49,
  VVCPROFILE_MAIN12_444_STILL_PICTURE: 50,
  VVCPROFILE_MAIN16_444_STILL_PICTURE: 51,
  MIN_VALUE: -1,
  MAX_VALUE: 51,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ImageDecodeAcceleratorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ImageDecodeAcceleratorType = {
  
  kJpeg: 0,
  kWebP: 1,
  kUnknown: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ImageDecodeAcceleratorSubsamplingSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ImageDecodeAcceleratorSubsampling = {
  
  k420: 0,
  k422: 1,
  k444: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GpuDeviceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecodeAcceleratorSupportedProfileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecodeAcceleratorCapabilitiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAcceleratorSupportedProfileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImageDecodeAcceleratorSupportedProfileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GpuInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    GpuDeviceSpec.$,
    'GpuDevice',
    [
      mojo.internal.StructField(
        'vendorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceId', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'active', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'vendorString', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceString', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'driverVendor', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'driverVersion', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'gpuPreference', 12,
        0,
        gl_mojom_GpuPreferenceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class GpuDevice {
  constructor() {
    /** @type { !number } */
    this.vendorId;
    /** @type { !number } */
    this.deviceId;
    /** @type { !boolean } */
    this.active;
    /** @type { !string } */
    this.vendorString;
    /** @type { !string } */
    this.deviceString;
    /** @type { !string } */
    this.driverVendor;
    /** @type { !string } */
    this.driverVersion;
    /** @type { !gl_mojom_GpuPreference } */
    this.gpuPreference;
  }
}



mojo.internal.Struct(
    VideoDecodeAcceleratorSupportedProfileSpec.$,
    'VideoDecodeAcceleratorSupportedProfile',
    [
      mojo.internal.StructField(
        'profile', 0,
        0,
        VideoCodecProfileSpec.$,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxResolution', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minResolution', 16,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encryptedOnly', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class VideoDecodeAcceleratorSupportedProfile {
  constructor() {
    /** @type { !VideoCodecProfile } */
    this.profile;
    /** @type { !gfx_mojom_Size } */
    this.maxResolution;
    /** @type { !gfx_mojom_Size } */
    this.minResolution;
    /** @type { !boolean } */
    this.encryptedOnly;
  }
}



mojo.internal.Struct(
    VideoDecodeAcceleratorCapabilitiesSpec.$,
    'VideoDecodeAcceleratorCapabilities',
    [
      mojo.internal.StructField(
        'supportedProfiles', 0,
        0,
        mojo.internal.Array(VideoDecodeAcceleratorSupportedProfileSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'flags', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoDecodeAcceleratorCapabilities {
  constructor() {
    /** @type { !Array<!VideoDecodeAcceleratorSupportedProfile> } */
    this.supportedProfiles;
    /** @type { !number } */
    this.flags;
  }
}



mojo.internal.Struct(
    VideoEncodeAcceleratorSupportedProfileSpec.$,
    'VideoEncodeAcceleratorSupportedProfile',
    [
      mojo.internal.StructField(
        'profile', 0,
        0,
        VideoCodecProfileSpec.$,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minResolution', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxResolution', 16,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFramerateNumerator', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFramerateDenominator', 24,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class VideoEncodeAcceleratorSupportedProfile {
  constructor() {
    /** @type { !VideoCodecProfile } */
    this.profile;
    /** @type { !gfx_mojom_Size } */
    this.minResolution;
    /** @type { !gfx_mojom_Size } */
    this.maxResolution;
    /** @type { !number } */
    this.maxFramerateNumerator;
    /** @type { !number } */
    this.maxFramerateDenominator;
  }
}



mojo.internal.Struct(
    ImageDecodeAcceleratorSupportedProfileSpec.$,
    'ImageDecodeAcceleratorSupportedProfile',
    [
      mojo.internal.StructField(
        'imageType', 0,
        0,
        ImageDecodeAcceleratorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minEncodedDimensions', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxEncodedDimensions', 16,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subsamplings', 24,
        0,
        mojo.internal.Array(ImageDecodeAcceleratorSubsamplingSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ImageDecodeAcceleratorSupportedProfile {
  constructor() {
    /** @type { !ImageDecodeAcceleratorType } */
    this.imageType;
    /** @type { !gfx_mojom_Size } */
    this.minEncodedDimensions;
    /** @type { !gfx_mojom_Size } */
    this.maxEncodedDimensions;
    /** @type { !Array<!ImageDecodeAcceleratorSubsampling> } */
    this.subsamplings;
  }
}



mojo.internal.Struct(
    GpuInfoSpec.$,
    'GpuInfo',
    [
      mojo.internal.StructField(
        'initializationTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'optimus', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'amdSwitchable', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'gpu', 16,
        0,
        GpuDeviceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'secondaryGpus', 24,
        0,
        mojo.internal.Array(GpuDeviceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'npus', 32,
        0,
        mojo.internal.Array(GpuDeviceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pixelShaderVersion', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'vertexShaderVersion', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxMsaaSamples', 56,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'machineModelName', 64,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'machineModelVersion', 72,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'displayType', 80,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'skiaBackendType', 12,
        0,
        SkiaBackendTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'glVersion', 88,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'glVendor', 96,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'glRenderer', 104,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'glExtensions', 112,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'glWsVendor', 120,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'glWsVersion', 128,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'glWsExtensions', 136,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'glResetNotificationStrategy', 144,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'glImplementationParts', 152,
        0,
        gl_mojom_GLImplementationPartsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directRenderingVersion', 160,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sandboxed', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inProcessGpu', 8,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'passthroughCmdDecoder', 8,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'canSupportThreadedTextureMailbox', 8,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoDecodeAcceleratorSupportedProfiles', 168,
        0,
        mojo.internal.Array(VideoDecodeAcceleratorSupportedProfileSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoEncodeAcceleratorSupportedProfiles', 176,
        0,
        mojo.internal.Array(VideoEncodeAcceleratorSupportedProfileSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'jpegDecodeAcceleratorSupported', 8,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subpixelFontRendering', 8,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'visibilityCallbackCallCount', 148,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hardwareSupportsVulkan', 9,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'vulkanInfo', 184,
        0,
        gpu_mojom_VulkanInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 200],]);



/**
 * @record
 */
export class GpuInfo {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.initializationTime;
    /** @type { !boolean } */
    this.optimus;
    /** @type { !boolean } */
    this.amdSwitchable;
    /** @type { !GpuDevice } */
    this.gpu;
    /** @type { !Array<!GpuDevice> } */
    this.secondaryGpus;
    /** @type { !Array<!GpuDevice> } */
    this.npus;
    /** @type { !string } */
    this.pixelShaderVersion;
    /** @type { !string } */
    this.vertexShaderVersion;
    /** @type { !string } */
    this.maxMsaaSamples;
    /** @type { !string } */
    this.machineModelName;
    /** @type { !string } */
    this.machineModelVersion;
    /** @type { !string } */
    this.displayType;
    /** @type { !SkiaBackendType } */
    this.skiaBackendType;
    /** @type { !string } */
    this.glVersion;
    /** @type { !string } */
    this.glVendor;
    /** @type { !string } */
    this.glRenderer;
    /** @type { !string } */
    this.glExtensions;
    /** @type { !string } */
    this.glWsVendor;
    /** @type { !string } */
    this.glWsVersion;
    /** @type { !string } */
    this.glWsExtensions;
    /** @type { !number } */
    this.glResetNotificationStrategy;
    /** @type { !gl_mojom_GLImplementationParts } */
    this.glImplementationParts;
    /** @type { !string } */
    this.directRenderingVersion;
    /** @type { !boolean } */
    this.sandboxed;
    /** @type { !boolean } */
    this.inProcessGpu;
    /** @type { !boolean } */
    this.passthroughCmdDecoder;
    /** @type { !boolean } */
    this.canSupportThreadedTextureMailbox;
    /** @type { !Array<!VideoDecodeAcceleratorSupportedProfile> } */
    this.videoDecodeAcceleratorSupportedProfiles;
    /** @type { !Array<!VideoEncodeAcceleratorSupportedProfile> } */
    this.videoEncodeAcceleratorSupportedProfiles;
    /** @type { !boolean } */
    this.jpegDecodeAcceleratorSupported;
    /** @type { !boolean } */
    this.subpixelFontRendering;
    /** @type { !number } */
    this.visibilityCallbackCallCount;
    /** @type { !boolean } */
    this.hardwareSupportsVulkan;
    /** @type { (gpu_mojom_VulkanInfo|undefined) } */
    this.vulkanInfo;
  }
}

