// gpu/ipc/common/gpu_preferences.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'gpu/ipc/common/gpu_preferences.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gpu.mojom');
  var message_pump_type$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/message_pump_type.mojom', '../../../mojo/public/mojom/base/message_pump_type.mojom.js');
  }
  var buffer_types$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/buffer_types.mojom', '../../../ui/gfx/mojom/buffer_types.mojom.js');
  }


  var VulkanImplementationName = {};
  VulkanImplementationName.kNone = 0;
  VulkanImplementationName.kNative = 1;
  VulkanImplementationName.kForcedNative = 2;
  VulkanImplementationName.kSwiftshader = 3;
  VulkanImplementationName.kLast = 3;
  VulkanImplementationName.MIN_VALUE = 0;
  VulkanImplementationName.MAX_VALUE = 3;

  VulkanImplementationName.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  VulkanImplementationName.toKnownEnumValue = function(value) {
    return value;
  };

  VulkanImplementationName.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WebGPUAdapterName = {};
  WebGPUAdapterName.kDefault = 0;
  WebGPUAdapterName.kD3D11 = 1;
  WebGPUAdapterName.kOpenGLES = 2;
  WebGPUAdapterName.kSwiftShader = 3;
  WebGPUAdapterName.MIN_VALUE = 0;
  WebGPUAdapterName.MAX_VALUE = 3;

  WebGPUAdapterName.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  WebGPUAdapterName.toKnownEnumValue = function(value) {
    return value;
  };

  WebGPUAdapterName.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WebGPUPowerPreference = {};
  WebGPUPowerPreference.kNone = 0;
  WebGPUPowerPreference.kDefaultLowPower = 1;
  WebGPUPowerPreference.kDefaultHighPerformance = 2;
  WebGPUPowerPreference.kForceLowPower = 3;
  WebGPUPowerPreference.kForceHighPerformance = 4;
  WebGPUPowerPreference.MIN_VALUE = 0;
  WebGPUPowerPreference.MAX_VALUE = 4;

  WebGPUPowerPreference.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  WebGPUPowerPreference.toKnownEnumValue = function(value) {
    return value;
  };

  WebGPUPowerPreference.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var GrContextType = {};
  GrContextType.kNone = 0;
  GrContextType.kGL = 1;
  GrContextType.kVulkan = 2;
  GrContextType.kGraphiteDawn = 3;
  GrContextType.kGraphiteMetal = 4;
  GrContextType.MIN_VALUE = 0;
  GrContextType.MAX_VALUE = 4;

  GrContextType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  GrContextType.toKnownEnumValue = function(value) {
    return value;
  };

  GrContextType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var DawnBackendValidationLevel = {};
  DawnBackendValidationLevel.kDisabled = 0;
  DawnBackendValidationLevel.kPartial = 1;
  DawnBackendValidationLevel.kFull = 2;
  DawnBackendValidationLevel.MIN_VALUE = 0;
  DawnBackendValidationLevel.MAX_VALUE = 2;

  DawnBackendValidationLevel.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  DawnBackendValidationLevel.toKnownEnumValue = function(value) {
    return value;
  };

  DawnBackendValidationLevel.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function GpuPreferences(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GpuPreferences.prototype.initDefaults_ = function() {
    this.disableAcceleratedVideoDecode = false;
    this.disableAcceleratedVideoEncode = false;
    this.gpuStartupDialog = false;
    this.disableGpuWatchdog = false;
    this.gpuSandboxStartEarly = false;
    this.enableLowLatencyDxva = false;
    this.enableZeroCopyDxgiVideo = false;
    this.enableNv12DxgiVideo = false;
    this.disableSoftwareRasterizer = false;
    this.logGpuControlListDecisions = false;
    this.compileShaderAlwaysSucceeds = false;
    this.disableGlErrorLimit = false;
    this.disableGlslTranslator = false;
    this.disableShaderNameHashing = false;
    this.enableGpuCommandLogging = false;
    this.enableGpuDebugging = false;
    this.enableGpuServiceLoggingGpu = false;
    this.enableGpuDriverDebugLogging = false;
    this.disableGpuProgramCache = false;
    this.enforceGlMinimums = false;
    this.disableGpuShaderDiskCache = false;
    this.enableThreadedTextureMailboxes = false;
    this.glShaderIntermOutput = false;
    this.performGraphitePrecompilation = false;
    this.enableGpuServiceLogging = false;
    this.enableGpuServiceTracing = false;
    this.usePassthroughCmdDecoder = false;
    this.ignoreGpuBlocklist = false;
    this.watchdogStartsBackgrounded = false;
    this.enableVulkanProtectedMemory = false;
    this.disableVulkanSurface = false;
    this.disableVulkanFallbackToGlForTesting = false;
    this.forceGpuMemDiscardableLimitBytes = 0;
    this.forceMaxTextureSize = 0;
    this.gpuProgramCacheSize = 0;
    this.grContextType = 0;
    this.useVulkan = 0;
    this.vulkanHeapMemoryLimit = 0;
    this.vulkanSyncCpuMemoryLimit = 0;
    this.enableGpuBenchmarkingExtension = false;
    this.enableWebgpu = false;
    this.enableUnsafeWebgpu = false;
    this.enableWebgpuDeveloperFeatures = false;
    this.enableWebgpuExperimentalFeatures = false;
    this.forceWebgpuCompat = false;
    this.enablePerfDataCollection = false;
    this.enableNativeGpuMemoryBuffers = false;
    this.forceSeparateEglDisplayForWebglTesting = false;
    this.useWebgpuAdapter = 0;
    this.useWebgpuPowerPreference = 0;
    this.enableDawnBackendValidation = 0;
    this.enabledDawnFeaturesList = null;
    this.disabledDawnFeaturesList = null;
    this.messagePumpType = 0;
  };
  GpuPreferences.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GpuPreferences.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


































    // validate GpuPreferences.grContextType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, GrContextType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GpuPreferences.useVulkan
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, VulkanImplementationName);
    if (err !== validator.validationError.NONE)
        return err;












    // validate GpuPreferences.useWebgpuAdapter
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, WebGPUAdapterName);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GpuPreferences.useWebgpuPowerPreference
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, WebGPUPowerPreference);
    if (err !== validator.validationError.NONE)
        return err;



    // validate GpuPreferences.enableDawnBackendValidation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 44, DawnBackendValidationLevel);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GpuPreferences.enabledDawnFeaturesList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GpuPreferences.disabledDawnFeaturesList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate GpuPreferences.messagePumpType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 64, message_pump_type$.MessagePumpType);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  GpuPreferences.encodedSize = codec.kStructHeaderSize + 72;

  GpuPreferences.decode = function(decoder) {
    var packed;
    var val = new GpuPreferences();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.disableAcceleratedVideoDecode = (packed >> 0) & 1 ? true : false;
    val.disableAcceleratedVideoEncode = (packed >> 1) & 1 ? true : false;
    val.gpuStartupDialog = (packed >> 2) & 1 ? true : false;
    val.disableGpuWatchdog = (packed >> 3) & 1 ? true : false;
    val.gpuSandboxStartEarly = (packed >> 4) & 1 ? true : false;
    val.enableLowLatencyDxva = (packed >> 5) & 1 ? true : false;
    val.enableZeroCopyDxgiVideo = (packed >> 6) & 1 ? true : false;
    val.enableNv12DxgiVideo = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.disableSoftwareRasterizer = (packed >> 0) & 1 ? true : false;
    val.logGpuControlListDecisions = (packed >> 1) & 1 ? true : false;
    val.compileShaderAlwaysSucceeds = (packed >> 2) & 1 ? true : false;
    val.disableGlErrorLimit = (packed >> 3) & 1 ? true : false;
    val.disableGlslTranslator = (packed >> 4) & 1 ? true : false;
    val.disableShaderNameHashing = (packed >> 5) & 1 ? true : false;
    val.enableGpuCommandLogging = (packed >> 6) & 1 ? true : false;
    val.enableGpuDebugging = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.enableGpuServiceLoggingGpu = (packed >> 0) & 1 ? true : false;
    val.enableGpuDriverDebugLogging = (packed >> 1) & 1 ? true : false;
    val.disableGpuProgramCache = (packed >> 2) & 1 ? true : false;
    val.enforceGlMinimums = (packed >> 3) & 1 ? true : false;
    val.disableGpuShaderDiskCache = (packed >> 4) & 1 ? true : false;
    val.enableThreadedTextureMailboxes = (packed >> 5) & 1 ? true : false;
    val.glShaderIntermOutput = (packed >> 6) & 1 ? true : false;
    val.performGraphitePrecompilation = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.enableGpuServiceLogging = (packed >> 0) & 1 ? true : false;
    val.enableGpuServiceTracing = (packed >> 1) & 1 ? true : false;
    val.usePassthroughCmdDecoder = (packed >> 2) & 1 ? true : false;
    val.ignoreGpuBlocklist = (packed >> 3) & 1 ? true : false;
    val.watchdogStartsBackgrounded = (packed >> 4) & 1 ? true : false;
    val.enableVulkanProtectedMemory = (packed >> 5) & 1 ? true : false;
    val.disableVulkanSurface = (packed >> 6) & 1 ? true : false;
    val.disableVulkanFallbackToGlForTesting = (packed >> 7) & 1 ? true : false;
    val.forceGpuMemDiscardableLimitBytes =
        decoder.decodeStruct(codec.Uint32);
    val.forceMaxTextureSize =
        decoder.decodeStruct(codec.Uint32);
    val.gpuProgramCacheSize =
        decoder.decodeStruct(codec.Uint32);
    val.grContextType =
        decoder.decodeStruct(new codec.Enum(GrContextType));
    val.useVulkan =
        decoder.decodeStruct(new codec.Enum(VulkanImplementationName));
    val.vulkanHeapMemoryLimit =
        decoder.decodeStruct(codec.Uint32);
    val.vulkanSyncCpuMemoryLimit =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.enableGpuBenchmarkingExtension = (packed >> 0) & 1 ? true : false;
    val.enableWebgpu = (packed >> 1) & 1 ? true : false;
    val.enableUnsafeWebgpu = (packed >> 2) & 1 ? true : false;
    val.enableWebgpuDeveloperFeatures = (packed >> 3) & 1 ? true : false;
    val.enableWebgpuExperimentalFeatures = (packed >> 4) & 1 ? true : false;
    val.forceWebgpuCompat = (packed >> 5) & 1 ? true : false;
    val.enablePerfDataCollection = (packed >> 6) & 1 ? true : false;
    val.enableNativeGpuMemoryBuffers = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.forceSeparateEglDisplayForWebglTesting = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    val.useWebgpuAdapter =
        decoder.decodeStruct(new codec.Enum(WebGPUAdapterName));
    val.useWebgpuPowerPreference =
        decoder.decodeStruct(new codec.Enum(WebGPUPowerPreference));
    val.enableDawnBackendValidation =
        decoder.decodeStruct(new codec.Enum(DawnBackendValidationLevel));
    val.enabledDawnFeaturesList =
        decoder.decodeArrayPointer(codec.String);
    val.disabledDawnFeaturesList =
        decoder.decodeArrayPointer(codec.String);
    val.messagePumpType =
        decoder.decodeStruct(new codec.Enum(message_pump_type$.MessagePumpType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GpuPreferences.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GpuPreferences.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.disableAcceleratedVideoDecode & 1) << 0
    packed |= (val.disableAcceleratedVideoEncode & 1) << 1
    packed |= (val.gpuStartupDialog & 1) << 2
    packed |= (val.disableGpuWatchdog & 1) << 3
    packed |= (val.gpuSandboxStartEarly & 1) << 4
    packed |= (val.enableLowLatencyDxva & 1) << 5
    packed |= (val.enableZeroCopyDxgiVideo & 1) << 6
    packed |= (val.enableNv12DxgiVideo & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.disableSoftwareRasterizer & 1) << 0
    packed |= (val.logGpuControlListDecisions & 1) << 1
    packed |= (val.compileShaderAlwaysSucceeds & 1) << 2
    packed |= (val.disableGlErrorLimit & 1) << 3
    packed |= (val.disableGlslTranslator & 1) << 4
    packed |= (val.disableShaderNameHashing & 1) << 5
    packed |= (val.enableGpuCommandLogging & 1) << 6
    packed |= (val.enableGpuDebugging & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.enableGpuServiceLoggingGpu & 1) << 0
    packed |= (val.enableGpuDriverDebugLogging & 1) << 1
    packed |= (val.disableGpuProgramCache & 1) << 2
    packed |= (val.enforceGlMinimums & 1) << 3
    packed |= (val.disableGpuShaderDiskCache & 1) << 4
    packed |= (val.enableThreadedTextureMailboxes & 1) << 5
    packed |= (val.glShaderIntermOutput & 1) << 6
    packed |= (val.performGraphitePrecompilation & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.enableGpuServiceLogging & 1) << 0
    packed |= (val.enableGpuServiceTracing & 1) << 1
    packed |= (val.usePassthroughCmdDecoder & 1) << 2
    packed |= (val.ignoreGpuBlocklist & 1) << 3
    packed |= (val.watchdogStartsBackgrounded & 1) << 4
    packed |= (val.enableVulkanProtectedMemory & 1) << 5
    packed |= (val.disableVulkanSurface & 1) << 6
    packed |= (val.disableVulkanFallbackToGlForTesting & 1) << 7
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint32, val.forceGpuMemDiscardableLimitBytes);
    encoder.encodeStruct(codec.Uint32, val.forceMaxTextureSize);
    encoder.encodeStruct(codec.Uint32, val.gpuProgramCacheSize);
    encoder.encodeStruct(codec.Int32, val.grContextType);
    encoder.encodeStruct(codec.Int32, val.useVulkan);
    encoder.encodeStruct(codec.Uint32, val.vulkanHeapMemoryLimit);
    encoder.encodeStruct(codec.Uint32, val.vulkanSyncCpuMemoryLimit);
    packed = 0;
    packed |= (val.enableGpuBenchmarkingExtension & 1) << 0
    packed |= (val.enableWebgpu & 1) << 1
    packed |= (val.enableUnsafeWebgpu & 1) << 2
    packed |= (val.enableWebgpuDeveloperFeatures & 1) << 3
    packed |= (val.enableWebgpuExperimentalFeatures & 1) << 4
    packed |= (val.forceWebgpuCompat & 1) << 5
    packed |= (val.enablePerfDataCollection & 1) << 6
    packed |= (val.enableNativeGpuMemoryBuffers & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.forceSeparateEglDisplayForWebglTesting & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.useWebgpuAdapter);
    encoder.encodeStruct(codec.Int32, val.useWebgpuPowerPreference);
    encoder.encodeStruct(codec.Int32, val.enableDawnBackendValidation);
    encoder.encodeArrayPointer(codec.String, val.enabledDawnFeaturesList);
    encoder.encodeArrayPointer(codec.String, val.disabledDawnFeaturesList);
    encoder.encodeStruct(codec.Int32, val.messagePumpType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.VulkanImplementationName = VulkanImplementationName;
  exports.WebGPUAdapterName = WebGPUAdapterName;
  exports.WebGPUPowerPreference = WebGPUPowerPreference;
  exports.GrContextType = GrContextType;
  exports.DawnBackendValidationLevel = DawnBackendValidationLevel;
  exports.GpuPreferences = GpuPreferences;
})();