// gpu/ipc/common/shared_image_pool_client_interface.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'gpu/ipc/common/shared_image_pool_client_interface.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gpu.mojom');



  function SharedImagePoolClientInterface_OnClearPool_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedImagePoolClientInterface_OnClearPool_Params.prototype.initDefaults_ = function() {
  };
  SharedImagePoolClientInterface_OnClearPool_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedImagePoolClientInterface_OnClearPool_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedImagePoolClientInterface_OnClearPool_Params.encodedSize = codec.kStructHeaderSize + 0;

  SharedImagePoolClientInterface_OnClearPool_Params.decode = function(decoder) {
    var packed;
    var val = new SharedImagePoolClientInterface_OnClearPool_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SharedImagePoolClientInterface_OnClearPool_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedImagePoolClientInterface_OnClearPool_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kSharedImagePoolClientInterface_OnClearPool_Name = 0;

  function SharedImagePoolClientInterfacePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SharedImagePoolClientInterface,
                                                   handleOrPtrInfo);
  }

  function SharedImagePoolClientInterfaceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SharedImagePoolClientInterface, associatedInterfacePtrInfo);
  }

  SharedImagePoolClientInterfaceAssociatedPtr.prototype =
      Object.create(SharedImagePoolClientInterfacePtr.prototype);
  SharedImagePoolClientInterfaceAssociatedPtr.prototype.constructor =
      SharedImagePoolClientInterfaceAssociatedPtr;

  function SharedImagePoolClientInterfaceProxy(receiver) {
    this.receiver_ = receiver;
  }
  SharedImagePoolClientInterfacePtr.prototype.onClearPool = function() {
    return SharedImagePoolClientInterfaceProxy.prototype.onClearPool
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedImagePoolClientInterfaceProxy.prototype.onClearPool = function() {
    var params_ = new SharedImagePoolClientInterface_OnClearPool_Params();
    var builder = new codec.MessageV0Builder(
        kSharedImagePoolClientInterface_OnClearPool_Name,
        codec.align(SharedImagePoolClientInterface_OnClearPool_Params.encodedSize));
    builder.encodeStruct(SharedImagePoolClientInterface_OnClearPool_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SharedImagePoolClientInterfaceStub(delegate) {
    this.delegate_ = delegate;
  }
  SharedImagePoolClientInterfaceStub.prototype.onClearPool = function() {
    return this.delegate_ && this.delegate_.onClearPool && this.delegate_.onClearPool();
  }

  SharedImagePoolClientInterfaceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSharedImagePoolClientInterface_OnClearPool_Name:
      var params = reader.decodeStruct(SharedImagePoolClientInterface_OnClearPool_Params);
      this.onClearPool();
      return true;
    default:
      return false;
    }
  };

  SharedImagePoolClientInterfaceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSharedImagePoolClientInterfaceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSharedImagePoolClientInterface_OnClearPool_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SharedImagePoolClientInterface_OnClearPool_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSharedImagePoolClientInterfaceResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SharedImagePoolClientInterface = {
    name: 'gpu.mojom.SharedImagePoolClientInterface',
    kVersion: 0,
    ptrClass: SharedImagePoolClientInterfacePtr,
    proxyClass: SharedImagePoolClientInterfaceProxy,
    stubClass: SharedImagePoolClientInterfaceStub,
    validateRequest: validateSharedImagePoolClientInterfaceRequest,
    validateResponse: null,
  };
  SharedImagePoolClientInterfaceStub.prototype.validator = validateSharedImagePoolClientInterfaceRequest;
  SharedImagePoolClientInterfaceProxy.prototype.validator = null;
  exports.SharedImagePoolClientInterface = SharedImagePoolClientInterface;
  exports.SharedImagePoolClientInterfacePtr = SharedImagePoolClientInterfacePtr;
  exports.SharedImagePoolClientInterfaceAssociatedPtr = SharedImagePoolClientInterfaceAssociatedPtr;
})();