// gpu/ipc/common/vulkan_types.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'gpu/ipc/common/vulkan_types.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gpu.mojom');


  var VkPhysicalDeviceType = {};
  VkPhysicalDeviceType.OTHER = 0;
  VkPhysicalDeviceType.INTEGRATED_GPU = 1;
  VkPhysicalDeviceType.DISCRETE_GPU = 2;
  VkPhysicalDeviceType.VIRTUAL_GPU = 3;
  VkPhysicalDeviceType.CPU = 4;
  VkPhysicalDeviceType.INVALID_VALUE = -1;
  VkPhysicalDeviceType.MIN_VALUE = -1;
  VkPhysicalDeviceType.MAX_VALUE = 4;

  VkPhysicalDeviceType.isKnownEnumValue = function(value) {
    switch (value) {
    case -1:
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  VkPhysicalDeviceType.toKnownEnumValue = function(value) {
    return value;
  };

  VkPhysicalDeviceType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function VkExtensionProperties(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VkExtensionProperties.prototype.initDefaults_ = function() {
    this.extensionName = null;
    this.specVersion = 0;
  };
  VkExtensionProperties.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VkExtensionProperties.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VkExtensionProperties.extensionName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VkExtensionProperties.encodedSize = codec.kStructHeaderSize + 16;

  VkExtensionProperties.decode = function(decoder) {
    var packed;
    var val = new VkExtensionProperties();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionName =
        decoder.decodeStruct(codec.String);
    val.specVersion =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VkExtensionProperties.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VkExtensionProperties.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.extensionName);
    encoder.encodeStruct(codec.Uint32, val.specVersion);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VkLayerProperties(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VkLayerProperties.prototype.initDefaults_ = function() {
    this.layerName = null;
    this.specVersion = 0;
    this.implementationVersion = 0;
    this.description = null;
  };
  VkLayerProperties.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VkLayerProperties.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VkLayerProperties.layerName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate VkLayerProperties.description
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VkLayerProperties.encodedSize = codec.kStructHeaderSize + 24;

  VkLayerProperties.decode = function(decoder) {
    var packed;
    var val = new VkLayerProperties();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.layerName =
        decoder.decodeStruct(codec.String);
    val.specVersion =
        decoder.decodeStruct(codec.Uint32);
    val.implementationVersion =
        decoder.decodeStruct(codec.Uint32);
    val.description =
        decoder.decodeStruct(codec.String);
    return val;
  };

  VkLayerProperties.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VkLayerProperties.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.layerName);
    encoder.encodeStruct(codec.Uint32, val.specVersion);
    encoder.encodeStruct(codec.Uint32, val.implementationVersion);
    encoder.encodeStruct(codec.String, val.description);
  };
  function VkPhysicalDeviceLimits(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VkPhysicalDeviceLimits.prototype.initDefaults_ = function() {
    this.maxImageDimension1D = 0;
    this.maxImageDimension2D = 0;
    this.maxImageDimension3D = 0;
    this.maxImageDimensionCube = 0;
    this.maxImageArrayLayers = 0;
    this.maxTexelBufferElements = 0;
    this.maxUniformBufferRange = 0;
    this.maxStorageBufferRange = 0;
    this.maxPushConstantsSize = 0;
    this.maxMemoryAllocationCount = 0;
    this.maxSamplerAllocationCount = 0;
    this.maxBoundDescriptorSets = 0;
    this.bufferImageGranularity = 0;
    this.sparseAddressSpaceSize = 0;
    this.maxPerStageDescriptorSamplers = 0;
    this.maxPerStageDescriptorUniformBuffers = 0;
    this.maxPerStageDescriptorStorageBuffers = 0;
    this.maxPerStageDescriptorSampledImages = 0;
    this.maxPerStageDescriptorStorageImages = 0;
    this.maxPerStageDescriptorInputAttachments = 0;
    this.maxPerStageResources = 0;
    this.maxDescriptorSetSamplers = 0;
    this.maxDescriptorSetUniformBuffers = 0;
    this.maxDescriptorSetUniformBuffersDynamic = 0;
    this.maxDescriptorSetStorageBuffers = 0;
    this.maxDescriptorSetStorageBuffersDynamic = 0;
    this.maxDescriptorSetSampledImages = 0;
    this.maxDescriptorSetStorageImages = 0;
    this.maxDescriptorSetInputAttachments = 0;
    this.maxVertexInputAttributes = 0;
    this.maxVertexInputBindings = 0;
    this.maxVertexInputAttributeOffset = 0;
    this.maxVertexInputBindingStride = 0;
    this.maxVertexOutputComponents = 0;
    this.maxTessellationGenerationLevel = 0;
    this.maxTessellationPatchSize = 0;
    this.maxTessellationControlPerVertexInputComponents = 0;
    this.maxTessellationControlPerVertexOutputComponents = 0;
    this.maxTessellationControlPerPatchOutputComponents = 0;
    this.maxTessellationControlTotalOutputComponents = 0;
    this.maxTessellationEvaluationInputComponents = 0;
    this.maxTessellationEvaluationOutputComponents = 0;
    this.maxGeometryShaderInvocations = 0;
    this.maxGeometryInputComponents = 0;
    this.maxGeometryOutputComponents = 0;
    this.maxGeometryOutputVertices = 0;
    this.maxGeometryTotalOutputComponents = 0;
    this.maxFragmentInputComponents = 0;
    this.maxFragmentOutputAttachments = 0;
    this.maxFragmentDualSrcAttachments = 0;
    this.maxFragmentCombinedOutputResources = 0;
    this.maxComputeSharedMemorySize = 0;
    this.maxComputeWorkGroupCount = null;
    this.maxComputeWorkGroupInvocations = 0;
    this.subPixelPrecisionBits = 0;
    this.maxComputeWorkGroupSize = null;
    this.subTexelPrecisionBits = 0;
    this.mipmapPrecisionBits = 0;
    this.maxDrawIndexedIndexValue = 0;
    this.maxDrawIndirectCount = 0;
    this.maxSamplerLodBias = 0;
    this.maxSamplerAnisotropy = 0;
    this.maxViewports = 0;
    this.viewportSubPixelBits = 0;
    this.maxViewportDimensions = null;
    this.viewportBoundsRange = null;
    this.minMemoryMapAlignment = 0;
    this.minTexelBufferOffsetAlignment = 0;
    this.minUniformBufferOffsetAlignment = 0;
    this.minStorageBufferOffsetAlignment = 0;
    this.minTexelOffset = 0;
    this.maxTexelOffset = 0;
    this.minTexelGatherOffset = 0;
    this.maxTexelGatherOffset = 0;
    this.minInterpolationOffset = 0;
    this.maxInterpolationOffset = 0;
    this.subPixelInterpolationOffsetBits = 0;
    this.maxFramebufferWidth = 0;
    this.maxFramebufferHeight = 0;
    this.maxFramebufferLayers = 0;
    this.framebufferColorSampleCounts = 0;
    this.framebufferDepthSampleCounts = 0;
    this.framebufferStencilSampleCounts = 0;
    this.framebufferNoAttachmentsSampleCounts = 0;
    this.maxColorAttachments = 0;
    this.sampledImageColorSampleCounts = 0;
    this.sampledImageIntegerSampleCounts = 0;
    this.sampledImageDepthSampleCounts = 0;
    this.sampledImageStencilSampleCounts = 0;
    this.storageImageSampleCounts = 0;
    this.maxSampleMaskWords = 0;
    this.timestampComputeAndGraphics = false;
    this.strictLines = false;
    this.standardSampleLocations = false;
    this.timestampPeriod = 0;
    this.maxClipDistances = 0;
    this.maxCullDistances = 0;
    this.maxCombinedClipAndCullDistances = 0;
    this.discreteQueuePriorities = 0;
    this.pointSizeGranularity = 0;
    this.pointSizeRange = null;
    this.lineWidthRange = null;
    this.lineWidthGranularity = 0;
    this.optimalBufferCopyOffsetAlignment = 0;
    this.optimalBufferCopyRowPitchAlignment = 0;
    this.nonCoherentAtomSize = 0;
  };
  VkPhysicalDeviceLimits.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VkPhysicalDeviceLimits.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 488}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






















































    // validate VkPhysicalDeviceLimits.maxComputeWorkGroupCount
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 216, 4, codec.Uint32, false, [3], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VkPhysicalDeviceLimits.maxComputeWorkGroupSize
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 232, 4, codec.Uint32, false, [3], 0);
    if (err !== validator.validationError.NONE)
        return err;










    // validate VkPhysicalDeviceLimits.maxViewportDimensions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 272, 4, codec.Uint32, false, [2], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VkPhysicalDeviceLimits.viewportBoundsRange
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 280, 4, codec.Float, false, [2], 0);
    if (err !== validator.validationError.NONE)
        return err;


































    // validate VkPhysicalDeviceLimits.pointSizeRange
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 432, 4, codec.Float, false, [2], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VkPhysicalDeviceLimits.lineWidthRange
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 440, 4, codec.Float, false, [2], 0);
    if (err !== validator.validationError.NONE)
        return err;








    return validator.validationError.NONE;
  };

  VkPhysicalDeviceLimits.encodedSize = codec.kStructHeaderSize + 480;

  VkPhysicalDeviceLimits.decode = function(decoder) {
    var packed;
    var val = new VkPhysicalDeviceLimits();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.maxImageDimension1D =
        decoder.decodeStruct(codec.Uint32);
    val.maxImageDimension2D =
        decoder.decodeStruct(codec.Uint32);
    val.maxImageDimension3D =
        decoder.decodeStruct(codec.Uint32);
    val.maxImageDimensionCube =
        decoder.decodeStruct(codec.Uint32);
    val.maxImageArrayLayers =
        decoder.decodeStruct(codec.Uint32);
    val.maxTexelBufferElements =
        decoder.decodeStruct(codec.Uint32);
    val.maxUniformBufferRange =
        decoder.decodeStruct(codec.Uint32);
    val.maxStorageBufferRange =
        decoder.decodeStruct(codec.Uint32);
    val.maxPushConstantsSize =
        decoder.decodeStruct(codec.Uint32);
    val.maxMemoryAllocationCount =
        decoder.decodeStruct(codec.Uint32);
    val.maxSamplerAllocationCount =
        decoder.decodeStruct(codec.Uint32);
    val.maxBoundDescriptorSets =
        decoder.decodeStruct(codec.Uint32);
    val.bufferImageGranularity =
        decoder.decodeStruct(codec.Uint64);
    val.sparseAddressSpaceSize =
        decoder.decodeStruct(codec.Uint64);
    val.maxPerStageDescriptorSamplers =
        decoder.decodeStruct(codec.Uint32);
    val.maxPerStageDescriptorUniformBuffers =
        decoder.decodeStruct(codec.Uint32);
    val.maxPerStageDescriptorStorageBuffers =
        decoder.decodeStruct(codec.Uint32);
    val.maxPerStageDescriptorSampledImages =
        decoder.decodeStruct(codec.Uint32);
    val.maxPerStageDescriptorStorageImages =
        decoder.decodeStruct(codec.Uint32);
    val.maxPerStageDescriptorInputAttachments =
        decoder.decodeStruct(codec.Uint32);
    val.maxPerStageResources =
        decoder.decodeStruct(codec.Uint32);
    val.maxDescriptorSetSamplers =
        decoder.decodeStruct(codec.Uint32);
    val.maxDescriptorSetUniformBuffers =
        decoder.decodeStruct(codec.Uint32);
    val.maxDescriptorSetUniformBuffersDynamic =
        decoder.decodeStruct(codec.Uint32);
    val.maxDescriptorSetStorageBuffers =
        decoder.decodeStruct(codec.Uint32);
    val.maxDescriptorSetStorageBuffersDynamic =
        decoder.decodeStruct(codec.Uint32);
    val.maxDescriptorSetSampledImages =
        decoder.decodeStruct(codec.Uint32);
    val.maxDescriptorSetStorageImages =
        decoder.decodeStruct(codec.Uint32);
    val.maxDescriptorSetInputAttachments =
        decoder.decodeStruct(codec.Uint32);
    val.maxVertexInputAttributes =
        decoder.decodeStruct(codec.Uint32);
    val.maxVertexInputBindings =
        decoder.decodeStruct(codec.Uint32);
    val.maxVertexInputAttributeOffset =
        decoder.decodeStruct(codec.Uint32);
    val.maxVertexInputBindingStride =
        decoder.decodeStruct(codec.Uint32);
    val.maxVertexOutputComponents =
        decoder.decodeStruct(codec.Uint32);
    val.maxTessellationGenerationLevel =
        decoder.decodeStruct(codec.Uint32);
    val.maxTessellationPatchSize =
        decoder.decodeStruct(codec.Uint32);
    val.maxTessellationControlPerVertexInputComponents =
        decoder.decodeStruct(codec.Uint32);
    val.maxTessellationControlPerVertexOutputComponents =
        decoder.decodeStruct(codec.Uint32);
    val.maxTessellationControlPerPatchOutputComponents =
        decoder.decodeStruct(codec.Uint32);
    val.maxTessellationControlTotalOutputComponents =
        decoder.decodeStruct(codec.Uint32);
    val.maxTessellationEvaluationInputComponents =
        decoder.decodeStruct(codec.Uint32);
    val.maxTessellationEvaluationOutputComponents =
        decoder.decodeStruct(codec.Uint32);
    val.maxGeometryShaderInvocations =
        decoder.decodeStruct(codec.Uint32);
    val.maxGeometryInputComponents =
        decoder.decodeStruct(codec.Uint32);
    val.maxGeometryOutputComponents =
        decoder.decodeStruct(codec.Uint32);
    val.maxGeometryOutputVertices =
        decoder.decodeStruct(codec.Uint32);
    val.maxGeometryTotalOutputComponents =
        decoder.decodeStruct(codec.Uint32);
    val.maxFragmentInputComponents =
        decoder.decodeStruct(codec.Uint32);
    val.maxFragmentOutputAttachments =
        decoder.decodeStruct(codec.Uint32);
    val.maxFragmentDualSrcAttachments =
        decoder.decodeStruct(codec.Uint32);
    val.maxFragmentCombinedOutputResources =
        decoder.decodeStruct(codec.Uint32);
    val.maxComputeSharedMemorySize =
        decoder.decodeStruct(codec.Uint32);
    val.maxComputeWorkGroupCount =
        decoder.decodeArrayPointer(codec.Uint32);
    val.maxComputeWorkGroupInvocations =
        decoder.decodeStruct(codec.Uint32);
    val.subPixelPrecisionBits =
        decoder.decodeStruct(codec.Uint32);
    val.maxComputeWorkGroupSize =
        decoder.decodeArrayPointer(codec.Uint32);
    val.subTexelPrecisionBits =
        decoder.decodeStruct(codec.Uint32);
    val.mipmapPrecisionBits =
        decoder.decodeStruct(codec.Uint32);
    val.maxDrawIndexedIndexValue =
        decoder.decodeStruct(codec.Uint32);
    val.maxDrawIndirectCount =
        decoder.decodeStruct(codec.Uint32);
    val.maxSamplerLodBias =
        decoder.decodeStruct(codec.Float);
    val.maxSamplerAnisotropy =
        decoder.decodeStruct(codec.Float);
    val.maxViewports =
        decoder.decodeStruct(codec.Uint32);
    val.viewportSubPixelBits =
        decoder.decodeStruct(codec.Uint32);
    val.maxViewportDimensions =
        decoder.decodeArrayPointer(codec.Uint32);
    val.viewportBoundsRange =
        decoder.decodeArrayPointer(codec.Float);
    val.minMemoryMapAlignment =
        decoder.decodeStruct(codec.Uint64);
    val.minTexelBufferOffsetAlignment =
        decoder.decodeStruct(codec.Uint64);
    val.minUniformBufferOffsetAlignment =
        decoder.decodeStruct(codec.Uint64);
    val.minStorageBufferOffsetAlignment =
        decoder.decodeStruct(codec.Uint64);
    val.minTexelOffset =
        decoder.decodeStruct(codec.Int32);
    val.maxTexelOffset =
        decoder.decodeStruct(codec.Uint32);
    val.minTexelGatherOffset =
        decoder.decodeStruct(codec.Int32);
    val.maxTexelGatherOffset =
        decoder.decodeStruct(codec.Uint32);
    val.minInterpolationOffset =
        decoder.decodeStruct(codec.Float);
    val.maxInterpolationOffset =
        decoder.decodeStruct(codec.Float);
    val.subPixelInterpolationOffsetBits =
        decoder.decodeStruct(codec.Uint32);
    val.maxFramebufferWidth =
        decoder.decodeStruct(codec.Uint32);
    val.maxFramebufferHeight =
        decoder.decodeStruct(codec.Uint32);
    val.maxFramebufferLayers =
        decoder.decodeStruct(codec.Uint32);
    val.framebufferColorSampleCounts =
        decoder.decodeStruct(codec.Uint32);
    val.framebufferDepthSampleCounts =
        decoder.decodeStruct(codec.Uint32);
    val.framebufferStencilSampleCounts =
        decoder.decodeStruct(codec.Uint32);
    val.framebufferNoAttachmentsSampleCounts =
        decoder.decodeStruct(codec.Uint32);
    val.maxColorAttachments =
        decoder.decodeStruct(codec.Uint32);
    val.sampledImageColorSampleCounts =
        decoder.decodeStruct(codec.Uint32);
    val.sampledImageIntegerSampleCounts =
        decoder.decodeStruct(codec.Uint32);
    val.sampledImageDepthSampleCounts =
        decoder.decodeStruct(codec.Uint32);
    val.sampledImageStencilSampleCounts =
        decoder.decodeStruct(codec.Uint32);
    val.storageImageSampleCounts =
        decoder.decodeStruct(codec.Uint32);
    val.maxSampleMaskWords =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.timestampComputeAndGraphics = (packed >> 0) & 1 ? true : false;
    val.strictLines = (packed >> 1) & 1 ? true : false;
    val.standardSampleLocations = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.timestampPeriod =
        decoder.decodeStruct(codec.Float);
    val.maxClipDistances =
        decoder.decodeStruct(codec.Uint32);
    val.maxCullDistances =
        decoder.decodeStruct(codec.Uint32);
    val.maxCombinedClipAndCullDistances =
        decoder.decodeStruct(codec.Uint32);
    val.discreteQueuePriorities =
        decoder.decodeStruct(codec.Uint32);
    val.pointSizeGranularity =
        decoder.decodeStruct(codec.Float);
    val.pointSizeRange =
        decoder.decodeArrayPointer(codec.Float);
    val.lineWidthRange =
        decoder.decodeArrayPointer(codec.Float);
    val.lineWidthGranularity =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optimalBufferCopyOffsetAlignment =
        decoder.decodeStruct(codec.Uint64);
    val.optimalBufferCopyRowPitchAlignment =
        decoder.decodeStruct(codec.Uint64);
    val.nonCoherentAtomSize =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  VkPhysicalDeviceLimits.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VkPhysicalDeviceLimits.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.maxImageDimension1D);
    encoder.encodeStruct(codec.Uint32, val.maxImageDimension2D);
    encoder.encodeStruct(codec.Uint32, val.maxImageDimension3D);
    encoder.encodeStruct(codec.Uint32, val.maxImageDimensionCube);
    encoder.encodeStruct(codec.Uint32, val.maxImageArrayLayers);
    encoder.encodeStruct(codec.Uint32, val.maxTexelBufferElements);
    encoder.encodeStruct(codec.Uint32, val.maxUniformBufferRange);
    encoder.encodeStruct(codec.Uint32, val.maxStorageBufferRange);
    encoder.encodeStruct(codec.Uint32, val.maxPushConstantsSize);
    encoder.encodeStruct(codec.Uint32, val.maxMemoryAllocationCount);
    encoder.encodeStruct(codec.Uint32, val.maxSamplerAllocationCount);
    encoder.encodeStruct(codec.Uint32, val.maxBoundDescriptorSets);
    encoder.encodeStruct(codec.Uint64, val.bufferImageGranularity);
    encoder.encodeStruct(codec.Uint64, val.sparseAddressSpaceSize);
    encoder.encodeStruct(codec.Uint32, val.maxPerStageDescriptorSamplers);
    encoder.encodeStruct(codec.Uint32, val.maxPerStageDescriptorUniformBuffers);
    encoder.encodeStruct(codec.Uint32, val.maxPerStageDescriptorStorageBuffers);
    encoder.encodeStruct(codec.Uint32, val.maxPerStageDescriptorSampledImages);
    encoder.encodeStruct(codec.Uint32, val.maxPerStageDescriptorStorageImages);
    encoder.encodeStruct(codec.Uint32, val.maxPerStageDescriptorInputAttachments);
    encoder.encodeStruct(codec.Uint32, val.maxPerStageResources);
    encoder.encodeStruct(codec.Uint32, val.maxDescriptorSetSamplers);
    encoder.encodeStruct(codec.Uint32, val.maxDescriptorSetUniformBuffers);
    encoder.encodeStruct(codec.Uint32, val.maxDescriptorSetUniformBuffersDynamic);
    encoder.encodeStruct(codec.Uint32, val.maxDescriptorSetStorageBuffers);
    encoder.encodeStruct(codec.Uint32, val.maxDescriptorSetStorageBuffersDynamic);
    encoder.encodeStruct(codec.Uint32, val.maxDescriptorSetSampledImages);
    encoder.encodeStruct(codec.Uint32, val.maxDescriptorSetStorageImages);
    encoder.encodeStruct(codec.Uint32, val.maxDescriptorSetInputAttachments);
    encoder.encodeStruct(codec.Uint32, val.maxVertexInputAttributes);
    encoder.encodeStruct(codec.Uint32, val.maxVertexInputBindings);
    encoder.encodeStruct(codec.Uint32, val.maxVertexInputAttributeOffset);
    encoder.encodeStruct(codec.Uint32, val.maxVertexInputBindingStride);
    encoder.encodeStruct(codec.Uint32, val.maxVertexOutputComponents);
    encoder.encodeStruct(codec.Uint32, val.maxTessellationGenerationLevel);
    encoder.encodeStruct(codec.Uint32, val.maxTessellationPatchSize);
    encoder.encodeStruct(codec.Uint32, val.maxTessellationControlPerVertexInputComponents);
    encoder.encodeStruct(codec.Uint32, val.maxTessellationControlPerVertexOutputComponents);
    encoder.encodeStruct(codec.Uint32, val.maxTessellationControlPerPatchOutputComponents);
    encoder.encodeStruct(codec.Uint32, val.maxTessellationControlTotalOutputComponents);
    encoder.encodeStruct(codec.Uint32, val.maxTessellationEvaluationInputComponents);
    encoder.encodeStruct(codec.Uint32, val.maxTessellationEvaluationOutputComponents);
    encoder.encodeStruct(codec.Uint32, val.maxGeometryShaderInvocations);
    encoder.encodeStruct(codec.Uint32, val.maxGeometryInputComponents);
    encoder.encodeStruct(codec.Uint32, val.maxGeometryOutputComponents);
    encoder.encodeStruct(codec.Uint32, val.maxGeometryOutputVertices);
    encoder.encodeStruct(codec.Uint32, val.maxGeometryTotalOutputComponents);
    encoder.encodeStruct(codec.Uint32, val.maxFragmentInputComponents);
    encoder.encodeStruct(codec.Uint32, val.maxFragmentOutputAttachments);
    encoder.encodeStruct(codec.Uint32, val.maxFragmentDualSrcAttachments);
    encoder.encodeStruct(codec.Uint32, val.maxFragmentCombinedOutputResources);
    encoder.encodeStruct(codec.Uint32, val.maxComputeSharedMemorySize);
    encoder.encodeArrayPointer(codec.Uint32, val.maxComputeWorkGroupCount);
    encoder.encodeStruct(codec.Uint32, val.maxComputeWorkGroupInvocations);
    encoder.encodeStruct(codec.Uint32, val.subPixelPrecisionBits);
    encoder.encodeArrayPointer(codec.Uint32, val.maxComputeWorkGroupSize);
    encoder.encodeStruct(codec.Uint32, val.subTexelPrecisionBits);
    encoder.encodeStruct(codec.Uint32, val.mipmapPrecisionBits);
    encoder.encodeStruct(codec.Uint32, val.maxDrawIndexedIndexValue);
    encoder.encodeStruct(codec.Uint32, val.maxDrawIndirectCount);
    encoder.encodeStruct(codec.Float, val.maxSamplerLodBias);
    encoder.encodeStruct(codec.Float, val.maxSamplerAnisotropy);
    encoder.encodeStruct(codec.Uint32, val.maxViewports);
    encoder.encodeStruct(codec.Uint32, val.viewportSubPixelBits);
    encoder.encodeArrayPointer(codec.Uint32, val.maxViewportDimensions);
    encoder.encodeArrayPointer(codec.Float, val.viewportBoundsRange);
    encoder.encodeStruct(codec.Uint64, val.minMemoryMapAlignment);
    encoder.encodeStruct(codec.Uint64, val.minTexelBufferOffsetAlignment);
    encoder.encodeStruct(codec.Uint64, val.minUniformBufferOffsetAlignment);
    encoder.encodeStruct(codec.Uint64, val.minStorageBufferOffsetAlignment);
    encoder.encodeStruct(codec.Int32, val.minTexelOffset);
    encoder.encodeStruct(codec.Uint32, val.maxTexelOffset);
    encoder.encodeStruct(codec.Int32, val.minTexelGatherOffset);
    encoder.encodeStruct(codec.Uint32, val.maxTexelGatherOffset);
    encoder.encodeStruct(codec.Float, val.minInterpolationOffset);
    encoder.encodeStruct(codec.Float, val.maxInterpolationOffset);
    encoder.encodeStruct(codec.Uint32, val.subPixelInterpolationOffsetBits);
    encoder.encodeStruct(codec.Uint32, val.maxFramebufferWidth);
    encoder.encodeStruct(codec.Uint32, val.maxFramebufferHeight);
    encoder.encodeStruct(codec.Uint32, val.maxFramebufferLayers);
    encoder.encodeStruct(codec.Uint32, val.framebufferColorSampleCounts);
    encoder.encodeStruct(codec.Uint32, val.framebufferDepthSampleCounts);
    encoder.encodeStruct(codec.Uint32, val.framebufferStencilSampleCounts);
    encoder.encodeStruct(codec.Uint32, val.framebufferNoAttachmentsSampleCounts);
    encoder.encodeStruct(codec.Uint32, val.maxColorAttachments);
    encoder.encodeStruct(codec.Uint32, val.sampledImageColorSampleCounts);
    encoder.encodeStruct(codec.Uint32, val.sampledImageIntegerSampleCounts);
    encoder.encodeStruct(codec.Uint32, val.sampledImageDepthSampleCounts);
    encoder.encodeStruct(codec.Uint32, val.sampledImageStencilSampleCounts);
    encoder.encodeStruct(codec.Uint32, val.storageImageSampleCounts);
    encoder.encodeStruct(codec.Uint32, val.maxSampleMaskWords);
    packed = 0;
    packed |= (val.timestampComputeAndGraphics & 1) << 0
    packed |= (val.strictLines & 1) << 1
    packed |= (val.standardSampleLocations & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Float, val.timestampPeriod);
    encoder.encodeStruct(codec.Uint32, val.maxClipDistances);
    encoder.encodeStruct(codec.Uint32, val.maxCullDistances);
    encoder.encodeStruct(codec.Uint32, val.maxCombinedClipAndCullDistances);
    encoder.encodeStruct(codec.Uint32, val.discreteQueuePriorities);
    encoder.encodeStruct(codec.Float, val.pointSizeGranularity);
    encoder.encodeArrayPointer(codec.Float, val.pointSizeRange);
    encoder.encodeArrayPointer(codec.Float, val.lineWidthRange);
    encoder.encodeStruct(codec.Float, val.lineWidthGranularity);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint64, val.optimalBufferCopyOffsetAlignment);
    encoder.encodeStruct(codec.Uint64, val.optimalBufferCopyRowPitchAlignment);
    encoder.encodeStruct(codec.Uint64, val.nonCoherentAtomSize);
  };
  function VkPhysicalDeviceSparseProperties(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VkPhysicalDeviceSparseProperties.prototype.initDefaults_ = function() {
    this.residencyStandard2DBlockShape = false;
    this.residencyStandard2DMultisampleBlockShape = false;
    this.residencyStandard3DBlockShape = false;
    this.residencyAlignedMipSize = false;
    this.residencyNonResidentStrict = false;
  };
  VkPhysicalDeviceSparseProperties.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VkPhysicalDeviceSparseProperties.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    return validator.validationError.NONE;
  };

  VkPhysicalDeviceSparseProperties.encodedSize = codec.kStructHeaderSize + 8;

  VkPhysicalDeviceSparseProperties.decode = function(decoder) {
    var packed;
    var val = new VkPhysicalDeviceSparseProperties();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.residencyStandard2DBlockShape = (packed >> 0) & 1 ? true : false;
    val.residencyStandard2DMultisampleBlockShape = (packed >> 1) & 1 ? true : false;
    val.residencyStandard3DBlockShape = (packed >> 2) & 1 ? true : false;
    val.residencyAlignedMipSize = (packed >> 3) & 1 ? true : false;
    val.residencyNonResidentStrict = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VkPhysicalDeviceSparseProperties.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VkPhysicalDeviceSparseProperties.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.residencyStandard2DBlockShape & 1) << 0
    packed |= (val.residencyStandard2DMultisampleBlockShape & 1) << 1
    packed |= (val.residencyStandard3DBlockShape & 1) << 2
    packed |= (val.residencyAlignedMipSize & 1) << 3
    packed |= (val.residencyNonResidentStrict & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VkPhysicalDeviceProperties(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VkPhysicalDeviceProperties.prototype.initDefaults_ = function() {
    this.apiVersion = 0;
    this.driverVersion = 0;
    this.vendorID = 0;
    this.deviceID = 0;
    this.deviceType = 0;
    this.deviceName = null;
    this.pipelineCacheUUID = null;
    this.limits = null;
    this.sparseProperties = null;
  };
  VkPhysicalDeviceProperties.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VkPhysicalDeviceProperties.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    // validate VkPhysicalDeviceProperties.deviceType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, VkPhysicalDeviceType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VkPhysicalDeviceProperties.deviceName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate VkPhysicalDeviceProperties.pipelineCacheUUID
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 1, codec.Uint8, false, [16], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VkPhysicalDeviceProperties.limits
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, VkPhysicalDeviceLimits, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VkPhysicalDeviceProperties.sparseProperties
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, VkPhysicalDeviceSparseProperties, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VkPhysicalDeviceProperties.encodedSize = codec.kStructHeaderSize + 56;

  VkPhysicalDeviceProperties.decode = function(decoder) {
    var packed;
    var val = new VkPhysicalDeviceProperties();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.apiVersion =
        decoder.decodeStruct(codec.Uint32);
    val.driverVersion =
        decoder.decodeStruct(codec.Uint32);
    val.vendorID =
        decoder.decodeStruct(codec.Uint32);
    val.deviceID =
        decoder.decodeStruct(codec.Uint32);
    val.deviceType =
        decoder.decodeStruct(new codec.Enum(VkPhysicalDeviceType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.deviceName =
        decoder.decodeStruct(codec.String);
    val.pipelineCacheUUID =
        decoder.decodeArrayPointer(codec.Uint8);
    val.limits =
        decoder.decodeStructPointer(VkPhysicalDeviceLimits);
    val.sparseProperties =
        decoder.decodeStructPointer(VkPhysicalDeviceSparseProperties);
    return val;
  };

  VkPhysicalDeviceProperties.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VkPhysicalDeviceProperties.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.apiVersion);
    encoder.encodeStruct(codec.Uint32, val.driverVersion);
    encoder.encodeStruct(codec.Uint32, val.vendorID);
    encoder.encodeStruct(codec.Uint32, val.deviceID);
    encoder.encodeStruct(codec.Int32, val.deviceType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.deviceName);
    encoder.encodeArrayPointer(codec.Uint8, val.pipelineCacheUUID);
    encoder.encodeStructPointer(VkPhysicalDeviceLimits, val.limits);
    encoder.encodeStructPointer(VkPhysicalDeviceSparseProperties, val.sparseProperties);
  };
  function VkPhysicalDeviceFeatures(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VkPhysicalDeviceFeatures.prototype.initDefaults_ = function() {
    this.robustBufferAccess = false;
    this.fullDrawIndexUint32 = false;
    this.imageCubeArray = false;
    this.independentBlend = false;
    this.geometryShader = false;
    this.tessellationShader = false;
    this.sampleRateShading = false;
    this.dualSrcBlend = false;
    this.logicOp = false;
    this.multiDrawIndirect = false;
    this.drawIndirectFirstInstance = false;
    this.depthClamp = false;
    this.depthBiasClamp = false;
    this.fillModeNonSolid = false;
    this.depthBounds = false;
    this.wideLines = false;
    this.largePoints = false;
    this.alphaToOne = false;
    this.multiViewport = false;
    this.samplerAnisotropy = false;
    this.textureCompressionETC2 = false;
    this.textureCompressionASTCLDR = false;
    this.textureCompressionBC = false;
    this.occlusionQueryPrecise = false;
    this.pipelineStatisticsQuery = false;
    this.vertexPipelineStoresAndAtomics = false;
    this.fragmentStoresAndAtomics = false;
    this.shaderTessellationAndGeometryPointSize = false;
    this.shaderImageGatherExtended = false;
    this.shaderStorageImageExtendedFormats = false;
    this.shaderStorageImageMultisample = false;
    this.shaderStorageImageReadWithoutFormat = false;
    this.shaderStorageImageWriteWithoutFormat = false;
    this.shaderUniformBufferArrayDynamicIndexing = false;
    this.shaderSampledImageArrayDynamicIndexing = false;
    this.shaderStorageBufferArrayDynamicIndexing = false;
    this.shaderStorageImageArrayDynamicIndexing = false;
    this.shaderClipDistance = false;
    this.shaderCullDistance = false;
    this.shaderFloat64 = false;
    this.shaderInt64 = false;
    this.shaderInt16 = false;
    this.shaderResourceResidency = false;
    this.shaderResourceMinLod = false;
    this.sparseBinding = false;
    this.sparseResidencyBuffer = false;
    this.sparseResidencyImage2D = false;
    this.sparseResidencyImage3D = false;
    this.sparseResidency2Samples = false;
    this.sparseResidency4Samples = false;
    this.sparseResidency8Samples = false;
    this.sparseResidency16Samples = false;
    this.sparseResidencyAliased = false;
    this.variableMultisampleRate = false;
    this.inheritedQueries = false;
  };
  VkPhysicalDeviceFeatures.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VkPhysicalDeviceFeatures.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;
























































    return validator.validationError.NONE;
  };

  VkPhysicalDeviceFeatures.encodedSize = codec.kStructHeaderSize + 8;

  VkPhysicalDeviceFeatures.decode = function(decoder) {
    var packed;
    var val = new VkPhysicalDeviceFeatures();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.robustBufferAccess = (packed >> 0) & 1 ? true : false;
    val.fullDrawIndexUint32 = (packed >> 1) & 1 ? true : false;
    val.imageCubeArray = (packed >> 2) & 1 ? true : false;
    val.independentBlend = (packed >> 3) & 1 ? true : false;
    val.geometryShader = (packed >> 4) & 1 ? true : false;
    val.tessellationShader = (packed >> 5) & 1 ? true : false;
    val.sampleRateShading = (packed >> 6) & 1 ? true : false;
    val.dualSrcBlend = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.logicOp = (packed >> 0) & 1 ? true : false;
    val.multiDrawIndirect = (packed >> 1) & 1 ? true : false;
    val.drawIndirectFirstInstance = (packed >> 2) & 1 ? true : false;
    val.depthClamp = (packed >> 3) & 1 ? true : false;
    val.depthBiasClamp = (packed >> 4) & 1 ? true : false;
    val.fillModeNonSolid = (packed >> 5) & 1 ? true : false;
    val.depthBounds = (packed >> 6) & 1 ? true : false;
    val.wideLines = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.largePoints = (packed >> 0) & 1 ? true : false;
    val.alphaToOne = (packed >> 1) & 1 ? true : false;
    val.multiViewport = (packed >> 2) & 1 ? true : false;
    val.samplerAnisotropy = (packed >> 3) & 1 ? true : false;
    val.textureCompressionETC2 = (packed >> 4) & 1 ? true : false;
    val.textureCompressionASTCLDR = (packed >> 5) & 1 ? true : false;
    val.textureCompressionBC = (packed >> 6) & 1 ? true : false;
    val.occlusionQueryPrecise = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.pipelineStatisticsQuery = (packed >> 0) & 1 ? true : false;
    val.vertexPipelineStoresAndAtomics = (packed >> 1) & 1 ? true : false;
    val.fragmentStoresAndAtomics = (packed >> 2) & 1 ? true : false;
    val.shaderTessellationAndGeometryPointSize = (packed >> 3) & 1 ? true : false;
    val.shaderImageGatherExtended = (packed >> 4) & 1 ? true : false;
    val.shaderStorageImageExtendedFormats = (packed >> 5) & 1 ? true : false;
    val.shaderStorageImageMultisample = (packed >> 6) & 1 ? true : false;
    val.shaderStorageImageReadWithoutFormat = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.shaderStorageImageWriteWithoutFormat = (packed >> 0) & 1 ? true : false;
    val.shaderUniformBufferArrayDynamicIndexing = (packed >> 1) & 1 ? true : false;
    val.shaderSampledImageArrayDynamicIndexing = (packed >> 2) & 1 ? true : false;
    val.shaderStorageBufferArrayDynamicIndexing = (packed >> 3) & 1 ? true : false;
    val.shaderStorageImageArrayDynamicIndexing = (packed >> 4) & 1 ? true : false;
    val.shaderClipDistance = (packed >> 5) & 1 ? true : false;
    val.shaderCullDistance = (packed >> 6) & 1 ? true : false;
    val.shaderFloat64 = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.shaderInt64 = (packed >> 0) & 1 ? true : false;
    val.shaderInt16 = (packed >> 1) & 1 ? true : false;
    val.shaderResourceResidency = (packed >> 2) & 1 ? true : false;
    val.shaderResourceMinLod = (packed >> 3) & 1 ? true : false;
    val.sparseBinding = (packed >> 4) & 1 ? true : false;
    val.sparseResidencyBuffer = (packed >> 5) & 1 ? true : false;
    val.sparseResidencyImage2D = (packed >> 6) & 1 ? true : false;
    val.sparseResidencyImage3D = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.sparseResidency2Samples = (packed >> 0) & 1 ? true : false;
    val.sparseResidency4Samples = (packed >> 1) & 1 ? true : false;
    val.sparseResidency8Samples = (packed >> 2) & 1 ? true : false;
    val.sparseResidency16Samples = (packed >> 3) & 1 ? true : false;
    val.sparseResidencyAliased = (packed >> 4) & 1 ? true : false;
    val.variableMultisampleRate = (packed >> 5) & 1 ? true : false;
    val.inheritedQueries = (packed >> 6) & 1 ? true : false;
    decoder.skip(1);
    return val;
  };

  VkPhysicalDeviceFeatures.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VkPhysicalDeviceFeatures.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.robustBufferAccess & 1) << 0
    packed |= (val.fullDrawIndexUint32 & 1) << 1
    packed |= (val.imageCubeArray & 1) << 2
    packed |= (val.independentBlend & 1) << 3
    packed |= (val.geometryShader & 1) << 4
    packed |= (val.tessellationShader & 1) << 5
    packed |= (val.sampleRateShading & 1) << 6
    packed |= (val.dualSrcBlend & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.logicOp & 1) << 0
    packed |= (val.multiDrawIndirect & 1) << 1
    packed |= (val.drawIndirectFirstInstance & 1) << 2
    packed |= (val.depthClamp & 1) << 3
    packed |= (val.depthBiasClamp & 1) << 4
    packed |= (val.fillModeNonSolid & 1) << 5
    packed |= (val.depthBounds & 1) << 6
    packed |= (val.wideLines & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.largePoints & 1) << 0
    packed |= (val.alphaToOne & 1) << 1
    packed |= (val.multiViewport & 1) << 2
    packed |= (val.samplerAnisotropy & 1) << 3
    packed |= (val.textureCompressionETC2 & 1) << 4
    packed |= (val.textureCompressionASTCLDR & 1) << 5
    packed |= (val.textureCompressionBC & 1) << 6
    packed |= (val.occlusionQueryPrecise & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.pipelineStatisticsQuery & 1) << 0
    packed |= (val.vertexPipelineStoresAndAtomics & 1) << 1
    packed |= (val.fragmentStoresAndAtomics & 1) << 2
    packed |= (val.shaderTessellationAndGeometryPointSize & 1) << 3
    packed |= (val.shaderImageGatherExtended & 1) << 4
    packed |= (val.shaderStorageImageExtendedFormats & 1) << 5
    packed |= (val.shaderStorageImageMultisample & 1) << 6
    packed |= (val.shaderStorageImageReadWithoutFormat & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.shaderStorageImageWriteWithoutFormat & 1) << 0
    packed |= (val.shaderUniformBufferArrayDynamicIndexing & 1) << 1
    packed |= (val.shaderSampledImageArrayDynamicIndexing & 1) << 2
    packed |= (val.shaderStorageBufferArrayDynamicIndexing & 1) << 3
    packed |= (val.shaderStorageImageArrayDynamicIndexing & 1) << 4
    packed |= (val.shaderClipDistance & 1) << 5
    packed |= (val.shaderCullDistance & 1) << 6
    packed |= (val.shaderFloat64 & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.shaderInt64 & 1) << 0
    packed |= (val.shaderInt16 & 1) << 1
    packed |= (val.shaderResourceResidency & 1) << 2
    packed |= (val.shaderResourceMinLod & 1) << 3
    packed |= (val.sparseBinding & 1) << 4
    packed |= (val.sparseResidencyBuffer & 1) << 5
    packed |= (val.sparseResidencyImage2D & 1) << 6
    packed |= (val.sparseResidencyImage3D & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.sparseResidency2Samples & 1) << 0
    packed |= (val.sparseResidency4Samples & 1) << 1
    packed |= (val.sparseResidency8Samples & 1) << 2
    packed |= (val.sparseResidency16Samples & 1) << 3
    packed |= (val.sparseResidencyAliased & 1) << 4
    packed |= (val.variableMultisampleRate & 1) << 5
    packed |= (val.inheritedQueries & 1) << 6
    encoder.writeUint8(packed);
    encoder.skip(1);
  };
  function VkExtent3D(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VkExtent3D.prototype.initDefaults_ = function() {
    this.width = 0;
    this.height = 0;
    this.depth = 0;
  };
  VkExtent3D.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VkExtent3D.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  VkExtent3D.encodedSize = codec.kStructHeaderSize + 16;

  VkExtent3D.decode = function(decoder) {
    var packed;
    var val = new VkExtent3D();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.width =
        decoder.decodeStruct(codec.Uint32);
    val.height =
        decoder.decodeStruct(codec.Uint32);
    val.depth =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VkExtent3D.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VkExtent3D.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.width);
    encoder.encodeStruct(codec.Uint32, val.height);
    encoder.encodeStruct(codec.Uint32, val.depth);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VkQueueFamilyProperties(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VkQueueFamilyProperties.prototype.initDefaults_ = function() {
    this.queueFlags = 0;
    this.queueCount = 0;
    this.timestampValidBits = 0;
    this.minImageTransferGranularity = null;
  };
  VkQueueFamilyProperties.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VkQueueFamilyProperties.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate VkQueueFamilyProperties.minImageTransferGranularity
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, VkExtent3D, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VkQueueFamilyProperties.encodedSize = codec.kStructHeaderSize + 24;

  VkQueueFamilyProperties.decode = function(decoder) {
    var packed;
    var val = new VkQueueFamilyProperties();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.queueFlags =
        decoder.decodeStruct(codec.Uint32);
    val.queueCount =
        decoder.decodeStruct(codec.Uint32);
    val.timestampValidBits =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.minImageTransferGranularity =
        decoder.decodeStructPointer(VkExtent3D);
    return val;
  };

  VkQueueFamilyProperties.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VkQueueFamilyProperties.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.queueFlags);
    encoder.encodeStruct(codec.Uint32, val.queueCount);
    encoder.encodeStruct(codec.Uint32, val.timestampValidBits);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(VkExtent3D, val.minImageTransferGranularity);
  };
  exports.VkPhysicalDeviceType = VkPhysicalDeviceType;
  exports.VkExtensionProperties = VkExtensionProperties;
  exports.VkLayerProperties = VkLayerProperties;
  exports.VkPhysicalDeviceLimits = VkPhysicalDeviceLimits;
  exports.VkPhysicalDeviceSparseProperties = VkPhysicalDeviceSparseProperties;
  exports.VkPhysicalDeviceProperties = VkPhysicalDeviceProperties;
  exports.VkPhysicalDeviceFeatures = VkPhysicalDeviceFeatures;
  exports.VkExtent3D = VkExtent3D;
  exports.VkQueueFamilyProperties = VkQueueFamilyProperties;
})();