// media/capture/mojom/video_capture_types.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoCapturePixelFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoCapturePixelFormat = {
  
  UNKNOWN: 0,
  I420: 1,
  YV12: 2,
  I422: 3,
  I420A: 4,
  I444: 5,
  NV12: 6,
  NV21: 7,
  UYVY: 8,
  YUY2: 9,
  ARGB: 10,
  XRGB: 11,
  RGB24: 12,
  MJPEG: 13,
  YUV420P9_DEPRECATED: 14,
  YUV420P10: 15,
  YUV422P9_DEPRECATED: 16,
  YUV422P10: 17,
  YUV444P9_DEPRECATED: 18,
  YUV444P10: 19,
  YUV420P12: 20,
  YUV422P12: 21,
  YUV444P12: 22,
  Y16: 23,
  ABGR: 24,
  XBGR: 25,
  P010LE: 26,
  XR30: 27,
  XB30: 28,
  BGRA: 29,
  RGBAF16: 30,
  I422A: 31,
  I444A: 32,
  YUV420AP10: 33,
  YUV422AP10: 34,
  YUV444AP10: 35,
  NV12A: 36,
  NV16: 37,
  NV24: 38,
  P210LE: 39,
  P410LE: 40,
  MIN_VALUE: 0,
  MAX_VALUE: 40,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ResolutionChangePolicySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ResolutionChangePolicy = {
  
  FIXED_RESOLUTION: 0,
  FIXED_ASPECT_RATIO: 1,
  ANY_WITHIN_LIMIT: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PowerLineFrequencySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PowerLineFrequency = {
  
  DEFAULT: 0,
  HZ_50: 1,
  HZ_60: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoFacingModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoFacingMode = {
  
  NONE: 0,
  USER: 1,
  ENVIRONMENT: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CameraAvailabilitySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CameraAvailability = {
  
  kAvailable: 0,
  kUnavailableExclusivelyUsedByOtherApplication: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoCaptureApiSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoCaptureApi = {
  
  LINUX_V4L2_SINGLE_PLANE: 0,
  WIN_MEDIA_FOUNDATION: 1,
  WIN_MEDIA_FOUNDATION_SENSOR: 2,
  WIN_DIRECT_SHOW: 3,
  MACOSX_AVFOUNDATION: 4,
  MACOSX_DECKLINK: 5,
  ANDROID_API1: 6,
  ANDROID_API2_LEGACY: 7,
  ANDROID_API2_FULL: 8,
  ANDROID_API2_LIMITED: 9,
  FUCHSIA_CAMERA3: 10,
  VIRTUAL_DEVICE: 11,
  UNKNOWN: 12,
  WEBRTC_LINUX_PIPEWIRE_SINGLE_PLANE: 13,
  MIN_VALUE: 0,
  MAX_VALUE: 13,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoCaptureTransportTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoCaptureTransportType = {
  
  APPLE_USB_OR_BUILT_IN: 0,
  OTHER_TRANSPORT: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoCaptureBufferTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoCaptureBufferType = {
  
  kSharedMemory: 0,
  kSharedMemoryViaRawFileDescriptor_DEPRECATED: 1,
  kMailboxHolder: 2,
  kGpuMemoryBuffer: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoCaptureErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoCaptureError = {
  
  kNone: 0,
  kVideoCaptureControllerInvalidOrUnsupportedVideoCaptureParametersRequested: 1,
  kVideoCaptureControllerIsAlreadyInErrorState: 2,
  kVideoCaptureManagerDeviceConnectionLost: 3,
  kFrameSinkVideoCaptureDeviceAlreadyEndedOnFatalError: 4,
  kFrameSinkVideoCaptureDeviceEncounteredFatalError: 5,
  kV4L2FailedToOpenV4L2DeviceDriverFile: 6,
  kV4L2ThisIsNotAV4L2VideoCaptureDevice: 7,
  kV4L2FailedToFindASupportedCameraFormat: 8,
  kV4L2FailedToSetVideoCaptureFormat: 9,
  kV4L2UnsupportedPixelFormat: 10,
  kV4L2FailedToSetCameraFramerate: 11,
  kV4L2ErrorRequestingMmapBuffers: 12,
  kV4L2AllocateBufferFailed: 13,
  kV4L2VidiocStreamonFailed: 14,
  kV4L2VidiocStreamoffFailed: 15,
  kV4L2FailedToVidiocReqbufsWithCount0: 16,
  kV4L2PollFailed: 17,
  kV4L2MultipleContinuousTimeoutsWhileReadPolling: 18,
  kV4L2FailedToDequeueCaptureBuffer: 19,
  kV4L2FailedToEnqueueCaptureBuffer: 20,
  kSingleClientVideoCaptureHostLostConnectionToDevice: 21,
  kSingleClientVideoCaptureDeviceLaunchAborted: 22,
  kDesktopCaptureDeviceWebrtcDesktopCapturerHasFailed: 23,
  kFileVideoCaptureDeviceCouldNotOpenVideoFile: 24,
  kDeviceCaptureLinuxFailedToCreateVideoCaptureDelegate: 25,
  kErrorFakeDeviceIntentionallyEmittingErrorEvent: 26,
  kDeviceClientTooManyFramesDroppedY16: 27,
  kDeviceMediaToMojoAdapterEncounteredUnsupportedBufferType: 28,
  kVideoCaptureManagerProcessDeviceStartQueueDeviceInfoNotFound: 29,
  kInProcessDeviceLauncherFailedToCreateDeviceInstance: 30,
  kServiceDeviceLauncherLostConnectionToDeviceFactoryDuringDeviceStart: 31,
  kServiceDeviceLauncherServiceRespondedWithDeviceNotFound: 32,
  kServiceDeviceLauncherConnectionLostWhileWaitingForCallback: 33,
  kIntentionalErrorRaisedByUnitTest: 34,
  kCrosHalV3FailedToStartDeviceThread: 35,
  kCrosHalV3DeviceDelegateMojoConnectionError: 36,
  kCrosHalV3DeviceDelegateFailedToGetCameraInfo: 37,
  kCrosHalV3DeviceDelegateMissingSensorOrientationInfo: 38,
  kCrosHalV3DeviceDelegateFailedToOpenCameraDevice: 39,
  kCrosHalV3DeviceDelegateFailedToInitializeCameraDevice: 40,
  kCrosHalV3DeviceDelegateFailedToConfigureStreams: 41,
  kCrosHalV3DeviceDelegateWrongNumberOfStreamsConfigured: 42,
  kCrosHalV3DeviceDelegateFailedToGetDefaultRequestSettings: 43,
  kCrosHalV3BufferManagerHalRequestedTooManyBuffers: 44,
  kCrosHalV3BufferManagerFailedToCreateMappableSI: 45,
  kCrosHalV3BufferManagerFailedToMapGpuMemoryBuffer: 46,
  kCrosHalV3BufferManagerUnsupportedVideoPixelFormat: 47,
  kCrosHalV3BufferManagerFailedToDupFd: 48,
  kCrosHalV3BufferManagerFailedToWrapGpuMemoryHandle: 49,
  kCrosHalV3BufferManagerFailedToRegisterBuffer: 50,
  kCrosHalV3BufferManagerProcessCaptureRequestFailed: 51,
  kCrosHalV3BufferManagerInvalidPendingResultId: 52,
  kCrosHalV3BufferManagerReceivedDuplicatedPartialMetadata: 53,
  kCrosHalV3BufferManagerIncorrectNumberOfOutputBuffersReceived: 54,
  kCrosHalV3BufferManagerInvalidTypeOfOutputBuffersReceived: 55,
  kCrosHalV3BufferManagerReceivedMultipleResultBuffersForFrame: 56,
  kCrosHalV3BufferManagerUnknownStreamInCamera3NotifyMsg: 57,
  kCrosHalV3BufferManagerReceivedInvalidShutterTime: 58,
  kCrosHalV3BufferManagerFatalDeviceError: 59,
  kCrosHalV3BufferManagerReceivedFrameIsOutOfOrder: 60,
  kCrosHalV3BufferManagerFailedToUnwrapReleaseFenceFd: 61,
  kCrosHalV3BufferManagerSyncWaitOnReleaseFenceTimedOut: 62,
  kCrosHalV3BufferManagerInvalidJpegBlob: 63,
  kAndroidFailedToAllocate: 64,
  kAndroidFailedToStartCapture: 65,
  kAndroidFailedToStopCapture: 66,
  kAndroidApi1CameraErrorCallbackReceived: 67,
  kAndroidApi2CameraDeviceErrorReceived: 68,
  kAndroidApi2CaptureSessionConfigureFailed: 69,
  kAndroidApi2ImageReaderUnexpectedImageFormat: 70,
  kAndroidApi2ImageReaderSizeDidNotMatchImageSize: 71,
  kAndroidApi2ErrorRestartingPreview: 72,
  kAndroidScreenCaptureUnsupportedFormat: 73,
  kAndroidScreenCaptureFailedToStartCaptureMachine: 74,
  kAndroidScreenCaptureTheUserDeniedScreenCapture: 75,
  kAndroidScreenCaptureFailedToStartScreenCapture: 76,
  kWinDirectShowCantGetCaptureFormatSettings: 77,
  kWinDirectShowFailedToGetNumberOfCapabilities: 78,
  kWinDirectShowFailedToGetCaptureDeviceCapabilities: 79,
  kWinDirectShowFailedToSetCaptureDeviceOutputFormat: 80,
  kWinDirectShowFailedToConnectTheCaptureGraph: 81,
  kWinDirectShowFailedToPauseTheCaptureDevice: 82,
  kWinDirectShowFailedToStartTheCaptureDevice: 83,
  kWinDirectShowFailedToStopTheCaptureGraph: 84,
  kWinMediaFoundationEngineIsNull: 85,
  kWinMediaFoundationEngineGetSourceFailed: 86,
  kWinMediaFoundationFillPhotoCapabilitiesFailed: 87,
  kWinMediaFoundationFillVideoCapabilitiesFailed: 88,
  kWinMediaFoundationNoVideoCapabilityFound: 89,
  kWinMediaFoundationGetAvailableDeviceMediaTypeFailed: 90,
  kWinMediaFoundationSetCurrentDeviceMediaTypeFailed: 91,
  kWinMediaFoundationEngineGetSinkFailed: 92,
  kWinMediaFoundationSinkQueryCapturePreviewInterfaceFailed: 93,
  kWinMediaFoundationSinkRemoveAllStreamsFailed: 94,
  kWinMediaFoundationCreateSinkVideoMediaTypeFailed: 95,
  kWinMediaFoundationConvertToVideoSinkMediaTypeFailed: 96,
  kWinMediaFoundationSinkAddStreamFailed: 97,
  kWinMediaFoundationSinkSetSampleCallbackFailed: 98,
  kWinMediaFoundationEngineStartPreviewFailed: 99,
  kWinMediaFoundationGetMediaEventStatusFailed: 100,
  kMacSetCaptureDeviceFailed: 101,
  kMacCouldNotStartCaptureDevice: 102,
  kMacReceivedFrameWithUnexpectedResolution: 103,
  kMacUpdateCaptureResolutionFailed: 104,
  kMacDeckLinkDeviceIdNotFoundInTheSystem: 105,
  kMacDeckLinkErrorQueryingInputInterface: 106,
  kMacDeckLinkErrorCreatingDisplayModeIterator: 107,
  kMacDeckLinkCouldNotFindADisplayMode: 108,
  kMacDeckLinkCouldNotSelectTheVideoFormatWeLike: 109,
  kMacDeckLinkCouldNotStartCapturing: 110,
  kMacDeckLinkUnsupportedPixelFormat: 111,
  kMacAvFoundationReceivedAVCaptureSessionRuntimeErrorNotification: 112,
  kAndroidApi2ErrorConfiguringCamera: 113,
  kCrosHalV3DeviceDelegateFailedToFlush: 114,
  kFuchsiaCameraDeviceDisconnected: 115,
  kFuchsiaCameraStreamDisconnected: 116,
  kFuchsiaSysmemDidNotSetImageFormat: 117,
  kFuchsiaSysmemInvalidBufferIndex: 118,
  kFuchsiaSysmemInvalidBufferSize: 119,
  kFuchsiaUnsupportedPixelFormat: 120,
  kFuchsiaFailedToMapSysmemBuffer: 121,
  kCrosHalV3DeviceContextDuplicatedClient: 122,
  kDesktopCaptureDeviceMacFailedStreamCreate: 123,
  kDesktopCaptureDeviceMacFailedStreamStart: 124,
  kCrosHalV3BufferManagerFailedToReserveBuffers: 125,
  kWinMediaFoundationSystemPermissionDenied: 126,
  kVideoCaptureImplTimedOutOnStart: 127,
  kLacrosVideoCaptureDeviceProxyAlreadyEndedOnFatalError: 128,
  kLacrosVideoCaptureDeviceProxyEncounteredFatalError: 129,
  kScreenCaptureKitFailedGetShareableContent: 130,
  kScreenCaptureKitFailedAddStreamOutput: 131,
  kScreenCaptureKitFailedStartCapture: 132,
  kScreenCaptureKitFailedStopCapture: 133,
  kScreenCaptureKitStreamError: 134,
  kScreenCaptureKitFailedToFindSCDisplay: 135,
  kVideoCaptureControllerInvalid: 136,
  kVideoCaptureDeviceFactoryChromeOSCreateDeviceFailed: 137,
  kVideoCaptureControllerUnsupportedPixelFormat: 138,
  kVideoCaptureDeviceAlreadyReleased: 139,
  kVideoCaptureSystemDeviceIdNotFound: 140,
  kVideoCaptureDeviceFactoryWinUnknownError: 141,
  kWinMediaFoundationDeviceInitializationFailed: 142,
  kWinMediaFoundationSourceCreationFailed: 143,
  kWinDirectShowDeviceFilterCreationFailed: 144,
  kWinDirectShowDeviceInitializationFailed: 145,
  kVideoCaptureDeviceFactorySecondCreateDenied: 146,
  kScreenCaptureKitResetStreamError: 147,
  kWinMediaFoundationCameraBusy: 148,
  kWebRtcStartCaptureFailed: 149,
  MIN_VALUE: 0,
  MAX_VALUE: 149,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoCaptureFrameDropReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoCaptureFrameDropReason = {
  
  kNone: 0,
  kDeviceClientFrameHasInvalidFormat: 1,
  kDeviceClientLibyuvConvertToI420Failed: 2,
  kV4L2BufferErrorFlagWasSet: 3,
  kV4L2InvalidNumberOfBytesInBuffer: 4,
  kAndroidThrottling: 5,
  kAndroidGetByteArrayElementsFailed: 6,
  kAndroidApi1UnexpectedDataLength: 7,
  kAndroidApi2AcquiredImageIsNull: 8,
  kWinDirectShowUnexpectedSampleLength: 9,
  kWinDirectShowFailedToGetMemoryPointerFromMediaSample: 10,
  kWinMediaFoundationReceivedSampleIsNull: 11,
  kWinMediaFoundationLockingBufferDelieveredNullptr: 12,
  kWinMediaFoundationGetBufferByIndexReturnedNull: 13,
  kBufferPoolMaxBufferCountExceeded: 14,
  kBufferPoolBufferAllocationFailed: 15,
  kVideoCaptureImplNotInStartedState: 16,
  kVideoCaptureImplFailedToWrapDataAsMediaVideoFrame: 17,
  kVideoTrackAdapterHasNoResolutionAdapters: 18,
  kResolutionAdapterFrameIsNotValid: 19,
  kResolutionAdapterWrappingFrameForCroppingFailed: 20,
  kResolutionAdapterTimestampTooCloseToPrevious_DEPRECATED: 21,
  kResolutionAdapterFrameRateIsHigherThanRequested: 22,
  kResolutionAdapterHasNoCallbacks: 23,
  kVideoTrackFrameDelivererNotEnabledReplacingWithBlackFrame: 24,
  kRendererSinkFrameDelivererIsNotStarted: 25,
  kCropVersionNotCurrent_DEPRECATED: 26,
  kGpuMemoryBufferMapFailed: 27,
  kSubCaptureTargetVersionNotCurrent_DEPRECATED: 28,
  kPostProcessingFailed: 29,
  kResolutionAdapterFrameIsNotMappable: 30,
  kResolutionAdapterCannotCreateConvertFrame: 31,
  kResolutionAdapterConvertAndScaleFailed: 32,
  kOldCaptureVersion: 33,
  MIN_VALUE: 0,
  MAX_VALUE: 33,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SubCaptureTargetTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SubCaptureTargetType = {
  
  kCropTarget: 0,
  kRestrictionTarget: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ApplySubCaptureTargetResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ApplySubCaptureTargetResult = {
  
  kSuccess: 0,
  kErrorGeneric: 1,
  kUnsupportedCaptureDevice: 2,
  kNotImplemented: 3,
  kNonIncreasingVersion: 4,
  kInvalidTarget: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DeviceEnumerationResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DeviceEnumerationResult = {
  
  kSuccess: 0,
  kUnknownError: 1,
  kErrorCaptureServiceCrash: 2,
  kErrorCaptureServiceDroppedRequest: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureControlSupportSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureFormatSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureFeedbackSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaneStridesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureDeviceDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureDeviceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    VideoCaptureControlSupportSpec.$,
    'VideoCaptureControlSupport',
    [
      mojo.internal.StructField(
        'pan', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tilt', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'zoom', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoCaptureControlSupport {
  constructor() {
    /** @type { !boolean } */
    this.pan;
    /** @type { !boolean } */
    this.tilt;
    /** @type { !boolean } */
    this.zoom;
  }
}



mojo.internal.Struct(
    VideoCaptureFormatSpec.$,
    'VideoCaptureFormat',
    [
      mojo.internal.StructField(
        'frameSize', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameRate', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pixelFormat', 12,
        0,
        VideoCapturePixelFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoCaptureFormat {
  constructor() {
    /** @type { !gfx_mojom_Size } */
    this.frameSize;
    /** @type { !number } */
    this.frameRate;
    /** @type { !VideoCapturePixelFormat } */
    this.pixelFormat;
  }
}



mojo.internal.Struct(
    VideoCaptureParamsSpec.$,
    'VideoCaptureParams',
    [
      mojo.internal.StructField(
        'requestedFormat', 0,
        0,
        VideoCaptureFormatSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bufferType', 8,
        0,
        VideoCaptureBufferTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resolutionChangePolicy', 12,
        0,
        ResolutionChangePolicySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'powerLineFrequency', 16,
        0,
        PowerLineFrequencySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableFaceDetection', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isHighDpiEnabled', 20,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'captureVersionSource', 24,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        2,
      ),
    ],
    [[0, 32],[1, 32],[2, 40],]);



/**
 * @record
 */
export class VideoCaptureParams {
  constructor() {
    /** @type { !VideoCaptureFormat } */
    this.requestedFormat;
    /** @type { !VideoCaptureBufferType } */
    this.bufferType;
    /** @type { !ResolutionChangePolicy } */
    this.resolutionChangePolicy;
    /** @type { !PowerLineFrequency } */
    this.powerLineFrequency;
    /** @type { !boolean } */
    this.enableFaceDetection;
    /** @type { !boolean } */
    this.isHighDpiEnabled;
    /** @type { !number } */
    this.captureVersionSource;
  }
}



mojo.internal.Struct(
    VideoCaptureFeedbackSpec.$,
    'VideoCaptureFeedback',
    [
      mojo.internal.StructField(
        'resourceUtilization', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFramerateFps', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxPixels', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requireMappedFrame', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dEPRECATEDMappedSizes', 24,
        0,
        mojo.internal.Array(gfx_mojom_SizeSpec.$, false),
        null,
        true /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'frameId', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        2,
      ),
      mojo.internal.StructField(
        'hasFrameId', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        2,
      ),
    ],
    [[0, 32],[1, 40],[2, 40],]);



/**
 * @record
 */
export class VideoCaptureFeedback {
  constructor() {
    /** @type { !number } */
    this.resourceUtilization;
    /** @type { !number } */
    this.maxFramerateFps;
    /** @type { !number } */
    this.maxPixels;
    /** @type { !boolean } */
    this.requireMappedFrame;
    /** @type { (Array<!gfx_mojom_Size>|undefined) } */
    this.dEPRECATEDMappedSizes;
    /** @type { !number } */
    this.frameId;
    /** @type { !boolean } */
    this.hasFrameId;
  }
}



mojo.internal.Struct(
    PlaneStridesSpec.$,
    'PlaneStrides',
    [
      mojo.internal.StructField(
        'strideByPlane', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PlaneStrides {
  constructor() {
    /** @type { !Array<!number> } */
    this.strideByPlane;
  }
}



mojo.internal.Struct(
    VideoCaptureDeviceDescriptorSpec.$,
    'VideoCaptureDeviceDescriptor',
    [
      mojo.internal.StructField(
        'displayName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modelId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'facingMode', 24,
        0,
        VideoFacingModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'captureApi', 28,
        0,
        VideoCaptureApiSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'controlSupport', 32,
        0,
        VideoCaptureControlSupportSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transportType', 40,
        0,
        VideoCaptureTransportTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'availability_$flag', 44,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        1,
        {
          isPrimary: true,
          linkedValueFieldName: "availability_$value",
          originalFieldName: "availability",
        }
      ),
      mojo.internal.StructField(
        'availability_$value', 48,
        0,
        CameraAvailabilitySpec.$,
        0,
        false /* nullable */,
        1,
        {
          isPrimary: false,
          originalFieldName: "availability",
        }
      ),
    ],
    [[0, 56],[1, 64],]);



/**
 * @record
 */
export class VideoCaptureDeviceDescriptor {
  constructor() {
    /** @type { !string } */
    this.displayName;
    /** @type { !string } */
    this.deviceId;
    /** @type { !string } */
    this.modelId;
    /** @type { !VideoFacingMode } */
    this.facingMode;
    /** @type { !VideoCaptureApi } */
    this.captureApi;
    /** @type { !VideoCaptureControlSupport } */
    this.controlSupport;
    /** @type { !VideoCaptureTransportType } */
    this.transportType;
    /** @type { (CameraAvailability|undefined) } */
    this.availability;
  }
}



mojo.internal.Struct(
    VideoCaptureDeviceInfoSpec.$,
    'VideoCaptureDeviceInfo',
    [
      mojo.internal.StructField(
        'descriptor', 0,
        0,
        VideoCaptureDeviceDescriptorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'supportedFormats', 8,
        0,
        mojo.internal.Array(VideoCaptureFormatSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoCaptureDeviceInfo {
  constructor() {
    /** @type { !VideoCaptureDeviceDescriptor } */
    this.descriptor;
    /** @type { !Array<!VideoCaptureFormat> } */
    this.supportedFormats;
  }
}

