// media/mojo/mojom/cdm_context_for_oopvd.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('media.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.DecryptStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.DecryptStatus = {
  
  kSuccess: 0,
  kNoKey: 1,
  kFailure: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.CdmContextEventSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.CdmContextEvent = {
  
  kHasAdditionalUsableKey: 0,
  kHardwareContextReset: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.CdmContextEventCallbackPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.CdmContextEventCallback.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.CdmContextEventCallbackInterface }
 */
media.mojom.CdmContextEventCallbackRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.CdmContextEventCallbackPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.CdmContextEventCallbackPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.CdmContextEventCallbackPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.CdmContextEvent } event
   */

  eventCallback(
      event) {
    this.proxy.sendMessage(
        0,
        media.mojom.CdmContextEventCallback_EventCallback_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CdmContextEventCallback
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.CdmContextEventCallbackReceiver = class {
  /**
   * @param {!media.mojom.CdmContextEventCallbackInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.CdmContextEventCallbackRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.CdmContextEventCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.CdmContextEventCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.CdmContextEventCallback_EventCallback_ParamsSpec.$,
        null,
        impl.eventCallback.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.CdmContextEventCallback = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.CdmContextEventCallback";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.CdmContextEventCallbackRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.CdmContextEventCallbackRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CdmContextEventCallback
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.CdmContextEventCallbackCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.CdmContextEventCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.CdmContextEventCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.eventCallback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.CdmContextEventCallback_EventCallback_ParamsSpec.$,
        null,
        this.eventCallback.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.CdmContextForOOPVDPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.CdmContextForOOPVD.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.CdmContextForOOPVDInterface }
 */
media.mojom.CdmContextForOOPVDRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.CdmContextForOOPVDPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.CdmContextForOOPVDPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.CdmContextForOOPVDPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.DecryptConfig } decryptConfig
   * @param { !Array<!number> } hwIdentifier
   * @return {!Promise<{
        status: !media.mojom.DecryptStatus,
        keyData: !Array<!number>,
   *  }>}
   */

  getHwKeyData(
      decryptConfig,
      hwIdentifier) {
    return this.proxy.sendMessage(
        0,
        media.mojom.CdmContextForOOPVD_GetHwKeyData_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_GetHwKeyData_ResponseParamsSpec.$,
        [
          decryptConfig,
          hwIdentifier
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.CdmContextEventCallbackRemote } callback
   */

  registerEventCallback(
      callback) {
    this.proxy.sendMessage(
        1,
        media.mojom.CdmContextForOOPVD_RegisterEventCallback_ParamsSpec.$,
        null,
        [
          callback
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
        configData: !Array<!number>,
   *  }>}
   */

  getHwConfigData() {
    return this.proxy.sendMessage(
        2,
        media.mojom.CdmContextForOOPVD_GetHwConfigData_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_GetHwConfigData_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        resolutions: !Array<!gfx.mojom.Size>,
   *  }>}
   */

  getScreenResolutions() {
    return this.proxy.sendMessage(
        3,
        media.mojom.CdmContextForOOPVD_GetScreenResolutions_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_GetScreenResolutions_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } size
   * @return {!Promise<{
        secureBuffer: ?MojoHandle,
   *  }>}
   */

  allocateSecureBuffer(
      size) {
    return this.proxy.sendMessage(
        4,
        media.mojom.CdmContextForOOPVD_AllocateSecureBuffer_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_AllocateSecureBuffer_ResponseParamsSpec.$,
        [
          size
        ],
        false);
  }

  
  /**
   * @param { !bigint } secureHandle
   * @param { !number } offset
   * @param { !Array<!number> } streamData
   * @return {!Promise<{
        success: !boolean,
        sliceHeader: !Array<!number>,
   *  }>}
   */

  parseEncryptedSliceHeader(
      secureHandle,
      offset,
      streamData) {
    return this.proxy.sendMessage(
        5,
        media.mojom.CdmContextForOOPVD_ParseEncryptedSliceHeader_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParamsSpec.$,
        [
          secureHandle,
          offset,
          streamData
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.DecoderBuffer } buffer
   * @param { !Array<!number> } bytes
   * @return {!Promise<{
        status: !media.mojom.DecryptStatus,
        decoderBuffer: ?media.mojom.DecoderBuffer,
        bytes: !Array<!number>,
   *  }>}
   */

  decryptVideoBuffer(
      buffer,
      bytes) {
    return this.proxy.sendMessage(
        6,
        media.mojom.CdmContextForOOPVD_DecryptVideoBuffer_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_DecryptVideoBuffer_ResponseParamsSpec.$,
        [
          buffer,
          bytes
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CdmContextForOOPVD
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.CdmContextForOOPVDReceiver = class {
  /**
   * @param {!media.mojom.CdmContextForOOPVDInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.CdmContextForOOPVDRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.CdmContextForOOPVDRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.CdmContextForOOPVDRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.CdmContextForOOPVD_GetHwKeyData_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_GetHwKeyData_ResponseParamsSpec.$,
        impl.getHwKeyData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.CdmContextForOOPVD_RegisterEventCallback_ParamsSpec.$,
        null,
        impl.registerEventCallback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.CdmContextForOOPVD_GetHwConfigData_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_GetHwConfigData_ResponseParamsSpec.$,
        impl.getHwConfigData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.CdmContextForOOPVD_GetScreenResolutions_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_GetScreenResolutions_ResponseParamsSpec.$,
        impl.getScreenResolutions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.CdmContextForOOPVD_AllocateSecureBuffer_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_AllocateSecureBuffer_ResponseParamsSpec.$,
        impl.allocateSecureBuffer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.CdmContextForOOPVD_ParseEncryptedSliceHeader_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParamsSpec.$,
        impl.parseEncryptedSliceHeader.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        media.mojom.CdmContextForOOPVD_DecryptVideoBuffer_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_DecryptVideoBuffer_ResponseParamsSpec.$,
        impl.decryptVideoBuffer.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.CdmContextForOOPVD = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.CdmContextForOOPVD";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.CdmContextForOOPVDRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.CdmContextForOOPVDRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CdmContextForOOPVD
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.CdmContextForOOPVDCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.CdmContextForOOPVDRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.CdmContextForOOPVDRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getHwKeyData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.CdmContextForOOPVD_GetHwKeyData_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_GetHwKeyData_ResponseParamsSpec.$,
        this.getHwKeyData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerEventCallback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.CdmContextForOOPVD_RegisterEventCallback_ParamsSpec.$,
        null,
        this.registerEventCallback.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getHwConfigData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.CdmContextForOOPVD_GetHwConfigData_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_GetHwConfigData_ResponseParamsSpec.$,
        this.getHwConfigData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getScreenResolutions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.CdmContextForOOPVD_GetScreenResolutions_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_GetScreenResolutions_ResponseParamsSpec.$,
        this.getScreenResolutions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.allocateSecureBuffer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.CdmContextForOOPVD_AllocateSecureBuffer_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_AllocateSecureBuffer_ResponseParamsSpec.$,
        this.allocateSecureBuffer.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.parseEncryptedSliceHeader =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.CdmContextForOOPVD_ParseEncryptedSliceHeader_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParamsSpec.$,
        this.parseEncryptedSliceHeader.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decryptVideoBuffer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        media.mojom.CdmContextForOOPVD_DecryptVideoBuffer_ParamsSpec.$,
        media.mojom.CdmContextForOOPVD_DecryptVideoBuffer_ResponseParamsSpec.$,
        this.decryptVideoBuffer.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextEventCallback_EventCallback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextForOOPVD_GetHwKeyData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextForOOPVD_GetHwKeyData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextForOOPVD_RegisterEventCallback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextForOOPVD_GetHwConfigData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextForOOPVD_GetHwConfigData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextForOOPVD_GetScreenResolutions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextForOOPVD_GetScreenResolutions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextForOOPVD_AllocateSecureBuffer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextForOOPVD_AllocateSecureBuffer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextForOOPVD_ParseEncryptedSliceHeader_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextForOOPVD_DecryptVideoBuffer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextForOOPVD_DecryptVideoBuffer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.CdmContextEventCallback_EventCallback_ParamsSpec.$,
    'CdmContextEventCallback_EventCallback_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        media.mojom.CdmContextEventSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.CdmContextEventCallback_EventCallback_Params = class {
  constructor() {
    /** @export { !media.mojom.CdmContextEvent } */
    this.event;
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextForOOPVD_GetHwKeyData_ParamsSpec.$,
    'CdmContextForOOPVD_GetHwKeyData_Params',
    [
      mojo.internal.StructField(
        'decryptConfig', 0,
        0,
        media.mojom.DecryptConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hwIdentifier', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
media.mojom.CdmContextForOOPVD_GetHwKeyData_Params = class {
  constructor() {
    /** @export { !media.mojom.DecryptConfig } */
    this.decryptConfig;
    /** @export { !Array<!number> } */
    this.hwIdentifier;
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextForOOPVD_GetHwKeyData_ResponseParamsSpec.$,
    'CdmContextForOOPVD_GetHwKeyData_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.DecryptStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyData', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
media.mojom.CdmContextForOOPVD_GetHwKeyData_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.DecryptStatus } */
    this.status;
    /** @export { !Array<!number> } */
    this.keyData;
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextForOOPVD_RegisterEventCallback_ParamsSpec.$,
    'CdmContextForOOPVD_RegisterEventCallback_Params',
    [
      mojo.internal.StructField(
        'callback', 0,
        0,
        mojo.internal.InterfaceProxy(media.mojom.CdmContextEventCallbackRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.CdmContextForOOPVD_RegisterEventCallback_Params = class {
  constructor() {
    /** @export { !media.mojom.CdmContextEventCallbackRemote } */
    this.callback;
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextForOOPVD_GetHwConfigData_ParamsSpec.$,
    'CdmContextForOOPVD_GetHwConfigData_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.CdmContextForOOPVD_GetHwConfigData_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextForOOPVD_GetHwConfigData_ResponseParamsSpec.$,
    'CdmContextForOOPVD_GetHwConfigData_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'configData', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
media.mojom.CdmContextForOOPVD_GetHwConfigData_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !Array<!number> } */
    this.configData;
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextForOOPVD_GetScreenResolutions_ParamsSpec.$,
    'CdmContextForOOPVD_GetScreenResolutions_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.CdmContextForOOPVD_GetScreenResolutions_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextForOOPVD_GetScreenResolutions_ResponseParamsSpec.$,
    'CdmContextForOOPVD_GetScreenResolutions_ResponseParams',
    [
      mojo.internal.StructField(
        'resolutions', 0,
        0,
        mojo.internal.Array(gfx.mojom.SizeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.CdmContextForOOPVD_GetScreenResolutions_ResponseParams = class {
  constructor() {
    /** @export { !Array<!gfx.mojom.Size> } */
    this.resolutions;
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextForOOPVD_AllocateSecureBuffer_ParamsSpec.$,
    'CdmContextForOOPVD_AllocateSecureBuffer_Params',
    [
      mojo.internal.StructField(
        'size', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.CdmContextForOOPVD_AllocateSecureBuffer_Params = class {
  constructor() {
    /** @export { !number } */
    this.size;
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextForOOPVD_AllocateSecureBuffer_ResponseParamsSpec.$,
    'CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams',
    [
      mojo.internal.StructField(
        'secureBuffer', 0,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams = class {
  constructor() {
    /** @export { (MojoHandle|undefined) } */
    this.secureBuffer;
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextForOOPVD_ParseEncryptedSliceHeader_ParamsSpec.$,
    'CdmContextForOOPVD_ParseEncryptedSliceHeader_Params',
    [
      mojo.internal.StructField(
        'secureHandle', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'offset', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'streamData', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
media.mojom.CdmContextForOOPVD_ParseEncryptedSliceHeader_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.secureHandle;
    /** @export { !number } */
    this.offset;
    /** @export { !Array<!number> } */
    this.streamData;
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParamsSpec.$,
    'CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sliceHeader', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
media.mojom.CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !Array<!number> } */
    this.sliceHeader;
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextForOOPVD_DecryptVideoBuffer_ParamsSpec.$,
    'CdmContextForOOPVD_DecryptVideoBuffer_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media.mojom.DecoderBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bytes', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
media.mojom.CdmContextForOOPVD_DecryptVideoBuffer_Params = class {
  constructor() {
    /** @export { !media.mojom.DecoderBuffer } */
    this.buffer;
    /** @export { !Array<!number> } */
    this.bytes;
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextForOOPVD_DecryptVideoBuffer_ResponseParamsSpec.$,
    'CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.DecryptStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'decoderBuffer', 8,
        0,
        media.mojom.DecoderBufferSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bytes', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
media.mojom.CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.DecryptStatus } */
    this.status;
    /** @export { (media.mojom.DecoderBuffer|undefined) } */
    this.decoderBuffer;
    /** @export { !Array<!number> } */
    this.bytes;
  }
};

