// media/mojo/mojom/cdm_context_for_oopvd.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/cdm_context_for_oopvd.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', 'media_types.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }


  var DecryptStatus = {};
  DecryptStatus.kSuccess = 0;
  DecryptStatus.kNoKey = 1;
  DecryptStatus.kFailure = 2;
  DecryptStatus.MIN_VALUE = 0;
  DecryptStatus.MAX_VALUE = 2;

  DecryptStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  DecryptStatus.toKnownEnumValue = function(value) {
    return value;
  };

  DecryptStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CdmContextEvent = {};
  CdmContextEvent.kHasAdditionalUsableKey = 0;
  CdmContextEvent.kHardwareContextReset = 1;
  CdmContextEvent.MIN_VALUE = 0;
  CdmContextEvent.MAX_VALUE = 1;

  CdmContextEvent.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  CdmContextEvent.toKnownEnumValue = function(value) {
    return value;
  };

  CdmContextEvent.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function CdmContextEventCallback_EventCallback_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextEventCallback_EventCallback_Params.prototype.initDefaults_ = function() {
    this.event = 0;
  };
  CdmContextEventCallback_EventCallback_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextEventCallback_EventCallback_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmContextEventCallback_EventCallback_Params.event
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CdmContextEvent);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmContextEventCallback_EventCallback_Params.encodedSize = codec.kStructHeaderSize + 8;

  CdmContextEventCallback_EventCallback_Params.decode = function(decoder) {
    var packed;
    var val = new CdmContextEventCallback_EventCallback_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.event =
        decoder.decodeStruct(new codec.Enum(CdmContextEvent));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CdmContextEventCallback_EventCallback_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextEventCallback_EventCallback_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.event);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CdmContextForOOPVD_GetHwKeyData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextForOOPVD_GetHwKeyData_Params.prototype.initDefaults_ = function() {
    this.decryptConfig = null;
    this.hwIdentifier = null;
  };
  CdmContextForOOPVD_GetHwKeyData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextForOOPVD_GetHwKeyData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmContextForOOPVD_GetHwKeyData_Params.decryptConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.DecryptConfig, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmContextForOOPVD_GetHwKeyData_Params.hwIdentifier
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmContextForOOPVD_GetHwKeyData_Params.encodedSize = codec.kStructHeaderSize + 16;

  CdmContextForOOPVD_GetHwKeyData_Params.decode = function(decoder) {
    var packed;
    var val = new CdmContextForOOPVD_GetHwKeyData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.decryptConfig =
        decoder.decodeStructPointer(media_types$.DecryptConfig);
    val.hwIdentifier =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  CdmContextForOOPVD_GetHwKeyData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextForOOPVD_GetHwKeyData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.DecryptConfig, val.decryptConfig);
    encoder.encodeArrayPointer(codec.Uint8, val.hwIdentifier);
  };
  function CdmContextForOOPVD_GetHwKeyData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextForOOPVD_GetHwKeyData_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.keyData = null;
  };
  CdmContextForOOPVD_GetHwKeyData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextForOOPVD_GetHwKeyData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmContextForOOPVD_GetHwKeyData_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, DecryptStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmContextForOOPVD_GetHwKeyData_ResponseParams.keyData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmContextForOOPVD_GetHwKeyData_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CdmContextForOOPVD_GetHwKeyData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CdmContextForOOPVD_GetHwKeyData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(DecryptStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.keyData =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  CdmContextForOOPVD_GetHwKeyData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextForOOPVD_GetHwKeyData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.keyData);
  };
  function CdmContextForOOPVD_RegisterEventCallback_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextForOOPVD_RegisterEventCallback_Params.prototype.initDefaults_ = function() {
    this.callback = new CdmContextEventCallbackPtr();
  };
  CdmContextForOOPVD_RegisterEventCallback_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextForOOPVD_RegisterEventCallback_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmContextForOOPVD_RegisterEventCallback_Params.callback
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmContextForOOPVD_RegisterEventCallback_Params.encodedSize = codec.kStructHeaderSize + 8;

  CdmContextForOOPVD_RegisterEventCallback_Params.decode = function(decoder) {
    var packed;
    var val = new CdmContextForOOPVD_RegisterEventCallback_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.callback =
        decoder.decodeStruct(new codec.Interface(CdmContextEventCallbackPtr));
    return val;
  };

  CdmContextForOOPVD_RegisterEventCallback_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextForOOPVD_RegisterEventCallback_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(CdmContextEventCallbackPtr), val.callback);
  };
  function CdmContextForOOPVD_GetHwConfigData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextForOOPVD_GetHwConfigData_Params.prototype.initDefaults_ = function() {
  };
  CdmContextForOOPVD_GetHwConfigData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextForOOPVD_GetHwConfigData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmContextForOOPVD_GetHwConfigData_Params.encodedSize = codec.kStructHeaderSize + 0;

  CdmContextForOOPVD_GetHwConfigData_Params.decode = function(decoder) {
    var packed;
    var val = new CdmContextForOOPVD_GetHwConfigData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CdmContextForOOPVD_GetHwConfigData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextForOOPVD_GetHwConfigData_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CdmContextForOOPVD_GetHwConfigData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextForOOPVD_GetHwConfigData_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.configData = null;
  };
  CdmContextForOOPVD_GetHwConfigData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextForOOPVD_GetHwConfigData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CdmContextForOOPVD_GetHwConfigData_ResponseParams.configData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmContextForOOPVD_GetHwConfigData_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CdmContextForOOPVD_GetHwConfigData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CdmContextForOOPVD_GetHwConfigData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.configData =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  CdmContextForOOPVD_GetHwConfigData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextForOOPVD_GetHwConfigData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.configData);
  };
  function CdmContextForOOPVD_GetScreenResolutions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextForOOPVD_GetScreenResolutions_Params.prototype.initDefaults_ = function() {
  };
  CdmContextForOOPVD_GetScreenResolutions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextForOOPVD_GetScreenResolutions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmContextForOOPVD_GetScreenResolutions_Params.encodedSize = codec.kStructHeaderSize + 0;

  CdmContextForOOPVD_GetScreenResolutions_Params.decode = function(decoder) {
    var packed;
    var val = new CdmContextForOOPVD_GetScreenResolutions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CdmContextForOOPVD_GetScreenResolutions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextForOOPVD_GetScreenResolutions_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CdmContextForOOPVD_GetScreenResolutions_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextForOOPVD_GetScreenResolutions_ResponseParams.prototype.initDefaults_ = function() {
    this.resolutions = null;
  };
  CdmContextForOOPVD_GetScreenResolutions_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextForOOPVD_GetScreenResolutions_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmContextForOOPVD_GetScreenResolutions_ResponseParams.resolutions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(geometry$.Size), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmContextForOOPVD_GetScreenResolutions_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CdmContextForOOPVD_GetScreenResolutions_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CdmContextForOOPVD_GetScreenResolutions_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.resolutions =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.Size));
    return val;
  };

  CdmContextForOOPVD_GetScreenResolutions_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextForOOPVD_GetScreenResolutions_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.Size), val.resolutions);
  };
  function CdmContextForOOPVD_AllocateSecureBuffer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextForOOPVD_AllocateSecureBuffer_Params.prototype.initDefaults_ = function() {
    this.size = 0;
  };
  CdmContextForOOPVD_AllocateSecureBuffer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextForOOPVD_AllocateSecureBuffer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CdmContextForOOPVD_AllocateSecureBuffer_Params.encodedSize = codec.kStructHeaderSize + 8;

  CdmContextForOOPVD_AllocateSecureBuffer_Params.decode = function(decoder) {
    var packed;
    var val = new CdmContextForOOPVD_AllocateSecureBuffer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.size =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CdmContextForOOPVD_AllocateSecureBuffer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextForOOPVD_AllocateSecureBuffer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.size);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams.prototype.initDefaults_ = function() {
    this.secureBuffer = null;
  };
  CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams.secureBuffer
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.secureBuffer =
        decoder.decodeStruct(codec.Handle);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Handle, val.secureBuffer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CdmContextForOOPVD_ParseEncryptedSliceHeader_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextForOOPVD_ParseEncryptedSliceHeader_Params.prototype.initDefaults_ = function() {
    this.secureHandle = 0;
    this.offset = 0;
    this.streamData = null;
  };
  CdmContextForOOPVD_ParseEncryptedSliceHeader_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextForOOPVD_ParseEncryptedSliceHeader_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate CdmContextForOOPVD_ParseEncryptedSliceHeader_Params.streamData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmContextForOOPVD_ParseEncryptedSliceHeader_Params.encodedSize = codec.kStructHeaderSize + 24;

  CdmContextForOOPVD_ParseEncryptedSliceHeader_Params.decode = function(decoder) {
    var packed;
    var val = new CdmContextForOOPVD_ParseEncryptedSliceHeader_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.secureHandle =
        decoder.decodeStruct(codec.Uint64);
    val.offset =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.streamData =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  CdmContextForOOPVD_ParseEncryptedSliceHeader_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextForOOPVD_ParseEncryptedSliceHeader_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.secureHandle);
    encoder.encodeStruct(codec.Uint32, val.offset);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.streamData);
  };
  function CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.sliceHeader = null;
  };
  CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams.sliceHeader
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sliceHeader =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.sliceHeader);
  };
  function CdmContextForOOPVD_DecryptVideoBuffer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextForOOPVD_DecryptVideoBuffer_Params.prototype.initDefaults_ = function() {
    this.buffer = null;
    this.bytes = null;
  };
  CdmContextForOOPVD_DecryptVideoBuffer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextForOOPVD_DecryptVideoBuffer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmContextForOOPVD_DecryptVideoBuffer_Params.buffer
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, media_types$.DecoderBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmContextForOOPVD_DecryptVideoBuffer_Params.bytes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmContextForOOPVD_DecryptVideoBuffer_Params.encodedSize = codec.kStructHeaderSize + 24;

  CdmContextForOOPVD_DecryptVideoBuffer_Params.decode = function(decoder) {
    var packed;
    var val = new CdmContextForOOPVD_DecryptVideoBuffer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buffer =
        decoder.decodeStruct(media_types$.DecoderBuffer);
    val.bytes =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  CdmContextForOOPVD_DecryptVideoBuffer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextForOOPVD_DecryptVideoBuffer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(media_types$.DecoderBuffer, val.buffer);
    encoder.encodeArrayPointer(codec.Uint8, val.bytes);
  };
  function CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.decoderBuffer = null;
    this.bytes = null;
  };
  CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, DecryptStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams.decoderBuffer
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, media_types$.DecoderBuffer, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams.bytes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams.encodedSize = codec.kStructHeaderSize + 32;

  CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(DecryptStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.decoderBuffer =
        decoder.decodeStruct(media_types$.DecoderBuffer);
    val.bytes =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(media_types$.DecoderBuffer, val.decoderBuffer);
    encoder.encodeArrayPointer(codec.Uint8, val.bytes);
  };
  var kCdmContextEventCallback_EventCallback_Name = 0;

  function CdmContextEventCallbackPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CdmContextEventCallback,
                                                   handleOrPtrInfo);
  }

  function CdmContextEventCallbackAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CdmContextEventCallback, associatedInterfacePtrInfo);
  }

  CdmContextEventCallbackAssociatedPtr.prototype =
      Object.create(CdmContextEventCallbackPtr.prototype);
  CdmContextEventCallbackAssociatedPtr.prototype.constructor =
      CdmContextEventCallbackAssociatedPtr;

  function CdmContextEventCallbackProxy(receiver) {
    this.receiver_ = receiver;
  }
  CdmContextEventCallbackPtr.prototype.eventCallback = function() {
    return CdmContextEventCallbackProxy.prototype.eventCallback
        .apply(this.ptr.getProxy(), arguments);
  };

  CdmContextEventCallbackProxy.prototype.eventCallback = function(event) {
    var params_ = new CdmContextEventCallback_EventCallback_Params();
    params_.event = event;
    var builder = new codec.MessageV0Builder(
        kCdmContextEventCallback_EventCallback_Name,
        codec.align(CdmContextEventCallback_EventCallback_Params.encodedSize));
    builder.encodeStruct(CdmContextEventCallback_EventCallback_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function CdmContextEventCallbackStub(delegate) {
    this.delegate_ = delegate;
  }
  CdmContextEventCallbackStub.prototype.eventCallback = function(event) {
    return this.delegate_ && this.delegate_.eventCallback && this.delegate_.eventCallback(event);
  }

  CdmContextEventCallbackStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCdmContextEventCallback_EventCallback_Name:
      var params = reader.decodeStruct(CdmContextEventCallback_EventCallback_Params);
      this.eventCallback(params.event);
      return true;
    default:
      return false;
    }
  };

  CdmContextEventCallbackStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateCdmContextEventCallbackRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCdmContextEventCallback_EventCallback_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CdmContextEventCallback_EventCallback_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCdmContextEventCallbackResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var CdmContextEventCallback = {
    name: 'media.mojom.CdmContextEventCallback',
    kVersion: 0,
    ptrClass: CdmContextEventCallbackPtr,
    proxyClass: CdmContextEventCallbackProxy,
    stubClass: CdmContextEventCallbackStub,
    validateRequest: validateCdmContextEventCallbackRequest,
    validateResponse: null,
  };
  CdmContextEventCallbackStub.prototype.validator = validateCdmContextEventCallbackRequest;
  CdmContextEventCallbackProxy.prototype.validator = null;
  var kCdmContextForOOPVD_GetHwKeyData_Name = 0;
  var kCdmContextForOOPVD_RegisterEventCallback_Name = 1;
  var kCdmContextForOOPVD_GetHwConfigData_Name = 2;
  var kCdmContextForOOPVD_GetScreenResolutions_Name = 3;
  var kCdmContextForOOPVD_AllocateSecureBuffer_Name = 4;
  var kCdmContextForOOPVD_ParseEncryptedSliceHeader_Name = 5;
  var kCdmContextForOOPVD_DecryptVideoBuffer_Name = 6;

  function CdmContextForOOPVDPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CdmContextForOOPVD,
                                                   handleOrPtrInfo);
  }

  function CdmContextForOOPVDAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CdmContextForOOPVD, associatedInterfacePtrInfo);
  }

  CdmContextForOOPVDAssociatedPtr.prototype =
      Object.create(CdmContextForOOPVDPtr.prototype);
  CdmContextForOOPVDAssociatedPtr.prototype.constructor =
      CdmContextForOOPVDAssociatedPtr;

  function CdmContextForOOPVDProxy(receiver) {
    this.receiver_ = receiver;
  }
  CdmContextForOOPVDPtr.prototype.getHwKeyData = function() {
    return CdmContextForOOPVDProxy.prototype.getHwKeyData
        .apply(this.ptr.getProxy(), arguments);
  };

  CdmContextForOOPVDProxy.prototype.getHwKeyData = function(decryptConfig, hwIdentifier) {
    var params_ = new CdmContextForOOPVD_GetHwKeyData_Params();
    params_.decryptConfig = decryptConfig;
    params_.hwIdentifier = hwIdentifier;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCdmContextForOOPVD_GetHwKeyData_Name,
          codec.align(CdmContextForOOPVD_GetHwKeyData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CdmContextForOOPVD_GetHwKeyData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CdmContextForOOPVD_GetHwKeyData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CdmContextForOOPVDPtr.prototype.registerEventCallback = function() {
    return CdmContextForOOPVDProxy.prototype.registerEventCallback
        .apply(this.ptr.getProxy(), arguments);
  };

  CdmContextForOOPVDProxy.prototype.registerEventCallback = function(callback) {
    var params_ = new CdmContextForOOPVD_RegisterEventCallback_Params();
    params_.callback = callback;
    var builder = new codec.MessageV0Builder(
        kCdmContextForOOPVD_RegisterEventCallback_Name,
        codec.align(CdmContextForOOPVD_RegisterEventCallback_Params.encodedSize));
    builder.encodeStruct(CdmContextForOOPVD_RegisterEventCallback_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CdmContextForOOPVDPtr.prototype.getHwConfigData = function() {
    return CdmContextForOOPVDProxy.prototype.getHwConfigData
        .apply(this.ptr.getProxy(), arguments);
  };

  CdmContextForOOPVDProxy.prototype.getHwConfigData = function() {
    var params_ = new CdmContextForOOPVD_GetHwConfigData_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCdmContextForOOPVD_GetHwConfigData_Name,
          codec.align(CdmContextForOOPVD_GetHwConfigData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CdmContextForOOPVD_GetHwConfigData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CdmContextForOOPVD_GetHwConfigData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CdmContextForOOPVDPtr.prototype.getScreenResolutions = function() {
    return CdmContextForOOPVDProxy.prototype.getScreenResolutions
        .apply(this.ptr.getProxy(), arguments);
  };

  CdmContextForOOPVDProxy.prototype.getScreenResolutions = function() {
    var params_ = new CdmContextForOOPVD_GetScreenResolutions_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCdmContextForOOPVD_GetScreenResolutions_Name,
          codec.align(CdmContextForOOPVD_GetScreenResolutions_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CdmContextForOOPVD_GetScreenResolutions_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CdmContextForOOPVD_GetScreenResolutions_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CdmContextForOOPVDPtr.prototype.allocateSecureBuffer = function() {
    return CdmContextForOOPVDProxy.prototype.allocateSecureBuffer
        .apply(this.ptr.getProxy(), arguments);
  };

  CdmContextForOOPVDProxy.prototype.allocateSecureBuffer = function(size) {
    var params_ = new CdmContextForOOPVD_AllocateSecureBuffer_Params();
    params_.size = size;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCdmContextForOOPVD_AllocateSecureBuffer_Name,
          codec.align(CdmContextForOOPVD_AllocateSecureBuffer_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CdmContextForOOPVD_AllocateSecureBuffer_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CdmContextForOOPVDPtr.prototype.parseEncryptedSliceHeader = function() {
    return CdmContextForOOPVDProxy.prototype.parseEncryptedSliceHeader
        .apply(this.ptr.getProxy(), arguments);
  };

  CdmContextForOOPVDProxy.prototype.parseEncryptedSliceHeader = function(secureHandle, offset, streamData) {
    var params_ = new CdmContextForOOPVD_ParseEncryptedSliceHeader_Params();
    params_.secureHandle = secureHandle;
    params_.offset = offset;
    params_.streamData = streamData;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCdmContextForOOPVD_ParseEncryptedSliceHeader_Name,
          codec.align(CdmContextForOOPVD_ParseEncryptedSliceHeader_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CdmContextForOOPVD_ParseEncryptedSliceHeader_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CdmContextForOOPVDPtr.prototype.decryptVideoBuffer = function() {
    return CdmContextForOOPVDProxy.prototype.decryptVideoBuffer
        .apply(this.ptr.getProxy(), arguments);
  };

  CdmContextForOOPVDProxy.prototype.decryptVideoBuffer = function(buffer, bytes) {
    var params_ = new CdmContextForOOPVD_DecryptVideoBuffer_Params();
    params_.buffer = buffer;
    params_.bytes = bytes;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCdmContextForOOPVD_DecryptVideoBuffer_Name,
          codec.align(CdmContextForOOPVD_DecryptVideoBuffer_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CdmContextForOOPVD_DecryptVideoBuffer_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function CdmContextForOOPVDStub(delegate) {
    this.delegate_ = delegate;
  }
  CdmContextForOOPVDStub.prototype.getHwKeyData = function(decryptConfig, hwIdentifier) {
    return this.delegate_ && this.delegate_.getHwKeyData && this.delegate_.getHwKeyData(decryptConfig, hwIdentifier);
  }
  CdmContextForOOPVDStub.prototype.registerEventCallback = function(callback) {
    return this.delegate_ && this.delegate_.registerEventCallback && this.delegate_.registerEventCallback(callback);
  }
  CdmContextForOOPVDStub.prototype.getHwConfigData = function() {
    return this.delegate_ && this.delegate_.getHwConfigData && this.delegate_.getHwConfigData();
  }
  CdmContextForOOPVDStub.prototype.getScreenResolutions = function() {
    return this.delegate_ && this.delegate_.getScreenResolutions && this.delegate_.getScreenResolutions();
  }
  CdmContextForOOPVDStub.prototype.allocateSecureBuffer = function(size) {
    return this.delegate_ && this.delegate_.allocateSecureBuffer && this.delegate_.allocateSecureBuffer(size);
  }
  CdmContextForOOPVDStub.prototype.parseEncryptedSliceHeader = function(secureHandle, offset, streamData) {
    return this.delegate_ && this.delegate_.parseEncryptedSliceHeader && this.delegate_.parseEncryptedSliceHeader(secureHandle, offset, streamData);
  }
  CdmContextForOOPVDStub.prototype.decryptVideoBuffer = function(buffer, bytes) {
    return this.delegate_ && this.delegate_.decryptVideoBuffer && this.delegate_.decryptVideoBuffer(buffer, bytes);
  }

  CdmContextForOOPVDStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCdmContextForOOPVD_RegisterEventCallback_Name:
      var params = reader.decodeStruct(CdmContextForOOPVD_RegisterEventCallback_Params);
      this.registerEventCallback(params.callback);
      return true;
    default:
      return false;
    }
  };

  CdmContextForOOPVDStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCdmContextForOOPVD_GetHwKeyData_Name:
      var params = reader.decodeStruct(CdmContextForOOPVD_GetHwKeyData_Params);
      this.getHwKeyData(params.decryptConfig, params.hwIdentifier).then(function(response) {
        var responseParams =
            new CdmContextForOOPVD_GetHwKeyData_ResponseParams();
        responseParams.status = response.status;
        responseParams.keyData = response.keyData;
        var builder = new codec.MessageV1Builder(
            kCdmContextForOOPVD_GetHwKeyData_Name,
            codec.align(CdmContextForOOPVD_GetHwKeyData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CdmContextForOOPVD_GetHwKeyData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCdmContextForOOPVD_GetHwConfigData_Name:
      var params = reader.decodeStruct(CdmContextForOOPVD_GetHwConfigData_Params);
      this.getHwConfigData().then(function(response) {
        var responseParams =
            new CdmContextForOOPVD_GetHwConfigData_ResponseParams();
        responseParams.success = response.success;
        responseParams.configData = response.configData;
        var builder = new codec.MessageV1Builder(
            kCdmContextForOOPVD_GetHwConfigData_Name,
            codec.align(CdmContextForOOPVD_GetHwConfigData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CdmContextForOOPVD_GetHwConfigData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCdmContextForOOPVD_GetScreenResolutions_Name:
      var params = reader.decodeStruct(CdmContextForOOPVD_GetScreenResolutions_Params);
      this.getScreenResolutions().then(function(response) {
        var responseParams =
            new CdmContextForOOPVD_GetScreenResolutions_ResponseParams();
        responseParams.resolutions = response.resolutions;
        var builder = new codec.MessageV1Builder(
            kCdmContextForOOPVD_GetScreenResolutions_Name,
            codec.align(CdmContextForOOPVD_GetScreenResolutions_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CdmContextForOOPVD_GetScreenResolutions_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCdmContextForOOPVD_AllocateSecureBuffer_Name:
      var params = reader.decodeStruct(CdmContextForOOPVD_AllocateSecureBuffer_Params);
      this.allocateSecureBuffer(params.size).then(function(response) {
        var responseParams =
            new CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams();
        responseParams.secureBuffer = response.secureBuffer;
        var builder = new codec.MessageV1Builder(
            kCdmContextForOOPVD_AllocateSecureBuffer_Name,
            codec.align(CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCdmContextForOOPVD_ParseEncryptedSliceHeader_Name:
      var params = reader.decodeStruct(CdmContextForOOPVD_ParseEncryptedSliceHeader_Params);
      this.parseEncryptedSliceHeader(params.secureHandle, params.offset, params.streamData).then(function(response) {
        var responseParams =
            new CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams();
        responseParams.success = response.success;
        responseParams.sliceHeader = response.sliceHeader;
        var builder = new codec.MessageV1Builder(
            kCdmContextForOOPVD_ParseEncryptedSliceHeader_Name,
            codec.align(CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCdmContextForOOPVD_DecryptVideoBuffer_Name:
      var params = reader.decodeStruct(CdmContextForOOPVD_DecryptVideoBuffer_Params);
      this.decryptVideoBuffer(params.buffer, params.bytes).then(function(response) {
        var responseParams =
            new CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams();
        responseParams.status = response.status;
        responseParams.decoderBuffer = response.decoderBuffer;
        responseParams.bytes = response.bytes;
        var builder = new codec.MessageV1Builder(
            kCdmContextForOOPVD_DecryptVideoBuffer_Name,
            codec.align(CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCdmContextForOOPVDRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCdmContextForOOPVD_GetHwKeyData_Name:
        if (message.expectsResponse())
          paramsClass = CdmContextForOOPVD_GetHwKeyData_Params;
      break;
      case kCdmContextForOOPVD_RegisterEventCallback_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CdmContextForOOPVD_RegisterEventCallback_Params;
      break;
      case kCdmContextForOOPVD_GetHwConfigData_Name:
        if (message.expectsResponse())
          paramsClass = CdmContextForOOPVD_GetHwConfigData_Params;
      break;
      case kCdmContextForOOPVD_GetScreenResolutions_Name:
        if (message.expectsResponse())
          paramsClass = CdmContextForOOPVD_GetScreenResolutions_Params;
      break;
      case kCdmContextForOOPVD_AllocateSecureBuffer_Name:
        if (message.expectsResponse())
          paramsClass = CdmContextForOOPVD_AllocateSecureBuffer_Params;
      break;
      case kCdmContextForOOPVD_ParseEncryptedSliceHeader_Name:
        if (message.expectsResponse())
          paramsClass = CdmContextForOOPVD_ParseEncryptedSliceHeader_Params;
      break;
      case kCdmContextForOOPVD_DecryptVideoBuffer_Name:
        if (message.expectsResponse())
          paramsClass = CdmContextForOOPVD_DecryptVideoBuffer_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCdmContextForOOPVDResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCdmContextForOOPVD_GetHwKeyData_Name:
        if (message.isResponse())
          paramsClass = CdmContextForOOPVD_GetHwKeyData_ResponseParams;
        break;
      case kCdmContextForOOPVD_GetHwConfigData_Name:
        if (message.isResponse())
          paramsClass = CdmContextForOOPVD_GetHwConfigData_ResponseParams;
        break;
      case kCdmContextForOOPVD_GetScreenResolutions_Name:
        if (message.isResponse())
          paramsClass = CdmContextForOOPVD_GetScreenResolutions_ResponseParams;
        break;
      case kCdmContextForOOPVD_AllocateSecureBuffer_Name:
        if (message.isResponse())
          paramsClass = CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams;
        break;
      case kCdmContextForOOPVD_ParseEncryptedSliceHeader_Name:
        if (message.isResponse())
          paramsClass = CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams;
        break;
      case kCdmContextForOOPVD_DecryptVideoBuffer_Name:
        if (message.isResponse())
          paramsClass = CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CdmContextForOOPVD = {
    name: 'media.mojom.CdmContextForOOPVD',
    kVersion: 0,
    ptrClass: CdmContextForOOPVDPtr,
    proxyClass: CdmContextForOOPVDProxy,
    stubClass: CdmContextForOOPVDStub,
    validateRequest: validateCdmContextForOOPVDRequest,
    validateResponse: validateCdmContextForOOPVDResponse,
  };
  CdmContextForOOPVDStub.prototype.validator = validateCdmContextForOOPVDRequest;
  CdmContextForOOPVDProxy.prototype.validator = validateCdmContextForOOPVDResponse;
  exports.DecryptStatus = DecryptStatus;
  exports.CdmContextEvent = CdmContextEvent;
  exports.CdmContextEventCallback = CdmContextEventCallback;
  exports.CdmContextEventCallbackPtr = CdmContextEventCallbackPtr;
  exports.CdmContextEventCallbackAssociatedPtr = CdmContextEventCallbackAssociatedPtr;
  exports.CdmContextForOOPVD = CdmContextForOOPVD;
  exports.CdmContextForOOPVDPtr = CdmContextForOOPVDPtr;
  exports.CdmContextForOOPVDAssociatedPtr = CdmContextForOOPVDAssociatedPtr;
})();