// media/mojo/mojom/cdm_context_for_oopvd.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  DecryptConfig as media_mojom_DecryptConfig,
  DecryptConfigSpec as media_mojom_DecryptConfigSpec,
  DecoderBuffer as media_mojom_DecoderBuffer,
  DecoderBufferSpec as media_mojom_DecoderBufferSpec
} from './media_types.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DecryptStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DecryptStatus = {
  
  kSuccess: 0,
  kNoKey: 1,
  kFailure: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CdmContextEventSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CdmContextEvent = {
  
  kHasAdditionalUsableKey: 0,
  kHardwareContextReset: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CdmContextEventCallbackPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.CdmContextEventCallback', scope);
  }
}

/** @interface */
export class CdmContextEventCallbackInterface {
  
  /**
   * @param { !CdmContextEvent } event
   */

  eventCallback(event) {}
}

/**
 * @implements { CdmContextEventCallbackInterface }
 */
export class CdmContextEventCallbackRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CdmContextEventCallbackPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CdmContextEventCallbackPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CdmContextEventCallbackPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !CdmContextEvent } event
   */

  eventCallback(
      event) {
    this.proxy.sendMessage(
        0,
        CdmContextEventCallback_EventCallback_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CdmContextEventCallback
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CdmContextEventCallbackReceiver {
  /**
   * @param {!CdmContextEventCallbackInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CdmContextEventCallbackRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CdmContextEventCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmContextEventCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CdmContextEventCallback_EventCallback_ParamsSpec.$,
        null,
        impl.eventCallback.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CdmContextEventCallback {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.CdmContextEventCallback";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CdmContextEventCallbackRemote}
   */
  static getRemote() {
    let remote = new CdmContextEventCallbackRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CdmContextEventCallback
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CdmContextEventCallbackCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CdmContextEventCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmContextEventCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.eventCallback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CdmContextEventCallback_EventCallback_ParamsSpec.$,
        null,
        this.eventCallback.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CdmContextForOOPVDPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.CdmContextForOOPVD', scope);
  }
}

/** @interface */
export class CdmContextForOOPVDInterface {
  
  /**
   * @param { !media_mojom_DecryptConfig } decryptConfig
   * @param { !Array<!number> } hwIdentifier
   * @return {!Promise<{
        status: !DecryptStatus,
        keyData: !Array<!number>,
   *  }>}
   */

  getHwKeyData(decryptConfig, hwIdentifier) {}
  
  /**
   * @param { !CdmContextEventCallbackRemote } callback
   */

  registerEventCallback(callback) {}
  
  /**
   * @return {!Promise<{
        success: !boolean,
        configData: !Array<!number>,
   *  }>}
   */

  getHwConfigData() {}
  
  /**
   * @return {!Promise<{
        resolutions: !Array<!gfx_mojom_Size>,
   *  }>}
   */

  getScreenResolutions() {}
  
  /**
   * @param { !number } size
   * @return {!Promise<{
        secureBuffer: ?MojoHandle,
   *  }>}
   */

  allocateSecureBuffer(size) {}
  
  /**
   * @param { !bigint } secureHandle
   * @param { !number } offset
   * @param { !Array<!number> } streamData
   * @return {!Promise<{
        success: !boolean,
        sliceHeader: !Array<!number>,
   *  }>}
   */

  parseEncryptedSliceHeader(secureHandle, offset, streamData) {}
  
  /**
   * @param { !media_mojom_DecoderBuffer } buffer
   * @param { !Array<!number> } bytes
   * @return {!Promise<{
        status: !DecryptStatus,
        decoderBuffer: ?media_mojom_DecoderBuffer,
        bytes: !Array<!number>,
   *  }>}
   */

  decryptVideoBuffer(buffer, bytes) {}
}

/**
 * @implements { CdmContextForOOPVDInterface }
 */
export class CdmContextForOOPVDRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CdmContextForOOPVDPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CdmContextForOOPVDPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CdmContextForOOPVDPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_DecryptConfig } decryptConfig
   * @param { !Array<!number> } hwIdentifier
   * @return {!Promise<{
        status: !DecryptStatus,
        keyData: !Array<!number>,
   *  }>}
   */

  getHwKeyData(
      decryptConfig,
      hwIdentifier) {
    return this.proxy.sendMessage(
        0,
        CdmContextForOOPVD_GetHwKeyData_ParamsSpec.$,
        CdmContextForOOPVD_GetHwKeyData_ResponseParamsSpec.$,
        [
          decryptConfig,
          hwIdentifier
        ],
        false);
  }

  
  /**
   * @param { !CdmContextEventCallbackRemote } callback
   */

  registerEventCallback(
      callback) {
    this.proxy.sendMessage(
        1,
        CdmContextForOOPVD_RegisterEventCallback_ParamsSpec.$,
        null,
        [
          callback
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
        configData: !Array<!number>,
   *  }>}
   */

  getHwConfigData() {
    return this.proxy.sendMessage(
        2,
        CdmContextForOOPVD_GetHwConfigData_ParamsSpec.$,
        CdmContextForOOPVD_GetHwConfigData_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        resolutions: !Array<!gfx_mojom_Size>,
   *  }>}
   */

  getScreenResolutions() {
    return this.proxy.sendMessage(
        3,
        CdmContextForOOPVD_GetScreenResolutions_ParamsSpec.$,
        CdmContextForOOPVD_GetScreenResolutions_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } size
   * @return {!Promise<{
        secureBuffer: ?MojoHandle,
   *  }>}
   */

  allocateSecureBuffer(
      size) {
    return this.proxy.sendMessage(
        4,
        CdmContextForOOPVD_AllocateSecureBuffer_ParamsSpec.$,
        CdmContextForOOPVD_AllocateSecureBuffer_ResponseParamsSpec.$,
        [
          size
        ],
        false);
  }

  
  /**
   * @param { !bigint } secureHandle
   * @param { !number } offset
   * @param { !Array<!number> } streamData
   * @return {!Promise<{
        success: !boolean,
        sliceHeader: !Array<!number>,
   *  }>}
   */

  parseEncryptedSliceHeader(
      secureHandle,
      offset,
      streamData) {
    return this.proxy.sendMessage(
        5,
        CdmContextForOOPVD_ParseEncryptedSliceHeader_ParamsSpec.$,
        CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParamsSpec.$,
        [
          secureHandle,
          offset,
          streamData
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_DecoderBuffer } buffer
   * @param { !Array<!number> } bytes
   * @return {!Promise<{
        status: !DecryptStatus,
        decoderBuffer: ?media_mojom_DecoderBuffer,
        bytes: !Array<!number>,
   *  }>}
   */

  decryptVideoBuffer(
      buffer,
      bytes) {
    return this.proxy.sendMessage(
        6,
        CdmContextForOOPVD_DecryptVideoBuffer_ParamsSpec.$,
        CdmContextForOOPVD_DecryptVideoBuffer_ResponseParamsSpec.$,
        [
          buffer,
          bytes
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CdmContextForOOPVD
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CdmContextForOOPVDReceiver {
  /**
   * @param {!CdmContextForOOPVDInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CdmContextForOOPVDRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CdmContextForOOPVDRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmContextForOOPVDRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CdmContextForOOPVD_GetHwKeyData_ParamsSpec.$,
        CdmContextForOOPVD_GetHwKeyData_ResponseParamsSpec.$,
        impl.getHwKeyData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CdmContextForOOPVD_RegisterEventCallback_ParamsSpec.$,
        null,
        impl.registerEventCallback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CdmContextForOOPVD_GetHwConfigData_ParamsSpec.$,
        CdmContextForOOPVD_GetHwConfigData_ResponseParamsSpec.$,
        impl.getHwConfigData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CdmContextForOOPVD_GetScreenResolutions_ParamsSpec.$,
        CdmContextForOOPVD_GetScreenResolutions_ResponseParamsSpec.$,
        impl.getScreenResolutions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        CdmContextForOOPVD_AllocateSecureBuffer_ParamsSpec.$,
        CdmContextForOOPVD_AllocateSecureBuffer_ResponseParamsSpec.$,
        impl.allocateSecureBuffer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        CdmContextForOOPVD_ParseEncryptedSliceHeader_ParamsSpec.$,
        CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParamsSpec.$,
        impl.parseEncryptedSliceHeader.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        CdmContextForOOPVD_DecryptVideoBuffer_ParamsSpec.$,
        CdmContextForOOPVD_DecryptVideoBuffer_ResponseParamsSpec.$,
        impl.decryptVideoBuffer.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CdmContextForOOPVD {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.CdmContextForOOPVD";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CdmContextForOOPVDRemote}
   */
  static getRemote() {
    let remote = new CdmContextForOOPVDRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CdmContextForOOPVD
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CdmContextForOOPVDCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CdmContextForOOPVDRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CdmContextForOOPVDRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getHwKeyData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CdmContextForOOPVD_GetHwKeyData_ParamsSpec.$,
        CdmContextForOOPVD_GetHwKeyData_ResponseParamsSpec.$,
        this.getHwKeyData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerEventCallback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CdmContextForOOPVD_RegisterEventCallback_ParamsSpec.$,
        null,
        this.registerEventCallback.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getHwConfigData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CdmContextForOOPVD_GetHwConfigData_ParamsSpec.$,
        CdmContextForOOPVD_GetHwConfigData_ResponseParamsSpec.$,
        this.getHwConfigData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getScreenResolutions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CdmContextForOOPVD_GetScreenResolutions_ParamsSpec.$,
        CdmContextForOOPVD_GetScreenResolutions_ResponseParamsSpec.$,
        this.getScreenResolutions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.allocateSecureBuffer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        CdmContextForOOPVD_AllocateSecureBuffer_ParamsSpec.$,
        CdmContextForOOPVD_AllocateSecureBuffer_ResponseParamsSpec.$,
        this.allocateSecureBuffer.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.parseEncryptedSliceHeader =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        CdmContextForOOPVD_ParseEncryptedSliceHeader_ParamsSpec.$,
        CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParamsSpec.$,
        this.parseEncryptedSliceHeader.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decryptVideoBuffer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        CdmContextForOOPVD_DecryptVideoBuffer_ParamsSpec.$,
        CdmContextForOOPVD_DecryptVideoBuffer_ResponseParamsSpec.$,
        this.decryptVideoBuffer.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextEventCallback_EventCallback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextForOOPVD_GetHwKeyData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextForOOPVD_GetHwKeyData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextForOOPVD_RegisterEventCallback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextForOOPVD_GetHwConfigData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextForOOPVD_GetHwConfigData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextForOOPVD_GetScreenResolutions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextForOOPVD_GetScreenResolutions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextForOOPVD_AllocateSecureBuffer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextForOOPVD_AllocateSecureBuffer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextForOOPVD_ParseEncryptedSliceHeader_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextForOOPVD_DecryptVideoBuffer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmContextForOOPVD_DecryptVideoBuffer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CdmContextEventCallback_EventCallback_ParamsSpec.$,
    'CdmContextEventCallback_EventCallback_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        CdmContextEventSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CdmContextEventCallback_EventCallback_Params {
  constructor() {
    /** @type { !CdmContextEvent } */
    this.event;
  }
}



mojo.internal.Struct(
    CdmContextForOOPVD_GetHwKeyData_ParamsSpec.$,
    'CdmContextForOOPVD_GetHwKeyData_Params',
    [
      mojo.internal.StructField(
        'decryptConfig', 0,
        0,
        media_mojom_DecryptConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hwIdentifier', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CdmContextForOOPVD_GetHwKeyData_Params {
  constructor() {
    /** @type { !media_mojom_DecryptConfig } */
    this.decryptConfig;
    /** @type { !Array<!number> } */
    this.hwIdentifier;
  }
}



mojo.internal.Struct(
    CdmContextForOOPVD_GetHwKeyData_ResponseParamsSpec.$,
    'CdmContextForOOPVD_GetHwKeyData_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        DecryptStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyData', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CdmContextForOOPVD_GetHwKeyData_ResponseParams {
  constructor() {
    /** @type { !DecryptStatus } */
    this.status;
    /** @type { !Array<!number> } */
    this.keyData;
  }
}



mojo.internal.Struct(
    CdmContextForOOPVD_RegisterEventCallback_ParamsSpec.$,
    'CdmContextForOOPVD_RegisterEventCallback_Params',
    [
      mojo.internal.StructField(
        'callback', 0,
        0,
        mojo.internal.InterfaceProxy(CdmContextEventCallbackRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CdmContextForOOPVD_RegisterEventCallback_Params {
  constructor() {
    /** @type { !CdmContextEventCallbackRemote } */
    this.callback;
  }
}



mojo.internal.Struct(
    CdmContextForOOPVD_GetHwConfigData_ParamsSpec.$,
    'CdmContextForOOPVD_GetHwConfigData_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CdmContextForOOPVD_GetHwConfigData_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CdmContextForOOPVD_GetHwConfigData_ResponseParamsSpec.$,
    'CdmContextForOOPVD_GetHwConfigData_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'configData', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CdmContextForOOPVD_GetHwConfigData_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !Array<!number> } */
    this.configData;
  }
}



mojo.internal.Struct(
    CdmContextForOOPVD_GetScreenResolutions_ParamsSpec.$,
    'CdmContextForOOPVD_GetScreenResolutions_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CdmContextForOOPVD_GetScreenResolutions_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CdmContextForOOPVD_GetScreenResolutions_ResponseParamsSpec.$,
    'CdmContextForOOPVD_GetScreenResolutions_ResponseParams',
    [
      mojo.internal.StructField(
        'resolutions', 0,
        0,
        mojo.internal.Array(gfx_mojom_SizeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CdmContextForOOPVD_GetScreenResolutions_ResponseParams {
  constructor() {
    /** @type { !Array<!gfx_mojom_Size> } */
    this.resolutions;
  }
}



mojo.internal.Struct(
    CdmContextForOOPVD_AllocateSecureBuffer_ParamsSpec.$,
    'CdmContextForOOPVD_AllocateSecureBuffer_Params',
    [
      mojo.internal.StructField(
        'size', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CdmContextForOOPVD_AllocateSecureBuffer_Params {
  constructor() {
    /** @type { !number } */
    this.size;
  }
}



mojo.internal.Struct(
    CdmContextForOOPVD_AllocateSecureBuffer_ResponseParamsSpec.$,
    'CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams',
    [
      mojo.internal.StructField(
        'secureBuffer', 0,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams {
  constructor() {
    /** @type { (MojoHandle|undefined) } */
    this.secureBuffer;
  }
}



mojo.internal.Struct(
    CdmContextForOOPVD_ParseEncryptedSliceHeader_ParamsSpec.$,
    'CdmContextForOOPVD_ParseEncryptedSliceHeader_Params',
    [
      mojo.internal.StructField(
        'secureHandle', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'offset', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streamData', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CdmContextForOOPVD_ParseEncryptedSliceHeader_Params {
  constructor() {
    /** @type { !bigint } */
    this.secureHandle;
    /** @type { !number } */
    this.offset;
    /** @type { !Array<!number> } */
    this.streamData;
  }
}



mojo.internal.Struct(
    CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParamsSpec.$,
    'CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sliceHeader', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !Array<!number> } */
    this.sliceHeader;
  }
}



mojo.internal.Struct(
    CdmContextForOOPVD_DecryptVideoBuffer_ParamsSpec.$,
    'CdmContextForOOPVD_DecryptVideoBuffer_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media_mojom_DecoderBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bytes', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CdmContextForOOPVD_DecryptVideoBuffer_Params {
  constructor() {
    /** @type { !media_mojom_DecoderBuffer } */
    this.buffer;
    /** @type { !Array<!number> } */
    this.bytes;
  }
}



mojo.internal.Struct(
    CdmContextForOOPVD_DecryptVideoBuffer_ResponseParamsSpec.$,
    'CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        DecryptStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'decoderBuffer', 8,
        0,
        media_mojom_DecoderBufferSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bytes', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams {
  constructor() {
    /** @type { !DecryptStatus } */
    this.status;
    /** @type { (media_mojom_DecoderBuffer|undefined) } */
    this.decoderBuffer;
    /** @type { !Array<!number> } */
    this.bytes;
  }
}

