// media/mojo/mojom/interface_factory.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  AudioDecoderRemote as media_mojom_AudioDecoderRemote,
  AudioDecoderPendingReceiver as media_mojom_AudioDecoderPendingReceiver
} from './audio_decoder.mojom.m.js';

import {
  AudioEncoderRemote as media_mojom_AudioEncoderRemote,
  AudioEncoderPendingReceiver as media_mojom_AudioEncoderPendingReceiver
} from './audio_encoder.mojom.m.js';

import {
  ContentDecryptionModuleRemote as media_mojom_ContentDecryptionModuleRemote,
  ContentDecryptionModulePendingReceiver as media_mojom_ContentDecryptionModulePendingReceiver,
  CdmConfig as media_mojom_CdmConfig,
  CdmConfigSpec as media_mojom_CdmConfigSpec,
  CdmContext as media_mojom_CdmContext,
  CdmContextSpec as media_mojom_CdmContextSpec
} from './content_decryption_module.mojom.m.js';

import {
  CreateCdmStatus as media_mojom_CreateCdmStatus,
  CreateCdmStatusSpec as media_mojom_CreateCdmStatusSpec
} from './media_types.mojom.m.js';

import {
  RendererRemote as media_mojom_RendererRemote,
  RendererPendingReceiver as media_mojom_RendererPendingReceiver
} from './renderer.mojom.m.js';

import {
  VideoDecoderRemote as media_mojom_VideoDecoderRemote,
  VideoDecoderPendingReceiver as media_mojom_VideoDecoderPendingReceiver
} from './video_decoder.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VideoDecoderTrackerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.VideoDecoderTracker', scope);
  }
}

/** @interface */
export class VideoDecoderTrackerInterface {
}

/**
 * @implements { VideoDecoderTrackerInterface }
 */
export class VideoDecoderTrackerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VideoDecoderTrackerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VideoDecoderTrackerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VideoDecoderTrackerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
}

/**
 * An object which receives request messages for the VideoDecoderTracker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VideoDecoderTrackerReceiver {
  /**
   * @param {!VideoDecoderTrackerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VideoDecoderTrackerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VideoDecoderTrackerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoDecoderTrackerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VideoDecoderTracker {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoDecoderTracker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VideoDecoderTrackerRemote}
   */
  static getRemote() {
    let remote = new VideoDecoderTrackerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VideoDecoderTracker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VideoDecoderTrackerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VideoDecoderTrackerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoDecoderTrackerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class InterfaceFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.InterfaceFactory', scope);
  }
}

/** @interface */
export class InterfaceFactoryInterface {
  
  /**
   * @param { !media_mojom_AudioDecoderPendingReceiver } audioDecoder
   */

  createAudioDecoder(audioDecoder) {}
  
  /**
   * @param { !media_mojom_VideoDecoderPendingReceiver } videoDecoder
   * @param { ?media_mojom_VideoDecoderRemote } dstVideoDecoder
   */

  createVideoDecoder(videoDecoder, dstVideoDecoder) {}
  
  /**
   * @param { !media_mojom_VideoDecoderPendingReceiver } receiver
   * @param { ?VideoDecoderTrackerRemote } tracker
   */

  createVideoDecoderWithTracker(receiver, tracker) {}
  
  /**
   * @param { !media_mojom_AudioEncoderPendingReceiver } audioEncoder
   */

  createAudioEncoder(audioEncoder) {}
  
  /**
   * @param { !string } audioDeviceId
   * @param { !media_mojom_RendererPendingReceiver } renderer
   */

  createDefaultRenderer(audioDeviceId, renderer) {}
  
  /**
   * @param { !media_mojom_CdmConfig } cdmConfig
   * @return {!Promise<{
        cdm: ?media_mojom_ContentDecryptionModuleRemote,
        cdmContext: ?media_mojom_CdmContext,
        status: !media_mojom_CreateCdmStatus,
   *  }>}
   */

  createCdm(cdmConfig) {}
}

/**
 * @implements { InterfaceFactoryInterface }
 */
export class InterfaceFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!InterfaceFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          InterfaceFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!InterfaceFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_AudioDecoderPendingReceiver } audioDecoder
   */

  createAudioDecoder(
      audioDecoder) {
    this.proxy.sendMessage(
        0,
        InterfaceFactory_CreateAudioDecoder_ParamsSpec.$,
        null,
        [
          audioDecoder
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_VideoDecoderPendingReceiver } videoDecoder
   * @param { ?media_mojom_VideoDecoderRemote } dstVideoDecoder
   */

  createVideoDecoder(
      videoDecoder,
      dstVideoDecoder) {
    this.proxy.sendMessage(
        1,
        InterfaceFactory_CreateVideoDecoder_ParamsSpec.$,
        null,
        [
          videoDecoder,
          dstVideoDecoder
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_VideoDecoderPendingReceiver } receiver
   * @param { ?VideoDecoderTrackerRemote } tracker
   */

  createVideoDecoderWithTracker(
      receiver,
      tracker) {
    this.proxy.sendMessage(
        2,
        InterfaceFactory_CreateVideoDecoderWithTracker_ParamsSpec.$,
        null,
        [
          receiver,
          tracker
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_AudioEncoderPendingReceiver } audioEncoder
   */

  createAudioEncoder(
      audioEncoder) {
    this.proxy.sendMessage(
        3,
        InterfaceFactory_CreateAudioEncoder_ParamsSpec.$,
        null,
        [
          audioEncoder
        ],
        false);
  }

  
  /**
   * @param { !string } audioDeviceId
   * @param { !media_mojom_RendererPendingReceiver } renderer
   */

  createDefaultRenderer(
      audioDeviceId,
      renderer) {
    this.proxy.sendMessage(
        4,
        InterfaceFactory_CreateDefaultRenderer_ParamsSpec.$,
        null,
        [
          audioDeviceId,
          renderer
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_CdmConfig } cdmConfig
   * @return {!Promise<{
        cdm: ?media_mojom_ContentDecryptionModuleRemote,
        cdmContext: ?media_mojom_CdmContext,
        status: !media_mojom_CreateCdmStatus,
   *  }>}
   */

  createCdm(
      cdmConfig) {
    return this.proxy.sendMessage(
        5,
        InterfaceFactory_CreateCdm_ParamsSpec.$,
        InterfaceFactory_CreateCdm_ResponseParamsSpec.$,
        [
          cdmConfig
        ],
        false);
  }
}

/**
 * An object which receives request messages for the InterfaceFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InterfaceFactoryReceiver {
  /**
   * @param {!InterfaceFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!InterfaceFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        InterfaceFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InterfaceFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        InterfaceFactory_CreateAudioDecoder_ParamsSpec.$,
        null,
        impl.createAudioDecoder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        InterfaceFactory_CreateVideoDecoder_ParamsSpec.$,
        null,
        impl.createVideoDecoder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        InterfaceFactory_CreateVideoDecoderWithTracker_ParamsSpec.$,
        null,
        impl.createVideoDecoderWithTracker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        InterfaceFactory_CreateAudioEncoder_ParamsSpec.$,
        null,
        impl.createAudioEncoder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        InterfaceFactory_CreateDefaultRenderer_ParamsSpec.$,
        null,
        impl.createDefaultRenderer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        InterfaceFactory_CreateCdm_ParamsSpec.$,
        InterfaceFactory_CreateCdm_ResponseParamsSpec.$,
        impl.createCdm.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class InterfaceFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.InterfaceFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!InterfaceFactoryRemote}
   */
  static getRemote() {
    let remote = new InterfaceFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the InterfaceFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InterfaceFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      InterfaceFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InterfaceFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createAudioDecoder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        InterfaceFactory_CreateAudioDecoder_ParamsSpec.$,
        null,
        this.createAudioDecoder.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createVideoDecoder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        InterfaceFactory_CreateVideoDecoder_ParamsSpec.$,
        null,
        this.createVideoDecoder.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createVideoDecoderWithTracker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        InterfaceFactory_CreateVideoDecoderWithTracker_ParamsSpec.$,
        null,
        this.createVideoDecoderWithTracker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createAudioEncoder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        InterfaceFactory_CreateAudioEncoder_ParamsSpec.$,
        null,
        this.createAudioEncoder.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createDefaultRenderer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        InterfaceFactory_CreateDefaultRenderer_ParamsSpec.$,
        null,
        this.createDefaultRenderer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createCdm =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        InterfaceFactory_CreateCdm_ParamsSpec.$,
        InterfaceFactory_CreateCdm_ResponseParamsSpec.$,
        this.createCdm.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InterfaceFactory_CreateAudioDecoder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InterfaceFactory_CreateVideoDecoder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InterfaceFactory_CreateVideoDecoderWithTracker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InterfaceFactory_CreateAudioEncoder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InterfaceFactory_CreateDefaultRenderer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InterfaceFactory_CreateCdm_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InterfaceFactory_CreateCdm_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    InterfaceFactory_CreateAudioDecoder_ParamsSpec.$,
    'InterfaceFactory_CreateAudioDecoder_Params',
    [
      mojo.internal.StructField(
        'audioDecoder', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_AudioDecoderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InterfaceFactory_CreateAudioDecoder_Params {
  constructor() {
    /** @type { !media_mojom_AudioDecoderPendingReceiver } */
    this.audioDecoder;
  }
}



mojo.internal.Struct(
    InterfaceFactory_CreateVideoDecoder_ParamsSpec.$,
    'InterfaceFactory_CreateVideoDecoder_Params',
    [
      mojo.internal.StructField(
        'videoDecoder', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_VideoDecoderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dstVideoDecoder', 4,
        0,
        mojo.internal.InterfaceProxy(media_mojom_VideoDecoderRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InterfaceFactory_CreateVideoDecoder_Params {
  constructor() {
    /** @type { !media_mojom_VideoDecoderPendingReceiver } */
    this.videoDecoder;
    /** @type { (media_mojom_VideoDecoderRemote|undefined) } */
    this.dstVideoDecoder;
  }
}



mojo.internal.Struct(
    InterfaceFactory_CreateVideoDecoderWithTracker_ParamsSpec.$,
    'InterfaceFactory_CreateVideoDecoderWithTracker_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_VideoDecoderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tracker', 4,
        0,
        mojo.internal.InterfaceProxy(VideoDecoderTrackerRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InterfaceFactory_CreateVideoDecoderWithTracker_Params {
  constructor() {
    /** @type { !media_mojom_VideoDecoderPendingReceiver } */
    this.receiver;
    /** @type { (VideoDecoderTrackerRemote|undefined) } */
    this.tracker;
  }
}



mojo.internal.Struct(
    InterfaceFactory_CreateAudioEncoder_ParamsSpec.$,
    'InterfaceFactory_CreateAudioEncoder_Params',
    [
      mojo.internal.StructField(
        'audioEncoder', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_AudioEncoderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InterfaceFactory_CreateAudioEncoder_Params {
  constructor() {
    /** @type { !media_mojom_AudioEncoderPendingReceiver } */
    this.audioEncoder;
  }
}



mojo.internal.Struct(
    InterfaceFactory_CreateDefaultRenderer_ParamsSpec.$,
    'InterfaceFactory_CreateDefaultRenderer_Params',
    [
      mojo.internal.StructField(
        'audioDeviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'renderer', 8,
        0,
        mojo.internal.InterfaceRequest(media_mojom_RendererPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InterfaceFactory_CreateDefaultRenderer_Params {
  constructor() {
    /** @type { !string } */
    this.audioDeviceId;
    /** @type { !media_mojom_RendererPendingReceiver } */
    this.renderer;
  }
}



mojo.internal.Struct(
    InterfaceFactory_CreateCdm_ParamsSpec.$,
    'InterfaceFactory_CreateCdm_Params',
    [
      mojo.internal.StructField(
        'cdmConfig', 0,
        0,
        media_mojom_CdmConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InterfaceFactory_CreateCdm_Params {
  constructor() {
    /** @type { !media_mojom_CdmConfig } */
    this.cdmConfig;
  }
}



mojo.internal.Struct(
    InterfaceFactory_CreateCdm_ResponseParamsSpec.$,
    'InterfaceFactory_CreateCdm_ResponseParams',
    [
      mojo.internal.StructField(
        'cdm', 0,
        0,
        mojo.internal.InterfaceProxy(media_mojom_ContentDecryptionModuleRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cdmContext', 8,
        0,
        media_mojom_CdmContextSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 16,
        0,
        media_mojom_CreateCdmStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class InterfaceFactory_CreateCdm_ResponseParams {
  constructor() {
    /** @type { (media_mojom_ContentDecryptionModuleRemote|undefined) } */
    this.cdm;
    /** @type { (media_mojom_CdmContext|undefined) } */
    this.cdmContext;
    /** @type { !media_mojom_CreateCdmStatus } */
    this.status;
  }
}

