// media/mojo/mojom/key_system_support.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  Version as mojoBase_mojom_Version,
  VersionSpec as mojoBase_mojom_VersionSpec
} from '../../../mojo/public/mojom/base/version.mojom.m.js';

import {
  CdmSessionType as media_mojom_CdmSessionType,
  CdmSessionTypeSpec as media_mojom_CdmSessionTypeSpec
} from './content_decryption_module.mojom.m.js';

import {
  AudioCodec as media_mojom_AudioCodec,
  AudioCodecSpec as media_mojom_AudioCodecSpec,
  EncryptionScheme as media_mojom_EncryptionScheme,
  EncryptionSchemeSpec as media_mojom_EncryptionSchemeSpec,
  VideoCodec as media_mojom_VideoCodec,
  VideoCodecSpec as media_mojom_VideoCodecSpec,
  VideoCodecProfile as media_mojom_VideoCodecProfile,
  VideoCodecProfileSpec as media_mojom_VideoCodecProfileSpec
} from './media_types.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CdmCapabilityQueryStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CdmCapabilityQueryStatus = {
  
  kSuccess: 0,
  kUnknown: 1,
  kHardwareSecureCodecNotSupported: 2,
  kNoSupportedVideoCodec: 3,
  kNoSupportedEncryptionScheme: 4,
  kUnsupportedKeySystem: 5,
  kMediaFoundationCdmNotSupported: 6,
  kDisconnectionError: 7,
  kMediaFoundationGetCdmFactoryFailed: 8,
  kCreateDummyMediaFoundationCdmFailed: 9,
  kUnexpectedEmptyCapability: 10,
  kNoMediaDrmSupport: 11,
  kMediaFoundationGetExtendedDRMTypeSupportFailed: 12,
  MIN_VALUE: 0,
  MAX_VALUE: 12,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class KeySystemSupportObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.KeySystemSupportObserver', scope);
  }
}

/** @interface */
export class KeySystemSupportObserverInterface {
  
  /**
   * @param { !Object<!string, !KeySystemCapability> } keySystems
   */

  onKeySystemSupportUpdated(keySystems) {}
}

/**
 * @implements { KeySystemSupportObserverInterface }
 */
export class KeySystemSupportObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!KeySystemSupportObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          KeySystemSupportObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!KeySystemSupportObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object<!string, !KeySystemCapability> } keySystems
   */

  onKeySystemSupportUpdated(
      keySystems) {
    this.proxy.sendMessage(
        0,
        KeySystemSupportObserver_OnKeySystemSupportUpdated_ParamsSpec.$,
        null,
        [
          keySystems
        ],
        false);
  }
}

/**
 * An object which receives request messages for the KeySystemSupportObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class KeySystemSupportObserverReceiver {
  /**
   * @param {!KeySystemSupportObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!KeySystemSupportObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        KeySystemSupportObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!KeySystemSupportObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        KeySystemSupportObserver_OnKeySystemSupportUpdated_ParamsSpec.$,
        null,
        impl.onKeySystemSupportUpdated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class KeySystemSupportObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.KeySystemSupportObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!KeySystemSupportObserverRemote}
   */
  static getRemote() {
    let remote = new KeySystemSupportObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the KeySystemSupportObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class KeySystemSupportObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      KeySystemSupportObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!KeySystemSupportObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onKeySystemSupportUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        KeySystemSupportObserver_OnKeySystemSupportUpdated_ParamsSpec.$,
        null,
        this.onKeySystemSupportUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class KeySystemSupportPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.KeySystemSupport', scope);
  }
}

/** @interface */
export class KeySystemSupportInterface {
  
  /**
   * @param { !KeySystemSupportObserverRemote } observer
   */

  setObserver(observer) {}
}

/**
 * @implements { KeySystemSupportInterface }
 */
export class KeySystemSupportRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!KeySystemSupportPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          KeySystemSupportPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!KeySystemSupportPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !KeySystemSupportObserverRemote } observer
   */

  setObserver(
      observer) {
    this.proxy.sendMessage(
        0,
        KeySystemSupport_SetObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the KeySystemSupport
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class KeySystemSupportReceiver {
  /**
   * @param {!KeySystemSupportInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!KeySystemSupportRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        KeySystemSupportRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!KeySystemSupportRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        KeySystemSupport_SetObserver_ParamsSpec.$,
        null,
        impl.setObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class KeySystemSupport {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.KeySystemSupport";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!KeySystemSupportRemote}
   */
  static getRemote() {
    let remote = new KeySystemSupportRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the KeySystemSupport
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class KeySystemSupportCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      KeySystemSupportRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!KeySystemSupportRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        KeySystemSupport_SetObserver_ParamsSpec.$,
        null,
        this.setObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCodecInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CdmCapabilitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeySystemCapabilitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeySystemSupportObserver_OnKeySystemSupportUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeySystemSupport_SetObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    VideoCodecInfoSpec.$,
    'VideoCodecInfo',
    [
      mojo.internal.StructField(
        'supportedProfiles', 0,
        0,
        mojo.internal.Array(media_mojom_VideoCodecProfileSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'supportsClearLead', 8,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoCodecInfo {
  constructor() {
    /** @type { !Array<!media_mojom_VideoCodecProfile> } */
    this.supportedProfiles;
    /** @type { !boolean } */
    this.supportsClearLead;
  }
}



mojo.internal.Struct(
    CdmCapabilitySpec.$,
    'CdmCapability',
    [
      mojo.internal.StructField(
        'audioCodecs', 0,
        0,
        mojo.internal.Array(media_mojom_AudioCodecSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoCodecs', 8,
        0,
        mojo.internal.Map(media_mojom_VideoCodecSpec.$, VideoCodecInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encryptionSchemes', 16,
        0,
        mojo.internal.Array(media_mojom_EncryptionSchemeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionTypes', 24,
        0,
        mojo.internal.Array(media_mojom_CdmSessionTypeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'version', 32,
        0,
        mojoBase_mojom_VersionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class CdmCapability {
  constructor() {
    /** @type { !Array<!media_mojom_AudioCodec> } */
    this.audioCodecs;
    /** @type { !Object<!media_mojom_VideoCodec, !VideoCodecInfo> } */
    this.videoCodecs;
    /** @type { !Array<!media_mojom_EncryptionScheme> } */
    this.encryptionSchemes;
    /** @type { !Array<!media_mojom_CdmSessionType> } */
    this.sessionTypes;
    /** @type { !mojoBase_mojom_Version } */
    this.version;
  }
}



mojo.internal.Struct(
    KeySystemCapabilitySpec.$,
    'KeySystemCapability',
    [
      mojo.internal.StructField(
        'swSecureCapability', 0,
        0,
        CdmCapabilitySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hwSecureCapability', 8,
        0,
        CdmCapabilitySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sw_secure_capability_query_status_$flag', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "sw_secure_capability_query_status_$value",
          originalFieldName: "swSecureCapabilityQueryStatus",
        }
      ),
      mojo.internal.StructField(
        'sw_secure_capability_query_status_$value', 20,
        0,
        CdmCapabilityQueryStatusSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "swSecureCapabilityQueryStatus",
        }
      ),
      mojo.internal.StructField(
        'hw_secure_capability_query_status_$flag', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "hw_secure_capability_query_status_$value",
          originalFieldName: "hwSecureCapabilityQueryStatus",
        }
      ),
      mojo.internal.StructField(
        'hw_secure_capability_query_status_$value', 24,
        0,
        CdmCapabilityQueryStatusSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "hwSecureCapabilityQueryStatus",
        }
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class KeySystemCapability {
  constructor() {
    /** @type { (CdmCapability|undefined) } */
    this.swSecureCapability;
    /** @type { (CdmCapability|undefined) } */
    this.hwSecureCapability;
    /** @type { (CdmCapabilityQueryStatus|undefined) } */
    this.swSecureCapabilityQueryStatus;
    /** @type { (CdmCapabilityQueryStatus|undefined) } */
    this.hwSecureCapabilityQueryStatus;
  }
}



mojo.internal.Struct(
    KeySystemSupportObserver_OnKeySystemSupportUpdated_ParamsSpec.$,
    'KeySystemSupportObserver_OnKeySystemSupportUpdated_Params',
    [
      mojo.internal.StructField(
        'keySystems', 0,
        0,
        mojo.internal.Map(mojo.internal.String, KeySystemCapabilitySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class KeySystemSupportObserver_OnKeySystemSupportUpdated_Params {
  constructor() {
    /** @type { !Object<!string, !KeySystemCapability> } */
    this.keySystems;
  }
}



mojo.internal.Struct(
    KeySystemSupport_SetObserver_ParamsSpec.$,
    'KeySystemSupport_SetObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(KeySystemSupportObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class KeySystemSupport_SetObserver_Params {
  constructor() {
    /** @type { !KeySystemSupportObserverRemote } */
    this.observer;
  }
}

