// media/mojo/mojom/media_metrics_provider.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  AudioCodec as media_mojom_AudioCodec,
  AudioCodecSpec as media_mojom_AudioCodecSpec,
  DemuxerType as media_mojom_DemuxerType,
  DemuxerTypeSpec as media_mojom_DemuxerTypeSpec,
  MediaContainerName as media_mojom_MediaContainerName,
  MediaContainerNameSpec as media_mojom_MediaContainerNameSpec,
  MediaStreamType as media_mojom_MediaStreamType,
  MediaStreamTypeSpec as media_mojom_MediaStreamTypeSpec,
  RendererType as media_mojom_RendererType,
  RendererTypeSpec as media_mojom_RendererTypeSpec,
  VideoCodec as media_mojom_VideoCodec,
  VideoCodecSpec as media_mojom_VideoCodecSpec,
  AudioPipelineInfo as media_mojom_AudioPipelineInfo,
  AudioPipelineInfoSpec as media_mojom_AudioPipelineInfoSpec,
  PipelineStatus as media_mojom_PipelineStatus,
  PipelineStatusSpec as media_mojom_PipelineStatusSpec,
  VideoPipelineInfo as media_mojom_VideoPipelineInfo,
  VideoPipelineInfoSpec as media_mojom_VideoPipelineInfoSpec
} from './media_types.mojom.m.js';

import {
  PlaybackEventsRecorderRemote as media_mojom_PlaybackEventsRecorderRemote,
  PlaybackEventsRecorderPendingReceiver as media_mojom_PlaybackEventsRecorderPendingReceiver
} from './playback_events_recorder.mojom.m.js';

import {
  VideoDecodeStatsRecorderRemote as media_mojom_VideoDecodeStatsRecorderRemote,
  VideoDecodeStatsRecorderPendingReceiver as media_mojom_VideoDecodeStatsRecorderPendingReceiver
} from './video_decode_stats_recorder.mojom.m.js';

import {
  WatchTimeRecorderRemote as media_mojom_WatchTimeRecorderRemote,
  WatchTimeRecorderPendingReceiver as media_mojom_WatchTimeRecorderPendingReceiver,
  PlaybackProperties as media_mojom_PlaybackProperties,
  PlaybackPropertiesSpec as media_mojom_PlaybackPropertiesSpec
} from './watch_time_recorder.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaURLSchemeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaURLScheme = {
  
  kUnknown: 0,
  kMissing: 1,
  kHttp: 2,
  kHttps: 3,
  kFtp: 4,
  kChromeExtension: 5,
  kJavascript: 6,
  kFile: 7,
  kBlob: 8,
  kData: 9,
  kFileSystem: 10,
  kChrome: 11,
  kContent: 12,
  kContentId: 13,
  MIN_VALUE: 0,
  MAX_VALUE: 13,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaMetricsProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.MediaMetricsProvider', scope);
  }
}

/** @interface */
export class MediaMetricsProviderInterface {
  
  /**
   * @param { !boolean } isMse
   * @param { !MediaURLScheme } urlScheme
   * @param { !media_mojom_MediaStreamType } streamType
   */

  initialize(isMse, urlScheme, streamType) {}
  
  /**
   * @param { !media_mojom_PipelineStatus } status
   */

  onStarted(status) {}
  
  /**
   * @param { !media_mojom_PipelineStatus } status
   */

  onError(status) {}
  
  /**
   * @param { !media_mojom_PipelineStatus } status
   */

  onFallback(status) {}
  
  /**
   */

  setHasPlayed() {}
  
  /**
   */

  setHaveEnough() {}
  
  /**
   */

  setIsEME() {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } elapsed
   */

  setTimeToMetadata(elapsed) {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } elapsed
   */

  setTimeToFirstFrame(elapsed) {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } elapsed
   */

  setTimeToPlayReady(elapsed) {}
  
  /**
   * @param { !media_mojom_RendererType } rendererType
   */

  setRendererType(rendererType) {}
  
  /**
   * @param { !media_mojom_DemuxerType } demuxerType
   */

  setDemuxerType(demuxerType) {}
  
  /**
   * @param { !string } keySystem
   */

  setKeySystem(keySystem) {}
  
  /**
   */

  setHasWaitingForKey() {}
  
  /**
   */

  setIsHardwareSecure() {}
  
  /**
   * @param { !media_mojom_MediaContainerName } containerName
   */

  setContainerName(containerName) {}
  
  /**
   * @param { !media_mojom_PlaybackProperties } properties
   * @param { !media_mojom_WatchTimeRecorderPendingReceiver } recorder
   */

  acquireWatchTimeRecorder(properties, recorder) {}
  
  /**
   * @param { !media_mojom_VideoDecodeStatsRecorderPendingReceiver } recorder
   */

  acquireVideoDecodeStatsRecorder(recorder) {}
  
  /**
   * @param { !media_mojom_PlaybackEventsRecorderPendingReceiver } receiver
   */

  acquirePlaybackEventsRecorder(receiver) {}
  
  /**
   * @param { !media_mojom_AudioCodec } codec
   */

  setHasAudio(codec) {}
  
  /**
   * @param { !media_mojom_VideoCodec } codec
   */

  setHasVideo(codec) {}
  
  /**
   * @param { !media_mojom_VideoPipelineInfo } info
   */

  setVideoPipelineInfo(info) {}
  
  /**
   * @param { !media_mojom_AudioPipelineInfo } info
   */

  setAudioPipelineInfo(info) {}
}

/**
 * @implements { MediaMetricsProviderInterface }
 */
export class MediaMetricsProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaMetricsProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaMetricsProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaMetricsProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } isMse
   * @param { !MediaURLScheme } urlScheme
   * @param { !media_mojom_MediaStreamType } streamType
   */

  initialize(
      isMse,
      urlScheme,
      streamType) {
    this.proxy.sendMessage(
        0,
        MediaMetricsProvider_Initialize_ParamsSpec.$,
        null,
        [
          isMse,
          urlScheme,
          streamType
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_PipelineStatus } status
   */

  onStarted(
      status) {
    this.proxy.sendMessage(
        1,
        MediaMetricsProvider_OnStarted_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_PipelineStatus } status
   */

  onError(
      status) {
    this.proxy.sendMessage(
        2,
        MediaMetricsProvider_OnError_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_PipelineStatus } status
   */

  onFallback(
      status) {
    this.proxy.sendMessage(
        3,
        MediaMetricsProvider_OnFallback_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   */

  setHasPlayed() {
    this.proxy.sendMessage(
        4,
        MediaMetricsProvider_SetHasPlayed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  setHaveEnough() {
    this.proxy.sendMessage(
        5,
        MediaMetricsProvider_SetHaveEnough_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  setIsEME() {
    this.proxy.sendMessage(
        6,
        MediaMetricsProvider_SetIsEME_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } elapsed
   */

  setTimeToMetadata(
      elapsed) {
    this.proxy.sendMessage(
        7,
        MediaMetricsProvider_SetTimeToMetadata_ParamsSpec.$,
        null,
        [
          elapsed
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } elapsed
   */

  setTimeToFirstFrame(
      elapsed) {
    this.proxy.sendMessage(
        8,
        MediaMetricsProvider_SetTimeToFirstFrame_ParamsSpec.$,
        null,
        [
          elapsed
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } elapsed
   */

  setTimeToPlayReady(
      elapsed) {
    this.proxy.sendMessage(
        9,
        MediaMetricsProvider_SetTimeToPlayReady_ParamsSpec.$,
        null,
        [
          elapsed
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_RendererType } rendererType
   */

  setRendererType(
      rendererType) {
    this.proxy.sendMessage(
        10,
        MediaMetricsProvider_SetRendererType_ParamsSpec.$,
        null,
        [
          rendererType
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_DemuxerType } demuxerType
   */

  setDemuxerType(
      demuxerType) {
    this.proxy.sendMessage(
        11,
        MediaMetricsProvider_SetDemuxerType_ParamsSpec.$,
        null,
        [
          demuxerType
        ],
        false);
  }

  
  /**
   * @param { !string } keySystem
   */

  setKeySystem(
      keySystem) {
    this.proxy.sendMessage(
        12,
        MediaMetricsProvider_SetKeySystem_ParamsSpec.$,
        null,
        [
          keySystem
        ],
        false);
  }

  
  /**
   */

  setHasWaitingForKey() {
    this.proxy.sendMessage(
        13,
        MediaMetricsProvider_SetHasWaitingForKey_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  setIsHardwareSecure() {
    this.proxy.sendMessage(
        14,
        MediaMetricsProvider_SetIsHardwareSecure_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_MediaContainerName } containerName
   */

  setContainerName(
      containerName) {
    this.proxy.sendMessage(
        15,
        MediaMetricsProvider_SetContainerName_ParamsSpec.$,
        null,
        [
          containerName
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_PlaybackProperties } properties
   * @param { !media_mojom_WatchTimeRecorderPendingReceiver } recorder
   */

  acquireWatchTimeRecorder(
      properties,
      recorder) {
    this.proxy.sendMessage(
        16,
        MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsSpec.$,
        null,
        [
          properties,
          recorder
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_VideoDecodeStatsRecorderPendingReceiver } recorder
   */

  acquireVideoDecodeStatsRecorder(
      recorder) {
    this.proxy.sendMessage(
        17,
        MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsSpec.$,
        null,
        [
          recorder
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_PlaybackEventsRecorderPendingReceiver } receiver
   */

  acquirePlaybackEventsRecorder(
      receiver) {
    this.proxy.sendMessage(
        18,
        MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_AudioCodec } codec
   */

  setHasAudio(
      codec) {
    this.proxy.sendMessage(
        19,
        MediaMetricsProvider_SetHasAudio_ParamsSpec.$,
        null,
        [
          codec
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_VideoCodec } codec
   */

  setHasVideo(
      codec) {
    this.proxy.sendMessage(
        20,
        MediaMetricsProvider_SetHasVideo_ParamsSpec.$,
        null,
        [
          codec
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_VideoPipelineInfo } info
   */

  setVideoPipelineInfo(
      info) {
    this.proxy.sendMessage(
        21,
        MediaMetricsProvider_SetVideoPipelineInfo_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_AudioPipelineInfo } info
   */

  setAudioPipelineInfo(
      info) {
    this.proxy.sendMessage(
        22,
        MediaMetricsProvider_SetAudioPipelineInfo_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaMetricsProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaMetricsProviderReceiver {
  /**
   * @param {!MediaMetricsProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaMetricsProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaMetricsProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaMetricsProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaMetricsProvider_Initialize_ParamsSpec.$,
        null,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaMetricsProvider_OnStarted_ParamsSpec.$,
        null,
        impl.onStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaMetricsProvider_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaMetricsProvider_OnFallback_ParamsSpec.$,
        null,
        impl.onFallback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaMetricsProvider_SetHasPlayed_ParamsSpec.$,
        null,
        impl.setHasPlayed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MediaMetricsProvider_SetHaveEnough_ParamsSpec.$,
        null,
        impl.setHaveEnough.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MediaMetricsProvider_SetIsEME_ParamsSpec.$,
        null,
        impl.setIsEME.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MediaMetricsProvider_SetTimeToMetadata_ParamsSpec.$,
        null,
        impl.setTimeToMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        MediaMetricsProvider_SetTimeToFirstFrame_ParamsSpec.$,
        null,
        impl.setTimeToFirstFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        MediaMetricsProvider_SetTimeToPlayReady_ParamsSpec.$,
        null,
        impl.setTimeToPlayReady.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        MediaMetricsProvider_SetRendererType_ParamsSpec.$,
        null,
        impl.setRendererType.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        MediaMetricsProvider_SetDemuxerType_ParamsSpec.$,
        null,
        impl.setDemuxerType.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        MediaMetricsProvider_SetKeySystem_ParamsSpec.$,
        null,
        impl.setKeySystem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        MediaMetricsProvider_SetHasWaitingForKey_ParamsSpec.$,
        null,
        impl.setHasWaitingForKey.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        MediaMetricsProvider_SetIsHardwareSecure_ParamsSpec.$,
        null,
        impl.setIsHardwareSecure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        MediaMetricsProvider_SetContainerName_ParamsSpec.$,
        null,
        impl.setContainerName.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsSpec.$,
        null,
        impl.acquireWatchTimeRecorder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsSpec.$,
        null,
        impl.acquireVideoDecodeStatsRecorder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsSpec.$,
        null,
        impl.acquirePlaybackEventsRecorder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        MediaMetricsProvider_SetHasAudio_ParamsSpec.$,
        null,
        impl.setHasAudio.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        MediaMetricsProvider_SetHasVideo_ParamsSpec.$,
        null,
        impl.setHasVideo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        MediaMetricsProvider_SetVideoPipelineInfo_ParamsSpec.$,
        null,
        impl.setVideoPipelineInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        MediaMetricsProvider_SetAudioPipelineInfo_ParamsSpec.$,
        null,
        impl.setAudioPipelineInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaMetricsProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.MediaMetricsProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaMetricsProviderRemote}
   */
  static getRemote() {
    let remote = new MediaMetricsProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaMetricsProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaMetricsProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaMetricsProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaMetricsProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaMetricsProvider_Initialize_ParamsSpec.$,
        null,
        this.initialize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaMetricsProvider_OnStarted_ParamsSpec.$,
        null,
        this.onStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaMetricsProvider_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFallback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaMetricsProvider_OnFallback_ParamsSpec.$,
        null,
        this.onFallback.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHasPlayed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaMetricsProvider_SetHasPlayed_ParamsSpec.$,
        null,
        this.setHasPlayed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHaveEnough =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MediaMetricsProvider_SetHaveEnough_ParamsSpec.$,
        null,
        this.setHaveEnough.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIsEME =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MediaMetricsProvider_SetIsEME_ParamsSpec.$,
        null,
        this.setIsEME.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTimeToMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MediaMetricsProvider_SetTimeToMetadata_ParamsSpec.$,
        null,
        this.setTimeToMetadata.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTimeToFirstFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        MediaMetricsProvider_SetTimeToFirstFrame_ParamsSpec.$,
        null,
        this.setTimeToFirstFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTimeToPlayReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        MediaMetricsProvider_SetTimeToPlayReady_ParamsSpec.$,
        null,
        this.setTimeToPlayReady.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setRendererType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        MediaMetricsProvider_SetRendererType_ParamsSpec.$,
        null,
        this.setRendererType.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setDemuxerType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        MediaMetricsProvider_SetDemuxerType_ParamsSpec.$,
        null,
        this.setDemuxerType.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setKeySystem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        MediaMetricsProvider_SetKeySystem_ParamsSpec.$,
        null,
        this.setKeySystem.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHasWaitingForKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        MediaMetricsProvider_SetHasWaitingForKey_ParamsSpec.$,
        null,
        this.setHasWaitingForKey.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIsHardwareSecure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        MediaMetricsProvider_SetIsHardwareSecure_ParamsSpec.$,
        null,
        this.setIsHardwareSecure.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setContainerName =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        MediaMetricsProvider_SetContainerName_ParamsSpec.$,
        null,
        this.setContainerName.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.acquireWatchTimeRecorder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsSpec.$,
        null,
        this.acquireWatchTimeRecorder.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.acquireVideoDecodeStatsRecorder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsSpec.$,
        null,
        this.acquireVideoDecodeStatsRecorder.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.acquirePlaybackEventsRecorder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsSpec.$,
        null,
        this.acquirePlaybackEventsRecorder.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHasAudio =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        MediaMetricsProvider_SetHasAudio_ParamsSpec.$,
        null,
        this.setHasAudio.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHasVideo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        MediaMetricsProvider_SetHasVideo_ParamsSpec.$,
        null,
        this.setHasVideo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVideoPipelineInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        MediaMetricsProvider_SetVideoPipelineInfo_ParamsSpec.$,
        null,
        this.setVideoPipelineInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAudioPipelineInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        MediaMetricsProvider_SetAudioPipelineInfo_ParamsSpec.$,
        null,
        this.setAudioPipelineInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_OnStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_OnFallback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetHasPlayed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetHaveEnough_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetIsEME_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetTimeToMetadata_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetTimeToFirstFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetTimeToPlayReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetRendererType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetDemuxerType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetKeySystem_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetHasWaitingForKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetIsHardwareSecure_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetContainerName_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetHasAudio_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetHasVideo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetVideoPipelineInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetricsProvider_SetAudioPipelineInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MediaMetricsProvider_Initialize_ParamsSpec.$,
    'MediaMetricsProvider_Initialize_Params',
    [
      mojo.internal.StructField(
        'isMse', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'urlScheme', 4,
        0,
        MediaURLSchemeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streamType', 8,
        0,
        media_mojom_MediaStreamTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaMetricsProvider_Initialize_Params {
  constructor() {
    /** @type { !boolean } */
    this.isMse;
    /** @type { !MediaURLScheme } */
    this.urlScheme;
    /** @type { !media_mojom_MediaStreamType } */
    this.streamType;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_OnStarted_ParamsSpec.$,
    'MediaMetricsProvider_OnStarted_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_PipelineStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_OnStarted_Params {
  constructor() {
    /** @type { !media_mojom_PipelineStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_OnError_ParamsSpec.$,
    'MediaMetricsProvider_OnError_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_PipelineStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_OnError_Params {
  constructor() {
    /** @type { !media_mojom_PipelineStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_OnFallback_ParamsSpec.$,
    'MediaMetricsProvider_OnFallback_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_PipelineStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_OnFallback_Params {
  constructor() {
    /** @type { !media_mojom_PipelineStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetHasPlayed_ParamsSpec.$,
    'MediaMetricsProvider_SetHasPlayed_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetHasPlayed_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetHaveEnough_ParamsSpec.$,
    'MediaMetricsProvider_SetHaveEnough_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetHaveEnough_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetIsEME_ParamsSpec.$,
    'MediaMetricsProvider_SetIsEME_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetIsEME_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetTimeToMetadata_ParamsSpec.$,
    'MediaMetricsProvider_SetTimeToMetadata_Params',
    [
      mojo.internal.StructField(
        'elapsed', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetTimeToMetadata_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.elapsed;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetTimeToFirstFrame_ParamsSpec.$,
    'MediaMetricsProvider_SetTimeToFirstFrame_Params',
    [
      mojo.internal.StructField(
        'elapsed', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetTimeToFirstFrame_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.elapsed;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetTimeToPlayReady_ParamsSpec.$,
    'MediaMetricsProvider_SetTimeToPlayReady_Params',
    [
      mojo.internal.StructField(
        'elapsed', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetTimeToPlayReady_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.elapsed;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetRendererType_ParamsSpec.$,
    'MediaMetricsProvider_SetRendererType_Params',
    [
      mojo.internal.StructField(
        'rendererType', 0,
        0,
        media_mojom_RendererTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetRendererType_Params {
  constructor() {
    /** @type { !media_mojom_RendererType } */
    this.rendererType;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetDemuxerType_ParamsSpec.$,
    'MediaMetricsProvider_SetDemuxerType_Params',
    [
      mojo.internal.StructField(
        'demuxerType', 0,
        0,
        media_mojom_DemuxerTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetDemuxerType_Params {
  constructor() {
    /** @type { !media_mojom_DemuxerType } */
    this.demuxerType;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetKeySystem_ParamsSpec.$,
    'MediaMetricsProvider_SetKeySystem_Params',
    [
      mojo.internal.StructField(
        'keySystem', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetKeySystem_Params {
  constructor() {
    /** @type { !string } */
    this.keySystem;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetHasWaitingForKey_ParamsSpec.$,
    'MediaMetricsProvider_SetHasWaitingForKey_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetHasWaitingForKey_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetIsHardwareSecure_ParamsSpec.$,
    'MediaMetricsProvider_SetIsHardwareSecure_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetIsHardwareSecure_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetContainerName_ParamsSpec.$,
    'MediaMetricsProvider_SetContainerName_Params',
    [
      mojo.internal.StructField(
        'containerName', 0,
        0,
        media_mojom_MediaContainerNameSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetContainerName_Params {
  constructor() {
    /** @type { !media_mojom_MediaContainerName } */
    this.containerName;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsSpec.$,
    'MediaMetricsProvider_AcquireWatchTimeRecorder_Params',
    [
      mojo.internal.StructField(
        'properties', 0,
        0,
        media_mojom_PlaybackPropertiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'recorder', 8,
        0,
        mojo.internal.InterfaceRequest(media_mojom_WatchTimeRecorderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaMetricsProvider_AcquireWatchTimeRecorder_Params {
  constructor() {
    /** @type { !media_mojom_PlaybackProperties } */
    this.properties;
    /** @type { !media_mojom_WatchTimeRecorderPendingReceiver } */
    this.recorder;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsSpec.$,
    'MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params',
    [
      mojo.internal.StructField(
        'recorder', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_VideoDecodeStatsRecorderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params {
  constructor() {
    /** @type { !media_mojom_VideoDecodeStatsRecorderPendingReceiver } */
    this.recorder;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsSpec.$,
    'MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_PlaybackEventsRecorderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params {
  constructor() {
    /** @type { !media_mojom_PlaybackEventsRecorderPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetHasAudio_ParamsSpec.$,
    'MediaMetricsProvider_SetHasAudio_Params',
    [
      mojo.internal.StructField(
        'codec', 0,
        0,
        media_mojom_AudioCodecSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetHasAudio_Params {
  constructor() {
    /** @type { !media_mojom_AudioCodec } */
    this.codec;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetHasVideo_ParamsSpec.$,
    'MediaMetricsProvider_SetHasVideo_Params',
    [
      mojo.internal.StructField(
        'codec', 0,
        0,
        media_mojom_VideoCodecSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetHasVideo_Params {
  constructor() {
    /** @type { !media_mojom_VideoCodec } */
    this.codec;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetVideoPipelineInfo_ParamsSpec.$,
    'MediaMetricsProvider_SetVideoPipelineInfo_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        media_mojom_VideoPipelineInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetVideoPipelineInfo_Params {
  constructor() {
    /** @type { !media_mojom_VideoPipelineInfo } */
    this.info;
  }
}



mojo.internal.Struct(
    MediaMetricsProvider_SetAudioPipelineInfo_ParamsSpec.$,
    'MediaMetricsProvider_SetAudioPipelineInfo_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        media_mojom_AudioPipelineInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaMetricsProvider_SetAudioPipelineInfo_Params {
  constructor() {
    /** @type { !media_mojom_AudioPipelineInfo } */
    this.info;
  }
}

