// media/mojo/mojom/video_decoder.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.VideoCodecProfile');
goog.require('media.mojom.VideoDecoderType');
goog.require('media.mojom.WaitingReason');
goog.require('media.mojom.CdmContextForOOPVD');
goog.require('media.mojom.MediaLog');
goog.require('gfx.mojom.ColorSpace');
goog.require('media.mojom.DecoderStatus');
goog.require('gfx.mojom.Size');
goog.require('gpu.mojom.SyncToken');
goog.require('mojoBase.mojom.UnguessableToken');
goog.require('media.mojom.VideoDecoderConfig');
goog.require('media.mojom.VideoFrame');
goog.require('media.mojom.DecoderBuffer');






goog.provide('media.mojom.VideoFrameHandleReleaser');
goog.provide('media.mojom.VideoFrameHandleReleaserReceiver');
goog.provide('media.mojom.VideoFrameHandleReleaserCallbackRouter');
goog.provide('media.mojom.VideoFrameHandleReleaserInterface');
goog.provide('media.mojom.VideoFrameHandleReleaserRemote');
goog.provide('media.mojom.VideoFrameHandleReleaserPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.VideoFrameHandleReleaserPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.VideoFrameHandleReleaser.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.VideoFrameHandleReleaserInterface = class {
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } releaseToken
   * @param { ?gpu.mojom.SyncToken } releaseSyncToken
   */

  releaseVideoFrame(releaseToken, releaseSyncToken) {}
};

/**
 * @export
 * @implements { media.mojom.VideoFrameHandleReleaserInterface }
 */
media.mojom.VideoFrameHandleReleaserRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.VideoFrameHandleReleaserPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.VideoFrameHandleReleaserPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.VideoFrameHandleReleaserPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } releaseToken
   * @param { ?gpu.mojom.SyncToken } releaseSyncToken
   */

  releaseVideoFrame(
      releaseToken,
      releaseSyncToken) {
    this.proxy.sendMessage(
        0,
        media.mojom.VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsSpec.$,
        null,
        [
          releaseToken,
          releaseSyncToken
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VideoFrameHandleReleaser
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.VideoFrameHandleReleaserReceiver = class {
  /**
   * @param {!media.mojom.VideoFrameHandleReleaserInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.VideoFrameHandleReleaserRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.VideoFrameHandleReleaserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoFrameHandleReleaserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsSpec.$,
        null,
        impl.releaseVideoFrame.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.VideoFrameHandleReleaser = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoFrameHandleReleaser";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.VideoFrameHandleReleaserRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.VideoFrameHandleReleaserRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VideoFrameHandleReleaser
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.VideoFrameHandleReleaserCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.VideoFrameHandleReleaserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoFrameHandleReleaserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.releaseVideoFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsSpec.$,
        null,
        this.releaseVideoFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.VideoDecoder');
goog.provide('media.mojom.VideoDecoderReceiver');
goog.provide('media.mojom.VideoDecoderCallbackRouter');
goog.provide('media.mojom.VideoDecoderInterface');
goog.provide('media.mojom.VideoDecoderRemote');
goog.provide('media.mojom.VideoDecoderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.VideoDecoderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.VideoDecoder.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.VideoDecoderInterface = class {
  
  /**
   * @return {!Promise<{
        supportedConfigs: !Array<!media.mojom.SupportedVideoDecoderConfig>,
        decoderType: !media.mojom.VideoDecoderType,
   *  }>}
   */

  getSupportedConfigs() {}
  
  /**
   * @param { !Object } client
   * @param { !media.mojom.MediaLogRemote } mediaLog
   * @param { !media.mojom.VideoFrameHandleReleaserPendingReceiver } videoFrameHandleReleaser
   * @param { !MojoHandle } decoderBufferPipe
   * @param { ?media.mojom.CommandBufferId } commandBufferId
   * @param { !gfx.mojom.ColorSpace } targetColorSpace
   */

  construct(client, mediaLog, videoFrameHandleReleaser, decoderBufferPipe, commandBufferId, targetColorSpace) {}
  
  /**
   * @param { !media.mojom.VideoDecoderConfig } config
   * @param { !boolean } lowDelay
   * @param { ?media.mojom.Cdm } cdm
   * @return {!Promise<{
        status: !media.mojom.DecoderStatus,
        needsBitstreamConversion: !boolean,
        maxDecodeRequests: !number,
        decoderType: !media.mojom.VideoDecoderType,
        needsTranscryption: !boolean,
   *  }>}
   */

  initialize(config, lowDelay, cdm) {}
  
  /**
   * @param { !media.mojom.DecoderBuffer } buffer
   * @return {!Promise<{
        status: !media.mojom.DecoderStatus,
   *  }>}
   */

  decode(buffer) {}
  
  /**
   * @return {!Promise}
   */

  reset() {}
  
  /**
   * @param { !media.mojom.OverlayInfo } overlayInfo
   */

  onOverlayInfoChanged(overlayInfo) {}
};

/**
 * @export
 * @implements { media.mojom.VideoDecoderInterface }
 */
media.mojom.VideoDecoderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.VideoDecoderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.VideoDecoderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.VideoDecoderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        supportedConfigs: !Array<!media.mojom.SupportedVideoDecoderConfig>,
        decoderType: !media.mojom.VideoDecoderType,
   *  }>}
   */

  getSupportedConfigs() {
    return this.proxy.sendMessage(
        0,
        media.mojom.VideoDecoder_GetSupportedConfigs_ParamsSpec.$,
        media.mojom.VideoDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Object } client
   * @param { !media.mojom.MediaLogRemote } mediaLog
   * @param { !media.mojom.VideoFrameHandleReleaserPendingReceiver } videoFrameHandleReleaser
   * @param { !MojoHandle } decoderBufferPipe
   * @param { ?media.mojom.CommandBufferId } commandBufferId
   * @param { !gfx.mojom.ColorSpace } targetColorSpace
   */

  construct(
      client,
      mediaLog,
      videoFrameHandleReleaser,
      decoderBufferPipe,
      commandBufferId,
      targetColorSpace) {
    this.proxy.sendMessage(
        1,
        media.mojom.VideoDecoder_Construct_ParamsSpec.$,
        null,
        [
          client,
          mediaLog,
          videoFrameHandleReleaser,
          decoderBufferPipe,
          commandBufferId,
          targetColorSpace
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.VideoDecoderConfig } config
   * @param { !boolean } lowDelay
   * @param { ?media.mojom.Cdm } cdm
   * @return {!Promise<{
        status: !media.mojom.DecoderStatus,
        needsBitstreamConversion: !boolean,
        maxDecodeRequests: !number,
        decoderType: !media.mojom.VideoDecoderType,
        needsTranscryption: !boolean,
   *  }>}
   */

  initialize(
      config,
      lowDelay,
      cdm) {
    return this.proxy.sendMessage(
        2,
        media.mojom.VideoDecoder_Initialize_ParamsSpec.$,
        media.mojom.VideoDecoder_Initialize_ResponseParamsSpec.$,
        [
          config,
          lowDelay,
          cdm
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.DecoderBuffer } buffer
   * @return {!Promise<{
        status: !media.mojom.DecoderStatus,
   *  }>}
   */

  decode(
      buffer) {
    return this.proxy.sendMessage(
        3,
        media.mojom.VideoDecoder_Decode_ParamsSpec.$,
        media.mojom.VideoDecoder_Decode_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  reset() {
    return this.proxy.sendMessage(
        4,
        media.mojom.VideoDecoder_Reset_ParamsSpec.$,
        media.mojom.VideoDecoder_Reset_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.OverlayInfo } overlayInfo
   */

  onOverlayInfoChanged(
      overlayInfo) {
    this.proxy.sendMessage(
        5,
        media.mojom.VideoDecoder_OnOverlayInfoChanged_ParamsSpec.$,
        null,
        [
          overlayInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VideoDecoder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.VideoDecoderReceiver = class {
  /**
   * @param {!media.mojom.VideoDecoderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.VideoDecoderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.VideoDecoderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoDecoderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoDecoder_GetSupportedConfigs_ParamsSpec.$,
        media.mojom.VideoDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
        impl.getSupportedConfigs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoDecoder_Construct_ParamsSpec.$,
        null,
        impl.construct.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoDecoder_Initialize_ParamsSpec.$,
        media.mojom.VideoDecoder_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.VideoDecoder_Decode_ParamsSpec.$,
        media.mojom.VideoDecoder_Decode_ResponseParamsSpec.$,
        impl.decode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.VideoDecoder_Reset_ParamsSpec.$,
        media.mojom.VideoDecoder_Reset_ResponseParamsSpec.$,
        impl.reset.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.VideoDecoder_OnOverlayInfoChanged_ParamsSpec.$,
        null,
        impl.onOverlayInfoChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.VideoDecoder = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoDecoder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.VideoDecoderRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.VideoDecoderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VideoDecoder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.VideoDecoderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.VideoDecoderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoDecoderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSupportedConfigs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoDecoder_GetSupportedConfigs_ParamsSpec.$,
        media.mojom.VideoDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
        this.getSupportedConfigs.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.construct =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoDecoder_Construct_ParamsSpec.$,
        null,
        this.construct.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoDecoder_Initialize_ParamsSpec.$,
        media.mojom.VideoDecoder_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.VideoDecoder_Decode_ParamsSpec.$,
        media.mojom.VideoDecoder_Decode_ResponseParamsSpec.$,
        this.decode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.VideoDecoder_Reset_ParamsSpec.$,
        media.mojom.VideoDecoder_Reset_ResponseParamsSpec.$,
        this.reset.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onOverlayInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.VideoDecoder_OnOverlayInfoChanged_ParamsSpec.$,
        null,
        this.onOverlayInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.VideoDecoderClient');
goog.provide('media.mojom.VideoDecoderClientReceiver');
goog.provide('media.mojom.VideoDecoderClientCallbackRouter');
goog.provide('media.mojom.VideoDecoderClientInterface');
goog.provide('media.mojom.VideoDecoderClientRemote');
goog.provide('media.mojom.VideoDecoderClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.VideoDecoderClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.VideoDecoderClient.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.VideoDecoderClientInterface = class {
  
  /**
   * @param { !media.mojom.VideoFrame } frame
   * @param { !boolean } canReadWithoutStalling
   * @param { ?mojoBase.mojom.UnguessableToken } releaseToken
   */

  onVideoFrameDecoded(frame, canReadWithoutStalling, releaseToken) {}
  
  /**
   * @param { !media.mojom.WaitingReason } reason
   */

  onWaiting(reason) {}
  
  /**
   */

  requestOverlayInfo() {}
};

/**
 * @export
 * @implements { media.mojom.VideoDecoderClientInterface }
 */
media.mojom.VideoDecoderClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.VideoDecoderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.VideoDecoderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.VideoDecoderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.VideoFrame } frame
   * @param { !boolean } canReadWithoutStalling
   * @param { ?mojoBase.mojom.UnguessableToken } releaseToken
   */

  onVideoFrameDecoded(
      frame,
      canReadWithoutStalling,
      releaseToken) {
    this.proxy.sendMessage(
        0,
        media.mojom.VideoDecoderClient_OnVideoFrameDecoded_ParamsSpec.$,
        null,
        [
          frame,
          canReadWithoutStalling,
          releaseToken
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.WaitingReason } reason
   */

  onWaiting(
      reason) {
    this.proxy.sendMessage(
        1,
        media.mojom.VideoDecoderClient_OnWaiting_ParamsSpec.$,
        null,
        [
          reason
        ],
        false);
  }

  
  /**
   */

  requestOverlayInfo() {
    this.proxy.sendMessage(
        2,
        media.mojom.VideoDecoderClient_RequestOverlayInfo_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VideoDecoderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.VideoDecoderClientReceiver = class {
  /**
   * @param {!media.mojom.VideoDecoderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.VideoDecoderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.VideoDecoderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoDecoderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoDecoderClient_OnVideoFrameDecoded_ParamsSpec.$,
        null,
        impl.onVideoFrameDecoded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoDecoderClient_OnWaiting_ParamsSpec.$,
        null,
        impl.onWaiting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoDecoderClient_RequestOverlayInfo_ParamsSpec.$,
        null,
        impl.requestOverlayInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.VideoDecoderClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoDecoderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.VideoDecoderClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.VideoDecoderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VideoDecoderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.VideoDecoderClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.VideoDecoderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoDecoderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onVideoFrameDecoded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoDecoderClient_OnVideoFrameDecoded_ParamsSpec.$,
        null,
        this.onVideoFrameDecoded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWaiting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoDecoderClient_OnWaiting_ParamsSpec.$,
        null,
        this.onWaiting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestOverlayInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoDecoderClient_RequestOverlayInfo_ParamsSpec.$,
        null,
        this.requestOverlayInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.SupportedVideoDecoderConfigSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SupportedVideoDecoderConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.CommandBufferIdSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CommandBufferIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.OverlayInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.OverlayInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecoder_GetSupportedConfigs_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecoder_GetSupportedConfigs_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecoder_GetSupportedConfigs_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecoder_GetSupportedConfigs_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecoder_Construct_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecoder_Construct_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecoder_Initialize_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecoder_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecoder_Initialize_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecoder_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecoder_Decode_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecoder_Decode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecoder_Decode_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecoder_Decode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecoder_Reset_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecoder_Reset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecoder_Reset_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecoder_Reset_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecoder_OnOverlayInfoChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecoder_OnOverlayInfoChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecoderClient_OnVideoFrameDecoded_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecoderClient_OnVideoFrameDecoded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecoderClient_OnWaiting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecoderClient_OnWaiting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoDecoderClient_RequestOverlayInfo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoDecoderClient_RequestOverlayInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.CdmSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
media.mojom.CdmSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.SupportedVideoDecoderConfigSpec.$,
    'SupportedVideoDecoderConfig',
    [
      mojo.internal.StructField(
        'profileMin', 0,
        0,
        media.mojom.VideoCodecProfileSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'profileMax', 4,
        0,
        media.mojom.VideoCodecProfileSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'codedSizeMin', 8,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'codedSizeMax', 16,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowEncrypted', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requireEncrypted', 24,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('media.mojom.SupportedVideoDecoderConfig');

/** @record */
media.mojom.SupportedVideoDecoderConfig = class {
  constructor() {
    /** @export { !media.mojom.VideoCodecProfile } */
    this.profileMin;
    /** @export { !media.mojom.VideoCodecProfile } */
    this.profileMax;
    /** @export { !gfx.mojom.Size } */
    this.codedSizeMin;
    /** @export { !gfx.mojom.Size } */
    this.codedSizeMax;
    /** @export { !boolean } */
    this.allowEncrypted;
    /** @export { !boolean } */
    this.requireEncrypted;
  }
};



mojo.internal.Struct(
    media.mojom.CommandBufferIdSpec.$,
    'CommandBufferId',
    [
      mojo.internal.StructField(
        'channelToken', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'routeId', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.CommandBufferId');

/** @record */
media.mojom.CommandBufferId = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.channelToken;
    /** @export { !number } */
    this.routeId;
  }
};



mojo.internal.Struct(
    media.mojom.OverlayInfoSpec.$,
    'OverlayInfo',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.OverlayInfo');

/** @record */
media.mojom.OverlayInfo = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsSpec.$,
    'VideoFrameHandleReleaser_ReleaseVideoFrame_Params',
    [
      mojo.internal.StructField(
        'releaseToken', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'releaseSyncToken', 8,
        0,
        gpu.mojom.SyncTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoFrameHandleReleaser_ReleaseVideoFrame_Params');

/** @record */
media.mojom.VideoFrameHandleReleaser_ReleaseVideoFrame_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.releaseToken;
    /** @export { (gpu.mojom.SyncToken|undefined) } */
    this.releaseSyncToken;
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecoder_GetSupportedConfigs_ParamsSpec.$,
    'VideoDecoder_GetSupportedConfigs_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.VideoDecoder_GetSupportedConfigs_Params');

/** @record */
media.mojom.VideoDecoder_GetSupportedConfigs_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
    'VideoDecoder_GetSupportedConfigs_ResponseParams',
    [
      mojo.internal.StructField(
        'supportedConfigs', 0,
        0,
        mojo.internal.Array(media.mojom.SupportedVideoDecoderConfigSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'decoderType', 8,
        0,
        media.mojom.VideoDecoderTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoDecoder_GetSupportedConfigs_ResponseParams');

/** @record */
media.mojom.VideoDecoder_GetSupportedConfigs_ResponseParams = class {
  constructor() {
    /** @export { !Array<!media.mojom.SupportedVideoDecoderConfig> } */
    this.supportedConfigs;
    /** @export { !media.mojom.VideoDecoderType } */
    this.decoderType;
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecoder_Construct_ParamsSpec.$,
    'VideoDecoder_Construct_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(media.mojom.VideoDecoderClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mediaLog', 8,
        0,
        mojo.internal.InterfaceProxy(media.mojom.MediaLogRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoFrameHandleReleaser', 16,
        0,
        mojo.internal.InterfaceRequest(media.mojom.VideoFrameHandleReleaserPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'decoderBufferPipe', 20,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'commandBufferId', 24,
        0,
        media.mojom.CommandBufferIdSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetColorSpace', 32,
        0,
        gfx.mojom.ColorSpaceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('media.mojom.VideoDecoder_Construct_Params');

/** @record */
media.mojom.VideoDecoder_Construct_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
    /** @export { !media.mojom.MediaLogRemote } */
    this.mediaLog;
    /** @export { !media.mojom.VideoFrameHandleReleaserPendingReceiver } */
    this.videoFrameHandleReleaser;
    /** @export { !MojoHandle } */
    this.decoderBufferPipe;
    /** @export { (media.mojom.CommandBufferId|undefined) } */
    this.commandBufferId;
    /** @export { !gfx.mojom.ColorSpace } */
    this.targetColorSpace;
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecoder_Initialize_ParamsSpec.$,
    'VideoDecoder_Initialize_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        media.mojom.VideoDecoderConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lowDelay', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cdm', 16,
        0,
        media.mojom.CdmSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('media.mojom.VideoDecoder_Initialize_Params');

/** @record */
media.mojom.VideoDecoder_Initialize_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoDecoderConfig } */
    this.config;
    /** @export { !boolean } */
    this.lowDelay;
    /** @export { (media.mojom.Cdm|undefined) } */
    this.cdm;
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecoder_Initialize_ResponseParamsSpec.$,
    'VideoDecoder_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.DecoderStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'needsBitstreamConversion', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxDecodeRequests', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'decoderType', 16,
        0,
        media.mojom.VideoDecoderTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'needsTranscryption', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.VideoDecoder_Initialize_ResponseParams');

/** @record */
media.mojom.VideoDecoder_Initialize_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.DecoderStatus } */
    this.status;
    /** @export { !boolean } */
    this.needsBitstreamConversion;
    /** @export { !number } */
    this.maxDecodeRequests;
    /** @export { !media.mojom.VideoDecoderType } */
    this.decoderType;
    /** @export { !boolean } */
    this.needsTranscryption;
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecoder_Decode_ParamsSpec.$,
    'VideoDecoder_Decode_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media.mojom.DecoderBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoDecoder_Decode_Params');

/** @record */
media.mojom.VideoDecoder_Decode_Params = class {
  constructor() {
    /** @export { !media.mojom.DecoderBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecoder_Decode_ResponseParamsSpec.$,
    'VideoDecoder_Decode_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.DecoderStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoDecoder_Decode_ResponseParams');

/** @record */
media.mojom.VideoDecoder_Decode_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.DecoderStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecoder_Reset_ParamsSpec.$,
    'VideoDecoder_Reset_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.VideoDecoder_Reset_Params');

/** @record */
media.mojom.VideoDecoder_Reset_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecoder_Reset_ResponseParamsSpec.$,
    'VideoDecoder_Reset_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.VideoDecoder_Reset_ResponseParams');

/** @record */
media.mojom.VideoDecoder_Reset_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecoder_OnOverlayInfoChanged_ParamsSpec.$,
    'VideoDecoder_OnOverlayInfoChanged_Params',
    [
      mojo.internal.StructField(
        'overlayInfo', 0,
        0,
        media.mojom.OverlayInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoDecoder_OnOverlayInfoChanged_Params');

/** @record */
media.mojom.VideoDecoder_OnOverlayInfoChanged_Params = class {
  constructor() {
    /** @export { !media.mojom.OverlayInfo } */
    this.overlayInfo;
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecoderClient_OnVideoFrameDecoded_ParamsSpec.$,
    'VideoDecoderClient_OnVideoFrameDecoded_Params',
    [
      mojo.internal.StructField(
        'frame', 0,
        0,
        media.mojom.VideoFrameSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'canReadWithoutStalling', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'releaseToken', 16,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.VideoDecoderClient_OnVideoFrameDecoded_Params');

/** @record */
media.mojom.VideoDecoderClient_OnVideoFrameDecoded_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoFrame } */
    this.frame;
    /** @export { !boolean } */
    this.canReadWithoutStalling;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.releaseToken;
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecoderClient_OnWaiting_ParamsSpec.$,
    'VideoDecoderClient_OnWaiting_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        media.mojom.WaitingReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoDecoderClient_OnWaiting_Params');

/** @record */
media.mojom.VideoDecoderClient_OnWaiting_Params = class {
  constructor() {
    /** @export { !media.mojom.WaitingReason } */
    this.reason;
  }
};



mojo.internal.Struct(
    media.mojom.VideoDecoderClient_RequestOverlayInfo_ParamsSpec.$,
    'VideoDecoderClient_RequestOverlayInfo_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.VideoDecoderClient_RequestOverlayInfo_Params');

/** @record */
media.mojom.VideoDecoderClient_RequestOverlayInfo_Params = class {
  constructor() {
  }
};

goog.provide('media.mojom.Cdm');


mojo.internal.Union(
    media.mojom.CdmSpec.$, 'Cdm',
    {
      'cdmId': {
        'ordinal': 0,
        'type': mojoBase.mojom.UnguessableTokenSpec.$,
      },
      'cdmContext': {
        'ordinal': 1,
        'type': mojo.internal.InterfaceProxy(media.mojom.CdmContextForOOPVDRemote),
      },
    });

/**
 * @typedef { {
 *   cdmId: (!mojoBase.mojom.UnguessableToken|undefined),
 *   cdmContext: (!media.mojom.CdmContextForOOPVDRemote|undefined),
 * } }
 */
media.mojom.Cdm;
