// media/mojo/mojom/video_decoder.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/video_decoder.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var sync_token$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/sync_token.mojom', '../../../gpu/ipc/common/sync_token.mojom.js');
  }
  var media_log$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_log.mojom', 'media_log.mojom.js');
  }
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', 'media_types.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var color_space$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/color_space.mojom', '../../../ui/gfx/mojom/color_space.mojom.js');
  }
  var cdm_context_for_oopvd$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/cdm_context_for_oopvd.mojom', 'cdm_context_for_oopvd.mojom.js');
  }



  function SupportedVideoDecoderConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SupportedVideoDecoderConfig.prototype.initDefaults_ = function() {
    this.profileMin = 0;
    this.profileMax = 0;
    this.codedSizeMin = null;
    this.codedSizeMax = null;
    this.allowEncrypted = false;
    this.requireEncrypted = false;
  };
  SupportedVideoDecoderConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SupportedVideoDecoderConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SupportedVideoDecoderConfig.profileMin
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, media_types$.VideoCodecProfile);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SupportedVideoDecoderConfig.profileMax
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, media_types$.VideoCodecProfile);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SupportedVideoDecoderConfig.codedSizeMin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SupportedVideoDecoderConfig.codedSizeMax
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SupportedVideoDecoderConfig.encodedSize = codec.kStructHeaderSize + 32;

  SupportedVideoDecoderConfig.decode = function(decoder) {
    var packed;
    var val = new SupportedVideoDecoderConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.profileMin =
        decoder.decodeStruct(new codec.Enum(media_types$.VideoCodecProfile));
    val.profileMax =
        decoder.decodeStruct(new codec.Enum(media_types$.VideoCodecProfile));
    val.codedSizeMin =
        decoder.decodeStructPointer(geometry$.Size);
    val.codedSizeMax =
        decoder.decodeStructPointer(geometry$.Size);
    packed = decoder.readUint8();
    val.allowEncrypted = (packed >> 0) & 1 ? true : false;
    val.requireEncrypted = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SupportedVideoDecoderConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SupportedVideoDecoderConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.profileMin);
    encoder.encodeStruct(codec.Int32, val.profileMax);
    encoder.encodeStructPointer(geometry$.Size, val.codedSizeMin);
    encoder.encodeStructPointer(geometry$.Size, val.codedSizeMax);
    packed = 0;
    packed |= (val.allowEncrypted & 1) << 0
    packed |= (val.requireEncrypted & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CommandBufferId(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CommandBufferId.prototype.initDefaults_ = function() {
    this.channelToken = null;
    this.routeId = 0;
  };
  CommandBufferId.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CommandBufferId.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommandBufferId.channelToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CommandBufferId.encodedSize = codec.kStructHeaderSize + 16;

  CommandBufferId.decode = function(decoder) {
    var packed;
    var val = new CommandBufferId();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.channelToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.routeId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CommandBufferId.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CommandBufferId.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.channelToken);
    encoder.encodeStruct(codec.Int32, val.routeId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OverlayInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OverlayInfo.prototype.initDefaults_ = function() {
  };
  OverlayInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OverlayInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OverlayInfo.encodedSize = codec.kStructHeaderSize + 0;

  OverlayInfo.decode = function(decoder) {
    var packed;
    var val = new OverlayInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  OverlayInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OverlayInfo.encodedSize);
    encoder.writeUint32(0);
  };
  function VideoFrameHandleReleaser_ReleaseVideoFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoFrameHandleReleaser_ReleaseVideoFrame_Params.prototype.initDefaults_ = function() {
    this.releaseToken = null;
    this.releaseSyncToken = null;
  };
  VideoFrameHandleReleaser_ReleaseVideoFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoFrameHandleReleaser_ReleaseVideoFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrameHandleReleaser_ReleaseVideoFrame_Params.releaseToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrameHandleReleaser_ReleaseVideoFrame_Params.releaseSyncToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, sync_token$.SyncToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoFrameHandleReleaser_ReleaseVideoFrame_Params.encodedSize = codec.kStructHeaderSize + 16;

  VideoFrameHandleReleaser_ReleaseVideoFrame_Params.decode = function(decoder) {
    var packed;
    var val = new VideoFrameHandleReleaser_ReleaseVideoFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.releaseToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.releaseSyncToken =
        decoder.decodeStructPointer(sync_token$.SyncToken);
    return val;
  };

  VideoFrameHandleReleaser_ReleaseVideoFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoFrameHandleReleaser_ReleaseVideoFrame_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.releaseToken);
    encoder.encodeStructPointer(sync_token$.SyncToken, val.releaseSyncToken);
  };
  function VideoDecoder_GetSupportedConfigs_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoder_GetSupportedConfigs_Params.prototype.initDefaults_ = function() {
  };
  VideoDecoder_GetSupportedConfigs_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoder_GetSupportedConfigs_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoder_GetSupportedConfigs_Params.encodedSize = codec.kStructHeaderSize + 0;

  VideoDecoder_GetSupportedConfigs_Params.decode = function(decoder) {
    var packed;
    var val = new VideoDecoder_GetSupportedConfigs_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  VideoDecoder_GetSupportedConfigs_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoder_GetSupportedConfigs_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function VideoDecoder_GetSupportedConfigs_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoder_GetSupportedConfigs_ResponseParams.prototype.initDefaults_ = function() {
    this.supportedConfigs = null;
    this.decoderType = 0;
  };
  VideoDecoder_GetSupportedConfigs_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoder_GetSupportedConfigs_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoder_GetSupportedConfigs_ResponseParams.supportedConfigs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SupportedVideoDecoderConfig), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoder_GetSupportedConfigs_ResponseParams.decoderType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, media_types$.VideoDecoderType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoder_GetSupportedConfigs_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  VideoDecoder_GetSupportedConfigs_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new VideoDecoder_GetSupportedConfigs_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.supportedConfigs =
        decoder.decodeArrayPointer(new codec.PointerTo(SupportedVideoDecoderConfig));
    val.decoderType =
        decoder.decodeStruct(new codec.Enum(media_types$.VideoDecoderType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoDecoder_GetSupportedConfigs_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoder_GetSupportedConfigs_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SupportedVideoDecoderConfig), val.supportedConfigs);
    encoder.encodeStruct(codec.Int32, val.decoderType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoDecoder_Construct_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoder_Construct_Params.prototype.initDefaults_ = function() {
    this.client = new associatedBindings.AssociatedInterfacePtrInfo();
    this.mediaLog = new media_log$.MediaLogPtr();
    this.videoFrameHandleReleaser = new bindings.InterfaceRequest();
    this.decoderBufferPipe = null;
    this.commandBufferId = null;
    this.targetColorSpace = null;
  };
  VideoDecoder_Construct_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoder_Construct_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoder_Construct_Params.client
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoder_Construct_Params.mediaLog
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoder_Construct_Params.videoFrameHandleReleaser
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoder_Construct_Params.decoderBufferPipe
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 20, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoder_Construct_Params.commandBufferId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, CommandBufferId, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoder_Construct_Params.targetColorSpace
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, color_space$.ColorSpace, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoder_Construct_Params.encodedSize = codec.kStructHeaderSize + 40;

  VideoDecoder_Construct_Params.decode = function(decoder) {
    var packed;
    var val = new VideoDecoder_Construct_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.mediaLog =
        decoder.decodeStruct(new codec.Interface(media_log$.MediaLogPtr));
    val.videoFrameHandleReleaser =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.decoderBufferPipe =
        decoder.decodeStruct(codec.Handle);
    val.commandBufferId =
        decoder.decodeStructPointer(CommandBufferId);
    val.targetColorSpace =
        decoder.decodeStructPointer(color_space$.ColorSpace);
    return val;
  };

  VideoDecoder_Construct_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoder_Construct_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.client);
    encoder.encodeStruct(new codec.Interface(media_log$.MediaLogPtr), val.mediaLog);
    encoder.encodeStruct(codec.InterfaceRequest, val.videoFrameHandleReleaser);
    encoder.encodeStruct(codec.Handle, val.decoderBufferPipe);
    encoder.encodeStructPointer(CommandBufferId, val.commandBufferId);
    encoder.encodeStructPointer(color_space$.ColorSpace, val.targetColorSpace);
  };
  function VideoDecoder_Initialize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoder_Initialize_Params.prototype.initDefaults_ = function() {
    this.config = null;
    this.lowDelay = false;
    this.cdm = null;
  };
  VideoDecoder_Initialize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoder_Initialize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoder_Initialize_Params.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.VideoDecoderConfig, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoDecoder_Initialize_Params.cdm
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, Cdm, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoder_Initialize_Params.encodedSize = codec.kStructHeaderSize + 32;

  VideoDecoder_Initialize_Params.decode = function(decoder) {
    var packed;
    var val = new VideoDecoder_Initialize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.config =
        decoder.decodeStructPointer(media_types$.VideoDecoderConfig);
    packed = decoder.readUint8();
    val.lowDelay = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.cdm =
        decoder.decodeStruct(Cdm);
    return val;
  };

  VideoDecoder_Initialize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoder_Initialize_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.VideoDecoderConfig, val.config);
    packed = 0;
    packed |= (val.lowDelay & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(Cdm, val.cdm);
  };
  function VideoDecoder_Initialize_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoder_Initialize_ResponseParams.prototype.initDefaults_ = function() {
    this.status = null;
    this.needsBitstreamConversion = false;
    this.needsTranscryption = false;
    this.maxDecodeRequests = 0;
    this.decoderType = 0;
  };
  VideoDecoder_Initialize_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoder_Initialize_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoder_Initialize_ResponseParams.status
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.DecoderStatus, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate VideoDecoder_Initialize_ResponseParams.decoderType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, media_types$.VideoDecoderType);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VideoDecoder_Initialize_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  VideoDecoder_Initialize_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new VideoDecoder_Initialize_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStructPointer(media_types$.DecoderStatus);
    packed = decoder.readUint8();
    val.needsBitstreamConversion = (packed >> 0) & 1 ? true : false;
    val.needsTranscryption = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.maxDecodeRequests =
        decoder.decodeStruct(codec.Int32);
    val.decoderType =
        decoder.decodeStruct(new codec.Enum(media_types$.VideoDecoderType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoDecoder_Initialize_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoder_Initialize_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.DecoderStatus, val.status);
    packed = 0;
    packed |= (val.needsBitstreamConversion & 1) << 0
    packed |= (val.needsTranscryption & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.maxDecodeRequests);
    encoder.encodeStruct(codec.Int32, val.decoderType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoDecoder_Decode_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoder_Decode_Params.prototype.initDefaults_ = function() {
    this.buffer = null;
  };
  VideoDecoder_Decode_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoder_Decode_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoder_Decode_Params.buffer
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, media_types$.DecoderBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoder_Decode_Params.encodedSize = codec.kStructHeaderSize + 16;

  VideoDecoder_Decode_Params.decode = function(decoder) {
    var packed;
    var val = new VideoDecoder_Decode_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buffer =
        decoder.decodeStruct(media_types$.DecoderBuffer);
    return val;
  };

  VideoDecoder_Decode_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoder_Decode_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(media_types$.DecoderBuffer, val.buffer);
  };
  function VideoDecoder_Decode_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoder_Decode_ResponseParams.prototype.initDefaults_ = function() {
    this.status = null;
  };
  VideoDecoder_Decode_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoder_Decode_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoder_Decode_ResponseParams.status
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.DecoderStatus, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoder_Decode_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  VideoDecoder_Decode_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new VideoDecoder_Decode_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStructPointer(media_types$.DecoderStatus);
    return val;
  };

  VideoDecoder_Decode_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoder_Decode_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.DecoderStatus, val.status);
  };
  function VideoDecoder_Reset_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoder_Reset_Params.prototype.initDefaults_ = function() {
  };
  VideoDecoder_Reset_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoder_Reset_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoder_Reset_Params.encodedSize = codec.kStructHeaderSize + 0;

  VideoDecoder_Reset_Params.decode = function(decoder) {
    var packed;
    var val = new VideoDecoder_Reset_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  VideoDecoder_Reset_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoder_Reset_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function VideoDecoder_Reset_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoder_Reset_ResponseParams.prototype.initDefaults_ = function() {
  };
  VideoDecoder_Reset_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoder_Reset_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoder_Reset_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  VideoDecoder_Reset_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new VideoDecoder_Reset_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  VideoDecoder_Reset_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoder_Reset_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function VideoDecoder_OnOverlayInfoChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoder_OnOverlayInfoChanged_Params.prototype.initDefaults_ = function() {
    this.overlayInfo = null;
  };
  VideoDecoder_OnOverlayInfoChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoder_OnOverlayInfoChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoder_OnOverlayInfoChanged_Params.overlayInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, OverlayInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoder_OnOverlayInfoChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  VideoDecoder_OnOverlayInfoChanged_Params.decode = function(decoder) {
    var packed;
    var val = new VideoDecoder_OnOverlayInfoChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.overlayInfo =
        decoder.decodeStructPointer(OverlayInfo);
    return val;
  };

  VideoDecoder_OnOverlayInfoChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoder_OnOverlayInfoChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(OverlayInfo, val.overlayInfo);
  };
  function VideoDecoderClient_OnVideoFrameDecoded_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoderClient_OnVideoFrameDecoded_Params.prototype.initDefaults_ = function() {
    this.frame = null;
    this.canReadWithoutStalling = false;
    this.releaseToken = null;
  };
  VideoDecoderClient_OnVideoFrameDecoded_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoderClient_OnVideoFrameDecoded_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderClient_OnVideoFrameDecoded_Params.frame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.VideoFrame, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoDecoderClient_OnVideoFrameDecoded_Params.releaseToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoderClient_OnVideoFrameDecoded_Params.encodedSize = codec.kStructHeaderSize + 24;

  VideoDecoderClient_OnVideoFrameDecoded_Params.decode = function(decoder) {
    var packed;
    var val = new VideoDecoderClient_OnVideoFrameDecoded_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frame =
        decoder.decodeStructPointer(media_types$.VideoFrame);
    packed = decoder.readUint8();
    val.canReadWithoutStalling = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.releaseToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  VideoDecoderClient_OnVideoFrameDecoded_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoderClient_OnVideoFrameDecoded_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.VideoFrame, val.frame);
    packed = 0;
    packed |= (val.canReadWithoutStalling & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.releaseToken);
  };
  function VideoDecoderClient_OnWaiting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoderClient_OnWaiting_Params.prototype.initDefaults_ = function() {
    this.reason = 0;
  };
  VideoDecoderClient_OnWaiting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoderClient_OnWaiting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderClient_OnWaiting_Params.reason
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, media_types$.WaitingReason);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoderClient_OnWaiting_Params.encodedSize = codec.kStructHeaderSize + 8;

  VideoDecoderClient_OnWaiting_Params.decode = function(decoder) {
    var packed;
    var val = new VideoDecoderClient_OnWaiting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reason =
        decoder.decodeStruct(new codec.Enum(media_types$.WaitingReason));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoDecoderClient_OnWaiting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoderClient_OnWaiting_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.reason);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoDecoderClient_RequestOverlayInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoderClient_RequestOverlayInfo_Params.prototype.initDefaults_ = function() {
  };
  VideoDecoderClient_RequestOverlayInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoderClient_RequestOverlayInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoderClient_RequestOverlayInfo_Params.encodedSize = codec.kStructHeaderSize + 0;

  VideoDecoderClient_RequestOverlayInfo_Params.decode = function(decoder) {
    var packed;
    var val = new VideoDecoderClient_RequestOverlayInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  VideoDecoderClient_RequestOverlayInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoderClient_RequestOverlayInfo_Params.encodedSize);
    encoder.writeUint32(0);
  };

  function Cdm(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  Cdm.Tags = {
    cdmId: 0,
    cdmContext: 1,
  };

  Cdm.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  Cdm.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "cdmId",
        "cdmContext",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a Cdm member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(Cdm.prototype, "cdmId", {
    get: function() {
      if (this.$tag != Cdm.Tags.cdmId) {
        throw new ReferenceError(
            "Cdm.cdmId is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = Cdm.Tags.cdmId;
      this.$data = value;
    }
  });
  Object.defineProperty(Cdm.prototype, "cdmContext", {
    get: function() {
      if (this.$tag != Cdm.Tags.cdmContext) {
        throw new ReferenceError(
            "Cdm.cdmContext is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = Cdm.Tags.cdmContext;
      this.$data = value;
    }
  });


    Cdm.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case Cdm.Tags.cdmId:
          encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.cdmId);
          break;
        case Cdm.Tags.cdmContext:
          encoder.encodeStruct(new codec.Interface(cdm_context_for_oopvd$.CdmContextForOOPVDPtr), val.cdmContext);
          break;
      }
      encoder.align();
    };


    Cdm.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new Cdm();
      var tag = decoder.readUint32();
      switch (tag) {
        case Cdm.Tags.cdmId:
          result.cdmId = decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
          break;
        case Cdm.Tags.cdmContext:
          result.cdmContext = decoder.decodeStruct(new codec.Interface(cdm_context_for_oopvd$.CdmContextForOOPVDPtr));
          break;
      }
      decoder.align();

      return result;
    };


    Cdm.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case Cdm.Tags.cdmId:
          

    // validate Cdm.cdmId
    err = messageValidator.validateStructPointer(data_offset, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case Cdm.Tags.cdmContext:
          

    // validate Cdm.cdmContext
    err = messageValidator.validateInterface(data_offset, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  Cdm.encodedSize = 16;
  var kVideoFrameHandleReleaser_ReleaseVideoFrame_Name = 0;

  function VideoFrameHandleReleaserPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(VideoFrameHandleReleaser,
                                                   handleOrPtrInfo);
  }

  function VideoFrameHandleReleaserAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        VideoFrameHandleReleaser, associatedInterfacePtrInfo);
  }

  VideoFrameHandleReleaserAssociatedPtr.prototype =
      Object.create(VideoFrameHandleReleaserPtr.prototype);
  VideoFrameHandleReleaserAssociatedPtr.prototype.constructor =
      VideoFrameHandleReleaserAssociatedPtr;

  function VideoFrameHandleReleaserProxy(receiver) {
    this.receiver_ = receiver;
  }
  VideoFrameHandleReleaserPtr.prototype.releaseVideoFrame = function() {
    return VideoFrameHandleReleaserProxy.prototype.releaseVideoFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoFrameHandleReleaserProxy.prototype.releaseVideoFrame = function(releaseToken, releaseSyncToken) {
    var params_ = new VideoFrameHandleReleaser_ReleaseVideoFrame_Params();
    params_.releaseToken = releaseToken;
    params_.releaseSyncToken = releaseSyncToken;
    var builder = new codec.MessageV0Builder(
        kVideoFrameHandleReleaser_ReleaseVideoFrame_Name,
        codec.align(VideoFrameHandleReleaser_ReleaseVideoFrame_Params.encodedSize));
    builder.encodeStruct(VideoFrameHandleReleaser_ReleaseVideoFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function VideoFrameHandleReleaserStub(delegate) {
    this.delegate_ = delegate;
  }
  VideoFrameHandleReleaserStub.prototype.releaseVideoFrame = function(releaseToken, releaseSyncToken) {
    return this.delegate_ && this.delegate_.releaseVideoFrame && this.delegate_.releaseVideoFrame(releaseToken, releaseSyncToken);
  }

  VideoFrameHandleReleaserStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kVideoFrameHandleReleaser_ReleaseVideoFrame_Name:
      var params = reader.decodeStruct(VideoFrameHandleReleaser_ReleaseVideoFrame_Params);
      this.releaseVideoFrame(params.releaseToken, params.releaseSyncToken);
      return true;
    default:
      return false;
    }
  };

  VideoFrameHandleReleaserStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateVideoFrameHandleReleaserRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kVideoFrameHandleReleaser_ReleaseVideoFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoFrameHandleReleaser_ReleaseVideoFrame_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateVideoFrameHandleReleaserResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var VideoFrameHandleReleaser = {
    name: 'media.mojom.VideoFrameHandleReleaser',
    kVersion: 0,
    ptrClass: VideoFrameHandleReleaserPtr,
    proxyClass: VideoFrameHandleReleaserProxy,
    stubClass: VideoFrameHandleReleaserStub,
    validateRequest: validateVideoFrameHandleReleaserRequest,
    validateResponse: null,
  };
  VideoFrameHandleReleaserStub.prototype.validator = validateVideoFrameHandleReleaserRequest;
  VideoFrameHandleReleaserProxy.prototype.validator = null;
  var kVideoDecoder_GetSupportedConfigs_Name = 0;
  var kVideoDecoder_Construct_Name = 1;
  var kVideoDecoder_Initialize_Name = 2;
  var kVideoDecoder_Decode_Name = 3;
  var kVideoDecoder_Reset_Name = 4;
  var kVideoDecoder_OnOverlayInfoChanged_Name = 5;

  function VideoDecoderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(VideoDecoder,
                                                   handleOrPtrInfo);
  }

  function VideoDecoderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        VideoDecoder, associatedInterfacePtrInfo);
  }

  VideoDecoderAssociatedPtr.prototype =
      Object.create(VideoDecoderPtr.prototype);
  VideoDecoderAssociatedPtr.prototype.constructor =
      VideoDecoderAssociatedPtr;

  function VideoDecoderProxy(receiver) {
    this.receiver_ = receiver;
  }
  VideoDecoderPtr.prototype.getSupportedConfigs = function() {
    return VideoDecoderProxy.prototype.getSupportedConfigs
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoDecoderProxy.prototype.getSupportedConfigs = function() {
    var params_ = new VideoDecoder_GetSupportedConfigs_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kVideoDecoder_GetSupportedConfigs_Name,
          codec.align(VideoDecoder_GetSupportedConfigs_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(VideoDecoder_GetSupportedConfigs_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(VideoDecoder_GetSupportedConfigs_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  VideoDecoderPtr.prototype.construct = function() {
    return VideoDecoderProxy.prototype.construct
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoDecoderProxy.prototype.construct = function(client, mediaLog, videoFrameHandleReleaser, decoderBufferPipe, commandBufferId, targetColorSpace) {
    var params_ = new VideoDecoder_Construct_Params();
    params_.client = client;
    params_.mediaLog = mediaLog;
    params_.videoFrameHandleReleaser = videoFrameHandleReleaser;
    params_.decoderBufferPipe = decoderBufferPipe;
    params_.commandBufferId = commandBufferId;
    params_.targetColorSpace = targetColorSpace;
    var builder = new codec.MessageV2Builder(
        kVideoDecoder_Construct_Name,
        codec.align(VideoDecoder_Construct_Params.encodedSize));
    builder.setPayload(VideoDecoder_Construct_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  VideoDecoderPtr.prototype.initialize = function() {
    return VideoDecoderProxy.prototype.initialize
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoDecoderProxy.prototype.initialize = function(config, lowDelay, cdm) {
    var params_ = new VideoDecoder_Initialize_Params();
    params_.config = config;
    params_.lowDelay = lowDelay;
    params_.cdm = cdm;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kVideoDecoder_Initialize_Name,
          codec.align(VideoDecoder_Initialize_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(VideoDecoder_Initialize_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(VideoDecoder_Initialize_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  VideoDecoderPtr.prototype.decode = function() {
    return VideoDecoderProxy.prototype.decode
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoDecoderProxy.prototype.decode = function(buffer) {
    var params_ = new VideoDecoder_Decode_Params();
    params_.buffer = buffer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kVideoDecoder_Decode_Name,
          codec.align(VideoDecoder_Decode_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(VideoDecoder_Decode_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(VideoDecoder_Decode_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  VideoDecoderPtr.prototype.reset = function() {
    return VideoDecoderProxy.prototype.reset
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoDecoderProxy.prototype.reset = function() {
    var params_ = new VideoDecoder_Reset_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kVideoDecoder_Reset_Name,
          codec.align(VideoDecoder_Reset_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(VideoDecoder_Reset_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(VideoDecoder_Reset_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  VideoDecoderPtr.prototype.onOverlayInfoChanged = function() {
    return VideoDecoderProxy.prototype.onOverlayInfoChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoDecoderProxy.prototype.onOverlayInfoChanged = function(overlayInfo) {
    var params_ = new VideoDecoder_OnOverlayInfoChanged_Params();
    params_.overlayInfo = overlayInfo;
    var builder = new codec.MessageV0Builder(
        kVideoDecoder_OnOverlayInfoChanged_Name,
        codec.align(VideoDecoder_OnOverlayInfoChanged_Params.encodedSize));
    builder.encodeStruct(VideoDecoder_OnOverlayInfoChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function VideoDecoderStub(delegate) {
    this.delegate_ = delegate;
  }
  VideoDecoderStub.prototype.getSupportedConfigs = function() {
    return this.delegate_ && this.delegate_.getSupportedConfigs && this.delegate_.getSupportedConfigs();
  }
  VideoDecoderStub.prototype.construct = function(client, mediaLog, videoFrameHandleReleaser, decoderBufferPipe, commandBufferId, targetColorSpace) {
    return this.delegate_ && this.delegate_.construct && this.delegate_.construct(client, mediaLog, videoFrameHandleReleaser, decoderBufferPipe, commandBufferId, targetColorSpace);
  }
  VideoDecoderStub.prototype.initialize = function(config, lowDelay, cdm) {
    return this.delegate_ && this.delegate_.initialize && this.delegate_.initialize(config, lowDelay, cdm);
  }
  VideoDecoderStub.prototype.decode = function(buffer) {
    return this.delegate_ && this.delegate_.decode && this.delegate_.decode(buffer);
  }
  VideoDecoderStub.prototype.reset = function() {
    return this.delegate_ && this.delegate_.reset && this.delegate_.reset();
  }
  VideoDecoderStub.prototype.onOverlayInfoChanged = function(overlayInfo) {
    return this.delegate_ && this.delegate_.onOverlayInfoChanged && this.delegate_.onOverlayInfoChanged(overlayInfo);
  }

  VideoDecoderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kVideoDecoder_Construct_Name:
      var params = reader.decodeStruct(VideoDecoder_Construct_Params);
      this.construct(params.client, params.mediaLog, params.videoFrameHandleReleaser, params.decoderBufferPipe, params.commandBufferId, params.targetColorSpace);
      return true;
    case kVideoDecoder_OnOverlayInfoChanged_Name:
      var params = reader.decodeStruct(VideoDecoder_OnOverlayInfoChanged_Params);
      this.onOverlayInfoChanged(params.overlayInfo);
      return true;
    default:
      return false;
    }
  };

  VideoDecoderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kVideoDecoder_GetSupportedConfigs_Name:
      var params = reader.decodeStruct(VideoDecoder_GetSupportedConfigs_Params);
      this.getSupportedConfigs().then(function(response) {
        var responseParams =
            new VideoDecoder_GetSupportedConfigs_ResponseParams();
        responseParams.supportedConfigs = response.supportedConfigs;
        responseParams.decoderType = response.decoderType;
        var builder = new codec.MessageV1Builder(
            kVideoDecoder_GetSupportedConfigs_Name,
            codec.align(VideoDecoder_GetSupportedConfigs_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(VideoDecoder_GetSupportedConfigs_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kVideoDecoder_Initialize_Name:
      var params = reader.decodeStruct(VideoDecoder_Initialize_Params);
      this.initialize(params.config, params.lowDelay, params.cdm).then(function(response) {
        var responseParams =
            new VideoDecoder_Initialize_ResponseParams();
        responseParams.status = response.status;
        responseParams.needsBitstreamConversion = response.needsBitstreamConversion;
        responseParams.maxDecodeRequests = response.maxDecodeRequests;
        responseParams.decoderType = response.decoderType;
        responseParams.needsTranscryption = response.needsTranscryption;
        var builder = new codec.MessageV1Builder(
            kVideoDecoder_Initialize_Name,
            codec.align(VideoDecoder_Initialize_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(VideoDecoder_Initialize_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kVideoDecoder_Decode_Name:
      var params = reader.decodeStruct(VideoDecoder_Decode_Params);
      this.decode(params.buffer).then(function(response) {
        var responseParams =
            new VideoDecoder_Decode_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kVideoDecoder_Decode_Name,
            codec.align(VideoDecoder_Decode_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(VideoDecoder_Decode_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kVideoDecoder_Reset_Name:
      var params = reader.decodeStruct(VideoDecoder_Reset_Params);
      this.reset().then(function(response) {
        var responseParams =
            new VideoDecoder_Reset_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kVideoDecoder_Reset_Name,
            codec.align(VideoDecoder_Reset_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(VideoDecoder_Reset_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateVideoDecoderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kVideoDecoder_GetSupportedConfigs_Name:
        if (message.expectsResponse())
          paramsClass = VideoDecoder_GetSupportedConfigs_Params;
      break;
      case kVideoDecoder_Construct_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoDecoder_Construct_Params;
      break;
      case kVideoDecoder_Initialize_Name:
        if (message.expectsResponse())
          paramsClass = VideoDecoder_Initialize_Params;
      break;
      case kVideoDecoder_Decode_Name:
        if (message.expectsResponse())
          paramsClass = VideoDecoder_Decode_Params;
      break;
      case kVideoDecoder_Reset_Name:
        if (message.expectsResponse())
          paramsClass = VideoDecoder_Reset_Params;
      break;
      case kVideoDecoder_OnOverlayInfoChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoDecoder_OnOverlayInfoChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateVideoDecoderResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kVideoDecoder_GetSupportedConfigs_Name:
        if (message.isResponse())
          paramsClass = VideoDecoder_GetSupportedConfigs_ResponseParams;
        break;
      case kVideoDecoder_Initialize_Name:
        if (message.isResponse())
          paramsClass = VideoDecoder_Initialize_ResponseParams;
        break;
      case kVideoDecoder_Decode_Name:
        if (message.isResponse())
          paramsClass = VideoDecoder_Decode_ResponseParams;
        break;
      case kVideoDecoder_Reset_Name:
        if (message.isResponse())
          paramsClass = VideoDecoder_Reset_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var VideoDecoder = {
    name: 'media.mojom.VideoDecoder',
    kVersion: 0,
    ptrClass: VideoDecoderPtr,
    proxyClass: VideoDecoderProxy,
    stubClass: VideoDecoderStub,
    validateRequest: validateVideoDecoderRequest,
    validateResponse: validateVideoDecoderResponse,
  };
  VideoDecoderStub.prototype.validator = validateVideoDecoderRequest;
  VideoDecoderProxy.prototype.validator = validateVideoDecoderResponse;
  var kVideoDecoderClient_OnVideoFrameDecoded_Name = 0;
  var kVideoDecoderClient_OnWaiting_Name = 1;
  var kVideoDecoderClient_RequestOverlayInfo_Name = 2;

  function VideoDecoderClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(VideoDecoderClient,
                                                   handleOrPtrInfo);
  }

  function VideoDecoderClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        VideoDecoderClient, associatedInterfacePtrInfo);
  }

  VideoDecoderClientAssociatedPtr.prototype =
      Object.create(VideoDecoderClientPtr.prototype);
  VideoDecoderClientAssociatedPtr.prototype.constructor =
      VideoDecoderClientAssociatedPtr;

  function VideoDecoderClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  VideoDecoderClientPtr.prototype.onVideoFrameDecoded = function() {
    return VideoDecoderClientProxy.prototype.onVideoFrameDecoded
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoDecoderClientProxy.prototype.onVideoFrameDecoded = function(frame, canReadWithoutStalling, releaseToken) {
    var params_ = new VideoDecoderClient_OnVideoFrameDecoded_Params();
    params_.frame = frame;
    params_.canReadWithoutStalling = canReadWithoutStalling;
    params_.releaseToken = releaseToken;
    var builder = new codec.MessageV0Builder(
        kVideoDecoderClient_OnVideoFrameDecoded_Name,
        codec.align(VideoDecoderClient_OnVideoFrameDecoded_Params.encodedSize));
    builder.encodeStruct(VideoDecoderClient_OnVideoFrameDecoded_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  VideoDecoderClientPtr.prototype.onWaiting = function() {
    return VideoDecoderClientProxy.prototype.onWaiting
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoDecoderClientProxy.prototype.onWaiting = function(reason) {
    var params_ = new VideoDecoderClient_OnWaiting_Params();
    params_.reason = reason;
    var builder = new codec.MessageV0Builder(
        kVideoDecoderClient_OnWaiting_Name,
        codec.align(VideoDecoderClient_OnWaiting_Params.encodedSize));
    builder.encodeStruct(VideoDecoderClient_OnWaiting_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  VideoDecoderClientPtr.prototype.requestOverlayInfo = function() {
    return VideoDecoderClientProxy.prototype.requestOverlayInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoDecoderClientProxy.prototype.requestOverlayInfo = function() {
    var params_ = new VideoDecoderClient_RequestOverlayInfo_Params();
    var builder = new codec.MessageV0Builder(
        kVideoDecoderClient_RequestOverlayInfo_Name,
        codec.align(VideoDecoderClient_RequestOverlayInfo_Params.encodedSize));
    builder.encodeStruct(VideoDecoderClient_RequestOverlayInfo_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function VideoDecoderClientStub(delegate) {
    this.delegate_ = delegate;
  }
  VideoDecoderClientStub.prototype.onVideoFrameDecoded = function(frame, canReadWithoutStalling, releaseToken) {
    return this.delegate_ && this.delegate_.onVideoFrameDecoded && this.delegate_.onVideoFrameDecoded(frame, canReadWithoutStalling, releaseToken);
  }
  VideoDecoderClientStub.prototype.onWaiting = function(reason) {
    return this.delegate_ && this.delegate_.onWaiting && this.delegate_.onWaiting(reason);
  }
  VideoDecoderClientStub.prototype.requestOverlayInfo = function() {
    return this.delegate_ && this.delegate_.requestOverlayInfo && this.delegate_.requestOverlayInfo();
  }

  VideoDecoderClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kVideoDecoderClient_OnVideoFrameDecoded_Name:
      var params = reader.decodeStruct(VideoDecoderClient_OnVideoFrameDecoded_Params);
      this.onVideoFrameDecoded(params.frame, params.canReadWithoutStalling, params.releaseToken);
      return true;
    case kVideoDecoderClient_OnWaiting_Name:
      var params = reader.decodeStruct(VideoDecoderClient_OnWaiting_Params);
      this.onWaiting(params.reason);
      return true;
    case kVideoDecoderClient_RequestOverlayInfo_Name:
      var params = reader.decodeStruct(VideoDecoderClient_RequestOverlayInfo_Params);
      this.requestOverlayInfo();
      return true;
    default:
      return false;
    }
  };

  VideoDecoderClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateVideoDecoderClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kVideoDecoderClient_OnVideoFrameDecoded_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoDecoderClient_OnVideoFrameDecoded_Params;
      break;
      case kVideoDecoderClient_OnWaiting_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoDecoderClient_OnWaiting_Params;
      break;
      case kVideoDecoderClient_RequestOverlayInfo_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoDecoderClient_RequestOverlayInfo_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateVideoDecoderClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var VideoDecoderClient = {
    name: 'media.mojom.VideoDecoderClient',
    kVersion: 0,
    ptrClass: VideoDecoderClientPtr,
    proxyClass: VideoDecoderClientProxy,
    stubClass: VideoDecoderClientStub,
    validateRequest: validateVideoDecoderClientRequest,
    validateResponse: null,
  };
  VideoDecoderClientStub.prototype.validator = validateVideoDecoderClientRequest;
  VideoDecoderClientProxy.prototype.validator = null;
  exports.SupportedVideoDecoderConfig = SupportedVideoDecoderConfig;
  exports.CommandBufferId = CommandBufferId;
  exports.OverlayInfo = OverlayInfo;
  exports.Cdm = Cdm;
  exports.VideoFrameHandleReleaser = VideoFrameHandleReleaser;
  exports.VideoFrameHandleReleaserPtr = VideoFrameHandleReleaserPtr;
  exports.VideoFrameHandleReleaserAssociatedPtr = VideoFrameHandleReleaserAssociatedPtr;
  exports.VideoDecoder = VideoDecoder;
  exports.VideoDecoderPtr = VideoDecoderPtr;
  exports.VideoDecoderAssociatedPtr = VideoDecoderAssociatedPtr;
  exports.VideoDecoderClient = VideoDecoderClient;
  exports.VideoDecoderClientPtr = VideoDecoderClientPtr;
  exports.VideoDecoderClientAssociatedPtr = VideoDecoderClientAssociatedPtr;
})();