// media/mojo/mojom/video_decoder_factory_process.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/video_decoder_factory_process.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var gpu_feature_info$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/gpu_feature_info.mojom', '../../../gpu/ipc/common/gpu_feature_info.mojom.js');
  }
  var interface_factory$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/interface_factory.mojom', 'interface_factory.mojom.js');
  }
  var sandbox$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/sandbox.mojom', '../../../sandbox/policy/mojom/sandbox.mojom.js');
  }
  var gpu$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/gpu.mojom', '../../../services/viz/public/mojom/gpu.mojom.js');
  }



  function VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params.prototype.initDefaults_ = function() {
    this.gpuFeatureInfo = null;
    this.receiver = new bindings.InterfaceRequest();
    this.gpuRemote = new gpu$.GpuPtr();
  };
  VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params.gpuFeatureInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, gpu_feature_info$.GpuFeatureInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params.gpuRemote
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params.encodedSize = codec.kStructHeaderSize + 24;

  VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params.decode = function(decoder) {
    var packed;
    var val = new VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.gpuFeatureInfo =
        decoder.decodeStructPointer(gpu_feature_info$.GpuFeatureInfo);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.gpuRemote =
        decoder.decodeStruct(new codec.NullableInterface(gpu$.GpuPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(gpu_feature_info$.GpuFeatureInfo, val.gpuFeatureInfo);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.encodeStruct(new codec.NullableInterface(gpu$.GpuPtr), val.gpuRemote);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kVideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Name = 0;

  function VideoDecoderFactoryProcessPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(VideoDecoderFactoryProcess,
                                                   handleOrPtrInfo);
  }

  function VideoDecoderFactoryProcessAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        VideoDecoderFactoryProcess, associatedInterfacePtrInfo);
  }

  VideoDecoderFactoryProcessAssociatedPtr.prototype =
      Object.create(VideoDecoderFactoryProcessPtr.prototype);
  VideoDecoderFactoryProcessAssociatedPtr.prototype.constructor =
      VideoDecoderFactoryProcessAssociatedPtr;

  function VideoDecoderFactoryProcessProxy(receiver) {
    this.receiver_ = receiver;
  }
  VideoDecoderFactoryProcessPtr.prototype.initializeVideoDecoderFactory = function() {
    return VideoDecoderFactoryProcessProxy.prototype.initializeVideoDecoderFactory
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoDecoderFactoryProcessProxy.prototype.initializeVideoDecoderFactory = function(gpuFeatureInfo, receiver, gpuRemote) {
    var params_ = new VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params();
    params_.gpuFeatureInfo = gpuFeatureInfo;
    params_.receiver = receiver;
    params_.gpuRemote = gpuRemote;
    var builder = new codec.MessageV0Builder(
        kVideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Name,
        codec.align(VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params.encodedSize));
    builder.encodeStruct(VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function VideoDecoderFactoryProcessStub(delegate) {
    this.delegate_ = delegate;
  }
  VideoDecoderFactoryProcessStub.prototype.initializeVideoDecoderFactory = function(gpuFeatureInfo, receiver, gpuRemote) {
    return this.delegate_ && this.delegate_.initializeVideoDecoderFactory && this.delegate_.initializeVideoDecoderFactory(gpuFeatureInfo, receiver, gpuRemote);
  }

  VideoDecoderFactoryProcessStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kVideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Name:
      var params = reader.decodeStruct(VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params);
      this.initializeVideoDecoderFactory(params.gpuFeatureInfo, params.receiver, params.gpuRemote);
      return true;
    default:
      return false;
    }
  };

  VideoDecoderFactoryProcessStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateVideoDecoderFactoryProcessRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kVideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateVideoDecoderFactoryProcessResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var VideoDecoderFactoryProcess = {
    name: 'media.mojom.VideoDecoderFactoryProcess',
    kVersion: 0,
    ptrClass: VideoDecoderFactoryProcessPtr,
    proxyClass: VideoDecoderFactoryProcessProxy,
    stubClass: VideoDecoderFactoryProcessStub,
    validateRequest: validateVideoDecoderFactoryProcessRequest,
    validateResponse: null,
  };
  VideoDecoderFactoryProcessStub.prototype.validator = validateVideoDecoderFactoryProcessRequest;
  VideoDecoderFactoryProcessProxy.prototype.validator = null;
  exports.VideoDecoderFactoryProcess = VideoDecoderFactoryProcess;
  exports.VideoDecoderFactoryProcessPtr = VideoDecoderFactoryProcessPtr;
  exports.VideoDecoderFactoryProcessAssociatedPtr = VideoDecoderFactoryProcessAssociatedPtr;
})();