// media/mojo/mojom/video_decoder_factory_process.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  GpuFeatureInfo as gpu_mojom_GpuFeatureInfo,
  GpuFeatureInfoSpec as gpu_mojom_GpuFeatureInfoSpec
} from '../../../gpu/ipc/common/gpu_feature_info.mojom.m.js';

import {
  GpuRemote as viz_mojom_GpuRemote,
  GpuPendingReceiver as viz_mojom_GpuPendingReceiver
} from '../../../services/viz/public/mojom/gpu.mojom.m.js';

import {
  InterfaceFactoryRemote as media_mojom_InterfaceFactoryRemote,
  InterfaceFactoryPendingReceiver as media_mojom_InterfaceFactoryPendingReceiver
} from './interface_factory.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VideoDecoderFactoryProcessPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.VideoDecoderFactoryProcess', scope);
  }
}

/** @interface */
export class VideoDecoderFactoryProcessInterface {
  
  /**
   * @param { !gpu_mojom_GpuFeatureInfo } gpuFeatureInfo
   * @param { !media_mojom_InterfaceFactoryPendingReceiver } receiver
   * @param { ?viz_mojom_GpuRemote } gpuRemote
   */

  initializeVideoDecoderFactory(gpuFeatureInfo, receiver, gpuRemote) {}
}

/**
 * @implements { VideoDecoderFactoryProcessInterface }
 */
export class VideoDecoderFactoryProcessRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VideoDecoderFactoryProcessPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VideoDecoderFactoryProcessPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VideoDecoderFactoryProcessPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !gpu_mojom_GpuFeatureInfo } gpuFeatureInfo
   * @param { !media_mojom_InterfaceFactoryPendingReceiver } receiver
   * @param { ?viz_mojom_GpuRemote } gpuRemote
   */

  initializeVideoDecoderFactory(
      gpuFeatureInfo,
      receiver,
      gpuRemote) {
    this.proxy.sendMessage(
        0,
        VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_ParamsSpec.$,
        null,
        [
          gpuFeatureInfo,
          receiver,
          gpuRemote
        ],
        false);
  }
}

/**
 * An object which receives request messages for the VideoDecoderFactoryProcess
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VideoDecoderFactoryProcessReceiver {
  /**
   * @param {!VideoDecoderFactoryProcessInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VideoDecoderFactoryProcessRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VideoDecoderFactoryProcessRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoDecoderFactoryProcessRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_ParamsSpec.$,
        null,
        impl.initializeVideoDecoderFactory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VideoDecoderFactoryProcess {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoDecoderFactoryProcess";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VideoDecoderFactoryProcessRemote}
   */
  static getRemote() {
    let remote = new VideoDecoderFactoryProcessRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VideoDecoderFactoryProcess
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VideoDecoderFactoryProcessCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VideoDecoderFactoryProcessRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoDecoderFactoryProcessRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initializeVideoDecoderFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_ParamsSpec.$,
        null,
        this.initializeVideoDecoderFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_ParamsSpec.$,
    'VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params',
    [
      mojo.internal.StructField(
        'gpuFeatureInfo', 0,
        0,
        gpu_mojom_GpuFeatureInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(media_mojom_InterfaceFactoryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'gpuRemote', 12,
        0,
        mojo.internal.InterfaceProxy(viz_mojom_GpuRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class VideoDecoderFactoryProcess_InitializeVideoDecoderFactory_Params {
  constructor() {
    /** @type { !gpu_mojom_GpuFeatureInfo } */
    this.gpuFeatureInfo;
    /** @type { !media_mojom_InterfaceFactoryPendingReceiver } */
    this.receiver;
    /** @type { (viz_mojom_GpuRemote|undefined) } */
    this.gpuRemote;
  }
}

