// media/mojo/mojom/video_encode_accelerator.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.SVCInterLayerPredMode');
goog.require('media.mojom.SVCScalabilityMode');
goog.require('media.mojom.VideoCodecProfile');
goog.require('media.mojom.VideoPixelFormat');
goog.require('media.mojom.MediaLog');
goog.require('gfx.mojom.ColorSpace');
goog.require('media.mojom.EncoderStatus');
goog.require('gfx.mojom.Size');
goog.require('mojoBase.mojom.TimeDelta');
goog.require('mojoBase.mojom.UnguessableToken');
goog.require('mojoBase.mojom.UnsafeSharedMemoryRegion');
goog.require('media.mojom.VideoEncoderInfo');
goog.require('media.mojom.VideoFrame');




goog.provide('media.mojom.VideoEncodeAcceleratorSupportedRateControlMode');
goog.provide('media.mojom.VideoEncodeAcceleratorSupportedRateControlModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoEncodeAcceleratorSupportedRateControlModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.VideoEncodeAcceleratorSupportedRateControlMode = {
  
  kNoMode: 0,
  kConstantMode: 1,
  kVariableMode: 2,
  kExternalMode: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



goog.provide('media.mojom.VideoEncodeAcceleratorProvider');
goog.provide('media.mojom.VideoEncodeAcceleratorProviderReceiver');
goog.provide('media.mojom.VideoEncodeAcceleratorProviderCallbackRouter');
goog.provide('media.mojom.VideoEncodeAcceleratorProviderInterface');
goog.provide('media.mojom.VideoEncodeAcceleratorProviderRemote');
goog.provide('media.mojom.VideoEncodeAcceleratorProviderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.VideoEncodeAcceleratorProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.VideoEncodeAcceleratorProvider.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.VideoEncodeAcceleratorProviderInterface = class {
  
  /**
   * @param { ?media.mojom.EncodeCommandBufferId } commandBufferId
   * @param { !media.mojom.VideoEncodeAcceleratorPendingReceiver } receiver
   */

  createVideoEncodeAccelerator(commandBufferId, receiver) {}
  
  /**
   * @return {!Promise<{
        profiles: !Array<!media.mojom.VideoEncodeAcceleratorSupportedProfile>,
   *  }>}
   */

  getVideoEncodeAcceleratorSupportedProfiles() {}
};

/**
 * @export
 * @implements { media.mojom.VideoEncodeAcceleratorProviderInterface }
 */
media.mojom.VideoEncodeAcceleratorProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.VideoEncodeAcceleratorProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.VideoEncodeAcceleratorProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.VideoEncodeAcceleratorProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?media.mojom.EncodeCommandBufferId } commandBufferId
   * @param { !media.mojom.VideoEncodeAcceleratorPendingReceiver } receiver
   */

  createVideoEncodeAccelerator(
      commandBufferId,
      receiver) {
    this.proxy.sendMessage(
        0,
        media.mojom.VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsSpec.$,
        null,
        [
          commandBufferId,
          receiver
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        profiles: !Array<!media.mojom.VideoEncodeAcceleratorSupportedProfile>,
   *  }>}
   */

  getVideoEncodeAcceleratorSupportedProfiles() {
    return this.proxy.sendMessage(
        1,
        media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsSpec.$,
        media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VideoEncodeAcceleratorProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.VideoEncodeAcceleratorProviderReceiver = class {
  /**
   * @param {!media.mojom.VideoEncodeAcceleratorProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.VideoEncodeAcceleratorProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.VideoEncodeAcceleratorProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoEncodeAcceleratorProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsSpec.$,
        null,
        impl.createVideoEncodeAccelerator.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsSpec.$,
        media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsSpec.$,
        impl.getVideoEncodeAcceleratorSupportedProfiles.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.VideoEncodeAcceleratorProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoEncodeAcceleratorProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.VideoEncodeAcceleratorProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.VideoEncodeAcceleratorProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VideoEncodeAcceleratorProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.VideoEncodeAcceleratorProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.VideoEncodeAcceleratorProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoEncodeAcceleratorProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createVideoEncodeAccelerator =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsSpec.$,
        null,
        this.createVideoEncodeAccelerator.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getVideoEncodeAcceleratorSupportedProfiles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsSpec.$,
        media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsSpec.$,
        this.getVideoEncodeAcceleratorSupportedProfiles.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.VideoEncodeAcceleratorProviderFactory');
goog.provide('media.mojom.VideoEncodeAcceleratorProviderFactoryReceiver');
goog.provide('media.mojom.VideoEncodeAcceleratorProviderFactoryCallbackRouter');
goog.provide('media.mojom.VideoEncodeAcceleratorProviderFactoryInterface');
goog.provide('media.mojom.VideoEncodeAcceleratorProviderFactoryRemote');
goog.provide('media.mojom.VideoEncodeAcceleratorProviderFactoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.VideoEncodeAcceleratorProviderFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.VideoEncodeAcceleratorProviderFactory.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.VideoEncodeAcceleratorProviderFactoryInterface = class {
  
  /**
   * @param { !media.mojom.VideoEncodeAcceleratorProviderPendingReceiver } receiver
   */

  createVideoEncodeAcceleratorProvider(receiver) {}
};

/**
 * @export
 * @implements { media.mojom.VideoEncodeAcceleratorProviderFactoryInterface }
 */
media.mojom.VideoEncodeAcceleratorProviderFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.VideoEncodeAcceleratorProviderFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.VideoEncodeAcceleratorProviderFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.VideoEncodeAcceleratorProviderFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.VideoEncodeAcceleratorProviderPendingReceiver } receiver
   */

  createVideoEncodeAcceleratorProvider(
      receiver) {
    this.proxy.sendMessage(
        0,
        media.mojom.VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VideoEncodeAcceleratorProviderFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.VideoEncodeAcceleratorProviderFactoryReceiver = class {
  /**
   * @param {!media.mojom.VideoEncodeAcceleratorProviderFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.VideoEncodeAcceleratorProviderFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.VideoEncodeAcceleratorProviderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoEncodeAcceleratorProviderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_ParamsSpec.$,
        null,
        impl.createVideoEncodeAcceleratorProvider.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.VideoEncodeAcceleratorProviderFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoEncodeAcceleratorProviderFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.VideoEncodeAcceleratorProviderFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.VideoEncodeAcceleratorProviderFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VideoEncodeAcceleratorProviderFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.VideoEncodeAcceleratorProviderFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.VideoEncodeAcceleratorProviderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoEncodeAcceleratorProviderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createVideoEncodeAcceleratorProvider =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_ParamsSpec.$,
        null,
        this.createVideoEncodeAcceleratorProvider.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.VideoEncodeAccelerator');
goog.provide('media.mojom.VideoEncodeAcceleratorReceiver');
goog.provide('media.mojom.VideoEncodeAcceleratorCallbackRouter');
goog.provide('media.mojom.VideoEncodeAcceleratorInterface');
goog.provide('media.mojom.VideoEncodeAcceleratorRemote');
goog.provide('media.mojom.VideoEncodeAcceleratorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.VideoEncodeAcceleratorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.VideoEncodeAccelerator.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.VideoEncodeAcceleratorInterface = class {
  
  /**
   * @param { !media.mojom.VideoEncodeAcceleratorConfig } config
   * @param { !Object } client
   * @param { !media.mojom.MediaLogRemote } mediaLog
   * @return {!Promise<{
        result: !media.mojom.EncoderStatus,
   *  }>}
   */

  initialize(config, client, mediaLog) {}
  
  /**
   * @param { !media.mojom.VideoFrame } frame
   * @param { !media.mojom.VideoEncodeOptions } options
   * @return {!Promise}
   */

  encode(frame, options) {}
  
  /**
   * @param { !number } bitstreamBufferId
   * @param { !mojoBase.mojom.UnsafeSharedMemoryRegion } region
   */

  useOutputBitstreamBuffer(bitstreamBufferId, region) {}
  
  /**
   * @param { !media.mojom.VideoBitrateAllocation } bitrateAllocation
   * @param { !number } framerate
   * @param { ?gfx.mojom.Size } size
   */

  requestEncodingParametersChangeWithLayers(bitrateAllocation, framerate, size) {}
  
  /**
   * @param { !media.mojom.Bitrate } bitrate
   * @param { !number } framerate
   * @param { ?gfx.mojom.Size } size
   */

  requestEncodingParametersChangeWithBitrate(bitrate, framerate, size) {}
  
  /**
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  isFlushSupported() {}
  
  /**
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  flush() {}
};

/**
 * @export
 * @implements { media.mojom.VideoEncodeAcceleratorInterface }
 */
media.mojom.VideoEncodeAcceleratorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.VideoEncodeAcceleratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.VideoEncodeAcceleratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.VideoEncodeAcceleratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.VideoEncodeAcceleratorConfig } config
   * @param { !Object } client
   * @param { !media.mojom.MediaLogRemote } mediaLog
   * @return {!Promise<{
        result: !media.mojom.EncoderStatus,
   *  }>}
   */

  initialize(
      config,
      client,
      mediaLog) {
    return this.proxy.sendMessage(
        0,
        media.mojom.VideoEncodeAccelerator_Initialize_ParamsSpec.$,
        media.mojom.VideoEncodeAccelerator_Initialize_ResponseParamsSpec.$,
        [
          config,
          client,
          mediaLog
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.VideoFrame } frame
   * @param { !media.mojom.VideoEncodeOptions } options
   * @return {!Promise}
   */

  encode(
      frame,
      options) {
    return this.proxy.sendMessage(
        1,
        media.mojom.VideoEncodeAccelerator_Encode_ParamsSpec.$,
        media.mojom.VideoEncodeAccelerator_Encode_ResponseParamsSpec.$,
        [
          frame,
          options
        ],
        false);
  }

  
  /**
   * @param { !number } bitstreamBufferId
   * @param { !mojoBase.mojom.UnsafeSharedMemoryRegion } region
   */

  useOutputBitstreamBuffer(
      bitstreamBufferId,
      region) {
    this.proxy.sendMessage(
        2,
        media.mojom.VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsSpec.$,
        null,
        [
          bitstreamBufferId,
          region
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.VideoBitrateAllocation } bitrateAllocation
   * @param { !number } framerate
   * @param { ?gfx.mojom.Size } size
   */

  requestEncodingParametersChangeWithLayers(
      bitrateAllocation,
      framerate,
      size) {
    this.proxy.sendMessage(
        3,
        media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsSpec.$,
        null,
        [
          bitrateAllocation,
          framerate,
          size
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.Bitrate } bitrate
   * @param { !number } framerate
   * @param { ?gfx.mojom.Size } size
   */

  requestEncodingParametersChangeWithBitrate(
      bitrate,
      framerate,
      size) {
    this.proxy.sendMessage(
        4,
        media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsSpec.$,
        null,
        [
          bitrate,
          framerate,
          size
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  isFlushSupported() {
    return this.proxy.sendMessage(
        5,
        media.mojom.VideoEncodeAccelerator_IsFlushSupported_ParamsSpec.$,
        media.mojom.VideoEncodeAccelerator_IsFlushSupported_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  flush() {
    return this.proxy.sendMessage(
        6,
        media.mojom.VideoEncodeAccelerator_Flush_ParamsSpec.$,
        media.mojom.VideoEncodeAccelerator_Flush_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VideoEncodeAccelerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.VideoEncodeAcceleratorReceiver = class {
  /**
   * @param {!media.mojom.VideoEncodeAcceleratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.VideoEncodeAcceleratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.VideoEncodeAcceleratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoEncodeAcceleratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoEncodeAccelerator_Initialize_ParamsSpec.$,
        media.mojom.VideoEncodeAccelerator_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoEncodeAccelerator_Encode_ParamsSpec.$,
        media.mojom.VideoEncodeAccelerator_Encode_ResponseParamsSpec.$,
        impl.encode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsSpec.$,
        null,
        impl.useOutputBitstreamBuffer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsSpec.$,
        null,
        impl.requestEncodingParametersChangeWithLayers.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsSpec.$,
        null,
        impl.requestEncodingParametersChangeWithBitrate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.VideoEncodeAccelerator_IsFlushSupported_ParamsSpec.$,
        media.mojom.VideoEncodeAccelerator_IsFlushSupported_ResponseParamsSpec.$,
        impl.isFlushSupported.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        media.mojom.VideoEncodeAccelerator_Flush_ParamsSpec.$,
        media.mojom.VideoEncodeAccelerator_Flush_ResponseParamsSpec.$,
        impl.flush.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.VideoEncodeAccelerator = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoEncodeAccelerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.VideoEncodeAcceleratorRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.VideoEncodeAcceleratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VideoEncodeAccelerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.VideoEncodeAcceleratorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.VideoEncodeAcceleratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoEncodeAcceleratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoEncodeAccelerator_Initialize_ParamsSpec.$,
        media.mojom.VideoEncodeAccelerator_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.encode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoEncodeAccelerator_Encode_ParamsSpec.$,
        media.mojom.VideoEncodeAccelerator_Encode_ResponseParamsSpec.$,
        this.encode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.useOutputBitstreamBuffer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsSpec.$,
        null,
        this.useOutputBitstreamBuffer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestEncodingParametersChangeWithLayers =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsSpec.$,
        null,
        this.requestEncodingParametersChangeWithLayers.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestEncodingParametersChangeWithBitrate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsSpec.$,
        null,
        this.requestEncodingParametersChangeWithBitrate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isFlushSupported =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.VideoEncodeAccelerator_IsFlushSupported_ParamsSpec.$,
        media.mojom.VideoEncodeAccelerator_IsFlushSupported_ResponseParamsSpec.$,
        this.isFlushSupported.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        media.mojom.VideoEncodeAccelerator_Flush_ParamsSpec.$,
        media.mojom.VideoEncodeAccelerator_Flush_ResponseParamsSpec.$,
        this.flush.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.VideoEncodeAcceleratorClient');
goog.provide('media.mojom.VideoEncodeAcceleratorClientReceiver');
goog.provide('media.mojom.VideoEncodeAcceleratorClientCallbackRouter');
goog.provide('media.mojom.VideoEncodeAcceleratorClientInterface');
goog.provide('media.mojom.VideoEncodeAcceleratorClientRemote');
goog.provide('media.mojom.VideoEncodeAcceleratorClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.VideoEncodeAcceleratorClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.VideoEncodeAcceleratorClient.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.VideoEncodeAcceleratorClientInterface = class {
  
  /**
   * @param { !number } inputCount
   * @param { !gfx.mojom.Size } inputCodedSize
   * @param { !number } outputBufferSize
   */

  requireBitstreamBuffers(inputCount, inputCodedSize, outputBufferSize) {}
  
  /**
   * @param { !number } bitstreamBufferId
   * @param { !media.mojom.BitstreamBufferMetadata } metadata
   */

  bitstreamBufferReady(bitstreamBufferId, metadata) {}
  
  /**
   * @param { !media.mojom.EncoderStatus } status
   */

  notifyErrorStatus(status) {}
  
  /**
   * @param { !media.mojom.VideoEncoderInfo } info
   */

  notifyEncoderInfoChange(info) {}
};

/**
 * @export
 * @implements { media.mojom.VideoEncodeAcceleratorClientInterface }
 */
media.mojom.VideoEncodeAcceleratorClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.VideoEncodeAcceleratorClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.VideoEncodeAcceleratorClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.VideoEncodeAcceleratorClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } inputCount
   * @param { !gfx.mojom.Size } inputCodedSize
   * @param { !number } outputBufferSize
   */

  requireBitstreamBuffers(
      inputCount,
      inputCodedSize,
      outputBufferSize) {
    this.proxy.sendMessage(
        0,
        media.mojom.VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsSpec.$,
        null,
        [
          inputCount,
          inputCodedSize,
          outputBufferSize
        ],
        false);
  }

  
  /**
   * @param { !number } bitstreamBufferId
   * @param { !media.mojom.BitstreamBufferMetadata } metadata
   */

  bitstreamBufferReady(
      bitstreamBufferId,
      metadata) {
    this.proxy.sendMessage(
        1,
        media.mojom.VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsSpec.$,
        null,
        [
          bitstreamBufferId,
          metadata
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.EncoderStatus } status
   */

  notifyErrorStatus(
      status) {
    this.proxy.sendMessage(
        2,
        media.mojom.VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.VideoEncoderInfo } info
   */

  notifyEncoderInfoChange(
      info) {
    this.proxy.sendMessage(
        3,
        media.mojom.VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VideoEncodeAcceleratorClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.VideoEncodeAcceleratorClientReceiver = class {
  /**
   * @param {!media.mojom.VideoEncodeAcceleratorClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.VideoEncodeAcceleratorClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.VideoEncodeAcceleratorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoEncodeAcceleratorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsSpec.$,
        null,
        impl.requireBitstreamBuffers.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsSpec.$,
        null,
        impl.bitstreamBufferReady.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsSpec.$,
        null,
        impl.notifyErrorStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsSpec.$,
        null,
        impl.notifyEncoderInfoChange.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.VideoEncodeAcceleratorClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoEncodeAcceleratorClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.VideoEncodeAcceleratorClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.VideoEncodeAcceleratorClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VideoEncodeAcceleratorClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.VideoEncodeAcceleratorClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.VideoEncodeAcceleratorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoEncodeAcceleratorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requireBitstreamBuffers =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsSpec.$,
        null,
        this.requireBitstreamBuffers.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bitstreamBufferReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsSpec.$,
        null,
        this.bitstreamBufferReady.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyErrorStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsSpec.$,
        null,
        this.notifyErrorStatus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyEncoderInfoChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsSpec.$,
        null,
        this.notifyEncoderInfoChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.VideoEncodeAcceleratorSupportedProfileSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAcceleratorSupportedProfileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.EncodeCommandBufferIdSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.EncodeCommandBufferIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VariableBitratePeakSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VariableBitratePeakSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoBitrateAllocationSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoBitrateAllocationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpatialLayerSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpatialLayerSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ConstantBitrateSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ConstantBitrateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VariableBitrateSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VariableBitrateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ExternalBitrateSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ExternalBitrateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAcceleratorConfigSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAcceleratorConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.DropFrameMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.DropFrameMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.H264MetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.H264MetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Vp8MetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Vp8MetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Vp9MetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Vp9MetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SVCGenericMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SVCGenericMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.BitstreamBufferMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.BitstreamBufferMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAccelerator_Initialize_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAccelerator_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAccelerator_Initialize_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAccelerator_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAccelerator_Encode_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAccelerator_Encode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAccelerator_Encode_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAccelerator_Encode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAccelerator_IsFlushSupported_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAccelerator_IsFlushSupported_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAccelerator_IsFlushSupported_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAccelerator_IsFlushSupported_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAccelerator_Flush_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAccelerator_Flush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAccelerator_Flush_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAccelerator_Flush_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.BitrateSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
media.mojom.BitrateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.OptionalMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
media.mojom.OptionalMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.VideoEncodeAcceleratorSupportedProfileSpec.$,
    'VideoEncodeAcceleratorSupportedProfile',
    [
      mojo.internal.StructField(
        'profile', 0,
        0,
        media.mojom.VideoCodecProfileSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'minResolution', 8,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxResolution', 16,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxFramerateNumerator', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxFramerateDenominator', 24,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rateControlModes', 32,
        0,
        mojo.internal.Array(media.mojom.VideoEncodeAcceleratorSupportedRateControlModeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scalabilityModes', 40,
        0,
        mojo.internal.Array(media.mojom.SVCScalabilityModeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isSoftwareCodec', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'gpuSupportedPixelFormats', 48,
        0,
        mojo.internal.Array(media.mojom.VideoPixelFormatSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'supportsGpuSharedImages', 28,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('media.mojom.VideoEncodeAcceleratorSupportedProfile');

/** @record */
media.mojom.VideoEncodeAcceleratorSupportedProfile = class {
  constructor() {
    /** @export { !media.mojom.VideoCodecProfile } */
    this.profile;
    /** @export { !gfx.mojom.Size } */
    this.minResolution;
    /** @export { !gfx.mojom.Size } */
    this.maxResolution;
    /** @export { !number } */
    this.maxFramerateNumerator;
    /** @export { !number } */
    this.maxFramerateDenominator;
    /** @export { !Array<!media.mojom.VideoEncodeAcceleratorSupportedRateControlMode> } */
    this.rateControlModes;
    /** @export { !Array<!media.mojom.SVCScalabilityMode> } */
    this.scalabilityModes;
    /** @export { !boolean } */
    this.isSoftwareCodec;
    /** @export { !Array<!media.mojom.VideoPixelFormat> } */
    this.gpuSupportedPixelFormats;
    /** @export { !boolean } */
    this.supportsGpuSharedImages;
  }
};



mojo.internal.Struct(
    media.mojom.EncodeCommandBufferIdSpec.$,
    'EncodeCommandBufferId',
    [
      mojo.internal.StructField(
        'channelToken', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'routeId', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.EncodeCommandBufferId');

/** @record */
media.mojom.EncodeCommandBufferId = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.channelToken;
    /** @export { !number } */
    this.routeId;
  }
};



mojo.internal.Struct(
    media.mojom.VariableBitratePeakSpec.$,
    'VariableBitratePeak',
    [
      mojo.internal.StructField(
        'bps', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VariableBitratePeak');

/** @record */
media.mojom.VariableBitratePeak = class {
  constructor() {
    /** @export { !number } */
    this.bps;
  }
};



mojo.internal.Struct(
    media.mojom.VideoBitrateAllocationSpec.$,
    'VideoBitrateAllocation',
    [
      mojo.internal.StructField(
        'bitrates', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'variableBitratePeak', 8,
        0,
        media.mojom.VariableBitratePeakSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoBitrateAllocation');

/** @record */
media.mojom.VideoBitrateAllocation = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.bitrates;
    /** @export { (media.mojom.VariableBitratePeak|undefined) } */
    this.variableBitratePeak;
  }
};



mojo.internal.Struct(
    media.mojom.SpatialLayerSpec.$,
    'SpatialLayer',
    [
      mojo.internal.StructField(
        'width', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'height', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bitrateBps', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'framerate', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxQp', 16,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numOfTemporalLayers', 17,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.SpatialLayer');

/** @record */
media.mojom.SpatialLayer = class {
  constructor() {
    /** @export { !number } */
    this.width;
    /** @export { !number } */
    this.height;
    /** @export { !number } */
    this.bitrateBps;
    /** @export { !number } */
    this.framerate;
    /** @export { !number } */
    this.maxQp;
    /** @export { !number } */
    this.numOfTemporalLayers;
  }
};



mojo.internal.Struct(
    media.mojom.ConstantBitrateSpec.$,
    'ConstantBitrate',
    [
      mojo.internal.StructField(
        'targetBps', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.ConstantBitrate');

/** @record */
media.mojom.ConstantBitrate = class {
  constructor() {
    /** @export { !number } */
    this.targetBps;
  }
};



mojo.internal.Struct(
    media.mojom.VariableBitrateSpec.$,
    'VariableBitrate',
    [
      mojo.internal.StructField(
        'targetBps', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'peakBps', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VariableBitrate');

/** @record */
media.mojom.VariableBitrate = class {
  constructor() {
    /** @export { !number } */
    this.targetBps;
    /** @export { !number } */
    this.peakBps;
  }
};



mojo.internal.Struct(
    media.mojom.ExternalBitrateSpec.$,
    'ExternalBitrate',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.ExternalBitrate');

/** @record */
media.mojom.ExternalBitrate = class {
  constructor() {
  }
};


goog.provide('media.mojom.VideoEncodeAcceleratorConfig_ContentType');
goog.provide('media.mojom.VideoEncodeAcceleratorConfigSpec.ContentTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoEncodeAcceleratorConfigSpec.ContentTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.VideoEncodeAcceleratorConfig_ContentType = {
  
  kCamera: 0,
  kDisplay: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('media.mojom.VideoEncodeAcceleratorConfig_StorageType');
goog.provide('media.mojom.VideoEncodeAcceleratorConfigSpec.StorageTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoEncodeAcceleratorConfigSpec.StorageTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.VideoEncodeAcceleratorConfig_StorageType = {
  
  kShmem: 0,
  kGpuMemoryBuffer: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('media.mojom.VideoEncodeAcceleratorConfig_EncoderType');
goog.provide('media.mojom.VideoEncodeAcceleratorConfigSpec.EncoderTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoEncodeAcceleratorConfigSpec.EncoderTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.VideoEncodeAcceleratorConfig_EncoderType = {
  
  kHardware: 0,
  kSoftware: 1,
  kNoPreference: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


mojo.internal.Struct(
    media.mojom.VideoEncodeAcceleratorConfigSpec.$,
    'VideoEncodeAcceleratorConfig',
    [
      mojo.internal.StructField(
        'inputFormat', 0,
        0,
        media.mojom.VideoPixelFormatSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputVisibleSize', 8,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputProfile', 4,
        0,
        media.mojom.VideoCodecProfileSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bitrate', 16,
        0,
        media.mojom.BitrateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'framerate', 32,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageType', 36,
        0,
        media.mojom.VideoEncodeAcceleratorConfigSpec.StorageTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contentType', 40,
        0,
        media.mojom.VideoEncodeAcceleratorConfigSpec.ContentTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'gopLength', 44,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasGopLength', 48,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'h264OutputLevel', 49,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasH264OutputLevel', 48,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isConstrainedH264', 48,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dropFrameThreshPercentage', 50,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'spatialLayers', 56,
        0,
        mojo.internal.Array(media.mojom.SpatialLayerSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'interLayerPred', 52,
        0,
        media.mojom.SVCInterLayerPredModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requireLowDelay', 48,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requiredEncoderType', 64,
        0,
        media.mojom.VideoEncodeAcceleratorConfigSpec.EncoderTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'manualReferenceBufferControl', 48,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);



goog.provide('media.mojom.VideoEncodeAcceleratorConfig');

/** @record */
media.mojom.VideoEncodeAcceleratorConfig = class {
  constructor() {
    /** @export { !media.mojom.VideoPixelFormat } */
    this.inputFormat;
    /** @export { !gfx.mojom.Size } */
    this.inputVisibleSize;
    /** @export { !media.mojom.VideoCodecProfile } */
    this.outputProfile;
    /** @export { !media.mojom.Bitrate } */
    this.bitrate;
    /** @export { !number } */
    this.framerate;
    /** @export { !media.mojom.VideoEncodeAcceleratorConfig_StorageType } */
    this.storageType;
    /** @export { !media.mojom.VideoEncodeAcceleratorConfig_ContentType } */
    this.contentType;
    /** @export { !number } */
    this.gopLength;
    /** @export { !boolean } */
    this.hasGopLength;
    /** @export { !number } */
    this.h264OutputLevel;
    /** @export { !boolean } */
    this.hasH264OutputLevel;
    /** @export { !boolean } */
    this.isConstrainedH264;
    /** @export { !number } */
    this.dropFrameThreshPercentage;
    /** @export { !Array<!media.mojom.SpatialLayer> } */
    this.spatialLayers;
    /** @export { !media.mojom.SVCInterLayerPredMode } */
    this.interLayerPred;
    /** @export { !boolean } */
    this.requireLowDelay;
    /** @export { !media.mojom.VideoEncodeAcceleratorConfig_EncoderType } */
    this.requiredEncoderType;
    /** @export { !boolean } */
    this.manualReferenceBufferControl;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeOptionsSpec.$,
    'VideoEncodeOptions',
    [
      mojo.internal.StructField(
        'forceKeyframe', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'quantizer', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'update_buffer_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "update_buffer_$value",
          originalFieldName: "updateBuffer",
        }
      ),
      mojo.internal.StructField(
        'update_buffer_$value', 1,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "updateBuffer",
        }
      ),
      mojo.internal.StructField(
        'referenceBuffers', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoEncodeOptions');

/** @record */
media.mojom.VideoEncodeOptions = class {
  constructor() {
    /** @export { !boolean } */
    this.forceKeyframe;
    /** @export { !number } */
    this.quantizer;
    /** @export { (number|undefined) } */
    this.updateBuffer;
    /** @export { !Array<!number> } */
    this.referenceBuffers;
  }
};



mojo.internal.Struct(
    media.mojom.DropFrameMetadataSpec.$,
    'DropFrameMetadata',
    [
      mojo.internal.StructField(
        'spatialIdx', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endOfPicture', 1,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.DropFrameMetadata');

/** @record */
media.mojom.DropFrameMetadata = class {
  constructor() {
    /** @export { !number } */
    this.spatialIdx;
    /** @export { !boolean } */
    this.endOfPicture;
  }
};



mojo.internal.Struct(
    media.mojom.H264MetadataSpec.$,
    'H264Metadata',
    [
      mojo.internal.StructField(
        'temporalIdx', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'layerSync', 1,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.H264Metadata');

/** @record */
media.mojom.H264Metadata = class {
  constructor() {
    /** @export { !number } */
    this.temporalIdx;
    /** @export { !boolean } */
    this.layerSync;
  }
};



mojo.internal.Struct(
    media.mojom.Vp8MetadataSpec.$,
    'Vp8Metadata',
    [
      mojo.internal.StructField(
        'nonReference', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'temporalIdx', 1,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'layerSync', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.Vp8Metadata');

/** @record */
media.mojom.Vp8Metadata = class {
  constructor() {
    /** @export { !boolean } */
    this.nonReference;
    /** @export { !number } */
    this.temporalIdx;
    /** @export { !boolean } */
    this.layerSync;
  }
};



mojo.internal.Struct(
    media.mojom.Vp9MetadataSpec.$,
    'Vp9Metadata',
    [
      mojo.internal.StructField(
        'interPicPredicted', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'temporalUpSwitch', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referencedByUpperSpatialLayers', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referenceLowerSpatialLayers', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endOfPicture', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'temporalIdx', 1,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'spatialIdx', 2,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'spatialLayerResolutions', 8,
        0,
        mojo.internal.Array(gfx.mojom.SizeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'beginActiveSpatialLayerIndex', 3,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endActiveSpatialLayerIndex', 4,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pDiffs', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.Vp9Metadata');

/** @record */
media.mojom.Vp9Metadata = class {
  constructor() {
    /** @export { !boolean } */
    this.interPicPredicted;
    /** @export { !boolean } */
    this.temporalUpSwitch;
    /** @export { !boolean } */
    this.referencedByUpperSpatialLayers;
    /** @export { !boolean } */
    this.referenceLowerSpatialLayers;
    /** @export { !boolean } */
    this.endOfPicture;
    /** @export { !number } */
    this.temporalIdx;
    /** @export { !number } */
    this.spatialIdx;
    /** @export { !Array<!gfx.mojom.Size> } */
    this.spatialLayerResolutions;
    /** @export { !number } */
    this.beginActiveSpatialLayerIndex;
    /** @export { !number } */
    this.endActiveSpatialLayerIndex;
    /** @export { !Array<!number> } */
    this.pDiffs;
  }
};



mojo.internal.Struct(
    media.mojom.SVCGenericMetadataSpec.$,
    'SVCGenericMetadata',
    [
      mojo.internal.StructField(
        'followSvcSpec', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'temporalIdx', 1,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'spatialIdx', 2,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reference_flags_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "reference_flags_$value",
          originalFieldName: "referenceFlags",
        }
      ),
      mojo.internal.StructField(
        'reference_flags_$value', 4,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "referenceFlags",
        }
      ),
      mojo.internal.StructField(
        'refresh_flags_$flag', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "refresh_flags_$value",
          originalFieldName: "refreshFlags",
        }
      ),
      mojo.internal.StructField(
        'refresh_flags_$value', 6,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "refreshFlags",
        }
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SVCGenericMetadata');

/** @record */
media.mojom.SVCGenericMetadata = class {
  constructor() {
    /** @export { !boolean } */
    this.followSvcSpec;
    /** @export { !number } */
    this.temporalIdx;
    /** @export { !number } */
    this.spatialIdx;
    /** @export { (number|undefined) } */
    this.referenceFlags;
    /** @export { (number|undefined) } */
    this.refreshFlags;
  }
};



mojo.internal.Struct(
    media.mojom.BitstreamBufferMetadataSpec.$,
    'BitstreamBufferMetadata',
    [
      mojo.internal.StructField(
        'payloadSizeBytes', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyFrame', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timestamp', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'qp', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'optionalMetadata', 24,
        0,
        media.mojom.OptionalMetadataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'svcGeneric', 40,
        0,
        media.mojom.SVCGenericMetadataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'encodedSize', 48,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'encodedColorSpace', 56,
        0,
        gfx.mojom.ColorSpaceSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 72],]);



goog.provide('media.mojom.BitstreamBufferMetadata');

/** @record */
media.mojom.BitstreamBufferMetadata = class {
  constructor() {
    /** @export { !number } */
    this.payloadSizeBytes;
    /** @export { !boolean } */
    this.keyFrame;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.timestamp;
    /** @export { !number } */
    this.qp;
    /** @export { (media.mojom.OptionalMetadata|undefined) } */
    this.optionalMetadata;
    /** @export { (media.mojom.SVCGenericMetadata|undefined) } */
    this.svcGeneric;
    /** @export { (gfx.mojom.Size|undefined) } */
    this.encodedSize;
    /** @export { (gfx.mojom.ColorSpace|undefined) } */
    this.encodedColorSpace;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsSpec.$,
    'VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params',
    [
      mojo.internal.StructField(
        'commandBufferId', 0,
        0,
        media.mojom.EncodeCommandBufferIdSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(media.mojom.VideoEncodeAcceleratorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params');

/** @record */
media.mojom.VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params = class {
  constructor() {
    /** @export { (media.mojom.EncodeCommandBufferId|undefined) } */
    this.commandBufferId;
    /** @export { !media.mojom.VideoEncodeAcceleratorPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsSpec.$,
    'VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params');

/** @record */
media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsSpec.$,
    'VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams',
    [
      mojo.internal.StructField(
        'profiles', 0,
        0,
        mojo.internal.Array(media.mojom.VideoEncodeAcceleratorSupportedProfileSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams');

/** @record */
media.mojom.VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams = class {
  constructor() {
    /** @export { !Array<!media.mojom.VideoEncodeAcceleratorSupportedProfile> } */
    this.profiles;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_ParamsSpec.$,
    'VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.VideoEncodeAcceleratorProviderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params');

/** @record */
media.mojom.VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoEncodeAcceleratorProviderPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAccelerator_Initialize_ParamsSpec.$,
    'VideoEncodeAccelerator_Initialize_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        media.mojom.VideoEncodeAcceleratorConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(media.mojom.VideoEncodeAcceleratorClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mediaLog', 16,
        0,
        mojo.internal.InterfaceProxy(media.mojom.MediaLogRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.VideoEncodeAccelerator_Initialize_Params');

/** @record */
media.mojom.VideoEncodeAccelerator_Initialize_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoEncodeAcceleratorConfig } */
    this.config;
    /** @export { !Object } */
    this.client;
    /** @export { !media.mojom.MediaLogRemote } */
    this.mediaLog;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAccelerator_Initialize_ResponseParamsSpec.$,
    'VideoEncodeAccelerator_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        media.mojom.EncoderStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoEncodeAccelerator_Initialize_ResponseParams');

/** @record */
media.mojom.VideoEncodeAccelerator_Initialize_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.EncoderStatus } */
    this.result;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAccelerator_Encode_ParamsSpec.$,
    'VideoEncodeAccelerator_Encode_Params',
    [
      mojo.internal.StructField(
        'frame', 0,
        0,
        media.mojom.VideoFrameSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        media.mojom.VideoEncodeOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoEncodeAccelerator_Encode_Params');

/** @record */
media.mojom.VideoEncodeAccelerator_Encode_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoFrame } */
    this.frame;
    /** @export { !media.mojom.VideoEncodeOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAccelerator_Encode_ResponseParamsSpec.$,
    'VideoEncodeAccelerator_Encode_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.VideoEncodeAccelerator_Encode_ResponseParams');

/** @record */
media.mojom.VideoEncodeAccelerator_Encode_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsSpec.$,
    'VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params',
    [
      mojo.internal.StructField(
        'bitstreamBufferId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'region', 8,
        0,
        mojoBase.mojom.UnsafeSharedMemoryRegionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params');

/** @record */
media.mojom.VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params = class {
  constructor() {
    /** @export { !number } */
    this.bitstreamBufferId;
    /** @export { !mojoBase.mojom.UnsafeSharedMemoryRegion } */
    this.region;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsSpec.$,
    'VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params',
    [
      mojo.internal.StructField(
        'bitrateAllocation', 0,
        0,
        media.mojom.VideoBitrateAllocationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'framerate', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'size', 16,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params');

/** @record */
media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoBitrateAllocation } */
    this.bitrateAllocation;
    /** @export { !number } */
    this.framerate;
    /** @export { (gfx.mojom.Size|undefined) } */
    this.size;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsSpec.$,
    'VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params',
    [
      mojo.internal.StructField(
        'bitrate', 0,
        0,
        media.mojom.BitrateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'framerate', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'size', 24,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params');

/** @record */
media.mojom.VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params = class {
  constructor() {
    /** @export { !media.mojom.Bitrate } */
    this.bitrate;
    /** @export { !number } */
    this.framerate;
    /** @export { (gfx.mojom.Size|undefined) } */
    this.size;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAccelerator_IsFlushSupported_ParamsSpec.$,
    'VideoEncodeAccelerator_IsFlushSupported_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.VideoEncodeAccelerator_IsFlushSupported_Params');

/** @record */
media.mojom.VideoEncodeAccelerator_IsFlushSupported_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAccelerator_IsFlushSupported_ResponseParamsSpec.$,
    'VideoEncodeAccelerator_IsFlushSupported_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoEncodeAccelerator_IsFlushSupported_ResponseParams');

/** @record */
media.mojom.VideoEncodeAccelerator_IsFlushSupported_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAccelerator_Flush_ParamsSpec.$,
    'VideoEncodeAccelerator_Flush_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.VideoEncodeAccelerator_Flush_Params');

/** @record */
media.mojom.VideoEncodeAccelerator_Flush_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAccelerator_Flush_ResponseParamsSpec.$,
    'VideoEncodeAccelerator_Flush_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoEncodeAccelerator_Flush_ResponseParams');

/** @record */
media.mojom.VideoEncodeAccelerator_Flush_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsSpec.$,
    'VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params',
    [
      mojo.internal.StructField(
        'inputCount', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputCodedSize', 8,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputBufferSize', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params');

/** @record */
media.mojom.VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params = class {
  constructor() {
    /** @export { !number } */
    this.inputCount;
    /** @export { !gfx.mojom.Size } */
    this.inputCodedSize;
    /** @export { !number } */
    this.outputBufferSize;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsSpec.$,
    'VideoEncodeAcceleratorClient_BitstreamBufferReady_Params',
    [
      mojo.internal.StructField(
        'bitstreamBufferId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metadata', 8,
        0,
        media.mojom.BitstreamBufferMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoEncodeAcceleratorClient_BitstreamBufferReady_Params');

/** @record */
media.mojom.VideoEncodeAcceleratorClient_BitstreamBufferReady_Params = class {
  constructor() {
    /** @export { !number } */
    this.bitstreamBufferId;
    /** @export { !media.mojom.BitstreamBufferMetadata } */
    this.metadata;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsSpec.$,
    'VideoEncodeAcceleratorClient_NotifyErrorStatus_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.EncoderStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoEncodeAcceleratorClient_NotifyErrorStatus_Params');

/** @record */
media.mojom.VideoEncodeAcceleratorClient_NotifyErrorStatus_Params = class {
  constructor() {
    /** @export { !media.mojom.EncoderStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsSpec.$,
    'VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        media.mojom.VideoEncoderInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params');

/** @record */
media.mojom.VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoEncoderInfo } */
    this.info;
  }
};

goog.provide('media.mojom.Bitrate');


mojo.internal.Union(
    media.mojom.BitrateSpec.$, 'Bitrate',
    {
      'constant': {
        'ordinal': 0,
        'type': media.mojom.ConstantBitrateSpec.$,
      },
      'variable': {
        'ordinal': 1,
        'type': media.mojom.VariableBitrateSpec.$,
      },
      'external': {
        'ordinal': 2,
        'type': media.mojom.ExternalBitrateSpec.$,
      },
    });

/**
 * @typedef { {
 *   constant: (!media.mojom.ConstantBitrate|undefined),
 *   variable: (!media.mojom.VariableBitrate|undefined),
 *   external: (!media.mojom.ExternalBitrate|undefined),
 * } }
 */
media.mojom.Bitrate;
goog.provide('media.mojom.OptionalMetadata');


mojo.internal.Union(
    media.mojom.OptionalMetadataSpec.$, 'OptionalMetadata',
    {
      'drop': {
        'ordinal': 0,
        'type': media.mojom.DropFrameMetadataSpec.$,
      },
      'h264': {
        'ordinal': 1,
        'type': media.mojom.H264MetadataSpec.$,
      },
      'vp8': {
        'ordinal': 2,
        'type': media.mojom.Vp8MetadataSpec.$,
      },
      'vp9': {
        'ordinal': 3,
        'type': media.mojom.Vp9MetadataSpec.$,
      },
    });

/**
 * @typedef { {
 *   drop: (!media.mojom.DropFrameMetadata|undefined),
 *   h264: (!media.mojom.H264Metadata|undefined),
 *   vp8: (!media.mojom.Vp8Metadata|undefined),
 *   vp9: (!media.mojom.Vp9Metadata|undefined),
 * } }
 */
media.mojom.OptionalMetadata;
