// media/mojo/mojom/video_encode_accelerator.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/video_encode_accelerator.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var media_log$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_log.mojom', 'media_log.mojom.js');
  }
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', 'media_types.mojom.js');
  }
  var video_encoder_info$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/video_encoder_info.mojom', 'video_encoder_info.mojom.js');
  }
  var shared_memory$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/shared_memory.mojom', '../../../mojo/public/mojom/base/shared_memory.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../mojo/public/mojom/base/time.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var sandbox$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/sandbox.mojom', '../../../sandbox/policy/mojom/sandbox.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var color_space$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/color_space.mojom', '../../../ui/gfx/mojom/color_space.mojom.js');
  }


  var VideoEncodeAcceleratorSupportedRateControlMode = {};
  VideoEncodeAcceleratorSupportedRateControlMode.kNoMode = 0;
  VideoEncodeAcceleratorSupportedRateControlMode.kConstantMode = 1;
  VideoEncodeAcceleratorSupportedRateControlMode.kVariableMode = 2;
  VideoEncodeAcceleratorSupportedRateControlMode.kExternalMode = 3;
  VideoEncodeAcceleratorSupportedRateControlMode.MIN_VALUE = 0;
  VideoEncodeAcceleratorSupportedRateControlMode.MAX_VALUE = 3;

  VideoEncodeAcceleratorSupportedRateControlMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  VideoEncodeAcceleratorSupportedRateControlMode.toKnownEnumValue = function(value) {
    return value;
  };

  VideoEncodeAcceleratorSupportedRateControlMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function VideoEncodeAcceleratorSupportedProfile(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAcceleratorSupportedProfile.prototype.initDefaults_ = function() {
    this.profile = 0;
    this.maxFramerateNumerator = 0;
    this.minResolution = null;
    this.maxResolution = null;
    this.maxFramerateDenominator = 0;
    this.isSoftwareCodec = false;
    this.supportsGpuSharedImages = false;
    this.rateControlModes = null;
    this.scalabilityModes = null;
    this.gpuSupportedPixelFormats = null;
  };
  VideoEncodeAcceleratorSupportedProfile.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAcceleratorSupportedProfile.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorSupportedProfile.profile
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, media_types$.VideoCodecProfile);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorSupportedProfile.minResolution
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorSupportedProfile.maxResolution
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate VideoEncodeAcceleratorSupportedProfile.rateControlModes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 4, new codec.Enum(VideoEncodeAcceleratorSupportedRateControlMode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorSupportedProfile.scalabilityModes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 4, new codec.Enum(media_types$.SVCScalabilityMode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoEncodeAcceleratorSupportedProfile.gpuSupportedPixelFormats
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 4, new codec.Enum(media_types$.VideoPixelFormat), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VideoEncodeAcceleratorSupportedProfile.encodedSize = codec.kStructHeaderSize + 56;

  VideoEncodeAcceleratorSupportedProfile.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAcceleratorSupportedProfile();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.profile =
        decoder.decodeStruct(new codec.Enum(media_types$.VideoCodecProfile));
    val.maxFramerateNumerator =
        decoder.decodeStruct(codec.Uint32);
    val.minResolution =
        decoder.decodeStructPointer(geometry$.Size);
    val.maxResolution =
        decoder.decodeStructPointer(geometry$.Size);
    val.maxFramerateDenominator =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.isSoftwareCodec = (packed >> 0) & 1 ? true : false;
    val.supportsGpuSharedImages = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.rateControlModes =
        decoder.decodeArrayPointer(new codec.Enum(VideoEncodeAcceleratorSupportedRateControlMode));
    val.scalabilityModes =
        decoder.decodeArrayPointer(new codec.Enum(media_types$.SVCScalabilityMode));
    val.gpuSupportedPixelFormats =
        decoder.decodeArrayPointer(new codec.Enum(media_types$.VideoPixelFormat));
    return val;
  };

  VideoEncodeAcceleratorSupportedProfile.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAcceleratorSupportedProfile.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.profile);
    encoder.encodeStruct(codec.Uint32, val.maxFramerateNumerator);
    encoder.encodeStructPointer(geometry$.Size, val.minResolution);
    encoder.encodeStructPointer(geometry$.Size, val.maxResolution);
    encoder.encodeStruct(codec.Uint32, val.maxFramerateDenominator);
    packed = 0;
    packed |= (val.isSoftwareCodec & 1) << 0
    packed |= (val.supportsGpuSharedImages & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.Enum(VideoEncodeAcceleratorSupportedRateControlMode), val.rateControlModes);
    encoder.encodeArrayPointer(new codec.Enum(media_types$.SVCScalabilityMode), val.scalabilityModes);
    encoder.encodeArrayPointer(new codec.Enum(media_types$.VideoPixelFormat), val.gpuSupportedPixelFormats);
  };
  function EncodeCommandBufferId(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EncodeCommandBufferId.prototype.initDefaults_ = function() {
    this.channelToken = null;
    this.routeId = 0;
  };
  EncodeCommandBufferId.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EncodeCommandBufferId.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EncodeCommandBufferId.channelToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  EncodeCommandBufferId.encodedSize = codec.kStructHeaderSize + 16;

  EncodeCommandBufferId.decode = function(decoder) {
    var packed;
    var val = new EncodeCommandBufferId();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.channelToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.routeId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  EncodeCommandBufferId.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EncodeCommandBufferId.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.channelToken);
    encoder.encodeStruct(codec.Int32, val.routeId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VariableBitratePeak(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VariableBitratePeak.prototype.initDefaults_ = function() {
    this.bps = 0;
  };
  VariableBitratePeak.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VariableBitratePeak.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VariableBitratePeak.encodedSize = codec.kStructHeaderSize + 8;

  VariableBitratePeak.decode = function(decoder) {
    var packed;
    var val = new VariableBitratePeak();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bps =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VariableBitratePeak.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VariableBitratePeak.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.bps);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoBitrateAllocation(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoBitrateAllocation.prototype.initDefaults_ = function() {
    this.bitrates = null;
    this.variableBitratePeak = null;
  };
  VideoBitrateAllocation.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoBitrateAllocation.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoBitrateAllocation.bitrates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoBitrateAllocation.variableBitratePeak
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, VariableBitratePeak, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoBitrateAllocation.encodedSize = codec.kStructHeaderSize + 16;

  VideoBitrateAllocation.decode = function(decoder) {
    var packed;
    var val = new VideoBitrateAllocation();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bitrates =
        decoder.decodeArrayPointer(codec.Uint32);
    val.variableBitratePeak =
        decoder.decodeStructPointer(VariableBitratePeak);
    return val;
  };

  VideoBitrateAllocation.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoBitrateAllocation.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint32, val.bitrates);
    encoder.encodeStructPointer(VariableBitratePeak, val.variableBitratePeak);
  };
  function SpatialLayer(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpatialLayer.prototype.initDefaults_ = function() {
    this.width = 0;
    this.height = 0;
    this.bitrateBps = 0;
    this.framerate = 0;
    this.maxQp = 0;
    this.numOfTemporalLayers = 0;
  };
  SpatialLayer.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpatialLayer.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;







    return validator.validationError.NONE;
  };

  SpatialLayer.encodedSize = codec.kStructHeaderSize + 24;

  SpatialLayer.decode = function(decoder) {
    var packed;
    var val = new SpatialLayer();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.width =
        decoder.decodeStruct(codec.Int32);
    val.height =
        decoder.decodeStruct(codec.Int32);
    val.bitrateBps =
        decoder.decodeStruct(codec.Uint32);
    val.framerate =
        decoder.decodeStruct(codec.Uint32);
    val.maxQp =
        decoder.decodeStruct(codec.Uint8);
    val.numOfTemporalLayers =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpatialLayer.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpatialLayer.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.width);
    encoder.encodeStruct(codec.Int32, val.height);
    encoder.encodeStruct(codec.Uint32, val.bitrateBps);
    encoder.encodeStruct(codec.Uint32, val.framerate);
    encoder.encodeStruct(codec.Uint8, val.maxQp);
    encoder.encodeStruct(codec.Uint8, val.numOfTemporalLayers);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ConstantBitrate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ConstantBitrate.prototype.initDefaults_ = function() {
    this.targetBps = 0;
  };
  ConstantBitrate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ConstantBitrate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ConstantBitrate.encodedSize = codec.kStructHeaderSize + 8;

  ConstantBitrate.decode = function(decoder) {
    var packed;
    var val = new ConstantBitrate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.targetBps =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ConstantBitrate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ConstantBitrate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.targetBps);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VariableBitrate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VariableBitrate.prototype.initDefaults_ = function() {
    this.targetBps = 0;
    this.peakBps = 0;
  };
  VariableBitrate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VariableBitrate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  VariableBitrate.encodedSize = codec.kStructHeaderSize + 8;

  VariableBitrate.decode = function(decoder) {
    var packed;
    var val = new VariableBitrate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.targetBps =
        decoder.decodeStruct(codec.Uint32);
    val.peakBps =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  VariableBitrate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VariableBitrate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.targetBps);
    encoder.encodeStruct(codec.Uint32, val.peakBps);
  };
  function ExternalBitrate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ExternalBitrate.prototype.initDefaults_ = function() {
  };
  ExternalBitrate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ExternalBitrate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ExternalBitrate.encodedSize = codec.kStructHeaderSize + 0;

  ExternalBitrate.decode = function(decoder) {
    var packed;
    var val = new ExternalBitrate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ExternalBitrate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ExternalBitrate.encodedSize);
    encoder.writeUint32(0);
  };
  function VideoEncodeAcceleratorConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  VideoEncodeAcceleratorConfig.ContentType = {};
  VideoEncodeAcceleratorConfig.ContentType.kCamera = 0;
  VideoEncodeAcceleratorConfig.ContentType.kDisplay = 1;
  VideoEncodeAcceleratorConfig.ContentType.MIN_VALUE = 0;
  VideoEncodeAcceleratorConfig.ContentType.MAX_VALUE = 1;

  VideoEncodeAcceleratorConfig.ContentType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  VideoEncodeAcceleratorConfig.ContentType.toKnownEnumValue = function(value) {
    return value;
  };

  VideoEncodeAcceleratorConfig.ContentType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  VideoEncodeAcceleratorConfig.StorageType = {};
  VideoEncodeAcceleratorConfig.StorageType.kShmem = 0;
  VideoEncodeAcceleratorConfig.StorageType.kGpuMemoryBuffer = 1;
  VideoEncodeAcceleratorConfig.StorageType.MIN_VALUE = 0;
  VideoEncodeAcceleratorConfig.StorageType.MAX_VALUE = 1;

  VideoEncodeAcceleratorConfig.StorageType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  VideoEncodeAcceleratorConfig.StorageType.toKnownEnumValue = function(value) {
    return value;
  };

  VideoEncodeAcceleratorConfig.StorageType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  VideoEncodeAcceleratorConfig.EncoderType = {};
  VideoEncodeAcceleratorConfig.EncoderType.kHardware = 0;
  VideoEncodeAcceleratorConfig.EncoderType.kSoftware = 1;
  VideoEncodeAcceleratorConfig.EncoderType.kNoPreference = 2;
  VideoEncodeAcceleratorConfig.EncoderType.MIN_VALUE = 0;
  VideoEncodeAcceleratorConfig.EncoderType.MAX_VALUE = 2;

  VideoEncodeAcceleratorConfig.EncoderType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  VideoEncodeAcceleratorConfig.EncoderType.toKnownEnumValue = function(value) {
    return value;
  };

  VideoEncodeAcceleratorConfig.EncoderType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  VideoEncodeAcceleratorConfig.prototype.initDefaults_ = function() {
    this.inputFormat = 0;
    this.outputProfile = 0;
    this.inputVisibleSize = null;
    this.bitrate = null;
    this.framerate = 0;
    this.storageType = 0;
    this.contentType = 0;
    this.gopLength = 0;
    this.hasGopLength = false;
    this.hasH264OutputLevel = false;
    this.isConstrainedH264 = false;
    this.requireLowDelay = false;
    this.manualReferenceBufferControl = false;
    this.h264OutputLevel = 0;
    this.dropFrameThreshPercentage = 0;
    this.interLayerPred = 0;
    this.spatialLayers = null;
    this.requiredEncoderType = 0;
  };
  VideoEncodeAcceleratorConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAcceleratorConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorConfig.inputFormat
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, media_types$.VideoPixelFormat);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorConfig.inputVisibleSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorConfig.outputProfile
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, media_types$.VideoCodecProfile);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorConfig.bitrate
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, Bitrate, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoEncodeAcceleratorConfig.storageType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, VideoEncodeAcceleratorConfig.StorageType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorConfig.contentType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, VideoEncodeAcceleratorConfig.ContentType);
    if (err !== validator.validationError.NONE)
        return err;








    // validate VideoEncodeAcceleratorConfig.spatialLayers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 8, new codec.PointerTo(SpatialLayer), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorConfig.interLayerPred
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 52, media_types$.SVCInterLayerPredMode);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoEncodeAcceleratorConfig.requiredEncoderType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 64, VideoEncodeAcceleratorConfig.EncoderType);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VideoEncodeAcceleratorConfig.encodedSize = codec.kStructHeaderSize + 72;

  VideoEncodeAcceleratorConfig.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAcceleratorConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.inputFormat =
        decoder.decodeStruct(new codec.Enum(media_types$.VideoPixelFormat));
    val.outputProfile =
        decoder.decodeStruct(new codec.Enum(media_types$.VideoCodecProfile));
    val.inputVisibleSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.bitrate =
        decoder.decodeStruct(Bitrate);
    val.framerate =
        decoder.decodeStruct(codec.Uint32);
    val.storageType =
        decoder.decodeStruct(new codec.Enum(VideoEncodeAcceleratorConfig.StorageType));
    val.contentType =
        decoder.decodeStruct(new codec.Enum(VideoEncodeAcceleratorConfig.ContentType));
    val.gopLength =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.hasGopLength = (packed >> 0) & 1 ? true : false;
    val.hasH264OutputLevel = (packed >> 1) & 1 ? true : false;
    val.isConstrainedH264 = (packed >> 2) & 1 ? true : false;
    val.requireLowDelay = (packed >> 3) & 1 ? true : false;
    val.manualReferenceBufferControl = (packed >> 4) & 1 ? true : false;
    val.h264OutputLevel =
        decoder.decodeStruct(codec.Uint8);
    val.dropFrameThreshPercentage =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    val.interLayerPred =
        decoder.decodeStruct(new codec.Enum(media_types$.SVCInterLayerPredMode));
    val.spatialLayers =
        decoder.decodeArrayPointer(new codec.PointerTo(SpatialLayer));
    val.requiredEncoderType =
        decoder.decodeStruct(new codec.Enum(VideoEncodeAcceleratorConfig.EncoderType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoEncodeAcceleratorConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAcceleratorConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.inputFormat);
    encoder.encodeStruct(codec.Int32, val.outputProfile);
    encoder.encodeStructPointer(geometry$.Size, val.inputVisibleSize);
    encoder.encodeStruct(Bitrate, val.bitrate);
    encoder.encodeStruct(codec.Uint32, val.framerate);
    encoder.encodeStruct(codec.Int32, val.storageType);
    encoder.encodeStruct(codec.Int32, val.contentType);
    encoder.encodeStruct(codec.Uint32, val.gopLength);
    packed = 0;
    packed |= (val.hasGopLength & 1) << 0
    packed |= (val.hasH264OutputLevel & 1) << 1
    packed |= (val.isConstrainedH264 & 1) << 2
    packed |= (val.requireLowDelay & 1) << 3
    packed |= (val.manualReferenceBufferControl & 1) << 4
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.h264OutputLevel);
    encoder.encodeStruct(codec.Uint8, val.dropFrameThreshPercentage);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.interLayerPred);
    encoder.encodeArrayPointer(new codec.PointerTo(SpatialLayer), val.spatialLayers);
    encoder.encodeStruct(codec.Int32, val.requiredEncoderType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoEncodeOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeOptions.prototype.initDefaults_ = function() {
    this.forceKeyframe = false;
    this.update_buffer_$flag = false;
    this.update_buffer_$value = 0;
    this.quantizer = 0;
    this.referenceBuffers = null;
  };
  VideoEncodeOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    // validate VideoEncodeOptions.referenceBuffers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeOptions.encodedSize = codec.kStructHeaderSize + 16;

  VideoEncodeOptions.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.forceKeyframe = (packed >> 0) & 1 ? true : false;
    val.update_buffer_$flag = (packed >> 1) & 1 ? true : false;
    val.update_buffer_$value =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    val.quantizer =
        decoder.decodeStruct(codec.Int32);
    val.referenceBuffers =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  VideoEncodeOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeOptions.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.forceKeyframe & 1) << 0
    packed |= (val.update_buffer_$flag & 1) << 1
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.update_buffer_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.quantizer);
    encoder.encodeArrayPointer(codec.Uint8, val.referenceBuffers);
  };
  function DropFrameMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DropFrameMetadata.prototype.initDefaults_ = function() {
    this.spatialIdx = 0;
    this.endOfPicture = false;
  };
  DropFrameMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DropFrameMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  DropFrameMetadata.encodedSize = codec.kStructHeaderSize + 8;

  DropFrameMetadata.decode = function(decoder) {
    var packed;
    var val = new DropFrameMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.spatialIdx =
        decoder.decodeStruct(codec.Uint8);
    packed = decoder.readUint8();
    val.endOfPicture = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DropFrameMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DropFrameMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint8, val.spatialIdx);
    packed = 0;
    packed |= (val.endOfPicture & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function H264Metadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  H264Metadata.prototype.initDefaults_ = function() {
    this.temporalIdx = 0;
    this.layerSync = false;
  };
  H264Metadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  H264Metadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  H264Metadata.encodedSize = codec.kStructHeaderSize + 8;

  H264Metadata.decode = function(decoder) {
    var packed;
    var val = new H264Metadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.temporalIdx =
        decoder.decodeStruct(codec.Uint8);
    packed = decoder.readUint8();
    val.layerSync = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  H264Metadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(H264Metadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint8, val.temporalIdx);
    packed = 0;
    packed |= (val.layerSync & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Vp8Metadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Vp8Metadata.prototype.initDefaults_ = function() {
    this.nonReference = false;
    this.layerSync = false;
    this.temporalIdx = 0;
  };
  Vp8Metadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Vp8Metadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  Vp8Metadata.encodedSize = codec.kStructHeaderSize + 8;

  Vp8Metadata.decode = function(decoder) {
    var packed;
    var val = new Vp8Metadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.nonReference = (packed >> 0) & 1 ? true : false;
    val.layerSync = (packed >> 1) & 1 ? true : false;
    val.temporalIdx =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Vp8Metadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Vp8Metadata.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.nonReference & 1) << 0
    packed |= (val.layerSync & 1) << 1
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.temporalIdx);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Vp9Metadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Vp9Metadata.prototype.initDefaults_ = function() {
    this.interPicPredicted = false;
    this.temporalUpSwitch = false;
    this.referencedByUpperSpatialLayers = false;
    this.referenceLowerSpatialLayers = false;
    this.endOfPicture = false;
    this.temporalIdx = 0;
    this.spatialIdx = 0;
    this.beginActiveSpatialLayerIndex = 0;
    this.endActiveSpatialLayerIndex = 0;
    this.spatialLayerResolutions = null;
    this.pDiffs = null;
  };
  Vp9Metadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Vp9Metadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;









    // validate Vp9Metadata.spatialLayerResolutions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(geometry$.Size), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;




    // validate Vp9Metadata.pDiffs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Vp9Metadata.encodedSize = codec.kStructHeaderSize + 24;

  Vp9Metadata.decode = function(decoder) {
    var packed;
    var val = new Vp9Metadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.interPicPredicted = (packed >> 0) & 1 ? true : false;
    val.temporalUpSwitch = (packed >> 1) & 1 ? true : false;
    val.referencedByUpperSpatialLayers = (packed >> 2) & 1 ? true : false;
    val.referenceLowerSpatialLayers = (packed >> 3) & 1 ? true : false;
    val.endOfPicture = (packed >> 4) & 1 ? true : false;
    val.temporalIdx =
        decoder.decodeStruct(codec.Uint8);
    val.spatialIdx =
        decoder.decodeStruct(codec.Uint8);
    val.beginActiveSpatialLayerIndex =
        decoder.decodeStruct(codec.Uint8);
    val.endActiveSpatialLayerIndex =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.spatialLayerResolutions =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.Size));
    val.pDiffs =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  Vp9Metadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Vp9Metadata.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.interPicPredicted & 1) << 0
    packed |= (val.temporalUpSwitch & 1) << 1
    packed |= (val.referencedByUpperSpatialLayers & 1) << 2
    packed |= (val.referenceLowerSpatialLayers & 1) << 3
    packed |= (val.endOfPicture & 1) << 4
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.temporalIdx);
    encoder.encodeStruct(codec.Uint8, val.spatialIdx);
    encoder.encodeStruct(codec.Uint8, val.beginActiveSpatialLayerIndex);
    encoder.encodeStruct(codec.Uint8, val.endActiveSpatialLayerIndex);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.Size), val.spatialLayerResolutions);
    encoder.encodeArrayPointer(codec.Uint8, val.pDiffs);
  };
  function SVCGenericMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SVCGenericMetadata.prototype.initDefaults_ = function() {
    this.followSvcSpec = false;
    this.reference_flags_$flag = false;
    this.refresh_flags_$flag = false;
    this.temporalIdx = 0;
    this.spatialIdx = 0;
    this.reference_flags_$value = 0;
    this.refresh_flags_$value = 0;
  };
  SVCGenericMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SVCGenericMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;








    return validator.validationError.NONE;
  };

  SVCGenericMetadata.encodedSize = codec.kStructHeaderSize + 8;

  SVCGenericMetadata.decode = function(decoder) {
    var packed;
    var val = new SVCGenericMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.followSvcSpec = (packed >> 0) & 1 ? true : false;
    val.reference_flags_$flag = (packed >> 1) & 1 ? true : false;
    val.refresh_flags_$flag = (packed >> 2) & 1 ? true : false;
    val.temporalIdx =
        decoder.decodeStruct(codec.Uint8);
    val.spatialIdx =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    val.reference_flags_$value =
        decoder.decodeStruct(codec.Uint16);
    val.refresh_flags_$value =
        decoder.decodeStruct(codec.Uint16);
    return val;
  };

  SVCGenericMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SVCGenericMetadata.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.followSvcSpec & 1) << 0
    packed |= (val.reference_flags_$flag & 1) << 1
    packed |= (val.refresh_flags_$flag & 1) << 2
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.temporalIdx);
    encoder.encodeStruct(codec.Uint8, val.spatialIdx);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.reference_flags_$value);
    encoder.encodeStruct(codec.Uint16, val.refresh_flags_$value);
  };
  function BitstreamBufferMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BitstreamBufferMetadata.prototype.initDefaults_ = function() {
    this.payloadSizeBytes = 0;
    this.keyFrame = false;
    this.timestamp = null;
    this.qp = 0;
    this.optionalMetadata = null;
    this.svcGeneric = null;
    this.encodedSize = null;
    this.encodedColorSpace = null;
  };
  BitstreamBufferMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BitstreamBufferMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate BitstreamBufferMetadata.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate BitstreamBufferMetadata.optionalMetadata
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 24, OptionalMetadata, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BitstreamBufferMetadata.svcGeneric
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, SVCGenericMetadata, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BitstreamBufferMetadata.encodedSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, geometry$.Size, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BitstreamBufferMetadata.encodedColorSpace
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, color_space$.ColorSpace, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BitstreamBufferMetadata.encodedSize = codec.kStructHeaderSize + 64;

  BitstreamBufferMetadata.decode = function(decoder) {
    var packed;
    var val = new BitstreamBufferMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.payloadSizeBytes =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.keyFrame = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.timestamp =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.qp =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optionalMetadata =
        decoder.decodeStruct(OptionalMetadata);
    val.svcGeneric =
        decoder.decodeStructPointer(SVCGenericMetadata);
    val.encodedSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.encodedColorSpace =
        decoder.decodeStructPointer(color_space$.ColorSpace);
    return val;
  };

  BitstreamBufferMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BitstreamBufferMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.payloadSizeBytes);
    packed = 0;
    packed |= (val.keyFrame & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(time$.TimeDelta, val.timestamp);
    encoder.encodeStruct(codec.Int32, val.qp);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(OptionalMetadata, val.optionalMetadata);
    encoder.encodeStructPointer(SVCGenericMetadata, val.svcGeneric);
    encoder.encodeStructPointer(geometry$.Size, val.encodedSize);
    encoder.encodeStructPointer(color_space$.ColorSpace, val.encodedColorSpace);
  };
  function VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params.prototype.initDefaults_ = function() {
    this.commandBufferId = null;
    this.receiver = new bindings.InterfaceRequest();
  };
  VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params.commandBufferId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, EncodeCommandBufferId, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params.encodedSize = codec.kStructHeaderSize + 16;

  VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.commandBufferId =
        decoder.decodeStructPointer(EncodeCommandBufferId);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(EncodeCommandBufferId, val.commandBufferId);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params.prototype.initDefaults_ = function() {
  };
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params.encodedSize = codec.kStructHeaderSize + 0;

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams.prototype.initDefaults_ = function() {
    this.profiles = null;
  };
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams.profiles
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(VideoEncodeAcceleratorSupportedProfile), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.profiles =
        decoder.decodeArrayPointer(new codec.PointerTo(VideoEncodeAcceleratorSupportedProfile));
    return val;
  };

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(VideoEncodeAcceleratorSupportedProfile), val.profiles);
  };
  function VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params.encodedSize = codec.kStructHeaderSize + 8;

  VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoEncodeAccelerator_Initialize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAccelerator_Initialize_Params.prototype.initDefaults_ = function() {
    this.config = null;
    this.client = new associatedBindings.AssociatedInterfacePtrInfo();
    this.mediaLog = new media_log$.MediaLogPtr();
  };
  VideoEncodeAccelerator_Initialize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAccelerator_Initialize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAccelerator_Initialize_Params.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, VideoEncodeAcceleratorConfig, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAccelerator_Initialize_Params.client
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAccelerator_Initialize_Params.mediaLog
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAccelerator_Initialize_Params.encodedSize = codec.kStructHeaderSize + 24;

  VideoEncodeAccelerator_Initialize_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAccelerator_Initialize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.config =
        decoder.decodeStructPointer(VideoEncodeAcceleratorConfig);
    val.client =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.mediaLog =
        decoder.decodeStruct(new codec.Interface(media_log$.MediaLogPtr));
    return val;
  };

  VideoEncodeAccelerator_Initialize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAccelerator_Initialize_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(VideoEncodeAcceleratorConfig, val.config);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.client);
    encoder.encodeStruct(new codec.Interface(media_log$.MediaLogPtr), val.mediaLog);
  };
  function VideoEncodeAccelerator_Initialize_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAccelerator_Initialize_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  VideoEncodeAccelerator_Initialize_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAccelerator_Initialize_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAccelerator_Initialize_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.EncoderStatus, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAccelerator_Initialize_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  VideoEncodeAccelerator_Initialize_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAccelerator_Initialize_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(media_types$.EncoderStatus);
    return val;
  };

  VideoEncodeAccelerator_Initialize_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAccelerator_Initialize_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.EncoderStatus, val.result);
  };
  function VideoEncodeAccelerator_Encode_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAccelerator_Encode_Params.prototype.initDefaults_ = function() {
    this.frame = null;
    this.options = null;
  };
  VideoEncodeAccelerator_Encode_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAccelerator_Encode_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAccelerator_Encode_Params.frame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.VideoFrame, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAccelerator_Encode_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, VideoEncodeOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAccelerator_Encode_Params.encodedSize = codec.kStructHeaderSize + 16;

  VideoEncodeAccelerator_Encode_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAccelerator_Encode_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frame =
        decoder.decodeStructPointer(media_types$.VideoFrame);
    val.options =
        decoder.decodeStructPointer(VideoEncodeOptions);
    return val;
  };

  VideoEncodeAccelerator_Encode_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAccelerator_Encode_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.VideoFrame, val.frame);
    encoder.encodeStructPointer(VideoEncodeOptions, val.options);
  };
  function VideoEncodeAccelerator_Encode_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAccelerator_Encode_ResponseParams.prototype.initDefaults_ = function() {
  };
  VideoEncodeAccelerator_Encode_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAccelerator_Encode_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAccelerator_Encode_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  VideoEncodeAccelerator_Encode_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAccelerator_Encode_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  VideoEncodeAccelerator_Encode_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAccelerator_Encode_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params.prototype.initDefaults_ = function() {
    this.bitstreamBufferId = 0;
    this.region = null;
  };
  VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params.region
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, shared_memory$.UnsafeSharedMemoryRegion, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params.encodedSize = codec.kStructHeaderSize + 16;

  VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bitstreamBufferId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.region =
        decoder.decodeStructPointer(shared_memory$.UnsafeSharedMemoryRegion);
    return val;
  };

  VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.bitstreamBufferId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(shared_memory$.UnsafeSharedMemoryRegion, val.region);
  };
  function VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params.prototype.initDefaults_ = function() {
    this.bitrateAllocation = null;
    this.framerate = 0;
    this.size = null;
  };
  VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params.bitrateAllocation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, VideoBitrateAllocation, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params.size
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Size, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params.encodedSize = codec.kStructHeaderSize + 24;

  VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bitrateAllocation =
        decoder.decodeStructPointer(VideoBitrateAllocation);
    val.framerate =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.size =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(VideoBitrateAllocation, val.bitrateAllocation);
    encoder.encodeStruct(codec.Uint32, val.framerate);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.Size, val.size);
  };
  function VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params.prototype.initDefaults_ = function() {
    this.bitrate = null;
    this.framerate = 0;
    this.size = null;
  };
  VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params.bitrate
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, Bitrate, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params.size
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Size, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params.encodedSize = codec.kStructHeaderSize + 32;

  VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bitrate =
        decoder.decodeStruct(Bitrate);
    val.framerate =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.size =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(Bitrate, val.bitrate);
    encoder.encodeStruct(codec.Uint32, val.framerate);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.Size, val.size);
  };
  function VideoEncodeAccelerator_IsFlushSupported_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAccelerator_IsFlushSupported_Params.prototype.initDefaults_ = function() {
  };
  VideoEncodeAccelerator_IsFlushSupported_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAccelerator_IsFlushSupported_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAccelerator_IsFlushSupported_Params.encodedSize = codec.kStructHeaderSize + 0;

  VideoEncodeAccelerator_IsFlushSupported_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAccelerator_IsFlushSupported_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  VideoEncodeAccelerator_IsFlushSupported_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAccelerator_IsFlushSupported_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function VideoEncodeAccelerator_IsFlushSupported_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAccelerator_IsFlushSupported_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  VideoEncodeAccelerator_IsFlushSupported_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAccelerator_IsFlushSupported_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VideoEncodeAccelerator_IsFlushSupported_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  VideoEncodeAccelerator_IsFlushSupported_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAccelerator_IsFlushSupported_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoEncodeAccelerator_IsFlushSupported_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAccelerator_IsFlushSupported_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoEncodeAccelerator_Flush_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAccelerator_Flush_Params.prototype.initDefaults_ = function() {
  };
  VideoEncodeAccelerator_Flush_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAccelerator_Flush_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAccelerator_Flush_Params.encodedSize = codec.kStructHeaderSize + 0;

  VideoEncodeAccelerator_Flush_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAccelerator_Flush_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  VideoEncodeAccelerator_Flush_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAccelerator_Flush_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function VideoEncodeAccelerator_Flush_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAccelerator_Flush_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  VideoEncodeAccelerator_Flush_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAccelerator_Flush_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VideoEncodeAccelerator_Flush_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  VideoEncodeAccelerator_Flush_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAccelerator_Flush_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoEncodeAccelerator_Flush_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAccelerator_Flush_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params.prototype.initDefaults_ = function() {
    this.inputCount = 0;
    this.outputBufferSize = 0;
    this.inputCodedSize = null;
  };
  VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params.inputCodedSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params.encodedSize = codec.kStructHeaderSize + 16;

  VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.inputCount =
        decoder.decodeStruct(codec.Uint32);
    val.outputBufferSize =
        decoder.decodeStruct(codec.Uint32);
    val.inputCodedSize =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.inputCount);
    encoder.encodeStruct(codec.Uint32, val.outputBufferSize);
    encoder.encodeStructPointer(geometry$.Size, val.inputCodedSize);
  };
  function VideoEncodeAcceleratorClient_BitstreamBufferReady_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAcceleratorClient_BitstreamBufferReady_Params.prototype.initDefaults_ = function() {
    this.bitstreamBufferId = 0;
    this.metadata = null;
  };
  VideoEncodeAcceleratorClient_BitstreamBufferReady_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAcceleratorClient_BitstreamBufferReady_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoEncodeAcceleratorClient_BitstreamBufferReady_Params.metadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, BitstreamBufferMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAcceleratorClient_BitstreamBufferReady_Params.encodedSize = codec.kStructHeaderSize + 16;

  VideoEncodeAcceleratorClient_BitstreamBufferReady_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAcceleratorClient_BitstreamBufferReady_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bitstreamBufferId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.metadata =
        decoder.decodeStructPointer(BitstreamBufferMetadata);
    return val;
  };

  VideoEncodeAcceleratorClient_BitstreamBufferReady_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAcceleratorClient_BitstreamBufferReady_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.bitstreamBufferId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(BitstreamBufferMetadata, val.metadata);
  };
  function VideoEncodeAcceleratorClient_NotifyErrorStatus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAcceleratorClient_NotifyErrorStatus_Params.prototype.initDefaults_ = function() {
    this.status = null;
  };
  VideoEncodeAcceleratorClient_NotifyErrorStatus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAcceleratorClient_NotifyErrorStatus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorClient_NotifyErrorStatus_Params.status
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.EncoderStatus, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAcceleratorClient_NotifyErrorStatus_Params.encodedSize = codec.kStructHeaderSize + 8;

  VideoEncodeAcceleratorClient_NotifyErrorStatus_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAcceleratorClient_NotifyErrorStatus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStructPointer(media_types$.EncoderStatus);
    return val;
  };

  VideoEncodeAcceleratorClient_NotifyErrorStatus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAcceleratorClient_NotifyErrorStatus_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.EncoderStatus, val.status);
  };
  function VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params.prototype.initDefaults_ = function() {
    this.info = null;
  };
  VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, video_encoder_info$.VideoEncoderInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params.encodedSize = codec.kStructHeaderSize + 8;

  VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(video_encoder_info$.VideoEncoderInfo);
    return val;
  };

  VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(video_encoder_info$.VideoEncoderInfo, val.info);
  };

  function Bitrate(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  Bitrate.Tags = {
    constant: 0,
    variable: 1,
    external: 2,
  };

  Bitrate.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  Bitrate.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "constant",
        "variable",
        "external",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a Bitrate member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(Bitrate.prototype, "constant", {
    get: function() {
      if (this.$tag != Bitrate.Tags.constant) {
        throw new ReferenceError(
            "Bitrate.constant is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = Bitrate.Tags.constant;
      this.$data = value;
    }
  });
  Object.defineProperty(Bitrate.prototype, "variable", {
    get: function() {
      if (this.$tag != Bitrate.Tags.variable) {
        throw new ReferenceError(
            "Bitrate.variable is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = Bitrate.Tags.variable;
      this.$data = value;
    }
  });
  Object.defineProperty(Bitrate.prototype, "external", {
    get: function() {
      if (this.$tag != Bitrate.Tags.external) {
        throw new ReferenceError(
            "Bitrate.external is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = Bitrate.Tags.external;
      this.$data = value;
    }
  });


    Bitrate.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case Bitrate.Tags.constant:
          encoder.encodeStructPointer(ConstantBitrate, val.constant);
          break;
        case Bitrate.Tags.variable:
          encoder.encodeStructPointer(VariableBitrate, val.variable);
          break;
        case Bitrate.Tags.external:
          encoder.encodeStructPointer(ExternalBitrate, val.external);
          break;
      }
      encoder.align();
    };


    Bitrate.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new Bitrate();
      var tag = decoder.readUint32();
      switch (tag) {
        case Bitrate.Tags.constant:
          result.constant = decoder.decodeStructPointer(ConstantBitrate);
          break;
        case Bitrate.Tags.variable:
          result.variable = decoder.decodeStructPointer(VariableBitrate);
          break;
        case Bitrate.Tags.external:
          result.external = decoder.decodeStructPointer(ExternalBitrate);
          break;
      }
      decoder.align();

      return result;
    };


    Bitrate.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case Bitrate.Tags.constant:
          

    // validate Bitrate.constant
    err = messageValidator.validateStructPointer(data_offset, ConstantBitrate, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case Bitrate.Tags.variable:
          

    // validate Bitrate.variable
    err = messageValidator.validateStructPointer(data_offset, VariableBitrate, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case Bitrate.Tags.external:
          

    // validate Bitrate.external
    err = messageValidator.validateStructPointer(data_offset, ExternalBitrate, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  Bitrate.encodedSize = 16;

  function OptionalMetadata(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  OptionalMetadata.Tags = {
    drop: 0,
    h264: 1,
    vp8: 2,
    vp9: 3,
  };

  OptionalMetadata.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  OptionalMetadata.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "drop",
        "h264",
        "vp8",
        "vp9",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a OptionalMetadata member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(OptionalMetadata.prototype, "drop", {
    get: function() {
      if (this.$tag != OptionalMetadata.Tags.drop) {
        throw new ReferenceError(
            "OptionalMetadata.drop is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = OptionalMetadata.Tags.drop;
      this.$data = value;
    }
  });
  Object.defineProperty(OptionalMetadata.prototype, "h264", {
    get: function() {
      if (this.$tag != OptionalMetadata.Tags.h264) {
        throw new ReferenceError(
            "OptionalMetadata.h264 is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = OptionalMetadata.Tags.h264;
      this.$data = value;
    }
  });
  Object.defineProperty(OptionalMetadata.prototype, "vp8", {
    get: function() {
      if (this.$tag != OptionalMetadata.Tags.vp8) {
        throw new ReferenceError(
            "OptionalMetadata.vp8 is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = OptionalMetadata.Tags.vp8;
      this.$data = value;
    }
  });
  Object.defineProperty(OptionalMetadata.prototype, "vp9", {
    get: function() {
      if (this.$tag != OptionalMetadata.Tags.vp9) {
        throw new ReferenceError(
            "OptionalMetadata.vp9 is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = OptionalMetadata.Tags.vp9;
      this.$data = value;
    }
  });


    OptionalMetadata.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case OptionalMetadata.Tags.drop:
          encoder.encodeStructPointer(DropFrameMetadata, val.drop);
          break;
        case OptionalMetadata.Tags.h264:
          encoder.encodeStructPointer(H264Metadata, val.h264);
          break;
        case OptionalMetadata.Tags.vp8:
          encoder.encodeStructPointer(Vp8Metadata, val.vp8);
          break;
        case OptionalMetadata.Tags.vp9:
          encoder.encodeStructPointer(Vp9Metadata, val.vp9);
          break;
      }
      encoder.align();
    };


    OptionalMetadata.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new OptionalMetadata();
      var tag = decoder.readUint32();
      switch (tag) {
        case OptionalMetadata.Tags.drop:
          result.drop = decoder.decodeStructPointer(DropFrameMetadata);
          break;
        case OptionalMetadata.Tags.h264:
          result.h264 = decoder.decodeStructPointer(H264Metadata);
          break;
        case OptionalMetadata.Tags.vp8:
          result.vp8 = decoder.decodeStructPointer(Vp8Metadata);
          break;
        case OptionalMetadata.Tags.vp9:
          result.vp9 = decoder.decodeStructPointer(Vp9Metadata);
          break;
      }
      decoder.align();

      return result;
    };


    OptionalMetadata.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case OptionalMetadata.Tags.drop:
          

    // validate OptionalMetadata.drop
    err = messageValidator.validateStructPointer(data_offset, DropFrameMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case OptionalMetadata.Tags.h264:
          

    // validate OptionalMetadata.h264
    err = messageValidator.validateStructPointer(data_offset, H264Metadata, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case OptionalMetadata.Tags.vp8:
          

    // validate OptionalMetadata.vp8
    err = messageValidator.validateStructPointer(data_offset, Vp8Metadata, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case OptionalMetadata.Tags.vp9:
          

    // validate OptionalMetadata.vp9
    err = messageValidator.validateStructPointer(data_offset, Vp9Metadata, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  OptionalMetadata.encodedSize = 16;
  var kVideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Name = 0;
  var kVideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Name = 1;

  function VideoEncodeAcceleratorProviderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(VideoEncodeAcceleratorProvider,
                                                   handleOrPtrInfo);
  }

  function VideoEncodeAcceleratorProviderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        VideoEncodeAcceleratorProvider, associatedInterfacePtrInfo);
  }

  VideoEncodeAcceleratorProviderAssociatedPtr.prototype =
      Object.create(VideoEncodeAcceleratorProviderPtr.prototype);
  VideoEncodeAcceleratorProviderAssociatedPtr.prototype.constructor =
      VideoEncodeAcceleratorProviderAssociatedPtr;

  function VideoEncodeAcceleratorProviderProxy(receiver) {
    this.receiver_ = receiver;
  }
  VideoEncodeAcceleratorProviderPtr.prototype.createVideoEncodeAccelerator = function() {
    return VideoEncodeAcceleratorProviderProxy.prototype.createVideoEncodeAccelerator
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorProviderProxy.prototype.createVideoEncodeAccelerator = function(commandBufferId, receiver) {
    var params_ = new VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params();
    params_.commandBufferId = commandBufferId;
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kVideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Name,
        codec.align(VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params.encodedSize));
    builder.encodeStruct(VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  VideoEncodeAcceleratorProviderPtr.prototype.getVideoEncodeAcceleratorSupportedProfiles = function() {
    return VideoEncodeAcceleratorProviderProxy.prototype.getVideoEncodeAcceleratorSupportedProfiles
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorProviderProxy.prototype.getVideoEncodeAcceleratorSupportedProfiles = function() {
    var params_ = new VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kVideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Name,
          codec.align(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function VideoEncodeAcceleratorProviderStub(delegate) {
    this.delegate_ = delegate;
  }
  VideoEncodeAcceleratorProviderStub.prototype.createVideoEncodeAccelerator = function(commandBufferId, receiver) {
    return this.delegate_ && this.delegate_.createVideoEncodeAccelerator && this.delegate_.createVideoEncodeAccelerator(commandBufferId, receiver);
  }
  VideoEncodeAcceleratorProviderStub.prototype.getVideoEncodeAcceleratorSupportedProfiles = function() {
    return this.delegate_ && this.delegate_.getVideoEncodeAcceleratorSupportedProfiles && this.delegate_.getVideoEncodeAcceleratorSupportedProfiles();
  }

  VideoEncodeAcceleratorProviderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kVideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Name:
      var params = reader.decodeStruct(VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params);
      this.createVideoEncodeAccelerator(params.commandBufferId, params.receiver);
      return true;
    default:
      return false;
    }
  };

  VideoEncodeAcceleratorProviderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kVideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Name:
      var params = reader.decodeStruct(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params);
      this.getVideoEncodeAcceleratorSupportedProfiles().then(function(response) {
        var responseParams =
            new VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams();
        responseParams.profiles = response.profiles;
        var builder = new codec.MessageV1Builder(
            kVideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Name,
            codec.align(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateVideoEncodeAcceleratorProviderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kVideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params;
      break;
      case kVideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Name:
        if (message.expectsResponse())
          paramsClass = VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateVideoEncodeAcceleratorProviderResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kVideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Name:
        if (message.isResponse())
          paramsClass = VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var VideoEncodeAcceleratorProvider = {
    name: 'media.mojom.VideoEncodeAcceleratorProvider',
    kVersion: 0,
    ptrClass: VideoEncodeAcceleratorProviderPtr,
    proxyClass: VideoEncodeAcceleratorProviderProxy,
    stubClass: VideoEncodeAcceleratorProviderStub,
    validateRequest: validateVideoEncodeAcceleratorProviderRequest,
    validateResponse: validateVideoEncodeAcceleratorProviderResponse,
  };
  VideoEncodeAcceleratorProviderStub.prototype.validator = validateVideoEncodeAcceleratorProviderRequest;
  VideoEncodeAcceleratorProviderProxy.prototype.validator = validateVideoEncodeAcceleratorProviderResponse;
  var kVideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Name = 0;

  function VideoEncodeAcceleratorProviderFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(VideoEncodeAcceleratorProviderFactory,
                                                   handleOrPtrInfo);
  }

  function VideoEncodeAcceleratorProviderFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        VideoEncodeAcceleratorProviderFactory, associatedInterfacePtrInfo);
  }

  VideoEncodeAcceleratorProviderFactoryAssociatedPtr.prototype =
      Object.create(VideoEncodeAcceleratorProviderFactoryPtr.prototype);
  VideoEncodeAcceleratorProviderFactoryAssociatedPtr.prototype.constructor =
      VideoEncodeAcceleratorProviderFactoryAssociatedPtr;

  function VideoEncodeAcceleratorProviderFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  VideoEncodeAcceleratorProviderFactoryPtr.prototype.createVideoEncodeAcceleratorProvider = function() {
    return VideoEncodeAcceleratorProviderFactoryProxy.prototype.createVideoEncodeAcceleratorProvider
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorProviderFactoryProxy.prototype.createVideoEncodeAcceleratorProvider = function(receiver) {
    var params_ = new VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kVideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Name,
        codec.align(VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params.encodedSize));
    builder.encodeStruct(VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function VideoEncodeAcceleratorProviderFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  VideoEncodeAcceleratorProviderFactoryStub.prototype.createVideoEncodeAcceleratorProvider = function(receiver) {
    return this.delegate_ && this.delegate_.createVideoEncodeAcceleratorProvider && this.delegate_.createVideoEncodeAcceleratorProvider(receiver);
  }

  VideoEncodeAcceleratorProviderFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kVideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Name:
      var params = reader.decodeStruct(VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params);
      this.createVideoEncodeAcceleratorProvider(params.receiver);
      return true;
    default:
      return false;
    }
  };

  VideoEncodeAcceleratorProviderFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateVideoEncodeAcceleratorProviderFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kVideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoEncodeAcceleratorProviderFactory_CreateVideoEncodeAcceleratorProvider_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateVideoEncodeAcceleratorProviderFactoryResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var VideoEncodeAcceleratorProviderFactory = {
    name: 'media.mojom.VideoEncodeAcceleratorProviderFactory',
    kVersion: 0,
    ptrClass: VideoEncodeAcceleratorProviderFactoryPtr,
    proxyClass: VideoEncodeAcceleratorProviderFactoryProxy,
    stubClass: VideoEncodeAcceleratorProviderFactoryStub,
    validateRequest: validateVideoEncodeAcceleratorProviderFactoryRequest,
    validateResponse: null,
  };
  VideoEncodeAcceleratorProviderFactoryStub.prototype.validator = validateVideoEncodeAcceleratorProviderFactoryRequest;
  VideoEncodeAcceleratorProviderFactoryProxy.prototype.validator = null;
  var kVideoEncodeAccelerator_Initialize_Name = 0;
  var kVideoEncodeAccelerator_Encode_Name = 1;
  var kVideoEncodeAccelerator_UseOutputBitstreamBuffer_Name = 2;
  var kVideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Name = 3;
  var kVideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Name = 4;
  var kVideoEncodeAccelerator_IsFlushSupported_Name = 5;
  var kVideoEncodeAccelerator_Flush_Name = 6;

  function VideoEncodeAcceleratorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(VideoEncodeAccelerator,
                                                   handleOrPtrInfo);
  }

  function VideoEncodeAcceleratorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        VideoEncodeAccelerator, associatedInterfacePtrInfo);
  }

  VideoEncodeAcceleratorAssociatedPtr.prototype =
      Object.create(VideoEncodeAcceleratorPtr.prototype);
  VideoEncodeAcceleratorAssociatedPtr.prototype.constructor =
      VideoEncodeAcceleratorAssociatedPtr;

  function VideoEncodeAcceleratorProxy(receiver) {
    this.receiver_ = receiver;
  }
  VideoEncodeAcceleratorPtr.prototype.initialize = function() {
    return VideoEncodeAcceleratorProxy.prototype.initialize
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorProxy.prototype.initialize = function(config, client, mediaLog) {
    var params_ = new VideoEncodeAccelerator_Initialize_Params();
    params_.config = config;
    params_.client = client;
    params_.mediaLog = mediaLog;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kVideoEncodeAccelerator_Initialize_Name,
          codec.align(VideoEncodeAccelerator_Initialize_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(VideoEncodeAccelerator_Initialize_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(VideoEncodeAccelerator_Initialize_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  VideoEncodeAcceleratorPtr.prototype.encode = function() {
    return VideoEncodeAcceleratorProxy.prototype.encode
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorProxy.prototype.encode = function(frame, options) {
    var params_ = new VideoEncodeAccelerator_Encode_Params();
    params_.frame = frame;
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kVideoEncodeAccelerator_Encode_Name,
          codec.align(VideoEncodeAccelerator_Encode_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(VideoEncodeAccelerator_Encode_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(VideoEncodeAccelerator_Encode_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  VideoEncodeAcceleratorPtr.prototype.useOutputBitstreamBuffer = function() {
    return VideoEncodeAcceleratorProxy.prototype.useOutputBitstreamBuffer
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorProxy.prototype.useOutputBitstreamBuffer = function(bitstreamBufferId, region) {
    var params_ = new VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params();
    params_.bitstreamBufferId = bitstreamBufferId;
    params_.region = region;
    var builder = new codec.MessageV0Builder(
        kVideoEncodeAccelerator_UseOutputBitstreamBuffer_Name,
        codec.align(VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params.encodedSize));
    builder.encodeStruct(VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  VideoEncodeAcceleratorPtr.prototype.requestEncodingParametersChangeWithLayers = function() {
    return VideoEncodeAcceleratorProxy.prototype.requestEncodingParametersChangeWithLayers
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorProxy.prototype.requestEncodingParametersChangeWithLayers = function(bitrateAllocation, framerate, size) {
    var params_ = new VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params();
    params_.bitrateAllocation = bitrateAllocation;
    params_.framerate = framerate;
    params_.size = size;
    var builder = new codec.MessageV0Builder(
        kVideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Name,
        codec.align(VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params.encodedSize));
    builder.encodeStruct(VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  VideoEncodeAcceleratorPtr.prototype.requestEncodingParametersChangeWithBitrate = function() {
    return VideoEncodeAcceleratorProxy.prototype.requestEncodingParametersChangeWithBitrate
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorProxy.prototype.requestEncodingParametersChangeWithBitrate = function(bitrate, framerate, size) {
    var params_ = new VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params();
    params_.bitrate = bitrate;
    params_.framerate = framerate;
    params_.size = size;
    var builder = new codec.MessageV0Builder(
        kVideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Name,
        codec.align(VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params.encodedSize));
    builder.encodeStruct(VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  VideoEncodeAcceleratorPtr.prototype.isFlushSupported = function() {
    return VideoEncodeAcceleratorProxy.prototype.isFlushSupported
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorProxy.prototype.isFlushSupported = function() {
    var params_ = new VideoEncodeAccelerator_IsFlushSupported_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kVideoEncodeAccelerator_IsFlushSupported_Name,
          codec.align(VideoEncodeAccelerator_IsFlushSupported_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(VideoEncodeAccelerator_IsFlushSupported_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(VideoEncodeAccelerator_IsFlushSupported_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  VideoEncodeAcceleratorPtr.prototype.flush = function() {
    return VideoEncodeAcceleratorProxy.prototype.flush
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorProxy.prototype.flush = function() {
    var params_ = new VideoEncodeAccelerator_Flush_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kVideoEncodeAccelerator_Flush_Name,
          codec.align(VideoEncodeAccelerator_Flush_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(VideoEncodeAccelerator_Flush_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(VideoEncodeAccelerator_Flush_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function VideoEncodeAcceleratorStub(delegate) {
    this.delegate_ = delegate;
  }
  VideoEncodeAcceleratorStub.prototype.initialize = function(config, client, mediaLog) {
    return this.delegate_ && this.delegate_.initialize && this.delegate_.initialize(config, client, mediaLog);
  }
  VideoEncodeAcceleratorStub.prototype.encode = function(frame, options) {
    return this.delegate_ && this.delegate_.encode && this.delegate_.encode(frame, options);
  }
  VideoEncodeAcceleratorStub.prototype.useOutputBitstreamBuffer = function(bitstreamBufferId, region) {
    return this.delegate_ && this.delegate_.useOutputBitstreamBuffer && this.delegate_.useOutputBitstreamBuffer(bitstreamBufferId, region);
  }
  VideoEncodeAcceleratorStub.prototype.requestEncodingParametersChangeWithLayers = function(bitrateAllocation, framerate, size) {
    return this.delegate_ && this.delegate_.requestEncodingParametersChangeWithLayers && this.delegate_.requestEncodingParametersChangeWithLayers(bitrateAllocation, framerate, size);
  }
  VideoEncodeAcceleratorStub.prototype.requestEncodingParametersChangeWithBitrate = function(bitrate, framerate, size) {
    return this.delegate_ && this.delegate_.requestEncodingParametersChangeWithBitrate && this.delegate_.requestEncodingParametersChangeWithBitrate(bitrate, framerate, size);
  }
  VideoEncodeAcceleratorStub.prototype.isFlushSupported = function() {
    return this.delegate_ && this.delegate_.isFlushSupported && this.delegate_.isFlushSupported();
  }
  VideoEncodeAcceleratorStub.prototype.flush = function() {
    return this.delegate_ && this.delegate_.flush && this.delegate_.flush();
  }

  VideoEncodeAcceleratorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kVideoEncodeAccelerator_UseOutputBitstreamBuffer_Name:
      var params = reader.decodeStruct(VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params);
      this.useOutputBitstreamBuffer(params.bitstreamBufferId, params.region);
      return true;
    case kVideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Name:
      var params = reader.decodeStruct(VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params);
      this.requestEncodingParametersChangeWithLayers(params.bitrateAllocation, params.framerate, params.size);
      return true;
    case kVideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Name:
      var params = reader.decodeStruct(VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params);
      this.requestEncodingParametersChangeWithBitrate(params.bitrate, params.framerate, params.size);
      return true;
    default:
      return false;
    }
  };

  VideoEncodeAcceleratorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kVideoEncodeAccelerator_Initialize_Name:
      var params = reader.decodeStruct(VideoEncodeAccelerator_Initialize_Params);
      this.initialize(params.config, params.client, params.mediaLog).then(function(response) {
        var responseParams =
            new VideoEncodeAccelerator_Initialize_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV2Builder(
            kVideoEncodeAccelerator_Initialize_Name,
            codec.align(VideoEncodeAccelerator_Initialize_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(VideoEncodeAccelerator_Initialize_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kVideoEncodeAccelerator_Encode_Name:
      var params = reader.decodeStruct(VideoEncodeAccelerator_Encode_Params);
      this.encode(params.frame, params.options).then(function(response) {
        var responseParams =
            new VideoEncodeAccelerator_Encode_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kVideoEncodeAccelerator_Encode_Name,
            codec.align(VideoEncodeAccelerator_Encode_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(VideoEncodeAccelerator_Encode_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kVideoEncodeAccelerator_IsFlushSupported_Name:
      var params = reader.decodeStruct(VideoEncodeAccelerator_IsFlushSupported_Params);
      this.isFlushSupported().then(function(response) {
        var responseParams =
            new VideoEncodeAccelerator_IsFlushSupported_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kVideoEncodeAccelerator_IsFlushSupported_Name,
            codec.align(VideoEncodeAccelerator_IsFlushSupported_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(VideoEncodeAccelerator_IsFlushSupported_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kVideoEncodeAccelerator_Flush_Name:
      var params = reader.decodeStruct(VideoEncodeAccelerator_Flush_Params);
      this.flush().then(function(response) {
        var responseParams =
            new VideoEncodeAccelerator_Flush_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kVideoEncodeAccelerator_Flush_Name,
            codec.align(VideoEncodeAccelerator_Flush_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(VideoEncodeAccelerator_Flush_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateVideoEncodeAcceleratorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kVideoEncodeAccelerator_Initialize_Name:
        if (message.expectsResponse())
          paramsClass = VideoEncodeAccelerator_Initialize_Params;
      break;
      case kVideoEncodeAccelerator_Encode_Name:
        if (message.expectsResponse())
          paramsClass = VideoEncodeAccelerator_Encode_Params;
      break;
      case kVideoEncodeAccelerator_UseOutputBitstreamBuffer_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params;
      break;
      case kVideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params;
      break;
      case kVideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params;
      break;
      case kVideoEncodeAccelerator_IsFlushSupported_Name:
        if (message.expectsResponse())
          paramsClass = VideoEncodeAccelerator_IsFlushSupported_Params;
      break;
      case kVideoEncodeAccelerator_Flush_Name:
        if (message.expectsResponse())
          paramsClass = VideoEncodeAccelerator_Flush_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateVideoEncodeAcceleratorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kVideoEncodeAccelerator_Initialize_Name:
        if (message.isResponse())
          paramsClass = VideoEncodeAccelerator_Initialize_ResponseParams;
        break;
      case kVideoEncodeAccelerator_Encode_Name:
        if (message.isResponse())
          paramsClass = VideoEncodeAccelerator_Encode_ResponseParams;
        break;
      case kVideoEncodeAccelerator_IsFlushSupported_Name:
        if (message.isResponse())
          paramsClass = VideoEncodeAccelerator_IsFlushSupported_ResponseParams;
        break;
      case kVideoEncodeAccelerator_Flush_Name:
        if (message.isResponse())
          paramsClass = VideoEncodeAccelerator_Flush_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var VideoEncodeAccelerator = {
    name: 'media.mojom.VideoEncodeAccelerator',
    kVersion: 0,
    ptrClass: VideoEncodeAcceleratorPtr,
    proxyClass: VideoEncodeAcceleratorProxy,
    stubClass: VideoEncodeAcceleratorStub,
    validateRequest: validateVideoEncodeAcceleratorRequest,
    validateResponse: validateVideoEncodeAcceleratorResponse,
  };
  VideoEncodeAcceleratorStub.prototype.validator = validateVideoEncodeAcceleratorRequest;
  VideoEncodeAcceleratorProxy.prototype.validator = validateVideoEncodeAcceleratorResponse;
  var kVideoEncodeAcceleratorClient_RequireBitstreamBuffers_Name = 0;
  var kVideoEncodeAcceleratorClient_BitstreamBufferReady_Name = 1;
  var kVideoEncodeAcceleratorClient_NotifyErrorStatus_Name = 2;
  var kVideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Name = 3;

  function VideoEncodeAcceleratorClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(VideoEncodeAcceleratorClient,
                                                   handleOrPtrInfo);
  }

  function VideoEncodeAcceleratorClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        VideoEncodeAcceleratorClient, associatedInterfacePtrInfo);
  }

  VideoEncodeAcceleratorClientAssociatedPtr.prototype =
      Object.create(VideoEncodeAcceleratorClientPtr.prototype);
  VideoEncodeAcceleratorClientAssociatedPtr.prototype.constructor =
      VideoEncodeAcceleratorClientAssociatedPtr;

  function VideoEncodeAcceleratorClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  VideoEncodeAcceleratorClientPtr.prototype.requireBitstreamBuffers = function() {
    return VideoEncodeAcceleratorClientProxy.prototype.requireBitstreamBuffers
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorClientProxy.prototype.requireBitstreamBuffers = function(inputCount, inputCodedSize, outputBufferSize) {
    var params_ = new VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params();
    params_.inputCount = inputCount;
    params_.inputCodedSize = inputCodedSize;
    params_.outputBufferSize = outputBufferSize;
    var builder = new codec.MessageV0Builder(
        kVideoEncodeAcceleratorClient_RequireBitstreamBuffers_Name,
        codec.align(VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params.encodedSize));
    builder.encodeStruct(VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  VideoEncodeAcceleratorClientPtr.prototype.bitstreamBufferReady = function() {
    return VideoEncodeAcceleratorClientProxy.prototype.bitstreamBufferReady
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorClientProxy.prototype.bitstreamBufferReady = function(bitstreamBufferId, metadata) {
    var params_ = new VideoEncodeAcceleratorClient_BitstreamBufferReady_Params();
    params_.bitstreamBufferId = bitstreamBufferId;
    params_.metadata = metadata;
    var builder = new codec.MessageV0Builder(
        kVideoEncodeAcceleratorClient_BitstreamBufferReady_Name,
        codec.align(VideoEncodeAcceleratorClient_BitstreamBufferReady_Params.encodedSize));
    builder.encodeStruct(VideoEncodeAcceleratorClient_BitstreamBufferReady_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  VideoEncodeAcceleratorClientPtr.prototype.notifyErrorStatus = function() {
    return VideoEncodeAcceleratorClientProxy.prototype.notifyErrorStatus
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorClientProxy.prototype.notifyErrorStatus = function(status) {
    var params_ = new VideoEncodeAcceleratorClient_NotifyErrorStatus_Params();
    params_.status = status;
    var builder = new codec.MessageV0Builder(
        kVideoEncodeAcceleratorClient_NotifyErrorStatus_Name,
        codec.align(VideoEncodeAcceleratorClient_NotifyErrorStatus_Params.encodedSize));
    builder.encodeStruct(VideoEncodeAcceleratorClient_NotifyErrorStatus_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  VideoEncodeAcceleratorClientPtr.prototype.notifyEncoderInfoChange = function() {
    return VideoEncodeAcceleratorClientProxy.prototype.notifyEncoderInfoChange
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncodeAcceleratorClientProxy.prototype.notifyEncoderInfoChange = function(info) {
    var params_ = new VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params();
    params_.info = info;
    var builder = new codec.MessageV0Builder(
        kVideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Name,
        codec.align(VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params.encodedSize));
    builder.encodeStruct(VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function VideoEncodeAcceleratorClientStub(delegate) {
    this.delegate_ = delegate;
  }
  VideoEncodeAcceleratorClientStub.prototype.requireBitstreamBuffers = function(inputCount, inputCodedSize, outputBufferSize) {
    return this.delegate_ && this.delegate_.requireBitstreamBuffers && this.delegate_.requireBitstreamBuffers(inputCount, inputCodedSize, outputBufferSize);
  }
  VideoEncodeAcceleratorClientStub.prototype.bitstreamBufferReady = function(bitstreamBufferId, metadata) {
    return this.delegate_ && this.delegate_.bitstreamBufferReady && this.delegate_.bitstreamBufferReady(bitstreamBufferId, metadata);
  }
  VideoEncodeAcceleratorClientStub.prototype.notifyErrorStatus = function(status) {
    return this.delegate_ && this.delegate_.notifyErrorStatus && this.delegate_.notifyErrorStatus(status);
  }
  VideoEncodeAcceleratorClientStub.prototype.notifyEncoderInfoChange = function(info) {
    return this.delegate_ && this.delegate_.notifyEncoderInfoChange && this.delegate_.notifyEncoderInfoChange(info);
  }

  VideoEncodeAcceleratorClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kVideoEncodeAcceleratorClient_RequireBitstreamBuffers_Name:
      var params = reader.decodeStruct(VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params);
      this.requireBitstreamBuffers(params.inputCount, params.inputCodedSize, params.outputBufferSize);
      return true;
    case kVideoEncodeAcceleratorClient_BitstreamBufferReady_Name:
      var params = reader.decodeStruct(VideoEncodeAcceleratorClient_BitstreamBufferReady_Params);
      this.bitstreamBufferReady(params.bitstreamBufferId, params.metadata);
      return true;
    case kVideoEncodeAcceleratorClient_NotifyErrorStatus_Name:
      var params = reader.decodeStruct(VideoEncodeAcceleratorClient_NotifyErrorStatus_Params);
      this.notifyErrorStatus(params.status);
      return true;
    case kVideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Name:
      var params = reader.decodeStruct(VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params);
      this.notifyEncoderInfoChange(params.info);
      return true;
    default:
      return false;
    }
  };

  VideoEncodeAcceleratorClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateVideoEncodeAcceleratorClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kVideoEncodeAcceleratorClient_RequireBitstreamBuffers_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params;
      break;
      case kVideoEncodeAcceleratorClient_BitstreamBufferReady_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoEncodeAcceleratorClient_BitstreamBufferReady_Params;
      break;
      case kVideoEncodeAcceleratorClient_NotifyErrorStatus_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoEncodeAcceleratorClient_NotifyErrorStatus_Params;
      break;
      case kVideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateVideoEncodeAcceleratorClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var VideoEncodeAcceleratorClient = {
    name: 'media.mojom.VideoEncodeAcceleratorClient',
    kVersion: 0,
    ptrClass: VideoEncodeAcceleratorClientPtr,
    proxyClass: VideoEncodeAcceleratorClientProxy,
    stubClass: VideoEncodeAcceleratorClientStub,
    validateRequest: validateVideoEncodeAcceleratorClientRequest,
    validateResponse: null,
  };
  VideoEncodeAcceleratorClientStub.prototype.validator = validateVideoEncodeAcceleratorClientRequest;
  VideoEncodeAcceleratorClientProxy.prototype.validator = null;
  exports.VideoEncodeAcceleratorSupportedRateControlMode = VideoEncodeAcceleratorSupportedRateControlMode;
  exports.VideoEncodeAcceleratorSupportedProfile = VideoEncodeAcceleratorSupportedProfile;
  exports.EncodeCommandBufferId = EncodeCommandBufferId;
  exports.VariableBitratePeak = VariableBitratePeak;
  exports.VideoBitrateAllocation = VideoBitrateAllocation;
  exports.SpatialLayer = SpatialLayer;
  exports.ConstantBitrate = ConstantBitrate;
  exports.VariableBitrate = VariableBitrate;
  exports.ExternalBitrate = ExternalBitrate;
  exports.VideoEncodeAcceleratorConfig = VideoEncodeAcceleratorConfig;
  exports.VideoEncodeOptions = VideoEncodeOptions;
  exports.DropFrameMetadata = DropFrameMetadata;
  exports.H264Metadata = H264Metadata;
  exports.Vp8Metadata = Vp8Metadata;
  exports.Vp9Metadata = Vp9Metadata;
  exports.SVCGenericMetadata = SVCGenericMetadata;
  exports.BitstreamBufferMetadata = BitstreamBufferMetadata;
  exports.Bitrate = Bitrate;
  exports.OptionalMetadata = OptionalMetadata;
  exports.VideoEncodeAcceleratorProvider = VideoEncodeAcceleratorProvider;
  exports.VideoEncodeAcceleratorProviderPtr = VideoEncodeAcceleratorProviderPtr;
  exports.VideoEncodeAcceleratorProviderAssociatedPtr = VideoEncodeAcceleratorProviderAssociatedPtr;
  exports.VideoEncodeAcceleratorProviderFactory = VideoEncodeAcceleratorProviderFactory;
  exports.VideoEncodeAcceleratorProviderFactoryPtr = VideoEncodeAcceleratorProviderFactoryPtr;
  exports.VideoEncodeAcceleratorProviderFactoryAssociatedPtr = VideoEncodeAcceleratorProviderFactoryAssociatedPtr;
  exports.VideoEncodeAccelerator = VideoEncodeAccelerator;
  exports.VideoEncodeAcceleratorPtr = VideoEncodeAcceleratorPtr;
  exports.VideoEncodeAcceleratorAssociatedPtr = VideoEncodeAcceleratorAssociatedPtr;
  exports.VideoEncodeAcceleratorClient = VideoEncodeAcceleratorClient;
  exports.VideoEncodeAcceleratorClientPtr = VideoEncodeAcceleratorClientPtr;
  exports.VideoEncodeAcceleratorClientAssociatedPtr = VideoEncodeAcceleratorClientAssociatedPtr;
})();