// services/device/public/mojom/geoposition.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';


/**
 * @const { !number }
 */
export const BAD_LATITUDE_LONGITUDE = 200;


/**
 * @const { !number }
 */
export const BAD_ALTITUDE = -10000;


/**
 * @const { !number }
 */
export const BAD_ACCURACY = -1;


/**
 * @const { !number }
 */
export const BAD_HEADING = -1;


/**
 * @const { !number }
 */
export const BAD_SPEED = -1;


/**
 * @const { !string }
 */
export const GEO_PERMISSION_DENIED_ERROR_MESSAGE = "User denied geolocation permission";


/**
 * @const { !string }
 */
export const GEO_POSITION_UNAVAILABLE_ERROR_MESSAGE = "Position update is unavailable";


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const GeopositionErrorCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const GeopositionErrorCode = {
  
  kPermissionDenied: 1,
  kPositionUnavailable: 2,
  kWifiDisabled: 3,
  MIN_VALUE: 1,
  MAX_VALUE: 3,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GeopositionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GeopositionErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const GeopositionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    GeopositionSpec.$,
    'Geoposition',
    [
      mojo.internal.StructField(
        'latitude', 0,
        0,
        mojo.internal.Double,
        BAD_LATITUDE_LONGITUDE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'longitude', 8,
        0,
        mojo.internal.Double,
        BAD_LATITUDE_LONGITUDE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'altitude', 16,
        0,
        mojo.internal.Double,
        BAD_ALTITUDE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'accuracy', 24,
        0,
        mojo.internal.Double,
        BAD_ACCURACY,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'altitudeAccuracy', 32,
        0,
        mojo.internal.Double,
        BAD_ACCURACY,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'heading', 40,
        0,
        mojo.internal.Double,
        BAD_HEADING,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'speed', 48,
        0,
        mojo.internal.Double,
        BAD_SPEED,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timestamp', 56,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPrecise', 64,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class Geoposition {
  constructor() {
    /** @type { !number } */
    this.latitude;
    /** @type { !number } */
    this.longitude;
    /** @type { !number } */
    this.altitude;
    /** @type { !number } */
    this.accuracy;
    /** @type { !number } */
    this.altitudeAccuracy;
    /** @type { !number } */
    this.heading;
    /** @type { !number } */
    this.speed;
    /** @type { !mojoBase_mojom_Time } */
    this.timestamp;
    /** @type { !boolean } */
    this.isPrecise;
  }
}



mojo.internal.Struct(
    GeopositionErrorSpec.$,
    'GeopositionError',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        GeopositionErrorCodeSpec.$,
        1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorTechnical', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class GeopositionError {
  constructor() {
    /** @type { !GeopositionErrorCode } */
    this.errorCode;
    /** @type { !string } */
    this.errorMessage;
    /** @type { !string } */
    this.errorTechnical;
  }
}

mojo.internal.Union(
    GeopositionResultSpec.$, 'GeopositionResult',
    {
      'position': {
        'ordinal': 0,
        'type': GeopositionSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': GeopositionErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   position: (!Geoposition|undefined),
 *   error: (!GeopositionError|undefined),
 * } }
 */
export const GeopositionResult = {};
