// services/device/public/mojom/nfc_provider.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/device/public/mojom/nfc_provider.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('device.mojom');
  var nfc$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/nfc.mojom', 'nfc.mojom.js');
  }



  function NFCProvider_GetNFCForHost_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFCProvider_GetNFCForHost_Params.prototype.initDefaults_ = function() {
    this.hostId = 0;
    this.receiver = new bindings.InterfaceRequest();
  };
  NFCProvider_GetNFCForHost_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFCProvider_GetNFCForHost_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NFCProvider_GetNFCForHost_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 4, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NFCProvider_GetNFCForHost_Params.encodedSize = codec.kStructHeaderSize + 8;

  NFCProvider_GetNFCForHost_Params.decode = function(decoder) {
    var packed;
    var val = new NFCProvider_GetNFCForHost_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.hostId =
        decoder.decodeStruct(codec.Int32);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    return val;
  };

  NFCProvider_GetNFCForHost_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFCProvider_GetNFCForHost_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.hostId);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
  };
  function NFCProvider_SuspendNFCOperations_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFCProvider_SuspendNFCOperations_Params.prototype.initDefaults_ = function() {
  };
  NFCProvider_SuspendNFCOperations_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFCProvider_SuspendNFCOperations_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NFCProvider_SuspendNFCOperations_Params.encodedSize = codec.kStructHeaderSize + 0;

  NFCProvider_SuspendNFCOperations_Params.decode = function(decoder) {
    var packed;
    var val = new NFCProvider_SuspendNFCOperations_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NFCProvider_SuspendNFCOperations_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFCProvider_SuspendNFCOperations_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NFCProvider_ResumeNFCOperations_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NFCProvider_ResumeNFCOperations_Params.prototype.initDefaults_ = function() {
  };
  NFCProvider_ResumeNFCOperations_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NFCProvider_ResumeNFCOperations_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NFCProvider_ResumeNFCOperations_Params.encodedSize = codec.kStructHeaderSize + 0;

  NFCProvider_ResumeNFCOperations_Params.decode = function(decoder) {
    var packed;
    var val = new NFCProvider_ResumeNFCOperations_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NFCProvider_ResumeNFCOperations_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NFCProvider_ResumeNFCOperations_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kNFCProvider_GetNFCForHost_Name = 0;
  var kNFCProvider_SuspendNFCOperations_Name = 1;
  var kNFCProvider_ResumeNFCOperations_Name = 2;

  function NFCProviderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(NFCProvider,
                                                   handleOrPtrInfo);
  }

  function NFCProviderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        NFCProvider, associatedInterfacePtrInfo);
  }

  NFCProviderAssociatedPtr.prototype =
      Object.create(NFCProviderPtr.prototype);
  NFCProviderAssociatedPtr.prototype.constructor =
      NFCProviderAssociatedPtr;

  function NFCProviderProxy(receiver) {
    this.receiver_ = receiver;
  }
  NFCProviderPtr.prototype.getNFCForHost = function() {
    return NFCProviderProxy.prototype.getNFCForHost
        .apply(this.ptr.getProxy(), arguments);
  };

  NFCProviderProxy.prototype.getNFCForHost = function(hostId, receiver) {
    var params_ = new NFCProvider_GetNFCForHost_Params();
    params_.hostId = hostId;
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kNFCProvider_GetNFCForHost_Name,
        codec.align(NFCProvider_GetNFCForHost_Params.encodedSize));
    builder.encodeStruct(NFCProvider_GetNFCForHost_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NFCProviderPtr.prototype.suspendNFCOperations = function() {
    return NFCProviderProxy.prototype.suspendNFCOperations
        .apply(this.ptr.getProxy(), arguments);
  };

  NFCProviderProxy.prototype.suspendNFCOperations = function() {
    var params_ = new NFCProvider_SuspendNFCOperations_Params();
    var builder = new codec.MessageV0Builder(
        kNFCProvider_SuspendNFCOperations_Name,
        codec.align(NFCProvider_SuspendNFCOperations_Params.encodedSize));
    builder.encodeStruct(NFCProvider_SuspendNFCOperations_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NFCProviderPtr.prototype.resumeNFCOperations = function() {
    return NFCProviderProxy.prototype.resumeNFCOperations
        .apply(this.ptr.getProxy(), arguments);
  };

  NFCProviderProxy.prototype.resumeNFCOperations = function() {
    var params_ = new NFCProvider_ResumeNFCOperations_Params();
    var builder = new codec.MessageV0Builder(
        kNFCProvider_ResumeNFCOperations_Name,
        codec.align(NFCProvider_ResumeNFCOperations_Params.encodedSize));
    builder.encodeStruct(NFCProvider_ResumeNFCOperations_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function NFCProviderStub(delegate) {
    this.delegate_ = delegate;
  }
  NFCProviderStub.prototype.getNFCForHost = function(hostId, receiver) {
    return this.delegate_ && this.delegate_.getNFCForHost && this.delegate_.getNFCForHost(hostId, receiver);
  }
  NFCProviderStub.prototype.suspendNFCOperations = function() {
    return this.delegate_ && this.delegate_.suspendNFCOperations && this.delegate_.suspendNFCOperations();
  }
  NFCProviderStub.prototype.resumeNFCOperations = function() {
    return this.delegate_ && this.delegate_.resumeNFCOperations && this.delegate_.resumeNFCOperations();
  }

  NFCProviderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNFCProvider_GetNFCForHost_Name:
      var params = reader.decodeStruct(NFCProvider_GetNFCForHost_Params);
      this.getNFCForHost(params.hostId, params.receiver);
      return true;
    case kNFCProvider_SuspendNFCOperations_Name:
      var params = reader.decodeStruct(NFCProvider_SuspendNFCOperations_Params);
      this.suspendNFCOperations();
      return true;
    case kNFCProvider_ResumeNFCOperations_Name:
      var params = reader.decodeStruct(NFCProvider_ResumeNFCOperations_Params);
      this.resumeNFCOperations();
      return true;
    default:
      return false;
    }
  };

  NFCProviderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateNFCProviderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kNFCProvider_GetNFCForHost_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NFCProvider_GetNFCForHost_Params;
      break;
      case kNFCProvider_SuspendNFCOperations_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NFCProvider_SuspendNFCOperations_Params;
      break;
      case kNFCProvider_ResumeNFCOperations_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NFCProvider_ResumeNFCOperations_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateNFCProviderResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var NFCProvider = {
    name: 'device.mojom.NFCProvider',
    kVersion: 0,
    ptrClass: NFCProviderPtr,
    proxyClass: NFCProviderProxy,
    stubClass: NFCProviderStub,
    validateRequest: validateNFCProviderRequest,
    validateResponse: null,
  };
  NFCProviderStub.prototype.validator = validateNFCProviderRequest;
  NFCProviderProxy.prototype.validator = null;
  exports.NFCProvider = NFCProvider;
  exports.NFCProviderPtr = NFCProviderPtr;
  exports.NFCProviderAssociatedPtr = NFCProviderAssociatedPtr;
})();