// services/device/public/mojom/pressure_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  PressureSource as device_mojom_PressureSource,
  PressureSourceSpec as device_mojom_PressureSourceSpec,
  PressureState as device_mojom_PressureState,
  PressureStateSpec as device_mojom_PressureStateSpec,
  PressureUpdate as device_mojom_PressureUpdate,
  PressureUpdateSpec as device_mojom_PressureUpdateSpec
} from './pressure_update.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PressureManagerAddClientResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PressureManagerAddClientResult = {
  
  kNotSupported: 0,
  kOk: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PressureManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.PressureManager', scope);
  }
}

/** @interface */
export class PressureManagerInterface {
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } token
   * @param { !device_mojom_PressureSource } source
   * @param { !VirtualPressureSourceMetadata } metadata
   * @return {!Promise}
   */

  addVirtualPressureSource(token, source, metadata) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } token
   * @param { !device_mojom_PressureSource } source
   * @return {!Promise}
   */

  removeVirtualPressureSource(token, source) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } token
   * @param { !device_mojom_PressureSource } source
   * @param { !device_mojom_PressureState } state
   * @param { !number } ownContributionEstimate
   * @return {!Promise}
   */

  updateVirtualPressureSourceData(token, source, state, ownContributionEstimate) {}
  
  /**
   * @param { !device_mojom_PressureSource } source
   * @param { ?mojoBase_mojom_UnguessableToken } token
   * @param { !Object } client
   * @return {!Promise<{
        result: !PressureManagerAddClientResult,
   *  }>}
   */

  addClient(source, token, client) {}
}

/**
 * @implements { PressureManagerInterface }
 */
export class PressureManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PressureManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PressureManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PressureManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } token
   * @param { !device_mojom_PressureSource } source
   * @param { !VirtualPressureSourceMetadata } metadata
   * @return {!Promise}
   */

  addVirtualPressureSource(
      token,
      source,
      metadata) {
    return this.proxy.sendMessage(
        0,
        PressureManager_AddVirtualPressureSource_ParamsSpec.$,
        PressureManager_AddVirtualPressureSource_ResponseParamsSpec.$,
        [
          token,
          source,
          metadata
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } token
   * @param { !device_mojom_PressureSource } source
   * @return {!Promise}
   */

  removeVirtualPressureSource(
      token,
      source) {
    return this.proxy.sendMessage(
        1,
        PressureManager_RemoveVirtualPressureSource_ParamsSpec.$,
        PressureManager_RemoveVirtualPressureSource_ResponseParamsSpec.$,
        [
          token,
          source
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } token
   * @param { !device_mojom_PressureSource } source
   * @param { !device_mojom_PressureState } state
   * @param { !number } ownContributionEstimate
   * @return {!Promise}
   */

  updateVirtualPressureSourceData(
      token,
      source,
      state,
      ownContributionEstimate) {
    return this.proxy.sendMessage(
        2,
        PressureManager_UpdateVirtualPressureSourceData_ParamsSpec.$,
        PressureManager_UpdateVirtualPressureSourceData_ResponseParamsSpec.$,
        [
          token,
          source,
          state,
          ownContributionEstimate
        ],
        false);
  }

  
  /**
   * @param { !device_mojom_PressureSource } source
   * @param { ?mojoBase_mojom_UnguessableToken } token
   * @param { !Object } client
   * @return {!Promise<{
        result: !PressureManagerAddClientResult,
   *  }>}
   */

  addClient(
      source,
      token,
      client) {
    return this.proxy.sendMessage(
        3,
        PressureManager_AddClient_ParamsSpec.$,
        PressureManager_AddClient_ResponseParamsSpec.$,
        [
          source,
          token,
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PressureManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PressureManagerReceiver {
  /**
   * @param {!PressureManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PressureManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PressureManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PressureManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PressureManager_AddVirtualPressureSource_ParamsSpec.$,
        PressureManager_AddVirtualPressureSource_ResponseParamsSpec.$,
        impl.addVirtualPressureSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PressureManager_RemoveVirtualPressureSource_ParamsSpec.$,
        PressureManager_RemoveVirtualPressureSource_ResponseParamsSpec.$,
        impl.removeVirtualPressureSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PressureManager_UpdateVirtualPressureSourceData_ParamsSpec.$,
        PressureManager_UpdateVirtualPressureSourceData_ResponseParamsSpec.$,
        impl.updateVirtualPressureSourceData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PressureManager_AddClient_ParamsSpec.$,
        PressureManager_AddClient_ResponseParamsSpec.$,
        impl.addClient.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PressureManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.PressureManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PressureManagerRemote}
   */
  static getRemote() {
    let remote = new PressureManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PressureManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PressureManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PressureManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PressureManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addVirtualPressureSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PressureManager_AddVirtualPressureSource_ParamsSpec.$,
        PressureManager_AddVirtualPressureSource_ResponseParamsSpec.$,
        this.addVirtualPressureSource.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeVirtualPressureSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PressureManager_RemoveVirtualPressureSource_ParamsSpec.$,
        PressureManager_RemoveVirtualPressureSource_ResponseParamsSpec.$,
        this.removeVirtualPressureSource.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateVirtualPressureSourceData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PressureManager_UpdateVirtualPressureSourceData_ParamsSpec.$,
        PressureManager_UpdateVirtualPressureSourceData_ResponseParamsSpec.$,
        this.updateVirtualPressureSourceData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PressureManager_AddClient_ParamsSpec.$,
        PressureManager_AddClient_ResponseParamsSpec.$,
        this.addClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PressureClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.PressureClient', scope);
  }
}

/** @interface */
export class PressureClientInterface {
  
  /**
   * @param { !device_mojom_PressureUpdate } update
   */

  onPressureUpdated(update) {}
}

/**
 * @implements { PressureClientInterface }
 */
export class PressureClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PressureClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PressureClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PressureClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device_mojom_PressureUpdate } update
   */

  onPressureUpdated(
      update) {
    this.proxy.sendMessage(
        0,
        PressureClient_OnPressureUpdated_ParamsSpec.$,
        null,
        [
          update
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PressureClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PressureClientReceiver {
  /**
   * @param {!PressureClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PressureClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PressureClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PressureClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PressureClient_OnPressureUpdated_ParamsSpec.$,
        null,
        impl.onPressureUpdated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PressureClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.PressureClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PressureClientRemote}
   */
  static getRemote() {
    let remote = new PressureClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PressureClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PressureClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PressureClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PressureClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPressureUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PressureClient_OnPressureUpdated_ParamsSpec.$,
        null,
        this.onPressureUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VirtualPressureSourceMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PressureManager_AddVirtualPressureSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PressureManager_AddVirtualPressureSource_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PressureManager_RemoveVirtualPressureSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PressureManager_RemoveVirtualPressureSource_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PressureManager_UpdateVirtualPressureSourceData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PressureManager_UpdateVirtualPressureSourceData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PressureManager_AddClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PressureManager_AddClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PressureClient_OnPressureUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    VirtualPressureSourceMetadataSpec.$,
    'VirtualPressureSourceMetadata',
    [
      mojo.internal.StructField(
        'available', 0,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VirtualPressureSourceMetadata {
  constructor() {
    /** @type { !boolean } */
    this.available;
  }
}



mojo.internal.Struct(
    PressureManager_AddVirtualPressureSource_ParamsSpec.$,
    'PressureManager_AddVirtualPressureSource_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        device_mojom_PressureSourceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metadata', 16,
        0,
        VirtualPressureSourceMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PressureManager_AddVirtualPressureSource_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.token;
    /** @type { !device_mojom_PressureSource } */
    this.source;
    /** @type { !VirtualPressureSourceMetadata } */
    this.metadata;
  }
}



mojo.internal.Struct(
    PressureManager_AddVirtualPressureSource_ResponseParamsSpec.$,
    'PressureManager_AddVirtualPressureSource_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PressureManager_AddVirtualPressureSource_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    PressureManager_RemoveVirtualPressureSource_ParamsSpec.$,
    'PressureManager_RemoveVirtualPressureSource_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        device_mojom_PressureSourceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PressureManager_RemoveVirtualPressureSource_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.token;
    /** @type { !device_mojom_PressureSource } */
    this.source;
  }
}



mojo.internal.Struct(
    PressureManager_RemoveVirtualPressureSource_ResponseParamsSpec.$,
    'PressureManager_RemoveVirtualPressureSource_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PressureManager_RemoveVirtualPressureSource_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    PressureManager_UpdateVirtualPressureSourceData_ParamsSpec.$,
    'PressureManager_UpdateVirtualPressureSourceData_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        device_mojom_PressureSourceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'state', 12,
        0,
        device_mojom_PressureStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ownContributionEstimate', 16,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PressureManager_UpdateVirtualPressureSourceData_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.token;
    /** @type { !device_mojom_PressureSource } */
    this.source;
    /** @type { !device_mojom_PressureState } */
    this.state;
    /** @type { !number } */
    this.ownContributionEstimate;
  }
}



mojo.internal.Struct(
    PressureManager_UpdateVirtualPressureSourceData_ResponseParamsSpec.$,
    'PressureManager_UpdateVirtualPressureSourceData_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PressureManager_UpdateVirtualPressureSourceData_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    PressureManager_AddClient_ParamsSpec.$,
    'PressureManager_AddClient_Params',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        device_mojom_PressureSourceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'token', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 16,
        0,
        mojo.internal.AssociatedInterfaceProxy(PressureClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PressureManager_AddClient_Params {
  constructor() {
    /** @type { !device_mojom_PressureSource } */
    this.source;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.token;
    /** @type { !Object } */
    this.client;
  }
}



mojo.internal.Struct(
    PressureManager_AddClient_ResponseParamsSpec.$,
    'PressureManager_AddClient_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        PressureManagerAddClientResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PressureManager_AddClient_ResponseParams {
  constructor() {
    /** @type { !PressureManagerAddClientResult } */
    this.result;
  }
}



mojo.internal.Struct(
    PressureClient_OnPressureUpdated_ParamsSpec.$,
    'PressureClient_OnPressureUpdated_Params',
    [
      mojo.internal.StructField(
        'update', 0,
        0,
        device_mojom_PressureUpdateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PressureClient_OnPressureUpdated_Params {
  constructor() {
    /** @type { !device_mojom_PressureUpdate } */
    this.update;
  }
}

