// services/device/public/mojom/serial.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  UUID as bluetooth_mojom_UUID,
  UUIDSpec as bluetooth_mojom_UUIDSpec
} from '../../../../device/bluetooth/public/mojom/uuid.mojom.m.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SerialSendErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SerialSendError = {
  
  NONE: 0,
  DISCONNECTED: 1,
  SYSTEM_ERROR: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SerialReceiveErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SerialReceiveError = {
  
  NONE: 0,
  DISCONNECTED: 1,
  DEVICE_LOST: 2,
  BREAK: 3,
  FRAME_ERROR: 4,
  OVERRUN: 5,
  BUFFER_OVERFLOW: 6,
  PARITY_ERROR: 7,
  SYSTEM_ERROR: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SerialDataBitsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SerialDataBits = {
  
  NONE: 0,
  SEVEN: 1,
  EIGHT: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SerialParityBitSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SerialParityBit = {
  
  NONE: 0,
  NO_PARITY: 1,
  ODD: 2,
  EVEN: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SerialStopBitsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SerialStopBits = {
  
  NONE: 0,
  ONE: 1,
  TWO: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SerialPortFlushModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SerialPortFlushMode = {
  
  kReceiveAndTransmit: 0,
  kReceive: 1,
  kTransmit: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SerialPortTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SerialPortType = {
  
  PLATFORM_SERIAL: 0,
  BLUETOOTH_CLASSIC_RFCOMM: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SerialPortManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.SerialPortManager', scope);
  }
}

/** @interface */
export class SerialPortManagerInterface {
  
  /**
   * @param { !SerialPortManagerClientRemote } client
   */

  setClient(client) {}
  
  /**
   * @return {!Promise<{
        devices: !Array<!SerialPortInfo>,
   *  }>}
   */

  getDevices() {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } token
   * @param { !boolean } useAlternatePath
   * @param { !SerialConnectionOptions } options
   * @param { !SerialPortClientRemote } client
   * @param { ?SerialPortConnectionWatcherRemote } watcher
   * @return {!Promise<{
        port: ?SerialPortRemote,
   *  }>}
   */

  openPort(token, useAlternatePath, options, client, watcher) {}
}

/**
 * @implements { SerialPortManagerInterface }
 */
export class SerialPortManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SerialPortManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SerialPortManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SerialPortManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SerialPortManagerClientRemote } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        0,
        SerialPortManager_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        devices: !Array<!SerialPortInfo>,
   *  }>}
   */

  getDevices() {
    return this.proxy.sendMessage(
        1,
        SerialPortManager_GetDevices_ParamsSpec.$,
        SerialPortManager_GetDevices_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } token
   * @param { !boolean } useAlternatePath
   * @param { !SerialConnectionOptions } options
   * @param { !SerialPortClientRemote } client
   * @param { ?SerialPortConnectionWatcherRemote } watcher
   * @return {!Promise<{
        port: ?SerialPortRemote,
   *  }>}
   */

  openPort(
      token,
      useAlternatePath,
      options,
      client,
      watcher) {
    return this.proxy.sendMessage(
        2,
        SerialPortManager_OpenPort_ParamsSpec.$,
        SerialPortManager_OpenPort_ResponseParamsSpec.$,
        [
          token,
          useAlternatePath,
          options,
          client,
          watcher
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SerialPortManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SerialPortManagerReceiver {
  /**
   * @param {!SerialPortManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SerialPortManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SerialPortManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialPortManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SerialPortManager_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SerialPortManager_GetDevices_ParamsSpec.$,
        SerialPortManager_GetDevices_ResponseParamsSpec.$,
        impl.getDevices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SerialPortManager_OpenPort_ParamsSpec.$,
        SerialPortManager_OpenPort_ResponseParamsSpec.$,
        impl.openPort.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SerialPortManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SerialPortManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SerialPortManagerRemote}
   */
  static getRemote() {
    let remote = new SerialPortManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SerialPortManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SerialPortManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SerialPortManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialPortManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SerialPortManager_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SerialPortManager_GetDevices_ParamsSpec.$,
        SerialPortManager_GetDevices_ResponseParamsSpec.$,
        this.getDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openPort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SerialPortManager_OpenPort_ParamsSpec.$,
        SerialPortManager_OpenPort_ResponseParamsSpec.$,
        this.openPort.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SerialPortManagerClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.SerialPortManagerClient', scope);
  }
}

/** @interface */
export class SerialPortManagerClientInterface {
  
  /**
   * @param { !SerialPortInfo } portInfo
   */

  onPortAdded(portInfo) {}
  
  /**
   * @param { !SerialPortInfo } portInfo
   */

  onPortRemoved(portInfo) {}
  
  /**
   * @param { !SerialPortInfo } portInfo
   */

  onPortConnectedStateChanged(portInfo) {}
}

/**
 * @implements { SerialPortManagerClientInterface }
 */
export class SerialPortManagerClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SerialPortManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SerialPortManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SerialPortManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SerialPortInfo } portInfo
   */

  onPortAdded(
      portInfo) {
    this.proxy.sendMessage(
        0,
        SerialPortManagerClient_OnPortAdded_ParamsSpec.$,
        null,
        [
          portInfo
        ],
        false);
  }

  
  /**
   * @param { !SerialPortInfo } portInfo
   */

  onPortRemoved(
      portInfo) {
    this.proxy.sendMessage(
        1,
        SerialPortManagerClient_OnPortRemoved_ParamsSpec.$,
        null,
        [
          portInfo
        ],
        false);
  }

  
  /**
   * @param { !SerialPortInfo } portInfo
   */

  onPortConnectedStateChanged(
      portInfo) {
    this.proxy.sendMessage(
        2,
        SerialPortManagerClient_OnPortConnectedStateChanged_ParamsSpec.$,
        null,
        [
          portInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SerialPortManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SerialPortManagerClientReceiver {
  /**
   * @param {!SerialPortManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SerialPortManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SerialPortManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialPortManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SerialPortManagerClient_OnPortAdded_ParamsSpec.$,
        null,
        impl.onPortAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SerialPortManagerClient_OnPortRemoved_ParamsSpec.$,
        null,
        impl.onPortRemoved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SerialPortManagerClient_OnPortConnectedStateChanged_ParamsSpec.$,
        null,
        impl.onPortConnectedStateChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SerialPortManagerClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SerialPortManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SerialPortManagerClientRemote}
   */
  static getRemote() {
    let remote = new SerialPortManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SerialPortManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SerialPortManagerClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SerialPortManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialPortManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPortAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SerialPortManagerClient_OnPortAdded_ParamsSpec.$,
        null,
        this.onPortAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPortRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SerialPortManagerClient_OnPortRemoved_ParamsSpec.$,
        null,
        this.onPortRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPortConnectedStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SerialPortManagerClient_OnPortConnectedStateChanged_ParamsSpec.$,
        null,
        this.onPortConnectedStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SerialPortPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.SerialPort', scope);
  }
}

/** @interface */
export class SerialPortInterface {
  
  /**
   * @param { !MojoHandle } consumer
   */

  startWriting(consumer) {}
  
  /**
   * @param { !MojoHandle } producer
   */

  startReading(producer) {}
  
  /**
   * @param { !SerialPortFlushMode } mode
   * @return {!Promise}
   */

  flush(mode) {}
  
  /**
   * @return {!Promise}
   */

  drain() {}
  
  /**
   * @return {!Promise<{
        signals: ?SerialPortControlSignals,
   *  }>}
   */

  getControlSignals() {}
  
  /**
   * @param { !SerialHostControlSignals } signals
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setControlSignals(signals) {}
  
  /**
   * @param { !SerialConnectionOptions } options
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  configurePort(options) {}
  
  /**
   * @return {!Promise<{
        info: !SerialConnectionInfo,
   *  }>}
   */

  getPortInfo() {}
  
  /**
   * @param { !boolean } flush
   * @return {!Promise}
   */

  close(flush) {}
}

/**
 * @implements { SerialPortInterface }
 */
export class SerialPortRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SerialPortPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SerialPortPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SerialPortPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !MojoHandle } consumer
   */

  startWriting(
      consumer) {
    this.proxy.sendMessage(
        0,
        SerialPort_StartWriting_ParamsSpec.$,
        null,
        [
          consumer
        ],
        false);
  }

  
  /**
   * @param { !MojoHandle } producer
   */

  startReading(
      producer) {
    this.proxy.sendMessage(
        1,
        SerialPort_StartReading_ParamsSpec.$,
        null,
        [
          producer
        ],
        false);
  }

  
  /**
   * @param { !SerialPortFlushMode } mode
   * @return {!Promise}
   */

  flush(
      mode) {
    return this.proxy.sendMessage(
        2,
        SerialPort_Flush_ParamsSpec.$,
        SerialPort_Flush_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  drain() {
    return this.proxy.sendMessage(
        3,
        SerialPort_Drain_ParamsSpec.$,
        SerialPort_Drain_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        signals: ?SerialPortControlSignals,
   *  }>}
   */

  getControlSignals() {
    return this.proxy.sendMessage(
        4,
        SerialPort_GetControlSignals_ParamsSpec.$,
        SerialPort_GetControlSignals_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !SerialHostControlSignals } signals
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setControlSignals(
      signals) {
    return this.proxy.sendMessage(
        5,
        SerialPort_SetControlSignals_ParamsSpec.$,
        SerialPort_SetControlSignals_ResponseParamsSpec.$,
        [
          signals
        ],
        false);
  }

  
  /**
   * @param { !SerialConnectionOptions } options
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  configurePort(
      options) {
    return this.proxy.sendMessage(
        6,
        SerialPort_ConfigurePort_ParamsSpec.$,
        SerialPort_ConfigurePort_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        info: !SerialConnectionInfo,
   *  }>}
   */

  getPortInfo() {
    return this.proxy.sendMessage(
        7,
        SerialPort_GetPortInfo_ParamsSpec.$,
        SerialPort_GetPortInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } flush
   * @return {!Promise}
   */

  close(
      flush) {
    return this.proxy.sendMessage(
        8,
        SerialPort_Close_ParamsSpec.$,
        SerialPort_Close_ResponseParamsSpec.$,
        [
          flush
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SerialPort
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SerialPortReceiver {
  /**
   * @param {!SerialPortInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SerialPortRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SerialPortRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialPortRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SerialPort_StartWriting_ParamsSpec.$,
        null,
        impl.startWriting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SerialPort_StartReading_ParamsSpec.$,
        null,
        impl.startReading.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SerialPort_Flush_ParamsSpec.$,
        SerialPort_Flush_ResponseParamsSpec.$,
        impl.flush.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SerialPort_Drain_ParamsSpec.$,
        SerialPort_Drain_ResponseParamsSpec.$,
        impl.drain.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        SerialPort_GetControlSignals_ParamsSpec.$,
        SerialPort_GetControlSignals_ResponseParamsSpec.$,
        impl.getControlSignals.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        SerialPort_SetControlSignals_ParamsSpec.$,
        SerialPort_SetControlSignals_ResponseParamsSpec.$,
        impl.setControlSignals.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        SerialPort_ConfigurePort_ParamsSpec.$,
        SerialPort_ConfigurePort_ResponseParamsSpec.$,
        impl.configurePort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        SerialPort_GetPortInfo_ParamsSpec.$,
        SerialPort_GetPortInfo_ResponseParamsSpec.$,
        impl.getPortInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        SerialPort_Close_ParamsSpec.$,
        SerialPort_Close_ResponseParamsSpec.$,
        impl.close.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SerialPort {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SerialPort";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SerialPortRemote}
   */
  static getRemote() {
    let remote = new SerialPortRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SerialPort
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SerialPortCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SerialPortRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialPortRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startWriting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SerialPort_StartWriting_ParamsSpec.$,
        null,
        this.startWriting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startReading =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SerialPort_StartReading_ParamsSpec.$,
        null,
        this.startReading.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SerialPort_Flush_ParamsSpec.$,
        SerialPort_Flush_ResponseParamsSpec.$,
        this.flush.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.drain =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SerialPort_Drain_ParamsSpec.$,
        SerialPort_Drain_ResponseParamsSpec.$,
        this.drain.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getControlSignals =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SerialPort_GetControlSignals_ParamsSpec.$,
        SerialPort_GetControlSignals_ResponseParamsSpec.$,
        this.getControlSignals.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setControlSignals =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        SerialPort_SetControlSignals_ParamsSpec.$,
        SerialPort_SetControlSignals_ResponseParamsSpec.$,
        this.setControlSignals.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.configurePort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        SerialPort_ConfigurePort_ParamsSpec.$,
        SerialPort_ConfigurePort_ResponseParamsSpec.$,
        this.configurePort.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPortInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        SerialPort_GetPortInfo_ParamsSpec.$,
        SerialPort_GetPortInfo_ResponseParamsSpec.$,
        this.getPortInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        SerialPort_Close_ParamsSpec.$,
        SerialPort_Close_ResponseParamsSpec.$,
        this.close.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SerialPortClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.SerialPortClient', scope);
  }
}

/** @interface */
export class SerialPortClientInterface {
  
  /**
   * @param { !SerialReceiveError } error
   */

  onReadError(error) {}
  
  /**
   * @param { !SerialSendError } error
   */

  onSendError(error) {}
}

/**
 * @implements { SerialPortClientInterface }
 */
export class SerialPortClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SerialPortClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SerialPortClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SerialPortClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SerialReceiveError } error
   */

  onReadError(
      error) {
    this.proxy.sendMessage(
        0,
        SerialPortClient_OnReadError_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }

  
  /**
   * @param { !SerialSendError } error
   */

  onSendError(
      error) {
    this.proxy.sendMessage(
        1,
        SerialPortClient_OnSendError_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SerialPortClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SerialPortClientReceiver {
  /**
   * @param {!SerialPortClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SerialPortClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SerialPortClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialPortClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SerialPortClient_OnReadError_ParamsSpec.$,
        null,
        impl.onReadError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SerialPortClient_OnSendError_ParamsSpec.$,
        null,
        impl.onSendError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SerialPortClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SerialPortClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SerialPortClientRemote}
   */
  static getRemote() {
    let remote = new SerialPortClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SerialPortClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SerialPortClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SerialPortClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialPortClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReadError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SerialPortClient_OnReadError_ParamsSpec.$,
        null,
        this.onReadError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSendError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SerialPortClient_OnSendError_ParamsSpec.$,
        null,
        this.onSendError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SerialPortConnectionWatcherPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.SerialPortConnectionWatcher', scope);
  }
}

/** @interface */
export class SerialPortConnectionWatcherInterface {
}

/**
 * @implements { SerialPortConnectionWatcherInterface }
 */
export class SerialPortConnectionWatcherRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SerialPortConnectionWatcherPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SerialPortConnectionWatcherPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SerialPortConnectionWatcherPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
}

/**
 * An object which receives request messages for the SerialPortConnectionWatcher
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SerialPortConnectionWatcherReceiver {
  /**
   * @param {!SerialPortConnectionWatcherInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SerialPortConnectionWatcherRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SerialPortConnectionWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialPortConnectionWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SerialPortConnectionWatcher {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SerialPortConnectionWatcher";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SerialPortConnectionWatcherRemote}
   */
  static getRemote() {
    let remote = new SerialPortConnectionWatcherRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SerialPortConnectionWatcher
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SerialPortConnectionWatcherCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SerialPortConnectionWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialPortConnectionWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialConnectionOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialConnectionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialHostControlSignalsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortControlSignalsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortManager_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortManager_GetDevices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortManager_GetDevices_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortManager_OpenPort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortManager_OpenPort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortManagerClient_OnPortAdded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortManagerClient_OnPortRemoved_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortManagerClient_OnPortConnectedStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_StartWriting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_StartReading_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_Flush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_Flush_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_Drain_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_Drain_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_GetControlSignals_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_GetControlSignals_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_SetControlSignals_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_SetControlSignals_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_ConfigurePort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_ConfigurePort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_GetPortInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_GetPortInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_Close_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPort_Close_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortClient_OnReadError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortClient_OnSendError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SerialPortInfoSpec.$,
    'SerialPortInfo',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'path', 8,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 16,
        0,
        SerialPortTypeSpec.$,
        SerialPortType.PLATFORM_SERIAL,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'vendorId', 20,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasVendorId', 22,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'productId', 24,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasProductId', 22,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bluetoothServiceClassId', 32,
        0,
        bluetooth_mojom_UUIDSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'displayName', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serialNumber', 48,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connected', 22,
        2,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class SerialPortInfo {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.token;
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
    /** @type { !SerialPortType } */
    this.type;
    /** @type { !number } */
    this.vendorId;
    /** @type { !boolean } */
    this.hasVendorId;
    /** @type { !number } */
    this.productId;
    /** @type { !boolean } */
    this.hasProductId;
    /** @type { (bluetooth_mojom_UUID|undefined) } */
    this.bluetoothServiceClassId;
    /** @type { (string|undefined) } */
    this.displayName;
    /** @type { (string|undefined) } */
    this.serialNumber;
    /** @type { !boolean } */
    this.connected;
  }
}



mojo.internal.Struct(
    SerialConnectionOptionsSpec.$,
    'SerialConnectionOptions',
    [
      mojo.internal.StructField(
        'bitrate', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataBits', 4,
        0,
        SerialDataBitsSpec.$,
        SerialDataBits.NONE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'parityBit', 8,
        0,
        SerialParityBitSpec.$,
        SerialParityBit.NONE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stopBits', 12,
        0,
        SerialStopBitsSpec.$,
        SerialStopBits.NONE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ctsFlowControl', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasCtsFlowControl', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SerialConnectionOptions {
  constructor() {
    /** @type { !number } */
    this.bitrate;
    /** @type { !SerialDataBits } */
    this.dataBits;
    /** @type { !SerialParityBit } */
    this.parityBit;
    /** @type { !SerialStopBits } */
    this.stopBits;
    /** @type { !boolean } */
    this.ctsFlowControl;
    /** @type { !boolean } */
    this.hasCtsFlowControl;
  }
}



mojo.internal.Struct(
    SerialConnectionInfoSpec.$,
    'SerialConnectionInfo',
    [
      mojo.internal.StructField(
        'bitrate', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataBits', 4,
        0,
        SerialDataBitsSpec.$,
        SerialDataBits.NONE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'parityBit', 8,
        0,
        SerialParityBitSpec.$,
        SerialParityBit.NONE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stopBits', 12,
        0,
        SerialStopBitsSpec.$,
        SerialStopBits.NONE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ctsFlowControl', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SerialConnectionInfo {
  constructor() {
    /** @type { !number } */
    this.bitrate;
    /** @type { !SerialDataBits } */
    this.dataBits;
    /** @type { !SerialParityBit } */
    this.parityBit;
    /** @type { !SerialStopBits } */
    this.stopBits;
    /** @type { !boolean } */
    this.ctsFlowControl;
  }
}



mojo.internal.Struct(
    SerialHostControlSignalsSpec.$,
    'SerialHostControlSignals',
    [
      mojo.internal.StructField(
        'dtr', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasDtr', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rts', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasRts', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'brk', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasBrk', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialHostControlSignals {
  constructor() {
    /** @type { !boolean } */
    this.dtr;
    /** @type { !boolean } */
    this.hasDtr;
    /** @type { !boolean } */
    this.rts;
    /** @type { !boolean } */
    this.hasRts;
    /** @type { !boolean } */
    this.brk;
    /** @type { !boolean } */
    this.hasBrk;
  }
}



mojo.internal.Struct(
    SerialPortControlSignalsSpec.$,
    'SerialPortControlSignals',
    [
      mojo.internal.StructField(
        'dcd', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cts', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ri', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dsr', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPortControlSignals {
  constructor() {
    /** @type { !boolean } */
    this.dcd;
    /** @type { !boolean } */
    this.cts;
    /** @type { !boolean } */
    this.ri;
    /** @type { !boolean } */
    this.dsr;
  }
}



mojo.internal.Struct(
    SerialPortManager_SetClient_ParamsSpec.$,
    'SerialPortManager_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(SerialPortManagerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPortManager_SetClient_Params {
  constructor() {
    /** @type { !SerialPortManagerClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    SerialPortManager_GetDevices_ParamsSpec.$,
    'SerialPortManager_GetDevices_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SerialPortManager_GetDevices_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SerialPortManager_GetDevices_ResponseParamsSpec.$,
    'SerialPortManager_GetDevices_ResponseParams',
    [
      mojo.internal.StructField(
        'devices', 0,
        0,
        mojo.internal.Array(SerialPortInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPortManager_GetDevices_ResponseParams {
  constructor() {
    /** @type { !Array<!SerialPortInfo> } */
    this.devices;
  }
}



mojo.internal.Struct(
    SerialPortManager_OpenPort_ParamsSpec.$,
    'SerialPortManager_OpenPort_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'useAlternatePath', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 16,
        0,
        SerialConnectionOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 24,
        0,
        mojo.internal.InterfaceProxy(SerialPortClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'watcher', 32,
        0,
        mojo.internal.InterfaceProxy(SerialPortConnectionWatcherRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class SerialPortManager_OpenPort_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.token;
    /** @type { !boolean } */
    this.useAlternatePath;
    /** @type { !SerialConnectionOptions } */
    this.options;
    /** @type { !SerialPortClientRemote } */
    this.client;
    /** @type { (SerialPortConnectionWatcherRemote|undefined) } */
    this.watcher;
  }
}



mojo.internal.Struct(
    SerialPortManager_OpenPort_ResponseParamsSpec.$,
    'SerialPortManager_OpenPort_ResponseParams',
    [
      mojo.internal.StructField(
        'port', 0,
        0,
        mojo.internal.InterfaceProxy(SerialPortRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPortManager_OpenPort_ResponseParams {
  constructor() {
    /** @type { (SerialPortRemote|undefined) } */
    this.port;
  }
}



mojo.internal.Struct(
    SerialPortManagerClient_OnPortAdded_ParamsSpec.$,
    'SerialPortManagerClient_OnPortAdded_Params',
    [
      mojo.internal.StructField(
        'portInfo', 0,
        0,
        SerialPortInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPortManagerClient_OnPortAdded_Params {
  constructor() {
    /** @type { !SerialPortInfo } */
    this.portInfo;
  }
}



mojo.internal.Struct(
    SerialPortManagerClient_OnPortRemoved_ParamsSpec.$,
    'SerialPortManagerClient_OnPortRemoved_Params',
    [
      mojo.internal.StructField(
        'portInfo', 0,
        0,
        SerialPortInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPortManagerClient_OnPortRemoved_Params {
  constructor() {
    /** @type { !SerialPortInfo } */
    this.portInfo;
  }
}



mojo.internal.Struct(
    SerialPortManagerClient_OnPortConnectedStateChanged_ParamsSpec.$,
    'SerialPortManagerClient_OnPortConnectedStateChanged_Params',
    [
      mojo.internal.StructField(
        'portInfo', 0,
        0,
        SerialPortInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPortManagerClient_OnPortConnectedStateChanged_Params {
  constructor() {
    /** @type { !SerialPortInfo } */
    this.portInfo;
  }
}



mojo.internal.Struct(
    SerialPort_StartWriting_ParamsSpec.$,
    'SerialPort_StartWriting_Params',
    [
      mojo.internal.StructField(
        'consumer', 0,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPort_StartWriting_Params {
  constructor() {
    /** @type { !MojoHandle } */
    this.consumer;
  }
}



mojo.internal.Struct(
    SerialPort_StartReading_ParamsSpec.$,
    'SerialPort_StartReading_Params',
    [
      mojo.internal.StructField(
        'producer', 0,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPort_StartReading_Params {
  constructor() {
    /** @type { !MojoHandle } */
    this.producer;
  }
}



mojo.internal.Struct(
    SerialPort_Flush_ParamsSpec.$,
    'SerialPort_Flush_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        SerialPortFlushModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPort_Flush_Params {
  constructor() {
    /** @type { !SerialPortFlushMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    SerialPort_Flush_ResponseParamsSpec.$,
    'SerialPort_Flush_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SerialPort_Flush_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    SerialPort_Drain_ParamsSpec.$,
    'SerialPort_Drain_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SerialPort_Drain_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SerialPort_Drain_ResponseParamsSpec.$,
    'SerialPort_Drain_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SerialPort_Drain_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    SerialPort_GetControlSignals_ParamsSpec.$,
    'SerialPort_GetControlSignals_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SerialPort_GetControlSignals_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SerialPort_GetControlSignals_ResponseParamsSpec.$,
    'SerialPort_GetControlSignals_ResponseParams',
    [
      mojo.internal.StructField(
        'signals', 0,
        0,
        SerialPortControlSignalsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPort_GetControlSignals_ResponseParams {
  constructor() {
    /** @type { (SerialPortControlSignals|undefined) } */
    this.signals;
  }
}



mojo.internal.Struct(
    SerialPort_SetControlSignals_ParamsSpec.$,
    'SerialPort_SetControlSignals_Params',
    [
      mojo.internal.StructField(
        'signals', 0,
        0,
        SerialHostControlSignalsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPort_SetControlSignals_Params {
  constructor() {
    /** @type { !SerialHostControlSignals } */
    this.signals;
  }
}



mojo.internal.Struct(
    SerialPort_SetControlSignals_ResponseParamsSpec.$,
    'SerialPort_SetControlSignals_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPort_SetControlSignals_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    SerialPort_ConfigurePort_ParamsSpec.$,
    'SerialPort_ConfigurePort_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        SerialConnectionOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPort_ConfigurePort_Params {
  constructor() {
    /** @type { !SerialConnectionOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    SerialPort_ConfigurePort_ResponseParamsSpec.$,
    'SerialPort_ConfigurePort_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPort_ConfigurePort_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    SerialPort_GetPortInfo_ParamsSpec.$,
    'SerialPort_GetPortInfo_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SerialPort_GetPortInfo_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SerialPort_GetPortInfo_ResponseParamsSpec.$,
    'SerialPort_GetPortInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        SerialConnectionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPort_GetPortInfo_ResponseParams {
  constructor() {
    /** @type { !SerialConnectionInfo } */
    this.info;
  }
}



mojo.internal.Struct(
    SerialPort_Close_ParamsSpec.$,
    'SerialPort_Close_Params',
    [
      mojo.internal.StructField(
        'flush', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPort_Close_Params {
  constructor() {
    /** @type { !boolean } */
    this.flush;
  }
}



mojo.internal.Struct(
    SerialPort_Close_ResponseParamsSpec.$,
    'SerialPort_Close_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SerialPort_Close_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    SerialPortClient_OnReadError_ParamsSpec.$,
    'SerialPortClient_OnReadError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        SerialReceiveErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPortClient_OnReadError_Params {
  constructor() {
    /** @type { !SerialReceiveError } */
    this.error;
  }
}



mojo.internal.Struct(
    SerialPortClient_OnSendError_ParamsSpec.$,
    'SerialPortClient_OnSendError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        SerialSendErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialPortClient_OnSendError_Params {
  constructor() {
    /** @type { !SerialSendError } */
    this.error;
  }
}

