// services/device/public/mojom/wake_lock.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('device.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.WakeLockTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.WakeLockType = {
  
  kPreventAppSuspension: 0,
  kPreventDisplaySleep: 1,
  kPreventDisplaySleepAllowDimming: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.WakeLockReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.WakeLockReason = {
  
  kAudioPlayback: 0,
  kVideoPlayback: 1,
  kOther: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.WakeLockPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.WakeLock.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { device.mojom.WakeLockInterface }
 */
device.mojom.WakeLockRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.WakeLockPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.WakeLockPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.WakeLockPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  requestWakeLock() {
    this.proxy.sendMessage(
        0,
        device.mojom.WakeLock_RequestWakeLock_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  cancelWakeLock() {
    this.proxy.sendMessage(
        1,
        device.mojom.WakeLock_CancelWakeLock_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.WakeLockPendingReceiver } wakeLock
   */

  addClient(
      wakeLock) {
    this.proxy.sendMessage(
        2,
        device.mojom.WakeLock_AddClient_ParamsSpec.$,
        null,
        [
          wakeLock
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.WakeLockType } type
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  changeType(
      type) {
    return this.proxy.sendMessage(
        3,
        device.mojom.WakeLock_ChangeType_ParamsSpec.$,
        device.mojom.WakeLock_ChangeType_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  hasWakeLockForTests() {
    return this.proxy.sendMessage(
        4,
        device.mojom.WakeLock_HasWakeLockForTests_ParamsSpec.$,
        device.mojom.WakeLock_HasWakeLockForTests_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WakeLock
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.WakeLockReceiver = class {
  /**
   * @param {!device.mojom.WakeLockInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.WakeLockRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.WakeLockRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.WakeLockRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.WakeLock_RequestWakeLock_ParamsSpec.$,
        null,
        impl.requestWakeLock.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.WakeLock_CancelWakeLock_ParamsSpec.$,
        null,
        impl.cancelWakeLock.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.WakeLock_AddClient_ParamsSpec.$,
        null,
        impl.addClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.WakeLock_ChangeType_ParamsSpec.$,
        device.mojom.WakeLock_ChangeType_ResponseParamsSpec.$,
        impl.changeType.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        device.mojom.WakeLock_HasWakeLockForTests_ParamsSpec.$,
        device.mojom.WakeLock_HasWakeLockForTests_ResponseParamsSpec.$,
        impl.hasWakeLockForTests.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.WakeLock = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.WakeLock";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.WakeLockRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.WakeLockRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WakeLock
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.WakeLockCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.WakeLockRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.WakeLockRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestWakeLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.WakeLock_RequestWakeLock_ParamsSpec.$,
        null,
        this.requestWakeLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelWakeLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.WakeLock_CancelWakeLock_ParamsSpec.$,
        null,
        this.cancelWakeLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.WakeLock_AddClient_ParamsSpec.$,
        null,
        this.addClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.changeType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.WakeLock_ChangeType_ParamsSpec.$,
        device.mojom.WakeLock_ChangeType_ResponseParamsSpec.$,
        this.changeType.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasWakeLockForTests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        device.mojom.WakeLock_HasWakeLockForTests_ParamsSpec.$,
        device.mojom.WakeLock_HasWakeLockForTests_ResponseParamsSpec.$,
        this.hasWakeLockForTests.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLock_RequestWakeLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLock_CancelWakeLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLock_AddClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLock_ChangeType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLock_ChangeType_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLock_HasWakeLockForTests_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLock_HasWakeLockForTests_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.WakeLock_RequestWakeLock_ParamsSpec.$,
    'WakeLock_RequestWakeLock_Params',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.WakeLock_RequestWakeLock_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.WakeLock_CancelWakeLock_ParamsSpec.$,
    'WakeLock_CancelWakeLock_Params',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.WakeLock_CancelWakeLock_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.WakeLock_AddClient_ParamsSpec.$,
    'WakeLock_AddClient_Params',
    [
      mojo.internal.StructField(
        'wakeLock', 0,
        0,
        mojo.internal.InterfaceRequest(device.mojom.WakeLockPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.WakeLock_AddClient_Params = class {
  constructor() {
    /** @export { !device.mojom.WakeLockPendingReceiver } */
    this.wakeLock;
  }
};



mojo.internal.Struct(
    device.mojom.WakeLock_ChangeType_ParamsSpec.$,
    'WakeLock_ChangeType_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.WakeLockTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.WakeLock_ChangeType_Params = class {
  constructor() {
    /** @export { !device.mojom.WakeLockType } */
    this.type;
  }
};



mojo.internal.Struct(
    device.mojom.WakeLock_ChangeType_ResponseParamsSpec.$,
    'WakeLock_ChangeType_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.WakeLock_ChangeType_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.WakeLock_HasWakeLockForTests_ParamsSpec.$,
    'WakeLock_HasWakeLockForTests_Params',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.WakeLock_HasWakeLockForTests_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.WakeLock_HasWakeLockForTests_ResponseParamsSpec.$,
    'WakeLock_HasWakeLockForTests_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.WakeLock_HasWakeLockForTests_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};

