// services/device/public/mojom/wake_lock_context.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('device.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.WakeLockContextPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.WakeLockContext.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { device.mojom.WakeLockContextInterface }
 */
device.mojom.WakeLockContextRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.WakeLockContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.WakeLockContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.WakeLockContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.WakeLockType } type
   * @param { !device.mojom.WakeLockReason } reason
   * @param { !string } description
   * @param { !device.mojom.WakeLockPendingReceiver } wakeLock
   */

  getWakeLock(
      type,
      reason,
      description,
      wakeLock) {
    this.proxy.sendMessage(
        0,
        device.mojom.WakeLockContext_GetWakeLock_ParamsSpec.$,
        null,
        [
          type,
          reason,
          description,
          wakeLock
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WakeLockContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.WakeLockContextReceiver = class {
  /**
   * @param {!device.mojom.WakeLockContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.WakeLockContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.WakeLockContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.WakeLockContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.WakeLockContext_GetWakeLock_ParamsSpec.$,
        null,
        impl.getWakeLock.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.WakeLockContext = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.WakeLockContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.WakeLockContextRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.WakeLockContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WakeLockContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.WakeLockContextCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.WakeLockContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.WakeLockContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getWakeLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.WakeLockContext_GetWakeLock_ParamsSpec.$,
        null,
        this.getWakeLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLockContext_GetWakeLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.WakeLockContext_GetWakeLock_ParamsSpec.$,
    'WakeLockContext_GetWakeLock_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.WakeLockTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 4,
        0,
        device.mojom.WakeLockReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wakeLock', 16,
        0,
        mojo.internal.InterfaceRequest(device.mojom.WakeLockPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
device.mojom.WakeLockContext_GetWakeLock_Params = class {
  constructor() {
    /** @export { !device.mojom.WakeLockType } */
    this.type;
    /** @export { !device.mojom.WakeLockReason } */
    this.reason;
    /** @export { !string } */
    this.description;
    /** @export { !device.mojom.WakeLockPendingReceiver } */
    this.wakeLock;
  }
};

