// services/network/public/mojom/fetch_retry_options.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/fetch_retry_options.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }



  function FetchRetryOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FetchRetryOptions.prototype.initDefaults_ = function() {
    this.maxAttempts = 0;
    this.backoff_factor_$flag = false;
    this.retryAfterUnload = false;
    this.retryNonIdempotent = false;
    this.retryOnlyIfServerUnreached = false;
    this.initialDelay = null;
    this.backoff_factor_$value = 0;
    this.maxAge = null;
  };
  FetchRetryOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FetchRetryOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate FetchRetryOptions.initialDelay
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;




    // validate FetchRetryOptions.maxAge
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  FetchRetryOptions.encodedSize = codec.kStructHeaderSize + 32;

  FetchRetryOptions.decode = function(decoder) {
    var packed;
    var val = new FetchRetryOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.maxAttempts =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.backoff_factor_$flag = (packed >> 0) & 1 ? true : false;
    val.retryAfterUnload = (packed >> 1) & 1 ? true : false;
    val.retryNonIdempotent = (packed >> 2) & 1 ? true : false;
    val.retryOnlyIfServerUnreached = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.initialDelay =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.backoff_factor_$value =
        decoder.decodeStruct(codec.Double);
    val.maxAge =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  FetchRetryOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FetchRetryOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.maxAttempts);
    packed = 0;
    packed |= (val.backoff_factor_$flag & 1) << 0
    packed |= (val.retryAfterUnload & 1) << 1
    packed |= (val.retryNonIdempotent & 1) << 2
    packed |= (val.retryOnlyIfServerUnreached & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(time$.TimeDelta, val.initialDelay);
    encoder.encodeStruct(codec.Double, val.backoff_factor_$value);
    encoder.encodeStructPointer(time$.TimeDelta, val.maxAge);
  };
  exports.FetchRetryOptions = FetchRetryOptions;
})();