// services/network/public/mojom/host_resolver.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.OptionalSecureDnsModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.OptionalSecureDnsMode = {
  
  NO_OVERRIDE: 0,
  OFF: 1,
  AUTOMATIC: 2,
  SECURE: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.SecureDnsModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.SecureDnsMode = {
  
  OFF: 0,
  AUTOMATIC: 1,
  SECURE: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.SecureDnsPolicySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.SecureDnsPolicy = {
  
  ALLOW: 0,
  DISABLE: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.DnsQueryTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.DnsQueryType = {
  
  UNSPECIFIED: 0,
  A: 1,
  AAAA: 2,
  TXT: 3,
  PTR: 4,
  SRV: 5,
  HTTPS: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.ResolveHostHandlePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.ResolveHostHandle.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.ResolveHostHandleInterface }
 */
network.mojom.ResolveHostHandleRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.ResolveHostHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.ResolveHostHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.ResolveHostHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } result
   */

  cancel(
      result) {
    this.proxy.sendMessage(
        0,
        network.mojom.ResolveHostHandle_Cancel_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ResolveHostHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.ResolveHostHandleReceiver = class {
  /**
   * @param {!network.mojom.ResolveHostHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.ResolveHostHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.ResolveHostHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ResolveHostHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.ResolveHostHandle_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.ResolveHostHandle = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ResolveHostHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.ResolveHostHandleRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.ResolveHostHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ResolveHostHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.ResolveHostHandleCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.ResolveHostHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ResolveHostHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.ResolveHostHandle_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.ResolveHostClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.ResolveHostClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.ResolveHostClientInterface }
 */
network.mojom.ResolveHostClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.ResolveHostClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.ResolveHostClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.ResolveHostClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } result
   * @param { !network.mojom.ResolveErrorInfo } resolveErrorInfo
   * @param { !network.mojom.AddressList } resolvedAddresses
   * @param { !Array<!network.mojom.HostResolverEndpointResult> } alternativeEndpoints
   */

  onComplete(
      result,
      resolveErrorInfo,
      resolvedAddresses,
      alternativeEndpoints) {
    this.proxy.sendMessage(
        0,
        network.mojom.ResolveHostClient_OnComplete_ParamsSpec.$,
        null,
        [
          result,
          resolveErrorInfo,
          resolvedAddresses,
          alternativeEndpoints
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } textResults
   */

  onTextResults(
      textResults) {
    this.proxy.sendMessage(
        1,
        network.mojom.ResolveHostClient_OnTextResults_ParamsSpec.$,
        null,
        [
          textResults
        ],
        false);
  }

  
  /**
   * @param { !Array<!network.mojom.HostPortPair> } hosts
   */

  onHostnameResults(
      hosts) {
    this.proxy.sendMessage(
        2,
        network.mojom.ResolveHostClient_OnHostnameResults_ParamsSpec.$,
        null,
        [
          hosts
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ResolveHostClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.ResolveHostClientReceiver = class {
  /**
   * @param {!network.mojom.ResolveHostClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.ResolveHostClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.ResolveHostClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ResolveHostClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.ResolveHostClient_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.ResolveHostClient_OnTextResults_ParamsSpec.$,
        null,
        impl.onTextResults.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.ResolveHostClient_OnHostnameResults_ParamsSpec.$,
        null,
        impl.onHostnameResults.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.ResolveHostClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ResolveHostClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.ResolveHostClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.ResolveHostClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ResolveHostClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.ResolveHostClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.ResolveHostClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ResolveHostClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.ResolveHostClient_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTextResults =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.ResolveHostClient_OnTextResults_ParamsSpec.$,
        null,
        this.onTextResults.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onHostnameResults =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.ResolveHostClient_OnHostnameResults_ParamsSpec.$,
        null,
        this.onHostnameResults.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.MdnsListenClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.MdnsListenClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.MdnsListenClientInterface }
 */
network.mojom.MdnsListenClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.MdnsListenClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.MdnsListenClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.MdnsListenClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.MdnsListenClient_UpdateType } updateType
   * @param { !network.mojom.DnsQueryType } queryType
   * @param { !network.mojom.IPEndPoint } endpoint
   */

  onAddressResult(
      updateType,
      queryType,
      endpoint) {
    this.proxy.sendMessage(
        0,
        network.mojom.MdnsListenClient_OnAddressResult_ParamsSpec.$,
        null,
        [
          updateType,
          queryType,
          endpoint
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.MdnsListenClient_UpdateType } updateType
   * @param { !network.mojom.DnsQueryType } queryType
   * @param { !Array<!string> } textRecords
   */

  onTextResult(
      updateType,
      queryType,
      textRecords) {
    this.proxy.sendMessage(
        1,
        network.mojom.MdnsListenClient_OnTextResult_ParamsSpec.$,
        null,
        [
          updateType,
          queryType,
          textRecords
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.MdnsListenClient_UpdateType } updateType
   * @param { !network.mojom.DnsQueryType } queryType
   * @param { !network.mojom.HostPortPair } host
   */

  onHostnameResult(
      updateType,
      queryType,
      host) {
    this.proxy.sendMessage(
        2,
        network.mojom.MdnsListenClient_OnHostnameResult_ParamsSpec.$,
        null,
        [
          updateType,
          queryType,
          host
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.MdnsListenClient_UpdateType } updateType
   * @param { !network.mojom.DnsQueryType } queryType
   */

  onUnhandledResult(
      updateType,
      queryType) {
    this.proxy.sendMessage(
        3,
        network.mojom.MdnsListenClient_OnUnhandledResult_ParamsSpec.$,
        null,
        [
          updateType,
          queryType
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MdnsListenClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.MdnsListenClientReceiver = class {
  /**
   * @param {!network.mojom.MdnsListenClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.MdnsListenClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.MdnsListenClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.MdnsListenClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.MdnsListenClient_OnAddressResult_ParamsSpec.$,
        null,
        impl.onAddressResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.MdnsListenClient_OnTextResult_ParamsSpec.$,
        null,
        impl.onTextResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.MdnsListenClient_OnHostnameResult_ParamsSpec.$,
        null,
        impl.onHostnameResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.MdnsListenClient_OnUnhandledResult_ParamsSpec.$,
        null,
        impl.onUnhandledResult.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.MdnsListenClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.MdnsListenClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.MdnsListenClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.MdnsListenClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.MdnsListenClient.UpdateTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.MdnsListenClient_UpdateType = {
  
  ADDED: 0,
  CHANGED: 1,
  REMOVED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * An object which receives request messages for the MdnsListenClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.MdnsListenClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.MdnsListenClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.MdnsListenClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAddressResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.MdnsListenClient_OnAddressResult_ParamsSpec.$,
        null,
        this.onAddressResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTextResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.MdnsListenClient_OnTextResult_ParamsSpec.$,
        null,
        this.onTextResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onHostnameResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.MdnsListenClient_OnHostnameResult_ParamsSpec.$,
        null,
        this.onHostnameResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onUnhandledResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.MdnsListenClient_OnUnhandledResult_ParamsSpec.$,
        null,
        this.onUnhandledResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.HostResolverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.HostResolver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.HostResolverInterface }
 */
network.mojom.HostResolverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.HostResolverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.HostResolverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.HostResolverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.HostResolverHost } host
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { ?network.mojom.ResolveHostParameters } optionalParameters
   * @param { !network.mojom.ResolveHostClientRemote } responseClient
   */

  resolveHost(
      host,
      networkAnonymizationKey,
      optionalParameters,
      responseClient) {
    this.proxy.sendMessage(
        0,
        network.mojom.HostResolver_ResolveHost_ParamsSpec.$,
        null,
        [
          host,
          networkAnonymizationKey,
          optionalParameters,
          responseClient
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.HostPortPair } host
   * @param { !network.mojom.DnsQueryType } queryType
   * @param { !network.mojom.MdnsListenClientRemote } responseClient
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  mdnsListen(
      host,
      queryType,
      responseClient) {
    return this.proxy.sendMessage(
        1,
        network.mojom.HostResolver_MdnsListen_ParamsSpec.$,
        network.mojom.HostResolver_MdnsListen_ResponseParamsSpec.$,
        [
          host,
          queryType,
          responseClient
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HostResolver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.HostResolverReceiver = class {
  /**
   * @param {!network.mojom.HostResolverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.HostResolverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.HostResolverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.HostResolverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.HostResolver_ResolveHost_ParamsSpec.$,
        null,
        impl.resolveHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.HostResolver_MdnsListen_ParamsSpec.$,
        network.mojom.HostResolver_MdnsListen_ResponseParamsSpec.$,
        impl.mdnsListen.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.HostResolver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.HostResolver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.HostResolverRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.HostResolverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HostResolver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.HostResolverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.HostResolverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.HostResolverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.HostResolver_ResolveHost_ParamsSpec.$,
        null,
        this.resolveHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mdnsListen =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.HostResolver_MdnsListen_ParamsSpec.$,
        network.mojom.HostResolver_MdnsListen_ResponseParamsSpec.$,
        this.mdnsListen.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.DnsConfigChangeManagerClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.DnsConfigChangeManagerClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.DnsConfigChangeManagerClientInterface }
 */
network.mojom.DnsConfigChangeManagerClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.DnsConfigChangeManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.DnsConfigChangeManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.DnsConfigChangeManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onDnsConfigChanged() {
    this.proxy.sendMessage(
        0,
        network.mojom.DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DnsConfigChangeManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.DnsConfigChangeManagerClientReceiver = class {
  /**
   * @param {!network.mojom.DnsConfigChangeManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.DnsConfigChangeManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.DnsConfigChangeManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DnsConfigChangeManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsSpec.$,
        null,
        impl.onDnsConfigChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.DnsConfigChangeManagerClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DnsConfigChangeManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.DnsConfigChangeManagerClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.DnsConfigChangeManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DnsConfigChangeManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.DnsConfigChangeManagerClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.DnsConfigChangeManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DnsConfigChangeManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDnsConfigChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsSpec.$,
        null,
        this.onDnsConfigChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.DnsConfigChangeManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.DnsConfigChangeManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.DnsConfigChangeManagerInterface }
 */
network.mojom.DnsConfigChangeManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.DnsConfigChangeManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.DnsConfigChangeManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.DnsConfigChangeManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.DnsConfigChangeManagerClientRemote } client
   */

  requestNotifications(
      client) {
    this.proxy.sendMessage(
        0,
        network.mojom.DnsConfigChangeManager_RequestNotifications_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DnsConfigChangeManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.DnsConfigChangeManagerReceiver = class {
  /**
   * @param {!network.mojom.DnsConfigChangeManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.DnsConfigChangeManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.DnsConfigChangeManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DnsConfigChangeManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.DnsConfigChangeManager_RequestNotifications_ParamsSpec.$,
        null,
        impl.requestNotifications.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.DnsConfigChangeManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DnsConfigChangeManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.DnsConfigChangeManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.DnsConfigChangeManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DnsConfigChangeManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.DnsConfigChangeManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.DnsConfigChangeManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DnsConfigChangeManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.DnsConfigChangeManager_RequestNotifications_ParamsSpec.$,
        null,
        this.requestNotifications.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DnsOverHttpsServerConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DnsOverHttpsConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DnsConfigOverridesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ResolveHostParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ResolveHostHandle_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ResolveHostClient_OnComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ResolveHostClient_OnTextResults_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ResolveHostClient_OnHostnameResults_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.MdnsListenClient_OnAddressResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.MdnsListenClient_OnTextResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.MdnsListenClient_OnHostnameResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.MdnsListenClient_OnUnhandledResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HostResolver_ResolveHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HostResolver_MdnsListen_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HostResolver_MdnsListen_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DnsConfigChangeManager_RequestNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
network.mojom.HostResolverHostSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.DnsOverHttpsServerConfigSpec.$,
    'DnsOverHttpsServerConfig',
    [
      mojo.internal.StructField(
        'serverTemplate', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endpoints', 8,
        0,
        mojo.internal.Array(mojo.internal.Array(network.mojom.IPAddressSpec.$, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.DnsOverHttpsServerConfig = class {
  constructor() {
    /** @export { !string } */
    this.serverTemplate;
    /** @export { !Array<!Array<!network.mojom.IPAddress>> } */
    this.endpoints;
  }
};



mojo.internal.Struct(
    network.mojom.DnsOverHttpsConfigSpec.$,
    'DnsOverHttpsConfig',
    [
      mojo.internal.StructField(
        'servers', 0,
        0,
        mojo.internal.Array(network.mojom.DnsOverHttpsServerConfigSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.DnsOverHttpsConfig = class {
  constructor() {
    /** @export { !Array<!network.mojom.DnsOverHttpsServerConfig> } */
    this.servers;
  }
};



/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.DnsConfigOverridesSpec.TristateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.DnsConfigOverrides_Tristate = {
  
  NO_OVERRIDE: 0,
  TRISTATE_TRUE: 1,
  TRISTATE_FALSE: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


mojo.internal.Struct(
    network.mojom.DnsConfigOverridesSpec.$,
    'DnsConfigOverrides',
    [
      mojo.internal.StructField(
        'nameservers', 0,
        0,
        mojo.internal.Array(network.mojom.IPEndPointSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'search', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'appendToMultiLabelName', 16,
        0,
        network.mojom.DnsConfigOverridesSpec.TristateSpec.$,
        network.mojom.DnsConfigOverrides_Tristate.NO_OVERRIDE,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ndots', 20,
        0,
        mojo.internal.Int8,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fallbackPeriod', 24,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attempts', 32,
        0,
        mojo.internal.Int32,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rotate', 36,
        0,
        network.mojom.DnsConfigOverridesSpec.TristateSpec.$,
        network.mojom.DnsConfigOverrides_Tristate.NO_OVERRIDE,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'useLocalIpv6', 40,
        0,
        network.mojom.DnsConfigOverridesSpec.TristateSpec.$,
        network.mojom.DnsConfigOverrides_Tristate.NO_OVERRIDE,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dnsOverHttpsConfig', 48,
        0,
        network.mojom.DnsOverHttpsConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'secureDnsMode', 44,
        0,
        network.mojom.OptionalSecureDnsModeSpec.$,
        network.mojom.OptionalSecureDnsMode.NO_OVERRIDE,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowDnsOverHttpsUpgrade', 56,
        0,
        network.mojom.DnsConfigOverridesSpec.TristateSpec.$,
        network.mojom.DnsConfigOverrides_Tristate.NO_OVERRIDE,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clearHosts', 21,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 72],]);





/** @record */
network.mojom.DnsConfigOverrides = class {
  constructor() {
    /** @export { (Array<!network.mojom.IPEndPoint>|undefined) } */
    this.nameservers;
    /** @export { (Array<!string>|undefined) } */
    this.search;
    /** @export { !network.mojom.DnsConfigOverrides_Tristate } */
    this.appendToMultiLabelName;
    /** @export { !number } */
    this.ndots;
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.fallbackPeriod;
    /** @export { !number } */
    this.attempts;
    /** @export { !network.mojom.DnsConfigOverrides_Tristate } */
    this.rotate;
    /** @export { !network.mojom.DnsConfigOverrides_Tristate } */
    this.useLocalIpv6;
    /** @export { (network.mojom.DnsOverHttpsConfig|undefined) } */
    this.dnsOverHttpsConfig;
    /** @export { !network.mojom.OptionalSecureDnsMode } */
    this.secureDnsMode;
    /** @export { !network.mojom.DnsConfigOverrides_Tristate } */
    this.allowDnsOverHttpsUpgrade;
    /** @export { !boolean } */
    this.clearHosts;
  }
};



/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.ResolveHostParametersSpec.SourceSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.ResolveHostParameters_Source = {
  
  ANY: 0,
  SYSTEM: 1,
  DNS: 2,
  MULTICAST_DNS: 3,
  LOCAL_ONLY: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.ResolveHostParametersSpec.CacheUsageSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.ResolveHostParameters_CacheUsage = {
  
  ALLOWED: 0,
  STALE_ALLOWED: 1,
  DISALLOWED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.ResolveHostParametersSpec.PurposeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.ResolveHostParameters_Purpose = {
  
  kUnspecified: 0,
  kPreconnect: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    network.mojom.ResolveHostParametersSpec.$,
    'ResolveHostParameters',
    [
      mojo.internal.StructField(
        'dnsQueryType', 0,
        0,
        network.mojom.DnsQueryTypeSpec.$,
        network.mojom.DnsQueryType.UNSPECIFIED,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initialPriority', 4,
        0,
        network.mojom.RequestPrioritySpec.$,
        network.mojom.RequestPriority.kLowest,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        network.mojom.ResolveHostParametersSpec.SourceSpec.$,
        network.mojom.ResolveHostParameters_Source.ANY,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cacheUsage', 12,
        0,
        network.mojom.ResolveHostParametersSpec.CacheUsageSpec.$,
        network.mojom.ResolveHostParameters_CacheUsage.ALLOWED,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'controlHandle', 16,
        0,
        mojo.internal.InterfaceRequest(network.mojom.ResolveHostHandlePendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeCanonicalName', 20,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'loopbackOnly', 20,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isSpeculative', 20,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'secureDnsPolicy', 24,
        0,
        network.mojom.SecureDnsPolicySpec.$,
        network.mojom.SecureDnsPolicy.ALLOW,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'purpose', 28,
        0,
        network.mojom.ResolveHostParametersSpec.PurposeSpec.$,
        network.mojom.ResolveHostParameters_Purpose.kUnspecified,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.ResolveHostParameters = class {
  constructor() {
    /** @export { !network.mojom.DnsQueryType } */
    this.dnsQueryType;
    /** @export { !network.mojom.RequestPriority } */
    this.initialPriority;
    /** @export { !network.mojom.ResolveHostParameters_Source } */
    this.source;
    /** @export { !network.mojom.ResolveHostParameters_CacheUsage } */
    this.cacheUsage;
    /** @export { (network.mojom.ResolveHostHandlePendingReceiver|undefined) } */
    this.controlHandle;
    /** @export { !boolean } */
    this.includeCanonicalName;
    /** @export { !boolean } */
    this.loopbackOnly;
    /** @export { !boolean } */
    this.isSpeculative;
    /** @export { !network.mojom.SecureDnsPolicy } */
    this.secureDnsPolicy;
    /** @export { !network.mojom.ResolveHostParameters_Purpose } */
    this.purpose;
  }
};



mojo.internal.Struct(
    network.mojom.ResolveHostHandle_Cancel_ParamsSpec.$,
    'ResolveHostHandle_Cancel_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.ResolveHostHandle_Cancel_Params = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.ResolveHostClient_OnComplete_ParamsSpec.$,
    'ResolveHostClient_OnComplete_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resolveErrorInfo', 8,
        0,
        network.mojom.ResolveErrorInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resolvedAddresses', 16,
        0,
        network.mojom.AddressListSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'alternativeEndpoints', 24,
        0,
        mojo.internal.Array(network.mojom.HostResolverEndpointResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.ResolveHostClient_OnComplete_Params = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { !network.mojom.ResolveErrorInfo } */
    this.resolveErrorInfo;
    /** @export { !network.mojom.AddressList } */
    this.resolvedAddresses;
    /** @export { !Array<!network.mojom.HostResolverEndpointResult> } */
    this.alternativeEndpoints;
  }
};



mojo.internal.Struct(
    network.mojom.ResolveHostClient_OnTextResults_ParamsSpec.$,
    'ResolveHostClient_OnTextResults_Params',
    [
      mojo.internal.StructField(
        'textResults', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.ResolveHostClient_OnTextResults_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.textResults;
  }
};



mojo.internal.Struct(
    network.mojom.ResolveHostClient_OnHostnameResults_ParamsSpec.$,
    'ResolveHostClient_OnHostnameResults_Params',
    [
      mojo.internal.StructField(
        'hosts', 0,
        0,
        mojo.internal.Array(network.mojom.HostPortPairSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.ResolveHostClient_OnHostnameResults_Params = class {
  constructor() {
    /** @export { !Array<!network.mojom.HostPortPair> } */
    this.hosts;
  }
};



mojo.internal.Struct(
    network.mojom.MdnsListenClient_OnAddressResult_ParamsSpec.$,
    'MdnsListenClient_OnAddressResult_Params',
    [
      mojo.internal.StructField(
        'updateType', 0,
        0,
        network.mojom.MdnsListenClient.UpdateTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'queryType', 4,
        0,
        network.mojom.DnsQueryTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endpoint', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.MdnsListenClient_OnAddressResult_Params = class {
  constructor() {
    /** @export { !network.mojom.MdnsListenClient_UpdateType } */
    this.updateType;
    /** @export { !network.mojom.DnsQueryType } */
    this.queryType;
    /** @export { !network.mojom.IPEndPoint } */
    this.endpoint;
  }
};



mojo.internal.Struct(
    network.mojom.MdnsListenClient_OnTextResult_ParamsSpec.$,
    'MdnsListenClient_OnTextResult_Params',
    [
      mojo.internal.StructField(
        'updateType', 0,
        0,
        network.mojom.MdnsListenClient.UpdateTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'queryType', 4,
        0,
        network.mojom.DnsQueryTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textRecords', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.MdnsListenClient_OnTextResult_Params = class {
  constructor() {
    /** @export { !network.mojom.MdnsListenClient_UpdateType } */
    this.updateType;
    /** @export { !network.mojom.DnsQueryType } */
    this.queryType;
    /** @export { !Array<!string> } */
    this.textRecords;
  }
};



mojo.internal.Struct(
    network.mojom.MdnsListenClient_OnHostnameResult_ParamsSpec.$,
    'MdnsListenClient_OnHostnameResult_Params',
    [
      mojo.internal.StructField(
        'updateType', 0,
        0,
        network.mojom.MdnsListenClient.UpdateTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'queryType', 4,
        0,
        network.mojom.DnsQueryTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'host', 8,
        0,
        network.mojom.HostPortPairSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.MdnsListenClient_OnHostnameResult_Params = class {
  constructor() {
    /** @export { !network.mojom.MdnsListenClient_UpdateType } */
    this.updateType;
    /** @export { !network.mojom.DnsQueryType } */
    this.queryType;
    /** @export { !network.mojom.HostPortPair } */
    this.host;
  }
};



mojo.internal.Struct(
    network.mojom.MdnsListenClient_OnUnhandledResult_ParamsSpec.$,
    'MdnsListenClient_OnUnhandledResult_Params',
    [
      mojo.internal.StructField(
        'updateType', 0,
        0,
        network.mojom.MdnsListenClient.UpdateTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'queryType', 4,
        0,
        network.mojom.DnsQueryTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.MdnsListenClient_OnUnhandledResult_Params = class {
  constructor() {
    /** @export { !network.mojom.MdnsListenClient_UpdateType } */
    this.updateType;
    /** @export { !network.mojom.DnsQueryType } */
    this.queryType;
  }
};



mojo.internal.Struct(
    network.mojom.HostResolver_ResolveHost_ParamsSpec.$,
    'HostResolver_ResolveHost_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        network.mojom.HostResolverHostSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 16,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'optionalParameters', 32,
        0,
        network.mojom.ResolveHostParametersSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseClient', 40,
        0,
        mojo.internal.InterfaceProxy(network.mojom.ResolveHostClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
network.mojom.HostResolver_ResolveHost_Params = class {
  constructor() {
    /** @export { !network.mojom.HostResolverHost } */
    this.host;
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @export { (network.mojom.ResolveHostParameters|undefined) } */
    this.optionalParameters;
    /** @export { !network.mojom.ResolveHostClientRemote } */
    this.responseClient;
  }
};



mojo.internal.Struct(
    network.mojom.HostResolver_MdnsListen_ParamsSpec.$,
    'HostResolver_MdnsListen_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        network.mojom.HostPortPairSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'queryType', 8,
        0,
        network.mojom.DnsQueryTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseClient', 12,
        0,
        mojo.internal.InterfaceProxy(network.mojom.MdnsListenClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.HostResolver_MdnsListen_Params = class {
  constructor() {
    /** @export { !network.mojom.HostPortPair } */
    this.host;
    /** @export { !network.mojom.DnsQueryType } */
    this.queryType;
    /** @export { !network.mojom.MdnsListenClientRemote } */
    this.responseClient;
  }
};



mojo.internal.Struct(
    network.mojom.HostResolver_MdnsListen_ResponseParamsSpec.$,
    'HostResolver_MdnsListen_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.HostResolver_MdnsListen_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsSpec.$,
    'DnsConfigChangeManagerClient_OnDnsConfigChanged_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.DnsConfigChangeManagerClient_OnDnsConfigChanged_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.DnsConfigChangeManager_RequestNotifications_ParamsSpec.$,
    'DnsConfigChangeManager_RequestNotifications_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.DnsConfigChangeManagerClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.DnsConfigChangeManager_RequestNotifications_Params = class {
  constructor() {
    /** @export { !network.mojom.DnsConfigChangeManagerClientRemote } */
    this.client;
  }
};



mojo.internal.Union(
    network.mojom.HostResolverHostSpec.$, 'HostResolverHost',
    {
      'schemeHostPort': {
        'ordinal': 0,
        'type': url.mojom.SchemeHostPortSpec.$,
      },
      'hostPortPair': {
        'ordinal': 1,
        'type': network.mojom.HostPortPairSpec.$,
      },
    });

/**
 * @typedef { {
 *   schemeHostPort: (!url.mojom.SchemeHostPort|undefined),
 *   hostPortPair: (!network.mojom.HostPortPair|undefined),
 * } }
 */
network.mojom.HostResolverHost;
