// services/network/public/mojom/http_cache_backend_file_operations.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  File as mojoBase_mojom_File,
  FileSpec as mojoBase_mojom_FileSpec
} from '../../../../mojo/public/mojom/base/file.mojom.m.js';

import {
  FileError as mojoBase_mojom_FileError,
  FileErrorSpec as mojoBase_mojom_FileErrorSpec
} from '../../../../mojo/public/mojom/base/file_error.mojom.m.js';

import {
  FileInfo as mojoBase_mojom_FileInfo,
  FileInfoSpec as mojoBase_mojom_FileInfoSpec
} from '../../../../mojo/public/mojom/base/file_info.mojom.m.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const HttpCacheBackendOpenFileFlagsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const HttpCacheBackendOpenFileFlags = {
  
  kOpenAndRead: 33,
  kCreateAndWrite: 66,
  kOpenReadWriteWinShareDelete: 32865,
  kCreateReadWriteWinShareDelete: 32866,
  kCreateAlwaysWriteWinShareDelete: 32840,
  kOpenReadWinShareDeleteWinSequentialScan: 557089,
  MIN_VALUE: 33,
  MAX_VALUE: 557089,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const HttpCacheBackendDeleteFileModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const HttpCacheBackendDeleteFileMode = {
  
  kDefault: 0,
  kEnsureImmediateAvailability: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileEnumeratorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.FileEnumerator', scope);
  }
}

/** @interface */
export class FileEnumeratorInterface {
  
  /**
   * @param { !number } numEntries
   * @return {!Promise<{
        entries: !Array<!FileEnumerationEntry>,
        end: !boolean,
        error: !boolean,
   *  }>}
   */

  getNext(numEntries) {}
}

/**
 * @implements { FileEnumeratorInterface }
 */
export class FileEnumeratorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileEnumeratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileEnumeratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileEnumeratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } numEntries
   * @return {!Promise<{
        entries: !Array<!FileEnumerationEntry>,
        end: !boolean,
        error: !boolean,
   *  }>}
   */

  getNext(
      numEntries) {
    return this.proxy.sendMessage(
        0,
        FileEnumerator_GetNext_ParamsSpec.$,
        FileEnumerator_GetNext_ResponseParamsSpec.$,
        [
          numEntries
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileEnumerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileEnumeratorReceiver {
  /**
   * @param {!FileEnumeratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileEnumeratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileEnumeratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileEnumeratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileEnumerator_GetNext_ParamsSpec.$,
        FileEnumerator_GetNext_ResponseParamsSpec.$,
        impl.getNext.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileEnumerator {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.FileEnumerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileEnumeratorRemote}
   */
  static getRemote() {
    let remote = new FileEnumeratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileEnumerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileEnumeratorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileEnumeratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileEnumeratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileEnumerator_GetNext_ParamsSpec.$,
        FileEnumerator_GetNext_ResponseParamsSpec.$,
        this.getNext.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HttpCacheBackendFileOperationsPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.HttpCacheBackendFileOperations', scope);
  }
}

/** @interface */
export class HttpCacheBackendFileOperationsInterface {
  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  createDirectory(path) {}
  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  pathExists(path) {}
  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  directoryExists(path) {}
  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @param { !HttpCacheBackendOpenFileFlags } flags
   * @return {!Promise<{
        file: ?mojoBase_mojom_File,
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  openFile(path, flags) {}
  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @param { !HttpCacheBackendDeleteFileMode } mode
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  deleteFile(path, mode) {}
  
  /**
   * @param { !mojoBase_mojom_FilePath } fromPath
   * @param { !mojoBase_mojom_FilePath } toPath
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  renameFile(fromPath, toPath) {}
  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        info: ?mojoBase_mojom_FileInfo,
   *  }>}
   */

  getFileInfo(path) {}
  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @param { !FileEnumeratorPendingReceiver } receiver
   */

  enumerateFiles(path, receiver) {}
  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  cleanupDirectory(path) {}
}

/**
 * @implements { HttpCacheBackendFileOperationsInterface }
 */
export class HttpCacheBackendFileOperationsRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HttpCacheBackendFileOperationsPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HttpCacheBackendFileOperationsPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HttpCacheBackendFileOperationsPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  createDirectory(
      path) {
    return this.proxy.sendMessage(
        0,
        HttpCacheBackendFileOperations_CreateDirectory_ParamsSpec.$,
        HttpCacheBackendFileOperations_CreateDirectory_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  pathExists(
      path) {
    return this.proxy.sendMessage(
        1,
        HttpCacheBackendFileOperations_PathExists_ParamsSpec.$,
        HttpCacheBackendFileOperations_PathExists_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  directoryExists(
      path) {
    return this.proxy.sendMessage(
        2,
        HttpCacheBackendFileOperations_DirectoryExists_ParamsSpec.$,
        HttpCacheBackendFileOperations_DirectoryExists_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @param { !HttpCacheBackendOpenFileFlags } flags
   * @return {!Promise<{
        file: ?mojoBase_mojom_File,
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  openFile(
      path,
      flags) {
    return this.proxy.sendMessage(
        3,
        HttpCacheBackendFileOperations_OpenFile_ParamsSpec.$,
        HttpCacheBackendFileOperations_OpenFile_ResponseParamsSpec.$,
        [
          path,
          flags
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @param { !HttpCacheBackendDeleteFileMode } mode
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  deleteFile(
      path,
      mode) {
    return this.proxy.sendMessage(
        4,
        HttpCacheBackendFileOperations_DeleteFile_ParamsSpec.$,
        HttpCacheBackendFileOperations_DeleteFile_ResponseParamsSpec.$,
        [
          path,
          mode
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } fromPath
   * @param { !mojoBase_mojom_FilePath } toPath
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  renameFile(
      fromPath,
      toPath) {
    return this.proxy.sendMessage(
        5,
        HttpCacheBackendFileOperations_RenameFile_ParamsSpec.$,
        HttpCacheBackendFileOperations_RenameFile_ResponseParamsSpec.$,
        [
          fromPath,
          toPath
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        info: ?mojoBase_mojom_FileInfo,
   *  }>}
   */

  getFileInfo(
      path) {
    return this.proxy.sendMessage(
        6,
        HttpCacheBackendFileOperations_GetFileInfo_ParamsSpec.$,
        HttpCacheBackendFileOperations_GetFileInfo_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @param { !FileEnumeratorPendingReceiver } receiver
   */

  enumerateFiles(
      path,
      receiver) {
    this.proxy.sendMessage(
        7,
        HttpCacheBackendFileOperations_EnumerateFiles_ParamsSpec.$,
        null,
        [
          path,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  cleanupDirectory(
      path) {
    return this.proxy.sendMessage(
        8,
        HttpCacheBackendFileOperations_CleanupDirectory_ParamsSpec.$,
        HttpCacheBackendFileOperations_CleanupDirectory_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HttpCacheBackendFileOperations
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HttpCacheBackendFileOperationsReceiver {
  /**
   * @param {!HttpCacheBackendFileOperationsInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HttpCacheBackendFileOperationsRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HttpCacheBackendFileOperationsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HttpCacheBackendFileOperationsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HttpCacheBackendFileOperations_CreateDirectory_ParamsSpec.$,
        HttpCacheBackendFileOperations_CreateDirectory_ResponseParamsSpec.$,
        impl.createDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        HttpCacheBackendFileOperations_PathExists_ParamsSpec.$,
        HttpCacheBackendFileOperations_PathExists_ResponseParamsSpec.$,
        impl.pathExists.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        HttpCacheBackendFileOperations_DirectoryExists_ParamsSpec.$,
        HttpCacheBackendFileOperations_DirectoryExists_ResponseParamsSpec.$,
        impl.directoryExists.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        HttpCacheBackendFileOperations_OpenFile_ParamsSpec.$,
        HttpCacheBackendFileOperations_OpenFile_ResponseParamsSpec.$,
        impl.openFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        HttpCacheBackendFileOperations_DeleteFile_ParamsSpec.$,
        HttpCacheBackendFileOperations_DeleteFile_ResponseParamsSpec.$,
        impl.deleteFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        HttpCacheBackendFileOperations_RenameFile_ParamsSpec.$,
        HttpCacheBackendFileOperations_RenameFile_ResponseParamsSpec.$,
        impl.renameFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        HttpCacheBackendFileOperations_GetFileInfo_ParamsSpec.$,
        HttpCacheBackendFileOperations_GetFileInfo_ResponseParamsSpec.$,
        impl.getFileInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        HttpCacheBackendFileOperations_EnumerateFiles_ParamsSpec.$,
        null,
        impl.enumerateFiles.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        HttpCacheBackendFileOperations_CleanupDirectory_ParamsSpec.$,
        HttpCacheBackendFileOperations_CleanupDirectory_ResponseParamsSpec.$,
        impl.cleanupDirectory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HttpCacheBackendFileOperations {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.HttpCacheBackendFileOperations";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HttpCacheBackendFileOperationsRemote}
   */
  static getRemote() {
    let remote = new HttpCacheBackendFileOperationsRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HttpCacheBackendFileOperations
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HttpCacheBackendFileOperationsCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HttpCacheBackendFileOperationsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HttpCacheBackendFileOperationsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HttpCacheBackendFileOperations_CreateDirectory_ParamsSpec.$,
        HttpCacheBackendFileOperations_CreateDirectory_ResponseParamsSpec.$,
        this.createDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pathExists =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        HttpCacheBackendFileOperations_PathExists_ParamsSpec.$,
        HttpCacheBackendFileOperations_PathExists_ResponseParamsSpec.$,
        this.pathExists.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.directoryExists =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        HttpCacheBackendFileOperations_DirectoryExists_ParamsSpec.$,
        HttpCacheBackendFileOperations_DirectoryExists_ResponseParamsSpec.$,
        this.directoryExists.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        HttpCacheBackendFileOperations_OpenFile_ParamsSpec.$,
        HttpCacheBackendFileOperations_OpenFile_ResponseParamsSpec.$,
        this.openFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        HttpCacheBackendFileOperations_DeleteFile_ParamsSpec.$,
        HttpCacheBackendFileOperations_DeleteFile_ResponseParamsSpec.$,
        this.deleteFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.renameFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        HttpCacheBackendFileOperations_RenameFile_ParamsSpec.$,
        HttpCacheBackendFileOperations_RenameFile_ResponseParamsSpec.$,
        this.renameFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFileInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        HttpCacheBackendFileOperations_GetFileInfo_ParamsSpec.$,
        HttpCacheBackendFileOperations_GetFileInfo_ResponseParamsSpec.$,
        this.getFileInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enumerateFiles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        HttpCacheBackendFileOperations_EnumerateFiles_ParamsSpec.$,
        null,
        this.enumerateFiles.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cleanupDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        HttpCacheBackendFileOperations_CleanupDirectory_ParamsSpec.$,
        HttpCacheBackendFileOperations_CleanupDirectory_ResponseParamsSpec.$,
        this.cleanupDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HttpCacheBackendFileOperationsFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.HttpCacheBackendFileOperationsFactory', scope);
  }
}

/** @interface */
export class HttpCacheBackendFileOperationsFactoryInterface {
  
  /**
   * @param { !HttpCacheBackendFileOperationsPendingReceiver } receiver
   */

  create(receiver) {}
}

/**
 * @implements { HttpCacheBackendFileOperationsFactoryInterface }
 */
export class HttpCacheBackendFileOperationsFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HttpCacheBackendFileOperationsFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HttpCacheBackendFileOperationsFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HttpCacheBackendFileOperationsFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !HttpCacheBackendFileOperationsPendingReceiver } receiver
   */

  create(
      receiver) {
    this.proxy.sendMessage(
        0,
        HttpCacheBackendFileOperationsFactory_Create_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HttpCacheBackendFileOperationsFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HttpCacheBackendFileOperationsFactoryReceiver {
  /**
   * @param {!HttpCacheBackendFileOperationsFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HttpCacheBackendFileOperationsFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HttpCacheBackendFileOperationsFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HttpCacheBackendFileOperationsFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HttpCacheBackendFileOperationsFactory_Create_ParamsSpec.$,
        null,
        impl.create.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HttpCacheBackendFileOperationsFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.HttpCacheBackendFileOperationsFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HttpCacheBackendFileOperationsFactoryRemote}
   */
  static getRemote() {
    let remote = new HttpCacheBackendFileOperationsFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HttpCacheBackendFileOperationsFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HttpCacheBackendFileOperationsFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HttpCacheBackendFileOperationsFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HttpCacheBackendFileOperationsFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.create =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HttpCacheBackendFileOperationsFactory_Create_ParamsSpec.$,
        null,
        this.create.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileEnumerationEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileEnumerator_GetNext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileEnumerator_GetNext_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_CreateDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_CreateDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_PathExists_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_PathExists_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_DirectoryExists_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_DirectoryExists_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_OpenFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_OpenFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_DeleteFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_DeleteFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_RenameFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_RenameFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_GetFileInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_GetFileInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_EnumerateFiles_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_CleanupDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperations_CleanupDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpCacheBackendFileOperationsFactory_Create_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FileEnumerationEntrySpec.$,
    'FileEnumerationEntry',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'size', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastAccessed', 16,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastModified', 24,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class FileEnumerationEntry {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
    /** @type { !bigint } */
    this.size;
    /** @type { !mojoBase_mojom_Time } */
    this.lastAccessed;
    /** @type { !mojoBase_mojom_Time } */
    this.lastModified;
  }
}



mojo.internal.Struct(
    FileEnumerator_GetNext_ParamsSpec.$,
    'FileEnumerator_GetNext_Params',
    [
      mojo.internal.StructField(
        'numEntries', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileEnumerator_GetNext_Params {
  constructor() {
    /** @type { !number } */
    this.numEntries;
  }
}



mojo.internal.Struct(
    FileEnumerator_GetNext_ResponseParamsSpec.$,
    'FileEnumerator_GetNext_ResponseParams',
    [
      mojo.internal.StructField(
        'entries', 0,
        0,
        mojo.internal.Array(FileEnumerationEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'end', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileEnumerator_GetNext_ResponseParams {
  constructor() {
    /** @type { !Array<!FileEnumerationEntry> } */
    this.entries;
    /** @type { !boolean } */
    this.end;
    /** @type { !boolean } */
    this.error;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_CreateDirectory_ParamsSpec.$,
    'HttpCacheBackendFileOperations_CreateDirectory_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_CreateDirectory_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_CreateDirectory_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_CreateDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_CreateDirectory_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_PathExists_ParamsSpec.$,
    'HttpCacheBackendFileOperations_PathExists_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_PathExists_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_PathExists_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_PathExists_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_PathExists_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_DirectoryExists_ParamsSpec.$,
    'HttpCacheBackendFileOperations_DirectoryExists_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_DirectoryExists_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_DirectoryExists_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_DirectoryExists_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_DirectoryExists_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_OpenFile_ParamsSpec.$,
    'HttpCacheBackendFileOperations_OpenFile_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'flags', 8,
        0,
        HttpCacheBackendOpenFileFlagsSpec.$,
        33,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_OpenFile_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
    /** @type { !HttpCacheBackendOpenFileFlags } */
    this.flags;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_OpenFile_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_OpenFile_ResponseParams',
    [
      mojo.internal.StructField(
        'file', 0,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_OpenFile_ResponseParams {
  constructor() {
    /** @type { (mojoBase_mojom_File|undefined) } */
    this.file;
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_DeleteFile_ParamsSpec.$,
    'HttpCacheBackendFileOperations_DeleteFile_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mode', 8,
        0,
        HttpCacheBackendDeleteFileModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_DeleteFile_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
    /** @type { !HttpCacheBackendDeleteFileMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_DeleteFile_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_DeleteFile_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_DeleteFile_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_RenameFile_ParamsSpec.$,
    'HttpCacheBackendFileOperations_RenameFile_Params',
    [
      mojo.internal.StructField(
        'fromPath', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'toPath', 8,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_RenameFile_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.fromPath;
    /** @type { !mojoBase_mojom_FilePath } */
    this.toPath;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_RenameFile_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_RenameFile_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_RenameFile_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_GetFileInfo_ParamsSpec.$,
    'HttpCacheBackendFileOperations_GetFileInfo_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_GetFileInfo_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_GetFileInfo_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_GetFileInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        mojoBase_mojom_FileInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_GetFileInfo_ResponseParams {
  constructor() {
    /** @type { (mojoBase_mojom_FileInfo|undefined) } */
    this.info;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_EnumerateFiles_ParamsSpec.$,
    'HttpCacheBackendFileOperations_EnumerateFiles_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(FileEnumeratorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_EnumerateFiles_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
    /** @type { !FileEnumeratorPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_CleanupDirectory_ParamsSpec.$,
    'HttpCacheBackendFileOperations_CleanupDirectory_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_CleanupDirectory_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperations_CleanupDirectory_ResponseParamsSpec.$,
    'HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    HttpCacheBackendFileOperationsFactory_Create_ParamsSpec.$,
    'HttpCacheBackendFileOperationsFactory_Create_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(HttpCacheBackendFileOperationsPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpCacheBackendFileOperationsFactory_Create_Params {
  constructor() {
    /** @type { !HttpCacheBackendFileOperationsPendingReceiver } */
    this.receiver;
  }
}

