// services/network/public/mojom/mdns_responder.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  IPAddress as network_mojom_IPAddress,
  IPAddressSpec as network_mojom_IPAddressSpec
} from './ip_address.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MdnsResponderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.MdnsResponder', scope);
  }
}

/** @interface */
export class MdnsResponderInterface {
  
  /**
   * @param { !network_mojom_IPAddress } address
   * @return {!Promise<{
        name: !string,
        announcementScheduled: !boolean,
   *  }>}
   */

  createNameForAddress(address) {}
  
  /**
   * @param { !network_mojom_IPAddress } address
   * @return {!Promise<{
        removed: !boolean,
        goodbyeScheduled: !boolean,
   *  }>}
   */

  removeNameForAddress(address) {}
}

/**
 * @implements { MdnsResponderInterface }
 */
export class MdnsResponderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MdnsResponderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MdnsResponderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MdnsResponderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_IPAddress } address
   * @return {!Promise<{
        name: !string,
        announcementScheduled: !boolean,
   *  }>}
   */

  createNameForAddress(
      address) {
    return this.proxy.sendMessage(
        0,
        MdnsResponder_CreateNameForAddress_ParamsSpec.$,
        MdnsResponder_CreateNameForAddress_ResponseParamsSpec.$,
        [
          address
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_IPAddress } address
   * @return {!Promise<{
        removed: !boolean,
        goodbyeScheduled: !boolean,
   *  }>}
   */

  removeNameForAddress(
      address) {
    return this.proxy.sendMessage(
        1,
        MdnsResponder_RemoveNameForAddress_ParamsSpec.$,
        MdnsResponder_RemoveNameForAddress_ResponseParamsSpec.$,
        [
          address
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MdnsResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MdnsResponderReceiver {
  /**
   * @param {!MdnsResponderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MdnsResponderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MdnsResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MdnsResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MdnsResponder_CreateNameForAddress_ParamsSpec.$,
        MdnsResponder_CreateNameForAddress_ResponseParamsSpec.$,
        impl.createNameForAddress.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MdnsResponder_RemoveNameForAddress_ParamsSpec.$,
        MdnsResponder_RemoveNameForAddress_ResponseParamsSpec.$,
        impl.removeNameForAddress.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MdnsResponder {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.MdnsResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MdnsResponderRemote}
   */
  static getRemote() {
    let remote = new MdnsResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MdnsResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MdnsResponderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MdnsResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MdnsResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createNameForAddress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MdnsResponder_CreateNameForAddress_ParamsSpec.$,
        MdnsResponder_CreateNameForAddress_ResponseParamsSpec.$,
        this.createNameForAddress.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeNameForAddress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MdnsResponder_RemoveNameForAddress_ParamsSpec.$,
        MdnsResponder_RemoveNameForAddress_ResponseParamsSpec.$,
        this.removeNameForAddress.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MdnsResponder_CreateNameForAddress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MdnsResponder_CreateNameForAddress_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MdnsResponder_RemoveNameForAddress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MdnsResponder_RemoveNameForAddress_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MdnsResponder_CreateNameForAddress_ParamsSpec.$,
    'MdnsResponder_CreateNameForAddress_Params',
    [
      mojo.internal.StructField(
        'address', 0,
        0,
        network_mojom_IPAddressSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MdnsResponder_CreateNameForAddress_Params {
  constructor() {
    /** @type { !network_mojom_IPAddress } */
    this.address;
  }
}



mojo.internal.Struct(
    MdnsResponder_CreateNameForAddress_ResponseParamsSpec.$,
    'MdnsResponder_CreateNameForAddress_ResponseParams',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'announcementScheduled', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MdnsResponder_CreateNameForAddress_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !boolean } */
    this.announcementScheduled;
  }
}



mojo.internal.Struct(
    MdnsResponder_RemoveNameForAddress_ParamsSpec.$,
    'MdnsResponder_RemoveNameForAddress_Params',
    [
      mojo.internal.StructField(
        'address', 0,
        0,
        network_mojom_IPAddressSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MdnsResponder_RemoveNameForAddress_Params {
  constructor() {
    /** @type { !network_mojom_IPAddress } */
    this.address;
  }
}



mojo.internal.Struct(
    MdnsResponder_RemoveNameForAddress_ResponseParamsSpec.$,
    'MdnsResponder_RemoveNameForAddress_ResponseParams',
    [
      mojo.internal.StructField(
        'removed', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'goodbyeScheduled', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MdnsResponder_RemoveNameForAddress_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.removed;
    /** @type { !boolean } */
    this.goodbyeScheduled;
  }
}

