// services/network/public/mojom/network_context_client.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.NetworkContextClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.NetworkContextClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.NetworkContextClientInterface }
 */
network.mojom.NetworkContextClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.NetworkContextClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.NetworkContextClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.NetworkContextClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } processId
   * @param { !boolean } async
   * @param { !Array<!mojoBase.mojom.FilePath> } filePaths
   * @param { !url.mojom.Url } destinationUrl
   * @return {!Promise<{
        netError: !number,
        files: !Array<!mojoBase.mojom.ReadOnlyFile>,
   *  }>}
   */

  onFileUploadRequested(
      processId,
      async,
      filePaths,
      destinationUrl) {
    return this.proxy.sendMessage(
        0,
        network.mojom.NetworkContextClient_OnFileUploadRequested_ParamsSpec.$,
        network.mojom.NetworkContextClient_OnFileUploadRequested_ResponseParamsSpec.$,
        [
          processId,
          async,
          filePaths,
          destinationUrl
        ],
        false);
  }

  
  /**
   * @param { !Array<!url.mojom.Origin> } origins
   * @return {!Promise<{
        origins: !Array<!url.mojom.Origin>,
   *  }>}
   */

  onCanSendReportingReports(
      origins) {
    return this.proxy.sendMessage(
        1,
        network.mojom.NetworkContextClient_OnCanSendReportingReports_ParamsSpec.$,
        network.mojom.NetworkContextClient_OnCanSendReportingReports_ResponseParamsSpec.$,
        [
          origins
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Origin } origin
   * @return {!Promise<{
        allowed: !boolean,
   *  }>}
   */

  onCanSendDomainReliabilityUpload(
      origin) {
    return this.proxy.sendMessage(
        2,
        network.mojom.NetworkContextClient_OnCanSendDomainReliabilityUpload_ParamsSpec.$,
        network.mojom.NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParamsSpec.$,
        [
          origin
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        allowed: !boolean,
   *  }>}
   */

  onCanSendSCTAuditingReport() {
    return this.proxy.sendMessage(
        3,
        network.mojom.NetworkContextClient_OnCanSendSCTAuditingReport_ParamsSpec.$,
        network.mojom.NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   */

  onNewSCTAuditingReportSent() {
    this.proxy.sendMessage(
        4,
        network.mojom.NetworkContextClient_OnNewSCTAuditingReportSent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NetworkContextClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.NetworkContextClientReceiver = class {
  /**
   * @param {!network.mojom.NetworkContextClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.NetworkContextClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.NetworkContextClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.NetworkContextClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.NetworkContextClient_OnFileUploadRequested_ParamsSpec.$,
        network.mojom.NetworkContextClient_OnFileUploadRequested_ResponseParamsSpec.$,
        impl.onFileUploadRequested.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.NetworkContextClient_OnCanSendReportingReports_ParamsSpec.$,
        network.mojom.NetworkContextClient_OnCanSendReportingReports_ResponseParamsSpec.$,
        impl.onCanSendReportingReports.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.NetworkContextClient_OnCanSendDomainReliabilityUpload_ParamsSpec.$,
        network.mojom.NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParamsSpec.$,
        impl.onCanSendDomainReliabilityUpload.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.NetworkContextClient_OnCanSendSCTAuditingReport_ParamsSpec.$,
        network.mojom.NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParamsSpec.$,
        impl.onCanSendSCTAuditingReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.NetworkContextClient_OnNewSCTAuditingReportSent_ParamsSpec.$,
        null,
        impl.onNewSCTAuditingReportSent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.NetworkContextClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetworkContextClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.NetworkContextClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.NetworkContextClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NetworkContextClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.NetworkContextClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.NetworkContextClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.NetworkContextClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFileUploadRequested =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.NetworkContextClient_OnFileUploadRequested_ParamsSpec.$,
        network.mojom.NetworkContextClient_OnFileUploadRequested_ResponseParamsSpec.$,
        this.onFileUploadRequested.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCanSendReportingReports =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.NetworkContextClient_OnCanSendReportingReports_ParamsSpec.$,
        network.mojom.NetworkContextClient_OnCanSendReportingReports_ResponseParamsSpec.$,
        this.onCanSendReportingReports.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCanSendDomainReliabilityUpload =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.NetworkContextClient_OnCanSendDomainReliabilityUpload_ParamsSpec.$,
        network.mojom.NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParamsSpec.$,
        this.onCanSendDomainReliabilityUpload.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCanSendSCTAuditingReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.NetworkContextClient_OnCanSendSCTAuditingReport_ParamsSpec.$,
        network.mojom.NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParamsSpec.$,
        this.onCanSendSCTAuditingReport.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNewSCTAuditingReportSent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.NetworkContextClient_OnNewSCTAuditingReportSent_ParamsSpec.$,
        null,
        this.onNewSCTAuditingReportSent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContextClient_OnFileUploadRequested_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContextClient_OnFileUploadRequested_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContextClient_OnCanSendReportingReports_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContextClient_OnCanSendReportingReports_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContextClient_OnCanSendDomainReliabilityUpload_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContextClient_OnCanSendSCTAuditingReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContextClient_OnNewSCTAuditingReportSent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.NetworkContextClient_OnFileUploadRequested_ParamsSpec.$,
    'NetworkContextClient_OnFileUploadRequested_Params',
    [
      mojo.internal.StructField(
        'processId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'async', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filePaths', 8,
        0,
        mojo.internal.Array(mojoBase.mojom.FilePathSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'destinationUrl', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.NetworkContextClient_OnFileUploadRequested_Params = class {
  constructor() {
    /** @export { !number } */
    this.processId;
    /** @export { !boolean } */
    this.async;
    /** @export { !Array<!mojoBase.mojom.FilePath> } */
    this.filePaths;
    /** @export { !url.mojom.Url } */
    this.destinationUrl;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContextClient_OnFileUploadRequested_ResponseParamsSpec.$,
    'NetworkContextClient_OnFileUploadRequested_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'files', 8,
        0,
        mojo.internal.Array(mojoBase.mojom.ReadOnlyFileSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.NetworkContextClient_OnFileUploadRequested_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.netError;
    /** @export { !Array<!mojoBase.mojom.ReadOnlyFile> } */
    this.files;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContextClient_OnCanSendReportingReports_ParamsSpec.$,
    'NetworkContextClient_OnCanSendReportingReports_Params',
    [
      mojo.internal.StructField(
        'origins', 0,
        0,
        mojo.internal.Array(url.mojom.OriginSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.NetworkContextClient_OnCanSendReportingReports_Params = class {
  constructor() {
    /** @export { !Array<!url.mojom.Origin> } */
    this.origins;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContextClient_OnCanSendReportingReports_ResponseParamsSpec.$,
    'NetworkContextClient_OnCanSendReportingReports_ResponseParams',
    [
      mojo.internal.StructField(
        'origins', 0,
        0,
        mojo.internal.Array(url.mojom.OriginSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.NetworkContextClient_OnCanSendReportingReports_ResponseParams = class {
  constructor() {
    /** @export { !Array<!url.mojom.Origin> } */
    this.origins;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContextClient_OnCanSendDomainReliabilityUpload_ParamsSpec.$,
    'NetworkContextClient_OnCanSendDomainReliabilityUpload_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.NetworkContextClient_OnCanSendDomainReliabilityUpload_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.origin;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParamsSpec.$,
    'NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams',
    [
      mojo.internal.StructField(
        'allowed', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.allowed;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContextClient_OnCanSendSCTAuditingReport_ParamsSpec.$,
    'NetworkContextClient_OnCanSendSCTAuditingReport_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.NetworkContextClient_OnCanSendSCTAuditingReport_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParamsSpec.$,
    'NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams',
    [
      mojo.internal.StructField(
        'allowed', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.allowed;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContextClient_OnNewSCTAuditingReportSent_ParamsSpec.$,
    'NetworkContextClient_OnNewSCTAuditingReportSent_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.NetworkContextClient_OnNewSCTAuditingReportSent_Params = class {
  constructor() {
  }
};

