// services/network/public/mojom/network_interface_change_listener.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.IPAddress');






goog.provide('network.mojom.NetworkInterfaceChangeListener');
goog.provide('network.mojom.NetworkInterfaceChangeListenerReceiver');
goog.provide('network.mojom.NetworkInterfaceChangeListenerCallbackRouter');
goog.provide('network.mojom.NetworkInterfaceChangeListenerInterface');
goog.provide('network.mojom.NetworkInterfaceChangeListenerRemote');
goog.provide('network.mojom.NetworkInterfaceChangeListenerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.NetworkInterfaceChangeListenerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.NetworkInterfaceChangeListener.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.NetworkInterfaceChangeListenerInterface = class {
  
  /**
   * @param { !network.mojom.NetworkInterfaceChangeParams } params
   */

  onNetworkInterfacesChanged(params) {}
};

/**
 * @export
 * @implements { network.mojom.NetworkInterfaceChangeListenerInterface }
 */
network.mojom.NetworkInterfaceChangeListenerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.NetworkInterfaceChangeListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.NetworkInterfaceChangeListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.NetworkInterfaceChangeListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.NetworkInterfaceChangeParams } params
   */

  onNetworkInterfacesChanged(
      params) {
    this.proxy.sendMessage(
        0,
        network.mojom.NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NetworkInterfaceChangeListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.NetworkInterfaceChangeListenerReceiver = class {
  /**
   * @param {!network.mojom.NetworkInterfaceChangeListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.NetworkInterfaceChangeListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.NetworkInterfaceChangeListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.NetworkInterfaceChangeListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_ParamsSpec.$,
        null,
        impl.onNetworkInterfacesChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.NetworkInterfaceChangeListener = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetworkInterfaceChangeListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.NetworkInterfaceChangeListenerRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.NetworkInterfaceChangeListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NetworkInterfaceChangeListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.NetworkInterfaceChangeListenerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.NetworkInterfaceChangeListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.NetworkInterfaceChangeListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNetworkInterfacesChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_ParamsSpec.$,
        null,
        this.onNetworkInterfacesChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.IfAddrMsgSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.IfAddrMsgSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.AddressMapSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.AddressMapSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.OnlineLinksSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.OnlineLinksSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.InitialAddressMapSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.InitialAddressMapSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkInterfaceChangeParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkInterfaceChangeParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.IfAddrMsgSpec.$,
    'IfAddrMsg',
    [
      mojo.internal.StructField(
        'ifaFamily', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ifaPrefixlen', 1,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ifaFlags', 2,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ifaScope', 3,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ifaIndex', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.IfAddrMsg');

/** @record */
network.mojom.IfAddrMsg = class {
  constructor() {
    /** @export { !number } */
    this.ifaFamily;
    /** @export { !number } */
    this.ifaPrefixlen;
    /** @export { !number } */
    this.ifaFlags;
    /** @export { !number } */
    this.ifaScope;
    /** @export { !number } */
    this.ifaIndex;
  }
};



mojo.internal.Struct(
    network.mojom.AddressMapSpec.$,
    'AddressMap',
    [
      mojo.internal.StructField(
        'addressMap', 0,
        0,
        mojo.internal.Map(network.mojom.IPAddressSpec.$, network.mojom.IfAddrMsgSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.AddressMap');

/** @record */
network.mojom.AddressMap = class {
  constructor() {
    /** @export { !Map<!network.mojom.IPAddress, !network.mojom.IfAddrMsg> } */
    this.addressMap;
  }
};



mojo.internal.Struct(
    network.mojom.OnlineLinksSpec.$,
    'OnlineLinks',
    [
      mojo.internal.StructField(
        'onlineLinks', 0,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.OnlineLinks');

/** @record */
network.mojom.OnlineLinks = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.onlineLinks;
  }
};



mojo.internal.Struct(
    network.mojom.InitialAddressMapSpec.$,
    'InitialAddressMap',
    [
      mojo.internal.StructField(
        'addressMap', 0,
        0,
        network.mojom.AddressMapSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'onlineLinks', 8,
        0,
        network.mojom.OnlineLinksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.InitialAddressMap');

/** @record */
network.mojom.InitialAddressMap = class {
  constructor() {
    /** @export { !network.mojom.AddressMap } */
    this.addressMap;
    /** @export { !network.mojom.OnlineLinks } */
    this.onlineLinks;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkInterfaceChangeParamsSpec.$,
    'NetworkInterfaceChangeParams',
    [
      mojo.internal.StructField(
        'addressMap', 0,
        0,
        mojo.internal.Map(network.mojom.IPAddressSpec.$, network.mojom.IfAddrMsgSpec.$, true),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'onlineLinks', 8,
        0,
        mojo.internal.Map(mojo.internal.Int32, mojo.internal.Bool, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkInterfaceChangeParams');

/** @record */
network.mojom.NetworkInterfaceChangeParams = class {
  constructor() {
    /** @export { !Map<!network.mojom.IPAddress, ?network.mojom.IfAddrMsg> } */
    this.addressMap;
    /** @export { !Object<!number, !boolean> } */
    this.onlineLinks;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_ParamsSpec.$,
    'NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        network.mojom.NetworkInterfaceChangeParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_Params');

/** @record */
network.mojom.NetworkInterfaceChangeListener_OnNetworkInterfacesChanged_Params = class {
  constructor() {
    /** @export { !network.mojom.NetworkInterfaceChangeParams } */
    this.params;
  }
};

