// services/network/public/mojom/network_service_test.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/network_service_test.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var file$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file.mojom', '../../../../mojo/public/mojom/base/file.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var memory_pressure_level$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/memory_pressure_level.mojom', '../../../../mojo/public/mojom/base/memory_pressure_level.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var address_list$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/address_list.mojom', 'address_list.mojom.js');
  }
  var host_resolver$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/host_resolver.mojom', 'host_resolver.mojom.js');
  }
  var network_change_manager$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_change_manager.mojom', 'network_change_manager.mojom.js');
  }
  var network_interface_change_listener$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_interface_change_listener.mojom', 'network_interface_change_listener.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', 'network_param.mojom.js');
  }
  var network_types$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_types.mojom', 'network_types.mojom.js');
  }
  var http_cache_backend_file_operations$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/http_cache_backend_file_operations.mojom', 'http_cache_backend_file_operations.mojom.js');
  }
  var ip_endpoint$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_endpoint.mojom', 'ip_endpoint.mojom.js');
  }
  var transferable_socket$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/transferable_socket.mojom', 'transferable_socket.mojom.js');
  }


  var ResolverType = {};
  ResolverType.kResolverTypeFail = 0;
  ResolverType.kResolverTypeFailTimeout = 1;
  ResolverType.kResolverTypeSystem = 2;
  ResolverType.kResolverTypeIPLiteral = 3;
  ResolverType.kResolverTypeDirectLookup = 4;
  ResolverType.MIN_VALUE = 0;
  ResolverType.MAX_VALUE = 4;

  ResolverType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  ResolverType.toKnownEnumValue = function(value) {
    return value;
  };

  ResolverType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function Rule(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Rule.prototype.initDefaults_ = function() {
    this.resolverType = 0;
    this.hostResolverFlags = 0;
    this.hostPattern = null;
    this.replacement = null;
    this.dnsAliases = null;
  };
  Rule.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Rule.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Rule.resolverType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ResolverType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Rule.hostPattern
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate Rule.replacement
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate Rule.dnsAliases
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Rule.encodedSize = codec.kStructHeaderSize + 32;

  Rule.decode = function(decoder) {
    var packed;
    var val = new Rule();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.resolverType =
        decoder.decodeStruct(new codec.Enum(ResolverType));
    val.hostResolverFlags =
        decoder.decodeStruct(codec.Int32);
    val.hostPattern =
        decoder.decodeStruct(codec.String);
    val.replacement =
        decoder.decodeStruct(codec.String);
    val.dnsAliases =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  Rule.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Rule.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.resolverType);
    encoder.encodeStruct(codec.Int32, val.hostResolverFlags);
    encoder.encodeStruct(codec.String, val.hostPattern);
    encoder.encodeStruct(codec.String, val.replacement);
    encoder.encodeArrayPointer(codec.String, val.dnsAliases);
  };
  function SimpleCacheOpenEntryResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCacheOpenEntryResult.prototype.initDefaults_ = function() {
    this.error = 0;
    this.key = null;
    this.entry = new SimpleCacheEntryPtr();
  };
  SimpleCacheOpenEntryResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCacheOpenEntryResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SimpleCacheOpenEntryResult.key
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SimpleCacheOpenEntryResult.entry
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SimpleCacheOpenEntryResult.encodedSize = codec.kStructHeaderSize + 24;

  SimpleCacheOpenEntryResult.decode = function(decoder) {
    var packed;
    var val = new SimpleCacheOpenEntryResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.key =
        decoder.decodeStruct(codec.String);
    val.entry =
        decoder.decodeStruct(new codec.NullableInterface(SimpleCacheEntryPtr));
    return val;
  };

  SimpleCacheOpenEntryResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCacheOpenEntryResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.key);
    encoder.encodeStruct(new codec.NullableInterface(SimpleCacheEntryPtr), val.entry);
  };
  function SimpleCacheEntry_WriteData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCacheEntry_WriteData_Params.prototype.initDefaults_ = function() {
    this.index = 0;
    this.offset = 0;
    this.data = null;
    this.truncate = false;
  };
  SimpleCacheEntry_WriteData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCacheEntry_WriteData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate SimpleCacheEntry_WriteData_Params.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SimpleCacheEntry_WriteData_Params.encodedSize = codec.kStructHeaderSize + 24;

  SimpleCacheEntry_WriteData_Params.decode = function(decoder) {
    var packed;
    var val = new SimpleCacheEntry_WriteData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.index =
        decoder.decodeStruct(codec.Int32);
    val.offset =
        decoder.decodeStruct(codec.Int32);
    val.data =
        decoder.decodeArrayPointer(codec.Uint8);
    packed = decoder.readUint8();
    val.truncate = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SimpleCacheEntry_WriteData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCacheEntry_WriteData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.index);
    encoder.encodeStruct(codec.Int32, val.offset);
    encoder.encodeArrayPointer(codec.Uint8, val.data);
    packed = 0;
    packed |= (val.truncate & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SimpleCacheEntry_WriteData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCacheEntry_WriteData_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  SimpleCacheEntry_WriteData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCacheEntry_WriteData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SimpleCacheEntry_WriteData_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SimpleCacheEntry_WriteData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SimpleCacheEntry_WriteData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SimpleCacheEntry_WriteData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCacheEntry_WriteData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SimpleCacheEntry_ReadData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCacheEntry_ReadData_Params.prototype.initDefaults_ = function() {
    this.index = 0;
    this.offset = 0;
    this.length = 0;
  };
  SimpleCacheEntry_ReadData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCacheEntry_ReadData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  SimpleCacheEntry_ReadData_Params.encodedSize = codec.kStructHeaderSize + 16;

  SimpleCacheEntry_ReadData_Params.decode = function(decoder) {
    var packed;
    var val = new SimpleCacheEntry_ReadData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.index =
        decoder.decodeStruct(codec.Int32);
    val.offset =
        decoder.decodeStruct(codec.Int32);
    val.length =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SimpleCacheEntry_ReadData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCacheEntry_ReadData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.index);
    encoder.encodeStruct(codec.Int32, val.offset);
    encoder.encodeStruct(codec.Uint32, val.length);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SimpleCacheEntry_ReadData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCacheEntry_ReadData_ResponseParams.prototype.initDefaults_ = function() {
    this.data = null;
    this.result = 0;
  };
  SimpleCacheEntry_ReadData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCacheEntry_ReadData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SimpleCacheEntry_ReadData_ResponseParams.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SimpleCacheEntry_ReadData_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SimpleCacheEntry_ReadData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SimpleCacheEntry_ReadData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeArrayPointer(codec.Uint8);
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SimpleCacheEntry_ReadData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCacheEntry_ReadData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.data);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SimpleCacheEntry_WriteSparseData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCacheEntry_WriteSparseData_Params.prototype.initDefaults_ = function() {
    this.offset = 0;
    this.data = null;
  };
  SimpleCacheEntry_WriteSparseData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCacheEntry_WriteSparseData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SimpleCacheEntry_WriteSparseData_Params.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SimpleCacheEntry_WriteSparseData_Params.encodedSize = codec.kStructHeaderSize + 16;

  SimpleCacheEntry_WriteSparseData_Params.decode = function(decoder) {
    var packed;
    var val = new SimpleCacheEntry_WriteSparseData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.offset =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.data =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  SimpleCacheEntry_WriteSparseData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCacheEntry_WriteSparseData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.offset);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.data);
  };
  function SimpleCacheEntry_WriteSparseData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCacheEntry_WriteSparseData_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  SimpleCacheEntry_WriteSparseData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCacheEntry_WriteSparseData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SimpleCacheEntry_WriteSparseData_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SimpleCacheEntry_WriteSparseData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SimpleCacheEntry_WriteSparseData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SimpleCacheEntry_WriteSparseData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCacheEntry_WriteSparseData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SimpleCacheEntry_ReadSparseData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCacheEntry_ReadSparseData_Params.prototype.initDefaults_ = function() {
    this.offset = 0;
    this.length = 0;
  };
  SimpleCacheEntry_ReadSparseData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCacheEntry_ReadSparseData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SimpleCacheEntry_ReadSparseData_Params.encodedSize = codec.kStructHeaderSize + 8;

  SimpleCacheEntry_ReadSparseData_Params.decode = function(decoder) {
    var packed;
    var val = new SimpleCacheEntry_ReadSparseData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.offset =
        decoder.decodeStruct(codec.Int32);
    val.length =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  SimpleCacheEntry_ReadSparseData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCacheEntry_ReadSparseData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.offset);
    encoder.encodeStruct(codec.Uint32, val.length);
  };
  function SimpleCacheEntry_ReadSparseData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCacheEntry_ReadSparseData_ResponseParams.prototype.initDefaults_ = function() {
    this.data = null;
    this.result = 0;
  };
  SimpleCacheEntry_ReadSparseData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCacheEntry_ReadSparseData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SimpleCacheEntry_ReadSparseData_ResponseParams.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SimpleCacheEntry_ReadSparseData_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SimpleCacheEntry_ReadSparseData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SimpleCacheEntry_ReadSparseData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeArrayPointer(codec.Uint8);
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SimpleCacheEntry_ReadSparseData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCacheEntry_ReadSparseData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.data);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SimpleCacheEntry_Close_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCacheEntry_Close_Params.prototype.initDefaults_ = function() {
  };
  SimpleCacheEntry_Close_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCacheEntry_Close_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SimpleCacheEntry_Close_Params.encodedSize = codec.kStructHeaderSize + 0;

  SimpleCacheEntry_Close_Params.decode = function(decoder) {
    var packed;
    var val = new SimpleCacheEntry_Close_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SimpleCacheEntry_Close_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCacheEntry_Close_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SimpleCacheEntry_Close_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCacheEntry_Close_ResponseParams.prototype.initDefaults_ = function() {
  };
  SimpleCacheEntry_Close_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCacheEntry_Close_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SimpleCacheEntry_Close_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  SimpleCacheEntry_Close_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SimpleCacheEntry_Close_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SimpleCacheEntry_Close_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCacheEntry_Close_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function SimpleCacheEntryEnumerator_GetNext_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCacheEntryEnumerator_GetNext_Params.prototype.initDefaults_ = function() {
  };
  SimpleCacheEntryEnumerator_GetNext_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCacheEntryEnumerator_GetNext_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SimpleCacheEntryEnumerator_GetNext_Params.encodedSize = codec.kStructHeaderSize + 0;

  SimpleCacheEntryEnumerator_GetNext_Params.decode = function(decoder) {
    var packed;
    var val = new SimpleCacheEntryEnumerator_GetNext_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SimpleCacheEntryEnumerator_GetNext_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCacheEntryEnumerator_GetNext_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SimpleCacheEntryEnumerator_GetNext_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCacheEntryEnumerator_GetNext_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SimpleCacheEntryEnumerator_GetNext_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCacheEntryEnumerator_GetNext_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SimpleCacheEntryEnumerator_GetNext_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SimpleCacheOpenEntryResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SimpleCacheEntryEnumerator_GetNext_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SimpleCacheEntryEnumerator_GetNext_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SimpleCacheEntryEnumerator_GetNext_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(SimpleCacheOpenEntryResult);
    return val;
  };

  SimpleCacheEntryEnumerator_GetNext_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCacheEntryEnumerator_GetNext_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SimpleCacheOpenEntryResult, val.result);
  };
  function SimpleCache_CreateEntry_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCache_CreateEntry_Params.prototype.initDefaults_ = function() {
    this.key = null;
  };
  SimpleCache_CreateEntry_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCache_CreateEntry_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SimpleCache_CreateEntry_Params.key
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SimpleCache_CreateEntry_Params.encodedSize = codec.kStructHeaderSize + 8;

  SimpleCache_CreateEntry_Params.decode = function(decoder) {
    var packed;
    var val = new SimpleCache_CreateEntry_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SimpleCache_CreateEntry_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCache_CreateEntry_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.key);
  };
  function SimpleCache_CreateEntry_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCache_CreateEntry_ResponseParams.prototype.initDefaults_ = function() {
    this.entry = new SimpleCacheEntryPtr();
    this.error = 0;
  };
  SimpleCache_CreateEntry_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCache_CreateEntry_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SimpleCache_CreateEntry_ResponseParams.entry
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SimpleCache_CreateEntry_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SimpleCache_CreateEntry_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SimpleCache_CreateEntry_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.entry =
        decoder.decodeStruct(new codec.NullableInterface(SimpleCacheEntryPtr));
    val.error =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SimpleCache_CreateEntry_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCache_CreateEntry_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.NullableInterface(SimpleCacheEntryPtr), val.entry);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SimpleCache_OpenEntry_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCache_OpenEntry_Params.prototype.initDefaults_ = function() {
    this.key = null;
  };
  SimpleCache_OpenEntry_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCache_OpenEntry_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SimpleCache_OpenEntry_Params.key
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SimpleCache_OpenEntry_Params.encodedSize = codec.kStructHeaderSize + 8;

  SimpleCache_OpenEntry_Params.decode = function(decoder) {
    var packed;
    var val = new SimpleCache_OpenEntry_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SimpleCache_OpenEntry_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCache_OpenEntry_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.key);
  };
  function SimpleCache_OpenEntry_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCache_OpenEntry_ResponseParams.prototype.initDefaults_ = function() {
    this.entry = new SimpleCacheEntryPtr();
    this.error = 0;
  };
  SimpleCache_OpenEntry_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCache_OpenEntry_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SimpleCache_OpenEntry_ResponseParams.entry
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SimpleCache_OpenEntry_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SimpleCache_OpenEntry_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SimpleCache_OpenEntry_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.entry =
        decoder.decodeStruct(new codec.NullableInterface(SimpleCacheEntryPtr));
    val.error =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SimpleCache_OpenEntry_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCache_OpenEntry_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.NullableInterface(SimpleCacheEntryPtr), val.entry);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SimpleCache_DoomEntry_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCache_DoomEntry_Params.prototype.initDefaults_ = function() {
    this.key = null;
  };
  SimpleCache_DoomEntry_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCache_DoomEntry_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SimpleCache_DoomEntry_Params.key
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SimpleCache_DoomEntry_Params.encodedSize = codec.kStructHeaderSize + 8;

  SimpleCache_DoomEntry_Params.decode = function(decoder) {
    var packed;
    var val = new SimpleCache_DoomEntry_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SimpleCache_DoomEntry_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCache_DoomEntry_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.key);
  };
  function SimpleCache_DoomEntry_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCache_DoomEntry_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  SimpleCache_DoomEntry_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCache_DoomEntry_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SimpleCache_DoomEntry_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SimpleCache_DoomEntry_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SimpleCache_DoomEntry_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SimpleCache_DoomEntry_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCache_DoomEntry_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SimpleCache_DoomAllEntries_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCache_DoomAllEntries_Params.prototype.initDefaults_ = function() {
  };
  SimpleCache_DoomAllEntries_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCache_DoomAllEntries_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SimpleCache_DoomAllEntries_Params.encodedSize = codec.kStructHeaderSize + 0;

  SimpleCache_DoomAllEntries_Params.decode = function(decoder) {
    var packed;
    var val = new SimpleCache_DoomAllEntries_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SimpleCache_DoomAllEntries_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCache_DoomAllEntries_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SimpleCache_DoomAllEntries_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCache_DoomAllEntries_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  SimpleCache_DoomAllEntries_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCache_DoomAllEntries_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SimpleCache_DoomAllEntries_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SimpleCache_DoomAllEntries_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SimpleCache_DoomAllEntries_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SimpleCache_DoomAllEntries_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCache_DoomAllEntries_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SimpleCache_EnumerateEntries_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCache_EnumerateEntries_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  SimpleCache_EnumerateEntries_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCache_EnumerateEntries_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SimpleCache_EnumerateEntries_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SimpleCache_EnumerateEntries_Params.encodedSize = codec.kStructHeaderSize + 8;

  SimpleCache_EnumerateEntries_Params.decode = function(decoder) {
    var packed;
    var val = new SimpleCache_EnumerateEntries_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SimpleCache_EnumerateEntries_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCache_EnumerateEntries_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SimpleCache_Detach_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCache_Detach_Params.prototype.initDefaults_ = function() {
  };
  SimpleCache_Detach_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCache_Detach_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SimpleCache_Detach_Params.encodedSize = codec.kStructHeaderSize + 0;

  SimpleCache_Detach_Params.decode = function(decoder) {
    var packed;
    var val = new SimpleCache_Detach_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SimpleCache_Detach_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCache_Detach_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SimpleCache_Detach_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SimpleCache_Detach_ResponseParams.prototype.initDefaults_ = function() {
  };
  SimpleCache_Detach_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SimpleCache_Detach_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SimpleCache_Detach_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  SimpleCache_Detach_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SimpleCache_Detach_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SimpleCache_Detach_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SimpleCache_Detach_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_AddRules_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_AddRules_Params.prototype.initDefaults_ = function() {
    this.rules = null;
  };
  NetworkServiceTest_AddRules_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_AddRules_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_AddRules_Params.rules
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(Rule), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_AddRules_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_AddRules_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_AddRules_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rules =
        decoder.decodeArrayPointer(new codec.PointerTo(Rule));
    return val;
  };

  NetworkServiceTest_AddRules_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_AddRules_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(Rule), val.rules);
  };
  function NetworkServiceTest_AddRules_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_AddRules_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_AddRules_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_AddRules_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_AddRules_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_AddRules_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_AddRules_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_AddRules_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_AddRules_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_SimulateNetworkChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SimulateNetworkChange_Params.prototype.initDefaults_ = function() {
    this.type = 0;
  };
  NetworkServiceTest_SimulateNetworkChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SimulateNetworkChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_SimulateNetworkChange_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, network_change_manager$.ConnectionType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_SimulateNetworkChange_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_SimulateNetworkChange_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SimulateNetworkChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(network_change_manager$.ConnectionType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_SimulateNetworkChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SimulateNetworkChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkServiceTest_SimulateNetworkChange_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SimulateNetworkChange_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_SimulateNetworkChange_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SimulateNetworkChange_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_SimulateNetworkChange_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_SimulateNetworkChange_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SimulateNetworkChange_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_SimulateNetworkChange_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SimulateNetworkChange_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_SimulateNetworkQualityChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SimulateNetworkQualityChange_Params.prototype.initDefaults_ = function() {
    this.type = 0;
  };
  NetworkServiceTest_SimulateNetworkQualityChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SimulateNetworkQualityChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_SimulateNetworkQualityChange_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, network_types$.EffectiveConnectionType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_SimulateNetworkQualityChange_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_SimulateNetworkQualityChange_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SimulateNetworkQualityChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(network_types$.EffectiveConnectionType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_SimulateNetworkQualityChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SimulateNetworkQualityChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_SimulateCrash_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SimulateCrash_Params.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_SimulateCrash_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SimulateCrash_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_SimulateCrash_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_SimulateCrash_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SimulateCrash_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_SimulateCrash_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SimulateCrash_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_MockCertVerifierSetDefaultResult_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_MockCertVerifierSetDefaultResult_Params.prototype.initDefaults_ = function() {
    this.defaultResult = 0;
  };
  NetworkServiceTest_MockCertVerifierSetDefaultResult_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_MockCertVerifierSetDefaultResult_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkServiceTest_MockCertVerifierSetDefaultResult_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_MockCertVerifierSetDefaultResult_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_MockCertVerifierSetDefaultResult_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.defaultResult =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_MockCertVerifierSetDefaultResult_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_MockCertVerifierSetDefaultResult_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.defaultResult);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params.prototype.initDefaults_ = function() {
    this.cert = null;
    this.hostPattern = null;
    this.verifyResult = null;
    this.rv = 0;
  };
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params.cert
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.X509Certificate, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params.hostPattern
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params.verifyResult
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, network_param$.CertVerifyResult, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params.encodedSize = codec.kStructHeaderSize + 32;

  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cert =
        decoder.decodeStructPointer(network_param$.X509Certificate);
    val.hostPattern =
        decoder.decodeStruct(codec.String);
    val.verifyResult =
        decoder.decodeStructPointer(network_param$.CertVerifyResult);
    val.rv =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.X509Certificate, val.cert);
    encoder.encodeStruct(codec.String, val.hostPattern);
    encoder.encodeStructPointer(network_param$.CertVerifyResult, val.verifyResult);
    encoder.encodeStruct(codec.Int32, val.rv);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_SetTransportSecurityStateTestSource_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SetTransportSecurityStateTestSource_Params.prototype.initDefaults_ = function() {
    this.enableUnittestSource = false;
  };
  NetworkServiceTest_SetTransportSecurityStateTestSource_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SetTransportSecurityStateTestSource_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkServiceTest_SetTransportSecurityStateTestSource_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_SetTransportSecurityStateTestSource_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SetTransportSecurityStateTestSource_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enableUnittestSource = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_SetTransportSecurityStateTestSource_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SetTransportSecurityStateTestSource_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enableUnittestSource & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_ReplaceSystemDnsConfig_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_ReplaceSystemDnsConfig_Params.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_ReplaceSystemDnsConfig_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_ReplaceSystemDnsConfig_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_ReplaceSystemDnsConfig_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_ReplaceSystemDnsConfig_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_ReplaceSystemDnsConfig_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_ReplaceSystemDnsConfig_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_ReplaceSystemDnsConfig_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_SetTestDohConfig_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SetTestDohConfig_Params.prototype.initDefaults_ = function() {
    this.secureDnsMode = 0;
    this.dohConfig = null;
  };
  NetworkServiceTest_SetTestDohConfig_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SetTestDohConfig_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_SetTestDohConfig_Params.secureDnsMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, host_resolver$.SecureDnsMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_SetTestDohConfig_Params.dohConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, host_resolver$.DnsOverHttpsConfig, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_SetTestDohConfig_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkServiceTest_SetTestDohConfig_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SetTestDohConfig_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.secureDnsMode =
        decoder.decodeStruct(new codec.Enum(host_resolver$.SecureDnsMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.dohConfig =
        decoder.decodeStructPointer(host_resolver$.DnsOverHttpsConfig);
    return val;
  };

  NetworkServiceTest_SetTestDohConfig_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SetTestDohConfig_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.secureDnsMode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(host_resolver$.DnsOverHttpsConfig, val.dohConfig);
  };
  function NetworkServiceTest_SetTestDohConfig_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SetTestDohConfig_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_SetTestDohConfig_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SetTestDohConfig_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_SetTestDohConfig_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_SetTestDohConfig_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SetTestDohConfig_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_SetTestDohConfig_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SetTestDohConfig_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_CrashOnResolveHost_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_CrashOnResolveHost_Params.prototype.initDefaults_ = function() {
    this.host = null;
  };
  NetworkServiceTest_CrashOnResolveHost_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_CrashOnResolveHost_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_CrashOnResolveHost_Params.host
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_CrashOnResolveHost_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_CrashOnResolveHost_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_CrashOnResolveHost_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.host =
        decoder.decodeStruct(codec.String);
    return val;
  };

  NetworkServiceTest_CrashOnResolveHost_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_CrashOnResolveHost_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.host);
  };
  function NetworkServiceTest_CrashOnGetCookieList_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_CrashOnGetCookieList_Params.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_CrashOnGetCookieList_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_CrashOnGetCookieList_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_CrashOnGetCookieList_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_CrashOnGetCookieList_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_CrashOnGetCookieList_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_CrashOnGetCookieList_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_CrashOnGetCookieList_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_GetLatestMemoryPressureLevel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_GetLatestMemoryPressureLevel_Params.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_GetLatestMemoryPressureLevel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_GetLatestMemoryPressureLevel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_GetLatestMemoryPressureLevel_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_GetLatestMemoryPressureLevel_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_GetLatestMemoryPressureLevel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_GetLatestMemoryPressureLevel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_GetLatestMemoryPressureLevel_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams.prototype.initDefaults_ = function() {
    this.memoryPressureLevel = 0;
  };
  NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams.memoryPressureLevel
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, memory_pressure_level$.MemoryPressureLevel);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.memoryPressureLevel =
        decoder.decodeStruct(new codec.Enum(memory_pressure_level$.MemoryPressureLevel));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.memoryPressureLevel);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams.prototype.initDefaults_ = function() {
    this.connectionCount = 0;
  };
  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.connectionCount =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.connectionCount);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkServiceTest_GetEnvironmentVariableValue_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_GetEnvironmentVariableValue_Params.prototype.initDefaults_ = function() {
    this.name = null;
  };
  NetworkServiceTest_GetEnvironmentVariableValue_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_GetEnvironmentVariableValue_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_GetEnvironmentVariableValue_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_GetEnvironmentVariableValue_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_GetEnvironmentVariableValue_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_GetEnvironmentVariableValue_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    return val;
  };

  NetworkServiceTest_GetEnvironmentVariableValue_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_GetEnvironmentVariableValue_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
  };
  function NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams.prototype.initDefaults_ = function() {
    this.value = null;
  };
  NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams.value
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.String);
    return val;
  };

  NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.value);
  };
  function NetworkServiceTest_Log_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_Log_Params.prototype.initDefaults_ = function() {
    this.message = null;
  };
  NetworkServiceTest_Log_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_Log_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_Log_Params.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_Log_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_Log_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_Log_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.message =
        decoder.decodeStruct(codec.String);
    return val;
  };

  NetworkServiceTest_Log_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_Log_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.message);
  };
  function NetworkServiceTest_Log_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_Log_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_Log_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_Log_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_Log_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_Log_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_Log_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_Log_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_Log_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_ActivateFieldTrial_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_ActivateFieldTrial_Params.prototype.initDefaults_ = function() {
    this.fieldTrialName = null;
  };
  NetworkServiceTest_ActivateFieldTrial_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_ActivateFieldTrial_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_ActivateFieldTrial_Params.fieldTrialName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_ActivateFieldTrial_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_ActivateFieldTrial_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_ActivateFieldTrial_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.fieldTrialName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  NetworkServiceTest_ActivateFieldTrial_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_ActivateFieldTrial_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.fieldTrialName);
  };
  function NetworkServiceTest_SetSCTAuditingRetryDelay_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SetSCTAuditingRetryDelay_Params.prototype.initDefaults_ = function() {
    this.delay = null;
  };
  NetworkServiceTest_SetSCTAuditingRetryDelay_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SetSCTAuditingRetryDelay_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_SetSCTAuditingRetryDelay_Params.delay
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_SetSCTAuditingRetryDelay_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_SetSCTAuditingRetryDelay_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SetSCTAuditingRetryDelay_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.delay =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  NetworkServiceTest_SetSCTAuditingRetryDelay_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SetSCTAuditingRetryDelay_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.delay);
  };
  function NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_OpenFile_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_OpenFile_Params.prototype.initDefaults_ = function() {
    this.path = null;
  };
  NetworkServiceTest_OpenFile_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_OpenFile_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_OpenFile_Params.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_OpenFile_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_OpenFile_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_OpenFile_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    return val;
  };

  NetworkServiceTest_OpenFile_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_OpenFile_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
  };
  function NetworkServiceTest_OpenFile_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_OpenFile_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  NetworkServiceTest_OpenFile_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_OpenFile_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkServiceTest_OpenFile_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_OpenFile_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_OpenFile_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_OpenFile_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_OpenFile_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkServiceTest_EnumerateFiles_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_EnumerateFiles_Params.prototype.initDefaults_ = function() {
    this.path = null;
    this.factory = new http_cache_backend_file_operations$.HttpCacheBackendFileOperationsFactoryPtr();
  };
  NetworkServiceTest_EnumerateFiles_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_EnumerateFiles_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_EnumerateFiles_Params.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_EnumerateFiles_Params.factory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_EnumerateFiles_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkServiceTest_EnumerateFiles_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_EnumerateFiles_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.factory =
        decoder.decodeStruct(new codec.Interface(http_cache_backend_file_operations$.HttpCacheBackendFileOperationsFactoryPtr));
    return val;
  };

  NetworkServiceTest_EnumerateFiles_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_EnumerateFiles_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
    encoder.encodeStruct(new codec.Interface(http_cache_backend_file_operations$.HttpCacheBackendFileOperationsFactoryPtr), val.factory);
  };
  function NetworkServiceTest_EnumerateFiles_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_EnumerateFiles_ResponseParams.prototype.initDefaults_ = function() {
    this.entries = null;
    this.error = false;
  };
  NetworkServiceTest_EnumerateFiles_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_EnumerateFiles_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_EnumerateFiles_ResponseParams.entries
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(http_cache_backend_file_operations$.FileEnumerationEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkServiceTest_EnumerateFiles_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  NetworkServiceTest_EnumerateFiles_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_EnumerateFiles_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.entries =
        decoder.decodeArrayPointer(new codec.PointerTo(http_cache_backend_file_operations$.FileEnumerationEntry));
    packed = decoder.readUint8();
    val.error = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_EnumerateFiles_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_EnumerateFiles_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(http_cache_backend_file_operations$.FileEnumerationEntry), val.entries);
    packed = 0;
    packed |= (val.error & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkServiceTest_CreateSimpleCache_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_CreateSimpleCache_Params.prototype.initDefaults_ = function() {
    this.factory = new http_cache_backend_file_operations$.HttpCacheBackendFileOperationsFactoryPtr();
    this.path = null;
    this.reset = false;
  };
  NetworkServiceTest_CreateSimpleCache_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_CreateSimpleCache_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_CreateSimpleCache_Params.factory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_CreateSimpleCache_Params.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkServiceTest_CreateSimpleCache_Params.encodedSize = codec.kStructHeaderSize + 24;

  NetworkServiceTest_CreateSimpleCache_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_CreateSimpleCache_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.factory =
        decoder.decodeStruct(new codec.Interface(http_cache_backend_file_operations$.HttpCacheBackendFileOperationsFactoryPtr));
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    packed = decoder.readUint8();
    val.reset = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_CreateSimpleCache_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_CreateSimpleCache_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(http_cache_backend_file_operations$.HttpCacheBackendFileOperationsFactoryPtr), val.factory);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
    packed = 0;
    packed |= (val.reset & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkServiceTest_CreateSimpleCache_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_CreateSimpleCache_ResponseParams.prototype.initDefaults_ = function() {
    this.backend = new SimpleCachePtr();
  };
  NetworkServiceTest_CreateSimpleCache_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_CreateSimpleCache_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_CreateSimpleCache_ResponseParams.backend
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_CreateSimpleCache_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_CreateSimpleCache_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_CreateSimpleCache_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.backend =
        decoder.decodeStruct(new codec.NullableInterface(SimpleCachePtr));
    return val;
  };

  NetworkServiceTest_CreateSimpleCache_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_CreateSimpleCache_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.NullableInterface(SimpleCachePtr), val.backend);
  };
  function NetworkServiceTest_MakeRequestToServer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_MakeRequestToServer_Params.prototype.initDefaults_ = function() {
    this.s = null;
    this.endpoint = null;
  };
  NetworkServiceTest_MakeRequestToServer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_MakeRequestToServer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_MakeRequestToServer_Params.s
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, transferable_socket$.TransferableSocket, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_MakeRequestToServer_Params.endpoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ip_endpoint$.IPEndPoint, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_MakeRequestToServer_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkServiceTest_MakeRequestToServer_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_MakeRequestToServer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.s =
        decoder.decodeStructPointer(transferable_socket$.TransferableSocket);
    val.endpoint =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    return val;
  };

  NetworkServiceTest_MakeRequestToServer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_MakeRequestToServer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(transferable_socket$.TransferableSocket, val.s);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.endpoint);
  };
  function NetworkServiceTest_MakeRequestToServer_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_MakeRequestToServer_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  NetworkServiceTest_MakeRequestToServer_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_MakeRequestToServer_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkServiceTest_MakeRequestToServer_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_MakeRequestToServer_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_MakeRequestToServer_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_MakeRequestToServer_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_MakeRequestToServer_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams.prototype.initDefaults_ = function() {
    this.addrList = null;
    this.osError = 0;
    this.netError = 0;
  };
  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams.addrList
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, address_list$.AddressList, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.addrList =
        decoder.decodeStructPointer(address_list$.AddressList);
    val.osError =
        decoder.decodeStruct(codec.Int32);
    val.netError =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(address_list$.AddressList, val.addrList);
    encoder.encodeStruct(codec.Int32, val.osError);
    encoder.encodeStruct(codec.Int32, val.netError);
  };
  function NetworkServiceTest_SetIPv6ProbeResult_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SetIPv6ProbeResult_Params.prototype.initDefaults_ = function() {
    this.success = false;
  };
  NetworkServiceTest_SetIPv6ProbeResult_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SetIPv6ProbeResult_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkServiceTest_SetIPv6ProbeResult_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_SetIPv6ProbeResult_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SetIPv6ProbeResult_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_SetIPv6ProbeResult_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SetIPv6ProbeResult_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkServiceTest_SetIPv6ProbeResult_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_SetIPv6ProbeResult_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_SetIPv6ProbeResult_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_SetIPv6ProbeResult_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_SetIPv6ProbeResult_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_SetIPv6ProbeResult_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_SetIPv6ProbeResult_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_SetIPv6ProbeResult_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_SetIPv6ProbeResult_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_GetAddressMapCacheLinux_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_GetAddressMapCacheLinux_Params.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_GetAddressMapCacheLinux_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_GetAddressMapCacheLinux_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_GetAddressMapCacheLinux_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_GetAddressMapCacheLinux_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_GetAddressMapCacheLinux_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_GetAddressMapCacheLinux_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_GetAddressMapCacheLinux_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams.prototype.initDefaults_ = function() {
    this.addrMap = null;
    this.links = null;
  };
  NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams.addrMap
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_interface_change_listener$.AddressMap, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams.links
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_interface_change_listener$.OnlineLinks, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.addrMap =
        decoder.decodeStructPointer(network_interface_change_listener$.AddressMap);
    val.links =
        decoder.decodeStructPointer(network_interface_change_listener$.OnlineLinks);
    return val;
  };

  NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_interface_change_listener$.AddressMap, val.addrMap);
    encoder.encodeStructPointer(network_interface_change_listener$.OnlineLinks, val.links);
  };
  function NetworkServiceTest_AllowsGSSAPILibraryLoad_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_AllowsGSSAPILibraryLoad_Params.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_AllowsGSSAPILibraryLoad_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_AllowsGSSAPILibraryLoad_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_AllowsGSSAPILibraryLoad_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_AllowsGSSAPILibraryLoad_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_AllowsGSSAPILibraryLoad_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_AllowsGSSAPILibraryLoad_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_AllowsGSSAPILibraryLoad_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams.prototype.initDefaults_ = function() {
    this.allowGssapiLibraryLoad = false;
  };
  NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.allowGssapiLibraryLoad = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.allowGssapiLibraryLoad & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkServiceTest_IsHappyEyeballsV3Enabled_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_IsHappyEyeballsV3Enabled_Params.prototype.initDefaults_ = function() {
  };
  NetworkServiceTest_IsHappyEyeballsV3Enabled_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_IsHappyEyeballsV3Enabled_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceTest_IsHappyEyeballsV3Enabled_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkServiceTest_IsHappyEyeballsV3Enabled_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_IsHappyEyeballsV3Enabled_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkServiceTest_IsHappyEyeballsV3Enabled_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_IsHappyEyeballsV3Enabled_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams.prototype.initDefaults_ = function() {
    this.isHappyEyeballsV3Enabled = false;
  };
  NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isHappyEyeballsV3Enabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isHappyEyeballsV3Enabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kSimpleCacheEntry_WriteData_Name = 0;
  var kSimpleCacheEntry_ReadData_Name = 1;
  var kSimpleCacheEntry_WriteSparseData_Name = 2;
  var kSimpleCacheEntry_ReadSparseData_Name = 3;
  var kSimpleCacheEntry_Close_Name = 4;

  function SimpleCacheEntryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SimpleCacheEntry,
                                                   handleOrPtrInfo);
  }

  function SimpleCacheEntryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SimpleCacheEntry, associatedInterfacePtrInfo);
  }

  SimpleCacheEntryAssociatedPtr.prototype =
      Object.create(SimpleCacheEntryPtr.prototype);
  SimpleCacheEntryAssociatedPtr.prototype.constructor =
      SimpleCacheEntryAssociatedPtr;

  function SimpleCacheEntryProxy(receiver) {
    this.receiver_ = receiver;
  }
  SimpleCacheEntryPtr.prototype.writeData = function() {
    return SimpleCacheEntryProxy.prototype.writeData
        .apply(this.ptr.getProxy(), arguments);
  };

  SimpleCacheEntryProxy.prototype.writeData = function(index, offset, data, truncate) {
    var params_ = new SimpleCacheEntry_WriteData_Params();
    params_.index = index;
    params_.offset = offset;
    params_.data = data;
    params_.truncate = truncate;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSimpleCacheEntry_WriteData_Name,
          codec.align(SimpleCacheEntry_WriteData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SimpleCacheEntry_WriteData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SimpleCacheEntry_WriteData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SimpleCacheEntryPtr.prototype.readData = function() {
    return SimpleCacheEntryProxy.prototype.readData
        .apply(this.ptr.getProxy(), arguments);
  };

  SimpleCacheEntryProxy.prototype.readData = function(index, offset, length) {
    var params_ = new SimpleCacheEntry_ReadData_Params();
    params_.index = index;
    params_.offset = offset;
    params_.length = length;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSimpleCacheEntry_ReadData_Name,
          codec.align(SimpleCacheEntry_ReadData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SimpleCacheEntry_ReadData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SimpleCacheEntry_ReadData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SimpleCacheEntryPtr.prototype.writeSparseData = function() {
    return SimpleCacheEntryProxy.prototype.writeSparseData
        .apply(this.ptr.getProxy(), arguments);
  };

  SimpleCacheEntryProxy.prototype.writeSparseData = function(offset, data) {
    var params_ = new SimpleCacheEntry_WriteSparseData_Params();
    params_.offset = offset;
    params_.data = data;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSimpleCacheEntry_WriteSparseData_Name,
          codec.align(SimpleCacheEntry_WriteSparseData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SimpleCacheEntry_WriteSparseData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SimpleCacheEntry_WriteSparseData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SimpleCacheEntryPtr.prototype.readSparseData = function() {
    return SimpleCacheEntryProxy.prototype.readSparseData
        .apply(this.ptr.getProxy(), arguments);
  };

  SimpleCacheEntryProxy.prototype.readSparseData = function(offset, length) {
    var params_ = new SimpleCacheEntry_ReadSparseData_Params();
    params_.offset = offset;
    params_.length = length;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSimpleCacheEntry_ReadSparseData_Name,
          codec.align(SimpleCacheEntry_ReadSparseData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SimpleCacheEntry_ReadSparseData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SimpleCacheEntry_ReadSparseData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SimpleCacheEntryPtr.prototype.close = function() {
    return SimpleCacheEntryProxy.prototype.close
        .apply(this.ptr.getProxy(), arguments);
  };

  SimpleCacheEntryProxy.prototype.close = function() {
    var params_ = new SimpleCacheEntry_Close_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSimpleCacheEntry_Close_Name,
          codec.align(SimpleCacheEntry_Close_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SimpleCacheEntry_Close_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SimpleCacheEntry_Close_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SimpleCacheEntryStub(delegate) {
    this.delegate_ = delegate;
  }
  SimpleCacheEntryStub.prototype.writeData = function(index, offset, data, truncate) {
    return this.delegate_ && this.delegate_.writeData && this.delegate_.writeData(index, offset, data, truncate);
  }
  SimpleCacheEntryStub.prototype.readData = function(index, offset, length) {
    return this.delegate_ && this.delegate_.readData && this.delegate_.readData(index, offset, length);
  }
  SimpleCacheEntryStub.prototype.writeSparseData = function(offset, data) {
    return this.delegate_ && this.delegate_.writeSparseData && this.delegate_.writeSparseData(offset, data);
  }
  SimpleCacheEntryStub.prototype.readSparseData = function(offset, length) {
    return this.delegate_ && this.delegate_.readSparseData && this.delegate_.readSparseData(offset, length);
  }
  SimpleCacheEntryStub.prototype.close = function() {
    return this.delegate_ && this.delegate_.close && this.delegate_.close();
  }

  SimpleCacheEntryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  SimpleCacheEntryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSimpleCacheEntry_WriteData_Name:
      var params = reader.decodeStruct(SimpleCacheEntry_WriteData_Params);
      this.writeData(params.index, params.offset, params.data, params.truncate).then(function(response) {
        var responseParams =
            new SimpleCacheEntry_WriteData_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSimpleCacheEntry_WriteData_Name,
            codec.align(SimpleCacheEntry_WriteData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SimpleCacheEntry_WriteData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSimpleCacheEntry_ReadData_Name:
      var params = reader.decodeStruct(SimpleCacheEntry_ReadData_Params);
      this.readData(params.index, params.offset, params.length).then(function(response) {
        var responseParams =
            new SimpleCacheEntry_ReadData_ResponseParams();
        responseParams.data = response.data;
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSimpleCacheEntry_ReadData_Name,
            codec.align(SimpleCacheEntry_ReadData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SimpleCacheEntry_ReadData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSimpleCacheEntry_WriteSparseData_Name:
      var params = reader.decodeStruct(SimpleCacheEntry_WriteSparseData_Params);
      this.writeSparseData(params.offset, params.data).then(function(response) {
        var responseParams =
            new SimpleCacheEntry_WriteSparseData_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSimpleCacheEntry_WriteSparseData_Name,
            codec.align(SimpleCacheEntry_WriteSparseData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SimpleCacheEntry_WriteSparseData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSimpleCacheEntry_ReadSparseData_Name:
      var params = reader.decodeStruct(SimpleCacheEntry_ReadSparseData_Params);
      this.readSparseData(params.offset, params.length).then(function(response) {
        var responseParams =
            new SimpleCacheEntry_ReadSparseData_ResponseParams();
        responseParams.data = response.data;
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSimpleCacheEntry_ReadSparseData_Name,
            codec.align(SimpleCacheEntry_ReadSparseData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SimpleCacheEntry_ReadSparseData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSimpleCacheEntry_Close_Name:
      var params = reader.decodeStruct(SimpleCacheEntry_Close_Params);
      this.close().then(function(response) {
        var responseParams =
            new SimpleCacheEntry_Close_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kSimpleCacheEntry_Close_Name,
            codec.align(SimpleCacheEntry_Close_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SimpleCacheEntry_Close_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSimpleCacheEntryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSimpleCacheEntry_WriteData_Name:
        if (message.expectsResponse())
          paramsClass = SimpleCacheEntry_WriteData_Params;
      break;
      case kSimpleCacheEntry_ReadData_Name:
        if (message.expectsResponse())
          paramsClass = SimpleCacheEntry_ReadData_Params;
      break;
      case kSimpleCacheEntry_WriteSparseData_Name:
        if (message.expectsResponse())
          paramsClass = SimpleCacheEntry_WriteSparseData_Params;
      break;
      case kSimpleCacheEntry_ReadSparseData_Name:
        if (message.expectsResponse())
          paramsClass = SimpleCacheEntry_ReadSparseData_Params;
      break;
      case kSimpleCacheEntry_Close_Name:
        if (message.expectsResponse())
          paramsClass = SimpleCacheEntry_Close_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSimpleCacheEntryResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSimpleCacheEntry_WriteData_Name:
        if (message.isResponse())
          paramsClass = SimpleCacheEntry_WriteData_ResponseParams;
        break;
      case kSimpleCacheEntry_ReadData_Name:
        if (message.isResponse())
          paramsClass = SimpleCacheEntry_ReadData_ResponseParams;
        break;
      case kSimpleCacheEntry_WriteSparseData_Name:
        if (message.isResponse())
          paramsClass = SimpleCacheEntry_WriteSparseData_ResponseParams;
        break;
      case kSimpleCacheEntry_ReadSparseData_Name:
        if (message.isResponse())
          paramsClass = SimpleCacheEntry_ReadSparseData_ResponseParams;
        break;
      case kSimpleCacheEntry_Close_Name:
        if (message.isResponse())
          paramsClass = SimpleCacheEntry_Close_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SimpleCacheEntry = {
    name: 'network.mojom.SimpleCacheEntry',
    kVersion: 0,
    ptrClass: SimpleCacheEntryPtr,
    proxyClass: SimpleCacheEntryProxy,
    stubClass: SimpleCacheEntryStub,
    validateRequest: validateSimpleCacheEntryRequest,
    validateResponse: validateSimpleCacheEntryResponse,
  };
  SimpleCacheEntryStub.prototype.validator = validateSimpleCacheEntryRequest;
  SimpleCacheEntryProxy.prototype.validator = validateSimpleCacheEntryResponse;
  var kSimpleCacheEntryEnumerator_GetNext_Name = 0;

  function SimpleCacheEntryEnumeratorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SimpleCacheEntryEnumerator,
                                                   handleOrPtrInfo);
  }

  function SimpleCacheEntryEnumeratorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SimpleCacheEntryEnumerator, associatedInterfacePtrInfo);
  }

  SimpleCacheEntryEnumeratorAssociatedPtr.prototype =
      Object.create(SimpleCacheEntryEnumeratorPtr.prototype);
  SimpleCacheEntryEnumeratorAssociatedPtr.prototype.constructor =
      SimpleCacheEntryEnumeratorAssociatedPtr;

  function SimpleCacheEntryEnumeratorProxy(receiver) {
    this.receiver_ = receiver;
  }
  SimpleCacheEntryEnumeratorPtr.prototype.getNext = function() {
    return SimpleCacheEntryEnumeratorProxy.prototype.getNext
        .apply(this.ptr.getProxy(), arguments);
  };

  SimpleCacheEntryEnumeratorProxy.prototype.getNext = function() {
    var params_ = new SimpleCacheEntryEnumerator_GetNext_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSimpleCacheEntryEnumerator_GetNext_Name,
          codec.align(SimpleCacheEntryEnumerator_GetNext_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SimpleCacheEntryEnumerator_GetNext_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SimpleCacheEntryEnumerator_GetNext_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SimpleCacheEntryEnumeratorStub(delegate) {
    this.delegate_ = delegate;
  }
  SimpleCacheEntryEnumeratorStub.prototype.getNext = function() {
    return this.delegate_ && this.delegate_.getNext && this.delegate_.getNext();
  }

  SimpleCacheEntryEnumeratorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  SimpleCacheEntryEnumeratorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSimpleCacheEntryEnumerator_GetNext_Name:
      var params = reader.decodeStruct(SimpleCacheEntryEnumerator_GetNext_Params);
      this.getNext().then(function(response) {
        var responseParams =
            new SimpleCacheEntryEnumerator_GetNext_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSimpleCacheEntryEnumerator_GetNext_Name,
            codec.align(SimpleCacheEntryEnumerator_GetNext_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SimpleCacheEntryEnumerator_GetNext_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSimpleCacheEntryEnumeratorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSimpleCacheEntryEnumerator_GetNext_Name:
        if (message.expectsResponse())
          paramsClass = SimpleCacheEntryEnumerator_GetNext_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSimpleCacheEntryEnumeratorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSimpleCacheEntryEnumerator_GetNext_Name:
        if (message.isResponse())
          paramsClass = SimpleCacheEntryEnumerator_GetNext_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SimpleCacheEntryEnumerator = {
    name: 'network.mojom.SimpleCacheEntryEnumerator',
    kVersion: 0,
    ptrClass: SimpleCacheEntryEnumeratorPtr,
    proxyClass: SimpleCacheEntryEnumeratorProxy,
    stubClass: SimpleCacheEntryEnumeratorStub,
    validateRequest: validateSimpleCacheEntryEnumeratorRequest,
    validateResponse: validateSimpleCacheEntryEnumeratorResponse,
  };
  SimpleCacheEntryEnumeratorStub.prototype.validator = validateSimpleCacheEntryEnumeratorRequest;
  SimpleCacheEntryEnumeratorProxy.prototype.validator = validateSimpleCacheEntryEnumeratorResponse;
  var kSimpleCache_CreateEntry_Name = 0;
  var kSimpleCache_OpenEntry_Name = 1;
  var kSimpleCache_DoomEntry_Name = 2;
  var kSimpleCache_DoomAllEntries_Name = 3;
  var kSimpleCache_EnumerateEntries_Name = 4;
  var kSimpleCache_Detach_Name = 5;

  function SimpleCachePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SimpleCache,
                                                   handleOrPtrInfo);
  }

  function SimpleCacheAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SimpleCache, associatedInterfacePtrInfo);
  }

  SimpleCacheAssociatedPtr.prototype =
      Object.create(SimpleCachePtr.prototype);
  SimpleCacheAssociatedPtr.prototype.constructor =
      SimpleCacheAssociatedPtr;

  function SimpleCacheProxy(receiver) {
    this.receiver_ = receiver;
  }
  SimpleCachePtr.prototype.createEntry = function() {
    return SimpleCacheProxy.prototype.createEntry
        .apply(this.ptr.getProxy(), arguments);
  };

  SimpleCacheProxy.prototype.createEntry = function(key) {
    var params_ = new SimpleCache_CreateEntry_Params();
    params_.key = key;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSimpleCache_CreateEntry_Name,
          codec.align(SimpleCache_CreateEntry_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SimpleCache_CreateEntry_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SimpleCache_CreateEntry_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SimpleCachePtr.prototype.openEntry = function() {
    return SimpleCacheProxy.prototype.openEntry
        .apply(this.ptr.getProxy(), arguments);
  };

  SimpleCacheProxy.prototype.openEntry = function(key) {
    var params_ = new SimpleCache_OpenEntry_Params();
    params_.key = key;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSimpleCache_OpenEntry_Name,
          codec.align(SimpleCache_OpenEntry_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SimpleCache_OpenEntry_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SimpleCache_OpenEntry_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SimpleCachePtr.prototype.doomEntry = function() {
    return SimpleCacheProxy.prototype.doomEntry
        .apply(this.ptr.getProxy(), arguments);
  };

  SimpleCacheProxy.prototype.doomEntry = function(key) {
    var params_ = new SimpleCache_DoomEntry_Params();
    params_.key = key;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSimpleCache_DoomEntry_Name,
          codec.align(SimpleCache_DoomEntry_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SimpleCache_DoomEntry_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SimpleCache_DoomEntry_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SimpleCachePtr.prototype.doomAllEntries = function() {
    return SimpleCacheProxy.prototype.doomAllEntries
        .apply(this.ptr.getProxy(), arguments);
  };

  SimpleCacheProxy.prototype.doomAllEntries = function() {
    var params_ = new SimpleCache_DoomAllEntries_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSimpleCache_DoomAllEntries_Name,
          codec.align(SimpleCache_DoomAllEntries_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SimpleCache_DoomAllEntries_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SimpleCache_DoomAllEntries_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SimpleCachePtr.prototype.enumerateEntries = function() {
    return SimpleCacheProxy.prototype.enumerateEntries
        .apply(this.ptr.getProxy(), arguments);
  };

  SimpleCacheProxy.prototype.enumerateEntries = function(receiver) {
    var params_ = new SimpleCache_EnumerateEntries_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kSimpleCache_EnumerateEntries_Name,
        codec.align(SimpleCache_EnumerateEntries_Params.encodedSize));
    builder.encodeStruct(SimpleCache_EnumerateEntries_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SimpleCachePtr.prototype.detach = function() {
    return SimpleCacheProxy.prototype.detach
        .apply(this.ptr.getProxy(), arguments);
  };

  SimpleCacheProxy.prototype.detach = function() {
    var params_ = new SimpleCache_Detach_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSimpleCache_Detach_Name,
          codec.align(SimpleCache_Detach_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SimpleCache_Detach_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SimpleCache_Detach_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SimpleCacheStub(delegate) {
    this.delegate_ = delegate;
  }
  SimpleCacheStub.prototype.createEntry = function(key) {
    return this.delegate_ && this.delegate_.createEntry && this.delegate_.createEntry(key);
  }
  SimpleCacheStub.prototype.openEntry = function(key) {
    return this.delegate_ && this.delegate_.openEntry && this.delegate_.openEntry(key);
  }
  SimpleCacheStub.prototype.doomEntry = function(key) {
    return this.delegate_ && this.delegate_.doomEntry && this.delegate_.doomEntry(key);
  }
  SimpleCacheStub.prototype.doomAllEntries = function() {
    return this.delegate_ && this.delegate_.doomAllEntries && this.delegate_.doomAllEntries();
  }
  SimpleCacheStub.prototype.enumerateEntries = function(receiver) {
    return this.delegate_ && this.delegate_.enumerateEntries && this.delegate_.enumerateEntries(receiver);
  }
  SimpleCacheStub.prototype.detach = function() {
    return this.delegate_ && this.delegate_.detach && this.delegate_.detach();
  }

  SimpleCacheStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSimpleCache_EnumerateEntries_Name:
      var params = reader.decodeStruct(SimpleCache_EnumerateEntries_Params);
      this.enumerateEntries(params.receiver);
      return true;
    default:
      return false;
    }
  };

  SimpleCacheStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSimpleCache_CreateEntry_Name:
      var params = reader.decodeStruct(SimpleCache_CreateEntry_Params);
      this.createEntry(params.key).then(function(response) {
        var responseParams =
            new SimpleCache_CreateEntry_ResponseParams();
        responseParams.entry = response.entry;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kSimpleCache_CreateEntry_Name,
            codec.align(SimpleCache_CreateEntry_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SimpleCache_CreateEntry_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSimpleCache_OpenEntry_Name:
      var params = reader.decodeStruct(SimpleCache_OpenEntry_Params);
      this.openEntry(params.key).then(function(response) {
        var responseParams =
            new SimpleCache_OpenEntry_ResponseParams();
        responseParams.entry = response.entry;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kSimpleCache_OpenEntry_Name,
            codec.align(SimpleCache_OpenEntry_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SimpleCache_OpenEntry_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSimpleCache_DoomEntry_Name:
      var params = reader.decodeStruct(SimpleCache_DoomEntry_Params);
      this.doomEntry(params.key).then(function(response) {
        var responseParams =
            new SimpleCache_DoomEntry_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSimpleCache_DoomEntry_Name,
            codec.align(SimpleCache_DoomEntry_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SimpleCache_DoomEntry_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSimpleCache_DoomAllEntries_Name:
      var params = reader.decodeStruct(SimpleCache_DoomAllEntries_Params);
      this.doomAllEntries().then(function(response) {
        var responseParams =
            new SimpleCache_DoomAllEntries_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSimpleCache_DoomAllEntries_Name,
            codec.align(SimpleCache_DoomAllEntries_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SimpleCache_DoomAllEntries_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSimpleCache_Detach_Name:
      var params = reader.decodeStruct(SimpleCache_Detach_Params);
      this.detach().then(function(response) {
        var responseParams =
            new SimpleCache_Detach_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kSimpleCache_Detach_Name,
            codec.align(SimpleCache_Detach_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SimpleCache_Detach_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSimpleCacheRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSimpleCache_CreateEntry_Name:
        if (message.expectsResponse())
          paramsClass = SimpleCache_CreateEntry_Params;
      break;
      case kSimpleCache_OpenEntry_Name:
        if (message.expectsResponse())
          paramsClass = SimpleCache_OpenEntry_Params;
      break;
      case kSimpleCache_DoomEntry_Name:
        if (message.expectsResponse())
          paramsClass = SimpleCache_DoomEntry_Params;
      break;
      case kSimpleCache_DoomAllEntries_Name:
        if (message.expectsResponse())
          paramsClass = SimpleCache_DoomAllEntries_Params;
      break;
      case kSimpleCache_EnumerateEntries_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SimpleCache_EnumerateEntries_Params;
      break;
      case kSimpleCache_Detach_Name:
        if (message.expectsResponse())
          paramsClass = SimpleCache_Detach_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSimpleCacheResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSimpleCache_CreateEntry_Name:
        if (message.isResponse())
          paramsClass = SimpleCache_CreateEntry_ResponseParams;
        break;
      case kSimpleCache_OpenEntry_Name:
        if (message.isResponse())
          paramsClass = SimpleCache_OpenEntry_ResponseParams;
        break;
      case kSimpleCache_DoomEntry_Name:
        if (message.isResponse())
          paramsClass = SimpleCache_DoomEntry_ResponseParams;
        break;
      case kSimpleCache_DoomAllEntries_Name:
        if (message.isResponse())
          paramsClass = SimpleCache_DoomAllEntries_ResponseParams;
        break;
      case kSimpleCache_Detach_Name:
        if (message.isResponse())
          paramsClass = SimpleCache_Detach_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SimpleCache = {
    name: 'network.mojom.SimpleCache',
    kVersion: 0,
    ptrClass: SimpleCachePtr,
    proxyClass: SimpleCacheProxy,
    stubClass: SimpleCacheStub,
    validateRequest: validateSimpleCacheRequest,
    validateResponse: validateSimpleCacheResponse,
  };
  SimpleCacheStub.prototype.validator = validateSimpleCacheRequest;
  SimpleCacheProxy.prototype.validator = validateSimpleCacheResponse;
  var kNetworkServiceTest_AddRules_Name = 0;
  var kNetworkServiceTest_SimulateNetworkChange_Name = 1;
  var kNetworkServiceTest_SimulateNetworkQualityChange_Name = 2;
  var kNetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Name = 3;
  var kNetworkServiceTest_SimulateCrash_Name = 4;
  var kNetworkServiceTest_MockCertVerifierSetDefaultResult_Name = 5;
  var kNetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Name = 6;
  var kNetworkServiceTest_SetTransportSecurityStateTestSource_Name = 7;
  var kNetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Name = 8;
  var kNetworkServiceTest_ReplaceSystemDnsConfig_Name = 9;
  var kNetworkServiceTest_SetTestDohConfig_Name = 10;
  var kNetworkServiceTest_CrashOnResolveHost_Name = 11;
  var kNetworkServiceTest_CrashOnGetCookieList_Name = 12;
  var kNetworkServiceTest_GetLatestMemoryPressureLevel_Name = 13;
  var kNetworkServiceTest_GetPeerToPeerConnectionsCountChange_Name = 14;
  var kNetworkServiceTest_GetEnvironmentVariableValue_Name = 15;
  var kNetworkServiceTest_Log_Name = 16;
  var kNetworkServiceTest_ActivateFieldTrial_Name = 17;
  var kNetworkServiceTest_SetSCTAuditingRetryDelay_Name = 18;
  var kNetworkServiceTest_OpenFile_Name = 19;
  var kNetworkServiceTest_EnumerateFiles_Name = 20;
  var kNetworkServiceTest_CreateSimpleCache_Name = 21;
  var kNetworkServiceTest_MakeRequestToServer_Name = 22;
  var kNetworkServiceTest_ResolveOwnHostnameWithSystemDns_Name = 23;
  var kNetworkServiceTest_SetIPv6ProbeResult_Name = 24;
  var kNetworkServiceTest_GetAddressMapCacheLinux_Name = 25;
  var kNetworkServiceTest_AllowsGSSAPILibraryLoad_Name = 26;
  var kNetworkServiceTest_IsHappyEyeballsV3Enabled_Name = 27;

  function NetworkServiceTestPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(NetworkServiceTest,
                                                   handleOrPtrInfo);
  }

  function NetworkServiceTestAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        NetworkServiceTest, associatedInterfacePtrInfo);
  }

  NetworkServiceTestAssociatedPtr.prototype =
      Object.create(NetworkServiceTestPtr.prototype);
  NetworkServiceTestAssociatedPtr.prototype.constructor =
      NetworkServiceTestAssociatedPtr;

  function NetworkServiceTestProxy(receiver) {
    this.receiver_ = receiver;
  }
  NetworkServiceTestPtr.prototype.addRules = function() {
    return NetworkServiceTestProxy.prototype.addRules
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.addRules = function(rules) {
    var params_ = new NetworkServiceTest_AddRules_Params();
    params_.rules = rules;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_AddRules_Name,
          codec.align(NetworkServiceTest_AddRules_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_AddRules_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_AddRules_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.simulateNetworkChange = function() {
    return NetworkServiceTestProxy.prototype.simulateNetworkChange
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.simulateNetworkChange = function(type) {
    var params_ = new NetworkServiceTest_SimulateNetworkChange_Params();
    params_.type = type;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_SimulateNetworkChange_Name,
          codec.align(NetworkServiceTest_SimulateNetworkChange_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_SimulateNetworkChange_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_SimulateNetworkChange_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.simulateNetworkQualityChange = function() {
    return NetworkServiceTestProxy.prototype.simulateNetworkQualityChange
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.simulateNetworkQualityChange = function(type) {
    var params_ = new NetworkServiceTest_SimulateNetworkQualityChange_Params();
    params_.type = type;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_SimulateNetworkQualityChange_Name,
          codec.align(NetworkServiceTest_SimulateNetworkQualityChange_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_SimulateNetworkQualityChange_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.forceNetworkQualityEstimatorReportWifiAsSlow2G = function() {
    return NetworkServiceTestProxy.prototype.forceNetworkQualityEstimatorReportWifiAsSlow2G
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.forceNetworkQualityEstimatorReportWifiAsSlow2G = function() {
    var params_ = new NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Name,
          codec.align(NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.simulateCrash = function() {
    return NetworkServiceTestProxy.prototype.simulateCrash
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.simulateCrash = function() {
    var params_ = new NetworkServiceTest_SimulateCrash_Params();
    var builder = new codec.MessageV0Builder(
        kNetworkServiceTest_SimulateCrash_Name,
        codec.align(NetworkServiceTest_SimulateCrash_Params.encodedSize));
    builder.encodeStruct(NetworkServiceTest_SimulateCrash_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServiceTestPtr.prototype.mockCertVerifierSetDefaultResult = function() {
    return NetworkServiceTestProxy.prototype.mockCertVerifierSetDefaultResult
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.mockCertVerifierSetDefaultResult = function(defaultResult) {
    var params_ = new NetworkServiceTest_MockCertVerifierSetDefaultResult_Params();
    params_.defaultResult = defaultResult;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_MockCertVerifierSetDefaultResult_Name,
          codec.align(NetworkServiceTest_MockCertVerifierSetDefaultResult_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_MockCertVerifierSetDefaultResult_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.mockCertVerifierAddResultForCertAndHost = function() {
    return NetworkServiceTestProxy.prototype.mockCertVerifierAddResultForCertAndHost
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.mockCertVerifierAddResultForCertAndHost = function(cert, hostPattern, verifyResult, rv) {
    var params_ = new NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params();
    params_.cert = cert;
    params_.hostPattern = hostPattern;
    params_.verifyResult = verifyResult;
    params_.rv = rv;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Name,
          codec.align(NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.setTransportSecurityStateTestSource = function() {
    return NetworkServiceTestProxy.prototype.setTransportSecurityStateTestSource
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.setTransportSecurityStateTestSource = function(enableUnittestSource) {
    var params_ = new NetworkServiceTest_SetTransportSecurityStateTestSource_Params();
    params_.enableUnittestSource = enableUnittestSource;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_SetTransportSecurityStateTestSource_Name,
          codec.align(NetworkServiceTest_SetTransportSecurityStateTestSource_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_SetTransportSecurityStateTestSource_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.setAllowNetworkAccessToHostResolutions = function() {
    return NetworkServiceTestProxy.prototype.setAllowNetworkAccessToHostResolutions
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.setAllowNetworkAccessToHostResolutions = function() {
    var params_ = new NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Name,
          codec.align(NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.replaceSystemDnsConfig = function() {
    return NetworkServiceTestProxy.prototype.replaceSystemDnsConfig
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.replaceSystemDnsConfig = function() {
    var params_ = new NetworkServiceTest_ReplaceSystemDnsConfig_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_ReplaceSystemDnsConfig_Name,
          codec.align(NetworkServiceTest_ReplaceSystemDnsConfig_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_ReplaceSystemDnsConfig_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.setTestDohConfig = function() {
    return NetworkServiceTestProxy.prototype.setTestDohConfig
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.setTestDohConfig = function(secureDnsMode, dohConfig) {
    var params_ = new NetworkServiceTest_SetTestDohConfig_Params();
    params_.secureDnsMode = secureDnsMode;
    params_.dohConfig = dohConfig;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_SetTestDohConfig_Name,
          codec.align(NetworkServiceTest_SetTestDohConfig_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_SetTestDohConfig_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_SetTestDohConfig_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.crashOnResolveHost = function() {
    return NetworkServiceTestProxy.prototype.crashOnResolveHost
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.crashOnResolveHost = function(host) {
    var params_ = new NetworkServiceTest_CrashOnResolveHost_Params();
    params_.host = host;
    var builder = new codec.MessageV0Builder(
        kNetworkServiceTest_CrashOnResolveHost_Name,
        codec.align(NetworkServiceTest_CrashOnResolveHost_Params.encodedSize));
    builder.encodeStruct(NetworkServiceTest_CrashOnResolveHost_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServiceTestPtr.prototype.crashOnGetCookieList = function() {
    return NetworkServiceTestProxy.prototype.crashOnGetCookieList
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.crashOnGetCookieList = function() {
    var params_ = new NetworkServiceTest_CrashOnGetCookieList_Params();
    var builder = new codec.MessageV0Builder(
        kNetworkServiceTest_CrashOnGetCookieList_Name,
        codec.align(NetworkServiceTest_CrashOnGetCookieList_Params.encodedSize));
    builder.encodeStruct(NetworkServiceTest_CrashOnGetCookieList_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServiceTestPtr.prototype.getLatestMemoryPressureLevel = function() {
    return NetworkServiceTestProxy.prototype.getLatestMemoryPressureLevel
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.getLatestMemoryPressureLevel = function() {
    var params_ = new NetworkServiceTest_GetLatestMemoryPressureLevel_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_GetLatestMemoryPressureLevel_Name,
          codec.align(NetworkServiceTest_GetLatestMemoryPressureLevel_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_GetLatestMemoryPressureLevel_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.getPeerToPeerConnectionsCountChange = function() {
    return NetworkServiceTestProxy.prototype.getPeerToPeerConnectionsCountChange
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.getPeerToPeerConnectionsCountChange = function() {
    var params_ = new NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_GetPeerToPeerConnectionsCountChange_Name,
          codec.align(NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.getEnvironmentVariableValue = function() {
    return NetworkServiceTestProxy.prototype.getEnvironmentVariableValue
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.getEnvironmentVariableValue = function(name) {
    var params_ = new NetworkServiceTest_GetEnvironmentVariableValue_Params();
    params_.name = name;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_GetEnvironmentVariableValue_Name,
          codec.align(NetworkServiceTest_GetEnvironmentVariableValue_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_GetEnvironmentVariableValue_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.log = function() {
    return NetworkServiceTestProxy.prototype.log
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.log = function(message) {
    var params_ = new NetworkServiceTest_Log_Params();
    params_.message = message;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_Log_Name,
          codec.align(NetworkServiceTest_Log_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_Log_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_Log_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.activateFieldTrial = function() {
    return NetworkServiceTestProxy.prototype.activateFieldTrial
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.activateFieldTrial = function(fieldTrialName) {
    var params_ = new NetworkServiceTest_ActivateFieldTrial_Params();
    params_.fieldTrialName = fieldTrialName;
    var builder = new codec.MessageV0Builder(
        kNetworkServiceTest_ActivateFieldTrial_Name,
        codec.align(NetworkServiceTest_ActivateFieldTrial_Params.encodedSize));
    builder.encodeStruct(NetworkServiceTest_ActivateFieldTrial_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServiceTestPtr.prototype.setSCTAuditingRetryDelay = function() {
    return NetworkServiceTestProxy.prototype.setSCTAuditingRetryDelay
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.setSCTAuditingRetryDelay = function(delay) {
    var params_ = new NetworkServiceTest_SetSCTAuditingRetryDelay_Params();
    params_.delay = delay;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_SetSCTAuditingRetryDelay_Name,
          codec.align(NetworkServiceTest_SetSCTAuditingRetryDelay_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_SetSCTAuditingRetryDelay_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.openFile = function() {
    return NetworkServiceTestProxy.prototype.openFile
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.openFile = function(path) {
    var params_ = new NetworkServiceTest_OpenFile_Params();
    params_.path = path;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_OpenFile_Name,
          codec.align(NetworkServiceTest_OpenFile_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_OpenFile_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_OpenFile_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.enumerateFiles = function() {
    return NetworkServiceTestProxy.prototype.enumerateFiles
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.enumerateFiles = function(path, factory) {
    var params_ = new NetworkServiceTest_EnumerateFiles_Params();
    params_.path = path;
    params_.factory = factory;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_EnumerateFiles_Name,
          codec.align(NetworkServiceTest_EnumerateFiles_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_EnumerateFiles_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_EnumerateFiles_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.createSimpleCache = function() {
    return NetworkServiceTestProxy.prototype.createSimpleCache
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.createSimpleCache = function(factory, path, reset) {
    var params_ = new NetworkServiceTest_CreateSimpleCache_Params();
    params_.factory = factory;
    params_.path = path;
    params_.reset = reset;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_CreateSimpleCache_Name,
          codec.align(NetworkServiceTest_CreateSimpleCache_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_CreateSimpleCache_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_CreateSimpleCache_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.makeRequestToServer = function() {
    return NetworkServiceTestProxy.prototype.makeRequestToServer
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.makeRequestToServer = function(s, endpoint) {
    var params_ = new NetworkServiceTest_MakeRequestToServer_Params();
    params_.s = s;
    params_.endpoint = endpoint;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_MakeRequestToServer_Name,
          codec.align(NetworkServiceTest_MakeRequestToServer_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_MakeRequestToServer_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_MakeRequestToServer_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.resolveOwnHostnameWithSystemDns = function() {
    return NetworkServiceTestProxy.prototype.resolveOwnHostnameWithSystemDns
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.resolveOwnHostnameWithSystemDns = function() {
    var params_ = new NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_ResolveOwnHostnameWithSystemDns_Name,
          codec.align(NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.setIPv6ProbeResult = function() {
    return NetworkServiceTestProxy.prototype.setIPv6ProbeResult
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.setIPv6ProbeResult = function(success) {
    var params_ = new NetworkServiceTest_SetIPv6ProbeResult_Params();
    params_.success = success;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_SetIPv6ProbeResult_Name,
          codec.align(NetworkServiceTest_SetIPv6ProbeResult_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_SetIPv6ProbeResult_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_SetIPv6ProbeResult_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.getAddressMapCacheLinux = function() {
    return NetworkServiceTestProxy.prototype.getAddressMapCacheLinux
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.getAddressMapCacheLinux = function() {
    var params_ = new NetworkServiceTest_GetAddressMapCacheLinux_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_GetAddressMapCacheLinux_Name,
          codec.align(NetworkServiceTest_GetAddressMapCacheLinux_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_GetAddressMapCacheLinux_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.allowsGSSAPILibraryLoad = function() {
    return NetworkServiceTestProxy.prototype.allowsGSSAPILibraryLoad
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.allowsGSSAPILibraryLoad = function() {
    var params_ = new NetworkServiceTest_AllowsGSSAPILibraryLoad_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_AllowsGSSAPILibraryLoad_Name,
          codec.align(NetworkServiceTest_AllowsGSSAPILibraryLoad_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_AllowsGSSAPILibraryLoad_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServiceTestPtr.prototype.isHappyEyeballsV3Enabled = function() {
    return NetworkServiceTestProxy.prototype.isHappyEyeballsV3Enabled
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceTestProxy.prototype.isHappyEyeballsV3Enabled = function() {
    var params_ = new NetworkServiceTest_IsHappyEyeballsV3Enabled_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkServiceTest_IsHappyEyeballsV3Enabled_Name,
          codec.align(NetworkServiceTest_IsHappyEyeballsV3Enabled_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkServiceTest_IsHappyEyeballsV3Enabled_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function NetworkServiceTestStub(delegate) {
    this.delegate_ = delegate;
  }
  NetworkServiceTestStub.prototype.addRules = function(rules) {
    return this.delegate_ && this.delegate_.addRules && this.delegate_.addRules(rules);
  }
  NetworkServiceTestStub.prototype.simulateNetworkChange = function(type) {
    return this.delegate_ && this.delegate_.simulateNetworkChange && this.delegate_.simulateNetworkChange(type);
  }
  NetworkServiceTestStub.prototype.simulateNetworkQualityChange = function(type) {
    return this.delegate_ && this.delegate_.simulateNetworkQualityChange && this.delegate_.simulateNetworkQualityChange(type);
  }
  NetworkServiceTestStub.prototype.forceNetworkQualityEstimatorReportWifiAsSlow2G = function() {
    return this.delegate_ && this.delegate_.forceNetworkQualityEstimatorReportWifiAsSlow2G && this.delegate_.forceNetworkQualityEstimatorReportWifiAsSlow2G();
  }
  NetworkServiceTestStub.prototype.simulateCrash = function() {
    return this.delegate_ && this.delegate_.simulateCrash && this.delegate_.simulateCrash();
  }
  NetworkServiceTestStub.prototype.mockCertVerifierSetDefaultResult = function(defaultResult) {
    return this.delegate_ && this.delegate_.mockCertVerifierSetDefaultResult && this.delegate_.mockCertVerifierSetDefaultResult(defaultResult);
  }
  NetworkServiceTestStub.prototype.mockCertVerifierAddResultForCertAndHost = function(cert, hostPattern, verifyResult, rv) {
    return this.delegate_ && this.delegate_.mockCertVerifierAddResultForCertAndHost && this.delegate_.mockCertVerifierAddResultForCertAndHost(cert, hostPattern, verifyResult, rv);
  }
  NetworkServiceTestStub.prototype.setTransportSecurityStateTestSource = function(enableUnittestSource) {
    return this.delegate_ && this.delegate_.setTransportSecurityStateTestSource && this.delegate_.setTransportSecurityStateTestSource(enableUnittestSource);
  }
  NetworkServiceTestStub.prototype.setAllowNetworkAccessToHostResolutions = function() {
    return this.delegate_ && this.delegate_.setAllowNetworkAccessToHostResolutions && this.delegate_.setAllowNetworkAccessToHostResolutions();
  }
  NetworkServiceTestStub.prototype.replaceSystemDnsConfig = function() {
    return this.delegate_ && this.delegate_.replaceSystemDnsConfig && this.delegate_.replaceSystemDnsConfig();
  }
  NetworkServiceTestStub.prototype.setTestDohConfig = function(secureDnsMode, dohConfig) {
    return this.delegate_ && this.delegate_.setTestDohConfig && this.delegate_.setTestDohConfig(secureDnsMode, dohConfig);
  }
  NetworkServiceTestStub.prototype.crashOnResolveHost = function(host) {
    return this.delegate_ && this.delegate_.crashOnResolveHost && this.delegate_.crashOnResolveHost(host);
  }
  NetworkServiceTestStub.prototype.crashOnGetCookieList = function() {
    return this.delegate_ && this.delegate_.crashOnGetCookieList && this.delegate_.crashOnGetCookieList();
  }
  NetworkServiceTestStub.prototype.getLatestMemoryPressureLevel = function() {
    return this.delegate_ && this.delegate_.getLatestMemoryPressureLevel && this.delegate_.getLatestMemoryPressureLevel();
  }
  NetworkServiceTestStub.prototype.getPeerToPeerConnectionsCountChange = function() {
    return this.delegate_ && this.delegate_.getPeerToPeerConnectionsCountChange && this.delegate_.getPeerToPeerConnectionsCountChange();
  }
  NetworkServiceTestStub.prototype.getEnvironmentVariableValue = function(name) {
    return this.delegate_ && this.delegate_.getEnvironmentVariableValue && this.delegate_.getEnvironmentVariableValue(name);
  }
  NetworkServiceTestStub.prototype.log = function(message) {
    return this.delegate_ && this.delegate_.log && this.delegate_.log(message);
  }
  NetworkServiceTestStub.prototype.activateFieldTrial = function(fieldTrialName) {
    return this.delegate_ && this.delegate_.activateFieldTrial && this.delegate_.activateFieldTrial(fieldTrialName);
  }
  NetworkServiceTestStub.prototype.setSCTAuditingRetryDelay = function(delay) {
    return this.delegate_ && this.delegate_.setSCTAuditingRetryDelay && this.delegate_.setSCTAuditingRetryDelay(delay);
  }
  NetworkServiceTestStub.prototype.openFile = function(path) {
    return this.delegate_ && this.delegate_.openFile && this.delegate_.openFile(path);
  }
  NetworkServiceTestStub.prototype.enumerateFiles = function(path, factory) {
    return this.delegate_ && this.delegate_.enumerateFiles && this.delegate_.enumerateFiles(path, factory);
  }
  NetworkServiceTestStub.prototype.createSimpleCache = function(factory, path, reset) {
    return this.delegate_ && this.delegate_.createSimpleCache && this.delegate_.createSimpleCache(factory, path, reset);
  }
  NetworkServiceTestStub.prototype.makeRequestToServer = function(s, endpoint) {
    return this.delegate_ && this.delegate_.makeRequestToServer && this.delegate_.makeRequestToServer(s, endpoint);
  }
  NetworkServiceTestStub.prototype.resolveOwnHostnameWithSystemDns = function() {
    return this.delegate_ && this.delegate_.resolveOwnHostnameWithSystemDns && this.delegate_.resolveOwnHostnameWithSystemDns();
  }
  NetworkServiceTestStub.prototype.setIPv6ProbeResult = function(success) {
    return this.delegate_ && this.delegate_.setIPv6ProbeResult && this.delegate_.setIPv6ProbeResult(success);
  }
  NetworkServiceTestStub.prototype.getAddressMapCacheLinux = function() {
    return this.delegate_ && this.delegate_.getAddressMapCacheLinux && this.delegate_.getAddressMapCacheLinux();
  }
  NetworkServiceTestStub.prototype.allowsGSSAPILibraryLoad = function() {
    return this.delegate_ && this.delegate_.allowsGSSAPILibraryLoad && this.delegate_.allowsGSSAPILibraryLoad();
  }
  NetworkServiceTestStub.prototype.isHappyEyeballsV3Enabled = function() {
    return this.delegate_ && this.delegate_.isHappyEyeballsV3Enabled && this.delegate_.isHappyEyeballsV3Enabled();
  }

  NetworkServiceTestStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNetworkServiceTest_SimulateCrash_Name:
      var params = reader.decodeStruct(NetworkServiceTest_SimulateCrash_Params);
      this.simulateCrash();
      return true;
    case kNetworkServiceTest_CrashOnResolveHost_Name:
      var params = reader.decodeStruct(NetworkServiceTest_CrashOnResolveHost_Params);
      this.crashOnResolveHost(params.host);
      return true;
    case kNetworkServiceTest_CrashOnGetCookieList_Name:
      var params = reader.decodeStruct(NetworkServiceTest_CrashOnGetCookieList_Params);
      this.crashOnGetCookieList();
      return true;
    case kNetworkServiceTest_ActivateFieldTrial_Name:
      var params = reader.decodeStruct(NetworkServiceTest_ActivateFieldTrial_Params);
      this.activateFieldTrial(params.fieldTrialName);
      return true;
    default:
      return false;
    }
  };

  NetworkServiceTestStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNetworkServiceTest_AddRules_Name:
      var params = reader.decodeStruct(NetworkServiceTest_AddRules_Params);
      this.addRules(params.rules).then(function(response) {
        var responseParams =
            new NetworkServiceTest_AddRules_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_AddRules_Name,
            codec.align(NetworkServiceTest_AddRules_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_AddRules_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_SimulateNetworkChange_Name:
      var params = reader.decodeStruct(NetworkServiceTest_SimulateNetworkChange_Params);
      this.simulateNetworkChange(params.type).then(function(response) {
        var responseParams =
            new NetworkServiceTest_SimulateNetworkChange_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_SimulateNetworkChange_Name,
            codec.align(NetworkServiceTest_SimulateNetworkChange_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_SimulateNetworkChange_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_SimulateNetworkQualityChange_Name:
      var params = reader.decodeStruct(NetworkServiceTest_SimulateNetworkQualityChange_Params);
      this.simulateNetworkQualityChange(params.type).then(function(response) {
        var responseParams =
            new NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_SimulateNetworkQualityChange_Name,
            codec.align(NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Name:
      var params = reader.decodeStruct(NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params);
      this.forceNetworkQualityEstimatorReportWifiAsSlow2G().then(function(response) {
        var responseParams =
            new NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Name,
            codec.align(NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_MockCertVerifierSetDefaultResult_Name:
      var params = reader.decodeStruct(NetworkServiceTest_MockCertVerifierSetDefaultResult_Params);
      this.mockCertVerifierSetDefaultResult(params.defaultResult).then(function(response) {
        var responseParams =
            new NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_MockCertVerifierSetDefaultResult_Name,
            codec.align(NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Name:
      var params = reader.decodeStruct(NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params);
      this.mockCertVerifierAddResultForCertAndHost(params.cert, params.hostPattern, params.verifyResult, params.rv).then(function(response) {
        var responseParams =
            new NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Name,
            codec.align(NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_SetTransportSecurityStateTestSource_Name:
      var params = reader.decodeStruct(NetworkServiceTest_SetTransportSecurityStateTestSource_Params);
      this.setTransportSecurityStateTestSource(params.enableUnittestSource).then(function(response) {
        var responseParams =
            new NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_SetTransportSecurityStateTestSource_Name,
            codec.align(NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Name:
      var params = reader.decodeStruct(NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params);
      this.setAllowNetworkAccessToHostResolutions().then(function(response) {
        var responseParams =
            new NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Name,
            codec.align(NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_ReplaceSystemDnsConfig_Name:
      var params = reader.decodeStruct(NetworkServiceTest_ReplaceSystemDnsConfig_Params);
      this.replaceSystemDnsConfig().then(function(response) {
        var responseParams =
            new NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_ReplaceSystemDnsConfig_Name,
            codec.align(NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_SetTestDohConfig_Name:
      var params = reader.decodeStruct(NetworkServiceTest_SetTestDohConfig_Params);
      this.setTestDohConfig(params.secureDnsMode, params.dohConfig).then(function(response) {
        var responseParams =
            new NetworkServiceTest_SetTestDohConfig_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_SetTestDohConfig_Name,
            codec.align(NetworkServiceTest_SetTestDohConfig_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_SetTestDohConfig_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_GetLatestMemoryPressureLevel_Name:
      var params = reader.decodeStruct(NetworkServiceTest_GetLatestMemoryPressureLevel_Params);
      this.getLatestMemoryPressureLevel().then(function(response) {
        var responseParams =
            new NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams();
        responseParams.memoryPressureLevel = response.memoryPressureLevel;
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_GetLatestMemoryPressureLevel_Name,
            codec.align(NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_GetPeerToPeerConnectionsCountChange_Name:
      var params = reader.decodeStruct(NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params);
      this.getPeerToPeerConnectionsCountChange().then(function(response) {
        var responseParams =
            new NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams();
        responseParams.connectionCount = response.connectionCount;
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_GetPeerToPeerConnectionsCountChange_Name,
            codec.align(NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_GetEnvironmentVariableValue_Name:
      var params = reader.decodeStruct(NetworkServiceTest_GetEnvironmentVariableValue_Params);
      this.getEnvironmentVariableValue(params.name).then(function(response) {
        var responseParams =
            new NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_GetEnvironmentVariableValue_Name,
            codec.align(NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_Log_Name:
      var params = reader.decodeStruct(NetworkServiceTest_Log_Params);
      this.log(params.message).then(function(response) {
        var responseParams =
            new NetworkServiceTest_Log_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_Log_Name,
            codec.align(NetworkServiceTest_Log_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_Log_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_SetSCTAuditingRetryDelay_Name:
      var params = reader.decodeStruct(NetworkServiceTest_SetSCTAuditingRetryDelay_Params);
      this.setSCTAuditingRetryDelay(params.delay).then(function(response) {
        var responseParams =
            new NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_SetSCTAuditingRetryDelay_Name,
            codec.align(NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_OpenFile_Name:
      var params = reader.decodeStruct(NetworkServiceTest_OpenFile_Params);
      this.openFile(params.path).then(function(response) {
        var responseParams =
            new NetworkServiceTest_OpenFile_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_OpenFile_Name,
            codec.align(NetworkServiceTest_OpenFile_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_OpenFile_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_EnumerateFiles_Name:
      var params = reader.decodeStruct(NetworkServiceTest_EnumerateFiles_Params);
      this.enumerateFiles(params.path, params.factory).then(function(response) {
        var responseParams =
            new NetworkServiceTest_EnumerateFiles_ResponseParams();
        responseParams.entries = response.entries;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_EnumerateFiles_Name,
            codec.align(NetworkServiceTest_EnumerateFiles_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_EnumerateFiles_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_CreateSimpleCache_Name:
      var params = reader.decodeStruct(NetworkServiceTest_CreateSimpleCache_Params);
      this.createSimpleCache(params.factory, params.path, params.reset).then(function(response) {
        var responseParams =
            new NetworkServiceTest_CreateSimpleCache_ResponseParams();
        responseParams.backend = response.backend;
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_CreateSimpleCache_Name,
            codec.align(NetworkServiceTest_CreateSimpleCache_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_CreateSimpleCache_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_MakeRequestToServer_Name:
      var params = reader.decodeStruct(NetworkServiceTest_MakeRequestToServer_Params);
      this.makeRequestToServer(params.s, params.endpoint).then(function(response) {
        var responseParams =
            new NetworkServiceTest_MakeRequestToServer_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_MakeRequestToServer_Name,
            codec.align(NetworkServiceTest_MakeRequestToServer_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_MakeRequestToServer_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_ResolveOwnHostnameWithSystemDns_Name:
      var params = reader.decodeStruct(NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params);
      this.resolveOwnHostnameWithSystemDns().then(function(response) {
        var responseParams =
            new NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams();
        responseParams.addrList = response.addrList;
        responseParams.osError = response.osError;
        responseParams.netError = response.netError;
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_ResolveOwnHostnameWithSystemDns_Name,
            codec.align(NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_SetIPv6ProbeResult_Name:
      var params = reader.decodeStruct(NetworkServiceTest_SetIPv6ProbeResult_Params);
      this.setIPv6ProbeResult(params.success).then(function(response) {
        var responseParams =
            new NetworkServiceTest_SetIPv6ProbeResult_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_SetIPv6ProbeResult_Name,
            codec.align(NetworkServiceTest_SetIPv6ProbeResult_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_SetIPv6ProbeResult_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_GetAddressMapCacheLinux_Name:
      var params = reader.decodeStruct(NetworkServiceTest_GetAddressMapCacheLinux_Params);
      this.getAddressMapCacheLinux().then(function(response) {
        var responseParams =
            new NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams();
        responseParams.addrMap = response.addrMap;
        responseParams.links = response.links;
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_GetAddressMapCacheLinux_Name,
            codec.align(NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_AllowsGSSAPILibraryLoad_Name:
      var params = reader.decodeStruct(NetworkServiceTest_AllowsGSSAPILibraryLoad_Params);
      this.allowsGSSAPILibraryLoad().then(function(response) {
        var responseParams =
            new NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams();
        responseParams.allowGssapiLibraryLoad = response.allowGssapiLibraryLoad;
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_AllowsGSSAPILibraryLoad_Name,
            codec.align(NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkServiceTest_IsHappyEyeballsV3Enabled_Name:
      var params = reader.decodeStruct(NetworkServiceTest_IsHappyEyeballsV3Enabled_Params);
      this.isHappyEyeballsV3Enabled().then(function(response) {
        var responseParams =
            new NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams();
        responseParams.isHappyEyeballsV3Enabled = response.isHappyEyeballsV3Enabled;
        var builder = new codec.MessageV1Builder(
            kNetworkServiceTest_IsHappyEyeballsV3Enabled_Name,
            codec.align(NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateNetworkServiceTestRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kNetworkServiceTest_AddRules_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_AddRules_Params;
      break;
      case kNetworkServiceTest_SimulateNetworkChange_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_SimulateNetworkChange_Params;
      break;
      case kNetworkServiceTest_SimulateNetworkQualityChange_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_SimulateNetworkQualityChange_Params;
      break;
      case kNetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params;
      break;
      case kNetworkServiceTest_SimulateCrash_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkServiceTest_SimulateCrash_Params;
      break;
      case kNetworkServiceTest_MockCertVerifierSetDefaultResult_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_MockCertVerifierSetDefaultResult_Params;
      break;
      case kNetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params;
      break;
      case kNetworkServiceTest_SetTransportSecurityStateTestSource_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_SetTransportSecurityStateTestSource_Params;
      break;
      case kNetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params;
      break;
      case kNetworkServiceTest_ReplaceSystemDnsConfig_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_ReplaceSystemDnsConfig_Params;
      break;
      case kNetworkServiceTest_SetTestDohConfig_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_SetTestDohConfig_Params;
      break;
      case kNetworkServiceTest_CrashOnResolveHost_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkServiceTest_CrashOnResolveHost_Params;
      break;
      case kNetworkServiceTest_CrashOnGetCookieList_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkServiceTest_CrashOnGetCookieList_Params;
      break;
      case kNetworkServiceTest_GetLatestMemoryPressureLevel_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_GetLatestMemoryPressureLevel_Params;
      break;
      case kNetworkServiceTest_GetPeerToPeerConnectionsCountChange_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params;
      break;
      case kNetworkServiceTest_GetEnvironmentVariableValue_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_GetEnvironmentVariableValue_Params;
      break;
      case kNetworkServiceTest_Log_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_Log_Params;
      break;
      case kNetworkServiceTest_ActivateFieldTrial_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkServiceTest_ActivateFieldTrial_Params;
      break;
      case kNetworkServiceTest_SetSCTAuditingRetryDelay_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_SetSCTAuditingRetryDelay_Params;
      break;
      case kNetworkServiceTest_OpenFile_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_OpenFile_Params;
      break;
      case kNetworkServiceTest_EnumerateFiles_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_EnumerateFiles_Params;
      break;
      case kNetworkServiceTest_CreateSimpleCache_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_CreateSimpleCache_Params;
      break;
      case kNetworkServiceTest_MakeRequestToServer_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_MakeRequestToServer_Params;
      break;
      case kNetworkServiceTest_ResolveOwnHostnameWithSystemDns_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params;
      break;
      case kNetworkServiceTest_SetIPv6ProbeResult_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_SetIPv6ProbeResult_Params;
      break;
      case kNetworkServiceTest_GetAddressMapCacheLinux_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_GetAddressMapCacheLinux_Params;
      break;
      case kNetworkServiceTest_AllowsGSSAPILibraryLoad_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_AllowsGSSAPILibraryLoad_Params;
      break;
      case kNetworkServiceTest_IsHappyEyeballsV3Enabled_Name:
        if (message.expectsResponse())
          paramsClass = NetworkServiceTest_IsHappyEyeballsV3Enabled_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateNetworkServiceTestResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kNetworkServiceTest_AddRules_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_AddRules_ResponseParams;
        break;
      case kNetworkServiceTest_SimulateNetworkChange_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_SimulateNetworkChange_ResponseParams;
        break;
      case kNetworkServiceTest_SimulateNetworkQualityChange_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams;
        break;
      case kNetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams;
        break;
      case kNetworkServiceTest_MockCertVerifierSetDefaultResult_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams;
        break;
      case kNetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams;
        break;
      case kNetworkServiceTest_SetTransportSecurityStateTestSource_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams;
        break;
      case kNetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams;
        break;
      case kNetworkServiceTest_ReplaceSystemDnsConfig_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams;
        break;
      case kNetworkServiceTest_SetTestDohConfig_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_SetTestDohConfig_ResponseParams;
        break;
      case kNetworkServiceTest_GetLatestMemoryPressureLevel_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams;
        break;
      case kNetworkServiceTest_GetPeerToPeerConnectionsCountChange_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams;
        break;
      case kNetworkServiceTest_GetEnvironmentVariableValue_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams;
        break;
      case kNetworkServiceTest_Log_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_Log_ResponseParams;
        break;
      case kNetworkServiceTest_SetSCTAuditingRetryDelay_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams;
        break;
      case kNetworkServiceTest_OpenFile_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_OpenFile_ResponseParams;
        break;
      case kNetworkServiceTest_EnumerateFiles_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_EnumerateFiles_ResponseParams;
        break;
      case kNetworkServiceTest_CreateSimpleCache_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_CreateSimpleCache_ResponseParams;
        break;
      case kNetworkServiceTest_MakeRequestToServer_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_MakeRequestToServer_ResponseParams;
        break;
      case kNetworkServiceTest_ResolveOwnHostnameWithSystemDns_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams;
        break;
      case kNetworkServiceTest_SetIPv6ProbeResult_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_SetIPv6ProbeResult_ResponseParams;
        break;
      case kNetworkServiceTest_GetAddressMapCacheLinux_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams;
        break;
      case kNetworkServiceTest_AllowsGSSAPILibraryLoad_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams;
        break;
      case kNetworkServiceTest_IsHappyEyeballsV3Enabled_Name:
        if (message.isResponse())
          paramsClass = NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var NetworkServiceTest = {
    name: 'network.mojom.NetworkServiceTest',
    kVersion: 0,
    ptrClass: NetworkServiceTestPtr,
    proxyClass: NetworkServiceTestProxy,
    stubClass: NetworkServiceTestStub,
    validateRequest: validateNetworkServiceTestRequest,
    validateResponse: validateNetworkServiceTestResponse,
  };
  NetworkServiceTestStub.prototype.validator = validateNetworkServiceTestRequest;
  NetworkServiceTestProxy.prototype.validator = validateNetworkServiceTestResponse;
  exports.ResolverType = ResolverType;
  exports.Rule = Rule;
  exports.SimpleCacheOpenEntryResult = SimpleCacheOpenEntryResult;
  exports.SimpleCacheEntry = SimpleCacheEntry;
  exports.SimpleCacheEntryPtr = SimpleCacheEntryPtr;
  exports.SimpleCacheEntryAssociatedPtr = SimpleCacheEntryAssociatedPtr;
  exports.SimpleCacheEntryEnumerator = SimpleCacheEntryEnumerator;
  exports.SimpleCacheEntryEnumeratorPtr = SimpleCacheEntryEnumeratorPtr;
  exports.SimpleCacheEntryEnumeratorAssociatedPtr = SimpleCacheEntryEnumeratorAssociatedPtr;
  exports.SimpleCache = SimpleCache;
  exports.SimpleCachePtr = SimpleCachePtr;
  exports.SimpleCacheAssociatedPtr = SimpleCacheAssociatedPtr;
  exports.NetworkServiceTest = NetworkServiceTest;
  exports.NetworkServiceTestPtr = NetworkServiceTestPtr;
  exports.NetworkServiceTestAssociatedPtr = NetworkServiceTestAssociatedPtr;
})();