// services/network/public/mojom/network_service_test.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  MemoryPressureLevel as mojoBase_mojom_MemoryPressureLevel,
  MemoryPressureLevelSpec as mojoBase_mojom_MemoryPressureLevelSpec
} from '../../../../mojo/public/mojom/base/memory_pressure_level.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  AddressList as network_mojom_AddressList,
  AddressListSpec as network_mojom_AddressListSpec
} from './address_list.mojom.m.js';

import {
  SecureDnsMode as network_mojom_SecureDnsMode,
  SecureDnsModeSpec as network_mojom_SecureDnsModeSpec,
  DnsOverHttpsConfig as network_mojom_DnsOverHttpsConfig,
  DnsOverHttpsConfigSpec as network_mojom_DnsOverHttpsConfigSpec
} from './host_resolver.mojom.m.js';

import {
  HttpCacheBackendFileOperationsFactoryRemote as network_mojom_HttpCacheBackendFileOperationsFactoryRemote,
  HttpCacheBackendFileOperationsFactoryPendingReceiver as network_mojom_HttpCacheBackendFileOperationsFactoryPendingReceiver,
  FileEnumerationEntry as network_mojom_FileEnumerationEntry,
  FileEnumerationEntrySpec as network_mojom_FileEnumerationEntrySpec
} from './http_cache_backend_file_operations.mojom.m.js';

import {
  IPEndPoint as network_mojom_IPEndPoint,
  IPEndPointSpec as network_mojom_IPEndPointSpec
} from './ip_endpoint.mojom.m.js';

import {
  ConnectionType as network_mojom_ConnectionType,
  ConnectionTypeSpec as network_mojom_ConnectionTypeSpec
} from './network_change_manager.mojom.m.js';

import {
  AddressMap as network_mojom_AddressMap,
  AddressMapSpec as network_mojom_AddressMapSpec,
  OnlineLinks as network_mojom_OnlineLinks,
  OnlineLinksSpec as network_mojom_OnlineLinksSpec
} from './network_interface_change_listener.mojom.m.js';

import {
  CertVerifyResult as network_mojom_CertVerifyResult,
  CertVerifyResultSpec as network_mojom_CertVerifyResultSpec,
  X509Certificate as network_mojom_X509Certificate,
  X509CertificateSpec as network_mojom_X509CertificateSpec
} from './network_param.mojom.m.js';

import {
  EffectiveConnectionType as network_mojom_EffectiveConnectionType,
  EffectiveConnectionTypeSpec as network_mojom_EffectiveConnectionTypeSpec
} from './network_types.mojom.m.js';

import {
  TransferableSocket as network_mojom_TransferableSocket,
  TransferableSocketSpec as network_mojom_TransferableSocketSpec
} from './transferable_socket.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ResolverTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ResolverType = {
  
  kResolverTypeFail: 0,
  kResolverTypeFailTimeout: 1,
  kResolverTypeSystem: 2,
  kResolverTypeIPLiteral: 3,
  kResolverTypeDirectLookup: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SimpleCacheEntryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.SimpleCacheEntry', scope);
  }
}

/** @interface */
export class SimpleCacheEntryInterface {
  
  /**
   * @param { !number } index
   * @param { !number } offset
   * @param { !Array<!number> } data
   * @param { !boolean } truncate
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  writeData(index, offset, data, truncate) {}
  
  /**
   * @param { !number } index
   * @param { !number } offset
   * @param { !number } length
   * @return {!Promise<{
        data: !Array<!number>,
        result: !number,
   *  }>}
   */

  readData(index, offset, length) {}
  
  /**
   * @param { !number } offset
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  writeSparseData(offset, data) {}
  
  /**
   * @param { !number } offset
   * @param { !number } length
   * @return {!Promise<{
        data: !Array<!number>,
        result: !number,
   *  }>}
   */

  readSparseData(offset, length) {}
  
  /**
   * @return {!Promise}
   */

  close() {}
}

/**
 * @implements { SimpleCacheEntryInterface }
 */
export class SimpleCacheEntryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SimpleCacheEntryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SimpleCacheEntryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SimpleCacheEntryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } index
   * @param { !number } offset
   * @param { !Array<!number> } data
   * @param { !boolean } truncate
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  writeData(
      index,
      offset,
      data,
      truncate) {
    return this.proxy.sendMessage(
        0,
        SimpleCacheEntry_WriteData_ParamsSpec.$,
        SimpleCacheEntry_WriteData_ResponseParamsSpec.$,
        [
          index,
          offset,
          data,
          truncate
        ],
        false);
  }

  
  /**
   * @param { !number } index
   * @param { !number } offset
   * @param { !number } length
   * @return {!Promise<{
        data: !Array<!number>,
        result: !number,
   *  }>}
   */

  readData(
      index,
      offset,
      length) {
    return this.proxy.sendMessage(
        1,
        SimpleCacheEntry_ReadData_ParamsSpec.$,
        SimpleCacheEntry_ReadData_ResponseParamsSpec.$,
        [
          index,
          offset,
          length
        ],
        false);
  }

  
  /**
   * @param { !number } offset
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  writeSparseData(
      offset,
      data) {
    return this.proxy.sendMessage(
        2,
        SimpleCacheEntry_WriteSparseData_ParamsSpec.$,
        SimpleCacheEntry_WriteSparseData_ResponseParamsSpec.$,
        [
          offset,
          data
        ],
        false);
  }

  
  /**
   * @param { !number } offset
   * @param { !number } length
   * @return {!Promise<{
        data: !Array<!number>,
        result: !number,
   *  }>}
   */

  readSparseData(
      offset,
      length) {
    return this.proxy.sendMessage(
        3,
        SimpleCacheEntry_ReadSparseData_ParamsSpec.$,
        SimpleCacheEntry_ReadSparseData_ResponseParamsSpec.$,
        [
          offset,
          length
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  close() {
    return this.proxy.sendMessage(
        4,
        SimpleCacheEntry_Close_ParamsSpec.$,
        SimpleCacheEntry_Close_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SimpleCacheEntry
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SimpleCacheEntryReceiver {
  /**
   * @param {!SimpleCacheEntryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SimpleCacheEntryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SimpleCacheEntryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SimpleCacheEntryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SimpleCacheEntry_WriteData_ParamsSpec.$,
        SimpleCacheEntry_WriteData_ResponseParamsSpec.$,
        impl.writeData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SimpleCacheEntry_ReadData_ParamsSpec.$,
        SimpleCacheEntry_ReadData_ResponseParamsSpec.$,
        impl.readData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SimpleCacheEntry_WriteSparseData_ParamsSpec.$,
        SimpleCacheEntry_WriteSparseData_ResponseParamsSpec.$,
        impl.writeSparseData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SimpleCacheEntry_ReadSparseData_ParamsSpec.$,
        SimpleCacheEntry_ReadSparseData_ResponseParamsSpec.$,
        impl.readSparseData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        SimpleCacheEntry_Close_ParamsSpec.$,
        SimpleCacheEntry_Close_ResponseParamsSpec.$,
        impl.close.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SimpleCacheEntry {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SimpleCacheEntry";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SimpleCacheEntryRemote}
   */
  static getRemote() {
    let remote = new SimpleCacheEntryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SimpleCacheEntry
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SimpleCacheEntryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SimpleCacheEntryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SimpleCacheEntryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SimpleCacheEntry_WriteData_ParamsSpec.$,
        SimpleCacheEntry_WriteData_ResponseParamsSpec.$,
        this.writeData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SimpleCacheEntry_ReadData_ParamsSpec.$,
        SimpleCacheEntry_ReadData_ResponseParamsSpec.$,
        this.readData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeSparseData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SimpleCacheEntry_WriteSparseData_ParamsSpec.$,
        SimpleCacheEntry_WriteSparseData_ResponseParamsSpec.$,
        this.writeSparseData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readSparseData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SimpleCacheEntry_ReadSparseData_ParamsSpec.$,
        SimpleCacheEntry_ReadSparseData_ResponseParamsSpec.$,
        this.readSparseData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SimpleCacheEntry_Close_ParamsSpec.$,
        SimpleCacheEntry_Close_ResponseParamsSpec.$,
        this.close.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SimpleCacheEntryEnumeratorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.SimpleCacheEntryEnumerator', scope);
  }
}

/** @interface */
export class SimpleCacheEntryEnumeratorInterface {
  
  /**
   * @return {!Promise<{
        result: !SimpleCacheOpenEntryResult,
   *  }>}
   */

  getNext() {}
}

/**
 * @implements { SimpleCacheEntryEnumeratorInterface }
 */
export class SimpleCacheEntryEnumeratorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SimpleCacheEntryEnumeratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SimpleCacheEntryEnumeratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SimpleCacheEntryEnumeratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !SimpleCacheOpenEntryResult,
   *  }>}
   */

  getNext() {
    return this.proxy.sendMessage(
        0,
        SimpleCacheEntryEnumerator_GetNext_ParamsSpec.$,
        SimpleCacheEntryEnumerator_GetNext_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SimpleCacheEntryEnumerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SimpleCacheEntryEnumeratorReceiver {
  /**
   * @param {!SimpleCacheEntryEnumeratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SimpleCacheEntryEnumeratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SimpleCacheEntryEnumeratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SimpleCacheEntryEnumeratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SimpleCacheEntryEnumerator_GetNext_ParamsSpec.$,
        SimpleCacheEntryEnumerator_GetNext_ResponseParamsSpec.$,
        impl.getNext.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SimpleCacheEntryEnumerator {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SimpleCacheEntryEnumerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SimpleCacheEntryEnumeratorRemote}
   */
  static getRemote() {
    let remote = new SimpleCacheEntryEnumeratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SimpleCacheEntryEnumerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SimpleCacheEntryEnumeratorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SimpleCacheEntryEnumeratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SimpleCacheEntryEnumeratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SimpleCacheEntryEnumerator_GetNext_ParamsSpec.$,
        SimpleCacheEntryEnumerator_GetNext_ResponseParamsSpec.$,
        this.getNext.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SimpleCachePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.SimpleCache', scope);
  }
}

/** @interface */
export class SimpleCacheInterface {
  
  /**
   * @param { !string } key
   * @return {!Promise<{
        entry: ?SimpleCacheEntryRemote,
        error: !number,
   *  }>}
   */

  createEntry(key) {}
  
  /**
   * @param { !string } key
   * @return {!Promise<{
        entry: ?SimpleCacheEntryRemote,
        error: !number,
   *  }>}
   */

  openEntry(key) {}
  
  /**
   * @param { !string } key
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  doomEntry(key) {}
  
  /**
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  doomAllEntries() {}
  
  /**
   * @param { !SimpleCacheEntryEnumeratorPendingReceiver } receiver
   */

  enumerateEntries(receiver) {}
  
  /**
   * @return {!Promise}
   */

  detach() {}
}

/**
 * @implements { SimpleCacheInterface }
 */
export class SimpleCacheRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SimpleCachePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SimpleCachePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SimpleCachePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } key
   * @return {!Promise<{
        entry: ?SimpleCacheEntryRemote,
        error: !number,
   *  }>}
   */

  createEntry(
      key) {
    return this.proxy.sendMessage(
        0,
        SimpleCache_CreateEntry_ParamsSpec.$,
        SimpleCache_CreateEntry_ResponseParamsSpec.$,
        [
          key
        ],
        false);
  }

  
  /**
   * @param { !string } key
   * @return {!Promise<{
        entry: ?SimpleCacheEntryRemote,
        error: !number,
   *  }>}
   */

  openEntry(
      key) {
    return this.proxy.sendMessage(
        1,
        SimpleCache_OpenEntry_ParamsSpec.$,
        SimpleCache_OpenEntry_ResponseParamsSpec.$,
        [
          key
        ],
        false);
  }

  
  /**
   * @param { !string } key
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  doomEntry(
      key) {
    return this.proxy.sendMessage(
        2,
        SimpleCache_DoomEntry_ParamsSpec.$,
        SimpleCache_DoomEntry_ResponseParamsSpec.$,
        [
          key
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  doomAllEntries() {
    return this.proxy.sendMessage(
        3,
        SimpleCache_DoomAllEntries_ParamsSpec.$,
        SimpleCache_DoomAllEntries_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !SimpleCacheEntryEnumeratorPendingReceiver } receiver
   */

  enumerateEntries(
      receiver) {
    this.proxy.sendMessage(
        4,
        SimpleCache_EnumerateEntries_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  detach() {
    return this.proxy.sendMessage(
        5,
        SimpleCache_Detach_ParamsSpec.$,
        SimpleCache_Detach_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SimpleCache
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SimpleCacheReceiver {
  /**
   * @param {!SimpleCacheInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SimpleCacheRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SimpleCacheRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SimpleCacheRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SimpleCache_CreateEntry_ParamsSpec.$,
        SimpleCache_CreateEntry_ResponseParamsSpec.$,
        impl.createEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SimpleCache_OpenEntry_ParamsSpec.$,
        SimpleCache_OpenEntry_ResponseParamsSpec.$,
        impl.openEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SimpleCache_DoomEntry_ParamsSpec.$,
        SimpleCache_DoomEntry_ResponseParamsSpec.$,
        impl.doomEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SimpleCache_DoomAllEntries_ParamsSpec.$,
        SimpleCache_DoomAllEntries_ResponseParamsSpec.$,
        impl.doomAllEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        SimpleCache_EnumerateEntries_ParamsSpec.$,
        null,
        impl.enumerateEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        SimpleCache_Detach_ParamsSpec.$,
        SimpleCache_Detach_ResponseParamsSpec.$,
        impl.detach.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SimpleCache {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SimpleCache";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SimpleCacheRemote}
   */
  static getRemote() {
    let remote = new SimpleCacheRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SimpleCache
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SimpleCacheCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SimpleCacheRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SimpleCacheRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SimpleCache_CreateEntry_ParamsSpec.$,
        SimpleCache_CreateEntry_ResponseParamsSpec.$,
        this.createEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SimpleCache_OpenEntry_ParamsSpec.$,
        SimpleCache_OpenEntry_ResponseParamsSpec.$,
        this.openEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.doomEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SimpleCache_DoomEntry_ParamsSpec.$,
        SimpleCache_DoomEntry_ResponseParamsSpec.$,
        this.doomEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.doomAllEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SimpleCache_DoomAllEntries_ParamsSpec.$,
        SimpleCache_DoomAllEntries_ResponseParamsSpec.$,
        this.doomAllEntries.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enumerateEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SimpleCache_EnumerateEntries_ParamsSpec.$,
        null,
        this.enumerateEntries.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detach =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        SimpleCache_Detach_ParamsSpec.$,
        SimpleCache_Detach_ResponseParamsSpec.$,
        this.detach.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NetworkServiceTestPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.NetworkServiceTest', scope);
  }
}

/** @interface */
export class NetworkServiceTestInterface {
  
  /**
   * @param { !Array<!Rule> } rules
   * @return {!Promise}
   */

  addRules(rules) {}
  
  /**
   * @param { !network_mojom_ConnectionType } type
   * @return {!Promise}
   */

  simulateNetworkChange(type) {}
  
  /**
   * @param { !network_mojom_EffectiveConnectionType } type
   * @return {!Promise}
   */

  simulateNetworkQualityChange(type) {}
  
  /**
   * @return {!Promise}
   */

  forceNetworkQualityEstimatorReportWifiAsSlow2G() {}
  
  /**
   */

  simulateCrash() {}
  
  /**
   * @param { !number } defaultResult
   * @return {!Promise}
   */

  mockCertVerifierSetDefaultResult(defaultResult) {}
  
  /**
   * @param { !network_mojom_X509Certificate } cert
   * @param { !string } hostPattern
   * @param { !network_mojom_CertVerifyResult } verifyResult
   * @param { !number } rv
   * @return {!Promise}
   */

  mockCertVerifierAddResultForCertAndHost(cert, hostPattern, verifyResult, rv) {}
  
  /**
   * @param { !boolean } enableUnittestSource
   * @return {!Promise}
   */

  setTransportSecurityStateTestSource(enableUnittestSource) {}
  
  /**
   * @return {!Promise}
   */

  setAllowNetworkAccessToHostResolutions() {}
  
  /**
   * @return {!Promise}
   */

  replaceSystemDnsConfig() {}
  
  /**
   * @param { !network_mojom_SecureDnsMode } secureDnsMode
   * @param { !network_mojom_DnsOverHttpsConfig } dohConfig
   * @return {!Promise}
   */

  setTestDohConfig(secureDnsMode, dohConfig) {}
  
  /**
   * @param { !string } host
   */

  crashOnResolveHost(host) {}
  
  /**
   */

  crashOnGetCookieList() {}
  
  /**
   * @return {!Promise<{
        memoryPressureLevel: !mojoBase_mojom_MemoryPressureLevel,
   *  }>}
   */

  getLatestMemoryPressureLevel() {}
  
  /**
   * @return {!Promise<{
        connectionCount: !number,
   *  }>}
   */

  getPeerToPeerConnectionsCountChange() {}
  
  /**
   * @param { !string } name
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  getEnvironmentVariableValue(name) {}
  
  /**
   * @param { !string } message
   * @return {!Promise}
   */

  log(message) {}
  
  /**
   * @param { !string } fieldTrialName
   */

  activateFieldTrial(fieldTrialName) {}
  
  /**
   * @param { ?mojoBase_mojom_TimeDelta } delay
   * @return {!Promise}
   */

  setSCTAuditingRetryDelay(delay) {}
  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  openFile(path) {}
  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @param { !network_mojom_HttpCacheBackendFileOperationsFactoryRemote } factory
   * @return {!Promise<{
        entries: !Array<!network_mojom_FileEnumerationEntry>,
        error: !boolean,
   *  }>}
   */

  enumerateFiles(path, factory) {}
  
  /**
   * @param { !network_mojom_HttpCacheBackendFileOperationsFactoryRemote } factory
   * @param { !mojoBase_mojom_FilePath } path
   * @param { !boolean } reset
   * @return {!Promise<{
        backend: ?SimpleCacheRemote,
   *  }>}
   */

  createSimpleCache(factory, path, reset) {}
  
  /**
   * @param { !network_mojom_TransferableSocket } s
   * @param { !network_mojom_IPEndPoint } endpoint
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  makeRequestToServer(s, endpoint) {}
  
  /**
   * @return {!Promise<{
        addrList: !network_mojom_AddressList,
        osError: !number,
        netError: !number,
   *  }>}
   */

  resolveOwnHostnameWithSystemDns() {}
  
  /**
   * @param { !boolean } success
   * @return {!Promise}
   */

  setIPv6ProbeResult(success) {}
  
  /**
   * @return {!Promise<{
        addrMap: !network_mojom_AddressMap,
        links: !network_mojom_OnlineLinks,
   *  }>}
   */

  getAddressMapCacheLinux() {}
  
  /**
   * @return {!Promise<{
        allowGssapiLibraryLoad: !boolean,
   *  }>}
   */

  allowsGSSAPILibraryLoad() {}
  
  /**
   * @return {!Promise<{
        isHappyEyeballsV3Enabled: !boolean,
   *  }>}
   */

  isHappyEyeballsV3Enabled() {}
}

/**
 * @implements { NetworkServiceTestInterface }
 */
export class NetworkServiceTestRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NetworkServiceTestPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NetworkServiceTestPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NetworkServiceTestPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!Rule> } rules
   * @return {!Promise}
   */

  addRules(
      rules) {
    return this.proxy.sendMessage(
        0,
        NetworkServiceTest_AddRules_ParamsSpec.$,
        NetworkServiceTest_AddRules_ResponseParamsSpec.$,
        [
          rules
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_ConnectionType } type
   * @return {!Promise}
   */

  simulateNetworkChange(
      type) {
    return this.proxy.sendMessage(
        1,
        NetworkServiceTest_SimulateNetworkChange_ParamsSpec.$,
        NetworkServiceTest_SimulateNetworkChange_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_EffectiveConnectionType } type
   * @return {!Promise}
   */

  simulateNetworkQualityChange(
      type) {
    return this.proxy.sendMessage(
        2,
        NetworkServiceTest_SimulateNetworkQualityChange_ParamsSpec.$,
        NetworkServiceTest_SimulateNetworkQualityChange_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  forceNetworkQualityEstimatorReportWifiAsSlow2G() {
    return this.proxy.sendMessage(
        3,
        NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ParamsSpec.$,
        NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   */

  simulateCrash() {
    this.proxy.sendMessage(
        4,
        NetworkServiceTest_SimulateCrash_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } defaultResult
   * @return {!Promise}
   */

  mockCertVerifierSetDefaultResult(
      defaultResult) {
    return this.proxy.sendMessage(
        5,
        NetworkServiceTest_MockCertVerifierSetDefaultResult_ParamsSpec.$,
        NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsSpec.$,
        [
          defaultResult
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_X509Certificate } cert
   * @param { !string } hostPattern
   * @param { !network_mojom_CertVerifyResult } verifyResult
   * @param { !number } rv
   * @return {!Promise}
   */

  mockCertVerifierAddResultForCertAndHost(
      cert,
      hostPattern,
      verifyResult,
      rv) {
    return this.proxy.sendMessage(
        6,
        NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ParamsSpec.$,
        NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsSpec.$,
        [
          cert,
          hostPattern,
          verifyResult,
          rv
        ],
        false);
  }

  
  /**
   * @param { !boolean } enableUnittestSource
   * @return {!Promise}
   */

  setTransportSecurityStateTestSource(
      enableUnittestSource) {
    return this.proxy.sendMessage(
        7,
        NetworkServiceTest_SetTransportSecurityStateTestSource_ParamsSpec.$,
        NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParamsSpec.$,
        [
          enableUnittestSource
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  setAllowNetworkAccessToHostResolutions() {
    return this.proxy.sendMessage(
        8,
        NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ParamsSpec.$,
        NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  replaceSystemDnsConfig() {
    return this.proxy.sendMessage(
        9,
        NetworkServiceTest_ReplaceSystemDnsConfig_ParamsSpec.$,
        NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_SecureDnsMode } secureDnsMode
   * @param { !network_mojom_DnsOverHttpsConfig } dohConfig
   * @return {!Promise}
   */

  setTestDohConfig(
      secureDnsMode,
      dohConfig) {
    return this.proxy.sendMessage(
        10,
        NetworkServiceTest_SetTestDohConfig_ParamsSpec.$,
        NetworkServiceTest_SetTestDohConfig_ResponseParamsSpec.$,
        [
          secureDnsMode,
          dohConfig
        ],
        false);
  }

  
  /**
   * @param { !string } host
   */

  crashOnResolveHost(
      host) {
    this.proxy.sendMessage(
        11,
        NetworkServiceTest_CrashOnResolveHost_ParamsSpec.$,
        null,
        [
          host
        ],
        false);
  }

  
  /**
   */

  crashOnGetCookieList() {
    this.proxy.sendMessage(
        12,
        NetworkServiceTest_CrashOnGetCookieList_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        memoryPressureLevel: !mojoBase_mojom_MemoryPressureLevel,
   *  }>}
   */

  getLatestMemoryPressureLevel() {
    return this.proxy.sendMessage(
        13,
        NetworkServiceTest_GetLatestMemoryPressureLevel_ParamsSpec.$,
        NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        connectionCount: !number,
   *  }>}
   */

  getPeerToPeerConnectionsCountChange() {
    return this.proxy.sendMessage(
        14,
        NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ParamsSpec.$,
        NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  getEnvironmentVariableValue(
      name) {
    return this.proxy.sendMessage(
        15,
        NetworkServiceTest_GetEnvironmentVariableValue_ParamsSpec.$,
        NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsSpec.$,
        [
          name
        ],
        false);
  }

  
  /**
   * @param { !string } message
   * @return {!Promise}
   */

  log(
      message) {
    return this.proxy.sendMessage(
        16,
        NetworkServiceTest_Log_ParamsSpec.$,
        NetworkServiceTest_Log_ResponseParamsSpec.$,
        [
          message
        ],
        false);
  }

  
  /**
   * @param { !string } fieldTrialName
   */

  activateFieldTrial(
      fieldTrialName) {
    this.proxy.sendMessage(
        17,
        NetworkServiceTest_ActivateFieldTrial_ParamsSpec.$,
        null,
        [
          fieldTrialName
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase_mojom_TimeDelta } delay
   * @return {!Promise}
   */

  setSCTAuditingRetryDelay(
      delay) {
    return this.proxy.sendMessage(
        18,
        NetworkServiceTest_SetSCTAuditingRetryDelay_ParamsSpec.$,
        NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParamsSpec.$,
        [
          delay
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  openFile(
      path) {
    return this.proxy.sendMessage(
        19,
        NetworkServiceTest_OpenFile_ParamsSpec.$,
        NetworkServiceTest_OpenFile_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @param { !network_mojom_HttpCacheBackendFileOperationsFactoryRemote } factory
   * @return {!Promise<{
        entries: !Array<!network_mojom_FileEnumerationEntry>,
        error: !boolean,
   *  }>}
   */

  enumerateFiles(
      path,
      factory) {
    return this.proxy.sendMessage(
        20,
        NetworkServiceTest_EnumerateFiles_ParamsSpec.$,
        NetworkServiceTest_EnumerateFiles_ResponseParamsSpec.$,
        [
          path,
          factory
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_HttpCacheBackendFileOperationsFactoryRemote } factory
   * @param { !mojoBase_mojom_FilePath } path
   * @param { !boolean } reset
   * @return {!Promise<{
        backend: ?SimpleCacheRemote,
   *  }>}
   */

  createSimpleCache(
      factory,
      path,
      reset) {
    return this.proxy.sendMessage(
        21,
        NetworkServiceTest_CreateSimpleCache_ParamsSpec.$,
        NetworkServiceTest_CreateSimpleCache_ResponseParamsSpec.$,
        [
          factory,
          path,
          reset
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_TransferableSocket } s
   * @param { !network_mojom_IPEndPoint } endpoint
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  makeRequestToServer(
      s,
      endpoint) {
    return this.proxy.sendMessage(
        22,
        NetworkServiceTest_MakeRequestToServer_ParamsSpec.$,
        NetworkServiceTest_MakeRequestToServer_ResponseParamsSpec.$,
        [
          s,
          endpoint
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        addrList: !network_mojom_AddressList,
        osError: !number,
        netError: !number,
   *  }>}
   */

  resolveOwnHostnameWithSystemDns() {
    return this.proxy.sendMessage(
        23,
        NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ParamsSpec.$,
        NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } success
   * @return {!Promise}
   */

  setIPv6ProbeResult(
      success) {
    return this.proxy.sendMessage(
        24,
        NetworkServiceTest_SetIPv6ProbeResult_ParamsSpec.$,
        NetworkServiceTest_SetIPv6ProbeResult_ResponseParamsSpec.$,
        [
          success
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        addrMap: !network_mojom_AddressMap,
        links: !network_mojom_OnlineLinks,
   *  }>}
   */

  getAddressMapCacheLinux() {
    return this.proxy.sendMessage(
        25,
        NetworkServiceTest_GetAddressMapCacheLinux_ParamsSpec.$,
        NetworkServiceTest_GetAddressMapCacheLinux_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        allowGssapiLibraryLoad: !boolean,
   *  }>}
   */

  allowsGSSAPILibraryLoad() {
    return this.proxy.sendMessage(
        26,
        NetworkServiceTest_AllowsGSSAPILibraryLoad_ParamsSpec.$,
        NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        isHappyEyeballsV3Enabled: !boolean,
   *  }>}
   */

  isHappyEyeballsV3Enabled() {
    return this.proxy.sendMessage(
        27,
        NetworkServiceTest_IsHappyEyeballsV3Enabled_ParamsSpec.$,
        NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NetworkServiceTest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NetworkServiceTestReceiver {
  /**
   * @param {!NetworkServiceTestInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NetworkServiceTestRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NetworkServiceTestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkServiceTestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NetworkServiceTest_AddRules_ParamsSpec.$,
        NetworkServiceTest_AddRules_ResponseParamsSpec.$,
        impl.addRules.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NetworkServiceTest_SimulateNetworkChange_ParamsSpec.$,
        NetworkServiceTest_SimulateNetworkChange_ResponseParamsSpec.$,
        impl.simulateNetworkChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        NetworkServiceTest_SimulateNetworkQualityChange_ParamsSpec.$,
        NetworkServiceTest_SimulateNetworkQualityChange_ResponseParamsSpec.$,
        impl.simulateNetworkQualityChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ParamsSpec.$,
        NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParamsSpec.$,
        impl.forceNetworkQualityEstimatorReportWifiAsSlow2G.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        NetworkServiceTest_SimulateCrash_ParamsSpec.$,
        null,
        impl.simulateCrash.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        NetworkServiceTest_MockCertVerifierSetDefaultResult_ParamsSpec.$,
        NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsSpec.$,
        impl.mockCertVerifierSetDefaultResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ParamsSpec.$,
        NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsSpec.$,
        impl.mockCertVerifierAddResultForCertAndHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        NetworkServiceTest_SetTransportSecurityStateTestSource_ParamsSpec.$,
        NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParamsSpec.$,
        impl.setTransportSecurityStateTestSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ParamsSpec.$,
        NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsSpec.$,
        impl.setAllowNetworkAccessToHostResolutions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        NetworkServiceTest_ReplaceSystemDnsConfig_ParamsSpec.$,
        NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParamsSpec.$,
        impl.replaceSystemDnsConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        NetworkServiceTest_SetTestDohConfig_ParamsSpec.$,
        NetworkServiceTest_SetTestDohConfig_ResponseParamsSpec.$,
        impl.setTestDohConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        NetworkServiceTest_CrashOnResolveHost_ParamsSpec.$,
        null,
        impl.crashOnResolveHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        NetworkServiceTest_CrashOnGetCookieList_ParamsSpec.$,
        null,
        impl.crashOnGetCookieList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        NetworkServiceTest_GetLatestMemoryPressureLevel_ParamsSpec.$,
        NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsSpec.$,
        impl.getLatestMemoryPressureLevel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ParamsSpec.$,
        NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsSpec.$,
        impl.getPeerToPeerConnectionsCountChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        NetworkServiceTest_GetEnvironmentVariableValue_ParamsSpec.$,
        NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsSpec.$,
        impl.getEnvironmentVariableValue.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        NetworkServiceTest_Log_ParamsSpec.$,
        NetworkServiceTest_Log_ResponseParamsSpec.$,
        impl.log.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        NetworkServiceTest_ActivateFieldTrial_ParamsSpec.$,
        null,
        impl.activateFieldTrial.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        NetworkServiceTest_SetSCTAuditingRetryDelay_ParamsSpec.$,
        NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParamsSpec.$,
        impl.setSCTAuditingRetryDelay.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        NetworkServiceTest_OpenFile_ParamsSpec.$,
        NetworkServiceTest_OpenFile_ResponseParamsSpec.$,
        impl.openFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        NetworkServiceTest_EnumerateFiles_ParamsSpec.$,
        NetworkServiceTest_EnumerateFiles_ResponseParamsSpec.$,
        impl.enumerateFiles.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        NetworkServiceTest_CreateSimpleCache_ParamsSpec.$,
        NetworkServiceTest_CreateSimpleCache_ResponseParamsSpec.$,
        impl.createSimpleCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        NetworkServiceTest_MakeRequestToServer_ParamsSpec.$,
        NetworkServiceTest_MakeRequestToServer_ResponseParamsSpec.$,
        impl.makeRequestToServer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ParamsSpec.$,
        NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParamsSpec.$,
        impl.resolveOwnHostnameWithSystemDns.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        NetworkServiceTest_SetIPv6ProbeResult_ParamsSpec.$,
        NetworkServiceTest_SetIPv6ProbeResult_ResponseParamsSpec.$,
        impl.setIPv6ProbeResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        NetworkServiceTest_GetAddressMapCacheLinux_ParamsSpec.$,
        NetworkServiceTest_GetAddressMapCacheLinux_ResponseParamsSpec.$,
        impl.getAddressMapCacheLinux.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        NetworkServiceTest_AllowsGSSAPILibraryLoad_ParamsSpec.$,
        NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParamsSpec.$,
        impl.allowsGSSAPILibraryLoad.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        NetworkServiceTest_IsHappyEyeballsV3Enabled_ParamsSpec.$,
        NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParamsSpec.$,
        impl.isHappyEyeballsV3Enabled.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NetworkServiceTest {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetworkServiceTest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NetworkServiceTestRemote}
   */
  static getRemote() {
    let remote = new NetworkServiceTestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NetworkServiceTest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NetworkServiceTestCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NetworkServiceTestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkServiceTestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addRules =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NetworkServiceTest_AddRules_ParamsSpec.$,
        NetworkServiceTest_AddRules_ResponseParamsSpec.$,
        this.addRules.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateNetworkChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NetworkServiceTest_SimulateNetworkChange_ParamsSpec.$,
        NetworkServiceTest_SimulateNetworkChange_ResponseParamsSpec.$,
        this.simulateNetworkChange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateNetworkQualityChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        NetworkServiceTest_SimulateNetworkQualityChange_ParamsSpec.$,
        NetworkServiceTest_SimulateNetworkQualityChange_ResponseParamsSpec.$,
        this.simulateNetworkQualityChange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forceNetworkQualityEstimatorReportWifiAsSlow2G =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ParamsSpec.$,
        NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParamsSpec.$,
        this.forceNetworkQualityEstimatorReportWifiAsSlow2G.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateCrash =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        NetworkServiceTest_SimulateCrash_ParamsSpec.$,
        null,
        this.simulateCrash.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mockCertVerifierSetDefaultResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        NetworkServiceTest_MockCertVerifierSetDefaultResult_ParamsSpec.$,
        NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsSpec.$,
        this.mockCertVerifierSetDefaultResult.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mockCertVerifierAddResultForCertAndHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ParamsSpec.$,
        NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsSpec.$,
        this.mockCertVerifierAddResultForCertAndHost.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTransportSecurityStateTestSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        NetworkServiceTest_SetTransportSecurityStateTestSource_ParamsSpec.$,
        NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParamsSpec.$,
        this.setTransportSecurityStateTestSource.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAllowNetworkAccessToHostResolutions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ParamsSpec.$,
        NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsSpec.$,
        this.setAllowNetworkAccessToHostResolutions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replaceSystemDnsConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        NetworkServiceTest_ReplaceSystemDnsConfig_ParamsSpec.$,
        NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParamsSpec.$,
        this.replaceSystemDnsConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTestDohConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        NetworkServiceTest_SetTestDohConfig_ParamsSpec.$,
        NetworkServiceTest_SetTestDohConfig_ResponseParamsSpec.$,
        this.setTestDohConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.crashOnResolveHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        NetworkServiceTest_CrashOnResolveHost_ParamsSpec.$,
        null,
        this.crashOnResolveHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.crashOnGetCookieList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        NetworkServiceTest_CrashOnGetCookieList_ParamsSpec.$,
        null,
        this.crashOnGetCookieList.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getLatestMemoryPressureLevel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        NetworkServiceTest_GetLatestMemoryPressureLevel_ParamsSpec.$,
        NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsSpec.$,
        this.getLatestMemoryPressureLevel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPeerToPeerConnectionsCountChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ParamsSpec.$,
        NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsSpec.$,
        this.getPeerToPeerConnectionsCountChange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getEnvironmentVariableValue =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        NetworkServiceTest_GetEnvironmentVariableValue_ParamsSpec.$,
        NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsSpec.$,
        this.getEnvironmentVariableValue.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.log =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        NetworkServiceTest_Log_ParamsSpec.$,
        NetworkServiceTest_Log_ResponseParamsSpec.$,
        this.log.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.activateFieldTrial =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        NetworkServiceTest_ActivateFieldTrial_ParamsSpec.$,
        null,
        this.activateFieldTrial.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSCTAuditingRetryDelay =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        NetworkServiceTest_SetSCTAuditingRetryDelay_ParamsSpec.$,
        NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParamsSpec.$,
        this.setSCTAuditingRetryDelay.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        NetworkServiceTest_OpenFile_ParamsSpec.$,
        NetworkServiceTest_OpenFile_ResponseParamsSpec.$,
        this.openFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enumerateFiles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        NetworkServiceTest_EnumerateFiles_ParamsSpec.$,
        NetworkServiceTest_EnumerateFiles_ResponseParamsSpec.$,
        this.enumerateFiles.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSimpleCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        NetworkServiceTest_CreateSimpleCache_ParamsSpec.$,
        NetworkServiceTest_CreateSimpleCache_ResponseParamsSpec.$,
        this.createSimpleCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.makeRequestToServer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        NetworkServiceTest_MakeRequestToServer_ParamsSpec.$,
        NetworkServiceTest_MakeRequestToServer_ResponseParamsSpec.$,
        this.makeRequestToServer.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveOwnHostnameWithSystemDns =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ParamsSpec.$,
        NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParamsSpec.$,
        this.resolveOwnHostnameWithSystemDns.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIPv6ProbeResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        NetworkServiceTest_SetIPv6ProbeResult_ParamsSpec.$,
        NetworkServiceTest_SetIPv6ProbeResult_ResponseParamsSpec.$,
        this.setIPv6ProbeResult.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAddressMapCacheLinux =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        NetworkServiceTest_GetAddressMapCacheLinux_ParamsSpec.$,
        NetworkServiceTest_GetAddressMapCacheLinux_ResponseParamsSpec.$,
        this.getAddressMapCacheLinux.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.allowsGSSAPILibraryLoad =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        NetworkServiceTest_AllowsGSSAPILibraryLoad_ParamsSpec.$,
        NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParamsSpec.$,
        this.allowsGSSAPILibraryLoad.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isHappyEyeballsV3Enabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        NetworkServiceTest_IsHappyEyeballsV3Enabled_ParamsSpec.$,
        NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParamsSpec.$,
        this.isHappyEyeballsV3Enabled.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RuleSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCacheOpenEntryResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCacheEntry_WriteData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCacheEntry_WriteData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCacheEntry_ReadData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCacheEntry_ReadData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCacheEntry_WriteSparseData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCacheEntry_WriteSparseData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCacheEntry_ReadSparseData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCacheEntry_ReadSparseData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCacheEntry_Close_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCacheEntry_Close_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCacheEntryEnumerator_GetNext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCacheEntryEnumerator_GetNext_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCache_CreateEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCache_CreateEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCache_OpenEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCache_OpenEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCache_DoomEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCache_DoomEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCache_DoomAllEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCache_DoomAllEntries_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCache_EnumerateEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCache_Detach_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SimpleCache_Detach_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_AddRules_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_AddRules_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SimulateNetworkChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SimulateNetworkChange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SimulateNetworkQualityChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SimulateNetworkQualityChange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SimulateCrash_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_MockCertVerifierSetDefaultResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SetTransportSecurityStateTestSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_ReplaceSystemDnsConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SetTestDohConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SetTestDohConfig_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_CrashOnResolveHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_CrashOnGetCookieList_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_GetLatestMemoryPressureLevel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_GetEnvironmentVariableValue_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_Log_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_Log_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_ActivateFieldTrial_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SetSCTAuditingRetryDelay_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_OpenFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_OpenFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_EnumerateFiles_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_EnumerateFiles_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_CreateSimpleCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_CreateSimpleCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_MakeRequestToServer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_MakeRequestToServer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SetIPv6ProbeResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_SetIPv6ProbeResult_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_GetAddressMapCacheLinux_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_GetAddressMapCacheLinux_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_AllowsGSSAPILibraryLoad_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_IsHappyEyeballsV3Enabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    RuleSpec.$,
    'Rule',
    [
      mojo.internal.StructField(
        'resolverType', 0,
        0,
        ResolverTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostPattern', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'replacement', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostResolverFlags', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dnsAliases', 24,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class Rule {
  constructor() {
    /** @type { !ResolverType } */
    this.resolverType;
    /** @type { !string } */
    this.hostPattern;
    /** @type { !string } */
    this.replacement;
    /** @type { !number } */
    this.hostResolverFlags;
    /** @type { !Array<!string> } */
    this.dnsAliases;
  }
}



mojo.internal.Struct(
    SimpleCacheOpenEntryResultSpec.$,
    'SimpleCacheOpenEntryResult',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'key', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'entry', 16,
        0,
        mojo.internal.InterfaceProxy(SimpleCacheEntryRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SimpleCacheOpenEntryResult {
  constructor() {
    /** @type { !number } */
    this.error;
    /** @type { !string } */
    this.key;
    /** @type { (SimpleCacheEntryRemote|undefined) } */
    this.entry;
  }
}



mojo.internal.Struct(
    SimpleCacheEntry_WriteData_ParamsSpec.$,
    'SimpleCacheEntry_WriteData_Params',
    [
      mojo.internal.StructField(
        'index', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'offset', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'truncate', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SimpleCacheEntry_WriteData_Params {
  constructor() {
    /** @type { !number } */
    this.index;
    /** @type { !number } */
    this.offset;
    /** @type { !Array<!number> } */
    this.data;
    /** @type { !boolean } */
    this.truncate;
  }
}



mojo.internal.Struct(
    SimpleCacheEntry_WriteData_ResponseParamsSpec.$,
    'SimpleCacheEntry_WriteData_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SimpleCacheEntry_WriteData_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    SimpleCacheEntry_ReadData_ParamsSpec.$,
    'SimpleCacheEntry_ReadData_Params',
    [
      mojo.internal.StructField(
        'index', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'offset', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SimpleCacheEntry_ReadData_Params {
  constructor() {
    /** @type { !number } */
    this.index;
    /** @type { !number } */
    this.offset;
    /** @type { !number } */
    this.length;
  }
}



mojo.internal.Struct(
    SimpleCacheEntry_ReadData_ResponseParamsSpec.$,
    'SimpleCacheEntry_ReadData_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SimpleCacheEntry_ReadData_ResponseParams {
  constructor() {
    /** @type { !Array<!number> } */
    this.data;
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    SimpleCacheEntry_WriteSparseData_ParamsSpec.$,
    'SimpleCacheEntry_WriteSparseData_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SimpleCacheEntry_WriteSparseData_Params {
  constructor() {
    /** @type { !number } */
    this.offset;
    /** @type { !Array<!number> } */
    this.data;
  }
}



mojo.internal.Struct(
    SimpleCacheEntry_WriteSparseData_ResponseParamsSpec.$,
    'SimpleCacheEntry_WriteSparseData_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SimpleCacheEntry_WriteSparseData_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    SimpleCacheEntry_ReadSparseData_ParamsSpec.$,
    'SimpleCacheEntry_ReadSparseData_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SimpleCacheEntry_ReadSparseData_Params {
  constructor() {
    /** @type { !number } */
    this.offset;
    /** @type { !number } */
    this.length;
  }
}



mojo.internal.Struct(
    SimpleCacheEntry_ReadSparseData_ResponseParamsSpec.$,
    'SimpleCacheEntry_ReadSparseData_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SimpleCacheEntry_ReadSparseData_ResponseParams {
  constructor() {
    /** @type { !Array<!number> } */
    this.data;
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    SimpleCacheEntry_Close_ParamsSpec.$,
    'SimpleCacheEntry_Close_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SimpleCacheEntry_Close_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SimpleCacheEntry_Close_ResponseParamsSpec.$,
    'SimpleCacheEntry_Close_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SimpleCacheEntry_Close_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    SimpleCacheEntryEnumerator_GetNext_ParamsSpec.$,
    'SimpleCacheEntryEnumerator_GetNext_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SimpleCacheEntryEnumerator_GetNext_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SimpleCacheEntryEnumerator_GetNext_ResponseParamsSpec.$,
    'SimpleCacheEntryEnumerator_GetNext_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SimpleCacheOpenEntryResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SimpleCacheEntryEnumerator_GetNext_ResponseParams {
  constructor() {
    /** @type { !SimpleCacheOpenEntryResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SimpleCache_CreateEntry_ParamsSpec.$,
    'SimpleCache_CreateEntry_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SimpleCache_CreateEntry_Params {
  constructor() {
    /** @type { !string } */
    this.key;
  }
}



mojo.internal.Struct(
    SimpleCache_CreateEntry_ResponseParamsSpec.$,
    'SimpleCache_CreateEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'entry', 0,
        0,
        mojo.internal.InterfaceProxy(SimpleCacheEntryRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SimpleCache_CreateEntry_ResponseParams {
  constructor() {
    /** @type { (SimpleCacheEntryRemote|undefined) } */
    this.entry;
    /** @type { !number } */
    this.error;
  }
}



mojo.internal.Struct(
    SimpleCache_OpenEntry_ParamsSpec.$,
    'SimpleCache_OpenEntry_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SimpleCache_OpenEntry_Params {
  constructor() {
    /** @type { !string } */
    this.key;
  }
}



mojo.internal.Struct(
    SimpleCache_OpenEntry_ResponseParamsSpec.$,
    'SimpleCache_OpenEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'entry', 0,
        0,
        mojo.internal.InterfaceProxy(SimpleCacheEntryRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SimpleCache_OpenEntry_ResponseParams {
  constructor() {
    /** @type { (SimpleCacheEntryRemote|undefined) } */
    this.entry;
    /** @type { !number } */
    this.error;
  }
}



mojo.internal.Struct(
    SimpleCache_DoomEntry_ParamsSpec.$,
    'SimpleCache_DoomEntry_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SimpleCache_DoomEntry_Params {
  constructor() {
    /** @type { !string } */
    this.key;
  }
}



mojo.internal.Struct(
    SimpleCache_DoomEntry_ResponseParamsSpec.$,
    'SimpleCache_DoomEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SimpleCache_DoomEntry_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    SimpleCache_DoomAllEntries_ParamsSpec.$,
    'SimpleCache_DoomAllEntries_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SimpleCache_DoomAllEntries_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SimpleCache_DoomAllEntries_ResponseParamsSpec.$,
    'SimpleCache_DoomAllEntries_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SimpleCache_DoomAllEntries_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    SimpleCache_EnumerateEntries_ParamsSpec.$,
    'SimpleCache_EnumerateEntries_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(SimpleCacheEntryEnumeratorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SimpleCache_EnumerateEntries_Params {
  constructor() {
    /** @type { !SimpleCacheEntryEnumeratorPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    SimpleCache_Detach_ParamsSpec.$,
    'SimpleCache_Detach_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SimpleCache_Detach_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SimpleCache_Detach_ResponseParamsSpec.$,
    'SimpleCache_Detach_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SimpleCache_Detach_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_AddRules_ParamsSpec.$,
    'NetworkServiceTest_AddRules_Params',
    [
      mojo.internal.StructField(
        'rules', 0,
        0,
        mojo.internal.Array(RuleSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_AddRules_Params {
  constructor() {
    /** @type { !Array<!Rule> } */
    this.rules;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_AddRules_ResponseParamsSpec.$,
    'NetworkServiceTest_AddRules_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_AddRules_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SimulateNetworkChange_ParamsSpec.$,
    'NetworkServiceTest_SimulateNetworkChange_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        network_mojom_ConnectionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_SimulateNetworkChange_Params {
  constructor() {
    /** @type { !network_mojom_ConnectionType } */
    this.type;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SimulateNetworkChange_ResponseParamsSpec.$,
    'NetworkServiceTest_SimulateNetworkChange_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_SimulateNetworkChange_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SimulateNetworkQualityChange_ParamsSpec.$,
    'NetworkServiceTest_SimulateNetworkQualityChange_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        network_mojom_EffectiveConnectionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_SimulateNetworkQualityChange_Params {
  constructor() {
    /** @type { !network_mojom_EffectiveConnectionType } */
    this.type;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SimulateNetworkQualityChange_ResponseParamsSpec.$,
    'NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ParamsSpec.$,
    'NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParamsSpec.$,
    'NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SimulateCrash_ParamsSpec.$,
    'NetworkServiceTest_SimulateCrash_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_SimulateCrash_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_MockCertVerifierSetDefaultResult_ParamsSpec.$,
    'NetworkServiceTest_MockCertVerifierSetDefaultResult_Params',
    [
      mojo.internal.StructField(
        'defaultResult', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_MockCertVerifierSetDefaultResult_Params {
  constructor() {
    /** @type { !number } */
    this.defaultResult;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsSpec.$,
    'NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ParamsSpec.$,
    'NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params',
    [
      mojo.internal.StructField(
        'cert', 0,
        0,
        network_mojom_X509CertificateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostPattern', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'verifyResult', 16,
        0,
        network_mojom_CertVerifyResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rv', 24,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params {
  constructor() {
    /** @type { !network_mojom_X509Certificate } */
    this.cert;
    /** @type { !string } */
    this.hostPattern;
    /** @type { !network_mojom_CertVerifyResult } */
    this.verifyResult;
    /** @type { !number } */
    this.rv;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsSpec.$,
    'NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SetTransportSecurityStateTestSource_ParamsSpec.$,
    'NetworkServiceTest_SetTransportSecurityStateTestSource_Params',
    [
      mojo.internal.StructField(
        'enableUnittestSource', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_SetTransportSecurityStateTestSource_Params {
  constructor() {
    /** @type { !boolean } */
    this.enableUnittestSource;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParamsSpec.$,
    'NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ParamsSpec.$,
    'NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsSpec.$,
    'NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_ReplaceSystemDnsConfig_ParamsSpec.$,
    'NetworkServiceTest_ReplaceSystemDnsConfig_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_ReplaceSystemDnsConfig_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParamsSpec.$,
    'NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SetTestDohConfig_ParamsSpec.$,
    'NetworkServiceTest_SetTestDohConfig_Params',
    [
      mojo.internal.StructField(
        'secureDnsMode', 0,
        0,
        network_mojom_SecureDnsModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dohConfig', 8,
        0,
        network_mojom_DnsOverHttpsConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkServiceTest_SetTestDohConfig_Params {
  constructor() {
    /** @type { !network_mojom_SecureDnsMode } */
    this.secureDnsMode;
    /** @type { !network_mojom_DnsOverHttpsConfig } */
    this.dohConfig;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SetTestDohConfig_ResponseParamsSpec.$,
    'NetworkServiceTest_SetTestDohConfig_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_SetTestDohConfig_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_CrashOnResolveHost_ParamsSpec.$,
    'NetworkServiceTest_CrashOnResolveHost_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_CrashOnResolveHost_Params {
  constructor() {
    /** @type { !string } */
    this.host;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_CrashOnGetCookieList_ParamsSpec.$,
    'NetworkServiceTest_CrashOnGetCookieList_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_CrashOnGetCookieList_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_GetLatestMemoryPressureLevel_ParamsSpec.$,
    'NetworkServiceTest_GetLatestMemoryPressureLevel_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_GetLatestMemoryPressureLevel_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsSpec.$,
    'NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams',
    [
      mojo.internal.StructField(
        'memoryPressureLevel', 0,
        0,
        mojoBase_mojom_MemoryPressureLevelSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_MemoryPressureLevel } */
    this.memoryPressureLevel;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ParamsSpec.$,
    'NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsSpec.$,
    'NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams',
    [
      mojo.internal.StructField(
        'connectionCount', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.connectionCount;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_GetEnvironmentVariableValue_ParamsSpec.$,
    'NetworkServiceTest_GetEnvironmentVariableValue_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_GetEnvironmentVariableValue_Params {
  constructor() {
    /** @type { !string } */
    this.name;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsSpec.$,
    'NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_Log_ParamsSpec.$,
    'NetworkServiceTest_Log_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_Log_Params {
  constructor() {
    /** @type { !string } */
    this.message;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_Log_ResponseParamsSpec.$,
    'NetworkServiceTest_Log_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_Log_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_ActivateFieldTrial_ParamsSpec.$,
    'NetworkServiceTest_ActivateFieldTrial_Params',
    [
      mojo.internal.StructField(
        'fieldTrialName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_ActivateFieldTrial_Params {
  constructor() {
    /** @type { !string } */
    this.fieldTrialName;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SetSCTAuditingRetryDelay_ParamsSpec.$,
    'NetworkServiceTest_SetSCTAuditingRetryDelay_Params',
    [
      mojo.internal.StructField(
        'delay', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_SetSCTAuditingRetryDelay_Params {
  constructor() {
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.delay;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParamsSpec.$,
    'NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_OpenFile_ParamsSpec.$,
    'NetworkServiceTest_OpenFile_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_OpenFile_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_OpenFile_ResponseParamsSpec.$,
    'NetworkServiceTest_OpenFile_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_OpenFile_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_EnumerateFiles_ParamsSpec.$,
    'NetworkServiceTest_EnumerateFiles_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'factory', 8,
        0,
        mojo.internal.InterfaceProxy(network_mojom_HttpCacheBackendFileOperationsFactoryRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkServiceTest_EnumerateFiles_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
    /** @type { !network_mojom_HttpCacheBackendFileOperationsFactoryRemote } */
    this.factory;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_EnumerateFiles_ResponseParamsSpec.$,
    'NetworkServiceTest_EnumerateFiles_ResponseParams',
    [
      mojo.internal.StructField(
        'entries', 0,
        0,
        mojo.internal.Array(network_mojom_FileEnumerationEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkServiceTest_EnumerateFiles_ResponseParams {
  constructor() {
    /** @type { !Array<!network_mojom_FileEnumerationEntry> } */
    this.entries;
    /** @type { !boolean } */
    this.error;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_CreateSimpleCache_ParamsSpec.$,
    'NetworkServiceTest_CreateSimpleCache_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.InterfaceProxy(network_mojom_HttpCacheBackendFileOperationsFactoryRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'path', 8,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reset', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkServiceTest_CreateSimpleCache_Params {
  constructor() {
    /** @type { !network_mojom_HttpCacheBackendFileOperationsFactoryRemote } */
    this.factory;
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
    /** @type { !boolean } */
    this.reset;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_CreateSimpleCache_ResponseParamsSpec.$,
    'NetworkServiceTest_CreateSimpleCache_ResponseParams',
    [
      mojo.internal.StructField(
        'backend', 0,
        0,
        mojo.internal.InterfaceProxy(SimpleCacheRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_CreateSimpleCache_ResponseParams {
  constructor() {
    /** @type { (SimpleCacheRemote|undefined) } */
    this.backend;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_MakeRequestToServer_ParamsSpec.$,
    'NetworkServiceTest_MakeRequestToServer_Params',
    [
      mojo.internal.StructField(
        's', 0,
        0,
        network_mojom_TransferableSocketSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endpoint', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkServiceTest_MakeRequestToServer_Params {
  constructor() {
    /** @type { !network_mojom_TransferableSocket } */
    this.s;
    /** @type { !network_mojom_IPEndPoint } */
    this.endpoint;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_MakeRequestToServer_ResponseParamsSpec.$,
    'NetworkServiceTest_MakeRequestToServer_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_MakeRequestToServer_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ParamsSpec.$,
    'NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParamsSpec.$,
    'NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams',
    [
      mojo.internal.StructField(
        'addrList', 0,
        0,
        network_mojom_AddressListSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'osError', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'netError', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams {
  constructor() {
    /** @type { !network_mojom_AddressList } */
    this.addrList;
    /** @type { !number } */
    this.osError;
    /** @type { !number } */
    this.netError;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SetIPv6ProbeResult_ParamsSpec.$,
    'NetworkServiceTest_SetIPv6ProbeResult_Params',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_SetIPv6ProbeResult_Params {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_SetIPv6ProbeResult_ResponseParamsSpec.$,
    'NetworkServiceTest_SetIPv6ProbeResult_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_SetIPv6ProbeResult_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_GetAddressMapCacheLinux_ParamsSpec.$,
    'NetworkServiceTest_GetAddressMapCacheLinux_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_GetAddressMapCacheLinux_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_GetAddressMapCacheLinux_ResponseParamsSpec.$,
    'NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams',
    [
      mojo.internal.StructField(
        'addrMap', 0,
        0,
        network_mojom_AddressMapSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'links', 8,
        0,
        network_mojom_OnlineLinksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkServiceTest_GetAddressMapCacheLinux_ResponseParams {
  constructor() {
    /** @type { !network_mojom_AddressMap } */
    this.addrMap;
    /** @type { !network_mojom_OnlineLinks } */
    this.links;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_AllowsGSSAPILibraryLoad_ParamsSpec.$,
    'NetworkServiceTest_AllowsGSSAPILibraryLoad_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_AllowsGSSAPILibraryLoad_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParamsSpec.$,
    'NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams',
    [
      mojo.internal.StructField(
        'allowGssapiLibraryLoad', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.allowGssapiLibraryLoad;
  }
}



mojo.internal.Struct(
    NetworkServiceTest_IsHappyEyeballsV3Enabled_ParamsSpec.$,
    'NetworkServiceTest_IsHappyEyeballsV3Enabled_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkServiceTest_IsHappyEyeballsV3Enabled_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParamsSpec.$,
    'NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams',
    [
      mojo.internal.StructField(
        'isHappyEyeballsV3Enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.isHappyEyeballsV3Enabled;
  }
}

