// services/network/public/mojom/schemeful_site.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/schemeful_site.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../url/mojom/origin.mojom.js');
  }



  function SchemefulSite(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SchemefulSite.prototype.initDefaults_ = function() {
    this.siteAsOrigin = null;
  };
  SchemefulSite.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SchemefulSite.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SchemefulSite.siteAsOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SchemefulSite.encodedSize = codec.kStructHeaderSize + 8;

  SchemefulSite.decode = function(decoder) {
    var packed;
    var val = new SchemefulSite();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.siteAsOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    return val;
  };

  SchemefulSite.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SchemefulSite.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.siteAsOrigin);
  };
  exports.SchemefulSite = SchemefulSite;
})();