// services/network/public/mojom/service_worker_router_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/service_worker_router_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }


  var ServiceWorkerRouterSourceType = {};
  ServiceWorkerRouterSourceType.kNetwork = 0;
  ServiceWorkerRouterSourceType.kRaceNetworkAndFetchEvent = 1;
  ServiceWorkerRouterSourceType.kFetchEvent = 2;
  ServiceWorkerRouterSourceType.kCache = 3;
  ServiceWorkerRouterSourceType.kRaceNetworkAndCache = 4;
  ServiceWorkerRouterSourceType.MIN_VALUE = 0;
  ServiceWorkerRouterSourceType.MAX_VALUE = 4;

  ServiceWorkerRouterSourceType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  ServiceWorkerRouterSourceType.toKnownEnumValue = function(value) {
    return value;
  };

  ServiceWorkerRouterSourceType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ServiceWorkerStatus = {};
  ServiceWorkerStatus.kRunning = 0;
  ServiceWorkerStatus.kStarting = 1;
  ServiceWorkerStatus.kStopping = 2;
  ServiceWorkerStatus.kStopped = 3;
  ServiceWorkerStatus.kWarmingUp = 4;
  ServiceWorkerStatus.kWarmedUp = 5;
  ServiceWorkerStatus.MIN_VALUE = 0;
  ServiceWorkerStatus.MAX_VALUE = 5;

  ServiceWorkerStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  ServiceWorkerStatus.toKnownEnumValue = function(value) {
    return value;
  };

  ServiceWorkerStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ServiceWorkerRouterInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterInfo.prototype.initDefaults_ = function() {
    this.rule_id_matched_$flag = true;
    this.matched_source_type_$flag = false;
    this.actual_source_type_$flag = false;
    this.evaluation_worker_status_$flag = false;
    this.rule_id_matched_$value = 0;
    this.matched_source_type_$value = 0;
    this.actual_source_type_$value = 0;
    this.routeRuleNum = 0;
    this.routerEvaluationTime = null;
    this.cacheLookupTime = null;
    this.evaluation_worker_status_$value = 0;
  };
  ServiceWorkerRouterInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate ServiceWorkerRouterInfo.matched_source_type_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, ServiceWorkerRouterSourceType);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ServiceWorkerRouterInfo.actual_source_type_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, ServiceWorkerRouterSourceType);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ServiceWorkerRouterInfo.routerEvaluationTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterInfo.cacheLookupTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ServiceWorkerRouterInfo.evaluation_worker_status_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, ServiceWorkerStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterInfo.encodedSize = codec.kStructHeaderSize + 48;

  ServiceWorkerRouterInfo.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.rule_id_matched_$flag = (packed >> 0) & 1 ? true : false;
    val.matched_source_type_$flag = (packed >> 1) & 1 ? true : false;
    val.actual_source_type_$flag = (packed >> 2) & 1 ? true : false;
    val.evaluation_worker_status_$flag = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.rule_id_matched_$value =
        decoder.decodeStruct(codec.Uint32);
    val.matched_source_type_$value =
        decoder.decodeStruct(new codec.Enum(ServiceWorkerRouterSourceType));
    val.actual_source_type_$value =
        decoder.decodeStruct(new codec.Enum(ServiceWorkerRouterSourceType));
    val.routeRuleNum =
        decoder.decodeStruct(codec.Uint64);
    val.routerEvaluationTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.cacheLookupTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.evaluation_worker_status_$value =
        decoder.decodeStruct(new codec.Enum(ServiceWorkerStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerRouterInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterInfo.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.rule_id_matched_$flag & 1) << 0
    packed |= (val.matched_source_type_$flag & 1) << 1
    packed |= (val.actual_source_type_$flag & 1) << 2
    packed |= (val.evaluation_worker_status_$flag & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.rule_id_matched_$value);
    encoder.encodeStruct(codec.Int32, val.matched_source_type_$value);
    encoder.encodeStruct(codec.Int32, val.actual_source_type_$value);
    encoder.encodeStruct(codec.Uint64, val.routeRuleNum);
    encoder.encodeStructPointer(time$.TimeDelta, val.routerEvaluationTime);
    encoder.encodeStructPointer(time$.TimeDelta, val.cacheLookupTime);
    encoder.encodeStruct(codec.Int32, val.evaluation_worker_status_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.ServiceWorkerRouterSourceType = ServiceWorkerRouterSourceType;
  exports.ServiceWorkerStatus = ServiceWorkerStatus;
  exports.ServiceWorkerRouterInfo = ServiceWorkerRouterInfo;
})();