// services/network/public/mojom/ssl_config.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');





goog.provide('network.mojom.SSLVersion');
goog.provide('network.mojom.SSLVersionSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.SSLVersionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.SSLVersion = {
  
  kTLS12: 0,
  kTLS13: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('network.mojom.SSLNamedGroupsPreset');
goog.provide('network.mojom.SSLNamedGroupsPresetSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.SSLNamedGroupsPresetSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.SSLNamedGroupsPreset = {
  
  kDefault: 0,
  kCnsa2: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('network.mojom.SSLConfigClient');
goog.provide('network.mojom.SSLConfigClientReceiver');
goog.provide('network.mojom.SSLConfigClientCallbackRouter');
goog.provide('network.mojom.SSLConfigClientInterface');
goog.provide('network.mojom.SSLConfigClientRemote');
goog.provide('network.mojom.SSLConfigClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.SSLConfigClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.SSLConfigClient.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.SSLConfigClientInterface = class {
  
  /**
   * @param { !network.mojom.SSLConfig } sslConfig
   */

  onSSLConfigUpdated(sslConfig) {}
};

/**
 * @export
 * @implements { network.mojom.SSLConfigClientInterface }
 */
network.mojom.SSLConfigClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.SSLConfigClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.SSLConfigClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.SSLConfigClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.SSLConfig } sslConfig
   */

  onSSLConfigUpdated(
      sslConfig) {
    this.proxy.sendMessage(
        0,
        network.mojom.SSLConfigClient_OnSSLConfigUpdated_ParamsSpec.$,
        null,
        [
          sslConfig
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SSLConfigClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.SSLConfigClientReceiver = class {
  /**
   * @param {!network.mojom.SSLConfigClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.SSLConfigClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.SSLConfigClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SSLConfigClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.SSLConfigClient_OnSSLConfigUpdated_ParamsSpec.$,
        null,
        impl.onSSLConfigUpdated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.SSLConfigClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SSLConfigClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.SSLConfigClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.SSLConfigClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SSLConfigClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.SSLConfigClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.SSLConfigClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SSLConfigClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSSLConfigUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.SSLConfigClient_OnSSLConfigUpdated_ParamsSpec.$,
        null,
        this.onSSLConfigUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.SSLConfigSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SSLConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SSLConfigClient_OnSSLConfigUpdated_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SSLConfigClient_OnSSLConfigUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.SSLConfigSpec.$,
    'SSLConfig',
    [
      mojo.internal.StructField(
        'revCheckingEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'revCheckingRequiredLocalAnchors', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sha1LocalAnchorsEnabled', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'versionMin', 4,
        0,
        network.mojom.SSLVersionSpec.$,
        network.mojom.SSLVersion.kTLS12,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'versionMax', 8,
        0,
        network.mojom.SSLVersionSpec.$,
        network.mojom.SSLVersion.kTLS13,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disabledCipherSuites', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint16, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tls13CipherPreferAes256', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientCertPoolingPolicy', 24,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'namedGroupsPreset', 12,
        0,
        network.mojom.SSLNamedGroupsPresetSpec.$,
        network.mojom.SSLNamedGroupsPreset.kDefault,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'postQuantumKeyAgreementEnabled', 0,
        4,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'echEnabled', 0,
        5,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustAnchorIds', 32,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('network.mojom.SSLConfig');

/** @record */
network.mojom.SSLConfig = class {
  constructor() {
    /** @export { !boolean } */
    this.revCheckingEnabled;
    /** @export { !boolean } */
    this.revCheckingRequiredLocalAnchors;
    /** @export { !boolean } */
    this.sha1LocalAnchorsEnabled;
    /** @export { !network.mojom.SSLVersion } */
    this.versionMin;
    /** @export { !network.mojom.SSLVersion } */
    this.versionMax;
    /** @export { !Array<!number> } */
    this.disabledCipherSuites;
    /** @export { !boolean } */
    this.tls13CipherPreferAes256;
    /** @export { !Array<!string> } */
    this.clientCertPoolingPolicy;
    /** @export { !network.mojom.SSLNamedGroupsPreset } */
    this.namedGroupsPreset;
    /** @export { !boolean } */
    this.postQuantumKeyAgreementEnabled;
    /** @export { !boolean } */
    this.echEnabled;
    /** @export { !Array<!Array<!number>> } */
    this.trustAnchorIds;
  }
};



mojo.internal.Struct(
    network.mojom.SSLConfigClient_OnSSLConfigUpdated_ParamsSpec.$,
    'SSLConfigClient_OnSSLConfigUpdated_Params',
    [
      mojo.internal.StructField(
        'sslConfig', 0,
        0,
        network.mojom.SSLConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SSLConfigClient_OnSSLConfigUpdated_Params');

/** @record */
network.mojom.SSLConfigClient_OnSSLConfigUpdated_Params = class {
  constructor() {
    /** @export { !network.mojom.SSLConfig } */
    this.sslConfig;
  }
};

