// services/network/public/mojom/supports_loading_mode.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/supports_loading_mode.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');


  var LoadingMode = {};
  LoadingMode.kDefault = 0;
  LoadingMode.kUncredentialedPrefetch = 1;
  LoadingMode.kUncredentialedPrerender = 2;
  LoadingMode.kCredentialedPrerender = 3;
  LoadingMode.kFencedFrame = 4;
  LoadingMode.kPrerenderCrossOriginFrames = 5;
  LoadingMode.MIN_VALUE = 0;
  LoadingMode.MAX_VALUE = 5;

  LoadingMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  LoadingMode.toKnownEnumValue = function(value) {
    return value;
  };

  LoadingMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SupportsLoadingMode(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SupportsLoadingMode.prototype.initDefaults_ = function() {
    this.supportedModes = null;
  };
  SupportsLoadingMode.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SupportsLoadingMode.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SupportsLoadingMode.supportedModes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(LoadingMode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SupportsLoadingMode.encodedSize = codec.kStructHeaderSize + 8;

  SupportsLoadingMode.decode = function(decoder) {
    var packed;
    var val = new SupportsLoadingMode();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.supportedModes =
        decoder.decodeArrayPointer(new codec.Enum(LoadingMode));
    return val;
  };

  SupportsLoadingMode.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SupportsLoadingMode.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(LoadingMode), val.supportedModes);
  };
  exports.LoadingMode = LoadingMode;
  exports.SupportsLoadingMode = SupportsLoadingMode;
})();