// services/network/public/mojom/tls_socket.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.SSLVersion');






goog.provide('network.mojom.TLSClientSocket');
goog.provide('network.mojom.TLSClientSocketReceiver');
goog.provide('network.mojom.TLSClientSocketCallbackRouter');
goog.provide('network.mojom.TLSClientSocketInterface');
goog.provide('network.mojom.TLSClientSocketRemote');
goog.provide('network.mojom.TLSClientSocketPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.TLSClientSocketPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.TLSClientSocket.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.TLSClientSocketInterface = class {
};

/**
 * @export
 * @implements { network.mojom.TLSClientSocketInterface }
 */
network.mojom.TLSClientSocketRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.TLSClientSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.TLSClientSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.TLSClientSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
};

/**
 * An object which receives request messages for the TLSClientSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.TLSClientSocketReceiver = class {
  /**
   * @param {!network.mojom.TLSClientSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.TLSClientSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.TLSClientSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TLSClientSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.TLSClientSocket = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TLSClientSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.TLSClientSocketRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.TLSClientSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TLSClientSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.TLSClientSocketCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.TLSClientSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TLSClientSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.TLSClientSocketOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TLSClientSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.TLSClientSocketOptionsSpec.$,
    'TLSClientSocketOptions',
    [
      mojo.internal.StructField(
        'versionMin', 0,
        0,
        network.mojom.SSLVersionSpec.$,
        network.mojom.SSLVersion.kTLS12,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'versionMax', 4,
        0,
        network.mojom.SSLVersionSpec.$,
        network.mojom.SSLVersion.kTLS13,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sendSslInfo', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unsafelySkipCertVerification', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.TLSClientSocketOptions');

/** @record */
network.mojom.TLSClientSocketOptions = class {
  constructor() {
    /** @export { !network.mojom.SSLVersion } */
    this.versionMin;
    /** @export { !network.mojom.SSLVersion } */
    this.versionMax;
    /** @export { !boolean } */
    this.sendSslInfo;
    /** @export { !boolean } */
    this.unsafelySkipCertVerification;
  }
};

