// services/network/public/mojom/url_loader_factory.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  MutableNetworkTrafficAnnotationTag as network_mojom_MutableNetworkTrafficAnnotationTag,
  MutableNetworkTrafficAnnotationTagSpec as network_mojom_MutableNetworkTrafficAnnotationTagSpec
} from './mutable_network_traffic_annotation_tag.mojom.m.js';

import {
  URLLoaderRemote as network_mojom_URLLoaderRemote,
  URLLoaderPendingReceiver as network_mojom_URLLoaderPendingReceiver,
  URLLoaderClientRemote as network_mojom_URLLoaderClientRemote,
  URLLoaderClientPendingReceiver as network_mojom_URLLoaderClientPendingReceiver
} from './url_loader.mojom.m.js';

import {
  URLRequest as network_mojom_URLRequest,
  URLRequestSpec as network_mojom_URLRequestSpec
} from './url_request.mojom.m.js';


/**
 * @const { !number }
 */
export const URL_LOAD_OPTION_NONE = 0;


/**
 * @const { !number }
 */
export const URL_LOAD_OPTION_SEND_SSL_INFO_WITH_RESPONSE = 1;


/**
 * @const { !number }
 */
export const URL_LOAD_OPTION_SNIFF_MIME_TYPE = 2;


/**
 * @const { !number }
 */
export const URL_LOAD_OPTION_SYNCHRONOUS = 4;


/**
 * @const { !number }
 */
export const URL_LOAD_OPTION_SEND_SSL_INFO_FOR_CERTIFICATE_ERROR = 8;


/**
 * @const { !number }
 */
export const URL_LOAD_OPTION_USE_HEADER_CLIENT = 16;


/**
 * @const { !number }
 */
export const URL_LOAD_OPTION_BLOCK_ALL_COOKIES = 32;


/**
 * @const { !number }
 */
export const URL_LOAD_OPTION_BLOCK_THIRD_PARTY_COOKIES = 64;


/**
 * @const { !number }
 */
export const URL_LOAD_OPTION_AS_CORS_PREFLIGHT = 128;


/**
 * @const { !number }
 */
export const URL_LOAD_OPTION_BLOCK_LOCAL_REQUEST = 256;


/**
 * @const { !number }
 */
export const URL_LOAD_OPTION_READ_AND_DISCARD_BODY = 512;




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class URLLoaderFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.URLLoaderFactory', scope);
  }
}

/** @interface */
export class URLLoaderFactoryInterface {
  
  /**
   * @param { !network_mojom_URLLoaderPendingReceiver } loader
   * @param { !number } requestId
   * @param { !number } options
   * @param { !network_mojom_URLRequest } request
   * @param { !network_mojom_URLLoaderClientRemote } client
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   */

  createLoaderAndStart(loader, requestId, options, request, client, trafficAnnotation) {}
  
  /**
   * @param { !URLLoaderFactoryPendingReceiver } factory
   */

  clone(factory) {}
}

/**
 * @implements { URLLoaderFactoryInterface }
 */
export class URLLoaderFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!URLLoaderFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          URLLoaderFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!URLLoaderFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_URLLoaderPendingReceiver } loader
   * @param { !number } requestId
   * @param { !number } options
   * @param { !network_mojom_URLRequest } request
   * @param { !network_mojom_URLLoaderClientRemote } client
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   */

  createLoaderAndStart(
      loader,
      requestId,
      options,
      request,
      client,
      trafficAnnotation) {
    this.proxy.sendMessage(
        0,
        URLLoaderFactory_CreateLoaderAndStart_ParamsSpec.$,
        null,
        [
          loader,
          requestId,
          options,
          request,
          client,
          trafficAnnotation
        ],
        false);
  }

  
  /**
   * @param { !URLLoaderFactoryPendingReceiver } factory
   */

  clone(
      factory) {
    this.proxy.sendMessage(
        1,
        URLLoaderFactory_Clone_ParamsSpec.$,
        null,
        [
          factory
        ],
        false);
  }
}

/**
 * An object which receives request messages for the URLLoaderFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class URLLoaderFactoryReceiver {
  /**
   * @param {!URLLoaderFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!URLLoaderFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        URLLoaderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!URLLoaderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        URLLoaderFactory_CreateLoaderAndStart_ParamsSpec.$,
        null,
        impl.createLoaderAndStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        URLLoaderFactory_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class URLLoaderFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.URLLoaderFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!URLLoaderFactoryRemote}
   */
  static getRemote() {
    let remote = new URLLoaderFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the URLLoaderFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class URLLoaderFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      URLLoaderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!URLLoaderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createLoaderAndStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        URLLoaderFactory_CreateLoaderAndStart_ParamsSpec.$,
        null,
        this.createLoaderAndStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        URLLoaderFactory_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderFactory_CreateLoaderAndStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderFactory_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    URLLoaderFactory_CreateLoaderAndStart_ParamsSpec.$,
    'URLLoaderFactory_CreateLoaderAndStart_Params',
    [
      mojo.internal.StructField(
        'loader', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_URLLoaderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'request', 16,
        0,
        network_mojom_URLRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 24,
        0,
        mojo.internal.InterfaceProxy(network_mojom_URLLoaderClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 32,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class URLLoaderFactory_CreateLoaderAndStart_Params {
  constructor() {
    /** @type { !network_mojom_URLLoaderPendingReceiver } */
    this.loader;
    /** @type { !number } */
    this.requestId;
    /** @type { !number } */
    this.options;
    /** @type { !network_mojom_URLRequest } */
    this.request;
    /** @type { !network_mojom_URLLoaderClientRemote } */
    this.client;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
  }
}



mojo.internal.Struct(
    URLLoaderFactory_Clone_ParamsSpec.$,
    'URLLoaderFactory_Clone_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.InterfaceRequest(URLLoaderFactoryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class URLLoaderFactory_Clone_Params {
  constructor() {
    /** @type { !URLLoaderFactoryPendingReceiver } */
    this.factory;
  }
}

