// services/network/public/mojom/web_bundle_handle.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebBundleErrorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebBundleErrorType = {
  
  kMetadataParseError: 0,
  kResponseParseError: 1,
  kResourceNotFound: 2,
  kMemoryQuotaExceeded: 3,
  kServingConstraintsNotMet: 4,
  kWebBundleFetchFailed: 5,
  kWebBundleRedirected: 6,
  kDeprecationWarning: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebBundleHandlePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.WebBundleHandle', scope);
  }
}

/** @interface */
export class WebBundleHandleInterface {
  
  /**
   * @param { !WebBundleHandlePendingReceiver } receiver
   */

  clone(receiver) {}
  
  /**
   * @param { !WebBundleErrorType } type
   * @param { !string } message
   */

  onWebBundleError(type, message) {}
  
  /**
   * @param { !boolean } success
   */

  onWebBundleLoadFinished(success) {}
}

/**
 * @implements { WebBundleHandleInterface }
 */
export class WebBundleHandleRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebBundleHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebBundleHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebBundleHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !WebBundleHandlePendingReceiver } receiver
   */

  clone(
      receiver) {
    this.proxy.sendMessage(
        0,
        WebBundleHandle_Clone_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !WebBundleErrorType } type
   * @param { !string } message
   */

  onWebBundleError(
      type,
      message) {
    this.proxy.sendMessage(
        1,
        WebBundleHandle_OnWebBundleError_ParamsSpec.$,
        null,
        [
          type,
          message
        ],
        false);
  }

  
  /**
   * @param { !boolean } success
   */

  onWebBundleLoadFinished(
      success) {
    this.proxy.sendMessage(
        2,
        WebBundleHandle_OnWebBundleLoadFinished_ParamsSpec.$,
        null,
        [
          success
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebBundleHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebBundleHandleReceiver {
  /**
   * @param {!WebBundleHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebBundleHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebBundleHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebBundleHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebBundleHandle_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebBundleHandle_OnWebBundleError_ParamsSpec.$,
        null,
        impl.onWebBundleError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WebBundleHandle_OnWebBundleLoadFinished_ParamsSpec.$,
        null,
        impl.onWebBundleLoadFinished.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebBundleHandle {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebBundleHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebBundleHandleRemote}
   */
  static getRemote() {
    let remote = new WebBundleHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebBundleHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebBundleHandleCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebBundleHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebBundleHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebBundleHandle_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWebBundleError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebBundleHandle_OnWebBundleError_ParamsSpec.$,
        null,
        this.onWebBundleError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWebBundleLoadFinished =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WebBundleHandle_OnWebBundleLoadFinished_ParamsSpec.$,
        null,
        this.onWebBundleLoadFinished.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebBundleHandle_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebBundleHandle_OnWebBundleError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebBundleHandle_OnWebBundleLoadFinished_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WebBundleHandle_Clone_ParamsSpec.$,
    'WebBundleHandle_Clone_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(WebBundleHandlePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebBundleHandle_Clone_Params {
  constructor() {
    /** @type { !WebBundleHandlePendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    WebBundleHandle_OnWebBundleError_ParamsSpec.$,
    'WebBundleHandle_OnWebBundleError_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        WebBundleErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebBundleHandle_OnWebBundleError_Params {
  constructor() {
    /** @type { !WebBundleErrorType } */
    this.type;
    /** @type { !string } */
    this.message;
  }
}



mojo.internal.Struct(
    WebBundleHandle_OnWebBundleLoadFinished_ParamsSpec.$,
    'WebBundleHandle_OnWebBundleLoadFinished_Params',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebBundleHandle_OnWebBundleLoadFinished_Params {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}

