// services/network/public/mojom/websocket.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/websocket.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', 'network_param.mojom.js');
  }
  var ip_endpoint$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_endpoint.mojom', 'ip_endpoint.mojom.js');
  }


  var WebSocketMessageType = {};
  WebSocketMessageType.CONTINUATION = 0;
  WebSocketMessageType.TEXT = 1;
  WebSocketMessageType.BINARY = 2;
  WebSocketMessageType.LAST = 2;
  WebSocketMessageType.MIN_VALUE = 0;
  WebSocketMessageType.MAX_VALUE = 2;

  WebSocketMessageType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  WebSocketMessageType.toKnownEnumValue = function(value) {
    return value;
  };

  WebSocketMessageType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function HttpHeader(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpHeader.prototype.initDefaults_ = function() {
    this.name = null;
    this.value = null;
  };
  HttpHeader.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpHeader.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpHeader.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpHeader.value
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpHeader.encodedSize = codec.kStructHeaderSize + 16;

  HttpHeader.decode = function(decoder) {
    var packed;
    var val = new HttpHeader();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.value =
        decoder.decodeStruct(codec.String);
    return val;
  };

  HttpHeader.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpHeader.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.value);
  };
  function WebSocketHandshakeRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSocketHandshakeRequest.prototype.initDefaults_ = function() {
    this.url = null;
    this.headers = null;
    this.headersText = null;
  };
  WebSocketHandshakeRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSocketHandshakeRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeRequest.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeRequest.headers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(HttpHeader), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeRequest.headersText
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebSocketHandshakeRequest.encodedSize = codec.kStructHeaderSize + 24;

  WebSocketHandshakeRequest.decode = function(decoder) {
    var packed;
    var val = new WebSocketHandshakeRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.headers =
        decoder.decodeArrayPointer(new codec.PointerTo(HttpHeader));
    val.headersText =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebSocketHandshakeRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSocketHandshakeRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeArrayPointer(new codec.PointerTo(HttpHeader), val.headers);
    encoder.encodeStruct(codec.String, val.headersText);
  };
  function WebSocketHandshakeResponse(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSocketHandshakeResponse.prototype.initDefaults_ = function() {
    this.url = null;
    this.httpVersion = null;
    this.statusCode = 0;
    this.statusText = null;
    this.remoteEndpoint = null;
    this.headers = null;
    this.headersText = null;
    this.selectedProtocol = null;
    this.extensions = null;
  };
  WebSocketHandshakeResponse.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSocketHandshakeResponse.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeResponse.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeResponse.httpVersion
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_param$.HttpVersion, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebSocketHandshakeResponse.statusText
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeResponse.remoteEndpoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, ip_endpoint$.IPEndPoint, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeResponse.headers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, new codec.PointerTo(HttpHeader), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeResponse.headersText
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 48, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeResponse.selectedProtocol
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 56, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeResponse.extensions
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 64, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebSocketHandshakeResponse.encodedSize = codec.kStructHeaderSize + 72;

  WebSocketHandshakeResponse.decode = function(decoder) {
    var packed;
    var val = new WebSocketHandshakeResponse();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.httpVersion =
        decoder.decodeStructPointer(network_param$.HttpVersion);
    val.statusCode =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.statusText =
        decoder.decodeStruct(codec.String);
    val.remoteEndpoint =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    val.headers =
        decoder.decodeArrayPointer(new codec.PointerTo(HttpHeader));
    val.headersText =
        decoder.decodeStruct(codec.String);
    val.selectedProtocol =
        decoder.decodeStruct(codec.String);
    val.extensions =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebSocketHandshakeResponse.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSocketHandshakeResponse.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(network_param$.HttpVersion, val.httpVersion);
    encoder.encodeStruct(codec.Int32, val.statusCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.statusText);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.remoteEndpoint);
    encoder.encodeArrayPointer(new codec.PointerTo(HttpHeader), val.headers);
    encoder.encodeStruct(codec.String, val.headersText);
    encoder.encodeStruct(codec.String, val.selectedProtocol);
    encoder.encodeStruct(codec.String, val.extensions);
  };
  function WebSocketAuthenticationHandler_OnAuthRequired_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSocketAuthenticationHandler_OnAuthRequired_Params.prototype.initDefaults_ = function() {
    this.info = null;
    this.headers = null;
    this.remoteEndpoint = null;
  };
  WebSocketAuthenticationHandler_OnAuthRequired_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSocketAuthenticationHandler_OnAuthRequired_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketAuthenticationHandler_OnAuthRequired_Params.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.AuthChallengeInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketAuthenticationHandler_OnAuthRequired_Params.headers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_param$.HttpResponseHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketAuthenticationHandler_OnAuthRequired_Params.remoteEndpoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, ip_endpoint$.IPEndPoint, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebSocketAuthenticationHandler_OnAuthRequired_Params.encodedSize = codec.kStructHeaderSize + 24;

  WebSocketAuthenticationHandler_OnAuthRequired_Params.decode = function(decoder) {
    var packed;
    var val = new WebSocketAuthenticationHandler_OnAuthRequired_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(network_param$.AuthChallengeInfo);
    val.headers =
        decoder.decodeStructPointer(network_param$.HttpResponseHeaders);
    val.remoteEndpoint =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    return val;
  };

  WebSocketAuthenticationHandler_OnAuthRequired_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSocketAuthenticationHandler_OnAuthRequired_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.AuthChallengeInfo, val.info);
    encoder.encodeStructPointer(network_param$.HttpResponseHeaders, val.headers);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.remoteEndpoint);
  };
  function WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams.prototype.initDefaults_ = function() {
    this.credentials = null;
  };
  WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams.credentials
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.AuthCredentials, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.credentials =
        decoder.decodeStructPointer(network_param$.AuthCredentials);
    return val;
  };

  WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.AuthCredentials, val.credentials);
  };
  function WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params.prototype.initDefaults_ = function() {
    this.request = null;
  };
  WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, WebSocketHandshakeRequest, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params.decode = function(decoder) {
    var packed;
    var val = new WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(WebSocketHandshakeRequest);
    return val;
  };

  WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(WebSocketHandshakeRequest, val.request);
  };
  function WebSocketHandshakeClient_OnFailure_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSocketHandshakeClient_OnFailure_Params.prototype.initDefaults_ = function() {
    this.message = null;
    this.netError = 0;
    this.responseCode = 0;
  };
  WebSocketHandshakeClient_OnFailure_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSocketHandshakeClient_OnFailure_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeClient_OnFailure_Params.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WebSocketHandshakeClient_OnFailure_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebSocketHandshakeClient_OnFailure_Params.decode = function(decoder) {
    var packed;
    var val = new WebSocketHandshakeClient_OnFailure_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.message =
        decoder.decodeStruct(codec.String);
    val.netError =
        decoder.decodeStruct(codec.Int32);
    val.responseCode =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  WebSocketHandshakeClient_OnFailure_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSocketHandshakeClient_OnFailure_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.message);
    encoder.encodeStruct(codec.Int32, val.netError);
    encoder.encodeStruct(codec.Int32, val.responseCode);
  };
  function WebSocketHandshakeClient_OnConnectionEstablished_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSocketHandshakeClient_OnConnectionEstablished_Params.prototype.initDefaults_ = function() {
    this.socket = new WebSocketPtr();
    this.clientReceiver = new bindings.InterfaceRequest();
    this.readable = null;
    this.response = null;
    this.writable = null;
  };
  WebSocketHandshakeClient_OnConnectionEstablished_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSocketHandshakeClient_OnConnectionEstablished_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeClient_OnConnectionEstablished_Params.socket
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeClient_OnConnectionEstablished_Params.clientReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeClient_OnConnectionEstablished_Params.response
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, WebSocketHandshakeResponse, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeClient_OnConnectionEstablished_Params.readable
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 12, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocketHandshakeClient_OnConnectionEstablished_Params.writable
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebSocketHandshakeClient_OnConnectionEstablished_Params.encodedSize = codec.kStructHeaderSize + 32;

  WebSocketHandshakeClient_OnConnectionEstablished_Params.decode = function(decoder) {
    var packed;
    var val = new WebSocketHandshakeClient_OnConnectionEstablished_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.socket =
        decoder.decodeStruct(new codec.Interface(WebSocketPtr));
    val.clientReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.readable =
        decoder.decodeStruct(codec.Handle);
    val.response =
        decoder.decodeStructPointer(WebSocketHandshakeResponse);
    val.writable =
        decoder.decodeStruct(codec.Handle);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebSocketHandshakeClient_OnConnectionEstablished_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSocketHandshakeClient_OnConnectionEstablished_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(WebSocketPtr), val.socket);
    encoder.encodeStruct(codec.InterfaceRequest, val.clientReceiver);
    encoder.encodeStruct(codec.Handle, val.readable);
    encoder.encodeStructPointer(WebSocketHandshakeResponse, val.response);
    encoder.encodeStruct(codec.Handle, val.writable);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebSocketClient_OnDataFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSocketClient_OnDataFrame_Params.prototype.initDefaults_ = function() {
    this.fin = false;
    this.type = 0;
    this.dataLength = 0;
  };
  WebSocketClient_OnDataFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSocketClient_OnDataFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebSocketClient_OnDataFrame_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, WebSocketMessageType);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebSocketClient_OnDataFrame_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebSocketClient_OnDataFrame_Params.decode = function(decoder) {
    var packed;
    var val = new WebSocketClient_OnDataFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.fin = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.type =
        decoder.decodeStruct(new codec.Enum(WebSocketMessageType));
    val.dataLength =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  WebSocketClient_OnDataFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSocketClient_OnDataFrame_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.fin & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Uint64, val.dataLength);
  };
  function WebSocketClient_OnDropChannel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSocketClient_OnDropChannel_Params.prototype.initDefaults_ = function() {
    this.wasClean = false;
    this.code = 0;
    this.reason = null;
  };
  WebSocketClient_OnDropChannel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSocketClient_OnDropChannel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate WebSocketClient_OnDropChannel_Params.reason
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebSocketClient_OnDropChannel_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebSocketClient_OnDropChannel_Params.decode = function(decoder) {
    var packed;
    var val = new WebSocketClient_OnDropChannel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.wasClean = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    val.code =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.reason =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebSocketClient_OnDropChannel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSocketClient_OnDropChannel_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.wasClean & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.code);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.reason);
  };
  function WebSocketClient_OnClosingHandshake_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSocketClient_OnClosingHandshake_Params.prototype.initDefaults_ = function() {
  };
  WebSocketClient_OnClosingHandshake_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSocketClient_OnClosingHandshake_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebSocketClient_OnClosingHandshake_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebSocketClient_OnClosingHandshake_Params.decode = function(decoder) {
    var packed;
    var val = new WebSocketClient_OnClosingHandshake_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebSocketClient_OnClosingHandshake_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSocketClient_OnClosingHandshake_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebSocket_SendMessage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSocket_SendMessage_Params.prototype.initDefaults_ = function() {
    this.type = 0;
    this.dataLength = 0;
  };
  WebSocket_SendMessage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSocket_SendMessage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSocket_SendMessage_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, WebSocketMessageType);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebSocket_SendMessage_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebSocket_SendMessage_Params.decode = function(decoder) {
    var packed;
    var val = new WebSocket_SendMessage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(WebSocketMessageType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.dataLength =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  WebSocket_SendMessage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSocket_SendMessage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint64, val.dataLength);
  };
  function WebSocket_StartReceiving_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSocket_StartReceiving_Params.prototype.initDefaults_ = function() {
  };
  WebSocket_StartReceiving_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSocket_StartReceiving_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebSocket_StartReceiving_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebSocket_StartReceiving_Params.decode = function(decoder) {
    var packed;
    var val = new WebSocket_StartReceiving_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebSocket_StartReceiving_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSocket_StartReceiving_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebSocket_StartClosingHandshake_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSocket_StartClosingHandshake_Params.prototype.initDefaults_ = function() {
    this.code = 0;
    this.reason = null;
  };
  WebSocket_StartClosingHandshake_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSocket_StartClosingHandshake_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebSocket_StartClosingHandshake_Params.reason
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebSocket_StartClosingHandshake_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebSocket_StartClosingHandshake_Params.decode = function(decoder) {
    var packed;
    var val = new WebSocket_StartClosingHandshake_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.reason =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebSocket_StartClosingHandshake_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSocket_StartClosingHandshake_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint16, val.code);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.reason);
  };
  var kWebSocketAuthenticationHandler_OnAuthRequired_Name = 0;

  function WebSocketAuthenticationHandlerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebSocketAuthenticationHandler,
                                                   handleOrPtrInfo);
  }

  function WebSocketAuthenticationHandlerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebSocketAuthenticationHandler, associatedInterfacePtrInfo);
  }

  WebSocketAuthenticationHandlerAssociatedPtr.prototype =
      Object.create(WebSocketAuthenticationHandlerPtr.prototype);
  WebSocketAuthenticationHandlerAssociatedPtr.prototype.constructor =
      WebSocketAuthenticationHandlerAssociatedPtr;

  function WebSocketAuthenticationHandlerProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebSocketAuthenticationHandlerPtr.prototype.onAuthRequired = function() {
    return WebSocketAuthenticationHandlerProxy.prototype.onAuthRequired
        .apply(this.ptr.getProxy(), arguments);
  };

  WebSocketAuthenticationHandlerProxy.prototype.onAuthRequired = function(info, headers, remoteEndpoint) {
    var params_ = new WebSocketAuthenticationHandler_OnAuthRequired_Params();
    params_.info = info;
    params_.headers = headers;
    params_.remoteEndpoint = remoteEndpoint;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebSocketAuthenticationHandler_OnAuthRequired_Name,
          codec.align(WebSocketAuthenticationHandler_OnAuthRequired_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebSocketAuthenticationHandler_OnAuthRequired_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function WebSocketAuthenticationHandlerStub(delegate) {
    this.delegate_ = delegate;
  }
  WebSocketAuthenticationHandlerStub.prototype.onAuthRequired = function(info, headers, remoteEndpoint) {
    return this.delegate_ && this.delegate_.onAuthRequired && this.delegate_.onAuthRequired(info, headers, remoteEndpoint);
  }

  WebSocketAuthenticationHandlerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  WebSocketAuthenticationHandlerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebSocketAuthenticationHandler_OnAuthRequired_Name:
      var params = reader.decodeStruct(WebSocketAuthenticationHandler_OnAuthRequired_Params);
      this.onAuthRequired(params.info, params.headers, params.remoteEndpoint).then(function(response) {
        var responseParams =
            new WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams();
        responseParams.credentials = response.credentials;
        var builder = new codec.MessageV1Builder(
            kWebSocketAuthenticationHandler_OnAuthRequired_Name,
            codec.align(WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWebSocketAuthenticationHandlerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebSocketAuthenticationHandler_OnAuthRequired_Name:
        if (message.expectsResponse())
          paramsClass = WebSocketAuthenticationHandler_OnAuthRequired_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebSocketAuthenticationHandlerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWebSocketAuthenticationHandler_OnAuthRequired_Name:
        if (message.isResponse())
          paramsClass = WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var WebSocketAuthenticationHandler = {
    name: 'network.mojom.WebSocketAuthenticationHandler',
    kVersion: 0,
    ptrClass: WebSocketAuthenticationHandlerPtr,
    proxyClass: WebSocketAuthenticationHandlerProxy,
    stubClass: WebSocketAuthenticationHandlerStub,
    validateRequest: validateWebSocketAuthenticationHandlerRequest,
    validateResponse: validateWebSocketAuthenticationHandlerResponse,
  };
  WebSocketAuthenticationHandlerStub.prototype.validator = validateWebSocketAuthenticationHandlerRequest;
  WebSocketAuthenticationHandlerProxy.prototype.validator = validateWebSocketAuthenticationHandlerResponse;
  var kWebSocketHandshakeClient_OnOpeningHandshakeStarted_Name = 0;
  var kWebSocketHandshakeClient_OnFailure_Name = 1;
  var kWebSocketHandshakeClient_OnConnectionEstablished_Name = 2;

  function WebSocketHandshakeClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebSocketHandshakeClient,
                                                   handleOrPtrInfo);
  }

  function WebSocketHandshakeClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebSocketHandshakeClient, associatedInterfacePtrInfo);
  }

  WebSocketHandshakeClientAssociatedPtr.prototype =
      Object.create(WebSocketHandshakeClientPtr.prototype);
  WebSocketHandshakeClientAssociatedPtr.prototype.constructor =
      WebSocketHandshakeClientAssociatedPtr;

  function WebSocketHandshakeClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebSocketHandshakeClientPtr.prototype.onOpeningHandshakeStarted = function() {
    return WebSocketHandshakeClientProxy.prototype.onOpeningHandshakeStarted
        .apply(this.ptr.getProxy(), arguments);
  };

  WebSocketHandshakeClientProxy.prototype.onOpeningHandshakeStarted = function(request) {
    var params_ = new WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params();
    params_.request = request;
    var builder = new codec.MessageV0Builder(
        kWebSocketHandshakeClient_OnOpeningHandshakeStarted_Name,
        codec.align(WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params.encodedSize));
    builder.encodeStruct(WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebSocketHandshakeClientPtr.prototype.onFailure = function() {
    return WebSocketHandshakeClientProxy.prototype.onFailure
        .apply(this.ptr.getProxy(), arguments);
  };

  WebSocketHandshakeClientProxy.prototype.onFailure = function(message, netError, responseCode) {
    var params_ = new WebSocketHandshakeClient_OnFailure_Params();
    params_.message = message;
    params_.netError = netError;
    params_.responseCode = responseCode;
    var builder = new codec.MessageV0Builder(
        kWebSocketHandshakeClient_OnFailure_Name,
        codec.align(WebSocketHandshakeClient_OnFailure_Params.encodedSize));
    builder.encodeStruct(WebSocketHandshakeClient_OnFailure_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebSocketHandshakeClientPtr.prototype.onConnectionEstablished = function() {
    return WebSocketHandshakeClientProxy.prototype.onConnectionEstablished
        .apply(this.ptr.getProxy(), arguments);
  };

  WebSocketHandshakeClientProxy.prototype.onConnectionEstablished = function(socket, clientReceiver, response, readable, writable) {
    var params_ = new WebSocketHandshakeClient_OnConnectionEstablished_Params();
    params_.socket = socket;
    params_.clientReceiver = clientReceiver;
    params_.response = response;
    params_.readable = readable;
    params_.writable = writable;
    var builder = new codec.MessageV0Builder(
        kWebSocketHandshakeClient_OnConnectionEstablished_Name,
        codec.align(WebSocketHandshakeClient_OnConnectionEstablished_Params.encodedSize));
    builder.encodeStruct(WebSocketHandshakeClient_OnConnectionEstablished_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebSocketHandshakeClientStub(delegate) {
    this.delegate_ = delegate;
  }
  WebSocketHandshakeClientStub.prototype.onOpeningHandshakeStarted = function(request) {
    return this.delegate_ && this.delegate_.onOpeningHandshakeStarted && this.delegate_.onOpeningHandshakeStarted(request);
  }
  WebSocketHandshakeClientStub.prototype.onFailure = function(message, netError, responseCode) {
    return this.delegate_ && this.delegate_.onFailure && this.delegate_.onFailure(message, netError, responseCode);
  }
  WebSocketHandshakeClientStub.prototype.onConnectionEstablished = function(socket, clientReceiver, response, readable, writable) {
    return this.delegate_ && this.delegate_.onConnectionEstablished && this.delegate_.onConnectionEstablished(socket, clientReceiver, response, readable, writable);
  }

  WebSocketHandshakeClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebSocketHandshakeClient_OnOpeningHandshakeStarted_Name:
      var params = reader.decodeStruct(WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params);
      this.onOpeningHandshakeStarted(params.request);
      return true;
    case kWebSocketHandshakeClient_OnFailure_Name:
      var params = reader.decodeStruct(WebSocketHandshakeClient_OnFailure_Params);
      this.onFailure(params.message, params.netError, params.responseCode);
      return true;
    case kWebSocketHandshakeClient_OnConnectionEstablished_Name:
      var params = reader.decodeStruct(WebSocketHandshakeClient_OnConnectionEstablished_Params);
      this.onConnectionEstablished(params.socket, params.clientReceiver, params.response, params.readable, params.writable);
      return true;
    default:
      return false;
    }
  };

  WebSocketHandshakeClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateWebSocketHandshakeClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebSocketHandshakeClient_OnOpeningHandshakeStarted_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params;
      break;
      case kWebSocketHandshakeClient_OnFailure_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebSocketHandshakeClient_OnFailure_Params;
      break;
      case kWebSocketHandshakeClient_OnConnectionEstablished_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebSocketHandshakeClient_OnConnectionEstablished_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebSocketHandshakeClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var WebSocketHandshakeClient = {
    name: 'network.mojom.WebSocketHandshakeClient',
    kVersion: 0,
    ptrClass: WebSocketHandshakeClientPtr,
    proxyClass: WebSocketHandshakeClientProxy,
    stubClass: WebSocketHandshakeClientStub,
    validateRequest: validateWebSocketHandshakeClientRequest,
    validateResponse: null,
  };
  WebSocketHandshakeClientStub.prototype.validator = validateWebSocketHandshakeClientRequest;
  WebSocketHandshakeClientProxy.prototype.validator = null;
  var kWebSocketClient_OnDataFrame_Name = 0;
  var kWebSocketClient_OnDropChannel_Name = 1;
  var kWebSocketClient_OnClosingHandshake_Name = 2;

  function WebSocketClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebSocketClient,
                                                   handleOrPtrInfo);
  }

  function WebSocketClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebSocketClient, associatedInterfacePtrInfo);
  }

  WebSocketClientAssociatedPtr.prototype =
      Object.create(WebSocketClientPtr.prototype);
  WebSocketClientAssociatedPtr.prototype.constructor =
      WebSocketClientAssociatedPtr;

  function WebSocketClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebSocketClientPtr.prototype.onDataFrame = function() {
    return WebSocketClientProxy.prototype.onDataFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  WebSocketClientProxy.prototype.onDataFrame = function(fin, type, dataLength) {
    var params_ = new WebSocketClient_OnDataFrame_Params();
    params_.fin = fin;
    params_.type = type;
    params_.dataLength = dataLength;
    var builder = new codec.MessageV0Builder(
        kWebSocketClient_OnDataFrame_Name,
        codec.align(WebSocketClient_OnDataFrame_Params.encodedSize));
    builder.encodeStruct(WebSocketClient_OnDataFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebSocketClientPtr.prototype.onDropChannel = function() {
    return WebSocketClientProxy.prototype.onDropChannel
        .apply(this.ptr.getProxy(), arguments);
  };

  WebSocketClientProxy.prototype.onDropChannel = function(wasClean, code, reason) {
    var params_ = new WebSocketClient_OnDropChannel_Params();
    params_.wasClean = wasClean;
    params_.code = code;
    params_.reason = reason;
    var builder = new codec.MessageV0Builder(
        kWebSocketClient_OnDropChannel_Name,
        codec.align(WebSocketClient_OnDropChannel_Params.encodedSize));
    builder.encodeStruct(WebSocketClient_OnDropChannel_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebSocketClientPtr.prototype.onClosingHandshake = function() {
    return WebSocketClientProxy.prototype.onClosingHandshake
        .apply(this.ptr.getProxy(), arguments);
  };

  WebSocketClientProxy.prototype.onClosingHandshake = function() {
    var params_ = new WebSocketClient_OnClosingHandshake_Params();
    var builder = new codec.MessageV0Builder(
        kWebSocketClient_OnClosingHandshake_Name,
        codec.align(WebSocketClient_OnClosingHandshake_Params.encodedSize));
    builder.encodeStruct(WebSocketClient_OnClosingHandshake_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebSocketClientStub(delegate) {
    this.delegate_ = delegate;
  }
  WebSocketClientStub.prototype.onDataFrame = function(fin, type, dataLength) {
    return this.delegate_ && this.delegate_.onDataFrame && this.delegate_.onDataFrame(fin, type, dataLength);
  }
  WebSocketClientStub.prototype.onDropChannel = function(wasClean, code, reason) {
    return this.delegate_ && this.delegate_.onDropChannel && this.delegate_.onDropChannel(wasClean, code, reason);
  }
  WebSocketClientStub.prototype.onClosingHandshake = function() {
    return this.delegate_ && this.delegate_.onClosingHandshake && this.delegate_.onClosingHandshake();
  }

  WebSocketClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebSocketClient_OnDataFrame_Name:
      var params = reader.decodeStruct(WebSocketClient_OnDataFrame_Params);
      this.onDataFrame(params.fin, params.type, params.dataLength);
      return true;
    case kWebSocketClient_OnDropChannel_Name:
      var params = reader.decodeStruct(WebSocketClient_OnDropChannel_Params);
      this.onDropChannel(params.wasClean, params.code, params.reason);
      return true;
    case kWebSocketClient_OnClosingHandshake_Name:
      var params = reader.decodeStruct(WebSocketClient_OnClosingHandshake_Params);
      this.onClosingHandshake();
      return true;
    default:
      return false;
    }
  };

  WebSocketClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateWebSocketClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebSocketClient_OnDataFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebSocketClient_OnDataFrame_Params;
      break;
      case kWebSocketClient_OnDropChannel_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebSocketClient_OnDropChannel_Params;
      break;
      case kWebSocketClient_OnClosingHandshake_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebSocketClient_OnClosingHandshake_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebSocketClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var WebSocketClient = {
    name: 'network.mojom.WebSocketClient',
    kVersion: 0,
    ptrClass: WebSocketClientPtr,
    proxyClass: WebSocketClientProxy,
    stubClass: WebSocketClientStub,
    validateRequest: validateWebSocketClientRequest,
    validateResponse: null,
  };
  WebSocketClientStub.prototype.validator = validateWebSocketClientRequest;
  WebSocketClientProxy.prototype.validator = null;
  var kWebSocket_SendMessage_Name = 0;
  var kWebSocket_StartReceiving_Name = 1;
  var kWebSocket_StartClosingHandshake_Name = 2;

  function WebSocketPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebSocket,
                                                   handleOrPtrInfo);
  }

  function WebSocketAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebSocket, associatedInterfacePtrInfo);
  }

  WebSocketAssociatedPtr.prototype =
      Object.create(WebSocketPtr.prototype);
  WebSocketAssociatedPtr.prototype.constructor =
      WebSocketAssociatedPtr;

  function WebSocketProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebSocketPtr.prototype.sendMessage = function() {
    return WebSocketProxy.prototype.sendMessage
        .apply(this.ptr.getProxy(), arguments);
  };

  WebSocketProxy.prototype.sendMessage = function(type, dataLength) {
    var params_ = new WebSocket_SendMessage_Params();
    params_.type = type;
    params_.dataLength = dataLength;
    var builder = new codec.MessageV0Builder(
        kWebSocket_SendMessage_Name,
        codec.align(WebSocket_SendMessage_Params.encodedSize));
    builder.encodeStruct(WebSocket_SendMessage_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebSocketPtr.prototype.startReceiving = function() {
    return WebSocketProxy.prototype.startReceiving
        .apply(this.ptr.getProxy(), arguments);
  };

  WebSocketProxy.prototype.startReceiving = function() {
    var params_ = new WebSocket_StartReceiving_Params();
    var builder = new codec.MessageV0Builder(
        kWebSocket_StartReceiving_Name,
        codec.align(WebSocket_StartReceiving_Params.encodedSize));
    builder.encodeStruct(WebSocket_StartReceiving_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebSocketPtr.prototype.startClosingHandshake = function() {
    return WebSocketProxy.prototype.startClosingHandshake
        .apply(this.ptr.getProxy(), arguments);
  };

  WebSocketProxy.prototype.startClosingHandshake = function(code, reason) {
    var params_ = new WebSocket_StartClosingHandshake_Params();
    params_.code = code;
    params_.reason = reason;
    var builder = new codec.MessageV0Builder(
        kWebSocket_StartClosingHandshake_Name,
        codec.align(WebSocket_StartClosingHandshake_Params.encodedSize));
    builder.encodeStruct(WebSocket_StartClosingHandshake_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebSocketStub(delegate) {
    this.delegate_ = delegate;
  }
  WebSocketStub.prototype.sendMessage = function(type, dataLength) {
    return this.delegate_ && this.delegate_.sendMessage && this.delegate_.sendMessage(type, dataLength);
  }
  WebSocketStub.prototype.startReceiving = function() {
    return this.delegate_ && this.delegate_.startReceiving && this.delegate_.startReceiving();
  }
  WebSocketStub.prototype.startClosingHandshake = function(code, reason) {
    return this.delegate_ && this.delegate_.startClosingHandshake && this.delegate_.startClosingHandshake(code, reason);
  }

  WebSocketStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebSocket_SendMessage_Name:
      var params = reader.decodeStruct(WebSocket_SendMessage_Params);
      this.sendMessage(params.type, params.dataLength);
      return true;
    case kWebSocket_StartReceiving_Name:
      var params = reader.decodeStruct(WebSocket_StartReceiving_Params);
      this.startReceiving();
      return true;
    case kWebSocket_StartClosingHandshake_Name:
      var params = reader.decodeStruct(WebSocket_StartClosingHandshake_Params);
      this.startClosingHandshake(params.code, params.reason);
      return true;
    default:
      return false;
    }
  };

  WebSocketStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateWebSocketRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebSocket_SendMessage_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebSocket_SendMessage_Params;
      break;
      case kWebSocket_StartReceiving_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebSocket_StartReceiving_Params;
      break;
      case kWebSocket_StartClosingHandshake_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebSocket_StartClosingHandshake_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebSocketResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var WebSocket = {
    name: 'network.mojom.WebSocket',
    kVersion: 0,
    ptrClass: WebSocketPtr,
    proxyClass: WebSocketProxy,
    stubClass: WebSocketStub,
    validateRequest: validateWebSocketRequest,
    validateResponse: null,
  };
  WebSocketStub.prototype.validator = validateWebSocketRequest;
  WebSocketProxy.prototype.validator = null;
  exports.WebSocketMessageType = WebSocketMessageType;
  exports.HttpHeader = HttpHeader;
  exports.WebSocketHandshakeRequest = WebSocketHandshakeRequest;
  exports.WebSocketHandshakeResponse = WebSocketHandshakeResponse;
  exports.WebSocketAuthenticationHandler = WebSocketAuthenticationHandler;
  exports.WebSocketAuthenticationHandlerPtr = WebSocketAuthenticationHandlerPtr;
  exports.WebSocketAuthenticationHandlerAssociatedPtr = WebSocketAuthenticationHandlerAssociatedPtr;
  exports.WebSocketHandshakeClient = WebSocketHandshakeClient;
  exports.WebSocketHandshakeClientPtr = WebSocketHandshakeClientPtr;
  exports.WebSocketHandshakeClientAssociatedPtr = WebSocketHandshakeClientAssociatedPtr;
  exports.WebSocketClient = WebSocketClient;
  exports.WebSocketClientPtr = WebSocketClientPtr;
  exports.WebSocketClientAssociatedPtr = WebSocketClientAssociatedPtr;
  exports.WebSocket = WebSocket;
  exports.WebSocketPtr = WebSocketPtr;
  exports.WebSocketAssociatedPtr = WebSocketAssociatedPtr;
})();