// services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('memoryInstrumentation.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
memoryInstrumentation.mojom.DumpTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
memoryInstrumentation.mojom.DumpType = {
  
  PERIODIC_INTERVAL: 0,
  EXPLICITLY_TRIGGERED: 1,
  SUMMARY_ONLY: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
memoryInstrumentation.mojom.LevelOfDetailSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
memoryInstrumentation.mojom.LevelOfDetail = {
  
  BACKGROUND: 0,
  LIGHT: 1,
  DETAILED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
memoryInstrumentation.mojom.DeterminismSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
memoryInstrumentation.mojom.Determinism = {
  
  NONE: 0,
  FORCE_GC: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
memoryInstrumentation.mojom.ProcessTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
memoryInstrumentation.mojom.ProcessType = {
  
  OTHER: 0,
  BROWSER: 1,
  RENDERER: 2,
  GPU: 3,
  UTILITY: 4,
  PLUGIN: 5,
  ARC: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
memoryInstrumentation.mojom.MemoryMapOptionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
memoryInstrumentation.mojom.MemoryMapOption = {
  
  NONE: 0,
  MODULES: 1,
  FULL: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
memoryInstrumentation.mojom.MemDumpFlagsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
memoryInstrumentation.mojom.MemDumpFlags = {
  
  MEM_DUMP_COUNT_MAPPINGS: 0,
  MEM_DUMP_PSS: 1,
  MEM_DUMP_PAGES_BITMAP: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
memoryInstrumentation.mojom.RequestOutcomeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
memoryInstrumentation.mojom.RequestOutcome = {
  
  kSuccess: 0,
  kRedundant: 1,
  kFillOsMemoryDumpFailed: 2,
  kFillProcessMemoryMapsFailed: 3,
  kNullPid: 4,
  kProcessNotFound: 5,
  kInvalidTracingState: 6,
  kProcessUnregistered: 7,
  kTimeout: 8,
  kInProcessMemoryDumpFailed: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
memoryInstrumentation.mojom.ClientProcessPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        memoryInstrumentation.mojom.ClientProcess.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { memoryInstrumentation.mojom.ClientProcessInterface }
 */
memoryInstrumentation.mojom.ClientProcessRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!memoryInstrumentation.mojom.ClientProcessPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          memoryInstrumentation.mojom.ClientProcessPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!memoryInstrumentation.mojom.ClientProcessPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !memoryInstrumentation.mojom.RequestArgs } args
   * @return {!Promise<{
        outcome: !memoryInstrumentation.mojom.RequestOutcome,
        dumpId: !bigint,
        rawProcessMemoryDump: ?memoryInstrumentation.mojom.RawProcessMemoryDump,
   *  }>}
   */

  requestChromeMemoryDump(
      args) {
    return this.proxy.sendMessage(
        0,
        memoryInstrumentation.mojom.ClientProcess_RequestChromeMemoryDump_ParamsSpec.$,
        memoryInstrumentation.mojom.ClientProcess_RequestChromeMemoryDump_ResponseParamsSpec.$,
        [
          args
        ],
        false);
  }

  
  /**
   * @param { !memoryInstrumentation.mojom.MemoryMapOption } option
   * @param { !Array<!memoryInstrumentation.mojom.MemDumpFlags> } flags
   * @param { !Array<!mojoBase.mojom.ProcessId> } pids
   * @return {!Promise<{
        outcome: !memoryInstrumentation.mojom.RequestOutcome,
        dumps: !Map<!mojoBase.mojom.ProcessId, !memoryInstrumentation.mojom.RawOSMemDump>,
   *  }>}
   */

  requestOSMemoryDump(
      option,
      flags,
      pids) {
    return this.proxy.sendMessage(
        1,
        memoryInstrumentation.mojom.ClientProcess_RequestOSMemoryDump_ParamsSpec.$,
        memoryInstrumentation.mojom.ClientProcess_RequestOSMemoryDump_ResponseParamsSpec.$,
        [
          option,
          flags,
          pids
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ClientProcess
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
memoryInstrumentation.mojom.ClientProcessReceiver = class {
  /**
   * @param {!memoryInstrumentation.mojom.ClientProcessInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!memoryInstrumentation.mojom.ClientProcessRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        memoryInstrumentation.mojom.ClientProcessRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!memoryInstrumentation.mojom.ClientProcessRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        memoryInstrumentation.mojom.ClientProcess_RequestChromeMemoryDump_ParamsSpec.$,
        memoryInstrumentation.mojom.ClientProcess_RequestChromeMemoryDump_ResponseParamsSpec.$,
        impl.requestChromeMemoryDump.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        memoryInstrumentation.mojom.ClientProcess_RequestOSMemoryDump_ParamsSpec.$,
        memoryInstrumentation.mojom.ClientProcess_RequestOSMemoryDump_ResponseParamsSpec.$,
        impl.requestOSMemoryDump.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
memoryInstrumentation.mojom.ClientProcess = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "memory_instrumentation.mojom.ClientProcess";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!memoryInstrumentation.mojom.ClientProcessRemote}
   * @export
   */
  static getRemote() {
    let remote = new memoryInstrumentation.mojom.ClientProcessRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ClientProcess
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
memoryInstrumentation.mojom.ClientProcessCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      memoryInstrumentation.mojom.ClientProcessRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!memoryInstrumentation.mojom.ClientProcessRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestChromeMemoryDump =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        memoryInstrumentation.mojom.ClientProcess_RequestChromeMemoryDump_ParamsSpec.$,
        memoryInstrumentation.mojom.ClientProcess_RequestChromeMemoryDump_ResponseParamsSpec.$,
        this.requestChromeMemoryDump.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestOSMemoryDump =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        memoryInstrumentation.mojom.ClientProcess_RequestOSMemoryDump_ParamsSpec.$,
        memoryInstrumentation.mojom.ClientProcess_RequestOSMemoryDump_ResponseParamsSpec.$,
        this.requestOSMemoryDump.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
memoryInstrumentation.mojom.HeapProfilerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        memoryInstrumentation.mojom.HeapProfiler.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { memoryInstrumentation.mojom.HeapProfilerInterface }
 */
memoryInstrumentation.mojom.HeapProfilerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!memoryInstrumentation.mojom.HeapProfilerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          memoryInstrumentation.mojom.HeapProfilerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!memoryInstrumentation.mojom.HeapProfilerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } stripPathFromMappedFiles
   * @param { !boolean } writeProto
   * @return {!Promise<{
        results: !Array<!memoryInstrumentation.mojom.HeapProfileResult>,
   *  }>}
   */

  dumpProcessesForTracing(
      stripPathFromMappedFiles,
      writeProto) {
    return this.proxy.sendMessage(
        0,
        memoryInstrumentation.mojom.HeapProfiler_DumpProcessesForTracing_ParamsSpec.$,
        memoryInstrumentation.mojom.HeapProfiler_DumpProcessesForTracing_ResponseParamsSpec.$,
        [
          stripPathFromMappedFiles,
          writeProto
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HeapProfiler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
memoryInstrumentation.mojom.HeapProfilerReceiver = class {
  /**
   * @param {!memoryInstrumentation.mojom.HeapProfilerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!memoryInstrumentation.mojom.HeapProfilerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        memoryInstrumentation.mojom.HeapProfilerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!memoryInstrumentation.mojom.HeapProfilerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        memoryInstrumentation.mojom.HeapProfiler_DumpProcessesForTracing_ParamsSpec.$,
        memoryInstrumentation.mojom.HeapProfiler_DumpProcessesForTracing_ResponseParamsSpec.$,
        impl.dumpProcessesForTracing.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
memoryInstrumentation.mojom.HeapProfiler = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "memory_instrumentation.mojom.HeapProfiler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!memoryInstrumentation.mojom.HeapProfilerRemote}
   * @export
   */
  static getRemote() {
    let remote = new memoryInstrumentation.mojom.HeapProfilerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HeapProfiler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
memoryInstrumentation.mojom.HeapProfilerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      memoryInstrumentation.mojom.HeapProfilerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!memoryInstrumentation.mojom.HeapProfilerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dumpProcessesForTracing =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        memoryInstrumentation.mojom.HeapProfiler_DumpProcessesForTracing_ParamsSpec.$,
        memoryInstrumentation.mojom.HeapProfiler_DumpProcessesForTracing_ResponseParamsSpec.$,
        this.dumpProcessesForTracing.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
memoryInstrumentation.mojom.HeapProfilerHelperPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        memoryInstrumentation.mojom.HeapProfilerHelper.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { memoryInstrumentation.mojom.HeapProfilerHelperInterface }
 */
memoryInstrumentation.mojom.HeapProfilerHelperRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!memoryInstrumentation.mojom.HeapProfilerHelperPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          memoryInstrumentation.mojom.HeapProfilerHelperPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!memoryInstrumentation.mojom.HeapProfilerHelperPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!mojoBase.mojom.ProcessId> } pids
   * @return {!Promise<{
        vmRegions: !Map<!mojoBase.mojom.ProcessId, !Array<!memoryInstrumentation.mojom.VmRegion>>,
   *  }>}
   */

  getVmRegionsForHeapProfiler(
      pids) {
    return this.proxy.sendMessage(
        0,
        memoryInstrumentation.mojom.HeapProfilerHelper_GetVmRegionsForHeapProfiler_ParamsSpec.$,
        memoryInstrumentation.mojom.HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParamsSpec.$,
        [
          pids
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HeapProfilerHelper
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
memoryInstrumentation.mojom.HeapProfilerHelperReceiver = class {
  /**
   * @param {!memoryInstrumentation.mojom.HeapProfilerHelperInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!memoryInstrumentation.mojom.HeapProfilerHelperRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        memoryInstrumentation.mojom.HeapProfilerHelperRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!memoryInstrumentation.mojom.HeapProfilerHelperRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        memoryInstrumentation.mojom.HeapProfilerHelper_GetVmRegionsForHeapProfiler_ParamsSpec.$,
        memoryInstrumentation.mojom.HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParamsSpec.$,
        impl.getVmRegionsForHeapProfiler.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
memoryInstrumentation.mojom.HeapProfilerHelper = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "memory_instrumentation.mojom.HeapProfilerHelper";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!memoryInstrumentation.mojom.HeapProfilerHelperRemote}
   * @export
   */
  static getRemote() {
    let remote = new memoryInstrumentation.mojom.HeapProfilerHelperRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HeapProfilerHelper
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
memoryInstrumentation.mojom.HeapProfilerHelperCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      memoryInstrumentation.mojom.HeapProfilerHelperRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!memoryInstrumentation.mojom.HeapProfilerHelperRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getVmRegionsForHeapProfiler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        memoryInstrumentation.mojom.HeapProfilerHelper_GetVmRegionsForHeapProfiler_ParamsSpec.$,
        memoryInstrumentation.mojom.HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParamsSpec.$,
        this.getVmRegionsForHeapProfiler.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
memoryInstrumentation.mojom.CoordinatorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        memoryInstrumentation.mojom.Coordinator.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { memoryInstrumentation.mojom.CoordinatorInterface }
 */
memoryInstrumentation.mojom.CoordinatorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!memoryInstrumentation.mojom.CoordinatorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          memoryInstrumentation.mojom.CoordinatorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!memoryInstrumentation.mojom.CoordinatorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !memoryInstrumentation.mojom.DumpType } dumpType
   * @param { !memoryInstrumentation.mojom.LevelOfDetail } levelOfDetail
   * @param { !memoryInstrumentation.mojom.Determinism } determinism
   * @param { !Array<!string> } allocatorDumpNames
   * @return {!Promise<{
        outcome: !memoryInstrumentation.mojom.RequestOutcome,
        globalMemoryDump: ?memoryInstrumentation.mojom.GlobalMemoryDump,
   *  }>}
   */

  requestGlobalMemoryDump(
      dumpType,
      levelOfDetail,
      determinism,
      allocatorDumpNames) {
    return this.proxy.sendMessage(
        0,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDump_ParamsSpec.$,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDump_ResponseParamsSpec.$,
        [
          dumpType,
          levelOfDetail,
          determinism,
          allocatorDumpNames
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.ProcessId } pid
   * @param { !Array<!string> } allocatorDumpNames
   * @return {!Promise<{
        outcome: !memoryInstrumentation.mojom.RequestOutcome,
        globalMemoryDump: ?memoryInstrumentation.mojom.GlobalMemoryDump,
   *  }>}
   */

  requestGlobalMemoryDumpForPid(
      pid,
      allocatorDumpNames) {
    return this.proxy.sendMessage(
        1,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpForPid_ParamsSpec.$,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpForPid_ResponseParamsSpec.$,
        [
          pid,
          allocatorDumpNames
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.ProcessId } pid
   * @return {!Promise<{
        outcome: !memoryInstrumentation.mojom.RequestOutcome,
        globalMemoryDump: ?memoryInstrumentation.mojom.GlobalMemoryDump,
   *  }>}
   */

  requestPrivateMemoryFootprint(
      pid) {
    return this.proxy.sendMessage(
        2,
        memoryInstrumentation.mojom.Coordinator_RequestPrivateMemoryFootprint_ParamsSpec.$,
        memoryInstrumentation.mojom.Coordinator_RequestPrivateMemoryFootprint_ResponseParamsSpec.$,
        [
          pid
        ],
        false);
  }

  
  /**
   * @param { !memoryInstrumentation.mojom.DumpType } dumpType
   * @param { !memoryInstrumentation.mojom.LevelOfDetail } levelOfDetail
   * @param { !memoryInstrumentation.mojom.Determinism } determinism
   * @return {!Promise<{
        outcome: !memoryInstrumentation.mojom.RequestOutcome,
        dumpId: !bigint,
   *  }>}
   */

  requestGlobalMemoryDumpAndAppendToTrace(
      dumpType,
      levelOfDetail,
      determinism) {
    return this.proxy.sendMessage(
        3,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ParamsSpec.$,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParamsSpec.$,
        [
          dumpType,
          levelOfDetail,
          determinism
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Coordinator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
memoryInstrumentation.mojom.CoordinatorReceiver = class {
  /**
   * @param {!memoryInstrumentation.mojom.CoordinatorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!memoryInstrumentation.mojom.CoordinatorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        memoryInstrumentation.mojom.CoordinatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!memoryInstrumentation.mojom.CoordinatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDump_ParamsSpec.$,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDump_ResponseParamsSpec.$,
        impl.requestGlobalMemoryDump.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpForPid_ParamsSpec.$,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpForPid_ResponseParamsSpec.$,
        impl.requestGlobalMemoryDumpForPid.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        memoryInstrumentation.mojom.Coordinator_RequestPrivateMemoryFootprint_ParamsSpec.$,
        memoryInstrumentation.mojom.Coordinator_RequestPrivateMemoryFootprint_ResponseParamsSpec.$,
        impl.requestPrivateMemoryFootprint.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ParamsSpec.$,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParamsSpec.$,
        impl.requestGlobalMemoryDumpAndAppendToTrace.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
memoryInstrumentation.mojom.Coordinator = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "memory_instrumentation.mojom.Coordinator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!memoryInstrumentation.mojom.CoordinatorRemote}
   * @export
   */
  static getRemote() {
    let remote = new memoryInstrumentation.mojom.CoordinatorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Coordinator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
memoryInstrumentation.mojom.CoordinatorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      memoryInstrumentation.mojom.CoordinatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!memoryInstrumentation.mojom.CoordinatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestGlobalMemoryDump =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDump_ParamsSpec.$,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDump_ResponseParamsSpec.$,
        this.requestGlobalMemoryDump.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestGlobalMemoryDumpForPid =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpForPid_ParamsSpec.$,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpForPid_ResponseParamsSpec.$,
        this.requestGlobalMemoryDumpForPid.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPrivateMemoryFootprint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        memoryInstrumentation.mojom.Coordinator_RequestPrivateMemoryFootprint_ParamsSpec.$,
        memoryInstrumentation.mojom.Coordinator_RequestPrivateMemoryFootprint_ResponseParamsSpec.$,
        this.requestPrivateMemoryFootprint.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestGlobalMemoryDumpAndAppendToTrace =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ParamsSpec.$,
        memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParamsSpec.$,
        this.requestGlobalMemoryDumpAndAppendToTrace.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
memoryInstrumentation.mojom.CoordinatorConnectorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        memoryInstrumentation.mojom.CoordinatorConnector.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { memoryInstrumentation.mojom.CoordinatorConnectorInterface }
 */
memoryInstrumentation.mojom.CoordinatorConnectorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!memoryInstrumentation.mojom.CoordinatorConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          memoryInstrumentation.mojom.CoordinatorConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!memoryInstrumentation.mojom.CoordinatorConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !memoryInstrumentation.mojom.CoordinatorPendingReceiver } receiver
   * @param { !memoryInstrumentation.mojom.ClientProcessRemote } clientProcess
   */

  registerCoordinatorClient(
      receiver,
      clientProcess) {
    this.proxy.sendMessage(
        0,
        memoryInstrumentation.mojom.CoordinatorConnector_RegisterCoordinatorClient_ParamsSpec.$,
        null,
        [
          receiver,
          clientProcess
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CoordinatorConnector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
memoryInstrumentation.mojom.CoordinatorConnectorReceiver = class {
  /**
   * @param {!memoryInstrumentation.mojom.CoordinatorConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!memoryInstrumentation.mojom.CoordinatorConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        memoryInstrumentation.mojom.CoordinatorConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!memoryInstrumentation.mojom.CoordinatorConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        memoryInstrumentation.mojom.CoordinatorConnector_RegisterCoordinatorClient_ParamsSpec.$,
        null,
        impl.registerCoordinatorClient.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
memoryInstrumentation.mojom.CoordinatorConnector = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "memory_instrumentation.mojom.CoordinatorConnector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!memoryInstrumentation.mojom.CoordinatorConnectorRemote}
   * @export
   */
  static getRemote() {
    let remote = new memoryInstrumentation.mojom.CoordinatorConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CoordinatorConnector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
memoryInstrumentation.mojom.CoordinatorConnectorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      memoryInstrumentation.mojom.CoordinatorConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!memoryInstrumentation.mojom.CoordinatorConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerCoordinatorClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        memoryInstrumentation.mojom.CoordinatorConnector_RegisterCoordinatorClient_ParamsSpec.$,
        null,
        this.registerCoordinatorClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.RequestArgsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.RawAllocatorDumpEdgeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.RawAllocatorDumpEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.RawAllocatorDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.RawProcessMemoryDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.VmRegionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.PlatformPrivateFootprintSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.RawOSMemDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.OSMemDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.AllocatorMemDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.ProcessMemoryDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.AggregatedMetricsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.GlobalMemoryDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.HeapProfileResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.ClientProcess_RequestChromeMemoryDump_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.ClientProcess_RequestChromeMemoryDump_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.ClientProcess_RequestOSMemoryDump_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.ClientProcess_RequestOSMemoryDump_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.HeapProfiler_DumpProcessesForTracing_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.HeapProfiler_DumpProcessesForTracing_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.HeapProfilerHelper_GetVmRegionsForHeapProfiler_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDump_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDump_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpForPid_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpForPid_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.Coordinator_RequestPrivateMemoryFootprint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.Coordinator_RequestPrivateMemoryFootprint_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
memoryInstrumentation.mojom.CoordinatorConnector_RegisterCoordinatorClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
memoryInstrumentation.mojom.RawAllocatorDumpEntryValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    memoryInstrumentation.mojom.RequestArgsSpec.$,
    'RequestArgs',
    [
      mojo.internal.StructField(
        'dumpGuid', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dumpType', 8,
        0,
        memoryInstrumentation.mojom.DumpTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'levelOfDetail', 12,
        0,
        memoryInstrumentation.mojom.LevelOfDetailSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'determinism', 16,
        0,
        memoryInstrumentation.mojom.DeterminismSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
memoryInstrumentation.mojom.RequestArgs = class {
  constructor() {
    /** @export { !bigint } */
    this.dumpGuid;
    /** @export { !memoryInstrumentation.mojom.DumpType } */
    this.dumpType;
    /** @export { !memoryInstrumentation.mojom.LevelOfDetail } */
    this.levelOfDetail;
    /** @export { !memoryInstrumentation.mojom.Determinism } */
    this.determinism;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.RawAllocatorDumpEdgeSpec.$,
    'RawAllocatorDumpEdge',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetId', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'importance', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'overridable', 20,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
memoryInstrumentation.mojom.RawAllocatorDumpEdge = class {
  constructor() {
    /** @export { !bigint } */
    this.sourceId;
    /** @export { !bigint } */
    this.targetId;
    /** @export { !number } */
    this.importance;
    /** @export { !boolean } */
    this.overridable;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.RawAllocatorDumpEntrySpec.$,
    'RawAllocatorDumpEntry',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'units', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 16,
        0,
        memoryInstrumentation.mojom.RawAllocatorDumpEntryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
memoryInstrumentation.mojom.RawAllocatorDumpEntry = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.units;
    /** @export { !memoryInstrumentation.mojom.RawAllocatorDumpEntryValue } */
    this.value;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.RawAllocatorDumpSpec.$,
    'RawAllocatorDump',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'absoluteName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'weak', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'levelOfDetail', 20,
        0,
        memoryInstrumentation.mojom.LevelOfDetailSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'entries', 24,
        0,
        mojo.internal.Array(memoryInstrumentation.mojom.RawAllocatorDumpEntrySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
memoryInstrumentation.mojom.RawAllocatorDump = class {
  constructor() {
    /** @export { !bigint } */
    this.id;
    /** @export { !string } */
    this.absoluteName;
    /** @export { !boolean } */
    this.weak;
    /** @export { !memoryInstrumentation.mojom.LevelOfDetail } */
    this.levelOfDetail;
    /** @export { !Array<!memoryInstrumentation.mojom.RawAllocatorDumpEntry> } */
    this.entries;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.RawProcessMemoryDumpSpec.$,
    'RawProcessMemoryDump',
    [
      mojo.internal.StructField(
        'levelOfDetail', 0,
        0,
        memoryInstrumentation.mojom.LevelOfDetailSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allocatorDumpEdges', 8,
        0,
        mojo.internal.Array(memoryInstrumentation.mojom.RawAllocatorDumpEdgeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allocatorDumps', 16,
        0,
        mojo.internal.Array(memoryInstrumentation.mojom.RawAllocatorDumpSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
memoryInstrumentation.mojom.RawProcessMemoryDump = class {
  constructor() {
    /** @export { !memoryInstrumentation.mojom.LevelOfDetail } */
    this.levelOfDetail;
    /** @export { !Array<!memoryInstrumentation.mojom.RawAllocatorDumpEdge> } */
    this.allocatorDumpEdges;
    /** @export { !Array<!memoryInstrumentation.mojom.RawAllocatorDump> } */
    this.allocatorDumps;
  }
};

/**
 * @const { !number }
 * @export
 */
memoryInstrumentation.mojom.VmRegion_PROTECTION_FLAGS_READ =
    4;

/**
 * @const { !number }
 * @export
 */
memoryInstrumentation.mojom.VmRegion_PROTECTION_FLAGS_WRITE =
    2;

/**
 * @const { !number }
 * @export
 */
memoryInstrumentation.mojom.VmRegion_PROTECTION_FLAGS_EXEC =
    1;

/**
 * @const { !number }
 * @export
 */
memoryInstrumentation.mojom.VmRegion_PROTECTION_FLAGS_MAYSHARE =
    128;



mojo.internal.Struct(
    memoryInstrumentation.mojom.VmRegionSpec.$,
    'VmRegion',
    [
      mojo.internal.StructField(
        'startAddress', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sizeInBytes', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'moduleTimestamp', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'moduleDebugid', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'moduleDebugPath', 32,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'protectionFlags', 40,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mappedFile', 48,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'byteStatsPrivateDirtyResident', 56,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'byteStatsPrivateCleanResident', 64,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'byteStatsSharedDirtyResident', 72,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'byteStatsSharedCleanResident', 80,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'byteStatsSwapped', 88,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'byteLocked', 96,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'byteStatsProportionalResident', 104,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 120],]);





/** @record */
memoryInstrumentation.mojom.VmRegion = class {
  constructor() {
    /** @export { !bigint } */
    this.startAddress;
    /** @export { !bigint } */
    this.sizeInBytes;
    /** @export { !bigint } */
    this.moduleTimestamp;
    /** @export { !string } */
    this.moduleDebugid;
    /** @export { !string } */
    this.moduleDebugPath;
    /** @export { !number } */
    this.protectionFlags;
    /** @export { !string } */
    this.mappedFile;
    /** @export { !bigint } */
    this.byteStatsPrivateDirtyResident;
    /** @export { !bigint } */
    this.byteStatsPrivateCleanResident;
    /** @export { !bigint } */
    this.byteStatsSharedDirtyResident;
    /** @export { !bigint } */
    this.byteStatsSharedCleanResident;
    /** @export { !bigint } */
    this.byteStatsSwapped;
    /** @export { !bigint } */
    this.byteLocked;
    /** @export { !bigint } */
    this.byteStatsProportionalResident;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.PlatformPrivateFootprintSpec.$,
    'PlatformPrivateFootprint',
    [
      mojo.internal.StructField(
        'physFootprintBytes', 0,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'internalBytes', 8,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'compressedBytes', 16,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rssAnonBytes', 24,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'vmSwapBytes', 32,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'privateBytes', 40,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
memoryInstrumentation.mojom.PlatformPrivateFootprint = class {
  constructor() {
    /** @export { !bigint } */
    this.physFootprintBytes;
    /** @export { !bigint } */
    this.internalBytes;
    /** @export { !bigint } */
    this.compressedBytes;
    /** @export { !bigint } */
    this.rssAnonBytes;
    /** @export { !bigint } */
    this.vmSwapBytes;
    /** @export { !bigint } */
    this.privateBytes;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.RawOSMemDumpSpec.$,
    'RawOSMemDump',
    [
      mojo.internal.StructField(
        'residentSetKb', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'peakResidentSetKb', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isPeakRssResettable', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'platformPrivateFootprint', 16,
        0,
        memoryInstrumentation.mojom.PlatformPrivateFootprintSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'memoryMaps', 24,
        0,
        mojo.internal.Array(memoryInstrumentation.mojom.VmRegionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nativeLibraryPagesBitmap', 32,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mappingsCount', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pssKb', 40,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'swapPssKb', 44,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
memoryInstrumentation.mojom.RawOSMemDump = class {
  constructor() {
    /** @export { !number } */
    this.residentSetKb;
    /** @export { !number } */
    this.peakResidentSetKb;
    /** @export { !boolean } */
    this.isPeakRssResettable;
    /** @export { !memoryInstrumentation.mojom.PlatformPrivateFootprint } */
    this.platformPrivateFootprint;
    /** @export { !Array<!memoryInstrumentation.mojom.VmRegion> } */
    this.memoryMaps;
    /** @export { !Array<!number> } */
    this.nativeLibraryPagesBitmap;
    /** @export { !number } */
    this.mappingsCount;
    /** @export { !number } */
    this.pssKb;
    /** @export { !number } */
    this.swapPssKb;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.OSMemDumpSpec.$,
    'OSMemDump',
    [
      mojo.internal.StructField(
        'residentSetKb', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'peakResidentSetKb', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isPeakRssResettable', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'privateFootprintKb', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sharedFootprintKb', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'privateFootprintSwapKb', 20,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mappingsCount', 24,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pssKb', 28,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'swapPssKb', 32,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
memoryInstrumentation.mojom.OSMemDump = class {
  constructor() {
    /** @export { !number } */
    this.residentSetKb;
    /** @export { !number } */
    this.peakResidentSetKb;
    /** @export { !boolean } */
    this.isPeakRssResettable;
    /** @export { !number } */
    this.privateFootprintKb;
    /** @export { !number } */
    this.sharedFootprintKb;
    /** @export { !number } */
    this.privateFootprintSwapKb;
    /** @export { !number } */
    this.mappingsCount;
    /** @export { !number } */
    this.pssKb;
    /** @export { !number } */
    this.swapPssKb;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.AllocatorMemDumpSpec.$,
    'AllocatorMemDump',
    [
      mojo.internal.StructField(
        'numericEntries', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Uint64, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'children', 8,
        0,
        mojo.internal.Map(mojo.internal.String, memoryInstrumentation.mojom.AllocatorMemDumpSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
memoryInstrumentation.mojom.AllocatorMemDump = class {
  constructor() {
    /** @export { !Object<!string, !bigint> } */
    this.numericEntries;
    /** @export { !Object<!string, !memoryInstrumentation.mojom.AllocatorMemDump> } */
    this.children;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.ProcessMemoryDumpSpec.$,
    'ProcessMemoryDump',
    [
      mojo.internal.StructField(
        'processType', 0,
        0,
        memoryInstrumentation.mojom.ProcessTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'osDump', 8,
        0,
        memoryInstrumentation.mojom.OSMemDumpSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'chromeAllocatorDumps', 16,
        0,
        mojo.internal.Map(mojo.internal.String, memoryInstrumentation.mojom.AllocatorMemDumpSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pid', 24,
        0,
        mojoBase.mojom.ProcessIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceName', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
memoryInstrumentation.mojom.ProcessMemoryDump = class {
  constructor() {
    /** @export { !memoryInstrumentation.mojom.ProcessType } */
    this.processType;
    /** @export { !memoryInstrumentation.mojom.OSMemDump } */
    this.osDump;
    /** @export { !Object<!string, !memoryInstrumentation.mojom.AllocatorMemDump> } */
    this.chromeAllocatorDumps;
    /** @export { !mojoBase.mojom.ProcessId } */
    this.pid;
    /** @export { (string|undefined) } */
    this.serviceName;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.AggregatedMetricsSpec.$,
    'AggregatedMetrics',
    [
      mojo.internal.StructField(
        'nativeLibraryResidentKb', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nativeLibraryResidentNotOrderedKb', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nativeLibraryNotResidentOrderedKb', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
memoryInstrumentation.mojom.AggregatedMetrics = class {
  constructor() {
    /** @export { !number } */
    this.nativeLibraryResidentKb;
    /** @export { !number } */
    this.nativeLibraryResidentNotOrderedKb;
    /** @export { !number } */
    this.nativeLibraryNotResidentOrderedKb;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.GlobalMemoryDumpSpec.$,
    'GlobalMemoryDump',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'processDumps', 8,
        0,
        mojo.internal.Array(memoryInstrumentation.mojom.ProcessMemoryDumpSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'aggregatedMetrics', 16,
        0,
        memoryInstrumentation.mojom.AggregatedMetricsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
memoryInstrumentation.mojom.GlobalMemoryDump = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.startTime;
    /** @export { !Array<!memoryInstrumentation.mojom.ProcessMemoryDump> } */
    this.processDumps;
    /** @export { !memoryInstrumentation.mojom.AggregatedMetrics } */
    this.aggregatedMetrics;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.HeapProfileResultSpec.$,
    'HeapProfileResult',
    [
      mojo.internal.StructField(
        'pid', 0,
        0,
        mojoBase.mojom.ProcessIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'json', 8,
        0,
        mojoBase.mojom.BigStringSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
memoryInstrumentation.mojom.HeapProfileResult = class {
  constructor() {
    /** @export { !mojoBase.mojom.ProcessId } */
    this.pid;
    /** @export { !mojoBase.mojom.BigString } */
    this.json;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.ClientProcess_RequestChromeMemoryDump_ParamsSpec.$,
    'ClientProcess_RequestChromeMemoryDump_Params',
    [
      mojo.internal.StructField(
        'args', 0,
        0,
        memoryInstrumentation.mojom.RequestArgsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
memoryInstrumentation.mojom.ClientProcess_RequestChromeMemoryDump_Params = class {
  constructor() {
    /** @export { !memoryInstrumentation.mojom.RequestArgs } */
    this.args;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.ClientProcess_RequestChromeMemoryDump_ResponseParamsSpec.$,
    'ClientProcess_RequestChromeMemoryDump_ResponseParams',
    [
      mojo.internal.StructField(
        'outcome', 0,
        0,
        memoryInstrumentation.mojom.RequestOutcomeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dumpId', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rawProcessMemoryDump', 16,
        0,
        memoryInstrumentation.mojom.RawProcessMemoryDumpSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
memoryInstrumentation.mojom.ClientProcess_RequestChromeMemoryDump_ResponseParams = class {
  constructor() {
    /** @export { !memoryInstrumentation.mojom.RequestOutcome } */
    this.outcome;
    /** @export { !bigint } */
    this.dumpId;
    /** @export { (memoryInstrumentation.mojom.RawProcessMemoryDump|undefined) } */
    this.rawProcessMemoryDump;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.ClientProcess_RequestOSMemoryDump_ParamsSpec.$,
    'ClientProcess_RequestOSMemoryDump_Params',
    [
      mojo.internal.StructField(
        'option', 0,
        0,
        memoryInstrumentation.mojom.MemoryMapOptionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'flags', 8,
        0,
        mojo.internal.Array(memoryInstrumentation.mojom.MemDumpFlagsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pids', 16,
        0,
        mojo.internal.Array(mojoBase.mojom.ProcessIdSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
memoryInstrumentation.mojom.ClientProcess_RequestOSMemoryDump_Params = class {
  constructor() {
    /** @export { !memoryInstrumentation.mojom.MemoryMapOption } */
    this.option;
    /** @export { !Array<!memoryInstrumentation.mojom.MemDumpFlags> } */
    this.flags;
    /** @export { !Array<!mojoBase.mojom.ProcessId> } */
    this.pids;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.ClientProcess_RequestOSMemoryDump_ResponseParamsSpec.$,
    'ClientProcess_RequestOSMemoryDump_ResponseParams',
    [
      mojo.internal.StructField(
        'outcome', 0,
        0,
        memoryInstrumentation.mojom.RequestOutcomeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dumps', 8,
        0,
        mojo.internal.Map(mojoBase.mojom.ProcessIdSpec.$, memoryInstrumentation.mojom.RawOSMemDumpSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
memoryInstrumentation.mojom.ClientProcess_RequestOSMemoryDump_ResponseParams = class {
  constructor() {
    /** @export { !memoryInstrumentation.mojom.RequestOutcome } */
    this.outcome;
    /** @export { !Map<!mojoBase.mojom.ProcessId, !memoryInstrumentation.mojom.RawOSMemDump> } */
    this.dumps;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.HeapProfiler_DumpProcessesForTracing_ParamsSpec.$,
    'HeapProfiler_DumpProcessesForTracing_Params',
    [
      mojo.internal.StructField(
        'stripPathFromMappedFiles', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'writeProto', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
memoryInstrumentation.mojom.HeapProfiler_DumpProcessesForTracing_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.stripPathFromMappedFiles;
    /** @export { !boolean } */
    this.writeProto;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.HeapProfiler_DumpProcessesForTracing_ResponseParamsSpec.$,
    'HeapProfiler_DumpProcessesForTracing_ResponseParams',
    [
      mojo.internal.StructField(
        'results', 0,
        0,
        mojo.internal.Array(memoryInstrumentation.mojom.HeapProfileResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
memoryInstrumentation.mojom.HeapProfiler_DumpProcessesForTracing_ResponseParams = class {
  constructor() {
    /** @export { !Array<!memoryInstrumentation.mojom.HeapProfileResult> } */
    this.results;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.HeapProfilerHelper_GetVmRegionsForHeapProfiler_ParamsSpec.$,
    'HeapProfilerHelper_GetVmRegionsForHeapProfiler_Params',
    [
      mojo.internal.StructField(
        'pids', 0,
        0,
        mojo.internal.Array(mojoBase.mojom.ProcessIdSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
memoryInstrumentation.mojom.HeapProfilerHelper_GetVmRegionsForHeapProfiler_Params = class {
  constructor() {
    /** @export { !Array<!mojoBase.mojom.ProcessId> } */
    this.pids;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParamsSpec.$,
    'HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParams',
    [
      mojo.internal.StructField(
        'vmRegions', 0,
        0,
        mojo.internal.Map(mojoBase.mojom.ProcessIdSpec.$, mojo.internal.Array(memoryInstrumentation.mojom.VmRegionSpec.$, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
memoryInstrumentation.mojom.HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParams = class {
  constructor() {
    /** @export { !Map<!mojoBase.mojom.ProcessId, !Array<!memoryInstrumentation.mojom.VmRegion>> } */
    this.vmRegions;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDump_ParamsSpec.$,
    'Coordinator_RequestGlobalMemoryDump_Params',
    [
      mojo.internal.StructField(
        'dumpType', 0,
        0,
        memoryInstrumentation.mojom.DumpTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'levelOfDetail', 4,
        0,
        memoryInstrumentation.mojom.LevelOfDetailSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'determinism', 8,
        0,
        memoryInstrumentation.mojom.DeterminismSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allocatorDumpNames', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDump_Params = class {
  constructor() {
    /** @export { !memoryInstrumentation.mojom.DumpType } */
    this.dumpType;
    /** @export { !memoryInstrumentation.mojom.LevelOfDetail } */
    this.levelOfDetail;
    /** @export { !memoryInstrumentation.mojom.Determinism } */
    this.determinism;
    /** @export { !Array<!string> } */
    this.allocatorDumpNames;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDump_ResponseParamsSpec.$,
    'Coordinator_RequestGlobalMemoryDump_ResponseParams',
    [
      mojo.internal.StructField(
        'outcome', 0,
        0,
        memoryInstrumentation.mojom.RequestOutcomeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'globalMemoryDump', 8,
        0,
        memoryInstrumentation.mojom.GlobalMemoryDumpSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDump_ResponseParams = class {
  constructor() {
    /** @export { !memoryInstrumentation.mojom.RequestOutcome } */
    this.outcome;
    /** @export { (memoryInstrumentation.mojom.GlobalMemoryDump|undefined) } */
    this.globalMemoryDump;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpForPid_ParamsSpec.$,
    'Coordinator_RequestGlobalMemoryDumpForPid_Params',
    [
      mojo.internal.StructField(
        'pid', 0,
        0,
        mojoBase.mojom.ProcessIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allocatorDumpNames', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpForPid_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ProcessId } */
    this.pid;
    /** @export { !Array<!string> } */
    this.allocatorDumpNames;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpForPid_ResponseParamsSpec.$,
    'Coordinator_RequestGlobalMemoryDumpForPid_ResponseParams',
    [
      mojo.internal.StructField(
        'outcome', 0,
        0,
        memoryInstrumentation.mojom.RequestOutcomeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'globalMemoryDump', 8,
        0,
        memoryInstrumentation.mojom.GlobalMemoryDumpSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpForPid_ResponseParams = class {
  constructor() {
    /** @export { !memoryInstrumentation.mojom.RequestOutcome } */
    this.outcome;
    /** @export { (memoryInstrumentation.mojom.GlobalMemoryDump|undefined) } */
    this.globalMemoryDump;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.Coordinator_RequestPrivateMemoryFootprint_ParamsSpec.$,
    'Coordinator_RequestPrivateMemoryFootprint_Params',
    [
      mojo.internal.StructField(
        'pid', 0,
        0,
        mojoBase.mojom.ProcessIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
memoryInstrumentation.mojom.Coordinator_RequestPrivateMemoryFootprint_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ProcessId } */
    this.pid;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.Coordinator_RequestPrivateMemoryFootprint_ResponseParamsSpec.$,
    'Coordinator_RequestPrivateMemoryFootprint_ResponseParams',
    [
      mojo.internal.StructField(
        'outcome', 0,
        0,
        memoryInstrumentation.mojom.RequestOutcomeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'globalMemoryDump', 8,
        0,
        memoryInstrumentation.mojom.GlobalMemoryDumpSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
memoryInstrumentation.mojom.Coordinator_RequestPrivateMemoryFootprint_ResponseParams = class {
  constructor() {
    /** @export { !memoryInstrumentation.mojom.RequestOutcome } */
    this.outcome;
    /** @export { (memoryInstrumentation.mojom.GlobalMemoryDump|undefined) } */
    this.globalMemoryDump;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ParamsSpec.$,
    'Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_Params',
    [
      mojo.internal.StructField(
        'dumpType', 0,
        0,
        memoryInstrumentation.mojom.DumpTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'levelOfDetail', 4,
        0,
        memoryInstrumentation.mojom.LevelOfDetailSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'determinism', 8,
        0,
        memoryInstrumentation.mojom.DeterminismSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_Params = class {
  constructor() {
    /** @export { !memoryInstrumentation.mojom.DumpType } */
    this.dumpType;
    /** @export { !memoryInstrumentation.mojom.LevelOfDetail } */
    this.levelOfDetail;
    /** @export { !memoryInstrumentation.mojom.Determinism } */
    this.determinism;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParamsSpec.$,
    'Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParams',
    [
      mojo.internal.StructField(
        'outcome', 0,
        0,
        memoryInstrumentation.mojom.RequestOutcomeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dumpId', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
memoryInstrumentation.mojom.Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParams = class {
  constructor() {
    /** @export { !memoryInstrumentation.mojom.RequestOutcome } */
    this.outcome;
    /** @export { !bigint } */
    this.dumpId;
  }
};



mojo.internal.Struct(
    memoryInstrumentation.mojom.CoordinatorConnector_RegisterCoordinatorClient_ParamsSpec.$,
    'CoordinatorConnector_RegisterCoordinatorClient_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(memoryInstrumentation.mojom.CoordinatorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientProcess', 4,
        0,
        mojo.internal.InterfaceProxy(memoryInstrumentation.mojom.ClientProcessRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
memoryInstrumentation.mojom.CoordinatorConnector_RegisterCoordinatorClient_Params = class {
  constructor() {
    /** @export { !memoryInstrumentation.mojom.CoordinatorPendingReceiver } */
    this.receiver;
    /** @export { !memoryInstrumentation.mojom.ClientProcessRemote } */
    this.clientProcess;
  }
};



mojo.internal.Union(
    memoryInstrumentation.mojom.RawAllocatorDumpEntryValueSpec.$, 'RawAllocatorDumpEntryValue',
    {
      'valueUint64': {
        'ordinal': 0,
        'type': mojo.internal.Uint64,
      },
      'valueString': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   valueUint64: (!bigint|undefined),
 *   valueString: (!string|undefined),
 * } }
 */
memoryInstrumentation.mojom.RawAllocatorDumpEntryValue;
