// services/service_manager/public/mojom/service_filter.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/service_manager/public/mojom/service_filter.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('serviceManager.mojom');
  var token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/token.mojom', '../../../../mojo/public/mojom/base/token.mojom.js');
  }



  function ServiceFilter(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceFilter.prototype.initDefaults_ = function() {
    this.serviceName = null;
    this.instanceGroup = null;
    this.instanceId = null;
    this.globallyUniqueId = null;
  };
  ServiceFilter.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceFilter.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceFilter.serviceName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceFilter.instanceGroup
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, token$.Token, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceFilter.instanceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, token$.Token, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceFilter.globallyUniqueId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, token$.Token, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceFilter.encodedSize = codec.kStructHeaderSize + 32;

  ServiceFilter.decode = function(decoder) {
    var packed;
    var val = new ServiceFilter();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.serviceName =
        decoder.decodeStruct(codec.String);
    val.instanceGroup =
        decoder.decodeStructPointer(token$.Token);
    val.instanceId =
        decoder.decodeStructPointer(token$.Token);
    val.globallyUniqueId =
        decoder.decodeStructPointer(token$.Token);
    return val;
  };

  ServiceFilter.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceFilter.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.serviceName);
    encoder.encodeStructPointer(token$.Token, val.instanceGroup);
    encoder.encodeStructPointer(token$.Token, val.instanceId);
    encoder.encodeStructPointer(token$.Token, val.globallyUniqueId);
  };
  exports.ServiceFilter = ServiceFilter;
})();